/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.util.DateRule;
import android.icu.util.GregorianCalendar;
import java.util.Date;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EasterRule
implements DateRule,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static GregorianCalendar gregorian;
    private static GregorianCalendar orthodox;
    private int daysAfterEaster;
    private GregorianCalendar calendar;

    private void $$robo$$android_icu_util_EasterRule$__constructor__(int daysAfterEaster, boolean isOrthodox) {
        this.calendar = gregorian;
        this.daysAfterEaster = daysAfterEaster;
        if (isOrthodox) {
            orthodox.setGregorianChange(new Date(Long.MAX_VALUE));
            this.calendar = orthodox;
        }
    }

    private final Date $$robo$$android_icu_util_EasterRule$firstAfter(Date start) {
        return this.doFirstBetween(start, null);
    }

    private final Date $$robo$$android_icu_util_EasterRule$firstBetween(Date start, Date end) {
        return this.doFirstBetween(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_icu_util_EasterRule$isOn(Date date) {
        GregorianCalendar gregorianCalendar = this.calendar;
        synchronized (gregorianCalendar) {
            this.calendar.setTime(date);
            int dayOfYear = this.calendar.get(6);
            this.calendar.setTime(this.computeInYear(this.calendar.getTime(), this.calendar));
            return this.calendar.get(6) == dayOfYear;
        }
    }

    private final boolean $$robo$$android_icu_util_EasterRule$isBetween(Date start, Date end) {
        return this.firstBetween(start, end) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Date $$robo$$android_icu_util_EasterRule$doFirstBetween(Date start, Date end) {
        GregorianCalendar gregorianCalendar = this.calendar;
        synchronized (gregorianCalendar) {
            Date result = this.computeInYear(start, this.calendar);
            if (result.before(start)) {
                this.calendar.setTime(start);
                this.calendar.get(1);
                this.calendar.add(1, 1);
                result = this.computeInYear(this.calendar.getTime(), this.calendar);
            }
            if (end != null && !result.before(end)) {
                return null;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Date $$robo$$android_icu_util_EasterRule$computeInYear(Date date, GregorianCalendar cal) {
        if (cal == null) {
            cal = this.calendar;
        }
        GregorianCalendar gregorianCalendar = cal;
        synchronized (gregorianCalendar) {
            cal.setTime(date);
            int year = cal.get(1);
            int g = year % 19;
            int i = 0;
            int j = 0;
            if (cal.getTime().after(cal.getGregorianChange())) {
                int c = year / 100;
                int h = (c - c / 4 - (8 * c + 13) / 25 + 19 * g + 15) % 30;
                i = h - h / 28 * (1 - h / 28 * (29 / (h + 1)) * ((21 - g) / 11));
                j = (year + year / 4 + i + 2 - c + c / 4) % 7;
            } else {
                i = (19 * g + 15) % 30;
                j = (year + year / 4 + i) % 7;
            }
            int l = i - j;
            int m = 3 + (l + 40) / 44;
            int d = l + 28 - 31 * (m / 4);
            cal.clear();
            cal.set(0, 1);
            cal.set(1, year);
            cal.set(2, m - 1);
            cal.set(5, d);
            cal.getTime();
            cal.add(5, this.daysAfterEaster);
            return cal.getTime();
        }
    }

    static void __staticInitializer__() {
        gregorian = new GregorianCalendar();
        orthodox = new GregorianCalendar();
    }

    private void __constructor__(int n, boolean bl) {
        this.$$robo$$android_icu_util_EasterRule$__constructor__(n, bl);
    }

    public EasterRule(int n, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_EasterRule$__constructor__(int boolean ), this, n, bl);
    }

    @Override
    public Date firstAfter(Date date) {
        return InvokeDynamicSupport.bootstrap("firstAfter", $$robo$$android_icu_util_EasterRule$firstAfter(java.util.Date ), this, date);
    }

    @Override
    public Date firstBetween(Date date, Date date2) {
        return InvokeDynamicSupport.bootstrap("firstBetween", $$robo$$android_icu_util_EasterRule$firstBetween(java.util.Date java.util.Date ), this, date, date2);
    }

    @Override
    public boolean isOn(Date date) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOn", $$robo$$android_icu_util_EasterRule$isOn(java.util.Date ), this, date);
    }

    @Override
    public boolean isBetween(Date date, Date date2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isBetween", $$robo$$android_icu_util_EasterRule$isBetween(java.util.Date java.util.Date ), this, date, date2);
    }

    private Date doFirstBetween(Date date, Date date2) {
        return InvokeDynamicSupport.bootstrap("doFirstBetween", $$robo$$android_icu_util_EasterRule$doFirstBetween(java.util.Date java.util.Date ), this, date, date2);
    }

    private Date computeInYear(Date date, GregorianCalendar gregorianCalendar) {
        return InvokeDynamicSupport.bootstrap("computeInYear", $$robo$$android_icu_util_EasterRule$computeInYear(java.util.Date android.icu.util.GregorianCalendar ), this, date, gregorianCalendar);
    }

    static {
        RobolectricInternals.classInitializing(EasterRule.class);
    }

    public /* synthetic */ EasterRule() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EasterRule)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

