/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.CharacterIteration;
import android.icu.impl.ICUBinary;
import android.icu.impl.ICUDebug;
import android.icu.impl.Trie2;
import android.icu.lang.UCharacter;
import android.icu.text.BreakIterator;
import android.icu.text.BurmeseBreakEngine;
import android.icu.text.CjkBreakEngine;
import android.icu.text.DictionaryBreakEngine;
import android.icu.text.KhmerBreakEngine;
import android.icu.text.LanguageBreakEngine;
import android.icu.text.LaoBreakEngine;
import android.icu.text.RBBIDataWrapper;
import android.icu.text.RBBIRuleBuilder;
import android.icu.text.ThaiBreakEngine;
import android.icu.text.UnhandledBreakEngine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RuleBasedBreakIterator
extends BreakIterator
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int START_STATE = 1;
    private static int STOP_STATE = 0;
    private static int RBBI_START = 0;
    private static int RBBI_RUN = 1;
    private static int RBBI_END = 2;
    private CharacterIterator fText;
    RBBIDataWrapper fRData;
    private int fPosition;
    private int fRuleStatusIndex;
    private boolean fDone;
    private BreakCache fBreakCache;
    private int fDictionaryCharCount;
    private DictionaryCache fDictionaryCache;
    private static String RBBI_DEBUG_ARG = "rbbi";
    private static boolean TRACE;
    private int fBreakType;
    private static UnhandledBreakEngine gUnhandledBreakEngine;
    private static List<LanguageBreakEngine> gAllBreakEngines;
    private List<LanguageBreakEngine> fBreakEngines;
    static String fDebugEnv;
    private static int kMaxLookaheads = 8;
    private LookAheadResults fLookAheadMatches;
    static /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_icu_text_RuleBasedBreakIterator$__constructor__() {
        this.fText = new StringCharacterIterator("");
        this.fBreakCache = new BreakCache(this);
        this.fDictionaryCache = new DictionaryCache(this);
        this.fBreakType = 1;
        this.fLookAheadMatches = new LookAheadResults();
        this.fDictionaryCharCount = 0;
        List<LanguageBreakEngine> list = gAllBreakEngines;
        synchronized (list) {
            this.fBreakEngines = new ArrayList<LanguageBreakEngine>(gAllBreakEngines);
        }
    }

    private static final RuleBasedBreakIterator $$robo$$android_icu_text_RuleBasedBreakIterator$getInstanceFromCompiledRules(InputStream is) throws IOException {
        RuleBasedBreakIterator This = new RuleBasedBreakIterator();
        This.fRData = RBBIDataWrapper.get(ICUBinary.getByteBufferFromInputStreamAndCloseStream(is));
        return This;
    }

    @Deprecated
    private static final RuleBasedBreakIterator $$robo$$android_icu_text_RuleBasedBreakIterator$getInstanceFromCompiledRules(ByteBuffer bytes) throws IOException {
        RuleBasedBreakIterator This = new RuleBasedBreakIterator();
        This.fRData = RBBIDataWrapper.get(bytes);
        return This;
    }

    private void $$robo$$android_icu_text_RuleBasedBreakIterator$__constructor__(String rules) {
        try {
            ByteArrayOutputStream ruleOS = new ByteArrayOutputStream();
            RuleBasedBreakIterator.compileRules(rules, ruleOS);
            this.fRData = RBBIDataWrapper.get(ByteBuffer.wrap(ruleOS.toByteArray()));
        }
        catch (IOException e) {
            RuntimeException rte = new RuntimeException("RuleBasedBreakIterator rule compilation internal error: " + e.getMessage());
            throw rte;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object $$robo$$android_icu_text_RuleBasedBreakIterator$clone() {
        RuleBasedBreakIterator result = (RuleBasedBreakIterator)super.clone();
        if (this.fText != null) {
            result.fText = (CharacterIterator)this.fText.clone();
        }
        List<LanguageBreakEngine> list = gAllBreakEngines;
        synchronized (list) {
            result.fBreakEngines = new ArrayList<LanguageBreakEngine>(gAllBreakEngines);
        }
        result.fLookAheadMatches = new LookAheadResults();
        RuleBasedBreakIterator ruleBasedBreakIterator = result;
        Objects.requireNonNull(ruleBasedBreakIterator);
        result.fBreakCache = new BreakCache(ruleBasedBreakIterator, this.fBreakCache);
        RuleBasedBreakIterator ruleBasedBreakIterator2 = result;
        Objects.requireNonNull(ruleBasedBreakIterator2);
        result.fDictionaryCache = new DictionaryCache(ruleBasedBreakIterator2, this.fDictionaryCache);
        return result;
    }

    private final boolean $$robo$$android_icu_text_RuleBasedBreakIterator$equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        try {
            RuleBasedBreakIterator other = (RuleBasedBreakIterator)that;
            if (this.fRData != other.fRData && (this.fRData == null || other.fRData == null)) {
                return false;
            }
            if (this.fRData != null && other.fRData != null && !this.fRData.fRuleSource.equals(other.fRData.fRuleSource)) {
                return false;
            }
            if (this.fText == null && other.fText == null) {
                return true;
            }
            if (this.fText == null || other.fText == null || !this.fText.equals(other.fText)) {
                return false;
            }
            return this.fPosition == other.fPosition;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private final String $$robo$$android_icu_text_RuleBasedBreakIterator$toString() {
        String retStr = "";
        if (this.fRData != null) {
            retStr = this.fRData.fRuleSource;
        }
        return retStr;
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$hashCode() {
        return this.fRData.fRuleSource.hashCode();
    }

    @Deprecated
    private final void $$robo$$android_icu_text_RuleBasedBreakIterator$dump(PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        this.fRData.dump(out);
    }

    private static final void $$robo$$android_icu_text_RuleBasedBreakIterator$compileRules(String rules, OutputStream ruleBinary) throws IOException {
        RBBIRuleBuilder.compileRules(rules, ruleBinary);
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$first() {
        if (this.fText == null) {
            return -1;
        }
        this.fText.first();
        int start = this.fText.getIndex();
        if (!this.fBreakCache.seek(start)) {
            this.fBreakCache.populateNear(start);
        }
        this.fBreakCache.current();
        if (!$assertionsDisabled && this.fPosition != start) {
            throw new AssertionError();
        }
        return this.fPosition;
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$last() {
        if (this.fText == null) {
            return -1;
        }
        int endPos = this.fText.getEndIndex();
        boolean endShouldBeBoundary = this.isBoundary(endPos);
        if (!$assertionsDisabled && !endShouldBeBoundary) {
            throw new AssertionError();
        }
        if (this.fPosition != endPos && !$assertionsDisabled && this.fPosition != endPos) {
            throw new AssertionError();
        }
        return endPos;
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$next(int n) {
        int result = 0;
        if (n > 0) {
            while (n > 0 && result != -1) {
                result = this.next();
                --n;
            }
        } else if (n < 0) {
            while (n < 0 && result != -1) {
                result = this.previous();
                ++n;
            }
        } else {
            result = this.current();
        }
        return result;
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$next() {
        this.fBreakCache.next();
        return this.fDone ? -1 : this.fPosition;
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$previous() {
        this.fBreakCache.previous();
        return this.fDone ? -1 : this.fPosition;
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$following(int startPos) {
        if (startPos < this.fText.getBeginIndex()) {
            return this.first();
        }
        startPos = RuleBasedBreakIterator.CISetIndex32(this.fText, startPos);
        this.fBreakCache.following(startPos);
        return this.fDone ? -1 : this.fPosition;
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$preceding(int offset) {
        if (this.fText == null || offset > this.fText.getEndIndex()) {
            return this.last();
        }
        if (offset < this.fText.getBeginIndex()) {
            return this.first();
        }
        int adjustedOffset = offset;
        this.fBreakCache.preceding(adjustedOffset);
        return this.fDone ? -1 : this.fPosition;
    }

    private static final void $$robo$$android_icu_text_RuleBasedBreakIterator$checkOffset(int offset, CharacterIterator text) {
        if (offset < text.getBeginIndex() || offset > text.getEndIndex()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
    }

    private final boolean $$robo$$android_icu_text_RuleBasedBreakIterator$isBoundary(int offset) {
        RuleBasedBreakIterator.checkOffset(offset, this.fText);
        int adjustedOffset = RuleBasedBreakIterator.CISetIndex32(this.fText, offset);
        boolean result = false;
        if (this.fBreakCache.seek(adjustedOffset) || this.fBreakCache.populateNear(adjustedOffset)) {
            boolean bl = result = this.fBreakCache.current() == offset;
        }
        if (!result) {
            this.next();
        }
        return result;
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$current() {
        return this.fText != null ? this.fPosition : -1;
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$getRuleStatus() {
        int idx = this.fRuleStatusIndex + this.fRData.fStatusTable[this.fRuleStatusIndex];
        int tagVal = this.fRData.fStatusTable[idx];
        return tagVal;
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$getRuleStatusVec(int[] fillInArray) {
        int numStatusVals = this.fRData.fStatusTable[this.fRuleStatusIndex];
        if (fillInArray != null) {
            int numToCopy = Math.min(numStatusVals, fillInArray.length);
            for (int i = 0; i < numToCopy; ++i) {
                fillInArray[i] = this.fRData.fStatusTable[this.fRuleStatusIndex + i + 1];
            }
        }
        return numStatusVals;
    }

    private final CharacterIterator $$robo$$android_icu_text_RuleBasedBreakIterator$getText() {
        return this.fText;
    }

    private final void $$robo$$android_icu_text_RuleBasedBreakIterator$setText(CharacterIterator newText) {
        if (newText != null) {
            this.fBreakCache.reset(newText.getBeginIndex(), 0);
        } else {
            this.fBreakCache.reset();
        }
        this.fDictionaryCache.reset();
        this.fText = newText;
        this.first();
    }

    private final void $$robo$$android_icu_text_RuleBasedBreakIterator$setBreakType(int type) {
        this.fBreakType = type;
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$getBreakType() {
        return this.fBreakType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LanguageBreakEngine $$robo$$android_icu_text_RuleBasedBreakIterator$getLanguageBreakEngine(int c) {
        for (LanguageBreakEngine languageBreakEngine : this.fBreakEngines) {
            if (!languageBreakEngine.handles(c, this.fBreakType)) continue;
            return languageBreakEngine;
        }
        List<LanguageBreakEngine> list = gAllBreakEngines;
        synchronized (list) {
            LanguageBreakEngine eng;
            int n;
            for (LanguageBreakEngine candidate : gAllBreakEngines) {
                if (!candidate.handles(c, this.fBreakType)) continue;
                this.fBreakEngines.add(candidate);
                return candidate;
            }
            int n2 = UCharacter.getIntPropertyValue(c, 4106);
            if (n2 == 22 || n2 == 20) {
                n = 17;
            }
            try {
                switch (n) {
                    case 38: {
                        eng = new ThaiBreakEngine();
                        break;
                    }
                    case 24: {
                        eng = new LaoBreakEngine();
                        break;
                    }
                    case 28: {
                        eng = new BurmeseBreakEngine();
                        break;
                    }
                    case 23: {
                        eng = new KhmerBreakEngine();
                        break;
                    }
                    case 17: {
                        if (this.getBreakType() == 1) {
                            eng = new CjkBreakEngine(false);
                            break;
                        }
                        gUnhandledBreakEngine.handleChar(c, this.getBreakType());
                        eng = gUnhandledBreakEngine;
                        break;
                    }
                    case 18: {
                        if (this.getBreakType() == 1) {
                            eng = new CjkBreakEngine(true);
                            break;
                        }
                        gUnhandledBreakEngine.handleChar(c, this.getBreakType());
                        eng = gUnhandledBreakEngine;
                        break;
                    }
                    default: {
                        gUnhandledBreakEngine.handleChar(c, this.getBreakType());
                        eng = gUnhandledBreakEngine;
                        break;
                    }
                }
            }
            catch (IOException e) {
                eng = null;
            }
            if (eng != null && eng != gUnhandledBreakEngine) {
                gAllBreakEngines.add(eng);
                this.fBreakEngines.add(eng);
            }
            return eng;
        }
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$handleNext() {
        if (TRACE) {
            System.out.println("Handle Next   pos      char  state category");
        }
        this.fRuleStatusIndex = 0;
        this.fDictionaryCharCount = 0;
        CharacterIterator text = this.fText;
        Trie2 trie = this.fRData.fTrie;
        short[] stateTable = this.fRData.fFTable;
        int initialPosition = this.fPosition;
        text.setIndex(initialPosition);
        int result = initialPosition;
        int c = text.current();
        if (c >= 55296 && (c = CharacterIteration.nextTrail32(text, c)) == Integer.MAX_VALUE) {
            this.fDone = true;
            return -1;
        }
        int state = 1;
        int row = this.fRData.getRowIndex(state);
        int category = 3;
        int flagsState = this.fRData.getStateTableFlags(stateTable);
        int mode = 1;
        if ((flagsState & 2) != 0) {
            category = 2;
            mode = 0;
            if (TRACE) {
                System.out.print("            " + RBBIDataWrapper.intToString(text.getIndex(), 5));
                System.out.print(RBBIDataWrapper.intToHexString(c, 10));
                System.out.println(RBBIDataWrapper.intToString(state, 7) + RBBIDataWrapper.intToString(category, 6));
            }
        }
        this.fLookAheadMatches.reset();
        while (state != 0) {
            int lookaheadResult;
            short completedRule;
            if (c == Integer.MAX_VALUE) {
                if (mode == 2) break;
                mode = 2;
                category = 1;
            } else if (mode == 1) {
                category = (short)trie.get(c);
                if ((category & 0x4000) != 0) {
                    ++this.fDictionaryCharCount;
                    category = (short)(category & 0xFFFFBFFF);
                }
                if (TRACE) {
                    System.out.print("            " + RBBIDataWrapper.intToString(text.getIndex(), 5));
                    System.out.print(RBBIDataWrapper.intToHexString(c, 10));
                    System.out.println(RBBIDataWrapper.intToString(state, 7) + RBBIDataWrapper.intToString(category, 6));
                }
                if ((c = (int)text.next()) >= 55296) {
                    c = CharacterIteration.nextTrail32(text, c);
                }
            } else {
                mode = 1;
            }
            state = stateTable[row + 4 + category];
            row = this.fRData.getRowIndex(state);
            if (stateTable[row + 0] == -1) {
                result = text.getIndex();
                if (c >= 65536 && c <= 0x10FFFF) {
                    --result;
                }
                this.fRuleStatusIndex = stateTable[row + 2];
            }
            if ((completedRule = stateTable[row + 0]) > 0 && (lookaheadResult = this.fLookAheadMatches.getPosition(completedRule)) >= 0) {
                this.fRuleStatusIndex = stateTable[row + 2];
                this.fPosition = lookaheadResult;
                return lookaheadResult;
            }
            short rule = stateTable[row + 1];
            if (rule == 0) continue;
            int pos = text.getIndex();
            if (c >= 65536 && c <= 0x10FFFF) {
                --pos;
            }
            this.fLookAheadMatches.setPosition(rule, pos);
        }
        if (result == initialPosition) {
            if (TRACE) {
                System.out.println("Iterator did not move. Advancing by 1.");
            }
            text.setIndex(initialPosition);
            CharacterIteration.next32(text);
            result = text.getIndex();
            this.fRuleStatusIndex = 0;
        }
        this.fPosition = result;
        if (TRACE) {
            System.out.println("result = " + result);
        }
        return result;
    }

    private final int $$robo$$android_icu_text_RuleBasedBreakIterator$handlePrevious(int fromPosition) {
        if (this.fText == null) {
            return 0;
        }
        int category = 0;
        int result = 0;
        int initialPosition = fromPosition;
        this.fLookAheadMatches.reset();
        short[] stateTable = this.fRData.fSRTable;
        RuleBasedBreakIterator.CISetIndex32(this.fText, fromPosition);
        if (fromPosition == this.fText.getBeginIndex()) {
            return -1;
        }
        result = initialPosition;
        int c = CharacterIteration.previous32(this.fText);
        int state = 1;
        int row = this.fRData.getRowIndex(state);
        category = 3;
        int mode = 1;
        if ((this.fRData.getStateTableFlags(stateTable) & 2) != 0) {
            category = 2;
            mode = 0;
        }
        if (TRACE) {
            System.out.println("Handle Prev   pos   char  state category ");
        }
        while (true) {
            int lookaheadResult;
            short completedRule;
            if (c == Integer.MAX_VALUE) {
                if (mode == 2) break;
                mode = 2;
                category = 1;
            }
            if (mode == 1) {
                category = (short)this.fRData.fTrie.get(c);
                category &= 0xFFFFBFFF;
            }
            if (TRACE) {
                System.out.print("             " + this.fText.getIndex() + "   ");
                if (32 <= c && c < 127) {
                    System.out.print("  " + c + "  ");
                } else {
                    System.out.print(" " + Integer.toHexString(c) + " ");
                }
                System.out.println(" " + state + "  " + category + " ");
            }
            if (stateTable[(row = this.fRData.getRowIndex(state = stateTable[row + 4 + category])) + 0] == -1) {
                result = this.fText.getIndex();
            }
            if ((completedRule = stateTable[row + 0]) > 0 && (lookaheadResult = this.fLookAheadMatches.getPosition(completedRule)) >= 0) {
                result = lookaheadResult;
                break;
            }
            short rule = stateTable[row + 1];
            if (rule != 0) {
                int pos = this.fText.getIndex();
                this.fLookAheadMatches.setPosition(rule, pos);
            }
            if (state == 0) break;
            if (mode == 1) {
                c = CharacterIteration.previous32(this.fText);
                continue;
            }
            if (mode != 0) continue;
            mode = 1;
        }
        if (result == initialPosition) {
            RuleBasedBreakIterator.CISetIndex32(this.fText, initialPosition);
            CharacterIteration.previous32(this.fText);
            result = this.fText.getIndex();
        }
        if (TRACE) {
            System.out.println("Result = " + result);
        }
        return result;
    }

    private static final int $$robo$$android_icu_text_RuleBasedBreakIterator$CISetIndex32(CharacterIterator ci, int index) {
        if (index <= ci.getBeginIndex()) {
            ci.first();
        } else if (index >= ci.getEndIndex()) {
            ci.setIndex(ci.getEndIndex());
        } else if (Character.isLowSurrogate(ci.setIndex(index)) && !Character.isHighSurrogate(ci.previous())) {
            ci.next();
        }
        return ci.getIndex();
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !RuleBasedBreakIterator.class.desiredAssertionStatus();
        TRACE = ICUDebug.enabled("rbbi") && ICUDebug.value("rbbi").indexOf("trace") >= 0;
        gUnhandledBreakEngine = new UnhandledBreakEngine();
        gAllBreakEngines = new ArrayList<LanguageBreakEngine>();
        gAllBreakEngines.add(gUnhandledBreakEngine);
        fDebugEnv = ICUDebug.enabled("rbbi") ? ICUDebug.value("rbbi") : null;
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_RuleBasedBreakIterator$__constructor__();
    }

    public RuleBasedBreakIterator() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedBreakIterator$__constructor__(), this);
    }

    public static RuleBasedBreakIterator getInstanceFromCompiledRules(InputStream inputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("getInstanceFromCompiledRules", $$robo$$android_icu_text_RuleBasedBreakIterator$getInstanceFromCompiledRules(java.io.InputStream ), (InputStream)inputStream);
    }

    @Deprecated
    public static RuleBasedBreakIterator getInstanceFromCompiledRules(ByteBuffer byteBuffer) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("getInstanceFromCompiledRules", $$robo$$android_icu_text_RuleBasedBreakIterator$getInstanceFromCompiledRules(java.nio.ByteBuffer ), (ByteBuffer)byteBuffer);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_text_RuleBasedBreakIterator$__constructor__(string2);
    }

    public RuleBasedBreakIterator(String string2) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedBreakIterator$__constructor__(java.lang.String ), this, string2);
    }

    @Override
    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_RuleBasedBreakIterator$clone(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_RuleBasedBreakIterator$equals(java.lang.Object ), this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_RuleBasedBreakIterator$toString(), this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_RuleBasedBreakIterator$hashCode(), this);
    }

    @Deprecated
    public void dump(PrintStream printStream) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_icu_text_RuleBasedBreakIterator$dump(java.io.PrintStream ), this, printStream);
    }

    public static void compileRules(String string2, OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("compileRules", $$robo$$android_icu_text_RuleBasedBreakIterator$compileRules(java.lang.String java.io.OutputStream ), (String)string2, (OutputStream)outputStream);
    }

    @Override
    public int first() {
        return (int)InvokeDynamicSupport.bootstrap("first", $$robo$$android_icu_text_RuleBasedBreakIterator$first(), this);
    }

    @Override
    public int last() {
        return (int)InvokeDynamicSupport.bootstrap("last", $$robo$$android_icu_text_RuleBasedBreakIterator$last(), this);
    }

    @Override
    public int next(int n) {
        return (int)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_text_RuleBasedBreakIterator$next(int ), this, n);
    }

    @Override
    public int next() {
        return (int)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_text_RuleBasedBreakIterator$next(), this);
    }

    @Override
    public int previous() {
        return (int)InvokeDynamicSupport.bootstrap("previous", $$robo$$android_icu_text_RuleBasedBreakIterator$previous(), this);
    }

    @Override
    public int following(int n) {
        return (int)InvokeDynamicSupport.bootstrap("following", $$robo$$android_icu_text_RuleBasedBreakIterator$following(int ), this, n);
    }

    @Override
    public int preceding(int n) {
        return (int)InvokeDynamicSupport.bootstrap("preceding", $$robo$$android_icu_text_RuleBasedBreakIterator$preceding(int ), this, n);
    }

    protected static void checkOffset(int n, CharacterIterator characterIterator) {
        InvokeDynamicSupport.bootstrapStatic("checkOffset", $$robo$$android_icu_text_RuleBasedBreakIterator$checkOffset(int java.text.CharacterIterator ), (int)n, (CharacterIterator)characterIterator);
    }

    @Override
    public boolean isBoundary(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isBoundary", $$robo$$android_icu_text_RuleBasedBreakIterator$isBoundary(int ), this, n);
    }

    @Override
    public int current() {
        return (int)InvokeDynamicSupport.bootstrap("current", $$robo$$android_icu_text_RuleBasedBreakIterator$current(), this);
    }

    @Override
    public int getRuleStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getRuleStatus", $$robo$$android_icu_text_RuleBasedBreakIterator$getRuleStatus(), this);
    }

    @Override
    public int getRuleStatusVec(int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("getRuleStatusVec", $$robo$$android_icu_text_RuleBasedBreakIterator$getRuleStatusVec(int[] ), this, nArray);
    }

    @Override
    public CharacterIterator getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_icu_text_RuleBasedBreakIterator$getText(), this);
    }

    @Override
    public void setText(CharacterIterator characterIterator) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_RuleBasedBreakIterator$setText(java.text.CharacterIterator ), this, characterIterator);
    }

    void setBreakType(int n) {
        InvokeDynamicSupport.bootstrap("setBreakType", $$robo$$android_icu_text_RuleBasedBreakIterator$setBreakType(int ), this, n);
    }

    int getBreakType() {
        return (int)InvokeDynamicSupport.bootstrap("getBreakType", $$robo$$android_icu_text_RuleBasedBreakIterator$getBreakType(), this);
    }

    private LanguageBreakEngine getLanguageBreakEngine(int n) {
        return InvokeDynamicSupport.bootstrap("getLanguageBreakEngine", $$robo$$android_icu_text_RuleBasedBreakIterator$getLanguageBreakEngine(int ), this, n);
    }

    private int handleNext() {
        return (int)InvokeDynamicSupport.bootstrap("handleNext", $$robo$$android_icu_text_RuleBasedBreakIterator$handleNext(), this);
    }

    private int handlePrevious(int n) {
        return (int)InvokeDynamicSupport.bootstrap("handlePrevious", $$robo$$android_icu_text_RuleBasedBreakIterator$handlePrevious(int ), this, n);
    }

    private static int CISetIndex32(CharacterIterator characterIterator, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("CISetIndex32", $$robo$$android_icu_text_RuleBasedBreakIterator$CISetIndex32(java.text.CharacterIterator int ), (CharacterIterator)characterIterator, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(RuleBasedBreakIterator.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RuleBasedBreakIterator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class BreakCache
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        static boolean RetainCachePosition = false;
        static boolean UpdateCachePosition = true;
        static int CACHE_SIZE = 128;
        int fStartBufIdx;
        int fEndBufIdx;
        int fTextIdx;
        int fBufIdx;
        int[] fBoundaries;
        short[] fStatuses;
        DictionaryBreakEngine.DequeI fSideBuffer;
        static /* synthetic */ boolean $assertionsDisabled;
        /* synthetic */ RuleBasedBreakIterator this$0;

        private void $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$__constructor__(RuleBasedBreakIterator this$0) {
            this.this$0 = this$0;
            this.fBoundaries = new int[128];
            this.fStatuses = new short[128];
            this.fSideBuffer = new DictionaryBreakEngine.DequeI();
            this.reset();
        }

        private final void $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$reset(int pos, int ruleStatus) {
            this.fStartBufIdx = 0;
            this.fEndBufIdx = 0;
            this.fTextIdx = pos;
            this.fBufIdx = 0;
            this.fBoundaries[0] = pos;
            this.fStatuses[0] = (short)ruleStatus;
        }

        private final void $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$reset() {
            this.reset(0, 0);
        }

        private final void $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$next() {
            if (this.fBufIdx == this.fEndBufIdx) {
                this.this$0.fDone = !this.populateFollowing();
                this.this$0.fPosition = this.fTextIdx;
                this.this$0.fRuleStatusIndex = this.fStatuses[this.fBufIdx];
            } else {
                this.fBufIdx = this.modChunkSize(this.fBufIdx + 1);
                this.fTextIdx = this.this$0.fPosition = this.fBoundaries[this.fBufIdx];
                this.this$0.fRuleStatusIndex = this.fStatuses[this.fBufIdx];
            }
        }

        private final void $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$previous() {
            int initialBufIdx = this.fBufIdx;
            if (this.fBufIdx == this.fStartBufIdx) {
                this.populatePreceding();
            } else {
                this.fBufIdx = this.modChunkSize(this.fBufIdx - 1);
                this.fTextIdx = this.fBoundaries[this.fBufIdx];
            }
            this.this$0.fDone = this.fBufIdx == initialBufIdx;
            this.this$0.fPosition = this.fTextIdx;
            this.this$0.fRuleStatusIndex = this.fStatuses[this.fBufIdx];
        }

        private final void $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$following(int startPos) {
            if (startPos == this.fTextIdx || this.seek(startPos) || this.populateNear(startPos)) {
                this.this$0.fDone = false;
                this.next();
            }
        }

        private final void $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$preceding(int startPos) {
            if (startPos == this.fTextIdx || this.seek(startPos) || this.populateNear(startPos)) {
                if (startPos == this.fTextIdx) {
                    this.previous();
                } else {
                    if (!$assertionsDisabled && startPos <= this.fTextIdx) {
                        throw new AssertionError();
                    }
                    this.current();
                }
            }
        }

        private final int $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$current() {
            this.this$0.fPosition = this.fTextIdx;
            this.this$0.fRuleStatusIndex = this.fStatuses[this.fBufIdx];
            this.this$0.fDone = false;
            return this.fTextIdx;
        }

        private final boolean $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$populateNear(int position) {
            if (!$assertionsDisabled && position >= this.fBoundaries[this.fStartBufIdx] && position <= this.fBoundaries[this.fEndBufIdx]) {
                throw new AssertionError();
            }
            if (position < this.fBoundaries[this.fStartBufIdx] - 15 || position > this.fBoundaries[this.fEndBufIdx] + 15) {
                int aBoundary = this.this$0.fText.getBeginIndex();
                int ruleStatusIndex = 0;
                if (position > aBoundary + 20) {
                    int backupPos = this.this$0.handlePrevious(position);
                    this.this$0.fPosition = backupPos;
                    aBoundary = this.this$0.handleNext();
                    ruleStatusIndex = this.this$0.fRuleStatusIndex;
                }
                this.reset(aBoundary, ruleStatusIndex);
            }
            if (this.fBoundaries[this.fEndBufIdx] < position) {
                while (this.fBoundaries[this.fEndBufIdx] < position) {
                    if (this.populateFollowing()) continue;
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return false;
                }
                this.fBufIdx = this.fEndBufIdx;
                this.fTextIdx = this.fBoundaries[this.fBufIdx];
                while (this.fTextIdx > position) {
                    this.previous();
                }
                return true;
            }
            if (this.fBoundaries[this.fStartBufIdx] > position) {
                while (this.fBoundaries[this.fStartBufIdx] > position) {
                    this.populatePreceding();
                }
                this.fBufIdx = this.fStartBufIdx;
                this.fTextIdx = this.fBoundaries[this.fBufIdx];
                while (this.fTextIdx < position) {
                    this.next();
                }
                if (this.fTextIdx > position) {
                    this.previous();
                }
                return true;
            }
            if (!$assertionsDisabled && this.fTextIdx != position) {
                throw new AssertionError();
            }
            return true;
        }

        private final boolean $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$populateFollowing() {
            int fromPosition = this.fBoundaries[this.fEndBufIdx];
            short fromRuleStatusIdx = this.fStatuses[this.fEndBufIdx];
            int pos = 0;
            int ruleStatusIdx = 0;
            if (this.this$0.fDictionaryCache.following(fromPosition)) {
                this.addFollowing(((RuleBasedBreakIterator)this.this$0).fDictionaryCache.fBoundary, ((RuleBasedBreakIterator)this.this$0).fDictionaryCache.fStatusIndex, true);
                return true;
            }
            this.this$0.fPosition = fromPosition;
            pos = this.this$0.handleNext();
            if (pos == -1) {
                return false;
            }
            ruleStatusIdx = this.this$0.fRuleStatusIndex;
            if (this.this$0.fDictionaryCharCount > 0) {
                this.this$0.fDictionaryCache.populateDictionary(fromPosition, pos, fromRuleStatusIdx, ruleStatusIdx);
                if (this.this$0.fDictionaryCache.following(fromPosition)) {
                    this.addFollowing(((RuleBasedBreakIterator)this.this$0).fDictionaryCache.fBoundary, ((RuleBasedBreakIterator)this.this$0).fDictionaryCache.fStatusIndex, true);
                    return true;
                }
            }
            this.addFollowing(pos, ruleStatusIdx, true);
            for (int count = 0; count < 6 && (pos = this.this$0.handleNext()) != -1 && this.this$0.fDictionaryCharCount <= 0; ++count) {
                this.addFollowing(pos, this.this$0.fRuleStatusIndex, false);
            }
            return true;
        }

        private final boolean $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$populatePreceding() {
            int fromPosition = this.fBoundaries[this.fStartBufIdx];
            int textBegin = this.this$0.fText.getBeginIndex();
            if (fromPosition == textBegin) {
                return false;
            }
            int position = textBegin;
            int positionStatusIdx = 0;
            if (this.this$0.fDictionaryCache.preceding(fromPosition)) {
                this.addPreceding(((RuleBasedBreakIterator)this.this$0).fDictionaryCache.fBoundary, ((RuleBasedBreakIterator)this.this$0).fDictionaryCache.fStatusIndex, true);
                return true;
            }
            int backupPosition = fromPosition;
            do {
                if ((backupPosition = (backupPosition -= 30) <= textBegin ? textBegin : this.this$0.handlePrevious(backupPosition)) == -1 || backupPosition == textBegin) {
                    position = textBegin;
                    positionStatusIdx = 0;
                    continue;
                }
                this.this$0.fPosition = backupPosition;
                position = this.this$0.handleNext();
                positionStatusIdx = this.this$0.fRuleStatusIndex;
            } while (position >= fromPosition);
            this.fSideBuffer.removeAllElements();
            this.fSideBuffer.push(position);
            this.fSideBuffer.push(positionStatusIdx);
            do {
                int prevPosition = this.this$0.fPosition = position;
                int prevStatusIdx = positionStatusIdx;
                position = this.this$0.handleNext();
                positionStatusIdx = this.this$0.fRuleStatusIndex;
                if (position == -1) break;
                boolean segmentHandledByDictionary = false;
                if (this.this$0.fDictionaryCharCount != 0) {
                    int dictSegEndPosition = position;
                    this.this$0.fDictionaryCache.populateDictionary(prevPosition, dictSegEndPosition, prevStatusIdx, positionStatusIdx);
                    while (this.this$0.fDictionaryCache.following(prevPosition)) {
                        position = ((RuleBasedBreakIterator)this.this$0).fDictionaryCache.fBoundary;
                        positionStatusIdx = ((RuleBasedBreakIterator)this.this$0).fDictionaryCache.fStatusIndex;
                        segmentHandledByDictionary = true;
                        if (!$assertionsDisabled && position <= prevPosition) {
                            throw new AssertionError();
                        }
                        if (position >= fromPosition) break;
                        if (!$assertionsDisabled && position > dictSegEndPosition) {
                            throw new AssertionError();
                        }
                        this.fSideBuffer.push(position);
                        this.fSideBuffer.push(positionStatusIdx);
                        prevPosition = position;
                    }
                    if (!$assertionsDisabled && position != dictSegEndPosition && position < fromPosition) {
                        throw new AssertionError();
                    }
                }
                if (segmentHandledByDictionary || position >= fromPosition) continue;
                this.fSideBuffer.push(position);
                this.fSideBuffer.push(positionStatusIdx);
            } while (position < fromPosition);
            boolean success = false;
            if (!this.fSideBuffer.isEmpty()) {
                positionStatusIdx = this.fSideBuffer.pop();
                position = this.fSideBuffer.pop();
                this.addPreceding(position, positionStatusIdx, true);
                success = true;
            }
            while (!this.fSideBuffer.isEmpty()) {
                positionStatusIdx = this.fSideBuffer.pop();
                position = this.fSideBuffer.pop();
                if (this.addPreceding(position, positionStatusIdx, false)) continue;
                break;
            }
            return success;
        }

        private final void $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$addFollowing(int position, int ruleStatusIdx, boolean update) {
            if (!$assertionsDisabled && position <= this.fBoundaries[this.fEndBufIdx]) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && ruleStatusIdx > Short.MAX_VALUE) {
                throw new AssertionError();
            }
            int nextIdx = this.modChunkSize(this.fEndBufIdx + 1);
            if (nextIdx == this.fStartBufIdx) {
                this.fStartBufIdx = this.modChunkSize(this.fStartBufIdx + 6);
            }
            this.fBoundaries[nextIdx] = position;
            this.fStatuses[nextIdx] = (short)ruleStatusIdx;
            this.fEndBufIdx = nextIdx;
            if (update) {
                this.fBufIdx = nextIdx;
                this.fTextIdx = position;
            } else if (!$assertionsDisabled && nextIdx == this.fBufIdx) {
                throw new AssertionError();
            }
        }

        private final boolean $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$addPreceding(int position, int ruleStatusIdx, boolean update) {
            if (!$assertionsDisabled && position >= this.fBoundaries[this.fStartBufIdx]) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && ruleStatusIdx > Short.MAX_VALUE) {
                throw new AssertionError();
            }
            int nextIdx = this.modChunkSize(this.fStartBufIdx - 1);
            if (nextIdx == this.fEndBufIdx) {
                if (this.fBufIdx == this.fEndBufIdx && !update) {
                    return false;
                }
                this.fEndBufIdx = this.modChunkSize(this.fEndBufIdx - 1);
            }
            this.fBoundaries[nextIdx] = position;
            this.fStatuses[nextIdx] = (short)ruleStatusIdx;
            this.fStartBufIdx = nextIdx;
            if (update) {
                this.fBufIdx = nextIdx;
                this.fTextIdx = position;
            }
            return true;
        }

        private final boolean $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$seek(int pos) {
            if (pos < this.fBoundaries[this.fStartBufIdx] || pos > this.fBoundaries[this.fEndBufIdx]) {
                return false;
            }
            if (pos == this.fBoundaries[this.fStartBufIdx]) {
                this.fBufIdx = this.fStartBufIdx;
                this.fTextIdx = this.fBoundaries[this.fBufIdx];
                return true;
            }
            if (pos == this.fBoundaries[this.fEndBufIdx]) {
                this.fBufIdx = this.fEndBufIdx;
                this.fTextIdx = this.fBoundaries[this.fBufIdx];
                return true;
            }
            int min = this.fStartBufIdx;
            int max = this.fEndBufIdx;
            while (min != max) {
                int probe = (min + max + (min > max ? 128 : 0)) / 2;
                if (this.fBoundaries[probe = this.modChunkSize(probe)] > pos) {
                    max = probe;
                    continue;
                }
                min = this.modChunkSize(probe + 1);
            }
            if (!$assertionsDisabled && this.fBoundaries[max] <= pos) {
                throw new AssertionError();
            }
            this.fBufIdx = this.modChunkSize(max - 1);
            this.fTextIdx = this.fBoundaries[this.fBufIdx];
            if (!$assertionsDisabled && this.fTextIdx > pos) {
                throw new AssertionError();
            }
            return true;
        }

        private void $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$__constructor__(RuleBasedBreakIterator this$0, BreakCache src) {
            this.this$0 = this$0;
            this.fBoundaries = new int[128];
            this.fStatuses = new short[128];
            this.fSideBuffer = new DictionaryBreakEngine.DequeI();
            this.fStartBufIdx = src.fStartBufIdx;
            this.fEndBufIdx = src.fEndBufIdx;
            this.fTextIdx = src.fTextIdx;
            this.fBufIdx = src.fBufIdx;
            this.fBoundaries = (int[])src.fBoundaries.clone();
            this.fStatuses = (short[])src.fStatuses.clone();
            this.fSideBuffer = new DictionaryBreakEngine.DequeI();
        }

        private final void $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$dumpCache() {
            System.out.printf("fTextIdx:%d   fBufIdx:%d%n", this.fTextIdx, this.fBufIdx);
            int i = this.fStartBufIdx;
            while (true) {
                System.out.printf("%d  %d%n", i, this.fBoundaries[i]);
                if (i == this.fEndBufIdx) break;
                i = this.modChunkSize(i + 1);
            }
        }

        private final int $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$modChunkSize(int index) {
            return index & 0x7F;
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !RuleBasedBreakIterator.class.desiredAssertionStatus();
        }

        private void __constructor__(RuleBasedBreakIterator ruleBasedBreakIterator) {
            this.$$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$__constructor__(ruleBasedBreakIterator);
        }

        public BreakCache(RuleBasedBreakIterator ruleBasedBreakIterator) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$__constructor__(android.icu.text.RuleBasedBreakIterator ), this, ruleBasedBreakIterator);
        }

        void reset(int n, int n2) {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$reset(int int ), this, n, n2);
        }

        void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$reset(), this);
        }

        void next() {
            InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$next(), this);
        }

        void previous() {
            InvokeDynamicSupport.bootstrap("previous", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$previous(), this);
        }

        void following(int n) {
            InvokeDynamicSupport.bootstrap("following", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$following(int ), this, n);
        }

        void preceding(int n) {
            InvokeDynamicSupport.bootstrap("preceding", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$preceding(int ), this, n);
        }

        int current() {
            return (int)InvokeDynamicSupport.bootstrap("current", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$current(), this);
        }

        boolean populateNear(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("populateNear", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$populateNear(int ), this, n);
        }

        boolean populateFollowing() {
            return (boolean)InvokeDynamicSupport.bootstrap("populateFollowing", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$populateFollowing(), this);
        }

        boolean populatePreceding() {
            return (boolean)InvokeDynamicSupport.bootstrap("populatePreceding", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$populatePreceding(), this);
        }

        void addFollowing(int n, int n2, boolean bl) {
            InvokeDynamicSupport.bootstrap("addFollowing", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$addFollowing(int int boolean ), this, n, n2, bl);
        }

        boolean addPreceding(int n, int n2, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("addPreceding", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$addPreceding(int int boolean ), this, n, n2, bl);
        }

        boolean seek(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("seek", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$seek(int ), this, n);
        }

        private void __constructor__(RuleBasedBreakIterator ruleBasedBreakIterator, BreakCache breakCache) {
            this.$$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$__constructor__(ruleBasedBreakIterator, breakCache);
        }

        public BreakCache(RuleBasedBreakIterator ruleBasedBreakIterator, BreakCache breakCache) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$__constructor__(android.icu.text.RuleBasedBreakIterator android.icu.text.RuleBasedBreakIterator$BreakCache ), this, ruleBasedBreakIterator, breakCache);
        }

        void dumpCache() {
            InvokeDynamicSupport.bootstrap("dumpCache", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$dumpCache(), this);
        }

        private int modChunkSize(int n) {
            return (int)InvokeDynamicSupport.bootstrap("modChunkSize", $$robo$$android_icu_text_RuleBasedBreakIterator_BreakCache$modChunkSize(int ), this, n);
        }

        static {
            RobolectricInternals.classInitializing(BreakCache.class);
        }

        public /* synthetic */ BreakCache() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BreakCache)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DictionaryCache
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        DictionaryBreakEngine.DequeI fBreaks;
        int fPositionInCache;
        int fStart;
        int fLimit;
        int fFirstRuleStatusIndex;
        int fOtherRuleStatusIndex;
        int fBoundary;
        int fStatusIndex;
        static /* synthetic */ boolean $assertionsDisabled;
        /* synthetic */ RuleBasedBreakIterator this$0;

        private final void $$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$reset() {
            this.fPositionInCache = -1;
            this.fStart = 0;
            this.fLimit = 0;
            this.fFirstRuleStatusIndex = 0;
            this.fOtherRuleStatusIndex = 0;
            this.fBreaks.removeAllElements();
        }

        private final boolean $$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$following(int fromPos) {
            if (fromPos >= this.fLimit || fromPos < this.fStart) {
                this.fPositionInCache = -1;
                return false;
            }
            int r = 0;
            if (this.fPositionInCache >= 0 && this.fPositionInCache < this.fBreaks.size() && this.fBreaks.elementAt(this.fPositionInCache) == fromPos) {
                ++this.fPositionInCache;
                if (this.fPositionInCache >= this.fBreaks.size()) {
                    this.fPositionInCache = -1;
                    return false;
                }
                r = this.fBreaks.elementAt(this.fPositionInCache);
                if (!$assertionsDisabled && r <= fromPos) {
                    throw new AssertionError();
                }
                this.fBoundary = r;
                this.fStatusIndex = this.fOtherRuleStatusIndex;
                return true;
            }
            this.fPositionInCache = 0;
            while (this.fPositionInCache < this.fBreaks.size()) {
                r = this.fBreaks.elementAt(this.fPositionInCache);
                if (r > fromPos) {
                    this.fBoundary = r;
                    this.fStatusIndex = this.fOtherRuleStatusIndex;
                    return true;
                }
                ++this.fPositionInCache;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            this.fPositionInCache = -1;
            return false;
        }

        private final boolean $$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$preceding(int fromPos) {
            if (fromPos <= this.fStart || fromPos > this.fLimit) {
                this.fPositionInCache = -1;
                return false;
            }
            if (fromPos == this.fLimit) {
                this.fPositionInCache = this.fBreaks.size() - 1;
                if (this.fPositionInCache >= 0 && !$assertionsDisabled && this.fBreaks.elementAt(this.fPositionInCache) != fromPos) {
                    throw new AssertionError();
                }
            }
            if (this.fPositionInCache > 0 && this.fPositionInCache < this.fBreaks.size() && this.fBreaks.elementAt(this.fPositionInCache) == fromPos) {
                --this.fPositionInCache;
                int r = this.fBreaks.elementAt(this.fPositionInCache);
                if (!$assertionsDisabled && r >= fromPos) {
                    throw new AssertionError();
                }
                this.fBoundary = r;
                this.fStatusIndex = r == this.fStart ? this.fFirstRuleStatusIndex : this.fOtherRuleStatusIndex;
                return true;
            }
            if (this.fPositionInCache == 0) {
                this.fPositionInCache = -1;
                return false;
            }
            this.fPositionInCache = this.fBreaks.size() - 1;
            while (this.fPositionInCache >= 0) {
                int r = this.fBreaks.elementAt(this.fPositionInCache);
                if (r < fromPos) {
                    this.fBoundary = r;
                    this.fStatusIndex = r == this.fStart ? this.fFirstRuleStatusIndex : this.fOtherRuleStatusIndex;
                    return true;
                }
                --this.fPositionInCache;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            this.fPositionInCache = -1;
            return false;
        }

        private final void $$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$populateDictionary(int startPos, int endPos, int firstRuleStatus, int otherRuleStatus) {
            if (endPos - startPos <= 1) {
                return;
            }
            this.reset();
            this.fFirstRuleStatusIndex = firstRuleStatus;
            this.fOtherRuleStatusIndex = otherRuleStatus;
            int rangeStart = startPos;
            int rangeEnd = endPos;
            int foundBreakCount = 0;
            this.this$0.fText.setIndex(rangeStart);
            int c = CharacterIteration.current32(this.this$0.fText);
            short category = (short)this.this$0.fRData.fTrie.get(c);
            while (true) {
                int current;
                if ((current = this.this$0.fText.getIndex()) < rangeEnd && (category & 0x4000) == 0) {
                    c = CharacterIteration.next32(this.this$0.fText);
                    category = (short)this.this$0.fRData.fTrie.get(c);
                    continue;
                }
                if (current >= rangeEnd) break;
                LanguageBreakEngine lbe = this.this$0.getLanguageBreakEngine(c);
                if (lbe != null) {
                    foundBreakCount += lbe.findBreaks(this.this$0.fText, rangeStart, rangeEnd, this.this$0.fBreakType, this.fBreaks);
                }
                c = CharacterIteration.current32(this.this$0.fText);
                category = (short)this.this$0.fRData.fTrie.get(c);
            }
            if (foundBreakCount > 0) {
                if (!$assertionsDisabled && foundBreakCount != this.fBreaks.size()) {
                    throw new AssertionError();
                }
                if (startPos < this.fBreaks.elementAt(0)) {
                    this.fBreaks.offer(startPos);
                }
                if (endPos > this.fBreaks.peek()) {
                    this.fBreaks.push(endPos);
                }
                this.fPositionInCache = 0;
                this.fStart = this.fBreaks.elementAt(0);
                this.fLimit = this.fBreaks.peek();
            }
        }

        private void $$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$__constructor__(RuleBasedBreakIterator this$0) {
            this.this$0 = this$0;
            this.fPositionInCache = -1;
            this.fBreaks = new DictionaryBreakEngine.DequeI();
        }

        private void $$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$__constructor__(RuleBasedBreakIterator this$0, DictionaryCache src) {
            this.this$0 = this$0;
            try {
                this.fBreaks = (DictionaryBreakEngine.DequeI)src.fBreaks.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            this.fPositionInCache = src.fPositionInCache;
            this.fStart = src.fStart;
            this.fLimit = src.fLimit;
            this.fFirstRuleStatusIndex = src.fFirstRuleStatusIndex;
            this.fOtherRuleStatusIndex = src.fOtherRuleStatusIndex;
            this.fBoundary = src.fBoundary;
            this.fStatusIndex = src.fStatusIndex;
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !RuleBasedBreakIterator.class.desiredAssertionStatus();
        }

        void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$reset(), this);
        }

        boolean following(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("following", $$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$following(int ), this, n);
        }

        boolean preceding(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("preceding", $$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$preceding(int ), this, n);
        }

        void populateDictionary(int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("populateDictionary", $$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$populateDictionary(int int int int ), this, n, n2, n3, n4);
        }

        private void __constructor__(RuleBasedBreakIterator ruleBasedBreakIterator) {
            this.$$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$__constructor__(ruleBasedBreakIterator);
        }

        public DictionaryCache(RuleBasedBreakIterator ruleBasedBreakIterator) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$__constructor__(android.icu.text.RuleBasedBreakIterator ), this, ruleBasedBreakIterator);
        }

        private void __constructor__(RuleBasedBreakIterator ruleBasedBreakIterator, DictionaryCache dictionaryCache) {
            this.$$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$__constructor__(ruleBasedBreakIterator, dictionaryCache);
        }

        public DictionaryCache(RuleBasedBreakIterator ruleBasedBreakIterator, DictionaryCache dictionaryCache) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedBreakIterator_DictionaryCache$__constructor__(android.icu.text.RuleBasedBreakIterator android.icu.text.RuleBasedBreakIterator$DictionaryCache ), this, ruleBasedBreakIterator, dictionaryCache);
        }

        static {
            RobolectricInternals.classInitializing(DictionaryCache.class);
        }

        public /* synthetic */ DictionaryCache() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DictionaryCache)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class LookAheadResults
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int fUsedSlotLimit;
        int[] fPositions;
        int[] fKeys;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_text_RuleBasedBreakIterator_LookAheadResults$__constructor__() {
            this.fUsedSlotLimit = 0;
            this.fPositions = new int[8];
            this.fKeys = new int[8];
        }

        private final int $$robo$$android_icu_text_RuleBasedBreakIterator_LookAheadResults$getPosition(int key) {
            for (int i = 0; i < this.fUsedSlotLimit; ++i) {
                if (this.fKeys[i] != key) continue;
                return this.fPositions[i];
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return -1;
        }

        private final void $$robo$$android_icu_text_RuleBasedBreakIterator_LookAheadResults$setPosition(int key, int position) {
            int i;
            for (i = 0; i < this.fUsedSlotLimit; ++i) {
                if (this.fKeys[i] != key) continue;
                this.fPositions[i] = position;
                return;
            }
            if (i >= 8) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                i = 7;
            }
            this.fKeys[i] = key;
            this.fPositions[i] = position;
            if (!$assertionsDisabled && this.fUsedSlotLimit != i) {
                throw new AssertionError();
            }
            this.fUsedSlotLimit = i + 1;
        }

        private final void $$robo$$android_icu_text_RuleBasedBreakIterator_LookAheadResults$reset() {
            this.fUsedSlotLimit = 0;
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !RuleBasedBreakIterator.class.desiredAssertionStatus();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_RuleBasedBreakIterator_LookAheadResults$__constructor__();
        }

        public LookAheadResults() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedBreakIterator_LookAheadResults$__constructor__(), this);
        }

        int getPosition(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getPosition", $$robo$$android_icu_text_RuleBasedBreakIterator_LookAheadResults$getPosition(int ), this, n);
        }

        void setPosition(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setPosition", $$robo$$android_icu_text_RuleBasedBreakIterator_LookAheadResults$setPosition(int int ), this, n, n2);
        }

        void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_text_RuleBasedBreakIterator_LookAheadResults$reset(), this);
        }

        static {
            RobolectricInternals.classInitializing(LookAheadResults.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LookAheadResults)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

