/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUBinary;
import android.icu.impl.Trie2;
import android.icu.text.RuleBasedBreakIterator;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RBBIDataWrapper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    RBBIDataHeader fHeader;
    short[] fFTable;
    short[] fRTable;
    short[] fSFTable;
    short[] fSRTable;
    Trie2 fTrie;
    String fRuleSource;
    int[] fStatusTable;
    private boolean isBigEndian;
    static int DATA_FORMAT = 1114794784;
    static int FORMAT_VERSION = 0x4000000;
    private static IsAcceptable IS_ACCEPTABLE;
    static int DH_SIZE = 24;
    static int DH_MAGIC = 0;
    static int DH_FORMATVERSION = 1;
    static int DH_LENGTH = 2;
    static int DH_CATCOUNT = 3;
    static int DH_FTABLE = 4;
    static int DH_FTABLELEN = 5;
    static int DH_RTABLE = 6;
    static int DH_RTABLELEN = 7;
    static int DH_SFTABLE = 8;
    static int DH_SFTABLELEN = 9;
    static int DH_SRTABLE = 10;
    static int DH_SRTABLELEN = 11;
    static int DH_TRIE = 12;
    static int DH_TRIELEN = 13;
    static int DH_RULESOURCE = 14;
    static int DH_RULESOURCELEN = 15;
    static int DH_STATUSTABLE = 16;
    static int DH_STATUSTABLELEN = 17;
    static int ACCEPTING = 0;
    static int LOOKAHEAD = 1;
    static int TAGIDX = 2;
    static int RESERVED = 3;
    static int NEXTSTATES = 4;
    static int NUMSTATES = 0;
    static int ROWLEN = 2;
    static int FLAGS = 4;
    private static int ROW_DATA = 8;
    static int RBBI_LOOKAHEAD_HARD_BREAK = 1;
    static int RBBI_BOF_REQUIRED = 2;

    private final int $$robo$$android_icu_text_RBBIDataWrapper$getRowIndex(int state) {
        return 8 + state * (this.fHeader.fCatCount + 4);
    }

    private void $$robo$$android_icu_text_RBBIDataWrapper$__constructor__() {
    }

    private static final RBBIDataWrapper $$robo$$android_icu_text_RBBIDataWrapper$get(ByteBuffer bytes) throws IOException {
        RBBIDataWrapper This = new RBBIDataWrapper();
        ICUBinary.readHeader(bytes, 1114794784, IS_ACCEPTABLE);
        This.isBigEndian = bytes.order() == ByteOrder.BIG_ENDIAN;
        This.fHeader = new RBBIDataHeader();
        This.fHeader.fMagic = bytes.getInt();
        This.fHeader.fFormatVersion[0] = bytes.get();
        This.fHeader.fFormatVersion[1] = bytes.get();
        This.fHeader.fFormatVersion[2] = bytes.get();
        This.fHeader.fFormatVersion[3] = bytes.get();
        This.fHeader.fLength = bytes.getInt();
        This.fHeader.fCatCount = bytes.getInt();
        This.fHeader.fFTable = bytes.getInt();
        This.fHeader.fFTableLen = bytes.getInt();
        This.fHeader.fRTable = bytes.getInt();
        This.fHeader.fRTableLen = bytes.getInt();
        This.fHeader.fSFTable = bytes.getInt();
        This.fHeader.fSFTableLen = bytes.getInt();
        This.fHeader.fSRTable = bytes.getInt();
        This.fHeader.fSRTableLen = bytes.getInt();
        This.fHeader.fTrie = bytes.getInt();
        This.fHeader.fTrieLen = bytes.getInt();
        This.fHeader.fRuleSource = bytes.getInt();
        This.fHeader.fRuleSourceLen = bytes.getInt();
        This.fHeader.fStatusTable = bytes.getInt();
        This.fHeader.fStatusTableLen = bytes.getInt();
        ICUBinary.skipBytes(bytes, 24);
        if (This.fHeader.fMagic != 45472 || !IS_ACCEPTABLE.isDataVersionAcceptable(This.fHeader.fFormatVersion)) {
            throw new IOException("Break Iterator Rule Data Magic Number Incorrect, or unsupported data version.");
        }
        int pos = 96;
        if (This.fHeader.fFTable < pos || This.fHeader.fFTable > This.fHeader.fLength) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(bytes, This.fHeader.fFTable - pos);
        pos = This.fHeader.fFTable;
        This.fFTable = ICUBinary.getShorts(bytes, This.fHeader.fFTableLen / 2, This.fHeader.fFTableLen & 1);
        ICUBinary.skipBytes(bytes, This.fHeader.fRTable - (pos += This.fHeader.fFTableLen));
        pos = This.fHeader.fRTable;
        This.fRTable = ICUBinary.getShorts(bytes, This.fHeader.fRTableLen / 2, This.fHeader.fRTableLen & 1);
        pos += This.fHeader.fRTableLen;
        if (This.fHeader.fSFTableLen > 0) {
            ICUBinary.skipBytes(bytes, This.fHeader.fSFTable - pos);
            pos = This.fHeader.fSFTable;
            This.fSFTable = ICUBinary.getShorts(bytes, This.fHeader.fSFTableLen / 2, This.fHeader.fSFTableLen & 1);
            pos += This.fHeader.fSFTableLen;
        }
        if (This.fHeader.fSRTableLen > 0) {
            ICUBinary.skipBytes(bytes, This.fHeader.fSRTable - pos);
            pos = This.fHeader.fSRTable;
            This.fSRTable = ICUBinary.getShorts(bytes, This.fHeader.fSRTableLen / 2, This.fHeader.fSRTableLen & 1);
            pos += This.fHeader.fSRTableLen;
        }
        if (This.fSRTable == null && This.fRTable != null) {
            This.fSRTable = This.fRTable;
            This.fRTable = null;
        }
        ICUBinary.skipBytes(bytes, This.fHeader.fTrie - pos);
        pos = This.fHeader.fTrie;
        bytes.mark();
        This.fTrie = Trie2.createFromSerialized(bytes);
        bytes.reset();
        if (pos > This.fHeader.fStatusTable) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(bytes, This.fHeader.fStatusTable - pos);
        pos = This.fHeader.fStatusTable;
        This.fStatusTable = ICUBinary.getInts(bytes, This.fHeader.fStatusTableLen / 4, This.fHeader.fStatusTableLen & 3);
        if ((pos += This.fHeader.fStatusTableLen) > This.fHeader.fRuleSource) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(bytes, This.fHeader.fRuleSource - pos);
        pos = This.fHeader.fRuleSource;
        This.fRuleSource = ICUBinary.getString(bytes, This.fHeader.fRuleSourceLen / 2, This.fHeader.fRuleSourceLen & 1);
        if (RuleBasedBreakIterator.fDebugEnv != null && RuleBasedBreakIterator.fDebugEnv.indexOf("data") >= 0) {
            This.dump(System.out);
        }
        return This;
    }

    private final int $$robo$$android_icu_text_RBBIDataWrapper$getStateTableNumStates(short[] table) {
        if (this.isBigEndian) {
            return table[0] << 16 | table[1] & 0xFFFF;
        }
        return table[1] << 16 | table[0] & 0xFFFF;
    }

    private final int $$robo$$android_icu_text_RBBIDataWrapper$getStateTableFlags(short[] table) {
        return table[this.isBigEndian ? 5 : 4];
    }

    private final void $$robo$$android_icu_text_RBBIDataWrapper$dump(PrintStream out) {
        if (this.fFTable.length == 0) {
            throw new NullPointerException();
        }
        out.println("RBBI Data Wrapper dump ...");
        out.println();
        out.println("Forward State Table");
        this.dumpTable(out, this.fFTable);
        out.println("Reverse State Table");
        this.dumpTable(out, this.fRTable);
        out.println("Forward Safe Points Table");
        this.dumpTable(out, this.fSFTable);
        out.println("Reverse Safe Points Table");
        this.dumpTable(out, this.fSRTable);
        this.dumpCharCategories(out);
        out.println("Source Rules: " + this.fRuleSource);
    }

    private static final String $$robo$$android_icu_text_RBBIDataWrapper$intToString(int n, int width) {
        StringBuilder dest = new StringBuilder(width);
        dest.append(n);
        while (dest.length() < width) {
            dest.insert(0, ' ');
        }
        return dest.toString();
    }

    private static final String $$robo$$android_icu_text_RBBIDataWrapper$intToHexString(int n, int width) {
        StringBuilder dest = new StringBuilder(width);
        dest.append(Integer.toHexString(n));
        while (dest.length() < width) {
            dest.insert(0, ' ');
        }
        return dest.toString();
    }

    private final void $$robo$$android_icu_text_RBBIDataWrapper$dumpTable(PrintStream out, short[] table) {
        if (table == null || table.length == 0) {
            out.println("  -- null -- ");
        } else {
            int n;
            StringBuilder header = new StringBuilder(" Row  Acc Look  Tag");
            for (n = 0; n < this.fHeader.fCatCount; ++n) {
                header.append(RBBIDataWrapper.intToString(n, 5));
            }
            out.println(header.toString());
            for (n = 0; n < header.length(); ++n) {
                out.print("-");
            }
            out.println();
            for (int state = 0; state < this.getStateTableNumStates(table); ++state) {
                this.dumpRow(out, table, state);
            }
            out.println();
        }
    }

    private final void $$robo$$android_icu_text_RBBIDataWrapper$dumpRow(PrintStream out, short[] table, int state) {
        StringBuilder dest = new StringBuilder(this.fHeader.fCatCount * 5 + 20);
        dest.append(RBBIDataWrapper.intToString(state, 4));
        int row = this.getRowIndex(state);
        if (table[row + 0] != 0) {
            dest.append(RBBIDataWrapper.intToString(table[row + 0], 5));
        } else {
            dest.append("     ");
        }
        if (table[row + 1] != 0) {
            dest.append(RBBIDataWrapper.intToString(table[row + 1], 5));
        } else {
            dest.append("     ");
        }
        dest.append(RBBIDataWrapper.intToString(table[row + 2], 5));
        for (int col = 0; col < this.fHeader.fCatCount; ++col) {
            dest.append(RBBIDataWrapper.intToString(table[row + 4 + col], 5));
        }
        out.println(dest);
    }

    private final void $$robo$$android_icu_text_RBBIDataWrapper$dumpCharCategories(PrintStream out) {
        int category;
        int n = this.fHeader.fCatCount;
        String[] catStrings = new String[n + 1];
        int rangeStart = 0;
        int rangeEnd = 0;
        int lastCat = -1;
        int[] lastNewline = new int[n + 1];
        for (category = 0; category <= this.fHeader.fCatCount; ++category) {
            catStrings[category] = "";
        }
        out.println("\nCharacter Categories");
        out.println("--------------------");
        for (int char32 = 0; char32 <= 0x10FFFF; ++char32) {
            category = this.fTrie.get(char32);
            if ((category &= 0xFFFFBFFF) < 0 || category > this.fHeader.fCatCount) {
                out.println("Error, bad category " + Integer.toHexString(category) + " for char " + Integer.toHexString(char32));
                break;
            }
            if (category == lastCat) {
                rangeEnd = char32;
                continue;
            }
            if (lastCat >= 0) {
                if (catStrings[lastCat].length() > lastNewline[lastCat] + 70) {
                    lastNewline[lastCat] = catStrings[lastCat].length() + 10;
                    int n2 = lastCat;
                    catStrings[n2] = catStrings[n2] + "\n       ";
                }
                int n3 = lastCat;
                catStrings[n3] = catStrings[n3] + " " + Integer.toHexString(rangeStart);
                if (rangeEnd != rangeStart) {
                    int n4 = lastCat;
                    catStrings[n4] = catStrings[n4] + "-" + Integer.toHexString(rangeEnd);
                }
            }
            lastCat = category;
            rangeStart = rangeEnd = char32;
        }
        int n5 = lastCat;
        catStrings[n5] = catStrings[n5] + " " + Integer.toHexString(rangeStart);
        if (rangeEnd != rangeStart) {
            int n6 = lastCat;
            catStrings[n6] = catStrings[n6] + "-" + Integer.toHexString(rangeEnd);
        }
        for (category = 0; category <= this.fHeader.fCatCount; ++category) {
            out.println(RBBIDataWrapper.intToString(category, 5) + "  " + catStrings[category]);
        }
        out.println();
    }

    static void __staticInitializer__() {
        IS_ACCEPTABLE = new IsAcceptable(null);
    }

    int getRowIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRowIndex", $$robo$$android_icu_text_RBBIDataWrapper$getRowIndex(int ), this, n);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_RBBIDataWrapper$__constructor__();
    }

    public RBBIDataWrapper() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RBBIDataWrapper$__constructor__(), this);
    }

    static RBBIDataWrapper get(ByteBuffer byteBuffer) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_icu_text_RBBIDataWrapper$get(java.nio.ByteBuffer ), (ByteBuffer)byteBuffer);
    }

    private int getStateTableNumStates(short[] sArray) {
        return (int)InvokeDynamicSupport.bootstrap("getStateTableNumStates", $$robo$$android_icu_text_RBBIDataWrapper$getStateTableNumStates(short[] ), this, sArray);
    }

    int getStateTableFlags(short[] sArray) {
        return (int)InvokeDynamicSupport.bootstrap("getStateTableFlags", $$robo$$android_icu_text_RBBIDataWrapper$getStateTableFlags(short[] ), this, sArray);
    }

    void dump(PrintStream printStream) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_icu_text_RBBIDataWrapper$dump(java.io.PrintStream ), this, printStream);
    }

    public static String intToString(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("intToString", $$robo$$android_icu_text_RBBIDataWrapper$intToString(int int ), (int)n, (int)n2);
    }

    public static String intToHexString(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("intToHexString", $$robo$$android_icu_text_RBBIDataWrapper$intToHexString(int int ), (int)n, (int)n2);
    }

    private void dumpTable(PrintStream printStream, short[] sArray) {
        InvokeDynamicSupport.bootstrap("dumpTable", $$robo$$android_icu_text_RBBIDataWrapper$dumpTable(java.io.PrintStream short[] ), this, printStream, sArray);
    }

    private void dumpRow(PrintStream printStream, short[] sArray, int n) {
        InvokeDynamicSupport.bootstrap("dumpRow", $$robo$$android_icu_text_RBBIDataWrapper$dumpRow(java.io.PrintStream short[] int ), this, printStream, sArray, n);
    }

    private void dumpCharCategories(PrintStream printStream) {
        InvokeDynamicSupport.bootstrap("dumpCharCategories", $$robo$$android_icu_text_RBBIDataWrapper$dumpCharCategories(java.io.PrintStream ), this, printStream);
    }

    static {
        RobolectricInternals.classInitializing(RBBIDataWrapper.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RBBIDataWrapper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class RBBIDataHeader
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int fMagic;
        byte[] fFormatVersion;
        int fLength;
        int fCatCount;
        int fFTable;
        int fFTableLen;
        int fRTable;
        int fRTableLen;
        int fSFTable;
        int fSFTableLen;
        int fSRTable;
        int fSRTableLen;
        int fTrie;
        int fTrieLen;
        int fRuleSource;
        int fRuleSourceLen;
        int fStatusTable;
        int fStatusTableLen;

        private void $$robo$$android_icu_text_RBBIDataWrapper_RBBIDataHeader$__constructor__() {
            this.fMagic = 0;
            this.fFormatVersion = new byte[4];
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_RBBIDataWrapper_RBBIDataHeader$__constructor__();
        }

        public RBBIDataHeader() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RBBIDataWrapper_RBBIDataHeader$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RBBIDataHeader)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class IsAcceptable
    implements ICUBinary.Authenticate,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_RBBIDataWrapper_IsAcceptable$__constructor__() {
        }

        private final boolean $$robo$$android_icu_text_RBBIDataWrapper_IsAcceptable$isDataVersionAcceptable(byte[] version) {
            int intVersion = (version[0] << 24) + (version[1] << 16) + (version[2] << 8) + version[3];
            return intVersion == 0x4000000;
        }

        private /* synthetic */ void $$robo$$android_icu_text_RBBIDataWrapper_IsAcceptable$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_RBBIDataWrapper_IsAcceptable$__constructor__();
        }

        public IsAcceptable() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RBBIDataWrapper_IsAcceptable$__constructor__(), this);
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("isDataVersionAcceptable", $$robo$$android_icu_text_RBBIDataWrapper_IsAcceptable$isDataVersionAcceptable(byte[] ), this, byArray);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_RBBIDataWrapper_IsAcceptable$__constructor__(var1_1);
        }

        public /* synthetic */ IsAcceptable(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RBBIDataWrapper_IsAcceptable$__constructor__(android.icu.text.RBBIDataWrapper$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IsAcceptable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

