/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.PluralRulesLoader;
import android.icu.text.PluralRulesSerialProxy;
import android.icu.text.UnicodeSet;
import android.icu.util.Output;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PluralRules
implements Serializable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static UnicodeSet ALLOWED_ID;
    @Deprecated
    public static String CATEGORY_SEPARATOR = ";  ";
    @Deprecated
    public static String KEYWORD_RULE_SEPARATOR = ": ";
    private static long serialVersionUID = 1L;
    private RuleList rules;
    private transient Set<String> keywords;
    public static String KEYWORD_ZERO = "zero";
    public static String KEYWORD_ONE = "one";
    public static String KEYWORD_TWO = "two";
    public static String KEYWORD_FEW = "few";
    public static String KEYWORD_MANY = "many";
    public static String KEYWORD_OTHER = "other";
    public static double NO_UNIQUE_VALUE = -0.00123456777;
    private static Constraint NO_CONSTRAINT;
    private static Rule DEFAULT_RULE;
    public static PluralRules DEFAULT;
    static Pattern AT_SEPARATED;
    static Pattern OR_SEPARATED;
    static Pattern AND_SEPARATED;
    static Pattern COMMA_SEPARATED;
    static Pattern DOTDOT_SEPARATED;
    static Pattern TILDE_SEPARATED;
    static Pattern SEMI_SEPARATED;

    private static final PluralRules $$robo$$android_icu_text_PluralRules$parseDescription(String description) throws ParseException {
        return (description = description.trim()).length() == 0 ? DEFAULT : new PluralRules(PluralRules.parseRuleChain(description));
    }

    private static final PluralRules $$robo$$android_icu_text_PluralRules$createRules(String description) {
        try {
            return PluralRules.parseDescription(description);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Constraint $$robo$$android_icu_text_PluralRules$parseConstraint(String description) throws ParseException {
        Constraint result = null;
        String[] or_together = OR_SEPARATED.split(description);
        for (int i = 0; i < or_together.length; ++i) {
            Constraint andConstraint = null;
            String[] and_together = AND_SEPARATED.split(or_together[i]);
            for (int j = 0; j < and_together.length; ++j) {
                Operand operand;
                Constraint newConstraint = NO_CONSTRAINT;
                String condition = and_together[j].trim();
                String[] tokens = SimpleTokenizer.split(condition);
                int mod = 0;
                boolean inRange = true;
                boolean integersOnly = true;
                double lowBound = 9.223372036854776E18;
                double highBound = -9.223372036854776E18;
                long[] vals = null;
                int x = 0;
                String t = tokens[x++];
                boolean hackForCompatibility = false;
                try {
                    operand = FixedDecimal.getOperand(t);
                }
                catch (Exception e) {
                    throw PluralRules.unexpected(t, condition);
                }
                if (x < tokens.length) {
                    if ("mod".equals(t = tokens[x++]) || "%".equals(t)) {
                        mod = Integer.parseInt(tokens[x++]);
                        t = PluralRules.nextToken(tokens, x++, condition);
                    }
                    if ("not".equals(t)) {
                        inRange = !inRange;
                        if ("=".equals(t = PluralRules.nextToken(tokens, x++, condition))) {
                            throw PluralRules.unexpected(t, condition);
                        }
                    } else if ("!".equals(t)) {
                        inRange = !inRange;
                        if (!"=".equals(t = PluralRules.nextToken(tokens, x++, condition))) {
                            throw PluralRules.unexpected(t, condition);
                        }
                    }
                    if ("is".equals(t) || "in".equals(t) || "=".equals(t)) {
                        hackForCompatibility = "is".equals(t);
                        if (hackForCompatibility && !inRange) {
                            throw PluralRules.unexpected(t, condition);
                        }
                        t = PluralRules.nextToken(tokens, x++, condition);
                    } else if ("within".equals(t)) {
                        integersOnly = false;
                        t = PluralRules.nextToken(tokens, x++, condition);
                    } else {
                        throw PluralRules.unexpected(t, condition);
                    }
                    if ("not".equals(t)) {
                        if (!hackForCompatibility && !inRange) {
                            throw PluralRules.unexpected(t, condition);
                        }
                        inRange = !inRange;
                        t = PluralRules.nextToken(tokens, x++, condition);
                    }
                    ArrayList<Long> valueList = new ArrayList<Long>();
                    while (true) {
                        long low;
                        long high = low = Long.parseLong(t);
                        if (x < tokens.length) {
                            if ((t = PluralRules.nextToken(tokens, x++, condition)).equals(".")) {
                                if (!(t = PluralRules.nextToken(tokens, x++, condition)).equals(".")) {
                                    throw PluralRules.unexpected(t, condition);
                                }
                                t = PluralRules.nextToken(tokens, x++, condition);
                                high = Long.parseLong(t);
                                if (x < tokens.length && !(t = PluralRules.nextToken(tokens, x++, condition)).equals(",")) {
                                    throw PluralRules.unexpected(t, condition);
                                }
                            } else if (!t.equals(",")) {
                                throw PluralRules.unexpected(t, condition);
                            }
                        }
                        if (low > high) {
                            throw PluralRules.unexpected(low + "~" + high, condition);
                        }
                        if (mod != 0 && high >= (long)mod) {
                            throw PluralRules.unexpected(high + ">mod=" + mod, condition);
                        }
                        valueList.add(low);
                        valueList.add(high);
                        lowBound = Math.min(lowBound, (double)low);
                        highBound = Math.max(highBound, (double)high);
                        if (x >= tokens.length) break;
                        t = PluralRules.nextToken(tokens, x++, condition);
                    }
                    if (t.equals(",")) {
                        throw PluralRules.unexpected(t, condition);
                    }
                    if (valueList.size() == 2) {
                        vals = null;
                    } else {
                        vals = new long[valueList.size()];
                        for (int k = 0; k < vals.length; ++k) {
                            vals[k] = (Long)valueList.get(k);
                        }
                    }
                    if (lowBound != highBound && hackForCompatibility && !inRange) {
                        throw PluralRules.unexpected("is not <range>", condition);
                    }
                    newConstraint = new RangeConstraint(mod, inRange, operand, integersOnly, lowBound, highBound, vals);
                }
                andConstraint = andConstraint == null ? newConstraint : new AndConstraint(andConstraint, newConstraint);
            }
            result = result == null ? andConstraint : new OrConstraint(result, andConstraint);
        }
        return result;
    }

    private static final ParseException $$robo$$android_icu_text_PluralRules$unexpected(String token, String context) {
        return new ParseException("unexpected token '" + token + "' in '" + context + "'", -1);
    }

    private static final String $$robo$$android_icu_text_PluralRules$nextToken(String[] tokens, int x, String context) throws ParseException {
        if (x < tokens.length) {
            return tokens[x];
        }
        throw new ParseException("missing token at end of '" + context + "'", -1);
    }

    private static final Rule $$robo$$android_icu_text_PluralRules$parseRule(String description) throws ParseException {
        if (description.length() == 0) {
            return DEFAULT_RULE;
        }
        int x = (description = description.toLowerCase(Locale.ENGLISH)).indexOf(58);
        if (x == -1) {
            throw new ParseException("missing ':' in rule description '" + description + "'", 0);
        }
        String keyword = description.substring(0, x).trim();
        if (!PluralRules.isValidKeyword(keyword)) {
            throw new ParseException("keyword '" + keyword + " is not valid", 0);
        }
        description = description.substring(x + 1).trim();
        String[] constraintOrSamples = AT_SEPARATED.split(description);
        boolean sampleFailure = false;
        FixedDecimalSamples integerSamples = null;
        FixedDecimalSamples decimalSamples = null;
        switch (constraintOrSamples.length) {
            case 1: {
                break;
            }
            case 2: {
                integerSamples = FixedDecimalSamples.parse(constraintOrSamples[1]);
                if (integerSamples.sampleType != SampleType.DECIMAL) break;
                decimalSamples = integerSamples;
                integerSamples = null;
                break;
            }
            case 3: {
                integerSamples = FixedDecimalSamples.parse(constraintOrSamples[1]);
                decimalSamples = FixedDecimalSamples.parse(constraintOrSamples[2]);
                if (integerSamples.sampleType == SampleType.INTEGER && decimalSamples.sampleType == SampleType.DECIMAL) break;
                throw new IllegalArgumentException("Must have @integer then @decimal in " + description);
            }
            default: {
                throw new IllegalArgumentException("Too many samples in " + description);
            }
        }
        if (sampleFailure) {
            throw new IllegalArgumentException("Ill-formed samples\u2014'@' characters.");
        }
        boolean isOther = keyword.equals("other");
        if (isOther != (constraintOrSamples[0].length() == 0)) {
            throw new IllegalArgumentException("The keyword 'other' must have no constraints, just samples.");
        }
        Constraint constraint = isOther ? NO_CONSTRAINT : PluralRules.parseConstraint(constraintOrSamples[0]);
        return new Rule(keyword, constraint, integerSamples, decimalSamples);
    }

    private static final RuleList $$robo$$android_icu_text_PluralRules$parseRuleChain(String description) throws ParseException {
        RuleList result = new RuleList(null);
        if (description.endsWith(";")) {
            description = description.substring(0, description.length() - 1);
        }
        String[] rules = SEMI_SEPARATED.split(description);
        for (int i = 0; i < rules.length; ++i) {
            Rule rule = PluralRules.parseRule(rules[i].trim());
            result.hasExplicitBoundingInfo = (byte)(result.hasExplicitBoundingInfo | (rule.integerSamples != null || rule.decimalSamples != null ? 1 : 0));
            result.addRule(rule);
        }
        return result.finish();
    }

    private static final void $$robo$$android_icu_text_PluralRules$addRange(StringBuilder result, double lb, double ub, boolean addSeparator) {
        if (addSeparator) {
            result.append(",");
        }
        if (lb == ub) {
            result.append(PluralRules.format(lb));
        } else {
            result.append(PluralRules.format(lb) + ".." + PluralRules.format(ub));
        }
    }

    private static final String $$robo$$android_icu_text_PluralRules$format(double lb) {
        long lbi = (long)lb;
        return lb == (double)lbi ? String.valueOf(lbi) : String.valueOf(lb);
    }

    private final boolean $$robo$$android_icu_text_PluralRules$addConditional(Set<IFixedDecimal> toAddTo, Set<IFixedDecimal> others, double trial) {
        boolean added;
        FixedDecimal toAdd = new FixedDecimal(trial);
        if (!toAddTo.contains(toAdd) && !others.contains(toAdd)) {
            others.add(toAdd);
            added = true;
        } else {
            added = false;
        }
        return added;
    }

    private static final PluralRules $$robo$$android_icu_text_PluralRules$forLocale(ULocale locale) {
        return Factory.getDefaultFactory().forLocale(locale, PluralType.CARDINAL);
    }

    private static final PluralRules $$robo$$android_icu_text_PluralRules$forLocale(Locale locale) {
        return PluralRules.forLocale(ULocale.forLocale(locale));
    }

    private static final PluralRules $$robo$$android_icu_text_PluralRules$forLocale(ULocale locale, PluralType type) {
        return Factory.getDefaultFactory().forLocale(locale, type);
    }

    private static final PluralRules $$robo$$android_icu_text_PluralRules$forLocale(Locale locale, PluralType type) {
        return PluralRules.forLocale(ULocale.forLocale(locale), type);
    }

    private static final boolean $$robo$$android_icu_text_PluralRules$isValidKeyword(String token) {
        return ALLOWED_ID.containsAll(token);
    }

    private void $$robo$$android_icu_text_PluralRules$__constructor__(RuleList rules) {
        this.rules = rules;
        this.keywords = Collections.unmodifiableSet(rules.getKeywords());
    }

    @Deprecated
    private final int $$robo$$android_icu_text_PluralRules$hashCode() {
        return this.rules.hashCode();
    }

    private final String $$robo$$android_icu_text_PluralRules$select(double number) {
        return this.rules.select(new FixedDecimal(number));
    }

    @Deprecated
    private final String $$robo$$android_icu_text_PluralRules$select(double number, int countVisibleFractionDigits, long fractionaldigits) {
        return this.rules.select(new FixedDecimal(number, countVisibleFractionDigits, fractionaldigits));
    }

    @Deprecated
    private final String $$robo$$android_icu_text_PluralRules$select(IFixedDecimal number) {
        return this.rules.select(number);
    }

    @Deprecated
    private final boolean $$robo$$android_icu_text_PluralRules$matches(FixedDecimal sample, String keyword) {
        return this.rules.select(sample, keyword);
    }

    private final Set<String> $$robo$$android_icu_text_PluralRules$getKeywords() {
        return this.keywords;
    }

    private final double $$robo$$android_icu_text_PluralRules$getUniqueKeywordValue(String keyword) {
        Collection<Double> values = this.getAllKeywordValues(keyword);
        if (values != null && values.size() == 1) {
            return values.iterator().next();
        }
        return -0.00123456777;
    }

    private final Collection<Double> $$robo$$android_icu_text_PluralRules$getAllKeywordValues(String keyword) {
        return this.getAllKeywordValues(keyword, SampleType.INTEGER);
    }

    @Deprecated
    private final Collection<Double> $$robo$$android_icu_text_PluralRules$getAllKeywordValues(String keyword, SampleType type) {
        if (!this.isLimited(keyword, type)) {
            return null;
        }
        Collection<Double> samples = this.getSamples(keyword, type);
        return samples == null ? null : Collections.unmodifiableCollection(samples);
    }

    private final Collection<Double> $$robo$$android_icu_text_PluralRules$getSamples(String keyword) {
        return this.getSamples(keyword, SampleType.INTEGER);
    }

    @Deprecated
    private final Collection<Double> $$robo$$android_icu_text_PluralRules$getSamples(String keyword, SampleType sampleType) {
        if (!this.keywords.contains(keyword)) {
            return null;
        }
        TreeSet<Double> result = new TreeSet<Double>();
        if (this.rules.hasExplicitBoundingInfo) {
            FixedDecimalSamples samples = this.rules.getDecimalSamples(keyword, sampleType);
            return samples == null ? Collections.unmodifiableSet(result) : Collections.unmodifiableSet(samples.addSamples(result));
        }
        int maxCount = this.isLimited(keyword, sampleType) ? Integer.MAX_VALUE : 20;
        switch (2.$SwitchMap$android$icu$text$PluralRules$SampleType[sampleType.ordinal()]) {
            case 1: {
                for (int i = 0; i < 200 && this.addSample(keyword, i, maxCount, result); ++i) {
                }
                this.addSample(keyword, 1000000, maxCount, result);
                break;
            }
            case 2: {
                for (int i = 0; i < 2000 && this.addSample(keyword, new FixedDecimal((double)i / 10.0, 1), maxCount, result); ++i) {
                }
                this.addSample(keyword, new FixedDecimal(1000000.0, 1), maxCount, result);
            }
        }
        return result.size() == 0 ? null : Collections.unmodifiableSet(result);
    }

    @Deprecated
    private final boolean $$robo$$android_icu_text_PluralRules$addSample(String keyword, Number sample, int maxCount, Set<Double> result) {
        String selectedKeyword;
        String string2 = selectedKeyword = sample instanceof FixedDecimal ? this.select((FixedDecimal)sample) : this.select(sample.doubleValue());
        if (selectedKeyword.equals(keyword)) {
            result.add(sample.doubleValue());
            if (--maxCount < 0) {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    private final FixedDecimalSamples $$robo$$android_icu_text_PluralRules$getDecimalSamples(String keyword, SampleType sampleType) {
        return this.rules.getDecimalSamples(keyword, sampleType);
    }

    private static final ULocale[] $$robo$$android_icu_text_PluralRules$getAvailableULocales() {
        return Factory.getDefaultFactory().getAvailableULocales();
    }

    private static final ULocale $$robo$$android_icu_text_PluralRules$getFunctionalEquivalent(ULocale locale, boolean[] isAvailable) {
        return Factory.getDefaultFactory().getFunctionalEquivalent(locale, isAvailable);
    }

    private final String $$robo$$android_icu_text_PluralRules$toString() {
        return this.rules.toString();
    }

    private final boolean $$robo$$android_icu_text_PluralRules$equals(Object rhs) {
        return rhs instanceof PluralRules && this.equals((PluralRules)rhs);
    }

    private final boolean $$robo$$android_icu_text_PluralRules$equals(PluralRules rhs) {
        return rhs != null && this.toString().equals(rhs.toString());
    }

    private final KeywordStatus $$robo$$android_icu_text_PluralRules$getKeywordStatus(String keyword, int offset, Set<Double> explicits, Output<Double> uniqueValue) {
        return this.getKeywordStatus(keyword, offset, explicits, uniqueValue, SampleType.INTEGER);
    }

    @Deprecated
    private final KeywordStatus $$robo$$android_icu_text_PluralRules$getKeywordStatus(String keyword, int offset, Set<Double> explicits, Output<Double> uniqueValue, SampleType sampleType) {
        if (uniqueValue != null) {
            uniqueValue.value = null;
        }
        if (!this.keywords.contains(keyword)) {
            return KeywordStatus.INVALID;
        }
        if (!this.isLimited(keyword, sampleType)) {
            return KeywordStatus.UNBOUNDED;
        }
        Collection<Double> values = this.getSamples(keyword, sampleType);
        int originalSize = values.size();
        if (explicits == null) {
            explicits = Collections.emptySet();
        }
        if (originalSize > explicits.size()) {
            if (originalSize == 1) {
                if (uniqueValue != null) {
                    uniqueValue.value = values.iterator().next();
                }
                return KeywordStatus.UNIQUE;
            }
            return KeywordStatus.BOUNDED;
        }
        HashSet<Double> subtractedSet = new HashSet<Double>(values);
        for (Double explicit : explicits) {
            subtractedSet.remove(explicit - (double)offset);
        }
        if (subtractedSet.size() == 0) {
            return KeywordStatus.SUPPRESSED;
        }
        if (uniqueValue != null && subtractedSet.size() == 1) {
            uniqueValue.value = subtractedSet.iterator().next();
        }
        return originalSize == 1 ? KeywordStatus.UNIQUE : KeywordStatus.BOUNDED;
    }

    @Deprecated
    private final String $$robo$$android_icu_text_PluralRules$getRules(String keyword) {
        return this.rules.getRules(keyword);
    }

    private final void $$robo$$android_icu_text_PluralRules$writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException();
    }

    private final void $$robo$$android_icu_text_PluralRules$readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }

    private final Object $$robo$$android_icu_text_PluralRules$writeReplace() throws ObjectStreamException {
        return new PluralRulesSerialProxy(this.toString());
    }

    @Deprecated
    private final int $$robo$$android_icu_text_PluralRules$compareTo(PluralRules other) {
        return this.toString().compareTo(other.toString());
    }

    @Deprecated
    private final Boolean $$robo$$android_icu_text_PluralRules$isLimited(String keyword) {
        return this.rules.isLimited(keyword, SampleType.INTEGER);
    }

    @Deprecated
    private final boolean $$robo$$android_icu_text_PluralRules$isLimited(String keyword, SampleType sampleType) {
        return this.rules.isLimited(keyword, sampleType);
    }

    @Deprecated
    private final boolean $$robo$$android_icu_text_PluralRules$computeLimited(String keyword, SampleType sampleType) {
        return this.rules.computeLimited(keyword, sampleType);
    }

    static void __staticInitializer__() {
        ALLOWED_ID = new UnicodeSet("[a-z]").freeze();
        NO_CONSTRAINT = new Constraint(){
            public /* synthetic */ Object __robo_data__;
            private static long serialVersionUID = 9163464945387899416L;

            private void $$robo$$android_icu_text_PluralRules_1$__constructor__() {
            }

            private final boolean $$robo$$android_icu_text_PluralRules_1$isFulfilled(IFixedDecimal n) {
                return true;
            }

            private final boolean $$robo$$android_icu_text_PluralRules_1$isLimited(SampleType sampleType) {
                return false;
            }

            private final String $$robo$$android_icu_text_PluralRules_1$toString() {
                return "";
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_PluralRules_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_1$__constructor__(), this);
            }

            @Override
            public boolean isFulfilled(IFixedDecimal iFixedDecimal) {
                return (boolean)InvokeDynamicSupport.bootstrap("isFulfilled", $$robo$$android_icu_text_PluralRules_1$isFulfilled(android.icu.text.PluralRules$IFixedDecimal ), this, iFixedDecimal);
            }

            @Override
            public boolean isLimited(SampleType sampleType) {
                return (boolean)InvokeDynamicSupport.bootstrap("isLimited", $$robo$$android_icu_text_PluralRules_1$isLimited(android.icu.text.PluralRules$SampleType ), this, sampleType);
            }

            public String toString() {
                return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_PluralRules_1$toString(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        DEFAULT_RULE = new Rule("other", NO_CONSTRAINT, null, null);
        DEFAULT = new PluralRules(new RuleList(null).addRule(DEFAULT_RULE));
        AT_SEPARATED = Pattern.compile("\\s*\\Q\\E@\\s*");
        OR_SEPARATED = Pattern.compile("\\s*or\\s*");
        AND_SEPARATED = Pattern.compile("\\s*and\\s*");
        COMMA_SEPARATED = Pattern.compile("\\s*,\\s*");
        DOTDOT_SEPARATED = Pattern.compile("\\s*\\Q..\\E\\s*");
        TILDE_SEPARATED = Pattern.compile("\\s*~\\s*");
        SEMI_SEPARATED = Pattern.compile("\\s*;\\s*");
    }

    public static PluralRules parseDescription(String string2) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseDescription", $$robo$$android_icu_text_PluralRules$parseDescription(java.lang.String ), (String)string2);
    }

    public static PluralRules createRules(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createRules", $$robo$$android_icu_text_PluralRules$createRules(java.lang.String ), (String)string2);
    }

    private static Constraint parseConstraint(String string2) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseConstraint", $$robo$$android_icu_text_PluralRules$parseConstraint(java.lang.String ), (String)string2);
    }

    private static ParseException unexpected(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("unexpected", $$robo$$android_icu_text_PluralRules$unexpected(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    private static String nextToken(String[] stringArray, int n, String string2) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("nextToken", $$robo$$android_icu_text_PluralRules$nextToken(java.lang.String[] int java.lang.String ), (String[])stringArray, (int)n, (String)string2);
    }

    private static Rule parseRule(String string2) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseRule", $$robo$$android_icu_text_PluralRules$parseRule(java.lang.String ), (String)string2);
    }

    private static RuleList parseRuleChain(String string2) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseRuleChain", $$robo$$android_icu_text_PluralRules$parseRuleChain(java.lang.String ), (String)string2);
    }

    private static void addRange(StringBuilder stringBuilder, double d, double d2, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("addRange", $$robo$$android_icu_text_PluralRules$addRange(java.lang.StringBuilder double double boolean ), (StringBuilder)stringBuilder, (double)d, (double)d2, (boolean)bl);
    }

    private static String format(double d) {
        return InvokeDynamicSupport.bootstrapStatic("format", $$robo$$android_icu_text_PluralRules$format(double ), (double)d);
    }

    private boolean addConditional(Set<IFixedDecimal> set, Set<IFixedDecimal> set2, double d) {
        return (boolean)InvokeDynamicSupport.bootstrap("addConditional", $$robo$$android_icu_text_PluralRules$addConditional(java.util.Set<android.icu.text.PluralRules$IFixedDecimal> java.util.Set<android.icu.text.PluralRules$IFixedDecimal> double ), this, set, set2, d);
    }

    public static PluralRules forLocale(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("forLocale", $$robo$$android_icu_text_PluralRules$forLocale(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    public static PluralRules forLocale(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("forLocale", $$robo$$android_icu_text_PluralRules$forLocale(java.util.Locale ), (Locale)locale);
    }

    public static PluralRules forLocale(ULocale uLocale, PluralType pluralType) {
        return InvokeDynamicSupport.bootstrapStatic("forLocale", $$robo$$android_icu_text_PluralRules$forLocale(android.icu.util.ULocale android.icu.text.PluralRules$PluralType ), (ULocale)uLocale, (PluralType)pluralType);
    }

    public static PluralRules forLocale(Locale locale, PluralType pluralType) {
        return InvokeDynamicSupport.bootstrapStatic("forLocale", $$robo$$android_icu_text_PluralRules$forLocale(java.util.Locale android.icu.text.PluralRules$PluralType ), (Locale)locale, (PluralType)pluralType);
    }

    private static boolean isValidKeyword(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidKeyword", $$robo$$android_icu_text_PluralRules$isValidKeyword(java.lang.String ), (String)string2);
    }

    private void __constructor__(RuleList ruleList) {
        this.$$robo$$android_icu_text_PluralRules$__constructor__(ruleList);
    }

    public PluralRules(RuleList ruleList) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules$__constructor__(android.icu.text.PluralRules$RuleList ), this, ruleList);
    }

    @Deprecated
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_PluralRules$hashCode(), this);
    }

    public String select(double d) {
        return InvokeDynamicSupport.bootstrap("select", $$robo$$android_icu_text_PluralRules$select(double ), this, d);
    }

    @Deprecated
    public String select(double d, int n, long l) {
        return InvokeDynamicSupport.bootstrap("select", $$robo$$android_icu_text_PluralRules$select(double int long ), this, d, n, l);
    }

    @Deprecated
    public String select(IFixedDecimal iFixedDecimal) {
        return InvokeDynamicSupport.bootstrap("select", $$robo$$android_icu_text_PluralRules$select(android.icu.text.PluralRules$IFixedDecimal ), this, iFixedDecimal);
    }

    @Deprecated
    public boolean matches(FixedDecimal fixedDecimal, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_PluralRules$matches(android.icu.text.PluralRules$FixedDecimal java.lang.String ), this, fixedDecimal, string2);
    }

    public Set<String> getKeywords() {
        return InvokeDynamicSupport.bootstrap("getKeywords", $$robo$$android_icu_text_PluralRules$getKeywords(), this);
    }

    public double getUniqueKeywordValue(String string2) {
        return (double)InvokeDynamicSupport.bootstrap("getUniqueKeywordValue", $$robo$$android_icu_text_PluralRules$getUniqueKeywordValue(java.lang.String ), this, string2);
    }

    public Collection<Double> getAllKeywordValues(String string2) {
        return InvokeDynamicSupport.bootstrap("getAllKeywordValues", $$robo$$android_icu_text_PluralRules$getAllKeywordValues(java.lang.String ), this, string2);
    }

    @Deprecated
    public Collection<Double> getAllKeywordValues(String string2, SampleType sampleType) {
        return InvokeDynamicSupport.bootstrap("getAllKeywordValues", $$robo$$android_icu_text_PluralRules$getAllKeywordValues(java.lang.String android.icu.text.PluralRules$SampleType ), this, string2, sampleType);
    }

    public Collection<Double> getSamples(String string2) {
        return InvokeDynamicSupport.bootstrap("getSamples", $$robo$$android_icu_text_PluralRules$getSamples(java.lang.String ), this, string2);
    }

    @Deprecated
    public Collection<Double> getSamples(String string2, SampleType sampleType) {
        return InvokeDynamicSupport.bootstrap("getSamples", $$robo$$android_icu_text_PluralRules$getSamples(java.lang.String android.icu.text.PluralRules$SampleType ), this, string2, sampleType);
    }

    @Deprecated
    public boolean addSample(String string2, Number number, int n, Set<Double> set) {
        return (boolean)InvokeDynamicSupport.bootstrap("addSample", $$robo$$android_icu_text_PluralRules$addSample(java.lang.String java.lang.Number int java.util.Set<java.lang.Double> ), this, string2, number, n, set);
    }

    @Deprecated
    public FixedDecimalSamples getDecimalSamples(String string2, SampleType sampleType) {
        return InvokeDynamicSupport.bootstrap("getDecimalSamples", $$robo$$android_icu_text_PluralRules$getDecimalSamples(java.lang.String android.icu.text.PluralRules$SampleType ), this, string2, sampleType);
    }

    public static ULocale[] getAvailableULocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableULocales", $$robo$$android_icu_text_PluralRules$getAvailableULocales());
    }

    public static ULocale getFunctionalEquivalent(ULocale uLocale, boolean[] blArray) {
        return InvokeDynamicSupport.bootstrapStatic("getFunctionalEquivalent", $$robo$$android_icu_text_PluralRules$getFunctionalEquivalent(android.icu.util.ULocale boolean[] ), (ULocale)uLocale, (boolean[])blArray);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_PluralRules$toString(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_PluralRules$equals(java.lang.Object ), this, object);
    }

    public boolean equals(PluralRules pluralRules) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_PluralRules$equals(android.icu.text.PluralRules ), this, pluralRules);
    }

    public KeywordStatus getKeywordStatus(String string2, int n, Set<Double> set, Output<Double> output) {
        return InvokeDynamicSupport.bootstrap("getKeywordStatus", $$robo$$android_icu_text_PluralRules$getKeywordStatus(java.lang.String int java.util.Set<java.lang.Double> android.icu.util.Output<java.lang.Double> ), this, string2, n, set, output);
    }

    @Deprecated
    public KeywordStatus getKeywordStatus(String string2, int n, Set<Double> set, Output<Double> output, SampleType sampleType) {
        return InvokeDynamicSupport.bootstrap("getKeywordStatus", $$robo$$android_icu_text_PluralRules$getKeywordStatus(java.lang.String int java.util.Set<java.lang.Double> android.icu.util.Output<java.lang.Double> android.icu.text.PluralRules$SampleType ), this, string2, n, set, output, sampleType);
    }

    @Deprecated
    public String getRules(String string2) {
        return InvokeDynamicSupport.bootstrap("getRules", $$robo$$android_icu_text_PluralRules$getRules(java.lang.String ), this, string2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeObject", $$robo$$android_icu_text_PluralRules$writeObject(java.io.ObjectOutputStream ), this, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_PluralRules$readObject(java.io.ObjectInputStream ), this, objectInputStream);
    }

    private Object writeReplace() throws ObjectStreamException {
        return InvokeDynamicSupport.bootstrap("writeReplace", $$robo$$android_icu_text_PluralRules$writeReplace(), this);
    }

    @Deprecated
    public int compareTo(PluralRules pluralRules) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_text_PluralRules$compareTo(android.icu.text.PluralRules ), this, pluralRules);
    }

    @Deprecated
    public Boolean isLimited(String string2) {
        return InvokeDynamicSupport.bootstrap("isLimited", $$robo$$android_icu_text_PluralRules$isLimited(java.lang.String ), this, string2);
    }

    @Deprecated
    public boolean isLimited(String string2, SampleType sampleType) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLimited", $$robo$$android_icu_text_PluralRules$isLimited(java.lang.String android.icu.text.PluralRules$SampleType ), this, string2, sampleType);
    }

    @Deprecated
    public boolean computeLimited(String string2, SampleType sampleType) {
        return (boolean)InvokeDynamicSupport.bootstrap("computeLimited", $$robo$$android_icu_text_PluralRules$computeLimited(java.lang.String android.icu.text.PluralRules$SampleType ), this, string2, sampleType);
    }

    static {
        RobolectricInternals.classInitializing(PluralRules.class);
    }

    public /* synthetic */ PluralRules() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PluralRules)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class KeywordStatus
    extends Enum<KeywordStatus> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ KeywordStatus INVALID;
        public static /* enum */ KeywordStatus SUPPRESSED;
        public static /* enum */ KeywordStatus UNIQUE;
        public static /* enum */ KeywordStatus BOUNDED;
        public static /* enum */ KeywordStatus UNBOUNDED;
        private static /* synthetic */ KeywordStatus[] $VALUES;

        private static final KeywordStatus[] $$robo$$android_icu_text_PluralRules_KeywordStatus$values() {
            return (KeywordStatus[])$VALUES.clone();
        }

        private static final KeywordStatus $$robo$$android_icu_text_PluralRules_KeywordStatus$valueOf(String name) {
            return Enum.valueOf(KeywordStatus.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_PluralRules_KeywordStatus$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            INVALID = new KeywordStatus();
            SUPPRESSED = new KeywordStatus();
            UNIQUE = new KeywordStatus();
            BOUNDED = new KeywordStatus();
            UNBOUNDED = new KeywordStatus();
            $VALUES = new KeywordStatus[]{INVALID, SUPPRESSED, UNIQUE, BOUNDED, UNBOUNDED};
        }

        public static KeywordStatus[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_PluralRules_KeywordStatus$values());
        }

        public static KeywordStatus valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_PluralRules_KeywordStatus$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_PluralRules_KeywordStatus$__constructor__(string2, n);
        }

        public KeywordStatus() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_KeywordStatus$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(KeywordStatus.class);
        }

        public /* synthetic */ KeywordStatus() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeywordStatus)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class RuleList
    implements Serializable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean hasExplicitBoundingInfo;
        private static long serialVersionUID = 1L;
        private List<Rule> rules;

        private void $$robo$$android_icu_text_PluralRules_RuleList$__constructor__() {
            this.hasExplicitBoundingInfo = false;
            this.rules = new ArrayList<Rule>();
        }

        private final RuleList $$robo$$android_icu_text_PluralRules_RuleList$addRule(Rule nextRule) {
            String keyword = nextRule.getKeyword();
            for (Rule rule : this.rules) {
                if (!keyword.equals(rule.getKeyword())) continue;
                throw new IllegalArgumentException("Duplicate keyword: " + keyword);
            }
            this.rules.add(nextRule);
            return this;
        }

        private final RuleList $$robo$$android_icu_text_PluralRules_RuleList$finish() throws ParseException {
            Rule otherRule = null;
            Iterator<Rule> it = this.rules.iterator();
            while (it.hasNext()) {
                Rule rule = it.next();
                if (!"other".equals(rule.getKeyword())) continue;
                otherRule = rule;
                it.remove();
            }
            if (otherRule == null) {
                otherRule = PluralRules.parseRule("other:");
            }
            this.rules.add(otherRule);
            return this;
        }

        private final Rule $$robo$$android_icu_text_PluralRules_RuleList$selectRule(IFixedDecimal n) {
            for (Rule rule : this.rules) {
                if (!rule.appliesTo(n)) continue;
                return rule;
            }
            return null;
        }

        private final String $$robo$$android_icu_text_PluralRules_RuleList$select(IFixedDecimal n) {
            if (n.isInfinite() || n.isNaN()) {
                return "other";
            }
            Rule r = this.selectRule(n);
            return r.getKeyword();
        }

        private final Set<String> $$robo$$android_icu_text_PluralRules_RuleList$getKeywords() {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (Rule rule : this.rules) {
                result.add(rule.getKeyword());
            }
            return result;
        }

        private final boolean $$robo$$android_icu_text_PluralRules_RuleList$isLimited(String keyword, SampleType sampleType) {
            if (this.hasExplicitBoundingInfo) {
                FixedDecimalSamples mySamples = this.getDecimalSamples(keyword, sampleType);
                return mySamples == null ? true : mySamples.bounded;
            }
            return this.computeLimited(keyword, sampleType);
        }

        private final boolean $$robo$$android_icu_text_PluralRules_RuleList$computeLimited(String keyword, SampleType sampleType) {
            boolean result = false;
            for (Rule rule : this.rules) {
                if (!keyword.equals(rule.getKeyword())) continue;
                if (!rule.isLimited(sampleType)) {
                    return false;
                }
                result = true;
            }
            return result;
        }

        private final String $$robo$$android_icu_text_PluralRules_RuleList$toString() {
            StringBuilder builder = new StringBuilder();
            for (Rule rule : this.rules) {
                if (builder.length() != 0) {
                    builder.append(";  ");
                }
                builder.append(rule);
            }
            return builder.toString();
        }

        private final String $$robo$$android_icu_text_PluralRules_RuleList$getRules(String keyword) {
            for (Rule rule : this.rules) {
                if (!rule.getKeyword().equals(keyword)) continue;
                return rule.getConstraint();
            }
            return null;
        }

        private final boolean $$robo$$android_icu_text_PluralRules_RuleList$select(IFixedDecimal sample, String keyword) {
            for (Rule rule : this.rules) {
                if (!rule.getKeyword().equals(keyword) || !rule.appliesTo(sample)) continue;
                return true;
            }
            return false;
        }

        private final FixedDecimalSamples $$robo$$android_icu_text_PluralRules_RuleList$getDecimalSamples(String keyword, SampleType sampleType) {
            for (Rule rule : this.rules) {
                if (!rule.getKeyword().equals(keyword)) continue;
                return sampleType == SampleType.INTEGER ? rule.integerSamples : rule.decimalSamples;
            }
            return null;
        }

        private /* synthetic */ void $$robo$$android_icu_text_PluralRules_RuleList$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_PluralRules_RuleList$__constructor__();
        }

        public RuleList() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_RuleList$__constructor__(), this);
        }

        public RuleList addRule(Rule rule) {
            return InvokeDynamicSupport.bootstrap("addRule", $$robo$$android_icu_text_PluralRules_RuleList$addRule(android.icu.text.PluralRules$Rule ), this, rule);
        }

        public RuleList finish() throws ParseException {
            return InvokeDynamicSupport.bootstrap("finish", $$robo$$android_icu_text_PluralRules_RuleList$finish(), this);
        }

        private Rule selectRule(IFixedDecimal iFixedDecimal) {
            return InvokeDynamicSupport.bootstrap("selectRule", $$robo$$android_icu_text_PluralRules_RuleList$selectRule(android.icu.text.PluralRules$IFixedDecimal ), this, iFixedDecimal);
        }

        public String select(IFixedDecimal iFixedDecimal) {
            return InvokeDynamicSupport.bootstrap("select", $$robo$$android_icu_text_PluralRules_RuleList$select(android.icu.text.PluralRules$IFixedDecimal ), this, iFixedDecimal);
        }

        public Set<String> getKeywords() {
            return InvokeDynamicSupport.bootstrap("getKeywords", $$robo$$android_icu_text_PluralRules_RuleList$getKeywords(), this);
        }

        public boolean isLimited(String string2, SampleType sampleType) {
            return (boolean)InvokeDynamicSupport.bootstrap("isLimited", $$robo$$android_icu_text_PluralRules_RuleList$isLimited(java.lang.String android.icu.text.PluralRules$SampleType ), this, string2, sampleType);
        }

        public boolean computeLimited(String string2, SampleType sampleType) {
            return (boolean)InvokeDynamicSupport.bootstrap("computeLimited", $$robo$$android_icu_text_PluralRules_RuleList$computeLimited(java.lang.String android.icu.text.PluralRules$SampleType ), this, string2, sampleType);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_PluralRules_RuleList$toString(), this);
        }

        public String getRules(String string2) {
            return InvokeDynamicSupport.bootstrap("getRules", $$robo$$android_icu_text_PluralRules_RuleList$getRules(java.lang.String ), this, string2);
        }

        public boolean select(IFixedDecimal iFixedDecimal, String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("select", $$robo$$android_icu_text_PluralRules_RuleList$select(android.icu.text.PluralRules$IFixedDecimal java.lang.String ), this, iFixedDecimal, string2);
        }

        public FixedDecimalSamples getDecimalSamples(String string2, SampleType sampleType) {
            return InvokeDynamicSupport.bootstrap("getDecimalSamples", $$robo$$android_icu_text_PluralRules_RuleList$getDecimalSamples(java.lang.String android.icu.text.PluralRules$SampleType ), this, string2, sampleType);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_PluralRules_RuleList$__constructor__(var1_1);
        }

        public /* synthetic */ RuleList(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_RuleList$__constructor__(android.icu.text.PluralRules$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RuleList)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Rule
    implements Serializable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static long serialVersionUID = 1L;
        private String keyword;
        private Constraint constraint;
        private FixedDecimalSamples integerSamples;
        private FixedDecimalSamples decimalSamples;

        private void $$robo$$android_icu_text_PluralRules_Rule$__constructor__(String keyword, Constraint constraint, FixedDecimalSamples integerSamples, FixedDecimalSamples decimalSamples) {
            this.keyword = keyword;
            this.constraint = constraint;
            this.integerSamples = integerSamples;
            this.decimalSamples = decimalSamples;
        }

        private final Rule $$robo$$android_icu_text_PluralRules_Rule$and(Constraint c) {
            return new Rule(this.keyword, new AndConstraint(this.constraint, c), this.integerSamples, this.decimalSamples);
        }

        private final Rule $$robo$$android_icu_text_PluralRules_Rule$or(Constraint c) {
            return new Rule(this.keyword, new OrConstraint(this.constraint, c), this.integerSamples, this.decimalSamples);
        }

        private final String $$robo$$android_icu_text_PluralRules_Rule$getKeyword() {
            return this.keyword;
        }

        private final boolean $$robo$$android_icu_text_PluralRules_Rule$appliesTo(IFixedDecimal n) {
            return this.constraint.isFulfilled(n);
        }

        private final boolean $$robo$$android_icu_text_PluralRules_Rule$isLimited(SampleType sampleType) {
            return this.constraint.isLimited(sampleType);
        }

        private final String $$robo$$android_icu_text_PluralRules_Rule$toString() {
            return this.keyword + ": " + this.constraint.toString() + (this.integerSamples == null ? "" : " " + this.integerSamples.toString()) + (this.decimalSamples == null ? "" : " " + this.decimalSamples.toString());
        }

        @Deprecated
        private final int $$robo$$android_icu_text_PluralRules_Rule$hashCode() {
            return this.keyword.hashCode() ^ this.constraint.hashCode();
        }

        private final String $$robo$$android_icu_text_PluralRules_Rule$getConstraint() {
            return this.constraint.toString();
        }

        private void __constructor__(String string2, Constraint constraint, FixedDecimalSamples fixedDecimalSamples, FixedDecimalSamples fixedDecimalSamples2) {
            this.$$robo$$android_icu_text_PluralRules_Rule$__constructor__(string2, constraint, fixedDecimalSamples, fixedDecimalSamples2);
        }

        public Rule(String string2, Constraint constraint, FixedDecimalSamples fixedDecimalSamples, FixedDecimalSamples fixedDecimalSamples2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_Rule$__constructor__(java.lang.String android.icu.text.PluralRules$Constraint android.icu.text.PluralRules$FixedDecimalSamples android.icu.text.PluralRules$FixedDecimalSamples ), this, string2, constraint, fixedDecimalSamples, fixedDecimalSamples2);
        }

        public Rule and(Constraint constraint) {
            return InvokeDynamicSupport.bootstrap("and", $$robo$$android_icu_text_PluralRules_Rule$and(android.icu.text.PluralRules$Constraint ), this, constraint);
        }

        public Rule or(Constraint constraint) {
            return InvokeDynamicSupport.bootstrap("or", $$robo$$android_icu_text_PluralRules_Rule$or(android.icu.text.PluralRules$Constraint ), this, constraint);
        }

        public String getKeyword() {
            return InvokeDynamicSupport.bootstrap("getKeyword", $$robo$$android_icu_text_PluralRules_Rule$getKeyword(), this);
        }

        public boolean appliesTo(IFixedDecimal iFixedDecimal) {
            return (boolean)InvokeDynamicSupport.bootstrap("appliesTo", $$robo$$android_icu_text_PluralRules_Rule$appliesTo(android.icu.text.PluralRules$IFixedDecimal ), this, iFixedDecimal);
        }

        public boolean isLimited(SampleType sampleType) {
            return (boolean)InvokeDynamicSupport.bootstrap("isLimited", $$robo$$android_icu_text_PluralRules_Rule$isLimited(android.icu.text.PluralRules$SampleType ), this, sampleType);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_PluralRules_Rule$toString(), this);
        }

        @Deprecated
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_PluralRules_Rule$hashCode(), this);
        }

        public String getConstraint() {
            return InvokeDynamicSupport.bootstrap("getConstraint", $$robo$$android_icu_text_PluralRules_Rule$getConstraint(), this);
        }

        public /* synthetic */ Rule() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Rule)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class OrConstraint
    extends BinaryConstraint
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static long serialVersionUID = 1405488568664762222L;

        private void $$robo$$android_icu_text_PluralRules_OrConstraint$__constructor__(Constraint a, Constraint b) {
        }

        private final boolean $$robo$$android_icu_text_PluralRules_OrConstraint$isFulfilled(IFixedDecimal n) {
            return this.a.isFulfilled(n) || this.b.isFulfilled(n);
        }

        private final boolean $$robo$$android_icu_text_PluralRules_OrConstraint$isLimited(SampleType sampleType) {
            return this.a.isLimited(sampleType) && this.b.isLimited(sampleType);
        }

        private final String $$robo$$android_icu_text_PluralRules_OrConstraint$toString() {
            return this.a.toString() + " or " + this.b.toString();
        }

        private void __constructor__(Constraint constraint, Constraint constraint2) {
            this.$$robo$$android_icu_text_PluralRules_OrConstraint$__constructor__(constraint, constraint2);
        }

        public OrConstraint(Constraint constraint, Constraint constraint2) {
            super(constraint, constraint2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_OrConstraint$__constructor__(android.icu.text.PluralRules$Constraint android.icu.text.PluralRules$Constraint ), this, constraint, constraint2);
        }

        @Override
        public boolean isFulfilled(IFixedDecimal iFixedDecimal) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFulfilled", $$robo$$android_icu_text_PluralRules_OrConstraint$isFulfilled(android.icu.text.PluralRules$IFixedDecimal ), this, iFixedDecimal);
        }

        @Override
        public boolean isLimited(SampleType sampleType) {
            return (boolean)InvokeDynamicSupport.bootstrap("isLimited", $$robo$$android_icu_text_PluralRules_OrConstraint$isLimited(android.icu.text.PluralRules$SampleType ), this, sampleType);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_PluralRules_OrConstraint$toString(), this);
        }

        public /* synthetic */ OrConstraint() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OrConstraint)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AndConstraint
    extends BinaryConstraint
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static long serialVersionUID = 7766999779862263523L;

        private void $$robo$$android_icu_text_PluralRules_AndConstraint$__constructor__(Constraint a, Constraint b) {
        }

        private final boolean $$robo$$android_icu_text_PluralRules_AndConstraint$isFulfilled(IFixedDecimal n) {
            return this.a.isFulfilled(n) && this.b.isFulfilled(n);
        }

        private final boolean $$robo$$android_icu_text_PluralRules_AndConstraint$isLimited(SampleType sampleType) {
            return this.a.isLimited(sampleType) || this.b.isLimited(sampleType);
        }

        private final String $$robo$$android_icu_text_PluralRules_AndConstraint$toString() {
            return this.a.toString() + " and " + this.b.toString();
        }

        private void __constructor__(Constraint constraint, Constraint constraint2) {
            this.$$robo$$android_icu_text_PluralRules_AndConstraint$__constructor__(constraint, constraint2);
        }

        public AndConstraint(Constraint constraint, Constraint constraint2) {
            super(constraint, constraint2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_AndConstraint$__constructor__(android.icu.text.PluralRules$Constraint android.icu.text.PluralRules$Constraint ), this, constraint, constraint2);
        }

        @Override
        public boolean isFulfilled(IFixedDecimal iFixedDecimal) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFulfilled", $$robo$$android_icu_text_PluralRules_AndConstraint$isFulfilled(android.icu.text.PluralRules$IFixedDecimal ), this, iFixedDecimal);
        }

        @Override
        public boolean isLimited(SampleType sampleType) {
            return (boolean)InvokeDynamicSupport.bootstrap("isLimited", $$robo$$android_icu_text_PluralRules_AndConstraint$isLimited(android.icu.text.PluralRules$SampleType ), this, sampleType);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_PluralRules_AndConstraint$toString(), this);
        }

        public /* synthetic */ AndConstraint() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndConstraint)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class BinaryConstraint
    implements Constraint,
    Serializable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static long serialVersionUID = 1L;
        protected Constraint a;
        protected Constraint b;

        private void $$robo$$android_icu_text_PluralRules_BinaryConstraint$__constructor__(Constraint a, Constraint b) {
            this.a = a;
            this.b = b;
        }

        private void __constructor__(Constraint constraint, Constraint constraint2) {
            this.$$robo$$android_icu_text_PluralRules_BinaryConstraint$__constructor__(constraint, constraint2);
        }

        public BinaryConstraint(Constraint constraint, Constraint constraint2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_BinaryConstraint$__constructor__(android.icu.text.PluralRules$Constraint android.icu.text.PluralRules$Constraint ), this, constraint, constraint2);
        }

        public /* synthetic */ BinaryConstraint() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BinaryConstraint)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class RangeConstraint
    implements Constraint,
    Serializable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static long serialVersionUID = 1L;
        private int mod;
        private boolean inRange;
        private boolean integersOnly;
        private double lowerBound;
        private double upperBound;
        private long[] range_list;
        private Operand operand;

        private void $$robo$$android_icu_text_PluralRules_RangeConstraint$__constructor__(int mod, boolean inRange, Operand operand, boolean integersOnly, double lowBound, double highBound, long[] vals) {
            this.mod = mod;
            this.inRange = inRange;
            this.integersOnly = integersOnly;
            this.lowerBound = lowBound;
            this.upperBound = highBound;
            this.range_list = vals;
            this.operand = operand;
        }

        private final boolean $$robo$$android_icu_text_PluralRules_RangeConstraint$isFulfilled(IFixedDecimal number) {
            boolean test;
            double n = number.getPluralOperand(this.operand);
            if (this.integersOnly && n - (double)((long)n) != 0.0 || this.operand == Operand.j && number.getPluralOperand(Operand.v) != 0.0) {
                return !this.inRange;
            }
            if (this.mod != 0) {
                n %= (double)this.mod;
            }
            boolean bl = test = n >= this.lowerBound && n <= this.upperBound;
            if (test && this.range_list != null) {
                test = false;
                for (int i = 0; !test && i < this.range_list.length; i += 2) {
                    test = n >= (double)this.range_list[i] && n <= (double)this.range_list[i + 1];
                }
            }
            return this.inRange == test;
        }

        private final boolean $$robo$$android_icu_text_PluralRules_RangeConstraint$isLimited(SampleType sampleType) {
            boolean valueIsZero = this.lowerBound == this.upperBound && this.lowerBound == 0.0;
            boolean hasDecimals = (this.operand == Operand.v || this.operand == Operand.w || this.operand == Operand.f || this.operand == Operand.t) && this.inRange != valueIsZero;
            switch (2.$SwitchMap$android$icu$text$PluralRules$SampleType[sampleType.ordinal()]) {
                case 1: {
                    return hasDecimals || (this.operand == Operand.n || this.operand == Operand.i || this.operand == Operand.j) && this.mod == 0 && this.inRange;
                }
                case 2: {
                    return !(hasDecimals && this.operand != Operand.n && this.operand != Operand.j || !this.integersOnly && this.lowerBound != this.upperBound || this.mod != 0 || !this.inRange);
                }
            }
            return false;
        }

        private final String $$robo$$android_icu_text_PluralRules_RangeConstraint$toString() {
            boolean isList;
            StringBuilder result = new StringBuilder();
            result.append((Object)this.operand);
            if (this.mod != 0) {
                result.append(" % ").append(this.mod);
            }
            boolean bl = isList = this.lowerBound != this.upperBound;
            result.append(!isList ? (this.inRange ? " = " : " != ") : (this.integersOnly ? (this.inRange ? " = " : " != ") : (this.inRange ? " within " : " not within ")));
            if (this.range_list != null) {
                for (int i = 0; i < this.range_list.length; i += 2) {
                    PluralRules.addRange(result, this.range_list[i], this.range_list[i + 1], i != 0);
                }
            } else {
                PluralRules.addRange(result, this.lowerBound, this.upperBound, false);
            }
            return result.toString();
        }

        private void __constructor__(int n, boolean bl, Operand operand, boolean bl2, double d, double d2, long[] lArray) {
            this.$$robo$$android_icu_text_PluralRules_RangeConstraint$__constructor__(n, bl, operand, bl2, d, d2, lArray);
        }

        public RangeConstraint(int n, boolean bl, Operand operand, boolean bl2, double d, double d2, long[] lArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_RangeConstraint$__constructor__(int boolean android.icu.text.PluralRules$Operand boolean double double long[] ), this, n, bl, operand, bl2, d, d2, lArray);
        }

        @Override
        public boolean isFulfilled(IFixedDecimal iFixedDecimal) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFulfilled", $$robo$$android_icu_text_PluralRules_RangeConstraint$isFulfilled(android.icu.text.PluralRules$IFixedDecimal ), this, iFixedDecimal);
        }

        @Override
        public boolean isLimited(SampleType sampleType) {
            return (boolean)InvokeDynamicSupport.bootstrap("isLimited", $$robo$$android_icu_text_PluralRules_RangeConstraint$isLimited(android.icu.text.PluralRules$SampleType ), this, sampleType);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_PluralRules_RangeConstraint$toString(), this);
        }

        public /* synthetic */ RangeConstraint() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RangeConstraint)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SimpleTokenizer
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        static UnicodeSet BREAK_AND_IGNORE;
        static UnicodeSet BREAK_AND_KEEP;

        private void $$robo$$android_icu_text_PluralRules_SimpleTokenizer$__constructor__() {
        }

        private static final String[] $$robo$$android_icu_text_PluralRules_SimpleTokenizer$split(String source) {
            int last = -1;
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < source.length(); ++i) {
                char ch = source.charAt(i);
                if (BREAK_AND_IGNORE.contains(ch)) {
                    if (last < 0) continue;
                    result.add(source.substring(last, i));
                    last = -1;
                    continue;
                }
                if (BREAK_AND_KEEP.contains(ch)) {
                    if (last >= 0) {
                        result.add(source.substring(last, i));
                    }
                    result.add(source.substring(i, i + 1));
                    last = -1;
                    continue;
                }
                if (last >= 0) continue;
                last = i;
            }
            if (last >= 0) {
                result.add(source.substring(last));
            }
            return result.toArray(new String[result.size()]);
        }

        static void __staticInitializer__() {
            BREAK_AND_IGNORE = new UnicodeSet(9, 10, 12, 13, 32, 32).freeze();
            BREAK_AND_KEEP = new UnicodeSet(33, 33, 37, 37, 44, 44, 46, 46, 61, 61).freeze();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_PluralRules_SimpleTokenizer$__constructor__();
        }

        public SimpleTokenizer() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_SimpleTokenizer$__constructor__(), this);
        }

        static String[] split(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("split", $$robo$$android_icu_text_PluralRules_SimpleTokenizer$split(java.lang.String ), (String)string2);
        }

        static {
            RobolectricInternals.classInitializing(SimpleTokenizer.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleTokenizer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface Constraint
    extends Serializable {
        public boolean isFulfilled(IFixedDecimal var1);

        public boolean isLimited(SampleType var1);
    }

    @Deprecated
    public static class FixedDecimalSamples
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        @Deprecated
        public SampleType sampleType;
        @Deprecated
        public Set<FixedDecimalRange> samples;
        @Deprecated
        public boolean bounded;

        private void $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$__constructor__(SampleType sampleType, Set<FixedDecimalRange> samples, boolean bounded) {
            this.sampleType = sampleType;
            this.samples = samples;
            this.bounded = bounded;
        }

        private static final FixedDecimalSamples $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$parse(String source) {
            SampleType sampleType2;
            boolean bounded2 = true;
            boolean haveBound = false;
            LinkedHashSet<FixedDecimalRange> samples2 = new LinkedHashSet<FixedDecimalRange>();
            if (source.startsWith("integer")) {
                sampleType2 = SampleType.INTEGER;
            } else if (source.startsWith("decimal")) {
                sampleType2 = SampleType.DECIMAL;
            } else {
                throw new IllegalArgumentException("Samples must start with 'integer' or 'decimal'");
            }
            source = source.substring(7).trim();
            block4: for (String range : COMMA_SEPARATED.split(source)) {
                if (range.equals("\u2026") || range.equals("...")) {
                    bounded2 = false;
                    haveBound = true;
                    continue;
                }
                if (haveBound) {
                    throw new IllegalArgumentException("Can only have \u2026 at the end of samples: " + range);
                }
                String[] rangeParts = TILDE_SEPARATED.split(range);
                switch (rangeParts.length) {
                    case 1: {
                        FixedDecimal sample = new FixedDecimal(rangeParts[0]);
                        FixedDecimalSamples.checkDecimal(sampleType2, sample);
                        samples2.add(new FixedDecimalRange(sample, sample));
                        continue block4;
                    }
                    case 2: {
                        FixedDecimal start = new FixedDecimal(rangeParts[0]);
                        FixedDecimal end = new FixedDecimal(rangeParts[1]);
                        FixedDecimalSamples.checkDecimal(sampleType2, start);
                        FixedDecimalSamples.checkDecimal(sampleType2, end);
                        samples2.add(new FixedDecimalRange(start, end));
                        continue block4;
                    }
                    default: {
                        throw new IllegalArgumentException("Ill-formed number range: " + range);
                    }
                }
            }
            return new FixedDecimalSamples(sampleType2, Collections.unmodifiableSet(samples2), bounded2);
        }

        private static final void $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$checkDecimal(SampleType sampleType2, FixedDecimal sample) {
            if (sampleType2 == SampleType.INTEGER != (sample.getVisibleDecimalDigitCount() == 0)) {
                throw new IllegalArgumentException("Ill-formed number range: " + sample);
            }
        }

        @Deprecated
        private final Set<Double> $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$addSamples(Set<Double> result) {
            for (FixedDecimalRange item : this.samples) {
                long startDouble = item.start.getShiftedValue();
                long endDouble = item.end.getShiftedValue();
                for (long d = startDouble; d <= endDouble; ++d) {
                    result.add((double)d / (double)item.start.baseFactor);
                }
            }
            return result;
        }

        @Deprecated
        private final String $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$toString() {
            StringBuilder b = new StringBuilder("@").append(this.sampleType.toString().toLowerCase(Locale.ENGLISH));
            boolean first = true;
            for (FixedDecimalRange item : this.samples) {
                if (first) {
                    first = false;
                } else {
                    b.append(",");
                }
                b.append(' ').append(item);
            }
            if (!this.bounded) {
                b.append(", \u2026");
            }
            return b.toString();
        }

        @Deprecated
        private final Set<FixedDecimalRange> $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$getSamples() {
            return this.samples;
        }

        @Deprecated
        private final void $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$getStartEndSamples(Set<FixedDecimal> target) {
            for (FixedDecimalRange item : this.samples) {
                target.add(item.start);
                target.add(item.end);
            }
        }

        private void __constructor__(SampleType sampleType, Set<FixedDecimalRange> set, boolean bl) {
            this.$$robo$$android_icu_text_PluralRules_FixedDecimalSamples$__constructor__(sampleType, set, bl);
        }

        public FixedDecimalSamples(SampleType sampleType, Set<FixedDecimalRange> set, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$__constructor__(android.icu.text.PluralRules$SampleType java.util.Set<android.icu.text.PluralRules$FixedDecimalRange> boolean ), this, sampleType, set, bl);
        }

        static FixedDecimalSamples parse(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$parse(java.lang.String ), (String)string2);
        }

        private static void checkDecimal(SampleType sampleType, FixedDecimal fixedDecimal) {
            InvokeDynamicSupport.bootstrapStatic("checkDecimal", $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$checkDecimal(android.icu.text.PluralRules$SampleType android.icu.text.PluralRules$FixedDecimal ), (SampleType)sampleType, (FixedDecimal)fixedDecimal);
        }

        @Deprecated
        public Set<Double> addSamples(Set<Double> set) {
            return InvokeDynamicSupport.bootstrap("addSamples", $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$addSamples(java.util.Set<java.lang.Double> ), this, set);
        }

        @Deprecated
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$toString(), this);
        }

        @Deprecated
        public Set<FixedDecimalRange> getSamples() {
            return InvokeDynamicSupport.bootstrap("getSamples", $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$getSamples(), this);
        }

        @Deprecated
        public void getStartEndSamples(Set<FixedDecimal> set) {
            InvokeDynamicSupport.bootstrap("getStartEndSamples", $$robo$$android_icu_text_PluralRules_FixedDecimalSamples$getStartEndSamples(java.util.Set<android.icu.text.PluralRules$FixedDecimal> ), this, set);
        }

        public /* synthetic */ FixedDecimalSamples() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FixedDecimalSamples)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class FixedDecimalRange
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        @Deprecated
        public FixedDecimal start;
        @Deprecated
        public FixedDecimal end;

        @Deprecated
        private void $$robo$$android_icu_text_PluralRules_FixedDecimalRange$__constructor__(FixedDecimal start, FixedDecimal end) {
            if (start.visibleDecimalDigitCount != end.visibleDecimalDigitCount) {
                throw new IllegalArgumentException("Ranges must have the same number of visible decimals: " + start + "~" + end);
            }
            this.start = start;
            this.end = end;
        }

        @Deprecated
        private final String $$robo$$android_icu_text_PluralRules_FixedDecimalRange$toString() {
            return this.start + (this.end == this.start ? "" : "~" + this.end);
        }

        private void __constructor__(FixedDecimal fixedDecimal, FixedDecimal fixedDecimal2) {
            this.$$robo$$android_icu_text_PluralRules_FixedDecimalRange$__constructor__(fixedDecimal, fixedDecimal2);
        }

        public FixedDecimalRange(FixedDecimal fixedDecimal, FixedDecimal fixedDecimal2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_FixedDecimalRange$__constructor__(android.icu.text.PluralRules$FixedDecimal android.icu.text.PluralRules$FixedDecimal ), this, fixedDecimal, fixedDecimal2);
        }

        @Deprecated
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_PluralRules_FixedDecimalRange$toString(), this);
        }

        public /* synthetic */ FixedDecimalRange() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FixedDecimalRange)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class SampleType
    extends Enum<SampleType> {
        public /* synthetic */ Object __robo_data__;
        @Deprecated
        public static /* enum */ SampleType INTEGER;
        @Deprecated
        public static /* enum */ SampleType DECIMAL;
        private static /* synthetic */ SampleType[] $VALUES;

        private static final SampleType[] $$robo$$android_icu_text_PluralRules_SampleType$values() {
            return (SampleType[])$VALUES.clone();
        }

        private static final SampleType $$robo$$android_icu_text_PluralRules_SampleType$valueOf(String name) {
            return Enum.valueOf(SampleType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_PluralRules_SampleType$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            INTEGER = new SampleType();
            DECIMAL = new SampleType();
            $VALUES = new SampleType[]{INTEGER, DECIMAL};
        }

        public static SampleType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_PluralRules_SampleType$values());
        }

        public static SampleType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_PluralRules_SampleType$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_PluralRules_SampleType$__constructor__(string2, n);
        }

        public SampleType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_SampleType$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(SampleType.class);
        }

        public /* synthetic */ SampleType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SampleType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class FixedDecimal
    extends Number
    implements Comparable<FixedDecimal>,
    IFixedDecimal {
        public /* synthetic */ Object __robo_data__;
        private static long serialVersionUID = -4756200506571685661L;
        double source;
        int visibleDecimalDigitCount;
        int visibleDecimalDigitCountWithoutTrailingZeros;
        long decimalDigits;
        long decimalDigitsWithoutTrailingZeros;
        long integerValue;
        boolean hasIntegerValue;
        boolean isNegative;
        private int baseFactor;
        static long MAX = 1000000000000000000L;
        private static long MAX_INTEGER_PART = 1000000000L;

        @Deprecated
        private final double $$robo$$android_icu_text_PluralRules_FixedDecimal$getSource() {
            return this.source;
        }

        @Deprecated
        private final int $$robo$$android_icu_text_PluralRules_FixedDecimal$getVisibleDecimalDigitCount() {
            return this.visibleDecimalDigitCount;
        }

        @Deprecated
        private final int $$robo$$android_icu_text_PluralRules_FixedDecimal$getVisibleDecimalDigitCountWithoutTrailingZeros() {
            return this.visibleDecimalDigitCountWithoutTrailingZeros;
        }

        @Deprecated
        private final long $$robo$$android_icu_text_PluralRules_FixedDecimal$getDecimalDigits() {
            return this.decimalDigits;
        }

        @Deprecated
        private final long $$robo$$android_icu_text_PluralRules_FixedDecimal$getDecimalDigitsWithoutTrailingZeros() {
            return this.decimalDigitsWithoutTrailingZeros;
        }

        @Deprecated
        private final long $$robo$$android_icu_text_PluralRules_FixedDecimal$getIntegerValue() {
            return this.integerValue;
        }

        @Deprecated
        private final boolean $$robo$$android_icu_text_PluralRules_FixedDecimal$isHasIntegerValue() {
            return this.hasIntegerValue;
        }

        @Deprecated
        private final boolean $$robo$$android_icu_text_PluralRules_FixedDecimal$isNegative() {
            return this.isNegative;
        }

        @Deprecated
        private final int $$robo$$android_icu_text_PluralRules_FixedDecimal$getBaseFactor() {
            return this.baseFactor;
        }

        @Deprecated
        private void $$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(double n, int v, long f) {
            this.isNegative = n < 0.0;
            this.source = this.isNegative ? -n : n;
            this.visibleDecimalDigitCount = v;
            this.decimalDigits = f;
            this.integerValue = n > 1.0E18 ? 1000000000000000000L : (long)n;
            boolean bl = this.hasIntegerValue = this.source == (double)this.integerValue;
            if (f == 0L) {
                this.decimalDigitsWithoutTrailingZeros = 0L;
                this.visibleDecimalDigitCountWithoutTrailingZeros = 0;
            } else {
                long fdwtz = f;
                int trimmedCount = v;
                while (fdwtz % 10L == 0L) {
                    fdwtz /= 10L;
                    --trimmedCount;
                }
                this.decimalDigitsWithoutTrailingZeros = fdwtz;
                this.visibleDecimalDigitCountWithoutTrailingZeros = trimmedCount;
            }
            this.baseFactor = (int)Math.pow(10.0, v);
        }

        @Deprecated
        private void $$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(double n, int v) {
        }

        private static final int $$robo$$android_icu_text_PluralRules_FixedDecimal$getFractionalDigits(double n, int v) {
            if (v == 0) {
                return 0;
            }
            if (n < 0.0) {
                n = -n;
            }
            int baseFactor = (int)Math.pow(10.0, v);
            long scaled = Math.round(n * (double)baseFactor);
            return (int)(scaled % (long)baseFactor);
        }

        @Deprecated
        private void $$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(double n) {
        }

        @Deprecated
        private void $$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(long n) {
        }

        @Deprecated
        private static final int $$robo$$android_icu_text_PluralRules_FixedDecimal$decimals(double n) {
            String exponentStr;
            int exponent;
            int numFractionDigits;
            int ePos;
            int expNumPos;
            if (Double.isInfinite(n) || Double.isNaN(n)) {
                return 0;
            }
            if (n < 0.0) {
                n = -n;
            }
            if (n == Math.floor(n)) {
                return 0;
            }
            if (n < 1.0E9) {
                long temp = (long)(n * 1000000.0) % 1000000L;
                int mask = 10;
                for (int digits = 6; digits > 0; --digits) {
                    if (temp % (long)mask != 0L) {
                        return digits;
                    }
                    mask *= 10;
                }
                return 0;
            }
            String buf = String.format(Locale.ENGLISH, "%1.15e", n);
            if (buf.charAt(expNumPos = (ePos = buf.lastIndexOf(101)) + 1) == '+') {
                ++expNumPos;
            }
            if ((numFractionDigits = ePos - 2 - (exponent = Integer.parseInt(exponentStr = buf.substring(expNumPos)))) < 0) {
                return 0;
            }
            int i = ePos - 1;
            while (numFractionDigits > 0 && buf.charAt(i) == '0') {
                --numFractionDigits;
                --i;
            }
            return numFractionDigits;
        }

        @Deprecated
        private void $$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(String n) {
        }

        private static final int $$robo$$android_icu_text_PluralRules_FixedDecimal$getVisibleFractionCount(String value) {
            int decimalPos = (value = value.trim()).indexOf(46) + 1;
            if (decimalPos == 0) {
                return 0;
            }
            return value.length() - decimalPos;
        }

        @Deprecated
        private final double $$robo$$android_icu_text_PluralRules_FixedDecimal$getPluralOperand(Operand operand) {
            switch (2.$SwitchMap$android$icu$text$PluralRules$Operand[operand.ordinal()]) {
                case 1: {
                    return this.source;
                }
                case 2: {
                    return this.integerValue;
                }
                case 3: {
                    return this.decimalDigits;
                }
                case 4: {
                    return this.decimalDigitsWithoutTrailingZeros;
                }
                case 5: {
                    return this.visibleDecimalDigitCount;
                }
                case 6: {
                    return this.visibleDecimalDigitCountWithoutTrailingZeros;
                }
            }
            return this.source;
        }

        @Deprecated
        private static final Operand $$robo$$android_icu_text_PluralRules_FixedDecimal$getOperand(String t) {
            return Operand.valueOf(t);
        }

        @Deprecated
        private final int $$robo$$android_icu_text_PluralRules_FixedDecimal$compareTo(FixedDecimal other) {
            if (this.integerValue != other.integerValue) {
                return this.integerValue < other.integerValue ? -1 : 1;
            }
            if (this.source != other.source) {
                return this.source < other.source ? -1 : 1;
            }
            if (this.visibleDecimalDigitCount != other.visibleDecimalDigitCount) {
                return this.visibleDecimalDigitCount < other.visibleDecimalDigitCount ? -1 : 1;
            }
            long diff = this.decimalDigits - other.decimalDigits;
            if (diff != 0L) {
                return diff < 0L ? -1 : 1;
            }
            return 0;
        }

        @Deprecated
        private final boolean $$robo$$android_icu_text_PluralRules_FixedDecimal$equals(Object arg0) {
            if (arg0 == null) {
                return false;
            }
            if (arg0 == this) {
                return true;
            }
            if (!(arg0 instanceof FixedDecimal)) {
                return false;
            }
            FixedDecimal other = (FixedDecimal)arg0;
            return this.source == other.source && this.visibleDecimalDigitCount == other.visibleDecimalDigitCount && this.decimalDigits == other.decimalDigits;
        }

        @Deprecated
        private final int $$robo$$android_icu_text_PluralRules_FixedDecimal$hashCode() {
            return (int)(this.decimalDigits + (long)(37 * (this.visibleDecimalDigitCount + (int)(37.0 * this.source))));
        }

        @Deprecated
        private final String $$robo$$android_icu_text_PluralRules_FixedDecimal$toString() {
            return String.format("%." + this.visibleDecimalDigitCount + "f", this.source);
        }

        @Deprecated
        private final boolean $$robo$$android_icu_text_PluralRules_FixedDecimal$hasIntegerValue() {
            return this.hasIntegerValue;
        }

        @Deprecated
        private final int $$robo$$android_icu_text_PluralRules_FixedDecimal$intValue() {
            return (int)this.integerValue;
        }

        @Deprecated
        private final long $$robo$$android_icu_text_PluralRules_FixedDecimal$longValue() {
            return this.integerValue;
        }

        @Deprecated
        private final float $$robo$$android_icu_text_PluralRules_FixedDecimal$floatValue() {
            return (float)this.source;
        }

        @Deprecated
        private final double $$robo$$android_icu_text_PluralRules_FixedDecimal$doubleValue() {
            return this.isNegative ? -this.source : this.source;
        }

        @Deprecated
        private final long $$robo$$android_icu_text_PluralRules_FixedDecimal$getShiftedValue() {
            return this.integerValue * (long)this.baseFactor + this.decimalDigits;
        }

        private final void $$robo$$android_icu_text_PluralRules_FixedDecimal$writeObject(ObjectOutputStream out) throws IOException {
            throw new NotSerializableException();
        }

        private final void $$robo$$android_icu_text_PluralRules_FixedDecimal$readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new NotSerializableException();
        }

        @Deprecated
        private final boolean $$robo$$android_icu_text_PluralRules_FixedDecimal$isNaN() {
            return Double.isNaN(this.source);
        }

        @Deprecated
        private final boolean $$robo$$android_icu_text_PluralRules_FixedDecimal$isInfinite() {
            return Double.isInfinite(this.source);
        }

        @Deprecated
        public double getSource() {
            return (double)InvokeDynamicSupport.bootstrap("getSource", $$robo$$android_icu_text_PluralRules_FixedDecimal$getSource(), this);
        }

        @Deprecated
        public int getVisibleDecimalDigitCount() {
            return (int)InvokeDynamicSupport.bootstrap("getVisibleDecimalDigitCount", $$robo$$android_icu_text_PluralRules_FixedDecimal$getVisibleDecimalDigitCount(), this);
        }

        @Deprecated
        public int getVisibleDecimalDigitCountWithoutTrailingZeros() {
            return (int)InvokeDynamicSupport.bootstrap("getVisibleDecimalDigitCountWithoutTrailingZeros", $$robo$$android_icu_text_PluralRules_FixedDecimal$getVisibleDecimalDigitCountWithoutTrailingZeros(), this);
        }

        @Deprecated
        public long getDecimalDigits() {
            return (long)InvokeDynamicSupport.bootstrap("getDecimalDigits", $$robo$$android_icu_text_PluralRules_FixedDecimal$getDecimalDigits(), this);
        }

        @Deprecated
        public long getDecimalDigitsWithoutTrailingZeros() {
            return (long)InvokeDynamicSupport.bootstrap("getDecimalDigitsWithoutTrailingZeros", $$robo$$android_icu_text_PluralRules_FixedDecimal$getDecimalDigitsWithoutTrailingZeros(), this);
        }

        @Deprecated
        public long getIntegerValue() {
            return (long)InvokeDynamicSupport.bootstrap("getIntegerValue", $$robo$$android_icu_text_PluralRules_FixedDecimal$getIntegerValue(), this);
        }

        @Deprecated
        public boolean isHasIntegerValue() {
            return (boolean)InvokeDynamicSupport.bootstrap("isHasIntegerValue", $$robo$$android_icu_text_PluralRules_FixedDecimal$isHasIntegerValue(), this);
        }

        @Deprecated
        public boolean isNegative() {
            return (boolean)InvokeDynamicSupport.bootstrap("isNegative", $$robo$$android_icu_text_PluralRules_FixedDecimal$isNegative(), this);
        }

        @Deprecated
        public int getBaseFactor() {
            return (int)InvokeDynamicSupport.bootstrap("getBaseFactor", $$robo$$android_icu_text_PluralRules_FixedDecimal$getBaseFactor(), this);
        }

        private void __constructor__(double d, int n, long l) {
            this.$$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(d, n, l);
        }

        public FixedDecimal(double d, int n, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(double int long ), this, d, n, l);
        }

        private void __constructor__(double d, int n) {
            this.$$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(d, n);
        }

        public FixedDecimal(double d, int n) {
            this(d, n, FixedDecimal.getFractionalDigits(d, n));
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(double int ), this, d, n);
        }

        private static int getFractionalDigits(double d, int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getFractionalDigits", $$robo$$android_icu_text_PluralRules_FixedDecimal$getFractionalDigits(double int ), (double)d, (int)n);
        }

        private void __constructor__(double d) {
            this.$$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(d);
        }

        public FixedDecimal(double d) {
            this(d, FixedDecimal.decimals(d));
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(double ), this, d);
        }

        private void __constructor__(long l) {
            this.$$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(l);
        }

        public FixedDecimal(long l) {
            this(l, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(long ), this, l);
        }

        @Deprecated
        public static int decimals(double d) {
            return (int)InvokeDynamicSupport.bootstrapStatic("decimals", $$robo$$android_icu_text_PluralRules_FixedDecimal$decimals(double ), (double)d);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(string2);
        }

        public FixedDecimal(String string2) {
            this(Double.parseDouble(string2), FixedDecimal.getVisibleFractionCount(string2));
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_FixedDecimal$__constructor__(java.lang.String ), this, string2);
        }

        private static int getVisibleFractionCount(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getVisibleFractionCount", $$robo$$android_icu_text_PluralRules_FixedDecimal$getVisibleFractionCount(java.lang.String ), (String)string2);
        }

        @Override
        @Deprecated
        public double getPluralOperand(Operand operand) {
            return (double)InvokeDynamicSupport.bootstrap("getPluralOperand", $$robo$$android_icu_text_PluralRules_FixedDecimal$getPluralOperand(android.icu.text.PluralRules$Operand ), this, operand);
        }

        @Deprecated
        public static Operand getOperand(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getOperand", $$robo$$android_icu_text_PluralRules_FixedDecimal$getOperand(java.lang.String ), (String)string2);
        }

        @Override
        @Deprecated
        public int compareTo(FixedDecimal fixedDecimal) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_text_PluralRules_FixedDecimal$compareTo(android.icu.text.PluralRules$FixedDecimal ), this, fixedDecimal);
        }

        @Deprecated
        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_PluralRules_FixedDecimal$equals(java.lang.Object ), this, object);
        }

        @Deprecated
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_PluralRules_FixedDecimal$hashCode(), this);
        }

        @Deprecated
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_PluralRules_FixedDecimal$toString(), this);
        }

        @Deprecated
        public boolean hasIntegerValue() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasIntegerValue", $$robo$$android_icu_text_PluralRules_FixedDecimal$hasIntegerValue(), this);
        }

        @Override
        @Deprecated
        public int intValue() {
            return (int)InvokeDynamicSupport.bootstrap("intValue", $$robo$$android_icu_text_PluralRules_FixedDecimal$intValue(), this);
        }

        @Override
        @Deprecated
        public long longValue() {
            return (long)InvokeDynamicSupport.bootstrap("longValue", $$robo$$android_icu_text_PluralRules_FixedDecimal$longValue(), this);
        }

        @Override
        @Deprecated
        public float floatValue() {
            return (float)InvokeDynamicSupport.bootstrap("floatValue", $$robo$$android_icu_text_PluralRules_FixedDecimal$floatValue(), this);
        }

        @Override
        @Deprecated
        public double doubleValue() {
            return (double)InvokeDynamicSupport.bootstrap("doubleValue", $$robo$$android_icu_text_PluralRules_FixedDecimal$doubleValue(), this);
        }

        @Deprecated
        public long getShiftedValue() {
            return (long)InvokeDynamicSupport.bootstrap("getShiftedValue", $$robo$$android_icu_text_PluralRules_FixedDecimal$getShiftedValue(), this);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            InvokeDynamicSupport.bootstrap("writeObject", $$robo$$android_icu_text_PluralRules_FixedDecimal$writeObject(java.io.ObjectOutputStream ), this, objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_PluralRules_FixedDecimal$readObject(java.io.ObjectInputStream ), this, objectInputStream);
        }

        @Override
        @Deprecated
        public boolean isNaN() {
            return (boolean)InvokeDynamicSupport.bootstrap("isNaN", $$robo$$android_icu_text_PluralRules_FixedDecimal$isNaN(), this);
        }

        @Override
        @Deprecated
        public boolean isInfinite() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInfinite", $$robo$$android_icu_text_PluralRules_FixedDecimal$isInfinite(), this);
        }

        public /* synthetic */ FixedDecimal() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FixedDecimal)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static interface IFixedDecimal {
        @Deprecated
        public double getPluralOperand(Operand var1);

        @Deprecated
        public boolean isNaN();

        @Deprecated
        public boolean isInfinite();
    }

    @Deprecated
    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Operand
    extends Enum<Operand> {
        public /* synthetic */ Object __robo_data__;
        @Deprecated
        public static /* enum */ Operand n;
        @Deprecated
        public static /* enum */ Operand i;
        @Deprecated
        public static /* enum */ Operand f;
        @Deprecated
        public static /* enum */ Operand t;
        @Deprecated
        public static /* enum */ Operand v;
        @Deprecated
        public static /* enum */ Operand w;
        @Deprecated
        public static /* enum */ Operand j;
        private static /* synthetic */ Operand[] $VALUES;

        private static final Operand[] $$robo$$android_icu_text_PluralRules_Operand$values() {
            return (Operand[])$VALUES.clone();
        }

        private static final Operand $$robo$$android_icu_text_PluralRules_Operand$valueOf(String name) {
            return Enum.valueOf(Operand.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_PluralRules_Operand$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            n = new Operand();
            i = new Operand();
            f = new Operand();
            t = new Operand();
            v = new Operand();
            w = new Operand();
            j = new Operand();
            $VALUES = new Operand[]{n, i, f, t, v, w, j};
        }

        public static Operand[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_PluralRules_Operand$values());
        }

        public static Operand valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_PluralRules_Operand$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_PluralRules_Operand$__constructor__(string2, n);
        }

        public Operand() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_Operand$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Operand.class);
        }

        public /* synthetic */ Operand() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Operand)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PluralType
    extends Enum<PluralType> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ PluralType CARDINAL;
        public static /* enum */ PluralType ORDINAL;
        private static /* synthetic */ PluralType[] $VALUES;

        private static final PluralType[] $$robo$$android_icu_text_PluralRules_PluralType$values() {
            return (PluralType[])$VALUES.clone();
        }

        private static final PluralType $$robo$$android_icu_text_PluralRules_PluralType$valueOf(String name) {
            return Enum.valueOf(PluralType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_PluralRules_PluralType$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            CARDINAL = new PluralType();
            ORDINAL = new PluralType();
            $VALUES = new PluralType[]{CARDINAL, ORDINAL};
        }

        public static PluralType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_PluralRules_PluralType$values());
        }

        public static PluralType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_PluralRules_PluralType$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_PluralRules_PluralType$__constructor__(string2, n);
        }

        public PluralType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_PluralType$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(PluralType.class);
        }

        public /* synthetic */ PluralType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PluralType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static abstract class Factory
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        @Deprecated
        private void $$robo$$android_icu_text_PluralRules_Factory$__constructor__() {
        }

        @Deprecated
        public abstract PluralRules forLocale(ULocale var1, PluralType var2);

        @Deprecated
        private final PluralRules $$robo$$android_icu_text_PluralRules_Factory$forLocale(ULocale locale) {
            return this.forLocale(locale, PluralType.CARDINAL);
        }

        @Deprecated
        public abstract ULocale[] getAvailableULocales();

        @Deprecated
        public abstract ULocale getFunctionalEquivalent(ULocale var1, boolean[] var2);

        @Deprecated
        private static final PluralRulesLoader $$robo$$android_icu_text_PluralRules_Factory$getDefaultFactory() {
            return PluralRulesLoader.loader;
        }

        @Deprecated
        public abstract boolean hasOverride(ULocale var1);

        private void __constructor__() {
            this.$$robo$$android_icu_text_PluralRules_Factory$__constructor__();
        }

        public Factory() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralRules_Factory$__constructor__(), this);
        }

        @Deprecated
        public PluralRules forLocale(ULocale uLocale) {
            return InvokeDynamicSupport.bootstrap("forLocale", $$robo$$android_icu_text_PluralRules_Factory$forLocale(android.icu.util.ULocale ), this, uLocale);
        }

        @Deprecated
        public static PluralRulesLoader getDefaultFactory() {
            return InvokeDynamicSupport.bootstrapStatic("getDefaultFactory", $$robo$$android_icu_text_PluralRules_Factory$getDefaultFactory());
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Factory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

