/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUDebug;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.UResource;
import android.icu.impl.coll.CollationData;
import android.icu.impl.coll.CollationRoot;
import android.icu.lang.UCharacter;
import android.icu.text.CollationKey;
import android.icu.text.RawCollationKey;
import android.icu.text.RuleBasedCollator;
import android.icu.text.UnicodeSet;
import android.icu.util.Freezable;
import android.icu.util.ICUException;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import android.icu.util.VersionInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Collator
implements Comparator<Object>,
Freezable<Collator>,
Cloneable {
    public /* synthetic */ Object __robo_data__;
    public static int PRIMARY = 0;
    public static int SECONDARY = 1;
    public static int TERTIARY = 2;
    public static int QUATERNARY = 3;
    public static int IDENTICAL = 15;
    public static int FULL_DECOMPOSITION = 15;
    public static int NO_DECOMPOSITION = 16;
    public static int CANONICAL_DECOMPOSITION = 17;
    private static ServiceShim shim;
    private static String[] KEYWORDS;
    private static String RESOURCE = "collations";
    private static String BASE = "android/icu/impl/data/icudt60b/coll";
    private static boolean DEBUG;

    private final boolean $$robo$$android_icu_text_Collator$equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass();
    }

    private final int $$robo$$android_icu_text_Collator$hashCode() {
        return 0;
    }

    private final void $$robo$$android_icu_text_Collator$checkNotFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen Collator");
        }
    }

    private final void $$robo$$android_icu_text_Collator$setStrength(int newStrength) {
        this.checkNotFrozen();
    }

    @Deprecated
    private final Collator $$robo$$android_icu_text_Collator$setStrength2(int newStrength) {
        this.setStrength(newStrength);
        return this;
    }

    private final void $$robo$$android_icu_text_Collator$setDecomposition(int decomposition) {
        this.checkNotFrozen();
    }

    private final void $$robo$$android_icu_text_Collator$setReorderCodes(int ... order) {
        throw new UnsupportedOperationException("Needs to be implemented by the subclass.");
    }

    private static final Collator $$robo$$android_icu_text_Collator$getInstance() {
        return Collator.getInstance(ULocale.getDefault());
    }

    private final Object $$robo$$android_icu_text_Collator$clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static final ServiceShim $$robo$$android_icu_text_Collator$getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName("android.icu.text.CollatorServiceShim");
                shim = (ServiceShim)cls.newInstance();
            }
            catch (MissingResourceException e) {
                throw e;
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                throw new ICUException(e);
            }
        }
        return shim;
    }

    private static final boolean $$robo$$android_icu_text_Collator$getYesOrNo(String keyword, String s) {
        if (ASCII.equalIgnoreCase(s, "yes")) {
            return true;
        }
        if (ASCII.equalIgnoreCase(s, "no")) {
            return false;
        }
        throw new IllegalArgumentException("illegal locale keyword=value: " + keyword + "=" + s);
    }

    private static final int $$robo$$android_icu_text_Collator$getIntValue(String keyword, String s, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (!ASCII.equalIgnoreCase(s, values[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("illegal locale keyword=value: " + keyword + "=" + s);
    }

    private static final int $$robo$$android_icu_text_Collator$getReorderCode(String keyword, String s) {
        return 4096 + Collator.getIntValue(keyword, s, "space", "punct", "symbol", "currency", "digit");
    }

    private static final void $$robo$$android_icu_text_Collator$setAttributesFromKeywords(ULocale loc, Collator coll, RuleBasedCollator rbc) {
        String value = loc.getKeywordValue("colHiraganaQuaternary");
        if (value != null) {
            throw new UnsupportedOperationException("locale keyword kh/colHiraganaQuaternary");
        }
        value = loc.getKeywordValue("variableTop");
        if (value != null) {
            throw new UnsupportedOperationException("locale keyword vt/variableTop");
        }
        value = loc.getKeywordValue("colStrength");
        if (value != null) {
            int strength = Collator.getIntValue("colStrength", value, "primary", "secondary", "tertiary", "quaternary", "identical");
            coll.setStrength(strength <= 3 ? strength : 15);
        }
        if ((value = loc.getKeywordValue("colBackwards")) != null) {
            if (rbc != null) {
                rbc.setFrenchCollation(Collator.getYesOrNo("colBackwards", value));
            } else {
                throw new UnsupportedOperationException("locale keyword kb/colBackwards only settable for RuleBasedCollator");
            }
        }
        if ((value = loc.getKeywordValue("colCaseLevel")) != null) {
            if (rbc != null) {
                rbc.setCaseLevel(Collator.getYesOrNo("colCaseLevel", value));
            } else {
                throw new UnsupportedOperationException("locale keyword kb/colBackwards only settable for RuleBasedCollator");
            }
        }
        if ((value = loc.getKeywordValue("colCaseFirst")) != null) {
            if (rbc != null) {
                int cf = Collator.getIntValue("colCaseFirst", value, "no", "lower", "upper");
                if (cf == 0) {
                    rbc.setLowerCaseFirst(false);
                    rbc.setUpperCaseFirst(false);
                } else if (cf == 1) {
                    rbc.setLowerCaseFirst(true);
                } else {
                    rbc.setUpperCaseFirst(true);
                }
            } else {
                throw new UnsupportedOperationException("locale keyword kf/colCaseFirst only settable for RuleBasedCollator");
            }
        }
        if ((value = loc.getKeywordValue("colAlternate")) != null) {
            if (rbc != null) {
                rbc.setAlternateHandlingShifted(Collator.getIntValue("colAlternate", value, "non-ignorable", "shifted") != 0);
            } else {
                throw new UnsupportedOperationException("locale keyword ka/colAlternate only settable for RuleBasedCollator");
            }
        }
        if ((value = loc.getKeywordValue("colNormalization")) != null) {
            coll.setDecomposition(Collator.getYesOrNo("colNormalization", value) ? 17 : 16);
        }
        if ((value = loc.getKeywordValue("colNumeric")) != null) {
            if (rbc != null) {
                rbc.setNumericCollation(Collator.getYesOrNo("colNumeric", value));
            } else {
                throw new UnsupportedOperationException("locale keyword kn/colNumeric only settable for RuleBasedCollator");
            }
        }
        if ((value = loc.getKeywordValue("colReorder")) != null) {
            int[] codes = new int[183];
            int codesLength = 0;
            int scriptNameStart = 0;
            while (true) {
                int limit;
                if (codesLength == codes.length) {
                    throw new IllegalArgumentException("too many script codes for colReorder locale keyword: " + value);
                }
                for (limit = scriptNameStart; limit < value.length() && value.charAt(limit) != '-'; ++limit) {
                }
                String scriptName = value.substring(scriptNameStart, limit);
                int code = scriptName.length() == 4 ? UCharacter.getPropertyValueEnum(4106, scriptName) : Collator.getReorderCode("colReorder", scriptName);
                codes[codesLength++] = code;
                if (limit == value.length()) break;
                scriptNameStart = limit + 1;
            }
            if (codesLength == 0) {
                throw new IllegalArgumentException("no script codes for colReorder locale keyword");
            }
            int[] args = new int[codesLength];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)codes, (int)0, (Object)args, (int)0, (int)codesLength);
            coll.setReorderCodes(args);
        }
        if ((value = loc.getKeywordValue("kv")) != null) {
            coll.setMaxVariable(Collator.getReorderCode("kv", value));
        }
    }

    private static final Collator $$robo$$android_icu_text_Collator$getInstance(ULocale locale) {
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        Collator coll = Collator.getShim().getInstance(locale);
        if (!locale.getName().equals(locale.getBaseName())) {
            Collator.setAttributesFromKeywords(locale, coll, coll instanceof RuleBasedCollator ? (RuleBasedCollator)coll : null);
        }
        return coll;
    }

    private static final Collator $$robo$$android_icu_text_Collator$getInstance(Locale locale) {
        return Collator.getInstance(ULocale.forLocale(locale));
    }

    private static final Object $$robo$$android_icu_text_Collator$registerInstance(Collator collator, ULocale locale) {
        return Collator.getShim().registerInstance(collator, locale);
    }

    private static final Object $$robo$$android_icu_text_Collator$registerFactory(CollatorFactory factory) {
        return Collator.getShim().registerFactory(factory);
    }

    private static final boolean $$robo$$android_icu_text_Collator$unregister(Object registryKey) {
        if (shim == null) {
            return false;
        }
        return shim.unregister(registryKey);
    }

    private static final Locale[] $$robo$$android_icu_text_Collator$getAvailableLocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableLocales("android/icu/impl/data/icudt60b/coll", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        }
        return shim.getAvailableLocales();
    }

    private static final ULocale[] $$robo$$android_icu_text_Collator$getAvailableULocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableULocales("android/icu/impl/data/icudt60b/coll", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        }
        return shim.getAvailableULocales();
    }

    private static final String[] $$robo$$android_icu_text_Collator$getKeywords() {
        return KEYWORDS;
    }

    private static final String[] $$robo$$android_icu_text_Collator$getKeywordValues(String keyword) {
        if (!keyword.equals(KEYWORDS[0])) {
            throw new IllegalArgumentException("Invalid keyword: " + keyword);
        }
        return ICUResourceBundle.getKeywordValues("android/icu/impl/data/icudt60b/coll", "collations");
    }

    private static final String[] $$robo$$android_icu_text_Collator$getKeywordValuesForLocale(String key, ULocale locale, boolean commonlyUsed) {
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b/coll", locale);
        KeywordsSink sink = new KeywordsSink(null);
        bundle.getAllItemsWithFallback("collations", sink);
        return sink.values.toArray(new String[sink.values.size()]);
    }

    private static final ULocale $$robo$$android_icu_text_Collator$getFunctionalEquivalent(String keyword, ULocale locID, boolean[] isAvailable) {
        return ICUResourceBundle.getFunctionalEquivalent("android/icu/impl/data/icudt60b/coll", ICUResourceBundle.ICU_DATA_CLASS_LOADER, "collations", keyword, locID, isAvailable, true);
    }

    private static final ULocale $$robo$$android_icu_text_Collator$getFunctionalEquivalent(String keyword, ULocale locID) {
        return Collator.getFunctionalEquivalent(keyword, locID, null);
    }

    private static final String $$robo$$android_icu_text_Collator$getDisplayName(Locale objectLocale, Locale displayLocale) {
        return Collator.getShim().getDisplayName(ULocale.forLocale(objectLocale), ULocale.forLocale(displayLocale));
    }

    private static final String $$robo$$android_icu_text_Collator$getDisplayName(ULocale objectLocale, ULocale displayLocale) {
        return Collator.getShim().getDisplayName(objectLocale, displayLocale);
    }

    private static final String $$robo$$android_icu_text_Collator$getDisplayName(Locale objectLocale) {
        return Collator.getShim().getDisplayName(ULocale.forLocale(objectLocale), ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    private static final String $$robo$$android_icu_text_Collator$getDisplayName(ULocale objectLocale) {
        return Collator.getShim().getDisplayName(objectLocale, ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    private final int $$robo$$android_icu_text_Collator$getStrength() {
        return 2;
    }

    private final int $$robo$$android_icu_text_Collator$getDecomposition() {
        return 16;
    }

    private final boolean $$robo$$android_icu_text_Collator$equals(String source, String target) {
        return this.compare(source, target) == 0;
    }

    private final UnicodeSet $$robo$$android_icu_text_Collator$getTailoredSet() {
        return new UnicodeSet(0, 0x10FFFF);
    }

    @Override
    public abstract int compare(String var1, String var2);

    private final int $$robo$$android_icu_text_Collator$compare(Object source, Object target) {
        return this.doCompare((CharSequence)source, (CharSequence)target);
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Collator$doCompare(CharSequence left, CharSequence right) {
        return this.compare(left.toString(), right.toString());
    }

    public abstract CollationKey getCollationKey(String var1);

    public abstract RawCollationKey getRawCollationKey(String var1, RawCollationKey var2);

    private final Collator $$robo$$android_icu_text_Collator$setMaxVariable(int group) {
        throw new UnsupportedOperationException("Needs to be implemented by the subclass.");
    }

    private final int $$robo$$android_icu_text_Collator$getMaxVariable() {
        return 4097;
    }

    @Deprecated
    public abstract int setVariableTop(String var1);

    public abstract int getVariableTop();

    @Deprecated
    public abstract void setVariableTop(int var1);

    public abstract VersionInfo getVersion();

    public abstract VersionInfo getUCAVersion();

    private final int[] $$robo$$android_icu_text_Collator$getReorderCodes() {
        throw new UnsupportedOperationException("Needs to be implemented by the subclass.");
    }

    private static final int[] $$robo$$android_icu_text_Collator$getEquivalentReorderCodes(int reorderCode) {
        CollationData baseData = CollationRoot.getData();
        return baseData.getEquivalentScripts(reorderCode);
    }

    private final boolean $$robo$$android_icu_text_Collator$isFrozen() {
        return false;
    }

    private final Collator $$robo$$android_icu_text_Collator$freeze() {
        throw new UnsupportedOperationException("Needs to be implemented by the subclass.");
    }

    private final Collator $$robo$$android_icu_text_Collator$cloneAsThawed() {
        throw new UnsupportedOperationException("Needs to be implemented by the subclass.");
    }

    private void $$robo$$android_icu_text_Collator$__constructor__() {
    }

    private final ULocale $$robo$$android_icu_text_Collator$getLocale(ULocale.Type type) {
        return ULocale.ROOT;
    }

    private final void $$robo$$android_icu_text_Collator$setLocale(ULocale valid, ULocale actual) {
    }

    static void __staticInitializer__() {
        KEYWORDS = new String[]{"collation"};
        DEBUG = ICUDebug.enabled("collator");
    }

    @Override
    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_Collator$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_Collator$hashCode(), this);
    }

    private void checkNotFrozen() {
        InvokeDynamicSupport.bootstrap("checkNotFrozen", $$robo$$android_icu_text_Collator$checkNotFrozen(), this);
    }

    public void setStrength(int n) {
        InvokeDynamicSupport.bootstrap("setStrength", $$robo$$android_icu_text_Collator$setStrength(int ), this, n);
    }

    @Deprecated
    public Collator setStrength2(int n) {
        return InvokeDynamicSupport.bootstrap("setStrength2", $$robo$$android_icu_text_Collator$setStrength2(int ), this, n);
    }

    public void setDecomposition(int n) {
        InvokeDynamicSupport.bootstrap("setDecomposition", $$robo$$android_icu_text_Collator$setDecomposition(int ), this, n);
    }

    public void setReorderCodes(int ... nArray) {
        InvokeDynamicSupport.bootstrap("setReorderCodes", $$robo$$android_icu_text_Collator$setReorderCodes(int[] ), this, nArray);
    }

    public static Collator getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_Collator$getInstance());
    }

    public Object clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_Collator$clone(), this);
    }

    private static ServiceShim getShim() {
        return InvokeDynamicSupport.bootstrapStatic("getShim", $$robo$$android_icu_text_Collator$getShim());
    }

    private static boolean getYesOrNo(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("getYesOrNo", $$robo$$android_icu_text_Collator$getYesOrNo(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    private static int getIntValue(String string2, String string3, String ... stringArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIntValue", $$robo$$android_icu_text_Collator$getIntValue(java.lang.String java.lang.String java.lang.String[] ), (String)string2, (String)string3, (String[])stringArray);
    }

    private static int getReorderCode(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getReorderCode", $$robo$$android_icu_text_Collator$getReorderCode(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    private static void setAttributesFromKeywords(ULocale uLocale, Collator collator, RuleBasedCollator ruleBasedCollator) {
        InvokeDynamicSupport.bootstrapStatic("setAttributesFromKeywords", $$robo$$android_icu_text_Collator$setAttributesFromKeywords(android.icu.util.ULocale android.icu.text.Collator android.icu.text.RuleBasedCollator ), (ULocale)uLocale, (Collator)collator, (RuleBasedCollator)ruleBasedCollator);
    }

    public static Collator getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_Collator$getInstance(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    public static Collator getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_Collator$getInstance(java.util.Locale ), (Locale)locale);
    }

    public static Object registerInstance(Collator collator, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("registerInstance", $$robo$$android_icu_text_Collator$registerInstance(android.icu.text.Collator android.icu.util.ULocale ), (Collator)collator, (ULocale)uLocale);
    }

    public static Object registerFactory(CollatorFactory collatorFactory) {
        return InvokeDynamicSupport.bootstrapStatic("registerFactory", $$robo$$android_icu_text_Collator$registerFactory(android.icu.text.Collator$CollatorFactory ), (CollatorFactory)collatorFactory);
    }

    public static boolean unregister(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("unregister", $$robo$$android_icu_text_Collator$unregister(java.lang.Object ), (Object)object);
    }

    public static Locale[] getAvailableLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableLocales", $$robo$$android_icu_text_Collator$getAvailableLocales());
    }

    public static ULocale[] getAvailableULocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableULocales", $$robo$$android_icu_text_Collator$getAvailableULocales());
    }

    public static String[] getKeywords() {
        return InvokeDynamicSupport.bootstrapStatic("getKeywords", $$robo$$android_icu_text_Collator$getKeywords());
    }

    public static String[] getKeywordValues(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getKeywordValues", $$robo$$android_icu_text_Collator$getKeywordValues(java.lang.String ), (String)string2);
    }

    public static String[] getKeywordValuesForLocale(String string2, ULocale uLocale, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getKeywordValuesForLocale", $$robo$$android_icu_text_Collator$getKeywordValuesForLocale(java.lang.String android.icu.util.ULocale boolean ), (String)string2, (ULocale)uLocale, (boolean)bl);
    }

    public static ULocale getFunctionalEquivalent(String string2, ULocale uLocale, boolean[] blArray) {
        return InvokeDynamicSupport.bootstrapStatic("getFunctionalEquivalent", $$robo$$android_icu_text_Collator$getFunctionalEquivalent(java.lang.String android.icu.util.ULocale boolean[] ), (String)string2, (ULocale)uLocale, (boolean[])blArray);
    }

    public static ULocale getFunctionalEquivalent(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getFunctionalEquivalent", $$robo$$android_icu_text_Collator$getFunctionalEquivalent(java.lang.String android.icu.util.ULocale ), (String)string2, (ULocale)uLocale);
    }

    public static String getDisplayName(Locale locale, Locale locale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayName", $$robo$$android_icu_text_Collator$getDisplayName(java.util.Locale java.util.Locale ), (Locale)locale, (Locale)locale2);
    }

    public static String getDisplayName(ULocale uLocale, ULocale uLocale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayName", $$robo$$android_icu_text_Collator$getDisplayName(android.icu.util.ULocale android.icu.util.ULocale ), (ULocale)uLocale, (ULocale)uLocale2);
    }

    public static String getDisplayName(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayName", $$robo$$android_icu_text_Collator$getDisplayName(java.util.Locale ), (Locale)locale);
    }

    public static String getDisplayName(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayName", $$robo$$android_icu_text_Collator$getDisplayName(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    public int getStrength() {
        return (int)InvokeDynamicSupport.bootstrap("getStrength", $$robo$$android_icu_text_Collator$getStrength(), this);
    }

    public int getDecomposition() {
        return (int)InvokeDynamicSupport.bootstrap("getDecomposition", $$robo$$android_icu_text_Collator$getDecomposition(), this);
    }

    public boolean equals(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_Collator$equals(java.lang.String java.lang.String ), this, string2, string3);
    }

    public UnicodeSet getTailoredSet() {
        return InvokeDynamicSupport.bootstrap("getTailoredSet", $$robo$$android_icu_text_Collator$getTailoredSet(), this);
    }

    @Override
    public int compare(Object object, Object object2) {
        return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_icu_text_Collator$compare(java.lang.Object java.lang.Object ), this, object, object2);
    }

    @Deprecated
    protected int doCompare(CharSequence charSequence, CharSequence charSequence2) {
        return (int)InvokeDynamicSupport.bootstrap("doCompare", $$robo$$android_icu_text_Collator$doCompare(java.lang.CharSequence java.lang.CharSequence ), this, charSequence, charSequence2);
    }

    public Collator setMaxVariable(int n) {
        return InvokeDynamicSupport.bootstrap("setMaxVariable", $$robo$$android_icu_text_Collator$setMaxVariable(int ), this, n);
    }

    public int getMaxVariable() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxVariable", $$robo$$android_icu_text_Collator$getMaxVariable(), this);
    }

    public int[] getReorderCodes() {
        return InvokeDynamicSupport.bootstrap("getReorderCodes", $$robo$$android_icu_text_Collator$getReorderCodes(), this);
    }

    public static int[] getEquivalentReorderCodes(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getEquivalentReorderCodes", $$robo$$android_icu_text_Collator$getEquivalentReorderCodes(int ), (int)n);
    }

    @Override
    public boolean isFrozen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_text_Collator$isFrozen(), this);
    }

    @Override
    public Collator freeze() {
        return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_text_Collator$freeze(), this);
    }

    @Override
    public Collator cloneAsThawed() {
        return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_text_Collator$cloneAsThawed(), this);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_Collator$__constructor__();
    }

    public Collator() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Collator$__constructor__(), this);
    }

    public ULocale getLocale(ULocale.Type type) {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_text_Collator$getLocale(android.icu.util.ULocale$Type ), this, type);
    }

    void setLocale(ULocale uLocale, ULocale uLocale2) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_icu_text_Collator$setLocale(android.icu.util.ULocale android.icu.util.ULocale ), this, uLocale, uLocale2);
    }

    static {
        RobolectricInternals.classInitializing(Collator.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Collator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class KeywordsSink
    extends UResource.Sink
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        LinkedList<String> values;
        boolean hasDefault;

        private void $$robo$$android_icu_text_Collator_KeywordsSink$__constructor__() {
            this.values = new LinkedList();
            this.hasDefault = false;
        }

        private final void $$robo$$android_icu_text_Collator_KeywordsSink$put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table collations = value.getTable();
            int i = 0;
            while (collations.getKeyAndValue(i, key, value)) {
                String collkey;
                int type = value.getType();
                if (type == 0) {
                    String defcoll;
                    if (!this.hasDefault && key.contentEquals("default") && !(defcoll = value.getString()).isEmpty()) {
                        this.values.remove(defcoll);
                        this.values.addFirst(defcoll);
                        this.hasDefault = true;
                    }
                } else if (type == 2 && !key.startsWith("private-") && !this.values.contains(collkey = key.toString())) {
                    this.values.add(collkey);
                }
                ++i;
            }
        }

        private /* synthetic */ void $$robo$$android_icu_text_Collator_KeywordsSink$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Collator_KeywordsSink$__constructor__();
        }

        public KeywordsSink() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Collator_KeywordsSink$__constructor__(), this);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_Collator_KeywordsSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), this, key, value, bl);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_Collator_KeywordsSink$__constructor__(var1_1);
        }

        public /* synthetic */ KeywordsSink(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Collator_KeywordsSink$__constructor__(android.icu.text.Collator$1 ), this, var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeywordsSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ASCII
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_Collator_ASCII$__constructor__() {
        }

        private static final boolean $$robo$$android_icu_text_Collator_ASCII$equalIgnoreCase(CharSequence left, CharSequence right) {
            int length = left.length();
            if (length != right.length()) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                char rc;
                char lc = left.charAt(i);
                if (lc == (rc = right.charAt(i)) || ('A' <= lc && lc <= 'Z' ? lc + 32 == rc : 'A' <= rc && rc <= 'Z' && rc + 32 == lc)) continue;
                return false;
            }
            return true;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Collator_ASCII$__constructor__();
        }

        public ASCII() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Collator_ASCII$__constructor__(), this);
        }

        static boolean equalIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("equalIgnoreCase", $$robo$$android_icu_text_Collator_ASCII$equalIgnoreCase(java.lang.CharSequence java.lang.CharSequence ), (CharSequence)charSequence, (CharSequence)charSequence2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ASCII)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class ServiceShim
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_Collator_ServiceShim$__constructor__() {
        }

        abstract Collator getInstance(ULocale var1);

        abstract Object registerInstance(Collator var1, ULocale var2);

        abstract Object registerFactory(CollatorFactory var1);

        abstract boolean unregister(Object var1);

        abstract Locale[] getAvailableLocales();

        abstract ULocale[] getAvailableULocales();

        abstract String getDisplayName(ULocale var1, ULocale var2);

        private void __constructor__() {
            this.$$robo$$android_icu_text_Collator_ServiceShim$__constructor__();
        }

        public ServiceShim() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Collator_ServiceShim$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceShim)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class CollatorFactory
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private final boolean $$robo$$android_icu_text_Collator_CollatorFactory$visible() {
            return true;
        }

        private final Collator $$robo$$android_icu_text_Collator_CollatorFactory$createCollator(ULocale loc) {
            return this.createCollator(loc.toLocale());
        }

        private final Collator $$robo$$android_icu_text_Collator_CollatorFactory$createCollator(Locale loc) {
            return this.createCollator(ULocale.forLocale(loc));
        }

        private final String $$robo$$android_icu_text_Collator_CollatorFactory$getDisplayName(Locale objectLocale, Locale displayLocale) {
            return this.getDisplayName(ULocale.forLocale(objectLocale), ULocale.forLocale(displayLocale));
        }

        private final String $$robo$$android_icu_text_Collator_CollatorFactory$getDisplayName(ULocale objectLocale, ULocale displayLocale) {
            String name;
            Set<String> supported;
            if (this.visible() && (supported = this.getSupportedLocaleIDs()).contains(name = objectLocale.getBaseName())) {
                return objectLocale.getDisplayName(displayLocale);
            }
            return null;
        }

        public abstract Set<String> getSupportedLocaleIDs();

        private void $$robo$$android_icu_text_Collator_CollatorFactory$__constructor__() {
        }

        public boolean visible() {
            return (boolean)InvokeDynamicSupport.bootstrap("visible", $$robo$$android_icu_text_Collator_CollatorFactory$visible(), this);
        }

        public Collator createCollator(ULocale uLocale) {
            return InvokeDynamicSupport.bootstrap("createCollator", $$robo$$android_icu_text_Collator_CollatorFactory$createCollator(android.icu.util.ULocale ), this, uLocale);
        }

        public Collator createCollator(Locale locale) {
            return InvokeDynamicSupport.bootstrap("createCollator", $$robo$$android_icu_text_Collator_CollatorFactory$createCollator(java.util.Locale ), this, locale);
        }

        public String getDisplayName(Locale locale, Locale locale2) {
            return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_text_Collator_CollatorFactory$getDisplayName(java.util.Locale java.util.Locale ), this, locale, locale2);
        }

        public String getDisplayName(ULocale uLocale, ULocale uLocale2) {
            return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_text_Collator_CollatorFactory$getDisplayName(android.icu.util.ULocale android.icu.util.ULocale ), this, uLocale, uLocale2);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Collator_CollatorFactory$__constructor__();
        }

        public CollatorFactory() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Collator_CollatorFactory$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollatorFactory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ReorderCodes {
        public static final int DEFAULT = -1;
        public static final int NONE = 103;
        public static final int OTHERS = 103;
        public static final int SPACE = 4096;
        public static final int FIRST = 4096;
        public static final int PUNCTUATION = 4097;
        public static final int SYMBOL = 4098;
        public static final int CURRENCY = 4099;
        public static final int DIGIT = 4100;
        @Deprecated
        public static final int LIMIT = 4101;
    }
}

