/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.StandardPlural;
import android.icu.impl.UResource;
import android.icu.impl.number.MultiplierProducer;
import android.icu.text.CompactDecimalFormat;
import android.icu.util.ICUException;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CompactData
implements MultiplierProducer,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String USE_FALLBACK = "<USE FALLBACK>";
    private String[] patterns;
    private byte[] multipliers;
    private byte largestMagnitude;
    private boolean isEmpty;
    private static int COMPACT_MAX_DIGITS = 15;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_number_CompactData$__constructor__() {
        this.patterns = new String[16 * StandardPlural.COUNT];
        this.multipliers = new byte[16];
        this.largestMagnitude = 0;
        this.isEmpty = true;
    }

    private final void $$robo$$android_icu_impl_number_CompactData$populate(ULocale locale, String nsName, CompactDecimalFormat.CompactStyle compactStyle, CompactType compactType) {
        if (!$assertionsDisabled && !this.isEmpty) {
            throw new AssertionError();
        }
        CompactDataSink sink = new CompactDataSink(this);
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b", locale);
        boolean nsIsLatn = nsName.equals("latn");
        boolean compactIsShort = compactStyle == CompactDecimalFormat.CompactStyle.SHORT;
        StringBuilder resourceKey = new StringBuilder();
        CompactData.getResourceBundleKey(nsName, compactStyle, compactType, resourceKey);
        rb.getAllItemsWithFallbackNoFail(resourceKey.toString(), sink);
        if (this.isEmpty && !nsIsLatn) {
            CompactData.getResourceBundleKey("latn", compactStyle, compactType, resourceKey);
            rb.getAllItemsWithFallbackNoFail(resourceKey.toString(), sink);
        }
        if (this.isEmpty && !compactIsShort) {
            CompactData.getResourceBundleKey(nsName, CompactDecimalFormat.CompactStyle.SHORT, compactType, resourceKey);
            rb.getAllItemsWithFallbackNoFail(resourceKey.toString(), sink);
        }
        if (this.isEmpty && !nsIsLatn && !compactIsShort) {
            CompactData.getResourceBundleKey("latn", CompactDecimalFormat.CompactStyle.SHORT, compactType, resourceKey);
            rb.getAllItemsWithFallbackNoFail(resourceKey.toString(), sink);
        }
        if (this.isEmpty) {
            throw new ICUException("Could not load compact decimal data for locale " + locale);
        }
    }

    private static final void $$robo$$android_icu_impl_number_CompactData$getResourceBundleKey(String nsName, CompactDecimalFormat.CompactStyle compactStyle, CompactType compactType, StringBuilder sb) {
        sb.setLength(0);
        sb.append("NumberElements/");
        sb.append(nsName);
        sb.append(compactStyle == CompactDecimalFormat.CompactStyle.SHORT ? "/patternsShort" : "/patternsLong");
        sb.append(compactType == CompactType.DECIMAL ? "/decimalFormat" : "/currencyFormat");
    }

    private final void $$robo$$android_icu_impl_number_CompactData$populate(Map<String, Map<String, String>> powersToPluralsToPatterns) {
        if (!$assertionsDisabled && !this.isEmpty) {
            throw new AssertionError();
        }
        for (Map.Entry<String, Map<String, String>> magnitudeEntry : powersToPluralsToPatterns.entrySet()) {
            byte magnitude = (byte)(magnitudeEntry.getKey().length() - 1);
            for (Map.Entry<String, String> pluralEntry : magnitudeEntry.getValue().entrySet()) {
                String patternString;
                StandardPlural plural = StandardPlural.fromString(pluralEntry.getKey().toString());
                this.patterns[CompactData.getIndex((int)magnitude, (StandardPlural)plural)] = patternString = pluralEntry.getValue().toString();
                int numZeros = CompactData.countZeros(patternString);
                if (numZeros <= 0) continue;
                this.multipliers[magnitude] = (byte)(numZeros - magnitude - 1);
                if (magnitude > this.largestMagnitude) {
                    this.largestMagnitude = magnitude;
                }
                this.isEmpty = false;
            }
        }
    }

    private final int $$robo$$android_icu_impl_number_CompactData$getMultiplier(int magnitude) {
        if (magnitude < 0) {
            return 0;
        }
        if (magnitude > this.largestMagnitude) {
            magnitude = this.largestMagnitude;
        }
        return this.multipliers[magnitude];
    }

    private final String $$robo$$android_icu_impl_number_CompactData$getPattern(int magnitude, StandardPlural plural) {
        String patternString;
        if (magnitude < 0) {
            return null;
        }
        if (magnitude > this.largestMagnitude) {
            magnitude = this.largestMagnitude;
        }
        if ((patternString = this.patterns[CompactData.getIndex(magnitude, plural)]) == null && plural != StandardPlural.OTHER) {
            patternString = this.patterns[CompactData.getIndex(magnitude, StandardPlural.OTHER)];
        }
        if (patternString == "<USE FALLBACK>") {
            patternString = null;
        }
        return patternString;
    }

    private final void $$robo$$android_icu_impl_number_CompactData$getUniquePatterns(Set<String> output) {
        if (!$assertionsDisabled && !output.isEmpty()) {
            throw new AssertionError();
        }
        output.addAll(Arrays.asList(this.patterns));
        output.remove("<USE FALLBACK>");
        output.remove(null);
    }

    private static final int $$robo$$android_icu_impl_number_CompactData$getIndex(int magnitude, StandardPlural plural) {
        return magnitude * StandardPlural.COUNT + plural.ordinal();
    }

    private static final int $$robo$$android_icu_impl_number_CompactData$countZeros(String patternString) {
        int numZeros = 0;
        for (int i = 0; i < patternString.length(); ++i) {
            if (patternString.charAt(i) == '0') {
                ++numZeros;
                continue;
            }
            if (numZeros > 0) break;
        }
        return numZeros;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !CompactData.class.desiredAssertionStatus();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_number_CompactData$__constructor__();
    }

    public CompactData() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_CompactData$__constructor__(), this);
    }

    public void populate(ULocale uLocale, String string2, CompactDecimalFormat.CompactStyle compactStyle, CompactType compactType) {
        InvokeDynamicSupport.bootstrap("populate", $$robo$$android_icu_impl_number_CompactData$populate(android.icu.util.ULocale java.lang.String android.icu.text.CompactDecimalFormat$CompactStyle android.icu.impl.number.CompactData$CompactType ), this, uLocale, string2, compactStyle, compactType);
    }

    private static void getResourceBundleKey(String string2, CompactDecimalFormat.CompactStyle compactStyle, CompactType compactType, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("getResourceBundleKey", $$robo$$android_icu_impl_number_CompactData$getResourceBundleKey(java.lang.String android.icu.text.CompactDecimalFormat$CompactStyle android.icu.impl.number.CompactData$CompactType java.lang.StringBuilder ), (String)string2, (CompactDecimalFormat.CompactStyle)compactStyle, (CompactType)compactType, (StringBuilder)stringBuilder);
    }

    public void populate(Map<String, Map<String, String>> map) {
        InvokeDynamicSupport.bootstrap("populate", $$robo$$android_icu_impl_number_CompactData$populate(java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.String>> ), this, map);
    }

    @Override
    public int getMultiplier(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMultiplier", $$robo$$android_icu_impl_number_CompactData$getMultiplier(int ), this, n);
    }

    public String getPattern(int n, StandardPlural standardPlural) {
        return InvokeDynamicSupport.bootstrap("getPattern", $$robo$$android_icu_impl_number_CompactData$getPattern(int android.icu.impl.StandardPlural ), this, n, standardPlural);
    }

    public void getUniquePatterns(Set<String> set) {
        InvokeDynamicSupport.bootstrap("getUniquePatterns", $$robo$$android_icu_impl_number_CompactData$getUniquePatterns(java.util.Set<java.lang.String> ), this, set);
    }

    private static int getIndex(int n, StandardPlural standardPlural) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIndex", $$robo$$android_icu_impl_number_CompactData$getIndex(int android.icu.impl.StandardPlural ), (int)n, (StandardPlural)standardPlural);
    }

    private static int countZeros(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("countZeros", $$robo$$android_icu_impl_number_CompactData$countZeros(java.lang.String ), (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(CompactData.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompactData)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CompactDataSink
    extends UResource.Sink
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        CompactData data;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_impl_number_CompactData_CompactDataSink$__constructor__(CompactData data) {
            this.data = data;
        }

        private final void $$robo$$android_icu_impl_number_CompactData_CompactDataSink$put(UResource.Key key, UResource.Value value, boolean isRoot) {
            UResource.Table powersOfTenTable = value.getTable();
            int i3 = 0;
            while (powersOfTenTable.getKeyAndValue(i3, key, value)) {
                byte magnitude = (byte)(key.length() - 1);
                byte multiplier = this.data.multipliers[magnitude];
                if (!$assertionsDisabled && magnitude >= 15) {
                    throw new AssertionError();
                }
                UResource.Table pluralVariantsTable = value.getTable();
                int i4 = 0;
                while (pluralVariantsTable.getKeyAndValue(i4, key, value)) {
                    StandardPlural plural = StandardPlural.fromString(key.toString());
                    if (this.data.patterns[CompactData.getIndex(magnitude, plural)] == null) {
                        int numZeros;
                        String patternString = value.toString();
                        if (patternString.equals("0")) {
                            patternString = "<USE FALLBACK>";
                        }
                        ((CompactData)this.data).patterns[CompactData.getIndex((int)magnitude, (StandardPlural)plural)] = patternString;
                        if (multiplier == 0 && (numZeros = CompactData.countZeros(patternString)) > 0) {
                            multiplier = (byte)(numZeros - magnitude - 1);
                        }
                    }
                    ++i4;
                }
                if (this.data.multipliers[magnitude] == 0) {
                    ((CompactData)this.data).multipliers[magnitude] = multiplier;
                    if (magnitude > this.data.largestMagnitude) {
                        this.data.largestMagnitude = magnitude;
                    }
                    this.data.isEmpty = false;
                } else if (!$assertionsDisabled && this.data.multipliers[magnitude] != multiplier) {
                    throw new AssertionError();
                }
                ++i3;
            }
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !CompactData.class.desiredAssertionStatus();
        }

        private void __constructor__(CompactData compactData) {
            this.$$robo$$android_icu_impl_number_CompactData_CompactDataSink$__constructor__(compactData);
        }

        public CompactDataSink(CompactData compactData) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_CompactData_CompactDataSink$__constructor__(android.icu.impl.number.CompactData ), this, compactData);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_impl_number_CompactData_CompactDataSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), this, key, value, bl);
        }

        static {
            RobolectricInternals.classInitializing(CompactDataSink.class);
        }

        public /* synthetic */ CompactDataSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompactDataSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CompactType
    extends Enum<CompactType> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ CompactType DECIMAL;
        public static /* enum */ CompactType CURRENCY;
        private static /* synthetic */ CompactType[] $VALUES;

        private static final CompactType[] $$robo$$android_icu_impl_number_CompactData_CompactType$values() {
            return (CompactType[])$VALUES.clone();
        }

        private static final CompactType $$robo$$android_icu_impl_number_CompactData_CompactType$valueOf(String name) {
            return Enum.valueOf(CompactType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_number_CompactData_CompactType$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            DECIMAL = new CompactType();
            CURRENCY = new CompactType();
            $VALUES = new CompactType[]{DECIMAL, CURRENCY};
        }

        public static CompactType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_number_CompactData_CompactType$values());
        }

        public static CompactType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_number_CompactData_CompactType$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_impl_number_CompactData_CompactType$__constructor__(string2, n);
        }

        public CompactType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_CompactData_CompactType$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(CompactType.class);
        }

        public /* synthetic */ CompactType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompactType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

