/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.locale;

import android.icu.impl.locale.XCldrStub;
import android.icu.impl.locale.XLikelySubtags;
import android.icu.impl.locale.XLocaleDistance;
import android.icu.util.LocalePriorityList;
import android.icu.util.Output;
import android.icu.util.ULocale;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class XLocaleMatcher
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static XLikelySubtags.LSR UND;
    private static ULocale UND_LOCALE;
    private XLocaleDistance localeDistance;
    private int thresholdDistance;
    private int demotionPerAdditionalDesiredLocale;
    private XLocaleDistance.DistanceOption distanceOption;
    private Map<XLikelySubtags.LSR, Set<ULocale>> supportedLanguages;
    private Set<ULocale> exactSupportedLocales;
    private ULocale defaultLanguage;

    private static final Builder $$robo$$android_icu_impl_locale_XLocaleMatcher$builder() {
        return new Builder();
    }

    private void $$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(String supportedLocales) {
    }

    private void $$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(LocalePriorityList supportedLocales) {
    }

    private void $$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(Set<ULocale> supportedLocales) {
    }

    private void $$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(Builder builder) {
        this.localeDistance = builder.localeDistance == null ? XLocaleDistance.getDefault() : builder.localeDistance;
        this.thresholdDistance = builder.thresholdDistance < 0 ? this.localeDistance.getDefaultScriptDistance() : builder.thresholdDistance;
        Set<XLikelySubtags.LSR> paradigms = this.extractLsrSet(this.localeDistance.getParadigms());
        XCldrStub.Multimap<XLikelySubtags.LSR, ULocale> temp2 = this.extractLsrMap(builder.supportedLanguagesList, paradigms);
        this.supportedLanguages = temp2.asMap();
        this.exactSupportedLocales = XCldrStub.ImmutableSet.copyOf(temp2.values());
        this.defaultLanguage = builder.defaultLanguage != null ? builder.defaultLanguage : (this.supportedLanguages.isEmpty() ? null : this.supportedLanguages.entrySet().iterator().next().getValue().iterator().next());
        this.demotionPerAdditionalDesiredLocale = builder.demotionPerAdditionalDesiredLocale < 0 ? this.localeDistance.getDefaultRegionDistance() + 1 : builder.demotionPerAdditionalDesiredLocale;
        this.distanceOption = builder.distanceOption;
    }

    private final Set<XLikelySubtags.LSR> $$robo$$android_icu_impl_locale_XLocaleMatcher$extractLsrSet(Set<ULocale> languagePriorityList) {
        LinkedHashSet<XLikelySubtags.LSR> result = new LinkedHashSet<XLikelySubtags.LSR>();
        for (ULocale item : languagePriorityList) {
            XLikelySubtags.LSR max = item.equals(UND_LOCALE) ? UND : XLikelySubtags.LSR.fromMaximalized(item);
            result.add(max);
        }
        return result;
    }

    private final XCldrStub.Multimap<XLikelySubtags.LSR, ULocale> $$robo$$android_icu_impl_locale_XLocaleMatcher$extractLsrMap(Set<ULocale> languagePriorityList, Set<XLikelySubtags.LSR> priorities) {
        XCldrStub.LinkedHashMultimap<XLikelySubtags.LSR, ULocale> builder = XCldrStub.LinkedHashMultimap.create();
        for (ULocale item : languagePriorityList) {
            XLikelySubtags.LSR max = item.equals(UND_LOCALE) ? UND : XLikelySubtags.LSR.fromMaximalized(item);
            builder.put(max, item);
        }
        if (builder.size() > 1 && priorities != null) {
            XCldrStub.LinkedHashMultimap<XLikelySubtags.LSR, ULocale> builder2 = XCldrStub.LinkedHashMultimap.create();
            boolean first = true;
            for (Map.Entry entry : builder.asMap().entrySet()) {
                XLikelySubtags.LSR key = (XLikelySubtags.LSR)entry.getKey();
                if (!first && !priorities.contains(key)) continue;
                builder2.putAll(key, entry.getValue());
                first = false;
            }
            builder2.putAll(builder);
            if (!builder2.equals(builder)) {
                throw new IllegalArgumentException();
            }
            builder = builder2;
        }
        return XCldrStub.ImmutableMultimap.copyOf(builder);
    }

    private final ULocale $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(ULocale ulocale) {
        return this.getBestMatch(ulocale, (Output<ULocale>)null);
    }

    private final ULocale $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(String languageList) {
        return this.getBestMatch(LocalePriorityList.add(languageList).build(), null);
    }

    private final ULocale $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(ULocale ... locales) {
        return this.getBestMatch(new LinkedHashSet<ULocale>(Arrays.asList(locales)), null);
    }

    private final ULocale $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(Set<ULocale> desiredLanguages) {
        return this.getBestMatch(desiredLanguages, null);
    }

    private final ULocale $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(LocalePriorityList desiredLanguages) {
        return this.getBestMatch(desiredLanguages, null);
    }

    private final ULocale $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(LocalePriorityList desiredLanguages, Output<ULocale> outputBestDesired) {
        return this.getBestMatch(XLocaleMatcher.asSet(desiredLanguages), outputBestDesired);
    }

    private static final Set<ULocale> $$robo$$android_icu_impl_locale_XLocaleMatcher$asSet(LocalePriorityList languageList) {
        LinkedHashSet<ULocale> temp = new LinkedHashSet<ULocale>();
        for (ULocale locale : languageList) {
            temp.add(locale);
        }
        return temp;
    }

    private final ULocale $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(Set<ULocale> desiredLanguages, Output<ULocale> outputBestDesired) {
        if (desiredLanguages.size() == 1) {
            return this.getBestMatch(desiredLanguages.iterator().next(), outputBestDesired);
        }
        XCldrStub.Multimap<XLikelySubtags.LSR, ULocale> desiredLSRs = this.extractLsrMap(desiredLanguages, null);
        int bestDistance = Integer.MAX_VALUE;
        ULocale bestDesiredLocale = null;
        Collection bestSupportedLocales = null;
        int delta = 0;
        block0: for (Map.Entry<XLikelySubtags.LSR, ULocale> desiredLsrAndLocale : desiredLSRs.entries()) {
            ULocale desiredLocale = desiredLsrAndLocale.getValue();
            XLikelySubtags.LSR desiredLSR = desiredLsrAndLocale.getKey();
            if (delta < bestDistance) {
                if (this.exactSupportedLocales.contains(desiredLocale)) {
                    if (outputBestDesired != null) {
                        outputBestDesired.value = desiredLocale;
                    }
                    return desiredLocale;
                }
                Collection found = this.supportedLanguages.get(desiredLSR);
                if (found != null) {
                    if (outputBestDesired != null) {
                        outputBestDesired.value = desiredLocale;
                    }
                    return (ULocale)found.iterator().next();
                }
            }
            for (Map.Entry<XLikelySubtags.LSR, Set<ULocale>> supportedLsrAndLocale : this.supportedLanguages.entrySet()) {
                int distance = delta + this.localeDistance.distanceRaw(desiredLSR, supportedLsrAndLocale.getKey(), this.thresholdDistance, this.distanceOption);
                if (distance >= bestDistance) continue;
                bestDistance = distance;
                bestDesiredLocale = desiredLocale;
                bestSupportedLocales = supportedLsrAndLocale.getValue();
                if (distance != 0) continue;
                break block0;
            }
            delta += this.demotionPerAdditionalDesiredLocale;
        }
        if (bestDistance >= this.thresholdDistance) {
            if (outputBestDesired != null) {
                outputBestDesired.value = null;
            }
            return this.defaultLanguage;
        }
        if (outputBestDesired != null) {
            outputBestDesired.value = bestDesiredLocale;
        }
        if (bestSupportedLocales.contains(bestDesiredLocale)) {
            return bestDesiredLocale;
        }
        return (ULocale)bestSupportedLocales.iterator().next();
    }

    private final ULocale $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(ULocale desiredLocale, Output<ULocale> outputBestDesired) {
        Collection found;
        XLikelySubtags.LSR desiredLSR;
        int bestDistance = Integer.MAX_VALUE;
        ULocale bestDesiredLocale = null;
        Collection bestSupportedLocales = null;
        XLikelySubtags.LSR lSR = desiredLSR = desiredLocale.equals(UND_LOCALE) ? UND : XLikelySubtags.LSR.fromMaximalized(desiredLocale);
        if (this.exactSupportedLocales.contains(desiredLocale)) {
            if (outputBestDesired != null) {
                outputBestDesired.value = desiredLocale;
            }
            return desiredLocale;
        }
        if (this.distanceOption == XLocaleDistance.DistanceOption.NORMAL && (found = (Collection)this.supportedLanguages.get(desiredLSR)) != null) {
            if (outputBestDesired != null) {
                outputBestDesired.value = desiredLocale;
            }
            return (ULocale)found.iterator().next();
        }
        for (Map.Entry<XLikelySubtags.LSR, Set<ULocale>> supportedLsrAndLocale : this.supportedLanguages.entrySet()) {
            int distance = this.localeDistance.distanceRaw(desiredLSR, supportedLsrAndLocale.getKey(), this.thresholdDistance, this.distanceOption);
            if (distance >= bestDistance) continue;
            bestDistance = distance;
            bestDesiredLocale = desiredLocale;
            bestSupportedLocales = supportedLsrAndLocale.getValue();
            if (distance != 0) continue;
            break;
        }
        if (bestDistance >= this.thresholdDistance) {
            if (outputBestDesired != null) {
                outputBestDesired.value = null;
            }
            return this.defaultLanguage;
        }
        if (outputBestDesired != null) {
            outputBestDesired.value = bestDesiredLocale;
        }
        if (bestSupportedLocales.contains(bestDesiredLocale)) {
            return bestDesiredLocale;
        }
        return (ULocale)bestSupportedLocales.iterator().next();
    }

    private static final ULocale $$robo$$android_icu_impl_locale_XLocaleMatcher$combine(ULocale bestSupported, ULocale bestDesired) {
        if (!bestSupported.equals(bestDesired) && bestDesired != null) {
            String variants;
            ULocale.Builder b = new ULocale.Builder().setLocale(bestSupported);
            String region = bestDesired.getCountry();
            if (!region.isEmpty()) {
                b.setRegion(region);
            }
            if (!(variants = bestDesired.getVariant()).isEmpty()) {
                b.setVariant(variants);
            }
            for (char extensionKey : bestDesired.getExtensionKeys()) {
                b.setExtension(extensionKey, bestDesired.getExtension(extensionKey));
            }
            bestSupported = b.build();
        }
        return bestSupported;
    }

    private final int $$robo$$android_icu_impl_locale_XLocaleMatcher$distance(ULocale desired, ULocale supported) {
        return this.localeDistance.distanceRaw(XLikelySubtags.LSR.fromMaximalized(desired), XLikelySubtags.LSR.fromMaximalized(supported), this.thresholdDistance, this.distanceOption);
    }

    private final int $$robo$$android_icu_impl_locale_XLocaleMatcher$distance(String desiredLanguage, String supportedLanguage) {
        return this.localeDistance.distanceRaw(XLikelySubtags.LSR.fromMaximalized(new ULocale(desiredLanguage)), XLikelySubtags.LSR.fromMaximalized(new ULocale(supportedLanguage)), this.thresholdDistance, this.distanceOption);
    }

    private final String $$robo$$android_icu_impl_locale_XLocaleMatcher$toString() {
        return this.exactSupportedLocales.toString();
    }

    private final double $$robo$$android_icu_impl_locale_XLocaleMatcher$match(ULocale desired, ULocale supported) {
        return (double)(100 - this.distance(desired, supported)) / 100.0;
    }

    @Deprecated
    private final double $$robo$$android_icu_impl_locale_XLocaleMatcher$match(ULocale desired, ULocale desiredMax, ULocale supported, ULocale supportedMax) {
        return this.match(desired, supported);
    }

    private final ULocale $$robo$$android_icu_impl_locale_XLocaleMatcher$canonicalize(ULocale ulocale) {
        return null;
    }

    private final int $$robo$$android_icu_impl_locale_XLocaleMatcher$getThresholdDistance() {
        return this.thresholdDistance;
    }

    private /* synthetic */ void $$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(Builder x0, 1 x1) {
    }

    static void __staticInitializer__() {
        UND = new XLikelySubtags.LSR("und", "", "");
        UND_LOCALE = new ULocale("und");
    }

    public static Builder builder() {
        return InvokeDynamicSupport.bootstrapStatic("builder", $$robo$$android_icu_impl_locale_XLocaleMatcher$builder());
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(string2);
    }

    public XLocaleMatcher(String string2) {
        this(XLocaleMatcher.builder().setSupportedLocales(string2));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(java.lang.String ), this, string2);
    }

    private void __constructor__(LocalePriorityList localePriorityList) {
        this.$$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(localePriorityList);
    }

    public XLocaleMatcher(LocalePriorityList localePriorityList) {
        this(XLocaleMatcher.builder().setSupportedLocales(localePriorityList));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(android.icu.util.LocalePriorityList ), this, localePriorityList);
    }

    private void __constructor__(Set<ULocale> set) {
        this.$$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(set);
    }

    public XLocaleMatcher(Set<ULocale> set) {
        this(XLocaleMatcher.builder().setSupportedLocales(set));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(java.util.Set<android.icu.util.ULocale> ), this, set);
    }

    private void __constructor__(Builder builder) {
        this.$$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(builder);
    }

    public XLocaleMatcher(Builder builder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(android.icu.impl.locale.XLocaleMatcher$Builder ), this, builder);
    }

    private Set<XLikelySubtags.LSR> extractLsrSet(Set<ULocale> set) {
        return InvokeDynamicSupport.bootstrap("extractLsrSet", $$robo$$android_icu_impl_locale_XLocaleMatcher$extractLsrSet(java.util.Set<android.icu.util.ULocale> ), this, set);
    }

    private XCldrStub.Multimap<XLikelySubtags.LSR, ULocale> extractLsrMap(Set<ULocale> set, Set<XLikelySubtags.LSR> set2) {
        return InvokeDynamicSupport.bootstrap("extractLsrMap", $$robo$$android_icu_impl_locale_XLocaleMatcher$extractLsrMap(java.util.Set<android.icu.util.ULocale> java.util.Set<android.icu.impl.locale.XLikelySubtags$LSR> ), this, set, set2);
    }

    public ULocale getBestMatch(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getBestMatch", $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(android.icu.util.ULocale ), this, uLocale);
    }

    public ULocale getBestMatch(String string2) {
        return InvokeDynamicSupport.bootstrap("getBestMatch", $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(java.lang.String ), this, string2);
    }

    public ULocale getBestMatch(ULocale ... uLocaleArray) {
        return InvokeDynamicSupport.bootstrap("getBestMatch", $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(android.icu.util.ULocale[] ), this, uLocaleArray);
    }

    public ULocale getBestMatch(Set<ULocale> set) {
        return InvokeDynamicSupport.bootstrap("getBestMatch", $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(java.util.Set<android.icu.util.ULocale> ), this, set);
    }

    public ULocale getBestMatch(LocalePriorityList localePriorityList) {
        return InvokeDynamicSupport.bootstrap("getBestMatch", $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(android.icu.util.LocalePriorityList ), this, localePriorityList);
    }

    public ULocale getBestMatch(LocalePriorityList localePriorityList, Output<ULocale> output) {
        return InvokeDynamicSupport.bootstrap("getBestMatch", $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(android.icu.util.LocalePriorityList android.icu.util.Output<android.icu.util.ULocale> ), this, localePriorityList, output);
    }

    private static Set<ULocale> asSet(LocalePriorityList localePriorityList) {
        return InvokeDynamicSupport.bootstrapStatic("asSet", $$robo$$android_icu_impl_locale_XLocaleMatcher$asSet(android.icu.util.LocalePriorityList ), (LocalePriorityList)localePriorityList);
    }

    public ULocale getBestMatch(Set<ULocale> set, Output<ULocale> output) {
        return InvokeDynamicSupport.bootstrap("getBestMatch", $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(java.util.Set<android.icu.util.ULocale> android.icu.util.Output<android.icu.util.ULocale> ), this, set, output);
    }

    public ULocale getBestMatch(ULocale uLocale, Output<ULocale> output) {
        return InvokeDynamicSupport.bootstrap("getBestMatch", $$robo$$android_icu_impl_locale_XLocaleMatcher$getBestMatch(android.icu.util.ULocale android.icu.util.Output<android.icu.util.ULocale> ), this, uLocale, output);
    }

    public static ULocale combine(ULocale uLocale, ULocale uLocale2) {
        return InvokeDynamicSupport.bootstrapStatic("combine", $$robo$$android_icu_impl_locale_XLocaleMatcher$combine(android.icu.util.ULocale android.icu.util.ULocale ), (ULocale)uLocale, (ULocale)uLocale2);
    }

    public int distance(ULocale uLocale, ULocale uLocale2) {
        return (int)InvokeDynamicSupport.bootstrap("distance", $$robo$$android_icu_impl_locale_XLocaleMatcher$distance(android.icu.util.ULocale android.icu.util.ULocale ), this, uLocale, uLocale2);
    }

    public int distance(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("distance", $$robo$$android_icu_impl_locale_XLocaleMatcher$distance(java.lang.String java.lang.String ), this, string2, string3);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_XLocaleMatcher$toString(), this);
    }

    public double match(ULocale uLocale, ULocale uLocale2) {
        return (double)InvokeDynamicSupport.bootstrap("match", $$robo$$android_icu_impl_locale_XLocaleMatcher$match(android.icu.util.ULocale android.icu.util.ULocale ), this, uLocale, uLocale2);
    }

    @Deprecated
    public double match(ULocale uLocale, ULocale uLocale2, ULocale uLocale3, ULocale uLocale4) {
        return (double)InvokeDynamicSupport.bootstrap("match", $$robo$$android_icu_impl_locale_XLocaleMatcher$match(android.icu.util.ULocale android.icu.util.ULocale android.icu.util.ULocale android.icu.util.ULocale ), this, uLocale, uLocale2, uLocale3, uLocale4);
    }

    public ULocale canonicalize(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("canonicalize", $$robo$$android_icu_impl_locale_XLocaleMatcher$canonicalize(android.icu.util.ULocale ), this, uLocale);
    }

    public int getThresholdDistance() {
        return (int)InvokeDynamicSupport.bootstrap("getThresholdDistance", $$robo$$android_icu_impl_locale_XLocaleMatcher$getThresholdDistance(), this);
    }

    private /* synthetic */ void __constructor__(Builder builder, 1 var2_2) {
        this.$$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(builder, var2_2);
    }

    public /* synthetic */ XLocaleMatcher(Builder builder, 1 var2_2) {
        this(builder);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleMatcher$__constructor__(android.icu.impl.locale.XLocaleMatcher$Builder android.icu.impl.locale.XLocaleMatcher$1 ), this, builder, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(XLocaleMatcher.class);
    }

    public /* synthetic */ XLocaleMatcher() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (XLocaleMatcher)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Set<ULocale> supportedLanguagesList;
        private int thresholdDistance;
        private int demotionPerAdditionalDesiredLocale;
        private ULocale defaultLanguage;
        private XLocaleDistance localeDistance;
        private XLocaleDistance.DistanceOption distanceOption;

        private void $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$__constructor__() {
            this.thresholdDistance = -1;
            this.demotionPerAdditionalDesiredLocale = -1;
        }

        private final Builder $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setSupportedLocales(String languagePriorityList) {
            this.supportedLanguagesList = XLocaleMatcher.asSet(LocalePriorityList.add(languagePriorityList).build());
            return this;
        }

        private final Builder $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setSupportedLocales(LocalePriorityList languagePriorityList) {
            this.supportedLanguagesList = XLocaleMatcher.asSet(languagePriorityList);
            return this;
        }

        private final Builder $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setSupportedLocales(Set<ULocale> languagePriorityList) {
            this.supportedLanguagesList = languagePriorityList;
            return this;
        }

        private final Builder $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setThresholdDistance(int thresholdDistance) {
            this.thresholdDistance = thresholdDistance;
            return this;
        }

        private final Builder $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setDemotionPerAdditionalDesiredLocale(int demotionPerAdditionalDesiredLocale) {
            this.demotionPerAdditionalDesiredLocale = demotionPerAdditionalDesiredLocale;
            return this;
        }

        private final Builder $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setLocaleDistance(XLocaleDistance localeDistance) {
            this.localeDistance = localeDistance;
            return this;
        }

        private final Builder $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setDefaultLanguage(ULocale defaultLanguage) {
            this.defaultLanguage = defaultLanguage;
            return this;
        }

        private final Builder $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setDistanceOption(XLocaleDistance.DistanceOption distanceOption) {
            this.distanceOption = distanceOption;
            return this;
        }

        private final XLocaleMatcher $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$build() {
            return new XLocaleMatcher(this, null);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$__constructor__(), this);
        }

        public Builder setSupportedLocales(String string2) {
            return InvokeDynamicSupport.bootstrap("setSupportedLocales", $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setSupportedLocales(java.lang.String ), this, string2);
        }

        public Builder setSupportedLocales(LocalePriorityList localePriorityList) {
            return InvokeDynamicSupport.bootstrap("setSupportedLocales", $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setSupportedLocales(android.icu.util.LocalePriorityList ), this, localePriorityList);
        }

        public Builder setSupportedLocales(Set<ULocale> set) {
            return InvokeDynamicSupport.bootstrap("setSupportedLocales", $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setSupportedLocales(java.util.Set<android.icu.util.ULocale> ), this, set);
        }

        public Builder setThresholdDistance(int n) {
            return InvokeDynamicSupport.bootstrap("setThresholdDistance", $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setThresholdDistance(int ), this, n);
        }

        public Builder setDemotionPerAdditionalDesiredLocale(int n) {
            return InvokeDynamicSupport.bootstrap("setDemotionPerAdditionalDesiredLocale", $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setDemotionPerAdditionalDesiredLocale(int ), this, n);
        }

        public Builder setLocaleDistance(XLocaleDistance xLocaleDistance) {
            return InvokeDynamicSupport.bootstrap("setLocaleDistance", $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setLocaleDistance(android.icu.impl.locale.XLocaleDistance ), this, xLocaleDistance);
        }

        public Builder setDefaultLanguage(ULocale uLocale) {
            return InvokeDynamicSupport.bootstrap("setDefaultLanguage", $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setDefaultLanguage(android.icu.util.ULocale ), this, uLocale);
        }

        public Builder setDistanceOption(XLocaleDistance.DistanceOption distanceOption) {
            return InvokeDynamicSupport.bootstrap("setDistanceOption", $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$setDistanceOption(android.icu.impl.locale.XLocaleDistance$DistanceOption ), this, distanceOption);
        }

        public XLocaleMatcher build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_icu_impl_locale_XLocaleMatcher_Builder$build(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

