/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.locale;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.Row;
import android.icu.impl.Utility;
import android.icu.impl.locale.XCldrStub;
import android.icu.impl.locale.XLikelySubtags;
import android.icu.text.LocaleDisplayNames;
import android.icu.util.LocaleMatcher;
import android.icu.util.Output;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import android.icu.util.UResourceBundleIterator;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class XLocaleDistance
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static boolean PRINT_OVERRIDES = false;
    public static int ABOVE_THRESHOLD = 100;
    @Deprecated
    public static String ANY = "\ufffd";
    static LocaleDisplayNames english;
    static XCldrStub.Multimap<String, String> CONTAINER_TO_CONTAINED;
    static XCldrStub.Multimap<String, String> CONTAINER_TO_CONTAINED_FINAL;
    private static Set<String> ALL_FINAL_REGIONS;
    private DistanceTable languageDesired2Supported;
    private RegionMapper regionMapper;
    private int defaultLanguageDistance;
    private int defaultScriptDistance;
    private int defaultRegionDistance;
    private static XLocaleDistance DEFAULT;
    static /* synthetic */ boolean $assertionsDisabled;

    private static final String $$robo$$android_icu_impl_locale_XLocaleDistance$fixAny(String string2) {
        return "*".equals(string2) ? "\ufffd" : string2;
    }

    private static final List<Row.R4<String, String, Integer, Boolean>> $$robo$$android_icu_impl_locale_XLocaleDistance$xGetLanguageMatcherData() {
        ArrayList<Row.R4> distanceList = new ArrayList<Row.R4>();
        ICUResourceBundle suppData = LocaleMatcher.getICUSupplementalData();
        UResourceBundle languageMatchingNew = suppData.findTopLevel("languageMatchingNew");
        ICUResourceBundle written = (ICUResourceBundle)languageMatchingNew.get("written");
        UResourceBundleIterator iter = written.getIterator();
        while (iter.hasNext()) {
            ICUResourceBundle item = (ICUResourceBundle)iter.next();
            boolean oneway = item.getSize() > 3 && "1".equals(item.getString(3));
            distanceList.add((Row.R4)Row.of(item.getString(0), item.getString(1), Integer.parseInt(item.getString(2)), oneway).freeze());
        }
        return Collections.unmodifiableList(distanceList);
    }

    private static final Set<String> $$robo$$android_icu_impl_locale_XLocaleDistance$xGetParadigmLocales() {
        ICUResourceBundle suppData = LocaleMatcher.getICUSupplementalData();
        UResourceBundle languageMatchingInfo = suppData.findTopLevel("languageMatchingInfo");
        ICUResourceBundle writtenParadigmLocales = (ICUResourceBundle)languageMatchingInfo.get("written").get("paradigmLocales");
        HashSet<String> paradigmLocales = new HashSet<String>(Arrays.asList(writtenParadigmLocales.getStringArray()));
        return Collections.unmodifiableSet(paradigmLocales);
    }

    private static final Map<String, String> $$robo$$android_icu_impl_locale_XLocaleDistance$xGetMatchVariables() {
        ICUResourceBundle suppData = LocaleMatcher.getICUSupplementalData();
        UResourceBundle languageMatchingInfo = suppData.findTopLevel("languageMatchingInfo");
        ICUResourceBundle writtenMatchVariables = (ICUResourceBundle)languageMatchingInfo.get("written").get("matchVariable");
        HashMap<String, String> matchVariables = new HashMap<String, String>();
        Enumeration<String> enumer = writtenMatchVariables.getKeys();
        while (enumer.hasMoreElements()) {
            String key = enumer.nextElement();
            matchVariables.put(key, writtenMatchVariables.getString(key));
        }
        return Collections.unmodifiableMap(matchVariables);
    }

    private static final XCldrStub.Multimap<String, String> $$robo$$android_icu_impl_locale_XLocaleDistance$xGetContainment() {
        XCldrStub.TreeMultimap<String, String> containment = XCldrStub.TreeMultimap.create();
        containment.putAll("001", "019", "002", "150", "142", "009").putAll("011", (String[])new String[]{"BF", "BJ", "CI", "CV", "GH", "GM", "GN", "GW", "LR", "ML", "MR", "NE", "NG", "SH", "SL", "SN", "TG"}).putAll("013", (String[])new String[]{"BZ", "CR", "GT", "HN", "MX", "NI", "PA", "SV"}).putAll("014", (String[])new String[]{"BI", "DJ", "ER", "ET", "KE", "KM", "MG", "MU", "MW", "MZ", "RE", "RW", "SC", "SO", "SS", "TZ", "UG", "YT", "ZM", "ZW"}).putAll("142", (String[])new String[]{"145", "143", "030", "034", "035"}).putAll("143", (String[])new String[]{"TM", "TJ", "KG", "KZ", "UZ"}).putAll("145", (String[])new String[]{"AE", "AM", "AZ", "BH", "CY", "GE", "IL", "IQ", "JO", "KW", "LB", "OM", "PS", "QA", "SA", "SY", "TR", "YE", "NT", "YD"}).putAll("015", (String[])new String[]{"DZ", "EG", "EH", "LY", "MA", "SD", "TN", "EA", "IC"}).putAll("150", (String[])new String[]{"154", "155", "151", "039"}).putAll("151", (String[])new String[]{"BG", "BY", "CZ", "HU", "MD", "PL", "RO", "RU", "SK", "UA", "SU"}).putAll("154", (String[])new String[]{"GG", "IM", "JE", "AX", "DK", "EE", "FI", "FO", "GB", "IE", "IS", "LT", "LV", "NO", "SE", "SJ"}).putAll("155", (String[])new String[]{"AT", "BE", "CH", "DE", "FR", "LI", "LU", "MC", "NL", "DD", "FX"}).putAll("017", (String[])new String[]{"AO", "CD", "CF", "CG", "CM", "GA", "GQ", "ST", "TD", "ZR"}).putAll("018", (String[])new String[]{"BW", "LS", "NA", "SZ", "ZA"}).putAll("019", (String[])new String[]{"021", "013", "029", "005", "003", "419"}).putAll("002", (String[])new String[]{"015", "011", "017", "014", "018"}).putAll("021", (String[])new String[]{"BM", "CA", "GL", "PM", "US"}).putAll("029", (String[])new String[]{"AG", "AI", "AW", "BB", "BL", "BQ", "BS", "CU", "CW", "DM", "DO", "GD", "GP", "HT", "JM", "KN", "KY", "LC", "MF", "MQ", "MS", "PR", "SX", "TC", "TT", "VC", "VG", "VI", "AN"}).putAll("003", (String[])new String[]{"021", "013", "029"}).putAll("030", (String[])new String[]{"CN", "HK", "JP", "KP", "KR", "MN", "MO", "TW"}).putAll("035", (String[])new String[]{"BN", "ID", "KH", "LA", "MM", "MY", "PH", "SG", "TH", "TL", "VN", "BU", "TP"}).putAll("039", (String[])new String[]{"AD", "AL", "BA", "ES", "GI", "GR", "HR", "IT", "ME", "MK", "MT", "RS", "PT", "SI", "SM", "VA", "XK", "CS", "YU"}).putAll("419", (String[])new String[]{"013", "029", "005"}).putAll("005", (String[])new String[]{"AR", "BO", "BR", "CL", "CO", "EC", "FK", "GF", "GY", "PE", "PY", "SR", "UY", "VE"}).putAll("053", (String[])new String[]{"AU", "NF", "NZ"}).putAll("054", (String[])new String[]{"FJ", "NC", "PG", "SB", "VU"}).putAll("057", (String[])new String[]{"FM", "GU", "KI", "MH", "MP", "NR", "PW"}).putAll("061", (String[])new String[]{"AS", "CK", "NU", "PF", "PN", "TK", "TO", "TV", "WF", "WS"}).putAll("034", (String[])new String[]{"AF", "BD", "BT", "IN", "IR", "LK", "MV", "NP", "PK"}).putAll("009", (String[])new String[]{"053", "054", "057", "061", "QO"}).putAll("QO", (String[])new String[]{"AQ", "BV", "CC", "CX", "GS", "HM", "IO", "TF", "UM", "AC", "CP", "DG", "TA"});
        XCldrStub.TreeMultimap<String, String> containmentResolved = XCldrStub.TreeMultimap.create();
        XLocaleDistance.fill("001", containment, containmentResolved);
        return XCldrStub.ImmutableMultimap.copyOf(containmentResolved);
    }

    private static final Set<String> $$robo$$android_icu_impl_locale_XLocaleDistance$fill(String region, XCldrStub.TreeMultimap<String, String> containment, XCldrStub.Multimap<String, String> toAddTo) {
        Set contained = containment.get(region);
        if (contained == null) {
            return Collections.emptySet();
        }
        toAddTo.putAll(region, contained);
        for (String subregion : contained) {
            toAddTo.putAll(region, (Collection<String>)XLocaleDistance.fill(subregion, containment, toAddTo));
        }
        return toAddTo.get(region);
    }

    private void $$robo$$android_icu_impl_locale_XLocaleDistance$__constructor__(DistanceTable datadistancetable2, RegionMapper regionMapper) {
        this.languageDesired2Supported = datadistancetable2;
        this.regionMapper = regionMapper;
        StringDistanceNode languageNode = (StringDistanceNode)((StringDistanceTable)this.languageDesired2Supported).subtables.get("\ufffd").get("\ufffd");
        this.defaultLanguageDistance = languageNode.distance;
        StringDistanceNode scriptNode = (StringDistanceNode)((StringDistanceTable)languageNode.distanceTable).subtables.get("\ufffd").get("\ufffd");
        this.defaultScriptDistance = scriptNode.distance;
        DistanceNode regionNode = ((StringDistanceTable)scriptNode.distanceTable).subtables.get("\ufffd").get("\ufffd");
        this.defaultRegionDistance = regionNode.distance;
    }

    private static final Map $$robo$$android_icu_impl_locale_XLocaleDistance$newMap() {
        return new TreeMap();
    }

    private final int $$robo$$android_icu_impl_locale_XLocaleDistance$distance(ULocale desired, ULocale supported, int threshold, DistanceOption distanceOption) {
        XLikelySubtags.LSR supportedLSR = XLikelySubtags.LSR.fromMaximalized(supported);
        XLikelySubtags.LSR desiredLSR = XLikelySubtags.LSR.fromMaximalized(desired);
        return this.distanceRaw(desiredLSR, supportedLSR, threshold, distanceOption);
    }

    private final int $$robo$$android_icu_impl_locale_XLocaleDistance$distanceRaw(XLikelySubtags.LSR desired, XLikelySubtags.LSR supported, int threshold, DistanceOption distanceOption) {
        return this.distanceRaw(desired.language, supported.language, desired.script, supported.script, desired.region, supported.region, threshold, distanceOption);
    }

    private final int $$robo$$android_icu_impl_locale_XLocaleDistance$distanceRaw(String desiredLang, String supportedlang, String desiredScript, String supportedScript, String desiredRegion, String supportedRegion, int threshold, DistanceOption distanceOption) {
        int subdistance;
        Set<String> supportedPartitions;
        boolean scriptFirst;
        Output<DistanceTable> subtable = new Output<DistanceTable>();
        int distance = this.languageDesired2Supported.getDistance(desiredLang, supportedlang, subtable, true);
        boolean bl = scriptFirst = distanceOption == DistanceOption.SCRIPT_FIRST;
        if (scriptFirst) {
            distance >>= 2;
        }
        if (distance < 0) {
            distance = 0;
        } else if (distance >= threshold) {
            return 100;
        }
        int scriptDistance = ((DistanceTable)subtable.value).getDistance(desiredScript, supportedScript, subtable, true);
        if (scriptFirst) {
            scriptDistance >>= 1;
        }
        if ((distance += scriptDistance) >= threshold) {
            return 100;
        }
        if (desiredRegion.equals(supportedRegion)) {
            return distance;
        }
        String desiredPartition = this.regionMapper.toId(desiredRegion);
        String supportedPartition = this.regionMapper.toId(supportedRegion);
        Set<String> desiredPartitions = desiredPartition.isEmpty() ? this.regionMapper.macroToPartitions.get(desiredRegion) : null;
        Set<String> set = supportedPartitions = supportedPartition.isEmpty() ? this.regionMapper.macroToPartitions.get(supportedRegion) : null;
        if (desiredPartitions != null || supportedPartitions != null) {
            subdistance = 0;
            if (desiredPartitions == null) {
                desiredPartitions = Collections.singleton(desiredPartition);
            }
            if (supportedPartitions == null) {
                supportedPartitions = Collections.singleton(supportedPartition);
            }
            for (String desiredPartition2 : desiredPartitions) {
                for (String supportedPartition2 : supportedPartitions) {
                    int tempSubdistance = ((DistanceTable)subtable.value).getDistance(desiredPartition2, supportedPartition2, null, false);
                    if (subdistance >= tempSubdistance) continue;
                    subdistance = tempSubdistance;
                }
            }
        } else {
            subdistance = ((DistanceTable)subtable.value).getDistance(desiredPartition, supportedPartition, null, false);
        }
        return (distance += subdistance) >= threshold ? 100 : distance;
    }

    private static final XLocaleDistance $$robo$$android_icu_impl_locale_XLocaleDistance$getDefault() {
        return DEFAULT;
    }

    private static final void $$robo$$android_icu_impl_locale_XLocaleDistance$printMatchXml(List<String> desired, List<String> supported, Integer distance, Boolean oneway) {
    }

    private static final String $$robo$$android_icu_impl_locale_XLocaleDistance$fixedName(List<String> match) {
        ArrayList<String> alt = new ArrayList<String>(match);
        int size = alt.size();
        if (!($assertionsDisabled || size >= 1 && size <= 3)) {
            throw new AssertionError();
        }
        StringBuilder result = new StringBuilder();
        if (size >= 3) {
            String region = (String)alt.get(2);
            if (region.equals("*") || region.startsWith("$")) {
                result.append(region);
            } else {
                result.append(english.regionDisplayName(region));
            }
        }
        if (size >= 2) {
            String script = (String)alt.get(1);
            if (script.equals("*")) {
                result.insert(0, script);
            } else {
                result.insert(0, english.scriptDisplayName(script));
            }
        }
        if (size >= 1) {
            String language = (String)alt.get(0);
            if (language.equals("*")) {
                result.insert(0, language);
            } else {
                result.insert(0, english.languageDisplayName(language));
            }
        }
        return XCldrStub.CollectionUtilities.join(alt, "; ");
    }

    private static final void $$robo$$android_icu_impl_locale_XLocaleDistance$add(StringDistanceTable languageDesired2Supported, List<String> desired, List<String> supported, int percentage) {
        int size = desired.size();
        if (size != supported.size() || size < 1 || size > 3) {
            throw new IllegalArgumentException();
        }
        String desiredLang = XLocaleDistance.fixAny(desired.get(0));
        String supportedLang = XLocaleDistance.fixAny(supported.get(0));
        if (size == 1) {
            languageDesired2Supported.addSubtable(desiredLang, supportedLang, percentage);
        } else {
            String desiredScript = XLocaleDistance.fixAny(desired.get(1));
            String supportedScript = XLocaleDistance.fixAny(supported.get(1));
            if (size == 2) {
                languageDesired2Supported.addSubtables(desiredLang, supportedLang, desiredScript, supportedScript, percentage);
            } else {
                String desiredRegion = XLocaleDistance.fixAny(desired.get(2));
                String supportedRegion = XLocaleDistance.fixAny(supported.get(2));
                languageDesired2Supported.addSubtables(desiredLang, supportedLang, desiredScript, supportedScript, desiredRegion, supportedRegion, percentage);
            }
        }
    }

    private final String $$robo$$android_icu_impl_locale_XLocaleDistance$toString() {
        return this.toString(false);
    }

    private final String $$robo$$android_icu_impl_locale_XLocaleDistance$toString(boolean abbreviate) {
        return this.regionMapper + "\n" + this.languageDesired2Supported.toString(abbreviate);
    }

    private static final Set<String> $$robo$$android_icu_impl_locale_XLocaleDistance$getContainingMacrosFor(Collection<String> input, Set<String> output) {
        output.clear();
        for (Map.Entry<String, Set<String>> entry : CONTAINER_TO_CONTAINED.asMap().entrySet()) {
            if (!input.containsAll((Collection)entry.getValue())) continue;
            output.add(entry.getKey());
        }
        return output;
    }

    private static final <K, V> XCldrStub.Multimap<K, V> $$robo$$android_icu_impl_locale_XLocaleDistance$invertMap(Map<V, K> map) {
        return XCldrStub.Multimaps.invertFrom(XCldrStub.Multimaps.forMap(map), XCldrStub.LinkedHashMultimap.create());
    }

    private final Set<ULocale> $$robo$$android_icu_impl_locale_XLocaleDistance$getParadigms() {
        return this.regionMapper.paradigms;
    }

    private final int $$robo$$android_icu_impl_locale_XLocaleDistance$getDefaultLanguageDistance() {
        return this.defaultLanguageDistance;
    }

    private final int $$robo$$android_icu_impl_locale_XLocaleDistance$getDefaultScriptDistance() {
        return this.defaultScriptDistance;
    }

    private final int $$robo$$android_icu_impl_locale_XLocaleDistance$getDefaultRegionDistance() {
        return this.defaultRegionDistance;
    }

    @Deprecated
    private final StringDistanceTable $$robo$$android_icu_impl_locale_XLocaleDistance$internalGetDistanceTable() {
        return (StringDistanceTable)this.languageDesired2Supported;
    }

    private static final void $$robo$$android_icu_impl_locale_XLocaleDistance$main(String[] args) {
        DistanceTable table = XLocaleDistance.getDefault().languageDesired2Supported;
        DistanceTable compactedTable = table.compact();
        if (!table.equals(compactedTable)) {
            throw new IllegalArgumentException("Compaction isn't equal");
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !XLocaleDistance.class.desiredAssertionStatus();
        english = LocaleDisplayNames.getInstance(ULocale.ENGLISH);
        CONTAINER_TO_CONTAINED = XLocaleDistance.xGetContainment();
        XCldrStub.TreeMultimap<String, String> containerToFinalContainedBuilder = XCldrStub.TreeMultimap.create();
        for (Map.Entry<String, Set<String>> entry : CONTAINER_TO_CONTAINED.asMap().entrySet()) {
            String container = entry.getKey();
            for (String contained : entry.getValue()) {
                if (CONTAINER_TO_CONTAINED.get(contained) != null) continue;
                containerToFinalContainedBuilder.put(container, contained);
            }
        }
        CONTAINER_TO_CONTAINED_FINAL = XCldrStub.ImmutableMultimap.copyOf(containerToFinalContainedBuilder);
        ALL_FINAL_REGIONS = XCldrStub.ImmutableSet.copyOf(CONTAINER_TO_CONTAINED_FINAL.get("001"));
        String[][] variableOverrides = new String[][]{{"$enUS", "AS+GU+MH+MP+PR+UM+US+VI"}, {"$cnsar", "HK+MO"}, {"$americas", "019"}, {"$maghreb", "MA+DZ+TN+LY+MR+EH"}};
        String[] paradigmRegions = new String[]{"en", "en-GB", "es", "es-419", "pt-BR", "pt-PT"};
        String[][] regionRuleOverrides = new String[][]{{"ar_*_$maghreb", "ar_*_$maghreb", "96"}, {"ar_*_$!maghreb", "ar_*_$!maghreb", "96"}, {"ar_*_*", "ar_*_*", "95"}, {"en_*_$enUS", "en_*_$enUS", "96"}, {"en_*_$!enUS", "en_*_$!enUS", "96"}, {"en_*_*", "en_*_*", "95"}, {"es_*_$americas", "es_*_$americas", "96"}, {"es_*_$!americas", "es_*_$!americas", "96"}, {"es_*_*", "es_*_*", "95"}, {"pt_*_$americas", "pt_*_$americas", "96"}, {"pt_*_$!americas", "pt_*_$!americas", "96"}, {"pt_*_*", "pt_*_*", "95"}, {"zh_Hant_$cnsar", "zh_Hant_$cnsar", "96"}, {"zh_Hant_$!cnsar", "zh_Hant_$!cnsar", "96"}, {"zh_Hant_*", "zh_Hant_*", "95"}, {"*_*_*", "*_*_*", "96"}};
        RegionMapper.Builder rmb = new RegionMapper.Builder().addParadigms(paradigmRegions);
        for (String[] variableRule : variableOverrides) {
            rmb.add(variableRule[0], variableRule[1]);
        }
        StringDistanceTable defaultDistanceTable = new StringDistanceTable();
        RegionMapper defaultRegionMapper = rmb.build();
        XCldrStub.Splitter bar = XCldrStub.Splitter.on('_');
        ArrayList[] sorted = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
        for (Row.R4<String, String, Integer, Boolean> info : XLocaleDistance.xGetLanguageMatcherData()) {
            String desiredRaw = (String)info.get0();
            String string2 = (String)info.get1();
            List<String> desired = bar.splitToList(desiredRaw);
            List<String> supported = bar.splitToList(string2);
            Boolean oneway = (Boolean)info.get3();
            int distance = desiredRaw.equals("*_*") ? 50 : (Integer)info.get2();
            int size = desired.size();
            if (size == 3) continue;
            sorted[size - 1].add(Row.of(desired, supported, distance, oneway));
        }
        for (ArrayList arrayList : sorted) {
            for (Row.R4 item2 : arrayList) {
                List desired = (List)item2.get0();
                List supported = (List)item2.get1();
                Integer distance = (Integer)item2.get2();
                Boolean oneway = (Boolean)item2.get3();
                XLocaleDistance.add(defaultDistanceTable, desired, supported, distance);
                if (oneway != Boolean.TRUE && !desired.equals(supported)) {
                    XLocaleDistance.add(defaultDistanceTable, supported, desired, distance);
                }
                XLocaleDistance.printMatchXml(desired, supported, distance, oneway);
            }
        }
        for (ArrayList arrayList : regionRuleOverrides) {
            ArrayList<String> desiredBase = new ArrayList<String>(bar.splitToList((String)((Object)arrayList[0])));
            ArrayList<String> supportedBase = new ArrayList<String>(bar.splitToList((String)((Object)arrayList[1])));
            Integer distance = 100 - Integer.parseInt((String)((Object)arrayList[2]));
            XLocaleDistance.printMatchXml(desiredBase, supportedBase, distance, false);
            Collection<String> desiredRegions = defaultRegionMapper.getIdsFromVariable((String)desiredBase.get(2));
            if (desiredRegions.isEmpty()) {
                throw new IllegalArgumentException("Bad region variable: " + (String)desiredBase.get(2));
            }
            Collection<String> supportedRegions = defaultRegionMapper.getIdsFromVariable((String)supportedBase.get(2));
            if (supportedRegions.isEmpty()) {
                throw new IllegalArgumentException("Bad region variable: " + (String)supportedBase.get(2));
            }
            for (String desiredRegion2 : desiredRegions) {
                desiredBase.set(2, desiredRegion2.toString());
                for (String supportedRegion2 : supportedRegions) {
                    supportedBase.set(2, supportedRegion2.toString());
                    XLocaleDistance.add(defaultDistanceTable, desiredBase, supportedBase, distance);
                    XLocaleDistance.add(defaultDistanceTable, supportedBase, desiredBase, distance);
                }
            }
        }
        DEFAULT = new XLocaleDistance(defaultDistanceTable.compact(), defaultRegionMapper);
    }

    private static String fixAny(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fixAny", $$robo$$android_icu_impl_locale_XLocaleDistance$fixAny(java.lang.String ), (String)string2);
    }

    private static List<Row.R4<String, String, Integer, Boolean>> xGetLanguageMatcherData() {
        return InvokeDynamicSupport.bootstrapStatic("xGetLanguageMatcherData", $$robo$$android_icu_impl_locale_XLocaleDistance$xGetLanguageMatcherData());
    }

    private static Set<String> xGetParadigmLocales() {
        return InvokeDynamicSupport.bootstrapStatic("xGetParadigmLocales", $$robo$$android_icu_impl_locale_XLocaleDistance$xGetParadigmLocales());
    }

    private static Map<String, String> xGetMatchVariables() {
        return InvokeDynamicSupport.bootstrapStatic("xGetMatchVariables", $$robo$$android_icu_impl_locale_XLocaleDistance$xGetMatchVariables());
    }

    private static XCldrStub.Multimap<String, String> xGetContainment() {
        return InvokeDynamicSupport.bootstrapStatic("xGetContainment", $$robo$$android_icu_impl_locale_XLocaleDistance$xGetContainment());
    }

    private static Set<String> fill(String string2, XCldrStub.TreeMultimap<String, String> treeMultimap, XCldrStub.Multimap<String, String> multimap) {
        return InvokeDynamicSupport.bootstrapStatic("fill", $$robo$$android_icu_impl_locale_XLocaleDistance$fill(java.lang.String android.icu.impl.locale.XCldrStub$TreeMultimap<java.lang.String, java.lang.String> android.icu.impl.locale.XCldrStub$Multimap<java.lang.String, java.lang.String> ), (String)string2, treeMultimap, multimap);
    }

    private void __constructor__(DistanceTable distanceTable, RegionMapper regionMapper) {
        this.$$robo$$android_icu_impl_locale_XLocaleDistance$__constructor__(distanceTable, regionMapper);
    }

    public XLocaleDistance(DistanceTable distanceTable, RegionMapper regionMapper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance$__constructor__(android.icu.impl.locale.XLocaleDistance$DistanceTable android.icu.impl.locale.XLocaleDistance$RegionMapper ), this, distanceTable, regionMapper);
    }

    private static Map newMap() {
        return InvokeDynamicSupport.bootstrapStatic("newMap", $$robo$$android_icu_impl_locale_XLocaleDistance$newMap());
    }

    public int distance(ULocale uLocale, ULocale uLocale2, int n, DistanceOption distanceOption) {
        return (int)InvokeDynamicSupport.bootstrap("distance", $$robo$$android_icu_impl_locale_XLocaleDistance$distance(android.icu.util.ULocale android.icu.util.ULocale int android.icu.impl.locale.XLocaleDistance$DistanceOption ), this, uLocale, uLocale2, n, distanceOption);
    }

    public int distanceRaw(XLikelySubtags.LSR lSR, XLikelySubtags.LSR lSR2, int n, DistanceOption distanceOption) {
        return (int)InvokeDynamicSupport.bootstrap("distanceRaw", $$robo$$android_icu_impl_locale_XLocaleDistance$distanceRaw(android.icu.impl.locale.XLikelySubtags$LSR android.icu.impl.locale.XLikelySubtags$LSR int android.icu.impl.locale.XLocaleDistance$DistanceOption ), this, lSR, lSR2, n, distanceOption);
    }

    public int distanceRaw(String string2, String string3, String string4, String string5, String string6, String string7, int n, DistanceOption distanceOption) {
        return (int)InvokeDynamicSupport.bootstrap("distanceRaw", $$robo$$android_icu_impl_locale_XLocaleDistance$distanceRaw(java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String int android.icu.impl.locale.XLocaleDistance$DistanceOption ), this, string2, string3, string4, string5, string6, string7, n, distanceOption);
    }

    public static XLocaleDistance getDefault() {
        return InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$android_icu_impl_locale_XLocaleDistance$getDefault());
    }

    private static void printMatchXml(List<String> list, List<String> list2, Integer n, Boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("printMatchXml", $$robo$$android_icu_impl_locale_XLocaleDistance$printMatchXml(java.util.List<java.lang.String> java.util.List<java.lang.String> java.lang.Integer java.lang.Boolean ), list, list2, (Integer)n, (Boolean)bl);
    }

    private static String fixedName(List<String> list) {
        return InvokeDynamicSupport.bootstrapStatic("fixedName", $$robo$$android_icu_impl_locale_XLocaleDistance$fixedName(java.util.List<java.lang.String> ), list);
    }

    public static void add(StringDistanceTable stringDistanceTable, List<String> list, List<String> list2, int n) {
        InvokeDynamicSupport.bootstrapStatic("add", $$robo$$android_icu_impl_locale_XLocaleDistance$add(android.icu.impl.locale.XLocaleDistance$StringDistanceTable java.util.List<java.lang.String> java.util.List<java.lang.String> int ), (StringDistanceTable)stringDistanceTable, list, list2, (int)n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_XLocaleDistance$toString(), this);
    }

    public String toString(boolean bl) {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_XLocaleDistance$toString(boolean ), this, bl);
    }

    static Set<String> getContainingMacrosFor(Collection<String> collection, Set<String> set) {
        return InvokeDynamicSupport.bootstrapStatic("getContainingMacrosFor", $$robo$$android_icu_impl_locale_XLocaleDistance$getContainingMacrosFor(java.util.Collection<java.lang.String> java.util.Set<java.lang.String> ), collection, set);
    }

    public static <K, V> XCldrStub.Multimap<K, V> invertMap(Map<V, K> map) {
        return InvokeDynamicSupport.bootstrapStatic("invertMap", $$robo$$android_icu_impl_locale_XLocaleDistance$invertMap(java.util.Map<V, K> ), map);
    }

    public Set<ULocale> getParadigms() {
        return InvokeDynamicSupport.bootstrap("getParadigms", $$robo$$android_icu_impl_locale_XLocaleDistance$getParadigms(), this);
    }

    public int getDefaultLanguageDistance() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultLanguageDistance", $$robo$$android_icu_impl_locale_XLocaleDistance$getDefaultLanguageDistance(), this);
    }

    public int getDefaultScriptDistance() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultScriptDistance", $$robo$$android_icu_impl_locale_XLocaleDistance$getDefaultScriptDistance(), this);
    }

    public int getDefaultRegionDistance() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultRegionDistance", $$robo$$android_icu_impl_locale_XLocaleDistance$getDefaultRegionDistance(), this);
    }

    @Deprecated
    public StringDistanceTable internalGetDistanceTable() {
        return InvokeDynamicSupport.bootstrap("internalGetDistanceTable", $$robo$$android_icu_impl_locale_XLocaleDistance$internalGetDistanceTable(), this);
    }

    public static void main(String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("main", $$robo$$android_icu_impl_locale_XLocaleDistance$main(java.lang.String[] ), (String[])stringArray);
    }

    static {
        RobolectricInternals.classInitializing(XLocaleDistance.class);
    }

    public /* synthetic */ XLocaleDistance() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (XLocaleDistance)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class CompactAndImmutablizer
    extends IdMakerFull<Object> {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_CompactAndImmutablizer$__constructor__() {
        }

        private final StringDistanceTable $$robo$$android_icu_impl_locale_XLocaleDistance_CompactAndImmutablizer$compact(StringDistanceTable item) {
            if (this.toId(item) != null) {
                return this.intern(item);
            }
            return new StringDistanceTable(this.compact(item.subtables, 0));
        }

        private final <K, T> Map<K, T> $$robo$$android_icu_impl_locale_XLocaleDistance_CompactAndImmutablizer$compact(Map<K, T> item, int level) {
            if (this.toId(item) != null) {
                return this.intern(item);
            }
            LinkedHashMap<K, Object> copy = new LinkedHashMap<K, Object>();
            for (Map.Entry<K, T> entry : item.entrySet()) {
                T value = entry.getValue();
                if (value instanceof Map) {
                    copy.put(entry.getKey(), this.compact((Map)value, level + 1));
                    continue;
                }
                copy.put(entry.getKey(), this.compact((DistanceNode)value));
            }
            return XCldrStub.ImmutableMap.copyOf(copy);
        }

        private final DistanceNode $$robo$$android_icu_impl_locale_XLocaleDistance_CompactAndImmutablizer$compact(DistanceNode item) {
            if (this.toId(item) != null) {
                return this.intern(item);
            }
            DistanceTable distanceTable = item.getDistanceTable();
            if (distanceTable == null || distanceTable.isEmpty()) {
                return new DistanceNode(item.distance);
            }
            return new StringDistanceNode(item.distance, this.compact((StringDistanceTable)((StringDistanceNode)item).distanceTable));
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_CompactAndImmutablizer$__constructor__();
        }

        public CompactAndImmutablizer() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_CompactAndImmutablizer$__constructor__(), this);
        }

        StringDistanceTable compact(StringDistanceTable stringDistanceTable) {
            return InvokeDynamicSupport.bootstrap("compact", $$robo$$android_icu_impl_locale_XLocaleDistance_CompactAndImmutablizer$compact(android.icu.impl.locale.XLocaleDistance$StringDistanceTable ), this, stringDistanceTable);
        }

        <K, T> Map<K, T> compact(Map<K, T> map, int n) {
            return InvokeDynamicSupport.bootstrap("compact", $$robo$$android_icu_impl_locale_XLocaleDistance_CompactAndImmutablizer$compact(java.util.Map<K, T> int ), this, map, n);
        }

        DistanceNode compact(DistanceNode distanceNode) {
            return InvokeDynamicSupport.bootstrap("compact", $$robo$$android_icu_impl_locale_XLocaleDistance_CompactAndImmutablizer$compact(android.icu.impl.locale.XLocaleDistance$DistanceNode ), this, distanceNode);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompactAndImmutablizer)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class RegionSet
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Set<String> tempRegions;
        private Operation operation;

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$__constructor__() {
            this.tempRegions = new TreeSet<String>();
            this.operation = null;
        }

        private final Set<String> $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$parseSet(String barString) {
            int i;
            this.operation = Operation.add;
            int last = 0;
            this.tempRegions.clear();
            block4: for (i = 0; i < barString.length(); ++i) {
                char c = barString.charAt(i);
                switch (c) {
                    case '+': {
                        this.add(barString, last, i);
                        last = i + 1;
                        this.operation = Operation.add;
                        continue block4;
                    }
                    case '-': {
                        this.add(barString, last, i);
                        last = i + 1;
                        this.operation = Operation.remove;
                    }
                }
            }
            this.add(barString, last, i);
            return this.tempRegions;
        }

        private final Set<String> $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$inverse() {
            TreeSet<String> result = new TreeSet<String>(ALL_FINAL_REGIONS);
            result.removeAll(this.tempRegions);
            return result;
        }

        private final void $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$add(String barString, int last, int i) {
            if (i > last) {
                String region = barString.substring(last, i);
                this.changeSet(this.operation, region);
            }
        }

        private final void $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$changeSet(Operation operation, String region) {
            Set<String> contained = CONTAINER_TO_CONTAINED_FINAL.get(region);
            if (contained != null && !contained.isEmpty()) {
                if (Operation.add == operation) {
                    this.tempRegions.addAll(contained);
                } else {
                    this.tempRegions.removeAll(contained);
                }
            } else if (Operation.add == operation) {
                this.tempRegions.add(region);
            } else {
                this.tempRegions.remove(region);
            }
        }

        private /* synthetic */ void $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$__constructor__();
        }

        public RegionSet() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$__constructor__(), this);
        }

        private Set<String> parseSet(String string2) {
            return InvokeDynamicSupport.bootstrap("parseSet", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$parseSet(java.lang.String ), this, string2);
        }

        private Set<String> inverse() {
            return InvokeDynamicSupport.bootstrap("inverse", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$inverse(), this);
        }

        private void add(String string2, int n, int n2) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$add(java.lang.String int int ), this, string2, n, n2);
        }

        private void changeSet(Operation operation, String string2) {
            InvokeDynamicSupport.bootstrap("changeSet", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$changeSet(android.icu.impl.locale.XLocaleDistance$RegionSet$Operation java.lang.String ), this, operation, string2);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$__constructor__(var1_1);
        }

        public /* synthetic */ RegionSet(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet$__constructor__(android.icu.impl.locale.XLocaleDistance$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RegionSet)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private static final class Operation
        extends Enum<Operation> {
            public /* synthetic */ Object __robo_data__;
            public static /* enum */ Operation add;
            public static /* enum */ Operation remove;
            private static /* synthetic */ Operation[] $VALUES;

            private static final Operation[] $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet_Operation$values() {
                return (Operation[])$VALUES.clone();
            }

            private static final Operation $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet_Operation$valueOf(String name) {
                return Enum.valueOf(Operation.class, name);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet_Operation$__constructor__(String string2, int n) {
            }

            static void __staticInitializer__() {
                add = new Operation();
                remove = new Operation();
                $VALUES = new Operation[]{add, remove};
            }

            public static Operation[] values() {
                return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet_Operation$values());
            }

            public static Operation valueOf(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet_Operation$valueOf(java.lang.String ), (String)string2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void __constructor__(String string2, int n) {
                this.$$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet_Operation$__constructor__(string2, n);
            }

            public Operation() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionSet_Operation$__constructor__(java.lang.String int ), this, string2, n);
            }

            static {
                RobolectricInternals.classInitializing(Operation.class);
            }

            public /* synthetic */ Operation() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Operation)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class RegionMapper
    implements IdMapper<String, String> {
        public /* synthetic */ Object __robo_data__;
        XCldrStub.Multimap<String, String> variableToPartition;
        Map<String, String> regionToPartition;
        XCldrStub.Multimap<String, String> macroToPartitions;
        Set<ULocale> paradigms;

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$__constructor__(XCldrStub.Multimap<String, String> variableToPartitionIn, Map<String, String> regionToPartitionIn, XCldrStub.Multimap<String, String> macroToPartitionsIn, Set<ULocale> paradigmsIn) {
            this.variableToPartition = XCldrStub.ImmutableMultimap.copyOf(variableToPartitionIn);
            this.regionToPartition = XCldrStub.ImmutableMap.copyOf(regionToPartitionIn);
            this.macroToPartitions = XCldrStub.ImmutableMultimap.copyOf(macroToPartitionsIn);
            this.paradigms = XCldrStub.ImmutableSet.copyOf(paradigmsIn);
        }

        private final String $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$toId(String region) {
            String result = this.regionToPartition.get(region);
            return result == null ? "" : result;
        }

        private final Collection<String> $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$getIdsFromVariable(String variable) {
            if (variable.equals("*")) {
                return Collections.singleton("*");
            }
            Set<String> result = this.variableToPartition.get(variable);
            if (result == null || result.isEmpty()) {
                throw new IllegalArgumentException("Variable not defined: " + variable);
            }
            return result;
        }

        private final Set<String> $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$regions() {
            return this.regionToPartition.keySet();
        }

        private final Set<String> $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$variables() {
            return this.variableToPartition.keySet();
        }

        private final String $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$toString() {
            XCldrStub.TreeMultimap partitionToVariables = XCldrStub.Multimaps.invertFrom(this.variableToPartition, XCldrStub.TreeMultimap.create());
            XCldrStub.TreeMultimap<String, String> partitionToRegions = XCldrStub.TreeMultimap.create();
            for (Map.Entry<String, String> e : this.regionToPartition.entrySet()) {
                partitionToRegions.put(e.getValue(), e.getKey());
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("Partition \u27a0 Variables \u27a0 Regions (final)");
            for (Map.Entry entry : partitionToVariables.asMap().entrySet()) {
                buffer.append('\n');
                buffer.append((String)entry.getKey() + "\t" + entry.getValue() + "\t" + partitionToRegions.get((String)entry.getKey()));
            }
            buffer.append("\nMacro \u27a0 Partitions");
            for (Map.Entry<Object, Set<Object>> entry : this.macroToPartitions.asMap().entrySet()) {
                buffer.append('\n');
                buffer.append((String)entry.getKey() + "\t" + entry.getValue());
            }
            return buffer.toString();
        }

        private /* synthetic */ void $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$__constructor__(XCldrStub.Multimap x0, Map x1, XCldrStub.Multimap x2, Set x3, 1 x4) {
        }

        private void __constructor__(XCldrStub.Multimap<String, String> multimap, Map<String, String> map, XCldrStub.Multimap<String, String> multimap2, Set<ULocale> set) {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$__constructor__(multimap, map, multimap2, set);
        }

        public RegionMapper(XCldrStub.Multimap<String, String> multimap, Map<String, String> map, XCldrStub.Multimap<String, String> multimap2, Set<ULocale> set) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$__constructor__(android.icu.impl.locale.XCldrStub$Multimap<java.lang.String, java.lang.String> java.util.Map<java.lang.String, java.lang.String> android.icu.impl.locale.XCldrStub$Multimap<java.lang.String, java.lang.String> java.util.Set<android.icu.util.ULocale> ), this, multimap, map, multimap2, set);
        }

        @Override
        public String toId(String string2) {
            return InvokeDynamicSupport.bootstrap("toId", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$toId(java.lang.String ), this, string2);
        }

        public Collection<String> getIdsFromVariable(String string2) {
            return InvokeDynamicSupport.bootstrap("getIdsFromVariable", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$getIdsFromVariable(java.lang.String ), this, string2);
        }

        public Set<String> regions() {
            return InvokeDynamicSupport.bootstrap("regions", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$regions(), this);
        }

        public Set<String> variables() {
            return InvokeDynamicSupport.bootstrap("variables", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$variables(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$toString(), this);
        }

        private /* synthetic */ void __constructor__(XCldrStub.Multimap multimap, Map map, XCldrStub.Multimap multimap2, Set set, 1 var5_5) {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$__constructor__(multimap, map, multimap2, set, var5_5);
        }

        public /* synthetic */ RegionMapper(XCldrStub.Multimap multimap, Map map, XCldrStub.Multimap multimap2, Set set, 1 var5_5) {
            this(multimap, map, multimap2, set);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper$__constructor__(android.icu.impl.locale.XCldrStub$Multimap java.util.Map android.icu.impl.locale.XCldrStub$Multimap java.util.Set android.icu.impl.locale.XLocaleDistance$1 ), this, multimap, map, multimap2, set, var5_5);
        }

        public /* synthetic */ RegionMapper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RegionMapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class Builder
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private XCldrStub.Multimap<String, String> regionToRawPartition;
            private RegionSet regionSet;
            private Set<ULocale> paradigms;

            private void $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper_Builder$__constructor__() {
                this.regionToRawPartition = XCldrStub.TreeMultimap.create();
                this.regionSet = new RegionSet(null);
                this.paradigms = new LinkedHashSet<ULocale>();
            }

            private final void $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper_Builder$add(String variable, String barString) {
                Set tempRegions = this.regionSet.parseSet(barString);
                for (String region : tempRegions) {
                    this.regionToRawPartition.put(region, variable);
                }
                Set inverse = this.regionSet.inverse();
                String inverseVariable = "$!" + variable.substring(1);
                for (String region : inverse) {
                    this.regionToRawPartition.put(region, inverseVariable);
                }
            }

            private final Builder $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper_Builder$addParadigms(String ... paradigmRegions) {
                for (String paradigm : paradigmRegions) {
                    this.paradigms.add(new ULocale(paradigm));
                }
                return this;
            }

            private final RegionMapper $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper_Builder$build() {
                IdMakerFull<Collection> id2 = new IdMakerFull<Collection>("partition");
                XCldrStub.TreeMultimap<String, String> variableToPartitions = XCldrStub.TreeMultimap.create();
                TreeMap<String, String> regionToPartition = new TreeMap<String, String>();
                XCldrStub.TreeMultimap<String, String> partitionToRegions = XCldrStub.TreeMultimap.create();
                for (Map.Entry<String, Set<String>> e : this.regionToRawPartition.asMap().entrySet()) {
                    String region = e.getKey();
                    Collection rawPartition = e.getValue();
                    String partition = String.valueOf((char)(945 + id2.add(rawPartition)));
                    regionToPartition.put(region, partition);
                    partitionToRegions.put(partition, region);
                    for (String variable : rawPartition) {
                        variableToPartitions.put(variable, partition);
                    }
                }
                XCldrStub.TreeMultimap<String, String> macroToPartitions = XCldrStub.TreeMultimap.create();
                for (Map.Entry<String, Set<String>> e : CONTAINER_TO_CONTAINED.asMap().entrySet()) {
                    String macro = e.getKey();
                    for (Map.Entry e2 : partitionToRegions.asMap().entrySet()) {
                        String partition = (String)e2.getKey();
                        if (Collections.disjoint((Collection)e.getValue(), e2.getValue())) continue;
                        macroToPartitions.put(macro, partition);
                    }
                }
                return new RegionMapper(variableToPartitions, regionToPartition, macroToPartitions, this.paradigms, null);
            }

            private void __constructor__() {
                this.$$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper_Builder$__constructor__();
            }

            public Builder() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper_Builder$__constructor__(), this);
            }

            void add(String string2, String string3) {
                InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper_Builder$add(java.lang.String java.lang.String ), this, string2, string3);
            }

            public Builder addParadigms(String ... stringArray) {
                return InvokeDynamicSupport.bootstrap("addParadigms", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper_Builder$addParadigms(java.lang.String[] ), this, stringArray);
            }

            RegionMapper build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_icu_impl_locale_XLocaleDistance_RegionMapper_Builder$build(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class DistanceOption
    extends Enum<DistanceOption> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ DistanceOption NORMAL;
        public static /* enum */ DistanceOption SCRIPT_FIRST;
        private static /* synthetic */ DistanceOption[] $VALUES;

        private static final DistanceOption[] $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceOption$values() {
            return (DistanceOption[])$VALUES.clone();
        }

        private static final DistanceOption $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceOption$valueOf(String name) {
            return Enum.valueOf(DistanceOption.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceOption$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NORMAL = new DistanceOption();
            SCRIPT_FIRST = new DistanceOption();
            $VALUES = new DistanceOption[]{NORMAL, SCRIPT_FIRST};
        }

        public static DistanceOption[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceOption$values());
        }

        public static DistanceOption valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceOption$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_DistanceOption$__constructor__(string2, n);
        }

        public DistanceOption() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceOption$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(DistanceOption.class);
        }

        public /* synthetic */ DistanceOption() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DistanceOption)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AddSub
    implements XCldrStub.Predicate<DistanceNode> {
        public /* synthetic */ Object __robo_data__;
        private String desiredSub;
        private String supportedSub;
        private CopyIfEmpty r;

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_AddSub$__constructor__(String desiredSub, String supportedSub, StringDistanceTable distanceTableToCopy) {
            this.r = new CopyIfEmpty(distanceTableToCopy);
            this.desiredSub = desiredSub;
            this.supportedSub = supportedSub;
        }

        private final boolean $$robo$$android_icu_impl_locale_XLocaleDistance_AddSub$test(DistanceNode node) {
            if (node == null) {
                throw new IllegalArgumentException("bad structure");
            }
            ((StringDistanceNode)node).addSubtables(this.desiredSub, this.supportedSub, this.r);
            return true;
        }

        private void __constructor__(String string2, String string3, StringDistanceTable stringDistanceTable) {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_AddSub$__constructor__(string2, string3, stringDistanceTable);
        }

        public AddSub(String string2, String string3, StringDistanceTable stringDistanceTable) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_AddSub$__constructor__(java.lang.String java.lang.String android.icu.impl.locale.XLocaleDistance$StringDistanceTable ), this, string2, string3, stringDistanceTable);
        }

        @Override
        public boolean test(DistanceNode distanceNode) {
            return (boolean)InvokeDynamicSupport.bootstrap("test", $$robo$$android_icu_impl_locale_XLocaleDistance_AddSub$test(android.icu.impl.locale.XLocaleDistance$DistanceNode ), this, distanceNode);
        }

        public /* synthetic */ AddSub() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AddSub)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CopyIfEmpty
    implements XCldrStub.Predicate<DistanceNode> {
        public /* synthetic */ Object __robo_data__;
        private StringDistanceTable toCopy;

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_CopyIfEmpty$__constructor__(StringDistanceTable resetIfNotNull) {
            this.toCopy = resetIfNotNull;
        }

        private final boolean $$robo$$android_icu_impl_locale_XLocaleDistance_CopyIfEmpty$test(DistanceNode node) {
            StringDistanceTable subtables = (StringDistanceTable)node.getDistanceTable();
            if (subtables.subtables.isEmpty()) {
                subtables.copy(this.toCopy);
            }
            return true;
        }

        private void __constructor__(StringDistanceTable stringDistanceTable) {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_CopyIfEmpty$__constructor__(stringDistanceTable);
        }

        public CopyIfEmpty(StringDistanceTable stringDistanceTable) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_CopyIfEmpty$__constructor__(android.icu.impl.locale.XLocaleDistance$StringDistanceTable ), this, stringDistanceTable);
        }

        @Override
        public boolean test(DistanceNode distanceNode) {
            return (boolean)InvokeDynamicSupport.bootstrap("test", $$robo$$android_icu_impl_locale_XLocaleDistance_CopyIfEmpty$test(android.icu.impl.locale.XLocaleDistance$DistanceNode ), this, distanceNode);
        }

        public /* synthetic */ CopyIfEmpty() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CopyIfEmpty)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class StringDistanceTable
    extends DistanceTable
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Map<String, Map<String, DistanceNode>> subtables;

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$__constructor__(Map<String, Map<String, DistanceNode>> tables) {
            this.subtables = tables;
        }

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$__constructor__() {
        }

        private final boolean $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$isEmpty() {
            return this.subtables.isEmpty();
        }

        private final boolean $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$equals(Object obj) {
            return this == obj || obj != null && obj.getClass() == this.getClass() && this.subtables.equals(((StringDistanceTable)obj).subtables);
        }

        private final int $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$hashCode() {
            return this.subtables.hashCode();
        }

        private final int $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$getDistance(String desired, String supported, Output<DistanceTable> distanceTable, boolean starEquals) {
            DistanceNode value;
            boolean star = false;
            Map<String, DistanceNode> sub2 = this.subtables.get(desired);
            if (sub2 == null) {
                sub2 = this.subtables.get("\ufffd");
                star = true;
            }
            if ((value = sub2.get(supported)) == null) {
                value = sub2.get("\ufffd");
                if (value == null && !star && (value = (sub2 = this.subtables.get("\ufffd")).get(supported)) == null) {
                    value = sub2.get("\ufffd");
                }
                star = true;
            }
            if (distanceTable != null) {
                distanceTable.value = ((StringDistanceNode)value).distanceTable;
            }
            return starEquals && star && desired.equals(supported) ? 0 : value.distance;
        }

        private final void $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$copy(StringDistanceTable other) {
            for (Map.Entry<String, Map<String, DistanceNode>> e1 : other.subtables.entrySet()) {
                for (Map.Entry<String, DistanceNode> e2 : e1.getValue().entrySet()) {
                    DistanceNode value = e2.getValue();
                    DistanceNode distanceNode = this.addSubtable(e1.getKey(), e2.getKey(), value.distance);
                }
            }
        }

        private final DistanceNode $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$addSubtable(String desired, String supported, int distance) {
            DistanceNode oldNode;
            Map sub2 = this.subtables.get(desired);
            if (sub2 == null) {
                sub2 = XLocaleDistance.newMap();
                this.subtables.put(desired, sub2);
            }
            if ((oldNode = sub2.get(supported)) != null) {
                return oldNode;
            }
            StringDistanceNode newNode = new StringDistanceNode(distance);
            sub2.put(supported, newNode);
            return newNode;
        }

        private final DistanceNode $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$getNode(String desired, String supported) {
            Map<String, DistanceNode> sub2 = this.subtables.get(desired);
            if (sub2 == null) {
                return null;
            }
            return sub2.get(supported);
        }

        private final void $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$addSubtables(String desired, String supported, XCldrStub.Predicate<DistanceNode> action) {
            DistanceNode node = this.getNode(desired, supported);
            if (node == null) {
                Output<DistanceTable> node2 = new Output<DistanceTable>();
                int distance = this.getDistance(desired, supported, node2, true);
                node = this.addSubtable(desired, supported, distance);
                if (node2.value != null) {
                    ((StringDistanceNode)node).copyTables((StringDistanceTable)node2.value);
                }
            }
            action.test(node);
        }

        private final void $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$addSubtables(String desiredLang, String supportedLang, String desiredScript, String supportedScript, int percentage) {
            boolean haveKeys = false;
            for (Map.Entry<String, Map<String, DistanceNode>> e1 : this.subtables.entrySet()) {
                String key1 = e1.getKey();
                boolean desiredIsKey = desiredLang.equals(key1);
                if (!desiredIsKey && !desiredLang.equals("\ufffd")) continue;
                for (Map.Entry<String, DistanceNode> e2 : e1.getValue().entrySet()) {
                    String key2 = e2.getKey();
                    boolean supportedIsKey = supportedLang.equals(key2);
                    haveKeys |= desiredIsKey && supportedIsKey;
                    if (!supportedIsKey && !supportedLang.equals("\ufffd")) continue;
                    DistanceNode value = e2.getValue();
                    ((StringDistanceTable)value.getDistanceTable()).addSubtable(desiredScript, supportedScript, percentage);
                }
            }
            StringDistanceTable dt = new StringDistanceTable();
            dt.addSubtable(desiredScript, supportedScript, percentage);
            CopyIfEmpty r = new CopyIfEmpty(dt);
            this.addSubtables(desiredLang, supportedLang, r);
        }

        private final void $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$addSubtables(String desiredLang, String supportedLang, String desiredScript, String supportedScript, String desiredRegion, String supportedRegion, int percentage) {
            boolean haveKeys = false;
            for (Map.Entry<String, Map<String, DistanceNode>> e1 : this.subtables.entrySet()) {
                String key1 = e1.getKey();
                boolean desiredIsKey = desiredLang.equals(key1);
                if (!desiredIsKey && !desiredLang.equals("\ufffd")) continue;
                for (Map.Entry<String, DistanceNode> e2 : e1.getValue().entrySet()) {
                    String key2 = e2.getKey();
                    boolean supportedIsKey = supportedLang.equals(key2);
                    haveKeys |= desiredIsKey && supportedIsKey;
                    if (!supportedIsKey && !supportedLang.equals("\ufffd")) continue;
                    StringDistanceNode value = (StringDistanceNode)e2.getValue();
                    ((StringDistanceTable)value.distanceTable).addSubtables(desiredScript, supportedScript, desiredRegion, supportedRegion, percentage);
                }
            }
            StringDistanceTable dt = new StringDistanceTable();
            dt.addSubtable(desiredRegion, supportedRegion, percentage);
            AddSub r = new AddSub(desiredScript, supportedScript, dt);
            this.addSubtables(desiredLang, supportedLang, r);
        }

        private final String $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$toString() {
            return this.toString(false);
        }

        private final String $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$toString(boolean abbreviate) {
            return this.toString(abbreviate, "", new IdMakerFull<Object>("interner"), new StringBuilder()).toString();
        }

        private final StringBuilder $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$toString(boolean abbreviate, String indent, IdMakerFull<Object> intern, StringBuilder buffer) {
            Integer id2;
            String indent2 = indent.isEmpty() ? "" : "\t";
            Integer n = id2 = abbreviate ? intern.getOldAndAdd(this.subtables) : null;
            if (id2 != null) {
                buffer.append(indent2).append('#').append(id2).append('\n');
            } else {
                for (Map.Entry<String, Map<String, DistanceNode>> e1 : this.subtables.entrySet()) {
                    Map<String, DistanceNode> subsubtable = e1.getValue();
                    buffer.append(indent2).append(e1.getKey());
                    String indent3 = "\t";
                    Integer n2 = id2 = abbreviate ? intern.getOldAndAdd(subsubtable) : null;
                    if (id2 != null) {
                        buffer.append(indent3).append('#').append(id2).append('\n');
                    } else {
                        for (Map.Entry<String, DistanceNode> e2 : subsubtable.entrySet()) {
                            DistanceNode value = e2.getValue();
                            buffer.append(indent3).append(e2.getKey());
                            Integer n3 = id2 = abbreviate ? intern.getOldAndAdd(value) : null;
                            if (id2 != null) {
                                buffer.append('\t').append('#').append(id2).append('\n');
                            } else {
                                buffer.append('\t').append(value.distance);
                                DistanceTable distanceTable = value.getDistanceTable();
                                if (distanceTable != null) {
                                    Integer n4 = id2 = abbreviate ? intern.getOldAndAdd(distanceTable) : null;
                                    if (id2 != null) {
                                        buffer.append('\t').append('#').append(id2).append('\n');
                                    } else {
                                        ((StringDistanceTable)distanceTable).toString(abbreviate, indent + "\t\t\t", intern, buffer);
                                    }
                                } else {
                                    buffer.append('\n');
                                }
                            }
                            indent3 = indent + '\t';
                        }
                    }
                    indent2 = indent;
                }
            }
            return buffer;
        }

        private final StringDistanceTable $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$compact() {
            return new CompactAndImmutablizer().compact(this);
        }

        private final Set<String> $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$getCloser(int threshold) {
            HashSet<String> result = new HashSet<String>();
            block0: for (Map.Entry<String, Map<String, DistanceNode>> e1 : this.subtables.entrySet()) {
                String desired = e1.getKey();
                for (Map.Entry<String, DistanceNode> e2 : e1.getValue().entrySet()) {
                    if (e2.getValue().distance >= threshold) continue;
                    result.add(desired);
                    continue block0;
                }
            }
            return result;
        }

        private final Integer $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$getInternalDistance(String a, String b) {
            Map<String, DistanceNode> subsub = this.subtables.get(a);
            if (subsub == null) {
                return null;
            }
            DistanceNode dnode = subsub.get(b);
            return dnode == null ? null : Integer.valueOf(dnode.distance);
        }

        private final DistanceNode $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$getInternalNode(String a, String b) {
            Map<String, DistanceNode> subsub = this.subtables.get(a);
            if (subsub == null) {
                return null;
            }
            return subsub.get(b);
        }

        private final Map<String, Set<String>> $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$getInternalMatches() {
            LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
            for (Map.Entry<String, Map<String, DistanceNode>> entry : this.subtables.entrySet()) {
                result.put(entry.getKey(), new LinkedHashSet<String>(entry.getValue().keySet()));
            }
            return result;
        }

        private void __constructor__(Map<String, Map<String, DistanceNode>> map) {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$__constructor__(map);
        }

        public StringDistanceTable(Map<String, Map<String, DistanceNode>> map) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$__constructor__(java.util.Map<java.lang.String, java.util.Map<java.lang.String, android.icu.impl.locale.XLocaleDistance$DistanceNode>> ), this, map);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$__constructor__();
        }

        public StringDistanceTable() {
            this(XLocaleDistance.newMap());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$__constructor__(), this);
        }

        @Override
        public boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$isEmpty(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$hashCode(), this);
        }

        @Override
        public int getDistance(String string2, String string3, Output<DistanceTable> output, boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("getDistance", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$getDistance(java.lang.String java.lang.String android.icu.util.Output<android.icu.impl.locale.XLocaleDistance$DistanceTable> boolean ), this, string2, string3, output, bl);
        }

        public void copy(StringDistanceTable stringDistanceTable) {
            InvokeDynamicSupport.bootstrap("copy", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$copy(android.icu.impl.locale.XLocaleDistance$StringDistanceTable ), this, stringDistanceTable);
        }

        DistanceNode addSubtable(String string2, String string3, int n) {
            return InvokeDynamicSupport.bootstrap("addSubtable", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$addSubtable(java.lang.String java.lang.String int ), this, string2, string3, n);
        }

        private DistanceNode getNode(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("getNode", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$getNode(java.lang.String java.lang.String ), this, string2, string3);
        }

        public void addSubtables(String string2, String string3, XCldrStub.Predicate<DistanceNode> predicate) {
            InvokeDynamicSupport.bootstrap("addSubtables", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$addSubtables(java.lang.String java.lang.String android.icu.impl.locale.XCldrStub$Predicate<android.icu.impl.locale.XLocaleDistance$DistanceNode> ), this, string2, string3, predicate);
        }

        public void addSubtables(String string2, String string3, String string4, String string5, int n) {
            InvokeDynamicSupport.bootstrap("addSubtables", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$addSubtables(java.lang.String java.lang.String java.lang.String java.lang.String int ), this, string2, string3, string4, string5, n);
        }

        public void addSubtables(String string2, String string3, String string4, String string5, String string6, String string7, int n) {
            InvokeDynamicSupport.bootstrap("addSubtables", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$addSubtables(java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String int ), this, string2, string3, string4, string5, string6, string7, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$toString(), this);
        }

        @Override
        public String toString(boolean bl) {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$toString(boolean ), this, bl);
        }

        public StringBuilder toString(boolean bl, String string2, IdMakerFull<Object> idMakerFull, StringBuilder stringBuilder) {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$toString(boolean java.lang.String android.icu.impl.locale.XLocaleDistance$IdMakerFull<java.lang.Object> java.lang.StringBuilder ), this, bl, string2, idMakerFull, stringBuilder);
        }

        @Override
        public StringDistanceTable compact() {
            return InvokeDynamicSupport.bootstrap("compact", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$compact(), this);
        }

        @Override
        public Set<String> getCloser(int n) {
            return InvokeDynamicSupport.bootstrap("getCloser", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$getCloser(int ), this, n);
        }

        public Integer getInternalDistance(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("getInternalDistance", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$getInternalDistance(java.lang.String java.lang.String ), this, string2, string3);
        }

        @Override
        public DistanceNode getInternalNode(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("getInternalNode", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$getInternalNode(java.lang.String java.lang.String ), this, string2, string3);
        }

        @Override
        public Map<String, Set<String>> getInternalMatches() {
            return InvokeDynamicSupport.bootstrap("getInternalMatches", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceTable$getInternalMatches(), this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StringDistanceTable)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class StringDistanceNode
    extends DistanceNode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        DistanceTable distanceTable;

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$__constructor__(int distance, DistanceTable distanceTable) {
            this.distanceTable = distanceTable;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$equals(Object obj) {
            if (this == obj) return true;
            if (obj == null) return false;
            if (obj.getClass() != this.getClass()) return false;
            StringDistanceNode other = (StringDistanceNode)obj;
            if (this.distance != other.distance) return false;
            if (!Utility.equals(this.distanceTable, other.distanceTable)) return false;
            if (!super.equals(other)) return false;
            return true;
        }

        private final int $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$hashCode() {
            return this.distance ^ Utility.hashCode(this.distanceTable);
        }

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$__constructor__(int distance) {
        }

        private final void $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$addSubtables(String desiredSub, String supportedSub, CopyIfEmpty r) {
            ((StringDistanceTable)this.distanceTable).addSubtables(desiredSub, supportedSub, r);
        }

        private final String $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$toString() {
            return "distance: " + this.distance + "\n" + this.distanceTable;
        }

        private final void $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$copyTables(StringDistanceTable value) {
            if (value != null) {
                ((StringDistanceTable)this.distanceTable).copy(value);
            }
        }

        private final DistanceTable $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$getDistanceTable() {
            return this.distanceTable;
        }

        private void __constructor__(int n, DistanceTable distanceTable) {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$__constructor__(n, distanceTable);
        }

        public StringDistanceNode(int n, DistanceTable distanceTable) {
            super(n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$__constructor__(int android.icu.impl.locale.XLocaleDistance$DistanceTable ), this, n, distanceTable);
        }

        @Override
        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$equals(java.lang.Object ), this, object);
        }

        @Override
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$hashCode(), this);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$__constructor__(n);
        }

        public StringDistanceNode(int n) {
            this(n, new StringDistanceTable());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$__constructor__(int ), this, n);
        }

        public void addSubtables(String string2, String string3, CopyIfEmpty copyIfEmpty) {
            InvokeDynamicSupport.bootstrap("addSubtables", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$addSubtables(java.lang.String java.lang.String android.icu.impl.locale.XLocaleDistance$CopyIfEmpty ), this, string2, string3, copyIfEmpty);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$toString(), this);
        }

        public void copyTables(StringDistanceTable stringDistanceTable) {
            InvokeDynamicSupport.bootstrap("copyTables", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$copyTables(android.icu.impl.locale.XLocaleDistance$StringDistanceTable ), this, stringDistanceTable);
        }

        @Override
        public DistanceTable getDistanceTable() {
            return InvokeDynamicSupport.bootstrap("getDistanceTable", $$robo$$android_icu_impl_locale_XLocaleDistance_StringDistanceNode$getDistanceTable(), this);
        }

        public /* synthetic */ StringDistanceNode() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StringDistanceNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class IdMakerFull<T>
    implements IdMapper<T, Integer> {
        public /* synthetic */ Object __robo_data__;
        private Map<T, Integer> objectToInt;
        private List<T> intToObject;
        String name;

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$__constructor__(String name) {
            this.objectToInt = new HashMap<T, Integer>();
            this.intToObject = new ArrayList<T>();
            this.name = name;
        }

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$__constructor__() {
        }

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$__constructor__(String name, T zeroValue) {
            this.add(zeroValue);
        }

        private final Integer $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$add(T source) {
            Integer result = this.objectToInt.get(source);
            if (result == null) {
                Integer newResult = this.intToObject.size();
                this.objectToInt.put(source, newResult);
                this.intToObject.add(source);
                return newResult;
            }
            return result;
        }

        private final Integer $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$toId(T source) {
            return this.objectToInt.get(source);
        }

        private final T $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$fromId(int id2) {
            return this.intToObject.get(id2);
        }

        private final T $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$intern(T source) {
            return this.fromId(this.add(source));
        }

        private final int $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$size() {
            return this.intToObject.size();
        }

        private final Integer $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$getOldAndAdd(T source) {
            Integer result = this.objectToInt.get(source);
            if (result == null) {
                Integer newResult = this.intToObject.size();
                this.objectToInt.put(source, newResult);
                this.intToObject.add(source);
            }
            return result;
        }

        private final String $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$toString() {
            return this.size() + ": " + this.intToObject;
        }

        private final boolean $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$equals(Object obj) {
            return this == obj || obj != null && obj.getClass() == this.getClass() && this.intToObject.equals(((IdMakerFull)obj).intToObject);
        }

        private final int $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$hashCode() {
            return this.intToObject.hashCode();
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$__constructor__(string2);
        }

        public IdMakerFull(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$__constructor__(java.lang.String ), this, string2);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$__constructor__();
        }

        public IdMakerFull() {
            this("unnamed");
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$__constructor__(), this);
        }

        private void __constructor__(String string2, T t) {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$__constructor__(string2, t);
        }

        public IdMakerFull(String string2, T t) {
            this(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$__constructor__(java.lang.String T ), this, string2, t);
        }

        public Integer add(T t) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$add(T ), this, t);
        }

        @Override
        public Integer toId(T t) {
            return InvokeDynamicSupport.bootstrap("toId", $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$toId(T ), this, t);
        }

        public T fromId(int n) {
            return (T)InvokeDynamicSupport.bootstrap("fromId", $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$fromId(int ), this, n);
        }

        public T intern(T t) {
            return (T)InvokeDynamicSupport.bootstrap("intern", $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$intern(T ), this, t);
        }

        public int size() {
            return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$size(), this);
        }

        public Integer getOldAndAdd(T t) {
            return InvokeDynamicSupport.bootstrap("getOldAndAdd", $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$getOldAndAdd(T ), this, t);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$toString(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_locale_XLocaleDistance_IdMakerFull$hashCode(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IdMakerFull)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface IdMapper<K, V> {
        public V toId(K var1);
    }

    @Deprecated
    public static class DistanceNode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int distance;

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceNode$__constructor__(int distance) {
            this.distance = distance;
        }

        private final DistanceTable $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceNode$getDistanceTable() {
            return null;
        }

        private final boolean $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceNode$equals(Object obj) {
            return this == obj || obj != null && obj.getClass() == this.getClass() && this.distance == ((DistanceNode)obj).distance;
        }

        private final int $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceNode$hashCode() {
            return this.distance;
        }

        private final String $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceNode$toString() {
            return "\ndistance: " + this.distance;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_DistanceNode$__constructor__(n);
        }

        public DistanceNode(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceNode$__constructor__(int ), this, n);
        }

        public DistanceTable getDistanceTable() {
            return InvokeDynamicSupport.bootstrap("getDistanceTable", $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceNode$getDistanceTable(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceNode$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceNode$hashCode(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceNode$toString(), this);
        }

        public /* synthetic */ DistanceNode() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DistanceNode)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static abstract class DistanceTable
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceTable$__constructor__() {
        }

        abstract int getDistance(String var1, String var2, Output<DistanceTable> var3, boolean var4);

        abstract Set<String> getCloser(int var1);

        abstract String toString(boolean var1);

        private final DistanceTable $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceTable$compact() {
            return this;
        }

        private final DistanceNode $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceTable$getInternalNode(String any, String any2) {
            return null;
        }

        private final Map<String, Set<String>> $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceTable$getInternalMatches() {
            return null;
        }

        private final boolean $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceTable$isEmpty() {
            return true;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_locale_XLocaleDistance_DistanceTable$__constructor__();
        }

        public DistanceTable() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceTable$__constructor__(), this);
        }

        public DistanceTable compact() {
            return InvokeDynamicSupport.bootstrap("compact", $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceTable$compact(), this);
        }

        public DistanceNode getInternalNode(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("getInternalNode", $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceTable$getInternalNode(java.lang.String java.lang.String ), this, string2, string3);
        }

        public Map<String, Set<String>> getInternalMatches() {
            return InvokeDynamicSupport.bootstrap("getInternalMatches", $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceTable$getInternalMatches(), this);
        }

        public boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_icu_impl_locale_XLocaleDistance_DistanceTable$isEmpty(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DistanceTable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

