/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.duration;

import android.icu.impl.duration.DateFormatter;
import android.icu.impl.duration.DurationFormatter;
import android.icu.impl.duration.Period;
import android.icu.impl.duration.PeriodBuilder;
import android.icu.impl.duration.PeriodFormatter;
import java.lang.invoke.CallSite;
import java.util.Date;
import java.util.TimeZone;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BasicDurationFormatter
implements DurationFormatter,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private PeriodFormatter formatter;
    private PeriodBuilder builder;
    private DateFormatter fallback;
    private long fallbackLimit;
    private String localeName;
    private TimeZone timeZone;

    private void $$robo$$android_icu_impl_duration_BasicDurationFormatter$__constructor__(PeriodFormatter formatter, PeriodBuilder builder, DateFormatter fallback, long fallbackLimit) {
        this.formatter = formatter;
        this.builder = builder;
        this.fallback = fallback;
        this.fallbackLimit = fallbackLimit < 0L ? 0L : fallbackLimit;
    }

    private void $$robo$$android_icu_impl_duration_BasicDurationFormatter$__constructor__(PeriodFormatter formatter, PeriodBuilder builder, DateFormatter fallback, long fallbackLimit, String localeName, TimeZone timeZone) {
        this.formatter = formatter;
        this.builder = builder;
        this.fallback = fallback;
        this.fallbackLimit = fallbackLimit;
        this.localeName = localeName;
        this.timeZone = timeZone;
    }

    private final String $$robo$$android_icu_impl_duration_BasicDurationFormatter$formatDurationFromNowTo(Date targetDate) {
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        long duration = targetDate.getTime() - now;
        return this.formatDurationFrom(duration, (long)now);
    }

    private final String $$robo$$android_icu_impl_duration_BasicDurationFormatter$formatDurationFromNow(long duration) {
        return this.formatDurationFrom(duration, (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
    }

    private final String $$robo$$android_icu_impl_duration_BasicDurationFormatter$formatDurationFrom(long duration, long referenceDate) {
        String s = this.doFallback(duration, referenceDate);
        if (s == null) {
            Period p = this.doBuild(duration, referenceDate);
            s = this.doFormat(p);
        }
        return s;
    }

    private final DurationFormatter $$robo$$android_icu_impl_duration_BasicDurationFormatter$withLocale(String locName) {
        if (!locName.equals(this.localeName)) {
            PeriodFormatter newFormatter = this.formatter.withLocale(locName);
            PeriodBuilder newBuilder = this.builder.withLocale(locName);
            DateFormatter newFallback = this.fallback == null ? null : this.fallback.withLocale(locName);
            return new BasicDurationFormatter(newFormatter, newBuilder, newFallback, this.fallbackLimit, locName, this.timeZone);
        }
        return this;
    }

    private final DurationFormatter $$robo$$android_icu_impl_duration_BasicDurationFormatter$withTimeZone(TimeZone tz) {
        if (!tz.equals(this.timeZone)) {
            PeriodBuilder newBuilder = this.builder.withTimeZone(tz);
            DateFormatter newFallback = this.fallback == null ? null : this.fallback.withTimeZone(tz);
            return new BasicDurationFormatter(this.formatter, newBuilder, newFallback, this.fallbackLimit, this.localeName, tz);
        }
        return this;
    }

    private final String $$robo$$android_icu_impl_duration_BasicDurationFormatter$doFallback(long duration, long referenceDate) {
        if (this.fallback != null && this.fallbackLimit > 0L && Math.abs(duration) >= this.fallbackLimit) {
            return this.fallback.format(referenceDate + duration);
        }
        return null;
    }

    private final Period $$robo$$android_icu_impl_duration_BasicDurationFormatter$doBuild(long duration, long referenceDate) {
        return this.builder.createWithReferenceDate(duration, referenceDate);
    }

    private final String $$robo$$android_icu_impl_duration_BasicDurationFormatter$doFormat(Period period) {
        if (!period.isSet()) {
            throw new IllegalArgumentException("period is not set");
        }
        return this.formatter.format(period);
    }

    private void __constructor__(PeriodFormatter periodFormatter, PeriodBuilder periodBuilder, DateFormatter dateFormatter, long l) {
        this.$$robo$$android_icu_impl_duration_BasicDurationFormatter$__constructor__(periodFormatter, periodBuilder, dateFormatter, l);
    }

    public BasicDurationFormatter(PeriodFormatter periodFormatter, PeriodBuilder periodBuilder, DateFormatter dateFormatter, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_duration_BasicDurationFormatter$__constructor__(android.icu.impl.duration.PeriodFormatter android.icu.impl.duration.PeriodBuilder android.icu.impl.duration.DateFormatter long ), this, periodFormatter, periodBuilder, dateFormatter, l);
    }

    private void __constructor__(PeriodFormatter periodFormatter, PeriodBuilder periodBuilder, DateFormatter dateFormatter, long l, String string2, TimeZone timeZone) {
        this.$$robo$$android_icu_impl_duration_BasicDurationFormatter$__constructor__(periodFormatter, periodBuilder, dateFormatter, l, string2, timeZone);
    }

    public BasicDurationFormatter(PeriodFormatter periodFormatter, PeriodBuilder periodBuilder, DateFormatter dateFormatter, long l, String string2, TimeZone timeZone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_duration_BasicDurationFormatter$__constructor__(android.icu.impl.duration.PeriodFormatter android.icu.impl.duration.PeriodBuilder android.icu.impl.duration.DateFormatter long java.lang.String java.util.TimeZone ), this, periodFormatter, periodBuilder, dateFormatter, l, string2, timeZone);
    }

    @Override
    public String formatDurationFromNowTo(Date date) {
        return InvokeDynamicSupport.bootstrap("formatDurationFromNowTo", $$robo$$android_icu_impl_duration_BasicDurationFormatter$formatDurationFromNowTo(java.util.Date ), this, date);
    }

    @Override
    public String formatDurationFromNow(long l) {
        return InvokeDynamicSupport.bootstrap("formatDurationFromNow", $$robo$$android_icu_impl_duration_BasicDurationFormatter$formatDurationFromNow(long ), this, l);
    }

    @Override
    public String formatDurationFrom(long l, long l2) {
        return InvokeDynamicSupport.bootstrap("formatDurationFrom", $$robo$$android_icu_impl_duration_BasicDurationFormatter$formatDurationFrom(long long ), this, l, l2);
    }

    @Override
    public DurationFormatter withLocale(String string2) {
        return InvokeDynamicSupport.bootstrap("withLocale", $$robo$$android_icu_impl_duration_BasicDurationFormatter$withLocale(java.lang.String ), this, string2);
    }

    @Override
    public DurationFormatter withTimeZone(TimeZone timeZone) {
        return InvokeDynamicSupport.bootstrap("withTimeZone", $$robo$$android_icu_impl_duration_BasicDurationFormatter$withTimeZone(java.util.TimeZone ), this, timeZone);
    }

    protected String doFallback(long l, long l2) {
        return InvokeDynamicSupport.bootstrap("doFallback", $$robo$$android_icu_impl_duration_BasicDurationFormatter$doFallback(long long ), this, l, l2);
    }

    protected Period doBuild(long l, long l2) {
        return InvokeDynamicSupport.bootstrap("doBuild", $$robo$$android_icu_impl_duration_BasicDurationFormatter$doBuild(long long ), this, l, l2);
    }

    protected String doFormat(Period period) {
        return InvokeDynamicSupport.bootstrap("doFormat", $$robo$$android_icu_impl_duration_BasicDurationFormatter$doFormat(android.icu.impl.duration.Period ), this, period);
    }

    public /* synthetic */ BasicDurationFormatter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BasicDurationFormatter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

