/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.coll;

import android.icu.impl.ICUBinary;
import android.icu.impl.Trie2_32;
import android.icu.impl.USerializedSet;
import android.icu.impl.coll.CollationData;
import android.icu.impl.coll.CollationFastLatin;
import android.icu.impl.coll.CollationSettings;
import android.icu.impl.coll.CollationTailoring;
import android.icu.text.UnicodeSet;
import android.icu.util.ICUException;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CollationDataReader
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static int IX_INDEXES_LENGTH = 0;
    static int IX_OPTIONS = 1;
    static int IX_RESERVED2 = 2;
    static int IX_RESERVED3 = 3;
    static int IX_JAMO_CE32S_START = 4;
    static int IX_REORDER_CODES_OFFSET = 5;
    static int IX_REORDER_TABLE_OFFSET = 6;
    static int IX_TRIE_OFFSET = 7;
    static int IX_RESERVED8_OFFSET = 8;
    static int IX_CES_OFFSET = 9;
    static int IX_RESERVED10_OFFSET = 10;
    static int IX_CE32S_OFFSET = 11;
    static int IX_ROOT_ELEMENTS_OFFSET = 12;
    static int IX_CONTEXTS_OFFSET = 13;
    static int IX_UNSAFE_BWD_OFFSET = 14;
    static int IX_FAST_LATIN_TABLE_OFFSET = 15;
    static int IX_SCRIPTS_OFFSET = 16;
    static int IX_COMPRESSIBLE_BYTES_OFFSET = 17;
    static int IX_RESERVED18_OFFSET = 18;
    static int IX_TOTAL_SIZE = 19;
    private static IsAcceptable IS_ACCEPTABLE;
    private static int DATA_FORMAT = 1430482796;
    static /* synthetic */ boolean $assertionsDisabled;

    private static final void $$robo$$android_icu_impl_coll_CollationDataReader$read(CollationTailoring base, ByteBuffer inBytes, CollationTailoring tailoring) throws IOException {
        int[] reorderCodes;
        int reorderCodesLength;
        int length;
        int i;
        tailoring.version = ICUBinary.readHeader(inBytes, 1430482796, IS_ACCEPTABLE);
        if (base != null && base.getUCAVersion() != tailoring.getUCAVersion()) {
            throw new ICUException("Tailoring UCA version differs from base data UCA version");
        }
        int inLength = inBytes.remaining();
        if (inLength < 8) {
            throw new ICUException("not enough bytes");
        }
        int indexesLength = inBytes.getInt();
        if (indexesLength < 2 || inLength < indexesLength * 4) {
            throw new ICUException("not enough indexes");
        }
        int[] inIndexes = new int[20];
        inIndexes[0] = indexesLength;
        for (i = 1; i < indexesLength && i < inIndexes.length; ++i) {
            inIndexes[i] = inBytes.getInt();
        }
        for (i = indexesLength; i < inIndexes.length; ++i) {
            inIndexes[i] = -1;
        }
        if (indexesLength > inIndexes.length) {
            ICUBinary.skipBytes(inBytes, (indexesLength - inIndexes.length) * 4);
        }
        if (inLength < (length = indexesLength > 19 ? inIndexes[19] : (indexesLength > 5 ? inIndexes[indexesLength - 1] : 0))) {
            throw new ICUException("not enough bytes");
        }
        CollationData baseData = base == null ? null : base.data;
        int index = 5;
        int offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 4) {
            int reorderRangesLength;
            if (baseData == null) {
                throw new ICUException("Collation base data must not reorder scripts");
            }
            reorderCodesLength = length / 4;
            reorderCodes = ICUBinary.getInts(inBytes, reorderCodesLength, length & 3);
            for (reorderRangesLength = 0; reorderRangesLength < reorderCodesLength && (reorderCodes[reorderCodesLength - reorderRangesLength - 1] & 0xFFFF0000) != 0; ++reorderRangesLength) {
            }
            if (!$assertionsDisabled && reorderRangesLength >= reorderCodesLength) {
                throw new AssertionError();
            }
            reorderCodesLength -= reorderRangesLength;
        } else {
            reorderCodes = new int[]{};
            reorderCodesLength = 0;
            ICUBinary.skipBytes(inBytes, length);
        }
        byte[] reorderTable = null;
        index = 6;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 256) {
            if (reorderCodesLength == 0) {
                throw new ICUException("Reordering table without reordering codes");
            }
            reorderTable = new byte[256];
            inBytes.get(reorderTable);
            length -= 256;
        }
        ICUBinary.skipBytes(inBytes, length);
        if (baseData != null && baseData.numericPrimary != ((long)inIndexes[1] & 0xFF000000L)) {
            throw new ICUException("Tailoring numeric primary weight differs from base data");
        }
        CollationData data = null;
        index = 7;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 8) {
            tailoring.ensureOwnedData();
            data = tailoring.ownedData;
            data.base = baseData;
            data.numericPrimary = (long)inIndexes[1] & 0xFF000000L;
            data.trie = tailoring.trie = Trie2_32.createFromSerialized(inBytes);
            int trieLength = data.trie.getSerializedLength();
            if (trieLength > length) {
                throw new ICUException("Not enough bytes for the mappings trie");
            }
            length -= trieLength;
        } else if (baseData != null) {
            tailoring.data = baseData;
        } else {
            throw new ICUException("Missing collation data mappings");
        }
        ICUBinary.skipBytes(inBytes, length);
        index = 8;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        ICUBinary.skipBytes(inBytes, length);
        index = 9;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 8) {
            if (data == null) {
                throw new ICUException("Tailored ces without tailored trie");
            }
            data.ces = ICUBinary.getLongs(inBytes, length / 8, length & 7);
        } else {
            ICUBinary.skipBytes(inBytes, length);
        }
        index = 10;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        ICUBinary.skipBytes(inBytes, length);
        index = 11;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 4) {
            if (data == null) {
                throw new ICUException("Tailored ce32s without tailored trie");
            }
            data.ce32s = ICUBinary.getInts(inBytes, length / 4, length & 3);
        } else {
            ICUBinary.skipBytes(inBytes, length);
        }
        int jamoCE32sStart = inIndexes[4];
        if (jamoCE32sStart >= 0) {
            if (data == null || data.ce32s == null) {
                throw new ICUException("JamoCE32sStart index into non-existent ce32s[]");
            }
            data.jamoCE32s = new int[67];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)data.ce32s, (int)jamoCE32sStart, (Object)data.jamoCE32s, (int)0, (int)67);
        } else if (data != null) {
            if (baseData != null) {
                data.jamoCE32s = baseData.jamoCE32s;
            } else {
                throw new ICUException("Missing Jamo CE32s for Hangul processing");
            }
        }
        index = 12;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 4) {
            int rootElementsLength = length / 4;
            if (data == null) {
                throw new ICUException("Root elements but no mappings");
            }
            if (rootElementsLength <= 4) {
                throw new ICUException("Root elements array too short");
            }
            data.rootElements = new long[rootElementsLength];
            for (int i2 = 0; i2 < rootElementsLength; ++i2) {
                data.rootElements[i2] = (long)inBytes.getInt() & 0xFFFFFFFFL;
            }
            long commonSecTer = data.rootElements[3];
            if (commonSecTer != 0x5000500L) {
                throw new ICUException("Common sec/ter weights in base data differ from the hardcoded value");
            }
            long secTerBoundaries = data.rootElements[4];
            if (secTerBoundaries >>> 24 < 69L) {
                throw new ICUException("[fixed last secondary common byte] is too low");
            }
            length &= 3;
        }
        ICUBinary.skipBytes(inBytes, length);
        index = 13;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 2) {
            if (data == null) {
                throw new ICUException("Tailored contexts without tailored trie");
            }
            data.contexts = ICUBinary.getString(inBytes, length / 2, length & 1);
        } else {
            ICUBinary.skipBytes(inBytes, length);
        }
        index = 14;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 2) {
            if (data == null) {
                throw new ICUException("Unsafe-backward-set but no mappings");
            }
            if (baseData == null) {
                tailoring.unsafeBackwardSet = new UnicodeSet(56320, 57343);
                data.nfcImpl.addLcccChars(tailoring.unsafeBackwardSet);
            } else {
                tailoring.unsafeBackwardSet = baseData.unsafeBackwardSet.cloneAsThawed();
            }
            USerializedSet sset = new USerializedSet();
            char[] unsafeData = ICUBinary.getChars(inBytes, length / 2, length & 1);
            length = 0;
            sset.getSet(unsafeData, 0);
            int count = sset.countRanges();
            int[] range = new int[2];
            for (int i3 = 0; i3 < count; ++i3) {
                sset.getRange(i3, range);
                tailoring.unsafeBackwardSet.add(range[0], range[1]);
            }
            int c = 65536;
            int lead = 55296;
            while (lead < 56320) {
                if (!tailoring.unsafeBackwardSet.containsNone(c, c + 1023)) {
                    tailoring.unsafeBackwardSet.add(lead);
                }
                ++lead;
                c += 1024;
            }
            tailoring.unsafeBackwardSet.freeze();
            data.unsafeBackwardSet = tailoring.unsafeBackwardSet;
        } else if (data != null) {
            if (baseData != null) {
                data.unsafeBackwardSet = baseData.unsafeBackwardSet;
            } else {
                throw new ICUException("Missing unsafe-backward-set");
            }
        }
        ICUBinary.skipBytes(inBytes, length);
        index = 15;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (data != null) {
            data.fastLatinTable = null;
            data.fastLatinTableHeader = null;
            if ((inIndexes[1] >> 16 & 0xFF) == 2) {
                if (length >= 2) {
                    char header0 = inBytes.getChar();
                    int headerLength = header0 & 0xFF;
                    data.fastLatinTableHeader = new char[headerLength];
                    data.fastLatinTableHeader[0] = header0;
                    for (int i4 = 1; i4 < headerLength; ++i4) {
                        data.fastLatinTableHeader[i4] = inBytes.getChar();
                    }
                    int tableLength = length / 2 - headerLength;
                    data.fastLatinTable = ICUBinary.getChars(inBytes, tableLength, length & 1);
                    length = 0;
                    if (header0 >> 8 != 2) {
                        throw new ICUException("Fast-Latin table version differs from version in data header");
                    }
                } else if (baseData != null) {
                    data.fastLatinTable = baseData.fastLatinTable;
                    data.fastLatinTableHeader = baseData.fastLatinTableHeader;
                }
            }
        }
        ICUBinary.skipBytes(inBytes, length);
        index = 16;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 2) {
            if (data == null) {
                throw new ICUException("Script order data but no mappings");
            }
            int scriptsLength = length / 2;
            CharBuffer inChars = inBytes.asCharBuffer();
            data.numScripts = inChars.get();
            int scriptStartsLength = scriptsLength - (1 + data.numScripts + 16);
            if (scriptStartsLength <= 2) {
                throw new ICUException("Script order data too short");
            }
            data.scriptsIndex = new char[data.numScripts + 16];
            inChars.get(data.scriptsIndex);
            data.scriptStarts = new char[scriptStartsLength];
            inChars.get(data.scriptStarts);
            if (data.scriptStarts[0] != '\u0000' || data.scriptStarts[1] != '\u0300' || data.scriptStarts[scriptStartsLength - 1] != '\uff00') {
                throw new ICUException("Script order data not valid");
            }
        } else if (data != null && baseData != null) {
            data.numScripts = baseData.numScripts;
            data.scriptsIndex = baseData.scriptsIndex;
            data.scriptStarts = baseData.scriptStarts;
        }
        ICUBinary.skipBytes(inBytes, length);
        index = 17;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 256) {
            if (data == null) {
                throw new ICUException("Data for compressible primary lead bytes but no mappings");
            }
            data.compressibleBytes = new boolean[256];
            for (int i5 = 0; i5 < 256; ++i5) {
                data.compressibleBytes[i5] = inBytes.get() != 0;
            }
            length -= 256;
        } else if (data != null) {
            if (baseData != null) {
                data.compressibleBytes = baseData.compressibleBytes;
            } else {
                throw new ICUException("Missing data for compressible primary lead bytes");
            }
        }
        ICUBinary.skipBytes(inBytes, length);
        index = 18;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        ICUBinary.skipBytes(inBytes, length);
        CollationSettings ts = tailoring.settings.readOnly();
        int options = inIndexes[1] & 0xFFFF;
        char[] fastLatinPrimaries = new char[384];
        int fastLatinOptions = CollationFastLatin.getOptions(tailoring.data, ts, fastLatinPrimaries);
        if (options == ts.options && ts.variableTop != 0L && Arrays.equals(reorderCodes, ts.reorderCodes) && fastLatinOptions == ts.fastLatinOptions && (fastLatinOptions < 0 || Arrays.equals(fastLatinPrimaries, ts.fastLatinPrimaries))) {
            return;
        }
        CollationSettings settings = tailoring.settings.copyOnWrite();
        settings.options = options;
        settings.variableTop = tailoring.data.getLastPrimaryForGroup(4096 + settings.getMaxVariable());
        if (settings.variableTop == 0L) {
            throw new ICUException("The maxVariable could not be mapped to a variableTop");
        }
        if (reorderCodesLength != 0) {
            settings.aliasReordering(baseData, reorderCodes, reorderCodesLength, reorderTable);
        }
        settings.fastLatinOptions = CollationFastLatin.getOptions(tailoring.data, settings, settings.fastLatinPrimaries);
    }

    private void $$robo$$android_icu_impl_coll_CollationDataReader$__constructor__() {
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !CollationDataReader.class.desiredAssertionStatus();
        IS_ACCEPTABLE = new IsAcceptable(null);
    }

    static void read(CollationTailoring collationTailoring, ByteBuffer byteBuffer, CollationTailoring collationTailoring2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("read", $$robo$$android_icu_impl_coll_CollationDataReader$read(android.icu.impl.coll.CollationTailoring java.nio.ByteBuffer android.icu.impl.coll.CollationTailoring ), (CollationTailoring)collationTailoring, (ByteBuffer)byteBuffer, (CollationTailoring)collationTailoring2);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_coll_CollationDataReader$__constructor__();
    }

    public CollationDataReader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationDataReader$__constructor__(), this);
    }

    static {
        RobolectricInternals.classInitializing(CollationDataReader.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollationDataReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class IsAcceptable
    implements ICUBinary.Authenticate,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_coll_CollationDataReader_IsAcceptable$__constructor__() {
        }

        private final boolean $$robo$$android_icu_impl_coll_CollationDataReader_IsAcceptable$isDataVersionAcceptable(byte[] version) {
            return version[0] == 5;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_coll_CollationDataReader_IsAcceptable$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_coll_CollationDataReader_IsAcceptable$__constructor__();
        }

        public IsAcceptable() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationDataReader_IsAcceptable$__constructor__(), this);
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("isDataVersionAcceptable", $$robo$$android_icu_impl_coll_CollationDataReader_IsAcceptable$isDataVersionAcceptable(byte[] ), this, byArray);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_coll_CollationDataReader_IsAcceptable$__constructor__(var1_1);
        }

        public /* synthetic */ IsAcceptable(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationDataReader_IsAcceptable$__constructor__(android.icu.impl.coll.CollationDataReader$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IsAcceptable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

