/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.text.StringTransform;
import android.icu.text.SymbolTable;
import android.icu.text.UnicodeSet;
import android.icu.util.Freezable;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

public class UnicodeRegex
implements Cloneable,
Freezable<UnicodeRegex>,
StringTransform {
    public /* synthetic */ Object __robo_data__;
    private SymbolTable symbolTable;
    private static UnicodeRegex STANDARD;
    private String bnfCommentString;
    private String bnfVariableInfix;
    private String bnfLineSeparator;
    private Comparator<Object> LongestFirst;

    private void $$robo$$android_icu_impl_UnicodeRegex$__constructor__() {
        this.bnfCommentString = "#";
        this.bnfVariableInfix = "=";
        this.bnfLineSeparator = "\n";
        this.LongestFirst = new Comparator<Object>(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ UnicodeRegex this$0;

            private void $$robo$$android_icu_impl_UnicodeRegex_1$__constructor__(UnicodeRegex this$0) {
                this.this$0 = this$0;
            }

            private final int $$robo$$android_icu_impl_UnicodeRegex_1$compare(Object obj0, Object obj1) {
                int len1;
                String arg0 = obj0.toString();
                String arg1 = obj1.toString();
                int len0 = arg0.length();
                if (len0 != (len1 = arg1.length())) {
                    return len1 - len0;
                }
                return arg0.compareTo(arg1);
            }

            private void __constructor__(UnicodeRegex unicodeRegex) {
                this.$$robo$$android_icu_impl_UnicodeRegex_1$__constructor__(unicodeRegex);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_UnicodeRegex_1$__constructor__(android.icu.impl.UnicodeRegex ), this, unicodeRegex);
            }

            @Override
            public int compare(Object object, Object object2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_icu_impl_UnicodeRegex_1$compare(java.lang.Object java.lang.Object ), this, object, object2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final SymbolTable $$robo$$android_icu_impl_UnicodeRegex$getSymbolTable() {
        return this.symbolTable;
    }

    private final UnicodeRegex $$robo$$android_icu_impl_UnicodeRegex$setSymbolTable(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String $$robo$$android_icu_impl_UnicodeRegex$transform(String regex) {
        StringBuilder result = new StringBuilder();
        UnicodeSet temp = new UnicodeSet();
        ParsePosition pos = new ParsePosition(0);
        int state = 0;
        int i = 0;
        while (true) {
            block13: {
                if (i >= regex.length()) {
                    return result.toString();
                }
                char ch = regex.charAt(i);
                switch (state) {
                    case 0: {
                        if (ch == '\\') {
                            if (UnicodeSet.resemblesPattern(regex, i)) {
                                i = this.processSet(regex, i, result, temp, pos);
                                break block13;
                            } else {
                                state = 1;
                                break;
                            }
                        }
                        if (ch != '[' || !UnicodeSet.resemblesPattern(regex, i)) break;
                        i = this.processSet(regex, i, result, temp, pos);
                        break block13;
                    }
                    case 1: {
                        if (ch == 'Q') {
                            state = 1;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 2: {
                        if (ch != '\\') break;
                        state = 3;
                        break;
                    }
                    case 3: {
                        if (ch == 'E') {
                            state = 0;
                        }
                        state = 2;
                    }
                }
                result.append(ch);
            }
            ++i;
        }
    }

    private static final String $$robo$$android_icu_impl_UnicodeRegex$fix(String regex) {
        return STANDARD.transform(regex);
    }

    private static final Pattern $$robo$$android_icu_impl_UnicodeRegex$compile(String regex) {
        return Pattern.compile(STANDARD.transform(regex));
    }

    private static final Pattern $$robo$$android_icu_impl_UnicodeRegex$compile(String regex, int options) {
        return Pattern.compile(STANDARD.transform(regex), options);
    }

    private final String $$robo$$android_icu_impl_UnicodeRegex$compileBnf(String bnfLines) {
        return this.compileBnf(Arrays.asList(bnfLines.split("\\r\\n?|\\n")));
    }

    private final String $$robo$$android_icu_impl_UnicodeRegex$compileBnf(List<String> lines) {
        Map<String, String> variables = this.getVariables(lines);
        LinkedHashSet<String> unused = new LinkedHashSet<String>(variables.keySet());
        for (int i = 0; i < 2; ++i) {
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                String variable = entry.getKey();
                String definition = entry.getValue();
                for (Map.Entry<String, String> entry2 : variables.entrySet()) {
                    String altered2;
                    String variable2 = entry2.getKey();
                    String definition2 = entry2.getValue();
                    if (variable.equals(variable2) || (altered2 = definition2.replace(variable, definition)).equals(definition2)) continue;
                    unused.remove(variable);
                    variables.put(variable2, altered2);
                }
            }
        }
        if (unused.size() != 1) {
            throw new IllegalArgumentException("Not a single root: " + unused);
        }
        return variables.get(unused.iterator().next());
    }

    private final String $$robo$$android_icu_impl_UnicodeRegex$getBnfCommentString() {
        return this.bnfCommentString;
    }

    private final void $$robo$$android_icu_impl_UnicodeRegex$setBnfCommentString(String bnfCommentString) {
        this.bnfCommentString = bnfCommentString;
    }

    private final String $$robo$$android_icu_impl_UnicodeRegex$getBnfVariableInfix() {
        return this.bnfVariableInfix;
    }

    private final void $$robo$$android_icu_impl_UnicodeRegex$setBnfVariableInfix(String bnfVariableInfix) {
        this.bnfVariableInfix = bnfVariableInfix;
    }

    private final String $$robo$$android_icu_impl_UnicodeRegex$getBnfLineSeparator() {
        return this.bnfLineSeparator;
    }

    private final void $$robo$$android_icu_impl_UnicodeRegex$setBnfLineSeparator(String bnfLineSeparator) {
        this.bnfLineSeparator = bnfLineSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> $$robo$$android_icu_impl_UnicodeRegex$appendLines(List<String> result, String file, String encoding) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            List<String> list = UnicodeRegex.appendLines(result, is, encoding);
            return list;
        }
    }

    private static final List<String> $$robo$$android_icu_impl_UnicodeRegex$appendLines(List<String> result, InputStream inputStream, String encoding) throws UnsupportedEncodingException, IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, encoding == null ? "UTF-8" : encoding));
        while ((line = in.readLine()) != null) {
            result.add(line);
        }
        return result;
    }

    private final UnicodeRegex $$robo$$android_icu_impl_UnicodeRegex$cloneAsThawed() {
        try {
            return (UnicodeRegex)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException();
        }
    }

    private final UnicodeRegex $$robo$$android_icu_impl_UnicodeRegex$freeze() {
        return this;
    }

    private final boolean $$robo$$android_icu_impl_UnicodeRegex$isFrozen() {
        return true;
    }

    private final int $$robo$$android_icu_impl_UnicodeRegex$processSet(String regex, int i, StringBuilder result, UnicodeSet temp, ParsePosition pos) {
        try {
            pos.setIndex(i);
            UnicodeSet x = temp.clear().applyPattern(regex, pos, this.symbolTable, 0);
            x.complement().complement();
            result.append(x.toPattern(false));
            i = pos.getIndex() - 1;
            return i;
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Error in " + regex).initCause(e);
        }
    }

    private final Map<String, String> $$robo$$android_icu_impl_UnicodeRegex$getVariables(List<String> lines) {
        TreeMap<Object, String> variables = new TreeMap<Object, String>(this.LongestFirst);
        String variable = null;
        StringBuffer definition = new StringBuffer();
        int count = 0;
        for (String line : lines) {
            int equalsPos;
            String linePart;
            String trimline;
            int hashPos;
            ++count;
            if (line.length() == 0) continue;
            if (line.charAt(0) == '\ufeff') {
                line = line.substring(1);
            }
            if (this.bnfCommentString != null && (hashPos = line.indexOf(this.bnfCommentString)) >= 0) {
                line = line.substring(0, hashPos);
            }
            if ((trimline = line.trim()).length() == 0 || (linePart = line).trim().length() == 0) continue;
            boolean terminated = trimline.endsWith(";");
            if (terminated) {
                linePart = linePart.substring(0, linePart.lastIndexOf(59));
            }
            if ((equalsPos = linePart.indexOf(this.bnfVariableInfix)) >= 0) {
                if (variable != null) {
                    throw new IllegalArgumentException("Missing ';' before " + count + ") " + line);
                }
                variable = linePart.substring(0, equalsPos).trim();
                if (variables.containsKey(variable)) {
                    throw new IllegalArgumentException("Duplicate variable definition in " + line);
                }
                definition.append(linePart.substring(equalsPos + 1).trim());
            } else {
                if (variable == null) {
                    throw new IllegalArgumentException("Missing '=' at " + count + ") " + line);
                }
                definition.append(this.bnfLineSeparator).append(linePart);
            }
            if (!terminated) continue;
            variables.put(variable, definition.toString());
            variable = null;
            definition.setLength(0);
        }
        if (variable != null) {
            throw new IllegalArgumentException("Missing ';' at end");
        }
        return variables;
    }

    static void __staticInitializer__() {
        STANDARD = new UnicodeRegex();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_UnicodeRegex$__constructor__();
    }

    public UnicodeRegex() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_UnicodeRegex$__constructor__(), this);
    }

    public SymbolTable getSymbolTable() {
        return InvokeDynamicSupport.bootstrap("getSymbolTable", $$robo$$android_icu_impl_UnicodeRegex$getSymbolTable(), this);
    }

    public UnicodeRegex setSymbolTable(SymbolTable symbolTable) {
        return InvokeDynamicSupport.bootstrap("setSymbolTable", $$robo$$android_icu_impl_UnicodeRegex$setSymbolTable(android.icu.text.SymbolTable ), this, symbolTable);
    }

    @Override
    public String transform(String string2) {
        return InvokeDynamicSupport.bootstrap("transform", $$robo$$android_icu_impl_UnicodeRegex$transform(java.lang.String ), this, string2);
    }

    public static String fix(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fix", $$robo$$android_icu_impl_UnicodeRegex$fix(java.lang.String ), (String)string2);
    }

    public static Pattern compile(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("compile", $$robo$$android_icu_impl_UnicodeRegex$compile(java.lang.String ), (String)string2);
    }

    public static Pattern compile(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("compile", $$robo$$android_icu_impl_UnicodeRegex$compile(java.lang.String int ), (String)string2, (int)n);
    }

    public String compileBnf(String string2) {
        return InvokeDynamicSupport.bootstrap("compileBnf", $$robo$$android_icu_impl_UnicodeRegex$compileBnf(java.lang.String ), this, string2);
    }

    public String compileBnf(List<String> list) {
        return InvokeDynamicSupport.bootstrap("compileBnf", $$robo$$android_icu_impl_UnicodeRegex$compileBnf(java.util.List<java.lang.String> ), this, list);
    }

    public String getBnfCommentString() {
        return InvokeDynamicSupport.bootstrap("getBnfCommentString", $$robo$$android_icu_impl_UnicodeRegex$getBnfCommentString(), this);
    }

    public void setBnfCommentString(String string2) {
        InvokeDynamicSupport.bootstrap("setBnfCommentString", $$robo$$android_icu_impl_UnicodeRegex$setBnfCommentString(java.lang.String ), this, string2);
    }

    public String getBnfVariableInfix() {
        return InvokeDynamicSupport.bootstrap("getBnfVariableInfix", $$robo$$android_icu_impl_UnicodeRegex$getBnfVariableInfix(), this);
    }

    public void setBnfVariableInfix(String string2) {
        InvokeDynamicSupport.bootstrap("setBnfVariableInfix", $$robo$$android_icu_impl_UnicodeRegex$setBnfVariableInfix(java.lang.String ), this, string2);
    }

    public String getBnfLineSeparator() {
        return InvokeDynamicSupport.bootstrap("getBnfLineSeparator", $$robo$$android_icu_impl_UnicodeRegex$getBnfLineSeparator(), this);
    }

    public void setBnfLineSeparator(String string2) {
        InvokeDynamicSupport.bootstrap("setBnfLineSeparator", $$robo$$android_icu_impl_UnicodeRegex$setBnfLineSeparator(java.lang.String ), this, string2);
    }

    public static List<String> appendLines(List<String> list, String string2, String string3) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("appendLines", $$robo$$android_icu_impl_UnicodeRegex$appendLines(java.util.List<java.lang.String> java.lang.String java.lang.String ), list, (String)string2, (String)string3);
    }

    public static List<String> appendLines(List<String> list, InputStream inputStream, String string2) throws UnsupportedEncodingException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("appendLines", $$robo$$android_icu_impl_UnicodeRegex$appendLines(java.util.List<java.lang.String> java.io.InputStream java.lang.String ), list, (InputStream)inputStream, (String)string2);
    }

    @Override
    public UnicodeRegex cloneAsThawed() {
        return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_impl_UnicodeRegex$cloneAsThawed(), this);
    }

    @Override
    public UnicodeRegex freeze() {
        return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_impl_UnicodeRegex$freeze(), this);
    }

    @Override
    public boolean isFrozen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_impl_UnicodeRegex$isFrozen(), this);
    }

    private int processSet(String string2, int n, StringBuilder stringBuilder, UnicodeSet unicodeSet, ParsePosition parsePosition) {
        return (int)InvokeDynamicSupport.bootstrap("processSet", $$robo$$android_icu_impl_UnicodeRegex$processSet(java.lang.String int java.lang.StringBuilder android.icu.text.UnicodeSet java.text.ParsePosition ), this, string2, n, stringBuilder, unicodeSet, parsePosition);
    }

    private Map<String, String> getVariables(List<String> list) {
        return InvokeDynamicSupport.bootstrap("getVariables", $$robo$$android_icu_impl_UnicodeRegex$getVariables(java.util.List<java.lang.String> ), this, list);
    }

    static {
        RobolectricInternals.classInitializing(UnicodeRegex.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnicodeRegex)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

