/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.IntTrie;
import android.icu.impl.IntTrieBuilder;
import android.icu.impl.PVecToTrieCompactHandler;
import android.icu.impl.Trie;
import android.icu.impl.TrieBuilder;
import java.util.Arrays;
import java.util.Comparator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PropsVectors
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int[] v;
    private int columns;
    private int maxRows;
    private int rows;
    private int prevRow;
    private boolean isCompacted;
    public static int FIRST_SPECIAL_CP = 0x110000;
    public static int INITIAL_VALUE_CP = 0x110000;
    public static int ERROR_VALUE_CP = 0x110001;
    public static int MAX_CP = 0x110001;
    public static int INITIAL_ROWS = 4096;
    public static int MEDIUM_ROWS = 65536;
    public static int MAX_ROWS = 0x110002;

    private final boolean $$robo$$android_icu_impl_PropsVectors$areElementsSame(int index1, int[] target, int index2, int length) {
        for (int i = 0; i < length; ++i) {
            if (this.v[index1 + i] == target[index2 + i]) continue;
            return false;
        }
        return true;
    }

    private final int $$robo$$android_icu_impl_PropsVectors$findRow(int rangeStart) {
        int index = 0;
        index = this.prevRow * this.columns;
        if (rangeStart >= this.v[index]) {
            if (rangeStart < this.v[index + 1]) {
                return index;
            }
            if (rangeStart < this.v[(index += this.columns) + 1]) {
                ++this.prevRow;
                return index;
            }
            if (rangeStart < this.v[(index += this.columns) + 1]) {
                this.prevRow += 2;
                return index;
            }
            if (rangeStart - this.v[index + 1] < 10) {
                this.prevRow += 2;
                do {
                    ++this.prevRow;
                } while (rangeStart >= this.v[(index += this.columns) + 1]);
                return index;
            }
        } else if (rangeStart < this.v[1]) {
            this.prevRow = 0;
            return 0;
        }
        int start = 0;
        int mid = 0;
        int limit = this.rows;
        while (start < limit - 1) {
            mid = (start + limit) / 2;
            index = this.columns * mid;
            if (rangeStart < this.v[index]) {
                limit = mid;
                continue;
            }
            if (rangeStart < this.v[index + 1]) {
                this.prevRow = mid;
                return index;
            }
            start = mid;
        }
        this.prevRow = start;
        index = start * this.columns;
        return index;
    }

    private void $$robo$$android_icu_impl_PropsVectors$__constructor__(int numOfColumns) {
        if (numOfColumns < 1) {
            throw new IllegalArgumentException("numOfColumns need to be no less than 1; but it is " + numOfColumns);
        }
        this.columns = numOfColumns + 2;
        this.v = new int[4096 * this.columns];
        this.maxRows = 4096;
        this.rows = 3;
        this.prevRow = 0;
        this.isCompacted = false;
        this.v[0] = 0;
        this.v[1] = 0x110000;
        int index = this.columns;
        for (int cp = 0x110000; cp <= 0x110001; ++cp) {
            this.v[index] = cp;
            this.v[index + 1] = cp + 1;
            index += this.columns;
        }
    }

    private final void $$robo$$android_icu_impl_PropsVectors$setValue(int start, int end, int column, int value, int mask) {
        boolean splitLastRow;
        if (start < 0 || start > end || end > 0x110001 || column < 0 || column >= this.columns - 2) {
            throw new IllegalArgumentException();
        }
        if (this.isCompacted) {
            throw new IllegalStateException("Shouldn't be called aftercompact()!");
        }
        int limit = end + 1;
        int firstRow = this.findRow(start);
        int lastRow = this.findRow(end);
        boolean splitFirstRow = start != this.v[firstRow] && (value &= mask) != (this.v[firstRow + (column += 2)] & mask);
        boolean bl = splitLastRow = limit != this.v[lastRow + 1] && value != (this.v[lastRow + column] & mask);
        if (splitFirstRow || splitLastRow) {
            int count;
            int rowsToExpand = 0;
            if (splitFirstRow) {
                ++rowsToExpand;
            }
            if (splitLastRow) {
                ++rowsToExpand;
            }
            int newMaxRows = 0;
            if (this.rows + rowsToExpand > this.maxRows) {
                if (this.maxRows < 65536) {
                    newMaxRows = 65536;
                } else if (this.maxRows < 0x110002) {
                    newMaxRows = 0x110002;
                } else {
                    throw new IndexOutOfBoundsException("MAX_ROWS exceeded! Increase it to a higher valuein the implementation");
                }
                int[] temp = new int[newMaxRows * this.columns];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.v, (int)0, (Object)temp, (int)0, (int)(this.rows * this.columns));
                this.v = temp;
                this.maxRows = newMaxRows;
            }
            if ((count = this.rows * this.columns - (lastRow + this.columns)) > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.v, (int)(lastRow + this.columns), (Object)this.v, (int)(lastRow + (1 + rowsToExpand) * this.columns), (int)count);
            }
            this.rows += rowsToExpand;
            if (splitFirstRow) {
                count = lastRow - firstRow + this.columns;
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.v, (int)firstRow, (Object)this.v, (int)(firstRow + this.columns), (int)count);
                lastRow += this.columns;
                int n = start;
                this.v[firstRow + this.columns] = n;
                this.v[firstRow + 1] = n;
                firstRow += this.columns;
            }
            if (splitLastRow) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.v, (int)lastRow, (Object)this.v, (int)(lastRow + this.columns), (int)this.columns);
                int n = limit;
                this.v[lastRow + this.columns] = n;
                this.v[lastRow + 1] = n;
            }
        }
        this.prevRow = lastRow / this.columns;
        firstRow += column;
        lastRow += column;
        mask ^= 0xFFFFFFFF;
        while (true) {
            this.v[firstRow] = this.v[firstRow] & mask | value;
            if (firstRow == lastRow) break;
            firstRow += this.columns;
        }
    }

    private final int $$robo$$android_icu_impl_PropsVectors$getValue(int c, int column) {
        if (this.isCompacted || c < 0 || c > 0x110001 || column < 0 || column >= this.columns - 2) {
            return 0;
        }
        int index = this.findRow(c);
        return this.v[index + 2 + column];
    }

    private final int[] $$robo$$android_icu_impl_PropsVectors$getRow(int rowIndex) {
        if (this.isCompacted) {
            throw new IllegalStateException("Illegal Invocation of the method after compact()");
        }
        if (rowIndex < 0 || rowIndex > this.rows) {
            throw new IllegalArgumentException("rowIndex out of bound!");
        }
        int[] rowToReturn = new int[this.columns - 2];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.v, (int)(rowIndex * this.columns + 2), (Object)rowToReturn, (int)0, (int)(this.columns - 2));
        return rowToReturn;
    }

    private final int $$robo$$android_icu_impl_PropsVectors$getRowStart(int rowIndex) {
        if (this.isCompacted) {
            throw new IllegalStateException("Illegal Invocation of the method after compact()");
        }
        if (rowIndex < 0 || rowIndex > this.rows) {
            throw new IllegalArgumentException("rowIndex out of bound!");
        }
        return this.v[rowIndex * this.columns];
    }

    private final int $$robo$$android_icu_impl_PropsVectors$getRowEnd(int rowIndex) {
        if (this.isCompacted) {
            throw new IllegalStateException("Illegal Invocation of the method after compact()");
        }
        if (rowIndex < 0 || rowIndex > this.rows) {
            throw new IllegalArgumentException("rowIndex out of bound!");
        }
        return this.v[rowIndex * this.columns + 1] - 1;
    }

    private final void $$robo$$android_icu_impl_PropsVectors$compact(CompactHandler compactor) {
        if (this.isCompacted) {
            return;
        }
        this.isCompacted = true;
        int valueColumns = this.columns - 2;
        Integer[] indexArray = new Integer[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            indexArray[i] = this.columns * i;
        }
        Arrays.sort(indexArray, new Comparator<Integer>(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ PropsVectors this$0;

            private void $$robo$$android_icu_impl_PropsVectors_1$__constructor__(PropsVectors this$0) {
                this.this$0 = this$0;
            }

            private final int $$robo$$android_icu_impl_PropsVectors_1$compare(Integer o1, Integer o2) {
                int indexOfRow1 = o1;
                int indexOfRow2 = o2;
                int count = this.this$0.columns;
                int index = 2;
                do {
                    if (this.this$0.v[indexOfRow1 + index] != this.this$0.v[indexOfRow2 + index]) {
                        return this.this$0.v[indexOfRow1 + index] < this.this$0.v[indexOfRow2 + index] ? -1 : 1;
                    }
                    if (++index != this.this$0.columns) continue;
                    index = 0;
                } while (--count > 0);
                return 0;
            }

            private void __constructor__(PropsVectors propsVectors) {
                this.$$robo$$android_icu_impl_PropsVectors_1$__constructor__(propsVectors);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_PropsVectors_1$__constructor__(android.icu.impl.PropsVectors ), this, propsVectors);
            }

            @Override
            public int compare(Integer n, Integer n2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_icu_impl_PropsVectors_1$compare(java.lang.Integer java.lang.Integer ), this, n, n2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        int count = -valueColumns;
        for (int i = 0; i < this.rows; ++i) {
            int start = this.v[indexArray[i]];
            if (count < 0 || !this.areElementsSame(indexArray[i] + 2, this.v, indexArray[i - 1] + 2, valueColumns)) {
                count += valueColumns;
            }
            if (start == 0x110000) {
                compactor.setRowIndexForInitialValue(count);
                continue;
            }
            if (start != 0x110001) continue;
            compactor.setRowIndexForErrorValue(count);
        }
        compactor.startRealValues(count += valueColumns);
        int[] temp = new int[count];
        count = -valueColumns;
        for (int i = 0; i < this.rows; ++i) {
            int start = this.v[indexArray[i]];
            int limit = this.v[indexArray[i] + 1];
            if (count < 0 || !this.areElementsSame(indexArray[i] + 2, temp, count, valueColumns)) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.v, (int)(indexArray[i] + 2), (Object)temp, (int)(count += valueColumns), (int)valueColumns);
            }
            if (start >= 0x110000) continue;
            compactor.setRowIndexForRange(start, limit - 1, count);
        }
        this.v = temp;
        this.rows = count / valueColumns + 1;
    }

    private final int[] $$robo$$android_icu_impl_PropsVectors$getCompactedArray() {
        if (!this.isCompacted) {
            throw new IllegalStateException("Illegal Invocation of the method before compact()");
        }
        return this.v;
    }

    private final int $$robo$$android_icu_impl_PropsVectors$getCompactedRows() {
        if (!this.isCompacted) {
            throw new IllegalStateException("Illegal Invocation of the method before compact()");
        }
        return this.rows;
    }

    private final int $$robo$$android_icu_impl_PropsVectors$getCompactedColumns() {
        if (!this.isCompacted) {
            throw new IllegalStateException("Illegal Invocation of the method before compact()");
        }
        return this.columns - 2;
    }

    private final IntTrie $$robo$$android_icu_impl_PropsVectors$compactToTrieWithRowIndexes() {
        PVecToTrieCompactHandler compactor = new PVecToTrieCompactHandler();
        this.compact(compactor);
        return compactor.builder.serialize(new DefaultGetFoldedValue(compactor.builder), new DefaultGetFoldingOffset(null));
    }

    private boolean areElementsSame(int n, int[] nArray, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("areElementsSame", $$robo$$android_icu_impl_PropsVectors$areElementsSame(int int[] int int ), this, n, nArray, n2, n3);
    }

    private int findRow(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findRow", $$robo$$android_icu_impl_PropsVectors$findRow(int ), this, n);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_icu_impl_PropsVectors$__constructor__(n);
    }

    public PropsVectors(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_PropsVectors$__constructor__(int ), this, n);
    }

    public void setValue(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_icu_impl_PropsVectors$setValue(int int int int int ), this, n, n2, n3, n4, n5);
    }

    public int getValue(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_icu_impl_PropsVectors$getValue(int int ), this, n, n2);
    }

    public int[] getRow(int n) {
        return InvokeDynamicSupport.bootstrap("getRow", $$robo$$android_icu_impl_PropsVectors$getRow(int ), this, n);
    }

    public int getRowStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRowStart", $$robo$$android_icu_impl_PropsVectors$getRowStart(int ), this, n);
    }

    public int getRowEnd(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRowEnd", $$robo$$android_icu_impl_PropsVectors$getRowEnd(int ), this, n);
    }

    public void compact(CompactHandler compactHandler) {
        InvokeDynamicSupport.bootstrap("compact", $$robo$$android_icu_impl_PropsVectors$compact(android.icu.impl.PropsVectors$CompactHandler ), this, compactHandler);
    }

    public int[] getCompactedArray() {
        return InvokeDynamicSupport.bootstrap("getCompactedArray", $$robo$$android_icu_impl_PropsVectors$getCompactedArray(), this);
    }

    public int getCompactedRows() {
        return (int)InvokeDynamicSupport.bootstrap("getCompactedRows", $$robo$$android_icu_impl_PropsVectors$getCompactedRows(), this);
    }

    public int getCompactedColumns() {
        return (int)InvokeDynamicSupport.bootstrap("getCompactedColumns", $$robo$$android_icu_impl_PropsVectors$getCompactedColumns(), this);
    }

    public IntTrie compactToTrieWithRowIndexes() {
        return InvokeDynamicSupport.bootstrap("compactToTrieWithRowIndexes", $$robo$$android_icu_impl_PropsVectors$compactToTrieWithRowIndexes(), this);
    }

    public /* synthetic */ PropsVectors() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PropsVectors)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface CompactHandler {
        public void setRowIndexForRange(int var1, int var2, int var3);

        public void setRowIndexForInitialValue(int var1);

        public void setRowIndexForErrorValue(int var1);

        public void startRealValues(int var1);
    }

    private static class DefaultGetFoldedValue
    implements TrieBuilder.DataManipulate,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private IntTrieBuilder builder;

        private void $$robo$$android_icu_impl_PropsVectors_DefaultGetFoldedValue$__constructor__(IntTrieBuilder inBuilder) {
            this.builder = inBuilder;
        }

        private final int $$robo$$android_icu_impl_PropsVectors_DefaultGetFoldedValue$getFoldedValue(int start, int offset) {
            int initialValue = this.builder.m_initialValue_;
            int limit = start + 1024;
            while (start < limit) {
                boolean[] inBlockZero = new boolean[1];
                int value = this.builder.getValue(start, inBlockZero);
                if (inBlockZero[0]) {
                    start += 32;
                    continue;
                }
                if (value != initialValue) {
                    return offset;
                }
                ++start;
            }
            return 0;
        }

        private void __constructor__(IntTrieBuilder intTrieBuilder) {
            this.$$robo$$android_icu_impl_PropsVectors_DefaultGetFoldedValue$__constructor__(intTrieBuilder);
        }

        public DefaultGetFoldedValue(IntTrieBuilder intTrieBuilder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_PropsVectors_DefaultGetFoldedValue$__constructor__(android.icu.impl.IntTrieBuilder ), this, intTrieBuilder);
        }

        @Override
        public int getFoldedValue(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("getFoldedValue", $$robo$$android_icu_impl_PropsVectors_DefaultGetFoldedValue$getFoldedValue(int int ), this, n, n2);
        }

        public /* synthetic */ DefaultGetFoldedValue() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultGetFoldedValue)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class DefaultGetFoldingOffset
    implements Trie.DataManipulate,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_PropsVectors_DefaultGetFoldingOffset$__constructor__() {
        }

        private final int $$robo$$android_icu_impl_PropsVectors_DefaultGetFoldingOffset$getFoldingOffset(int value) {
            return value;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_PropsVectors_DefaultGetFoldingOffset$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_PropsVectors_DefaultGetFoldingOffset$__constructor__();
        }

        public DefaultGetFoldingOffset() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_PropsVectors_DefaultGetFoldingOffset$__constructor__(), this);
        }

        @Override
        public int getFoldingOffset(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getFoldingOffset", $$robo$$android_icu_impl_PropsVectors_DefaultGetFoldingOffset$getFoldingOffset(int ), this, n);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_PropsVectors_DefaultGetFoldingOffset$__constructor__(var1_1);
        }

        public /* synthetic */ DefaultGetFoldingOffset(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_PropsVectors_DefaultGetFoldingOffset$__constructor__(android.icu.impl.PropsVectors$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultGetFoldingOffset)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

