/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import com.google.errorprone.annotations.DoNotMock;
import java.util.Date;
import java.util.TimeZone;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CalendarAstronomer
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static double SIDEREAL_DAY = 23.93446960027;
    public static double SOLAR_DAY = 24.065709816;
    public static double SYNODIC_MONTH = 29.530588853;
    public static double SIDEREAL_MONTH = 27.32166;
    public static double TROPICAL_YEAR = 365.242191;
    public static double SIDEREAL_YEAR = 365.25636;
    public static int SECOND_MS = 1000;
    public static int MINUTE_MS = 60000;
    public static int HOUR_MS = 3600000;
    public static long DAY_MS = 86400000L;
    public static long JULIAN_EPOCH_MS = -210866760000000L;
    static long EPOCH_2000_MS = 946598400000L;
    private static double PI = Math.PI;
    private static double PI2 = Math.PI * 2;
    private static double RAD_HOUR = 3.819718634205488;
    private static double DEG_RAD = Math.PI / 180;
    private static double RAD_DEG = 57.29577951308232;
    static double JD_EPOCH = 2447891.5;
    static double SUN_ETA_G = 4.87650757829735;
    static double SUN_OMEGA_G = 4.935239984568769;
    static double SUN_E = 0.016713;
    public static SolarLongitude VERNAL_EQUINOX;
    public static SolarLongitude SUMMER_SOLSTICE;
    public static SolarLongitude AUTUMN_EQUINOX;
    public static SolarLongitude WINTER_SOLSTICE;
    static double moonL0 = 5.556284436750021;
    static double moonP0 = 0.6342598060246725;
    static double moonN0 = 5.559050068029439;
    static double moonI = 0.08980357792017056;
    static double moonE = 0.0549;
    static double moonA = 384401.0;
    static double moonT0 = 0.009042550854582622;
    static double moonPi = 0.016592845198710092;
    public static MoonAge NEW_MOON;
    public static MoonAge FIRST_QUARTER;
    public static MoonAge FULL_MOON;
    public static MoonAge LAST_QUARTER;
    private long time;
    private double fLongitude;
    private double fLatitude;
    private long fGmtOffset;
    private static double INVALID = Double.MIN_VALUE;
    private transient double julianDay;
    private transient double julianCentury;
    private transient double sunLongitude;
    private transient double meanAnomalySun;
    private transient double moonLongitude;
    private transient double moonEclipLong;
    private transient double eclipObliquity;
    private transient double siderealT0;
    private transient double siderealTime;
    private transient Equatorial moonPosition;

    private void $$robo$$android_icu_impl_CalendarAstronomer$__constructor__() {
    }

    private void $$robo$$android_icu_impl_CalendarAstronomer$__constructor__(Date d) {
    }

    private void $$robo$$android_icu_impl_CalendarAstronomer$__constructor__(long aTime) {
        this.fLongitude = 0.0;
        this.fLatitude = 0.0;
        this.fGmtOffset = 0L;
        this.julianDay = Double.MIN_VALUE;
        this.julianCentury = Double.MIN_VALUE;
        this.sunLongitude = Double.MIN_VALUE;
        this.meanAnomalySun = Double.MIN_VALUE;
        this.moonLongitude = Double.MIN_VALUE;
        this.moonEclipLong = Double.MIN_VALUE;
        this.eclipObliquity = Double.MIN_VALUE;
        this.siderealT0 = Double.MIN_VALUE;
        this.siderealTime = Double.MIN_VALUE;
        this.moonPosition = null;
        this.time = aTime;
    }

    private void $$robo$$android_icu_impl_CalendarAstronomer$__constructor__(double longitude, double latitude) {
        this.fLongitude = CalendarAstronomer.normPI(longitude * (Math.PI / 180));
        this.fLatitude = CalendarAstronomer.normPI(latitude * (Math.PI / 180));
        this.fGmtOffset = (long)(this.fLongitude * 24.0 * 3600000.0 / (Math.PI * 2));
    }

    private final void $$robo$$android_icu_impl_CalendarAstronomer$setTime(long aTime) {
        this.time = aTime;
        this.clearCache();
    }

    private final void $$robo$$android_icu_impl_CalendarAstronomer$setDate(Date date) {
        this.setTime(date.getTime());
    }

    private final void $$robo$$android_icu_impl_CalendarAstronomer$setJulianDay(double jdn) {
        this.time = (long)(jdn * 8.64E7) + -210866760000000L;
        this.clearCache();
        this.julianDay = jdn;
    }

    private final long $$robo$$android_icu_impl_CalendarAstronomer$getTime() {
        return this.time;
    }

    private final Date $$robo$$android_icu_impl_CalendarAstronomer$getDate() {
        return new Date(this.time);
    }

    private final double $$robo$$android_icu_impl_CalendarAstronomer$getJulianDay() {
        if (this.julianDay == Double.MIN_VALUE) {
            this.julianDay = (double)(this.time - -210866760000000L) / 8.64E7;
        }
        return this.julianDay;
    }

    private final double $$robo$$android_icu_impl_CalendarAstronomer$getJulianCentury() {
        if (this.julianCentury == Double.MIN_VALUE) {
            this.julianCentury = (this.getJulianDay() - 2415020.0) / 36525.0;
        }
        return this.julianCentury;
    }

    private final double $$robo$$android_icu_impl_CalendarAstronomer$getGreenwichSidereal() {
        if (this.siderealTime == Double.MIN_VALUE) {
            double UT = CalendarAstronomer.normalize((double)this.time / 3600000.0, 24.0);
            this.siderealTime = CalendarAstronomer.normalize(this.getSiderealOffset() + UT * 1.002737909, 24.0);
        }
        return this.siderealTime;
    }

    private final double $$robo$$android_icu_impl_CalendarAstronomer$getSiderealOffset() {
        if (this.siderealT0 == Double.MIN_VALUE) {
            double JD = Math.floor(this.getJulianDay() - 0.5) + 0.5;
            double S = JD - 2451545.0;
            double T2 = S / 36525.0;
            this.siderealT0 = CalendarAstronomer.normalize(6.697374558 + 2400.051336 * T2 + 2.5862E-5 * T2 * T2, 24.0);
        }
        return this.siderealT0;
    }

    private final double $$robo$$android_icu_impl_CalendarAstronomer$getLocalSidereal() {
        return CalendarAstronomer.normalize(this.getGreenwichSidereal() + (double)this.fGmtOffset / 3600000.0, 24.0);
    }

    private final long $$robo$$android_icu_impl_CalendarAstronomer$lstToUT(double lst) {
        double lt = CalendarAstronomer.normalize((lst - this.getSiderealOffset()) * 0.9972695663, 24.0);
        long base = 86400000L * ((this.time + this.fGmtOffset) / 86400000L) - this.fGmtOffset;
        return base + (long)(lt * 3600000.0);
    }

    private final Equatorial $$robo$$android_icu_impl_CalendarAstronomer$eclipticToEquatorial(Ecliptic ecliptic) {
        return this.eclipticToEquatorial(ecliptic.longitude, ecliptic.latitude);
    }

    private final Equatorial $$robo$$android_icu_impl_CalendarAstronomer$eclipticToEquatorial(double eclipLong, double eclipLat) {
        double obliq = this.eclipticObliquity();
        double sinE = Math.sin(obliq);
        double cosE = Math.cos(obliq);
        double sinL = Math.sin(eclipLong);
        double cosL = Math.cos(eclipLong);
        double sinB = Math.sin(eclipLat);
        double cosB = Math.cos(eclipLat);
        double tanB = Math.tan(eclipLat);
        return new Equatorial(Math.atan2(sinL * cosE - tanB * sinE, cosL), Math.asin(sinB * cosE + cosB * sinE * sinL));
    }

    private final Equatorial $$robo$$android_icu_impl_CalendarAstronomer$eclipticToEquatorial(double eclipLong) {
        return this.eclipticToEquatorial(eclipLong, 0.0);
    }

    private final Horizon $$robo$$android_icu_impl_CalendarAstronomer$eclipticToHorizon(double eclipLong) {
        Equatorial equatorial = this.eclipticToEquatorial(eclipLong);
        double H2 = this.getLocalSidereal() * Math.PI / 12.0 - equatorial.ascension;
        double sinH = Math.sin(H2);
        double cosH = Math.cos(H2);
        double sinD = Math.sin(equatorial.declination);
        double cosD = Math.cos(equatorial.declination);
        double sinL = Math.sin(this.fLatitude);
        double cosL = Math.cos(this.fLatitude);
        double altitude = Math.asin(sinD * sinL + cosD * cosL * cosH);
        double azimuth = Math.atan2(-cosD * cosL * sinH, sinD - sinL * Math.sin(altitude));
        return new Horizon(azimuth, altitude);
    }

    private final double $$robo$$android_icu_impl_CalendarAstronomer$getSunLongitude() {
        if (this.sunLongitude == Double.MIN_VALUE) {
            double[] result = this.getSunLongitude(this.getJulianDay());
            this.sunLongitude = result[0];
            this.meanAnomalySun = result[1];
        }
        return this.sunLongitude;
    }

    private final double[] $$robo$$android_icu_impl_CalendarAstronomer$getSunLongitude(double julian) {
        double day = julian - 2447891.5;
        double epochAngle = CalendarAstronomer.norm2PI(0.017202791632524146 * day);
        double meanAnomaly = CalendarAstronomer.norm2PI(epochAngle + 4.87650757829735 - 4.935239984568769);
        return new double[]{CalendarAstronomer.norm2PI(this.trueAnomaly(meanAnomaly, 0.016713) + 4.935239984568769), meanAnomaly};
    }

    private final Equatorial $$robo$$android_icu_impl_CalendarAstronomer$getSunPosition() {
        return this.eclipticToEquatorial(this.getSunLongitude(), 0.0);
    }

    private final long $$robo$$android_icu_impl_CalendarAstronomer$getSunTime(double desired, boolean next) {
        return this.timeOfAngle(new AngleFunc(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CalendarAstronomer this$0;

            private void $$robo$$android_icu_impl_CalendarAstronomer_1$__constructor__(CalendarAstronomer this$0) {
                this.this$0 = this$0;
            }

            private final double $$robo$$android_icu_impl_CalendarAstronomer_1$eval() {
                return this.this$0.getSunLongitude();
            }

            private void __constructor__(CalendarAstronomer calendarAstronomer) {
                this.$$robo$$android_icu_impl_CalendarAstronomer_1$__constructor__(calendarAstronomer);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarAstronomer_1$__constructor__(android.icu.impl.CalendarAstronomer ), this, calendarAstronomer);
            }

            @Override
            public double eval() {
                return (double)InvokeDynamicSupport.bootstrap("eval", $$robo$$android_icu_impl_CalendarAstronomer_1$eval(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, desired, 365.242191, 60000L, next);
    }

    private final long $$robo$$android_icu_impl_CalendarAstronomer$getSunTime(SolarLongitude desired, boolean next) {
        return this.getSunTime(desired.value, next);
    }

    private final long $$robo$$android_icu_impl_CalendarAstronomer$getSunRiseSet(boolean rise) {
        long t0 = this.time;
        long noon = (this.time + this.fGmtOffset) / 86400000L * 86400000L - this.fGmtOffset + 43200000L;
        this.setTime(noon + (rise ? -6L : 6L) * 3600000L);
        long t = this.riseOrSet(new CoordFunc(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CalendarAstronomer this$0;

            private void $$robo$$android_icu_impl_CalendarAstronomer_2$__constructor__(CalendarAstronomer this$0) {
                this.this$0 = this$0;
            }

            private final Equatorial $$robo$$android_icu_impl_CalendarAstronomer_2$eval() {
                return this.this$0.getSunPosition();
            }

            private void __constructor__(CalendarAstronomer calendarAstronomer) {
                this.$$robo$$android_icu_impl_CalendarAstronomer_2$__constructor__(calendarAstronomer);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarAstronomer_2$__constructor__(android.icu.impl.CalendarAstronomer ), this, calendarAstronomer);
            }

            @Override
            public Equatorial eval() {
                return InvokeDynamicSupport.bootstrap("eval", $$robo$$android_icu_impl_CalendarAstronomer_2$eval(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, rise, 0.009302604913129777, 0.009890199094634533, 5000L);
        this.setTime(t0);
        return t;
    }

    private final Equatorial $$robo$$android_icu_impl_CalendarAstronomer$getMoonPosition() {
        if (this.moonPosition == null) {
            double sunLong = this.getSunLongitude();
            double day = this.getJulianDay() - 2447891.5;
            double meanLongitude = CalendarAstronomer.norm2PI(0.22997150421858628 * day + 5.556284436750021);
            double meanAnomalyMoon = CalendarAstronomer.norm2PI(meanLongitude - 0.001944368345221015 * day - 0.6342598060246725);
            double evection = 0.022233749341155764 * Math.sin(2.0 * (meanLongitude - sunLong) - meanAnomalyMoon);
            double annual = 0.003242821750205464 * Math.sin(this.meanAnomalySun);
            double a3 = 0.00645771823237902 * Math.sin(this.meanAnomalySun);
            double center = 0.10975677534091541 * Math.sin(meanAnomalyMoon += evection - annual - a3);
            double a4 = 0.0037350045992678655 * Math.sin(2.0 * meanAnomalyMoon);
            this.moonLongitude = meanLongitude + evection + center - annual + a4;
            double variation = 0.011489502465878671 * Math.sin(2.0 * (this.moonLongitude - sunLong));
            this.moonLongitude += variation;
            double nodeLongitude = CalendarAstronomer.norm2PI(5.559050068029439 - 9.242199067718253E-4 * day);
            double y = Math.sin(this.moonLongitude - (nodeLongitude -= 0.0027925268031909274 * Math.sin(this.meanAnomalySun)));
            double x = Math.cos(this.moonLongitude - nodeLongitude);
            this.moonEclipLong = Math.atan2(y * Math.cos(0.08980357792017056), x) + nodeLongitude;
            double moonEclipLat = Math.asin(y * Math.sin(0.08980357792017056));
            this.moonPosition = this.eclipticToEquatorial(this.moonEclipLong, moonEclipLat);
        }
        return this.moonPosition;
    }

    private final double $$robo$$android_icu_impl_CalendarAstronomer$getMoonAge() {
        this.getMoonPosition();
        return CalendarAstronomer.norm2PI(this.moonEclipLong - this.sunLongitude);
    }

    private final double $$robo$$android_icu_impl_CalendarAstronomer$getMoonPhase() {
        return 0.5 * (1.0 - Math.cos(this.getMoonAge()));
    }

    private final long $$robo$$android_icu_impl_CalendarAstronomer$getMoonTime(double desired, boolean next) {
        return this.timeOfAngle(new AngleFunc(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CalendarAstronomer this$0;

            private void $$robo$$android_icu_impl_CalendarAstronomer_3$__constructor__(CalendarAstronomer this$0) {
                this.this$0 = this$0;
            }

            private final double $$robo$$android_icu_impl_CalendarAstronomer_3$eval() {
                return this.this$0.getMoonAge();
            }

            private void __constructor__(CalendarAstronomer calendarAstronomer) {
                this.$$robo$$android_icu_impl_CalendarAstronomer_3$__constructor__(calendarAstronomer);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarAstronomer_3$__constructor__(android.icu.impl.CalendarAstronomer ), this, calendarAstronomer);
            }

            @Override
            public double eval() {
                return (double)InvokeDynamicSupport.bootstrap("eval", $$robo$$android_icu_impl_CalendarAstronomer_3$eval(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, desired, 29.530588853, 60000L, next);
    }

    private final long $$robo$$android_icu_impl_CalendarAstronomer$getMoonTime(MoonAge desired, boolean next) {
        return this.getMoonTime(desired.value, next);
    }

    private final long $$robo$$android_icu_impl_CalendarAstronomer$getMoonRiseSet(boolean rise) {
        return this.riseOrSet(new CoordFunc(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CalendarAstronomer this$0;

            private void $$robo$$android_icu_impl_CalendarAstronomer_4$__constructor__(CalendarAstronomer this$0) {
                this.this$0 = this$0;
            }

            private final Equatorial $$robo$$android_icu_impl_CalendarAstronomer_4$eval() {
                return this.this$0.getMoonPosition();
            }

            private void __constructor__(CalendarAstronomer calendarAstronomer) {
                this.$$robo$$android_icu_impl_CalendarAstronomer_4$__constructor__(calendarAstronomer);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarAstronomer_4$__constructor__(android.icu.impl.CalendarAstronomer ), this, calendarAstronomer);
            }

            @Override
            public Equatorial eval() {
                return InvokeDynamicSupport.bootstrap("eval", $$robo$$android_icu_impl_CalendarAstronomer_4$eval(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, rise, 0.009302604913129777, 0.009890199094634533, 60000L);
    }

    private final long $$robo$$android_icu_impl_CalendarAstronomer$timeOfAngle(AngleFunc func, double desired, double periodDays, long epsilon, boolean next) {
        double deltaT;
        double lastAngle = func.eval();
        double deltaAngle = CalendarAstronomer.norm2PI(desired - lastAngle);
        double lastDeltaT = deltaT = (deltaAngle + (next ? 0.0 : Math.PI * -2)) * (periodDays * 8.64E7) / (Math.PI * 2);
        long startTime = this.time;
        this.setTime(this.time + (long)deltaT);
        do {
            double angle = func.eval();
            double factor = Math.abs(deltaT / CalendarAstronomer.normPI(angle - lastAngle));
            deltaT = CalendarAstronomer.normPI(desired - angle) * factor;
            if (Math.abs(deltaT) > Math.abs(lastDeltaT)) {
                long delta = (long)(periodDays * 8.64E7 / 8.0);
                this.setTime(startTime + (next ? delta : -delta));
                return this.timeOfAngle(func, desired, periodDays, epsilon, next);
            }
            lastDeltaT = deltaT;
            lastAngle = angle;
            this.setTime(this.time + (long)deltaT);
        } while (Math.abs(deltaT) > (double)epsilon);
        return this.time;
    }

    private final long $$robo$$android_icu_impl_CalendarAstronomer$riseOrSet(CoordFunc func, boolean rise, double diameter, double refraction, long epsilon) {
        Equatorial pos = null;
        double tanL = Math.tan(this.fLatitude);
        long deltaT = Long.MAX_VALUE;
        int count = 0;
        do {
            pos = func.eval();
            double angle = Math.acos(-tanL * Math.tan(pos.declination));
            double lst = ((rise ? Math.PI * 2 - angle : angle) + pos.ascension) * 24.0 / (Math.PI * 2);
            long newTime = this.lstToUT(lst);
            deltaT = newTime - this.time;
            this.setTime(newTime);
        } while (++count < 5 && Math.abs(deltaT) > epsilon);
        double cosD = Math.cos(pos.declination);
        double psi = Math.acos(Math.sin(this.fLatitude) / cosD);
        double x = diameter / 2.0 + refraction;
        double y = Math.asin(Math.sin(x) / Math.sin(psi));
        long delta = (long)(240.0 * y * 57.29577951308232 / cosD * 1000.0);
        return this.time + (rise ? -delta : delta);
    }

    private static final double $$robo$$android_icu_impl_CalendarAstronomer$normalize(double value, double range) {
        return value - range * Math.floor(value / range);
    }

    private static final double $$robo$$android_icu_impl_CalendarAstronomer$norm2PI(double angle) {
        return CalendarAstronomer.normalize(angle, Math.PI * 2);
    }

    private static final double $$robo$$android_icu_impl_CalendarAstronomer$normPI(double angle) {
        return CalendarAstronomer.normalize(angle + Math.PI, Math.PI * 2) - Math.PI;
    }

    private final double $$robo$$android_icu_impl_CalendarAstronomer$trueAnomaly(double meanAnomaly, double eccentricity) {
        double delta;
        double E = meanAnomaly;
        do {
            delta = E - eccentricity * Math.sin(E) - meanAnomaly;
            E -= delta / (1.0 - eccentricity * Math.cos(E));
        } while (Math.abs(delta) > 1.0E-5);
        return 2.0 * Math.atan(Math.tan(E / 2.0) * Math.sqrt((1.0 + eccentricity) / (1.0 - eccentricity)));
    }

    private final double $$robo$$android_icu_impl_CalendarAstronomer$eclipticObliquity() {
        if (this.eclipObliquity == Double.MIN_VALUE) {
            double epoch = 2451545.0;
            double T2 = (this.getJulianDay() - 2451545.0) / 36525.0;
            this.eclipObliquity = 23.439292 - 0.013004166666666666 * T2 - 1.6666666666666665E-7 * T2 * T2 + 5.027777777777778E-7 * T2 * T2 * T2;
            this.eclipObliquity *= Math.PI / 180;
        }
        return this.eclipObliquity;
    }

    private final void $$robo$$android_icu_impl_CalendarAstronomer$clearCache() {
        this.julianDay = Double.MIN_VALUE;
        this.julianCentury = Double.MIN_VALUE;
        this.sunLongitude = Double.MIN_VALUE;
        this.meanAnomalySun = Double.MIN_VALUE;
        this.moonLongitude = Double.MIN_VALUE;
        this.moonEclipLong = Double.MIN_VALUE;
        this.eclipObliquity = Double.MIN_VALUE;
        this.siderealTime = Double.MIN_VALUE;
        this.siderealT0 = Double.MIN_VALUE;
        this.moonPosition = null;
    }

    private final String $$robo$$android_icu_impl_CalendarAstronomer$local(long localMillis) {
        return new Date(localMillis - (long)TimeZone.getDefault().getRawOffset()).toString();
    }

    private static final String $$robo$$android_icu_impl_CalendarAstronomer$radToHms(double angle) {
        int hrs = (int)(angle * 3.819718634205488);
        int min = (int)((angle * 3.819718634205488 - (double)hrs) * 60.0);
        int sec = (int)((angle * 3.819718634205488 - (double)hrs - (double)min / 60.0) * 3600.0);
        return Integer.toString(hrs) + "h" + min + "m" + sec + "s";
    }

    private static final String $$robo$$android_icu_impl_CalendarAstronomer$radToDms(double angle) {
        int deg = (int)(angle * 57.29577951308232);
        int min = (int)((angle * 57.29577951308232 - (double)deg) * 60.0);
        int sec = (int)((angle * 57.29577951308232 - (double)deg - (double)min / 60.0) * 3600.0);
        return Integer.toString(deg) + "\u00b0" + min + "'" + sec + "\"";
    }

    static void __staticInitializer__() {
        VERNAL_EQUINOX = new SolarLongitude(0.0);
        SUMMER_SOLSTICE = new SolarLongitude(1.5707963267948966);
        AUTUMN_EQUINOX = new SolarLongitude(Math.PI);
        WINTER_SOLSTICE = new SolarLongitude(4.71238898038469);
        NEW_MOON = new MoonAge(0.0);
        FIRST_QUARTER = new MoonAge(1.5707963267948966);
        FULL_MOON = new MoonAge(Math.PI);
        LAST_QUARTER = new MoonAge(4.71238898038469);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_CalendarAstronomer$__constructor__();
    }

    public CalendarAstronomer() {
        this((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarAstronomer$__constructor__(), this);
    }

    private void __constructor__(Date date) {
        this.$$robo$$android_icu_impl_CalendarAstronomer$__constructor__(date);
    }

    public CalendarAstronomer(Date date) {
        this(date.getTime());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarAstronomer$__constructor__(java.util.Date ), this, date);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_icu_impl_CalendarAstronomer$__constructor__(l);
    }

    public CalendarAstronomer(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarAstronomer$__constructor__(long ), this, l);
    }

    private void __constructor__(double d, double d2) {
        this.$$robo$$android_icu_impl_CalendarAstronomer$__constructor__(d, d2);
    }

    public CalendarAstronomer(double d, double d2) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarAstronomer$__constructor__(double double ), this, d, d2);
    }

    public void setTime(long l) {
        InvokeDynamicSupport.bootstrap("setTime", $$robo$$android_icu_impl_CalendarAstronomer$setTime(long ), this, l);
    }

    public void setDate(Date date) {
        InvokeDynamicSupport.bootstrap("setDate", $$robo$$android_icu_impl_CalendarAstronomer$setDate(java.util.Date ), this, date);
    }

    public void setJulianDay(double d) {
        InvokeDynamicSupport.bootstrap("setJulianDay", $$robo$$android_icu_impl_CalendarAstronomer$setJulianDay(double ), this, d);
    }

    public long getTime() {
        return (long)InvokeDynamicSupport.bootstrap("getTime", $$robo$$android_icu_impl_CalendarAstronomer$getTime(), this);
    }

    public Date getDate() {
        return InvokeDynamicSupport.bootstrap("getDate", $$robo$$android_icu_impl_CalendarAstronomer$getDate(), this);
    }

    public double getJulianDay() {
        return (double)InvokeDynamicSupport.bootstrap("getJulianDay", $$robo$$android_icu_impl_CalendarAstronomer$getJulianDay(), this);
    }

    public double getJulianCentury() {
        return (double)InvokeDynamicSupport.bootstrap("getJulianCentury", $$robo$$android_icu_impl_CalendarAstronomer$getJulianCentury(), this);
    }

    public double getGreenwichSidereal() {
        return (double)InvokeDynamicSupport.bootstrap("getGreenwichSidereal", $$robo$$android_icu_impl_CalendarAstronomer$getGreenwichSidereal(), this);
    }

    private double getSiderealOffset() {
        return (double)InvokeDynamicSupport.bootstrap("getSiderealOffset", $$robo$$android_icu_impl_CalendarAstronomer$getSiderealOffset(), this);
    }

    public double getLocalSidereal() {
        return (double)InvokeDynamicSupport.bootstrap("getLocalSidereal", $$robo$$android_icu_impl_CalendarAstronomer$getLocalSidereal(), this);
    }

    private long lstToUT(double d) {
        return (long)InvokeDynamicSupport.bootstrap("lstToUT", $$robo$$android_icu_impl_CalendarAstronomer$lstToUT(double ), this, d);
    }

    public Equatorial eclipticToEquatorial(Ecliptic ecliptic) {
        return InvokeDynamicSupport.bootstrap("eclipticToEquatorial", $$robo$$android_icu_impl_CalendarAstronomer$eclipticToEquatorial(android.icu.impl.CalendarAstronomer$Ecliptic ), this, ecliptic);
    }

    public Equatorial eclipticToEquatorial(double d, double d2) {
        return InvokeDynamicSupport.bootstrap("eclipticToEquatorial", $$robo$$android_icu_impl_CalendarAstronomer$eclipticToEquatorial(double double ), this, d, d2);
    }

    public Equatorial eclipticToEquatorial(double d) {
        return InvokeDynamicSupport.bootstrap("eclipticToEquatorial", $$robo$$android_icu_impl_CalendarAstronomer$eclipticToEquatorial(double ), this, d);
    }

    public Horizon eclipticToHorizon(double d) {
        return InvokeDynamicSupport.bootstrap("eclipticToHorizon", $$robo$$android_icu_impl_CalendarAstronomer$eclipticToHorizon(double ), this, d);
    }

    public double getSunLongitude() {
        return (double)InvokeDynamicSupport.bootstrap("getSunLongitude", $$robo$$android_icu_impl_CalendarAstronomer$getSunLongitude(), this);
    }

    double[] getSunLongitude(double d) {
        return InvokeDynamicSupport.bootstrap("getSunLongitude", $$robo$$android_icu_impl_CalendarAstronomer$getSunLongitude(double ), this, d);
    }

    public Equatorial getSunPosition() {
        return InvokeDynamicSupport.bootstrap("getSunPosition", $$robo$$android_icu_impl_CalendarAstronomer$getSunPosition(), this);
    }

    public long getSunTime(double d, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("getSunTime", $$robo$$android_icu_impl_CalendarAstronomer$getSunTime(double boolean ), this, d, bl);
    }

    public long getSunTime(SolarLongitude solarLongitude, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("getSunTime", $$robo$$android_icu_impl_CalendarAstronomer$getSunTime(android.icu.impl.CalendarAstronomer$SolarLongitude boolean ), this, solarLongitude, bl);
    }

    public long getSunRiseSet(boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("getSunRiseSet", $$robo$$android_icu_impl_CalendarAstronomer$getSunRiseSet(boolean ), this, bl);
    }

    public Equatorial getMoonPosition() {
        return InvokeDynamicSupport.bootstrap("getMoonPosition", $$robo$$android_icu_impl_CalendarAstronomer$getMoonPosition(), this);
    }

    public double getMoonAge() {
        return (double)InvokeDynamicSupport.bootstrap("getMoonAge", $$robo$$android_icu_impl_CalendarAstronomer$getMoonAge(), this);
    }

    public double getMoonPhase() {
        return (double)InvokeDynamicSupport.bootstrap("getMoonPhase", $$robo$$android_icu_impl_CalendarAstronomer$getMoonPhase(), this);
    }

    public long getMoonTime(double d, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("getMoonTime", $$robo$$android_icu_impl_CalendarAstronomer$getMoonTime(double boolean ), this, d, bl);
    }

    public long getMoonTime(MoonAge moonAge, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("getMoonTime", $$robo$$android_icu_impl_CalendarAstronomer$getMoonTime(android.icu.impl.CalendarAstronomer$MoonAge boolean ), this, moonAge, bl);
    }

    public long getMoonRiseSet(boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("getMoonRiseSet", $$robo$$android_icu_impl_CalendarAstronomer$getMoonRiseSet(boolean ), this, bl);
    }

    private long timeOfAngle(AngleFunc angleFunc, double d, double d2, long l, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("timeOfAngle", $$robo$$android_icu_impl_CalendarAstronomer$timeOfAngle(android.icu.impl.CalendarAstronomer$AngleFunc double double long boolean ), this, angleFunc, d, d2, l, bl);
    }

    private long riseOrSet(CoordFunc coordFunc, boolean bl, double d, double d2, long l) {
        return (long)InvokeDynamicSupport.bootstrap("riseOrSet", $$robo$$android_icu_impl_CalendarAstronomer$riseOrSet(android.icu.impl.CalendarAstronomer$CoordFunc boolean double double long ), this, coordFunc, bl, d, d2, l);
    }

    private static double normalize(double d, double d2) {
        return (double)InvokeDynamicSupport.bootstrapStatic("normalize", $$robo$$android_icu_impl_CalendarAstronomer$normalize(double double ), (double)d, (double)d2);
    }

    private static double norm2PI(double d) {
        return (double)InvokeDynamicSupport.bootstrapStatic("norm2PI", $$robo$$android_icu_impl_CalendarAstronomer$norm2PI(double ), (double)d);
    }

    private static double normPI(double d) {
        return (double)InvokeDynamicSupport.bootstrapStatic("normPI", $$robo$$android_icu_impl_CalendarAstronomer$normPI(double ), (double)d);
    }

    private double trueAnomaly(double d, double d2) {
        return (double)InvokeDynamicSupport.bootstrap("trueAnomaly", $$robo$$android_icu_impl_CalendarAstronomer$trueAnomaly(double double ), this, d, d2);
    }

    private double eclipticObliquity() {
        return (double)InvokeDynamicSupport.bootstrap("eclipticObliquity", $$robo$$android_icu_impl_CalendarAstronomer$eclipticObliquity(), this);
    }

    private void clearCache() {
        InvokeDynamicSupport.bootstrap("clearCache", $$robo$$android_icu_impl_CalendarAstronomer$clearCache(), this);
    }

    public String local(long l) {
        return InvokeDynamicSupport.bootstrap("local", $$robo$$android_icu_impl_CalendarAstronomer$local(long ), this, l);
    }

    private static String radToHms(double d) {
        return InvokeDynamicSupport.bootstrapStatic("radToHms", $$robo$$android_icu_impl_CalendarAstronomer$radToHms(double ), (double)d);
    }

    private static String radToDms(double d) {
        return InvokeDynamicSupport.bootstrapStatic("radToDms", $$robo$$android_icu_impl_CalendarAstronomer$radToDms(double ), (double)d);
    }

    static {
        RobolectricInternals.classInitializing(CalendarAstronomer.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CalendarAstronomer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Horizon
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public double altitude;
        public double azimuth;

        private void $$robo$$android_icu_impl_CalendarAstronomer_Horizon$__constructor__(double alt, double azim) {
            this.altitude = alt;
            this.azimuth = azim;
        }

        private final String $$robo$$android_icu_impl_CalendarAstronomer_Horizon$toString() {
            return Double.toString(this.altitude * 57.29577951308232) + "," + this.azimuth * 57.29577951308232;
        }

        private void __constructor__(double d, double d2) {
            this.$$robo$$android_icu_impl_CalendarAstronomer_Horizon$__constructor__(d, d2);
        }

        public Horizon(double d, double d2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarAstronomer_Horizon$__constructor__(double double ), this, d, d2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_CalendarAstronomer_Horizon$toString(), this);
        }

        public /* synthetic */ Horizon() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Horizon)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Equatorial
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public double ascension;
        public double declination;

        private void $$robo$$android_icu_impl_CalendarAstronomer_Equatorial$__constructor__(double asc, double dec) {
            this.ascension = asc;
            this.declination = dec;
        }

        private final String $$robo$$android_icu_impl_CalendarAstronomer_Equatorial$toString() {
            return Double.toString(this.ascension * 57.29577951308232) + "," + this.declination * 57.29577951308232;
        }

        private final String $$robo$$android_icu_impl_CalendarAstronomer_Equatorial$toHmsString() {
            return CalendarAstronomer.radToHms(this.ascension) + "," + CalendarAstronomer.radToDms(this.declination);
        }

        private void __constructor__(double d, double d2) {
            this.$$robo$$android_icu_impl_CalendarAstronomer_Equatorial$__constructor__(d, d2);
        }

        public Equatorial(double d, double d2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarAstronomer_Equatorial$__constructor__(double double ), this, d, d2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_CalendarAstronomer_Equatorial$toString(), this);
        }

        public String toHmsString() {
            return InvokeDynamicSupport.bootstrap("toHmsString", $$robo$$android_icu_impl_CalendarAstronomer_Equatorial$toHmsString(), this);
        }

        public /* synthetic */ Equatorial() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Equatorial)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Ecliptic
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public double latitude;
        public double longitude;

        private void $$robo$$android_icu_impl_CalendarAstronomer_Ecliptic$__constructor__(double lat, double lon) {
            this.latitude = lat;
            this.longitude = lon;
        }

        private final String $$robo$$android_icu_impl_CalendarAstronomer_Ecliptic$toString() {
            return Double.toString(this.longitude * 57.29577951308232) + "," + this.latitude * 57.29577951308232;
        }

        private void __constructor__(double d, double d2) {
            this.$$robo$$android_icu_impl_CalendarAstronomer_Ecliptic$__constructor__(d, d2);
        }

        public Ecliptic(double d, double d2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarAstronomer_Ecliptic$__constructor__(double double ), this, d, d2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_CalendarAstronomer_Ecliptic$toString(), this);
        }

        public /* synthetic */ Ecliptic() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Ecliptic)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface CoordFunc {
        public Equatorial eval();
    }

    private static interface AngleFunc {
        public double eval();
    }

    private static class MoonAge
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        double value;

        private void $$robo$$android_icu_impl_CalendarAstronomer_MoonAge$__constructor__(double val) {
            this.value = val;
        }

        private void __constructor__(double d) {
            this.$$robo$$android_icu_impl_CalendarAstronomer_MoonAge$__constructor__(d);
        }

        public MoonAge(double d) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarAstronomer_MoonAge$__constructor__(double ), this, d);
        }

        public /* synthetic */ MoonAge() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MoonAge)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SolarLongitude
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        double value;

        private void $$robo$$android_icu_impl_CalendarAstronomer_SolarLongitude$__constructor__(double val) {
            this.value = val;
        }

        private void __constructor__(double d) {
            this.$$robo$$android_icu_impl_CalendarAstronomer_SolarLongitude$__constructor__(d);
        }

        public SolarLongitude(double d) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarAstronomer_SolarLongitude$__constructor__(double ), this, d);
        }

        public /* synthetic */ SolarLongitude() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SolarLongitude)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

