/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbPort;
import android.hardware.usb.UsbPortStatus;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UsbManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "UsbManager";
    public static String ACTION_USB_STATE = "android.hardware.usb.action.USB_STATE";
    public static String ACTION_USB_PORT_CHANGED = "android.hardware.usb.action.USB_PORT_CHANGED";
    public static String ACTION_USB_DEVICE_ATTACHED = "android.hardware.usb.action.USB_DEVICE_ATTACHED";
    public static String ACTION_USB_DEVICE_DETACHED = "android.hardware.usb.action.USB_DEVICE_DETACHED";
    public static String ACTION_USB_ACCESSORY_ATTACHED = "android.hardware.usb.action.USB_ACCESSORY_ATTACHED";
    public static String ACTION_USB_ACCESSORY_DETACHED = "android.hardware.usb.action.USB_ACCESSORY_DETACHED";
    public static String USB_CONNECTED = "connected";
    public static String USB_HOST_CONNECTED = "host_connected";
    public static String USB_CONFIGURED = "configured";
    public static String USB_DATA_UNLOCKED = "unlocked";
    public static String USB_FUNCTION_NONE = "none";
    public static String USB_FUNCTION_ADB = "adb";
    public static String USB_FUNCTION_RNDIS = "rndis";
    public static String USB_FUNCTION_MTP = "mtp";
    public static String USB_FUNCTION_PTP = "ptp";
    public static String USB_FUNCTION_AUDIO_SOURCE = "audio_source";
    public static String USB_FUNCTION_MIDI = "midi";
    public static String USB_FUNCTION_ACCESSORY = "accessory";
    public static String EXTRA_PORT = "port";
    public static String EXTRA_PORT_STATUS = "portStatus";
    public static String EXTRA_DEVICE = "device";
    public static String EXTRA_ACCESSORY = "accessory";
    public static String EXTRA_PERMISSION_GRANTED = "permission";
    public static long FUNCTION_NONE = 0L;
    public static long FUNCTION_MTP = 4L;
    public static long FUNCTION_PTP = 16L;
    public static long FUNCTION_RNDIS = 32L;
    public static long FUNCTION_MIDI = 8L;
    public static long FUNCTION_ACCESSORY = 2L;
    public static long FUNCTION_AUDIO_SOURCE = 64L;
    public static long FUNCTION_ADB = 1L;
    private static long SETTABLE_FUNCTIONS = 60L;
    private static Map<String, Long> FUNCTION_NAME_TO_CODE;
    private Context mContext;
    private IUsbManager mService;

    private void $$robo$$android_hardware_usb_UsbManager$__constructor__(Context context, IUsbManager service) {
        this.mContext = context;
        this.mService = service;
    }

    private final HashMap<String, UsbDevice> $$robo$$android_hardware_usb_UsbManager$getDeviceList() {
        HashMap<String, UsbDevice> result = new HashMap<String, UsbDevice>();
        if (this.mService == null) {
            return result;
        }
        Bundle bundle = new Bundle();
        try {
            this.mService.getDeviceList(bundle);
            for (String name : bundle.keySet()) {
                result.put(name, (UsbDevice)bundle.get(name));
            }
            return result;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final UsbDeviceConnection $$robo$$android_hardware_usb_UsbManager$openDevice(UsbDevice device) {
        try {
            String deviceName = device.getDeviceName();
            ParcelFileDescriptor pfd = this.mService.openDevice(deviceName, this.mContext.getPackageName());
            if (pfd != null) {
                UsbDeviceConnection connection = new UsbDeviceConnection(device);
                boolean result = connection.open(deviceName, pfd, this.mContext);
                pfd.close();
                if (result) {
                    return connection;
                }
            }
        }
        catch (Exception e) {
            Log.e("UsbManager", "exception in UsbManager.openDevice", e);
        }
        return null;
    }

    private final UsbAccessory[] $$robo$$android_hardware_usb_UsbManager$getAccessoryList() {
        if (this.mService == null) {
            return null;
        }
        try {
            UsbAccessory accessory = this.mService.getCurrentAccessory();
            if (accessory == null) {
                return null;
            }
            return new UsbAccessory[]{accessory};
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ParcelFileDescriptor $$robo$$android_hardware_usb_UsbManager$openAccessory(UsbAccessory accessory) {
        try {
            return this.mService.openAccessory(accessory);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ParcelFileDescriptor $$robo$$android_hardware_usb_UsbManager$getControlFd(long function) {
        try {
            return this.mService.getControlFd(function);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_hardware_usb_UsbManager$hasPermission(UsbDevice device) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.hasDevicePermission(device, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_hardware_usb_UsbManager$hasPermission(UsbAccessory accessory) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.hasAccessoryPermission(accessory);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$requestPermission(UsbDevice device, PendingIntent pi) {
        try {
            this.mService.requestDevicePermission(device, this.mContext.getPackageName(), pi);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$requestPermission(UsbAccessory accessory, PendingIntent pi) {
        try {
            this.mService.requestAccessoryPermission(accessory, this.mContext.getPackageName(), pi);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$grantPermission(UsbDevice device) {
        this.grantPermission(device, Process.myUid());
    }

    private final void $$robo$$android_hardware_usb_UsbManager$grantPermission(UsbDevice device, int uid) {
        try {
            this.mService.grantDevicePermission(device, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_hardware_usb_UsbManager$grantPermission(UsbDevice device, String packageName) {
        try {
            int uid = this.mContext.getPackageManager().getPackageUidAsUser(packageName, this.mContext.getUserId());
            this.grantPermission(device, uid);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("UsbManager", "Package " + packageName + " not found.", e);
        }
    }

    @Deprecated
    private final boolean $$robo$$android_hardware_usb_UsbManager$isFunctionEnabled(String function) {
        try {
            return this.mService.isFunctionEnabled(function);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$setCurrentFunctions(long functions) {
        try {
            this.mService.setCurrentFunctions(functions);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_hardware_usb_UsbManager$setCurrentFunction(String functions, boolean usbDataUnlocked) {
        try {
            this.mService.setCurrentFunction(functions, usbDataUnlocked);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final long $$robo$$android_hardware_usb_UsbManager$getCurrentFunctions() {
        try {
            return this.mService.getCurrentFunctions();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$setScreenUnlockedFunctions(long functions) {
        try {
            this.mService.setScreenUnlockedFunctions(functions);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final long $$robo$$android_hardware_usb_UsbManager$getScreenUnlockedFunctions() {
        try {
            return this.mService.getScreenUnlockedFunctions();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final UsbPort[] $$robo$$android_hardware_usb_UsbManager$getPorts() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getPorts();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final UsbPortStatus $$robo$$android_hardware_usb_UsbManager$getPortStatus(UsbPort port) {
        Preconditions.checkNotNull(port, "port must not be null");
        try {
            return this.mService.getPortStatus(port.getId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$setPortRoles(UsbPort port, int powerRole, int dataRole) {
        Preconditions.checkNotNull(port, "port must not be null");
        UsbPort.checkRoles(powerRole, dataRole);
        Log.d("UsbManager", "setPortRoles Package:" + this.mContext.getPackageName());
        try {
            this.mService.setPortRoles(port.getId(), powerRole, dataRole);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$setUsbDeviceConnectionHandler(ComponentName usbDeviceConnectionHandler) {
        try {
            this.mService.setUsbDeviceConnectionHandler(usbDeviceConnectionHandler);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final boolean $$robo$$android_hardware_usb_UsbManager$areSettableFunctions(long functions) {
        return functions == 0L || (0xFFFFFFFFFFFFFFC3L & functions) == 0L && Long.bitCount(functions) == 1;
    }

    private static final String $$robo$$android_hardware_usb_UsbManager$usbFunctionsToString(long functions) {
        StringJoiner joiner = new StringJoiner(",");
        if ((functions & 4L) != 0L) {
            joiner.add("mtp");
        }
        if ((functions & 0x10L) != 0L) {
            joiner.add("ptp");
        }
        if ((functions & 0x20L) != 0L) {
            joiner.add("rndis");
        }
        if ((functions & 8L) != 0L) {
            joiner.add("midi");
        }
        if ((functions & 2L) != 0L) {
            joiner.add("accessory");
        }
        if ((functions & 0x40L) != 0L) {
            joiner.add("audio_source");
        }
        if ((functions & 1L) != 0L) {
            joiner.add("adb");
        }
        return joiner.toString();
    }

    private static final long $$robo$$android_hardware_usb_UsbManager$usbFunctionsFromString(String functions) {
        if (functions == null || functions.equals("none")) {
            return 0L;
        }
        long ret = 0L;
        for (String function : functions.split(",")) {
            if (FUNCTION_NAME_TO_CODE.containsKey(function)) {
                ret |= FUNCTION_NAME_TO_CODE.get(function).longValue();
                continue;
            }
            if (function.length() <= 0) continue;
            throw new IllegalArgumentException("Invalid usb function " + functions);
        }
        return ret;
    }

    static void __staticInitializer__() {
        FUNCTION_NAME_TO_CODE = new HashMap<String, Long>();
        FUNCTION_NAME_TO_CODE.put("mtp", 4L);
        FUNCTION_NAME_TO_CODE.put("ptp", 16L);
        FUNCTION_NAME_TO_CODE.put("rndis", 32L);
        FUNCTION_NAME_TO_CODE.put("midi", 8L);
        FUNCTION_NAME_TO_CODE.put("accessory", 2L);
        FUNCTION_NAME_TO_CODE.put("audio_source", 64L);
        FUNCTION_NAME_TO_CODE.put("adb", 1L);
    }

    private void __constructor__(Context context, IUsbManager iUsbManager) {
        this.$$robo$$android_hardware_usb_UsbManager$__constructor__(context, iUsbManager);
    }

    public UsbManager(Context context, IUsbManager iUsbManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_usb_UsbManager$__constructor__(android.content.Context android.hardware.usb.IUsbManager ), this, context, iUsbManager);
    }

    public HashMap<String, UsbDevice> getDeviceList() {
        return InvokeDynamicSupport.bootstrap("getDeviceList", $$robo$$android_hardware_usb_UsbManager$getDeviceList(), this);
    }

    public UsbDeviceConnection openDevice(UsbDevice usbDevice) {
        return InvokeDynamicSupport.bootstrap("openDevice", $$robo$$android_hardware_usb_UsbManager$openDevice(android.hardware.usb.UsbDevice ), this, usbDevice);
    }

    public UsbAccessory[] getAccessoryList() {
        return InvokeDynamicSupport.bootstrap("getAccessoryList", $$robo$$android_hardware_usb_UsbManager$getAccessoryList(), this);
    }

    public ParcelFileDescriptor openAccessory(UsbAccessory usbAccessory) {
        return InvokeDynamicSupport.bootstrap("openAccessory", $$robo$$android_hardware_usb_UsbManager$openAccessory(android.hardware.usb.UsbAccessory ), this, usbAccessory);
    }

    public ParcelFileDescriptor getControlFd(long l) {
        return InvokeDynamicSupport.bootstrap("getControlFd", $$robo$$android_hardware_usb_UsbManager$getControlFd(long ), this, l);
    }

    public boolean hasPermission(UsbDevice usbDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPermission", $$robo$$android_hardware_usb_UsbManager$hasPermission(android.hardware.usb.UsbDevice ), this, usbDevice);
    }

    public boolean hasPermission(UsbAccessory usbAccessory) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPermission", $$robo$$android_hardware_usb_UsbManager$hasPermission(android.hardware.usb.UsbAccessory ), this, usbAccessory);
    }

    public void requestPermission(UsbDevice usbDevice, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestPermission", $$robo$$android_hardware_usb_UsbManager$requestPermission(android.hardware.usb.UsbDevice android.app.PendingIntent ), this, usbDevice, pendingIntent);
    }

    public void requestPermission(UsbAccessory usbAccessory, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestPermission", $$robo$$android_hardware_usb_UsbManager$requestPermission(android.hardware.usb.UsbAccessory android.app.PendingIntent ), this, usbAccessory, pendingIntent);
    }

    public void grantPermission(UsbDevice usbDevice) {
        InvokeDynamicSupport.bootstrap("grantPermission", $$robo$$android_hardware_usb_UsbManager$grantPermission(android.hardware.usb.UsbDevice ), this, usbDevice);
    }

    public void grantPermission(UsbDevice usbDevice, int n) {
        InvokeDynamicSupport.bootstrap("grantPermission", $$robo$$android_hardware_usb_UsbManager$grantPermission(android.hardware.usb.UsbDevice int ), this, usbDevice, n);
    }

    @SystemApi
    public void grantPermission(UsbDevice usbDevice, String string2) {
        InvokeDynamicSupport.bootstrap("grantPermission", $$robo$$android_hardware_usb_UsbManager$grantPermission(android.hardware.usb.UsbDevice java.lang.String ), this, usbDevice, string2);
    }

    @Deprecated
    public boolean isFunctionEnabled(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFunctionEnabled", $$robo$$android_hardware_usb_UsbManager$isFunctionEnabled(java.lang.String ), this, string2);
    }

    public void setCurrentFunctions(long l) {
        InvokeDynamicSupport.bootstrap("setCurrentFunctions", $$robo$$android_hardware_usb_UsbManager$setCurrentFunctions(long ), this, l);
    }

    @Deprecated
    public void setCurrentFunction(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCurrentFunction", $$robo$$android_hardware_usb_UsbManager$setCurrentFunction(java.lang.String boolean ), this, string2, bl);
    }

    public long getCurrentFunctions() {
        return (long)InvokeDynamicSupport.bootstrap("getCurrentFunctions", $$robo$$android_hardware_usb_UsbManager$getCurrentFunctions(), this);
    }

    public void setScreenUnlockedFunctions(long l) {
        InvokeDynamicSupport.bootstrap("setScreenUnlockedFunctions", $$robo$$android_hardware_usb_UsbManager$setScreenUnlockedFunctions(long ), this, l);
    }

    public long getScreenUnlockedFunctions() {
        return (long)InvokeDynamicSupport.bootstrap("getScreenUnlockedFunctions", $$robo$$android_hardware_usb_UsbManager$getScreenUnlockedFunctions(), this);
    }

    public UsbPort[] getPorts() {
        return InvokeDynamicSupport.bootstrap("getPorts", $$robo$$android_hardware_usb_UsbManager$getPorts(), this);
    }

    public UsbPortStatus getPortStatus(UsbPort usbPort) {
        return InvokeDynamicSupport.bootstrap("getPortStatus", $$robo$$android_hardware_usb_UsbManager$getPortStatus(android.hardware.usb.UsbPort ), this, usbPort);
    }

    public void setPortRoles(UsbPort usbPort, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setPortRoles", $$robo$$android_hardware_usb_UsbManager$setPortRoles(android.hardware.usb.UsbPort int int ), this, usbPort, n, n2);
    }

    public void setUsbDeviceConnectionHandler(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("setUsbDeviceConnectionHandler", $$robo$$android_hardware_usb_UsbManager$setUsbDeviceConnectionHandler(android.content.ComponentName ), this, componentName);
    }

    public static boolean areSettableFunctions(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("areSettableFunctions", $$robo$$android_hardware_usb_UsbManager$areSettableFunctions(long ), (long)l);
    }

    public static String usbFunctionsToString(long l) {
        return InvokeDynamicSupport.bootstrapStatic("usbFunctionsToString", $$robo$$android_hardware_usb_UsbManager$usbFunctionsToString(long ), (long)l);
    }

    public static long usbFunctionsFromString(String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("usbFunctionsFromString", $$robo$$android_hardware_usb_UsbManager$usbFunctionsFromString(java.lang.String ), (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(UsbManager.class);
    }

    public /* synthetic */ UsbManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsbManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

