/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.hardware.radio.ITunerCallback;
import android.hardware.radio.ProgramList;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.RadioMetadata;
import android.hardware.radio.RadioTuner;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TunerCallbackAdapter
extends ITunerCallback.Stub
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BroadcastRadio.TunerCallbackAdapter";
    private Object mLock;
    private RadioTuner.Callback mCallback;
    private Handler mHandler;
    ProgramList mProgramList;
    boolean mIsAntennaConnected;
    List<RadioManager.ProgramInfo> mLastCompleteList;
    private boolean mDelayedCompleteCallback;
    RadioManager.ProgramInfo mCurrentProgramInfo;

    private void $$robo$$android_hardware_radio_TunerCallbackAdapter$__constructor__(RadioTuner.Callback callback, Handler handler) {
        this.mLock = new Object();
        this.mIsAntennaConnected = true;
        this.mDelayedCompleteCallback = false;
        this.mCallback = callback;
        this.mHandler = handler == null ? new Handler(Looper.getMainLooper()) : handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProgramList != null) {
                this.mProgramList.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$setProgramListObserver(ProgramList programList, ProgramList.OnCloseListener closeListener) {
        Objects.requireNonNull(closeListener);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProgramList != null) {
                Log.w("BroadcastRadio.TunerCallbackAdapter", "Previous program list observer wasn't properly closed, closing it...");
                this.mProgramList.close();
            }
            this.mProgramList = programList;
            if (programList == null) {
                return;
            }
            programList.setOnCloseListener(() -> {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mProgramList != programList) {
                        return;
                    }
                    this.mProgramList = null;
                    this.mLastCompleteList = null;
                    closeListener.onClose();
                }
            });
            programList.addOnCompleteListener(() -> {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mProgramList != programList) {
                        return;
                    }
                    this.mLastCompleteList = programList.toList();
                    if (this.mDelayedCompleteCallback) {
                        Log.d("BroadcastRadio.TunerCallbackAdapter", "Sending delayed onBackgroundScanComplete callback");
                        this.sendBackgroundScanCompleteLocked();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<RadioManager.ProgramInfo> $$robo$$android_hardware_radio_TunerCallbackAdapter$getLastCompleteList() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mLastCompleteList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$clearLastCompleteList() {
        Object object = this.mLock;
        synchronized (object) {
            this.mLastCompleteList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RadioManager.ProgramInfo $$robo$$android_hardware_radio_TunerCallbackAdapter$getCurrentProgramInformation() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentProgramInfo;
        }
    }

    private final boolean $$robo$$android_hardware_radio_TunerCallbackAdapter$isAntennaConnected() {
        return this.mIsAntennaConnected;
    }

    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$onError(int status) {
        this.mHandler.post(() -> this.mCallback.onError(status));
    }

    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$onTuneFailed(int status, ProgramSelector selector) {
        int errorCode;
        this.mHandler.post(() -> this.mCallback.onTuneFailed(status, selector));
        switch (status) {
            case -32: 
            case -1: {
                errorCode = 1;
                break;
            }
            case -2147483648: 
            case -38: 
            case -22: 
            case -19: {
                Log.i("BroadcastRadio.TunerCallbackAdapter", "Got an error with no mapping to the legacy API (" + status + "), doing a best-effort conversion to ERROR_SCAN_TIMEOUT");
            }
            default: {
                errorCode = 3;
            }
        }
        this.mHandler.post(() -> this.mCallback.onError(errorCode));
    }

    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$onConfigurationChanged(RadioManager.BandConfig config) {
        this.mHandler.post(() -> this.mCallback.onConfigurationChanged(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$onCurrentProgramInfoChanged(RadioManager.ProgramInfo info) {
        if (info == null) {
            Log.e("BroadcastRadio.TunerCallbackAdapter", "ProgramInfo must not be null");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentProgramInfo = info;
        }
        this.mHandler.post(() -> {
            this.mCallback.onProgramInfoChanged(info);
            RadioMetadata metadata = info.getMetadata();
            if (metadata != null) {
                this.mCallback.onMetadataChanged(metadata);
            }
        });
    }

    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$onTrafficAnnouncement(boolean active) {
        this.mHandler.post(() -> this.mCallback.onTrafficAnnouncement(active));
    }

    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$onEmergencyAnnouncement(boolean active) {
        this.mHandler.post(() -> this.mCallback.onEmergencyAnnouncement(active));
    }

    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$onAntennaState(boolean connected) {
        this.mIsAntennaConnected = connected;
        this.mHandler.post(() -> this.mCallback.onAntennaState(connected));
    }

    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$onBackgroundScanAvailabilityChange(boolean isAvailable) {
        this.mHandler.post(() -> this.mCallback.onBackgroundScanAvailabilityChange(isAvailable));
    }

    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$sendBackgroundScanCompleteLocked() {
        this.mDelayedCompleteCallback = false;
        this.mHandler.post(() -> this.mCallback.onBackgroundScanComplete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$onBackgroundScanComplete() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLastCompleteList == null) {
                Log.i("BroadcastRadio.TunerCallbackAdapter", "Got onBackgroundScanComplete callback, but the program list didn't get through yet. Delaying it...");
                this.mDelayedCompleteCallback = true;
                return;
            }
            this.sendBackgroundScanCompleteLocked();
        }
    }

    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$onProgramListChanged() {
        this.mHandler.post(() -> this.mCallback.onProgramListChanged());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$onProgramListUpdated(ProgramList.Chunk chunk) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProgramList == null) {
                return;
            }
            this.mProgramList.apply(Objects.requireNonNull(chunk));
        }
    }

    private final void $$robo$$android_hardware_radio_TunerCallbackAdapter$onParametersUpdated(Map parameters) {
        this.mHandler.post(() -> this.mCallback.onParametersUpdated(parameters));
    }

    private void __constructor__(RadioTuner.Callback callback, Handler handler) {
        this.$$robo$$android_hardware_radio_TunerCallbackAdapter$__constructor__(callback, handler);
    }

    public TunerCallbackAdapter(RadioTuner.Callback callback, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_TunerCallbackAdapter$__constructor__(android.hardware.radio.RadioTuner$Callback android.os.Handler ), this, callback, handler);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_radio_TunerCallbackAdapter$close(), this);
    }

    void setProgramListObserver(ProgramList programList, ProgramList.OnCloseListener onCloseListener) {
        InvokeDynamicSupport.bootstrap("setProgramListObserver", $$robo$$android_hardware_radio_TunerCallbackAdapter$setProgramListObserver(android.hardware.radio.ProgramList android.hardware.radio.ProgramList$OnCloseListener ), this, programList, onCloseListener);
    }

    List<RadioManager.ProgramInfo> getLastCompleteList() {
        return InvokeDynamicSupport.bootstrap("getLastCompleteList", $$robo$$android_hardware_radio_TunerCallbackAdapter$getLastCompleteList(), this);
    }

    void clearLastCompleteList() {
        InvokeDynamicSupport.bootstrap("clearLastCompleteList", $$robo$$android_hardware_radio_TunerCallbackAdapter$clearLastCompleteList(), this);
    }

    RadioManager.ProgramInfo getCurrentProgramInformation() {
        return InvokeDynamicSupport.bootstrap("getCurrentProgramInformation", $$robo$$android_hardware_radio_TunerCallbackAdapter$getCurrentProgramInformation(), this);
    }

    boolean isAntennaConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAntennaConnected", $$robo$$android_hardware_radio_TunerCallbackAdapter$isAntennaConnected(), this);
    }

    @Override
    public void onError(int n) {
        InvokeDynamicSupport.bootstrap("onError", $$robo$$android_hardware_radio_TunerCallbackAdapter$onError(int ), this, n);
    }

    @Override
    public void onTuneFailed(int n, ProgramSelector programSelector) {
        InvokeDynamicSupport.bootstrap("onTuneFailed", $$robo$$android_hardware_radio_TunerCallbackAdapter$onTuneFailed(int android.hardware.radio.ProgramSelector ), this, n, programSelector);
    }

    @Override
    public void onConfigurationChanged(RadioManager.BandConfig bandConfig) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_hardware_radio_TunerCallbackAdapter$onConfigurationChanged(android.hardware.radio.RadioManager$BandConfig ), this, bandConfig);
    }

    @Override
    public void onCurrentProgramInfoChanged(RadioManager.ProgramInfo programInfo) {
        InvokeDynamicSupport.bootstrap("onCurrentProgramInfoChanged", $$robo$$android_hardware_radio_TunerCallbackAdapter$onCurrentProgramInfoChanged(android.hardware.radio.RadioManager$ProgramInfo ), this, programInfo);
    }

    @Override
    public void onTrafficAnnouncement(boolean bl) {
        InvokeDynamicSupport.bootstrap("onTrafficAnnouncement", $$robo$$android_hardware_radio_TunerCallbackAdapter$onTrafficAnnouncement(boolean ), this, bl);
    }

    @Override
    public void onEmergencyAnnouncement(boolean bl) {
        InvokeDynamicSupport.bootstrap("onEmergencyAnnouncement", $$robo$$android_hardware_radio_TunerCallbackAdapter$onEmergencyAnnouncement(boolean ), this, bl);
    }

    @Override
    public void onAntennaState(boolean bl) {
        InvokeDynamicSupport.bootstrap("onAntennaState", $$robo$$android_hardware_radio_TunerCallbackAdapter$onAntennaState(boolean ), this, bl);
    }

    @Override
    public void onBackgroundScanAvailabilityChange(boolean bl) {
        InvokeDynamicSupport.bootstrap("onBackgroundScanAvailabilityChange", $$robo$$android_hardware_radio_TunerCallbackAdapter$onBackgroundScanAvailabilityChange(boolean ), this, bl);
    }

    private void sendBackgroundScanCompleteLocked() {
        InvokeDynamicSupport.bootstrap("sendBackgroundScanCompleteLocked", $$robo$$android_hardware_radio_TunerCallbackAdapter$sendBackgroundScanCompleteLocked(), this);
    }

    @Override
    public void onBackgroundScanComplete() {
        InvokeDynamicSupport.bootstrap("onBackgroundScanComplete", $$robo$$android_hardware_radio_TunerCallbackAdapter$onBackgroundScanComplete(), this);
    }

    @Override
    public void onProgramListChanged() {
        InvokeDynamicSupport.bootstrap("onProgramListChanged", $$robo$$android_hardware_radio_TunerCallbackAdapter$onProgramListChanged(), this);
    }

    @Override
    public void onProgramListUpdated(ProgramList.Chunk chunk) {
        InvokeDynamicSupport.bootstrap("onProgramListUpdated", $$robo$$android_hardware_radio_TunerCallbackAdapter$onProgramListUpdated(android.hardware.radio.ProgramList$Chunk ), this, chunk);
    }

    @Override
    public void onParametersUpdated(Map map) {
        InvokeDynamicSupport.bootstrap("onParametersUpdated", $$robo$$android_hardware_radio_TunerCallbackAdapter$onParametersUpdated(java.util.Map ), this, map);
    }

    public /* synthetic */ TunerCallbackAdapter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TunerCallbackAdapter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

