/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.graphics.Bitmap;
import android.hardware.radio.ITuner;
import android.hardware.radio.ProgramList;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.RadioTuner;
import android.hardware.radio.TunerCallbackAdapter;
import android.os.RemoteException;
import android.util.Log;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TunerAdapter
extends RadioTuner
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BroadcastRadio.TunerAdapter";
    private ITuner mTuner;
    private TunerCallbackAdapter mCallback;
    private boolean mIsClosed;
    private int mBand;
    private ProgramList mLegacyListProxy;
    private Map<String, String> mLegacyListFilter;

    private void $$robo$$android_hardware_radio_TunerAdapter$__constructor__(ITuner tuner, TunerCallbackAdapter callback, int band) {
        this.mIsClosed = false;
        this.mTuner = Objects.requireNonNull(tuner);
        this.mCallback = Objects.requireNonNull(callback);
        this.mBand = band;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_TunerAdapter$close() {
        ITuner iTuner = this.mTuner;
        synchronized (iTuner) {
            if (this.mIsClosed) {
                Log.v("BroadcastRadio.TunerAdapter", "Tuner is already closed");
                return;
            }
            this.mIsClosed = true;
            if (this.mLegacyListProxy != null) {
                this.mLegacyListProxy.close();
                this.mLegacyListProxy = null;
            }
            this.mCallback.close();
        }
        try {
            this.mTuner.close();
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Exception trying to close tuner", e);
        }
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$setConfiguration(RadioManager.BandConfig config) {
        if (config == null) {
            return -22;
        }
        try {
            this.mTuner.setConfiguration(config);
            this.mBand = config.getType();
            return 0;
        }
        catch (IllegalArgumentException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't set configuration", e);
            return -22;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$getConfiguration(RadioManager.BandConfig[] config) {
        if (config == null || config.length != 1) {
            throw new IllegalArgumentException("The argument must be an array of length 1");
        }
        try {
            config[0] = this.mTuner.getConfiguration();
            return 0;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$setMute(boolean mute) {
        try {
            this.mTuner.setMuted(mute);
        }
        catch (IllegalStateException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't set muted", e);
            return Integer.MIN_VALUE;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
        return 0;
    }

    private final boolean $$robo$$android_hardware_radio_TunerAdapter$getMute() {
        try {
            return this.mTuner.isMuted();
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return true;
        }
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$step(int direction, boolean skipSubChannel) {
        try {
            this.mTuner.step(direction == 1, skipSubChannel);
        }
        catch (IllegalStateException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't step", e);
            return -38;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
        return 0;
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$scan(int direction, boolean skipSubChannel) {
        try {
            this.mTuner.scan(direction == 1, skipSubChannel);
        }
        catch (IllegalStateException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't scan", e);
            return -38;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
        return 0;
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$tune(int channel, int subChannel) {
        try {
            this.mTuner.tune(ProgramSelector.createAmFmSelector(this.mBand, channel, subChannel));
        }
        catch (IllegalStateException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't tune", e);
            return -38;
        }
        catch (IllegalArgumentException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't tune", e);
            return -22;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
        return 0;
    }

    private final void $$robo$$android_hardware_radio_TunerAdapter$tune(ProgramSelector selector) {
        try {
            this.mTuner.tune(selector);
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$cancel() {
        try {
            this.mTuner.cancel();
        }
        catch (IllegalStateException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't cancel", e);
            return -38;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
        return 0;
    }

    private final void $$robo$$android_hardware_radio_TunerAdapter$cancelAnnouncement() {
        try {
            this.mTuner.cancelAnnouncement();
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$getProgramInformation(RadioManager.ProgramInfo[] info) {
        if (info == null || info.length != 1) {
            Log.e("BroadcastRadio.TunerAdapter", "The argument must be an array of length 1");
            return -22;
        }
        RadioManager.ProgramInfo current = this.mCallback.getCurrentProgramInformation();
        if (current == null) {
            Log.w("BroadcastRadio.TunerAdapter", "Didn't get program info yet");
            return -38;
        }
        info[0] = current;
        return 0;
    }

    private final Bitmap $$robo$$android_hardware_radio_TunerAdapter$getMetadataImage(int id2) {
        try {
            return this.mTuner.getImage(id2);
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final boolean $$robo$$android_hardware_radio_TunerAdapter$startBackgroundScan() {
        try {
            return this.mTuner.startBackgroundScan();
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<RadioManager.ProgramInfo> $$robo$$android_hardware_radio_TunerAdapter$getProgramList(Map<String, String> vendorFilter) {
        ITuner iTuner = this.mTuner;
        synchronized (iTuner) {
            List<RadioManager.ProgramInfo> list;
            if (this.mLegacyListProxy == null || !Objects.equals(this.mLegacyListFilter, vendorFilter)) {
                Log.i("BroadcastRadio.TunerAdapter", "Program list filter has changed, requesting new list");
                this.mLegacyListProxy = new ProgramList();
                this.mLegacyListFilter = vendorFilter;
                this.mCallback.clearLastCompleteList();
                this.mCallback.setProgramListObserver(this.mLegacyListProxy, () -> {});
                try {
                    this.mTuner.startProgramListUpdates(new ProgramList.Filter(vendorFilter));
                }
                catch (RemoteException ex) {
                    throw new RuntimeException("service died", ex);
                }
            }
            if ((list = this.mCallback.getLastCompleteList()) == null) {
                throw new IllegalStateException("Program list is not ready yet");
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProgramList $$robo$$android_hardware_radio_TunerAdapter$getDynamicProgramList(ProgramList.Filter filter) {
        ITuner iTuner = this.mTuner;
        synchronized (iTuner) {
            if (this.mLegacyListProxy != null) {
                this.mLegacyListProxy.close();
                this.mLegacyListProxy = null;
            }
            this.mLegacyListFilter = null;
            ProgramList list = new ProgramList();
            this.mCallback.setProgramListObserver(list, () -> {
                try {
                    this.mTuner.stopProgramListUpdates();
                }
                catch (RemoteException ex) {
                    Log.e("BroadcastRadio.TunerAdapter", "Couldn't stop program list updates", ex);
                }
            });
            try {
                this.mTuner.startProgramListUpdates(filter);
            }
            catch (UnsupportedOperationException ex) {
                Log.i("BroadcastRadio.TunerAdapter", "Program list is not supported with this hardware");
                return null;
            }
            catch (RemoteException ex) {
                this.mCallback.setProgramListObserver(null, () -> {});
                throw new RuntimeException("service died", ex);
            }
            return list;
        }
    }

    private final boolean $$robo$$android_hardware_radio_TunerAdapter$isAnalogForced() {
        try {
            return this.isConfigFlagSet(2);
        }
        catch (UnsupportedOperationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private final void $$robo$$android_hardware_radio_TunerAdapter$setAnalogForced(boolean isForced) {
        try {
            this.setConfigFlag(2, isForced);
        }
        catch (UnsupportedOperationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private final boolean $$robo$$android_hardware_radio_TunerAdapter$isConfigFlagSupported(int flag) {
        try {
            return this.mTuner.isConfigFlagSupported(flag);
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final boolean $$robo$$android_hardware_radio_TunerAdapter$isConfigFlagSet(int flag) {
        try {
            return this.mTuner.isConfigFlagSet(flag);
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final void $$robo$$android_hardware_radio_TunerAdapter$setConfigFlag(int flag, boolean value) {
        try {
            this.mTuner.setConfigFlag(flag, value);
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final Map<String, String> $$robo$$android_hardware_radio_TunerAdapter$setParameters(Map<String, String> parameters) {
        try {
            return this.mTuner.setParameters(Objects.requireNonNull(parameters));
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final Map<String, String> $$robo$$android_hardware_radio_TunerAdapter$getParameters(List<String> keys) {
        try {
            return this.mTuner.getParameters(Objects.requireNonNull(keys));
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final boolean $$robo$$android_hardware_radio_TunerAdapter$isAntennaConnected() {
        return this.mCallback.isAntennaConnected();
    }

    private final boolean $$robo$$android_hardware_radio_TunerAdapter$hasControl() {
        try {
            return !this.mTuner.isClosed();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private void __constructor__(ITuner iTuner, TunerCallbackAdapter tunerCallbackAdapter, int n) {
        this.$$robo$$android_hardware_radio_TunerAdapter$__constructor__(iTuner, tunerCallbackAdapter, n);
    }

    public TunerAdapter(ITuner iTuner, TunerCallbackAdapter tunerCallbackAdapter, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_TunerAdapter$__constructor__(android.hardware.radio.ITuner android.hardware.radio.TunerCallbackAdapter int ), this, iTuner, tunerCallbackAdapter, n);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_radio_TunerAdapter$close(), this);
    }

    @Override
    public int setConfiguration(RadioManager.BandConfig bandConfig) {
        return (int)InvokeDynamicSupport.bootstrap("setConfiguration", $$robo$$android_hardware_radio_TunerAdapter$setConfiguration(android.hardware.radio.RadioManager$BandConfig ), this, bandConfig);
    }

    @Override
    public int getConfiguration(RadioManager.BandConfig[] bandConfigArray) {
        return (int)InvokeDynamicSupport.bootstrap("getConfiguration", $$robo$$android_hardware_radio_TunerAdapter$getConfiguration(android.hardware.radio.RadioManager$BandConfig[] ), this, bandConfigArray);
    }

    @Override
    public int setMute(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("setMute", $$robo$$android_hardware_radio_TunerAdapter$setMute(boolean ), this, bl);
    }

    @Override
    public boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$android_hardware_radio_TunerAdapter$getMute(), this);
    }

    @Override
    public int step(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("step", $$robo$$android_hardware_radio_TunerAdapter$step(int boolean ), this, n, bl);
    }

    @Override
    public int scan(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("scan", $$robo$$android_hardware_radio_TunerAdapter$scan(int boolean ), this, n, bl);
    }

    @Override
    public int tune(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("tune", $$robo$$android_hardware_radio_TunerAdapter$tune(int int ), this, n, n2);
    }

    @Override
    public void tune(ProgramSelector programSelector) {
        InvokeDynamicSupport.bootstrap("tune", $$robo$$android_hardware_radio_TunerAdapter$tune(android.hardware.radio.ProgramSelector ), this, programSelector);
    }

    @Override
    public int cancel() {
        return (int)InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_hardware_radio_TunerAdapter$cancel(), this);
    }

    @Override
    public void cancelAnnouncement() {
        InvokeDynamicSupport.bootstrap("cancelAnnouncement", $$robo$$android_hardware_radio_TunerAdapter$cancelAnnouncement(), this);
    }

    @Override
    public int getProgramInformation(RadioManager.ProgramInfo[] programInfoArray) {
        return (int)InvokeDynamicSupport.bootstrap("getProgramInformation", $$robo$$android_hardware_radio_TunerAdapter$getProgramInformation(android.hardware.radio.RadioManager$ProgramInfo[] ), this, programInfoArray);
    }

    @Override
    public Bitmap getMetadataImage(int n) {
        return InvokeDynamicSupport.bootstrap("getMetadataImage", $$robo$$android_hardware_radio_TunerAdapter$getMetadataImage(int ), this, n);
    }

    @Override
    public boolean startBackgroundScan() {
        return (boolean)InvokeDynamicSupport.bootstrap("startBackgroundScan", $$robo$$android_hardware_radio_TunerAdapter$startBackgroundScan(), this);
    }

    @Override
    public List<RadioManager.ProgramInfo> getProgramList(Map<String, String> map) {
        return InvokeDynamicSupport.bootstrap("getProgramList", $$robo$$android_hardware_radio_TunerAdapter$getProgramList(java.util.Map<java.lang.String, java.lang.String> ), this, map);
    }

    @Override
    public ProgramList getDynamicProgramList(ProgramList.Filter filter) {
        return InvokeDynamicSupport.bootstrap("getDynamicProgramList", $$robo$$android_hardware_radio_TunerAdapter$getDynamicProgramList(android.hardware.radio.ProgramList$Filter ), this, filter);
    }

    @Override
    public boolean isAnalogForced() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAnalogForced", $$robo$$android_hardware_radio_TunerAdapter$isAnalogForced(), this);
    }

    @Override
    public void setAnalogForced(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAnalogForced", $$robo$$android_hardware_radio_TunerAdapter$setAnalogForced(boolean ), this, bl);
    }

    @Override
    public boolean isConfigFlagSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isConfigFlagSupported", $$robo$$android_hardware_radio_TunerAdapter$isConfigFlagSupported(int ), this, n);
    }

    @Override
    public boolean isConfigFlagSet(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isConfigFlagSet", $$robo$$android_hardware_radio_TunerAdapter$isConfigFlagSet(int ), this, n);
    }

    @Override
    public void setConfigFlag(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setConfigFlag", $$robo$$android_hardware_radio_TunerAdapter$setConfigFlag(int boolean ), this, n, bl);
    }

    @Override
    public Map<String, String> setParameters(Map<String, String> map) {
        return InvokeDynamicSupport.bootstrap("setParameters", $$robo$$android_hardware_radio_TunerAdapter$setParameters(java.util.Map<java.lang.String, java.lang.String> ), this, map);
    }

    @Override
    public Map<String, String> getParameters(List<String> list) {
        return InvokeDynamicSupport.bootstrap("getParameters", $$robo$$android_hardware_radio_TunerAdapter$getParameters(java.util.List<java.lang.String> ), this, list);
    }

    @Override
    public boolean isAntennaConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAntennaConnected", $$robo$$android_hardware_radio_TunerAdapter$isAntennaConnected(), this);
    }

    @Override
    public boolean hasControl() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasControl", $$robo$$android_hardware_radio_TunerAdapter$hasControl(), this);
    }

    public /* synthetic */ TunerAdapter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TunerAdapter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

