/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.SystemApi;
import android.hardware.location.GeofenceHardwareCallback;
import android.hardware.location.GeofenceHardwareMonitorCallback;
import android.hardware.location.GeofenceHardwareMonitorEvent;
import android.hardware.location.GeofenceHardwareRequest;
import android.hardware.location.GeofenceHardwareRequestParcelable;
import android.hardware.location.IGeofenceHardware;
import android.hardware.location.IGeofenceHardwareCallback;
import android.hardware.location.IGeofenceHardwareMonitorCallback;
import android.location.Location;
import android.os.Build;
import android.os.RemoteException;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class GeofenceHardware
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private IGeofenceHardware mService;
    static int NUM_MONITORS = 2;
    public static int MONITORING_TYPE_GPS_HARDWARE = 0;
    public static int MONITORING_TYPE_FUSED_HARDWARE = 1;
    public static int MONITOR_CURRENTLY_AVAILABLE = 0;
    public static int MONITOR_CURRENTLY_UNAVAILABLE = 1;
    public static int MONITOR_UNSUPPORTED = 2;
    public static int GEOFENCE_ENTERED = 1;
    public static int GEOFENCE_EXITED = 2;
    public static int GEOFENCE_UNCERTAIN = 4;
    public static int GEOFENCE_SUCCESS = 0;
    public static int GEOFENCE_ERROR_TOO_MANY_GEOFENCES = 1;
    public static int GEOFENCE_ERROR_ID_EXISTS = 2;
    public static int GEOFENCE_ERROR_ID_UNKNOWN = 3;
    public static int GEOFENCE_ERROR_INVALID_TRANSITION = 4;
    public static int GEOFENCE_FAILURE = 5;
    public static int GEOFENCE_ERROR_INSUFFICIENT_MEMORY = 6;
    public static int SOURCE_TECHNOLOGY_GNSS = 1;
    public static int SOURCE_TECHNOLOGY_WIFI = 2;
    public static int SOURCE_TECHNOLOGY_SENSORS = 4;
    public static int SOURCE_TECHNOLOGY_CELL = 8;
    public static int SOURCE_TECHNOLOGY_BLUETOOTH = 16;
    private HashMap<GeofenceHardwareCallback, GeofenceHardwareCallbackWrapper> mCallbacks;
    private HashMap<GeofenceHardwareMonitorCallback, GeofenceHardwareMonitorCallbackWrapper> mMonitorCallbacks;

    private void $$robo$$android_hardware_location_GeofenceHardware$__constructor__(IGeofenceHardware service) {
        this.mCallbacks = new HashMap();
        this.mMonitorCallbacks = new HashMap();
        this.mService = service;
    }

    private final int[] $$robo$$android_hardware_location_GeofenceHardware$getMonitoringTypes() {
        try {
            return this.mService.getMonitoringTypes();
        }
        catch (RemoteException remoteException) {
            return new int[0];
        }
    }

    private final int $$robo$$android_hardware_location_GeofenceHardware$getStatusOfMonitoringType(int monitoringType) {
        try {
            return this.mService.getStatusOfMonitoringType(monitoringType);
        }
        catch (RemoteException e) {
            return 2;
        }
    }

    private final boolean $$robo$$android_hardware_location_GeofenceHardware$addGeofence(int geofenceId, int monitoringType, GeofenceHardwareRequest geofenceRequest, GeofenceHardwareCallback callback) {
        try {
            if (geofenceRequest.getType() == 0) {
                return this.mService.addCircularFence(monitoringType, new GeofenceHardwareRequestParcelable(geofenceId, geofenceRequest), this.getCallbackWrapper(callback));
            }
            throw new IllegalArgumentException("Geofence Request type not supported");
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private final boolean $$robo$$android_hardware_location_GeofenceHardware$removeGeofence(int geofenceId, int monitoringType) {
        try {
            return this.mService.removeGeofence(geofenceId, monitoringType);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private final boolean $$robo$$android_hardware_location_GeofenceHardware$pauseGeofence(int geofenceId, int monitoringType) {
        try {
            return this.mService.pauseGeofence(geofenceId, monitoringType);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private final boolean $$robo$$android_hardware_location_GeofenceHardware$resumeGeofence(int geofenceId, int monitoringType, int monitorTransition) {
        try {
            return this.mService.resumeGeofence(geofenceId, monitoringType, monitorTransition);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private final boolean $$robo$$android_hardware_location_GeofenceHardware$registerForMonitorStateChangeCallback(int monitoringType, GeofenceHardwareMonitorCallback callback) {
        try {
            return this.mService.registerForMonitorStateChangeCallback(monitoringType, this.getMonitorCallbackWrapper(callback));
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private final boolean $$robo$$android_hardware_location_GeofenceHardware$unregisterForMonitorStateChangeCallback(int monitoringType, GeofenceHardwareMonitorCallback callback) {
        boolean result = false;
        try {
            result = this.mService.unregisterForMonitorStateChangeCallback(monitoringType, this.getMonitorCallbackWrapper(callback));
            if (result) {
                this.removeMonitorCallback(callback);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_location_GeofenceHardware$removeCallback(GeofenceHardwareCallback callback) {
        HashMap<GeofenceHardwareCallback, GeofenceHardwareCallbackWrapper> hashMap = this.mCallbacks;
        synchronized (hashMap) {
            this.mCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GeofenceHardwareCallbackWrapper $$robo$$android_hardware_location_GeofenceHardware$getCallbackWrapper(GeofenceHardwareCallback callback) {
        HashMap<GeofenceHardwareCallback, GeofenceHardwareCallbackWrapper> hashMap = this.mCallbacks;
        synchronized (hashMap) {
            GeofenceHardwareCallbackWrapper wrapper = this.mCallbacks.get(callback);
            if (wrapper == null) {
                wrapper = new GeofenceHardwareCallbackWrapper(this, callback);
                this.mCallbacks.put(callback, wrapper);
            }
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_location_GeofenceHardware$removeMonitorCallback(GeofenceHardwareMonitorCallback callback) {
        HashMap<GeofenceHardwareMonitorCallback, GeofenceHardwareMonitorCallbackWrapper> hashMap = this.mMonitorCallbacks;
        synchronized (hashMap) {
            this.mMonitorCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GeofenceHardwareMonitorCallbackWrapper $$robo$$android_hardware_location_GeofenceHardware$getMonitorCallbackWrapper(GeofenceHardwareMonitorCallback callback) {
        HashMap<GeofenceHardwareMonitorCallback, GeofenceHardwareMonitorCallbackWrapper> hashMap = this.mMonitorCallbacks;
        synchronized (hashMap) {
            GeofenceHardwareMonitorCallbackWrapper wrapper = this.mMonitorCallbacks.get(callback);
            if (wrapper == null) {
                wrapper = new GeofenceHardwareMonitorCallbackWrapper(this, callback);
                this.mMonitorCallbacks.put(callback, wrapper);
            }
            return wrapper;
        }
    }

    private void __constructor__(IGeofenceHardware iGeofenceHardware) {
        this.$$robo$$android_hardware_location_GeofenceHardware$__constructor__(iGeofenceHardware);
    }

    public GeofenceHardware(IGeofenceHardware iGeofenceHardware) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_GeofenceHardware$__constructor__(android.hardware.location.IGeofenceHardware ), this, iGeofenceHardware);
    }

    public int[] getMonitoringTypes() {
        return InvokeDynamicSupport.bootstrap("getMonitoringTypes", $$robo$$android_hardware_location_GeofenceHardware$getMonitoringTypes(), this);
    }

    public int getStatusOfMonitoringType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStatusOfMonitoringType", $$robo$$android_hardware_location_GeofenceHardware$getStatusOfMonitoringType(int ), this, n);
    }

    public boolean addGeofence(int n, int n2, GeofenceHardwareRequest geofenceHardwareRequest, GeofenceHardwareCallback geofenceHardwareCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("addGeofence", $$robo$$android_hardware_location_GeofenceHardware$addGeofence(int int android.hardware.location.GeofenceHardwareRequest android.hardware.location.GeofenceHardwareCallback ), this, n, n2, geofenceHardwareRequest, geofenceHardwareCallback);
    }

    public boolean removeGeofence(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeGeofence", $$robo$$android_hardware_location_GeofenceHardware$removeGeofence(int int ), this, n, n2);
    }

    public boolean pauseGeofence(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("pauseGeofence", $$robo$$android_hardware_location_GeofenceHardware$pauseGeofence(int int ), this, n, n2);
    }

    public boolean resumeGeofence(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("resumeGeofence", $$robo$$android_hardware_location_GeofenceHardware$resumeGeofence(int int int ), this, n, n2, n3);
    }

    public boolean registerForMonitorStateChangeCallback(int n, GeofenceHardwareMonitorCallback geofenceHardwareMonitorCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerForMonitorStateChangeCallback", $$robo$$android_hardware_location_GeofenceHardware$registerForMonitorStateChangeCallback(int android.hardware.location.GeofenceHardwareMonitorCallback ), this, n, geofenceHardwareMonitorCallback);
    }

    public boolean unregisterForMonitorStateChangeCallback(int n, GeofenceHardwareMonitorCallback geofenceHardwareMonitorCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("unregisterForMonitorStateChangeCallback", $$robo$$android_hardware_location_GeofenceHardware$unregisterForMonitorStateChangeCallback(int android.hardware.location.GeofenceHardwareMonitorCallback ), this, n, geofenceHardwareMonitorCallback);
    }

    private void removeCallback(GeofenceHardwareCallback geofenceHardwareCallback) {
        InvokeDynamicSupport.bootstrap("removeCallback", $$robo$$android_hardware_location_GeofenceHardware$removeCallback(android.hardware.location.GeofenceHardwareCallback ), this, geofenceHardwareCallback);
    }

    private GeofenceHardwareCallbackWrapper getCallbackWrapper(GeofenceHardwareCallback geofenceHardwareCallback) {
        return InvokeDynamicSupport.bootstrap("getCallbackWrapper", $$robo$$android_hardware_location_GeofenceHardware$getCallbackWrapper(android.hardware.location.GeofenceHardwareCallback ), this, geofenceHardwareCallback);
    }

    private void removeMonitorCallback(GeofenceHardwareMonitorCallback geofenceHardwareMonitorCallback) {
        InvokeDynamicSupport.bootstrap("removeMonitorCallback", $$robo$$android_hardware_location_GeofenceHardware$removeMonitorCallback(android.hardware.location.GeofenceHardwareMonitorCallback ), this, geofenceHardwareMonitorCallback);
    }

    private GeofenceHardwareMonitorCallbackWrapper getMonitorCallbackWrapper(GeofenceHardwareMonitorCallback geofenceHardwareMonitorCallback) {
        return InvokeDynamicSupport.bootstrap("getMonitorCallbackWrapper", $$robo$$android_hardware_location_GeofenceHardware$getMonitorCallbackWrapper(android.hardware.location.GeofenceHardwareMonitorCallback ), this, geofenceHardwareMonitorCallback);
    }

    public /* synthetic */ GeofenceHardware() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GeofenceHardware)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class GeofenceHardwareCallbackWrapper
    extends IGeofenceHardwareCallback.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private WeakReference<GeofenceHardwareCallback> mCallback;
        /* synthetic */ GeofenceHardware this$0;

        private void $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareCallbackWrapper$__constructor__(GeofenceHardware this$0, GeofenceHardwareCallback c) {
            this.this$0 = this$0;
            this.mCallback = new WeakReference<GeofenceHardwareCallback>(c);
        }

        private final void $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareCallbackWrapper$onGeofenceTransition(int geofenceId, int transition2, Location location, long timestamp, int monitoringType) {
            GeofenceHardwareCallback c = (GeofenceHardwareCallback)this.mCallback.get();
            if (c != null) {
                c.onGeofenceTransition(geofenceId, transition2, location, timestamp, monitoringType);
            }
        }

        private final void $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareCallbackWrapper$onGeofenceAdd(int geofenceId, int status) {
            GeofenceHardwareCallback c = (GeofenceHardwareCallback)this.mCallback.get();
            if (c != null) {
                c.onGeofenceAdd(geofenceId, status);
            }
        }

        private final void $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareCallbackWrapper$onGeofenceRemove(int geofenceId, int status) {
            GeofenceHardwareCallback c = (GeofenceHardwareCallback)this.mCallback.get();
            if (c != null) {
                c.onGeofenceRemove(geofenceId, status);
                this.this$0.removeCallback(c);
            }
        }

        private final void $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareCallbackWrapper$onGeofencePause(int geofenceId, int status) {
            GeofenceHardwareCallback c = (GeofenceHardwareCallback)this.mCallback.get();
            if (c != null) {
                c.onGeofencePause(geofenceId, status);
            }
        }

        private final void $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareCallbackWrapper$onGeofenceResume(int geofenceId, int status) {
            GeofenceHardwareCallback c = (GeofenceHardwareCallback)this.mCallback.get();
            if (c != null) {
                c.onGeofenceResume(geofenceId, status);
            }
        }

        private void __constructor__(GeofenceHardware geofenceHardware, GeofenceHardwareCallback geofenceHardwareCallback) {
            this.$$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareCallbackWrapper$__constructor__(geofenceHardware, geofenceHardwareCallback);
        }

        public GeofenceHardwareCallbackWrapper(GeofenceHardware geofenceHardware, GeofenceHardwareCallback geofenceHardwareCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareCallbackWrapper$__constructor__(android.hardware.location.GeofenceHardware android.hardware.location.GeofenceHardwareCallback ), this, geofenceHardware, geofenceHardwareCallback);
        }

        @Override
        public void onGeofenceTransition(int n, int n2, Location location, long l, int n3) {
            InvokeDynamicSupport.bootstrap("onGeofenceTransition", $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareCallbackWrapper$onGeofenceTransition(int int android.location.Location long int ), this, n, n2, location, l, n3);
        }

        @Override
        public void onGeofenceAdd(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onGeofenceAdd", $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareCallbackWrapper$onGeofenceAdd(int int ), this, n, n2);
        }

        @Override
        public void onGeofenceRemove(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onGeofenceRemove", $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareCallbackWrapper$onGeofenceRemove(int int ), this, n, n2);
        }

        @Override
        public void onGeofencePause(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onGeofencePause", $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareCallbackWrapper$onGeofencePause(int int ), this, n, n2);
        }

        @Override
        public void onGeofenceResume(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onGeofenceResume", $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareCallbackWrapper$onGeofenceResume(int int ), this, n, n2);
        }

        public /* synthetic */ GeofenceHardwareCallbackWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GeofenceHardwareCallbackWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class GeofenceHardwareMonitorCallbackWrapper
    extends IGeofenceHardwareMonitorCallback.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private WeakReference<GeofenceHardwareMonitorCallback> mCallback;
        /* synthetic */ GeofenceHardware this$0;

        private void $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareMonitorCallbackWrapper$__constructor__(GeofenceHardware this$0, GeofenceHardwareMonitorCallback c) {
            this.this$0 = this$0;
            this.mCallback = new WeakReference<GeofenceHardwareMonitorCallback>(c);
        }

        private final void $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareMonitorCallbackWrapper$onMonitoringSystemChange(GeofenceHardwareMonitorEvent event) {
            GeofenceHardwareMonitorCallback c = (GeofenceHardwareMonitorCallback)this.mCallback.get();
            if (c == null) {
                return;
            }
            c.onMonitoringSystemChange(event.getMonitoringType(), event.getMonitoringStatus() == 0, event.getLocation());
            if (Build.VERSION.SDK_INT >= 21) {
                c.onMonitoringSystemChange(event);
            }
        }

        private void __constructor__(GeofenceHardware geofenceHardware, GeofenceHardwareMonitorCallback geofenceHardwareMonitorCallback) {
            this.$$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareMonitorCallbackWrapper$__constructor__(geofenceHardware, geofenceHardwareMonitorCallback);
        }

        public GeofenceHardwareMonitorCallbackWrapper(GeofenceHardware geofenceHardware, GeofenceHardwareMonitorCallback geofenceHardwareMonitorCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareMonitorCallbackWrapper$__constructor__(android.hardware.location.GeofenceHardware android.hardware.location.GeofenceHardwareMonitorCallback ), this, geofenceHardware, geofenceHardwareMonitorCallback);
        }

        @Override
        public void onMonitoringSystemChange(GeofenceHardwareMonitorEvent geofenceHardwareMonitorEvent) {
            InvokeDynamicSupport.bootstrap("onMonitoringSystemChange", $$robo$$android_hardware_location_GeofenceHardware_GeofenceHardwareMonitorCallbackWrapper$onMonitoringSystemChange(android.hardware.location.GeofenceHardwareMonitorEvent ), this, geofenceHardwareMonitorEvent);
        }

        public /* synthetic */ GeofenceHardwareMonitorCallbackWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GeofenceHardwareMonitorCallbackWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

