/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.SystemApi;
import android.os.Handler;
import android.os.HandlerExecutor;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

@SystemApi
public class ContextHubTransaction<T> {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ContextHubTransaction";
    public static int TYPE_LOAD_NANOAPP = 0;
    public static int TYPE_UNLOAD_NANOAPP = 1;
    public static int TYPE_ENABLE_NANOAPP = 2;
    public static int TYPE_DISABLE_NANOAPP = 3;
    public static int TYPE_QUERY_NANOAPPS = 4;
    public static int RESULT_SUCCESS = 0;
    public static int RESULT_FAILED_UNKNOWN = 1;
    public static int RESULT_FAILED_BAD_PARAMS = 2;
    public static int RESULT_FAILED_UNINITIALIZED = 3;
    public static int RESULT_FAILED_BUSY = 4;
    public static int RESULT_FAILED_AT_HUB = 5;
    public static int RESULT_FAILED_TIMEOUT = 6;
    public static int RESULT_FAILED_SERVICE_INTERNAL_FAILURE = 7;
    public static int RESULT_FAILED_HAL_UNAVAILABLE = 8;
    private int mTransactionType;
    private Response<T> mResponse;
    private Executor mExecutor;
    private OnCompleteListener<T> mListener;
    private CountDownLatch mDoneSignal;
    private boolean mIsResponseSet;

    private void $$robo$$android_hardware_location_ContextHubTransaction$__constructor__(int type) {
        this.mExecutor = null;
        this.mListener = null;
        this.mDoneSignal = new CountDownLatch(1);
        this.mIsResponseSet = false;
        this.mTransactionType = type;
    }

    private static final String $$robo$$android_hardware_location_ContextHubTransaction$typeToString(int type, boolean upperCase) {
        switch (type) {
            case 0: {
                return upperCase ? "Load" : "load";
            }
            case 1: {
                return upperCase ? "Unload" : "unload";
            }
            case 2: {
                return upperCase ? "Enable" : "enable";
            }
            case 3: {
                return upperCase ? "Disable" : "disable";
            }
            case 4: {
                return upperCase ? "Query" : "query";
            }
        }
        return upperCase ? "Unknown" : "unknown";
    }

    private final int $$robo$$android_hardware_location_ContextHubTransaction$getType() {
        return this.mTransactionType;
    }

    private final Response<T> $$robo$$android_hardware_location_ContextHubTransaction$waitForResponse(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        boolean success = this.mDoneSignal.await(timeout, unit);
        if (!success) {
            throw new TimeoutException("Timed out while waiting for transaction");
        }
        return this.mResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_location_ContextHubTransaction$setOnCompleteListener(OnCompleteListener<T> listener, Executor executor) {
        ContextHubTransaction contextHubTransaction = this;
        synchronized (contextHubTransaction) {
            Preconditions.checkNotNull(listener, "OnCompleteListener cannot be null");
            Preconditions.checkNotNull(executor, "Executor cannot be null");
            if (this.mListener != null) {
                throw new IllegalStateException("Cannot set ContextHubTransaction listener multiple times");
            }
            this.mListener = listener;
            this.mExecutor = executor;
            if (this.mDoneSignal.getCount() == 0L) {
                this.mExecutor.execute(() -> this.mListener.onComplete(this, this.mResponse));
            }
        }
    }

    private final void $$robo$$android_hardware_location_ContextHubTransaction$setOnCompleteListener(OnCompleteListener<T> listener) {
        this.setOnCompleteListener(listener, new HandlerExecutor(Handler.getMain()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_location_ContextHubTransaction$setResponse(Response<T> response) {
        ContextHubTransaction contextHubTransaction = this;
        synchronized (contextHubTransaction) {
            Preconditions.checkNotNull(response, "Response cannot be null");
            if (this.mIsResponseSet) {
                throw new IllegalStateException("Cannot set response of ContextHubTransaction multiple times");
            }
            this.mResponse = response;
            this.mIsResponseSet = true;
            this.mDoneSignal.countDown();
            if (this.mListener != null) {
                this.mExecutor.execute(() -> this.mListener.onComplete(this, this.mResponse));
            }
        }
    }

    private void __constructor__(int n) {
        this.$$robo$$android_hardware_location_ContextHubTransaction$__constructor__(n);
    }

    public ContextHubTransaction(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubTransaction$__constructor__(int ), this, n);
    }

    public static String typeToString(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("typeToString", $$robo$$android_hardware_location_ContextHubTransaction$typeToString(int boolean ), (int)n, (boolean)bl);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_hardware_location_ContextHubTransaction$getType(), this);
    }

    public Response<T> waitForResponse(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        return InvokeDynamicSupport.bootstrap("waitForResponse", $$robo$$android_hardware_location_ContextHubTransaction$waitForResponse(long java.util.concurrent.TimeUnit ), this, l, timeUnit);
    }

    public void setOnCompleteListener(OnCompleteListener<T> onCompleteListener, Executor executor) {
        InvokeDynamicSupport.bootstrap("setOnCompleteListener", $$robo$$android_hardware_location_ContextHubTransaction$setOnCompleteListener(android.hardware.location.ContextHubTransaction$OnCompleteListener<T> java.util.concurrent.Executor ), this, onCompleteListener, executor);
    }

    public void setOnCompleteListener(OnCompleteListener<T> onCompleteListener) {
        InvokeDynamicSupport.bootstrap("setOnCompleteListener", $$robo$$android_hardware_location_ContextHubTransaction$setOnCompleteListener(android.hardware.location.ContextHubTransaction$OnCompleteListener<T> ), this, onCompleteListener);
    }

    void setResponse(Response<T> response) {
        InvokeDynamicSupport.bootstrap("setResponse", $$robo$$android_hardware_location_ContextHubTransaction$setResponse(android.hardware.location.ContextHubTransaction$Response<T> ), this, response);
    }

    public /* synthetic */ ContextHubTransaction() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContextHubTransaction)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @FunctionalInterface
    public static interface OnCompleteListener<L> {
        public void onComplete(ContextHubTransaction<L> var1, Response<L> var2);
    }

    public static class Response<R> {
        public /* synthetic */ Object __robo_data__;
        private int mResult;
        private R mContents;

        private void $$robo$$android_hardware_location_ContextHubTransaction_Response$__constructor__(int result, R contents) {
            this.mResult = result;
            this.mContents = contents;
        }

        private final int $$robo$$android_hardware_location_ContextHubTransaction_Response$getResult() {
            return this.mResult;
        }

        private final R $$robo$$android_hardware_location_ContextHubTransaction_Response$getContents() {
            return this.mContents;
        }

        private void __constructor__(int n, R r) {
            this.$$robo$$android_hardware_location_ContextHubTransaction_Response$__constructor__(n, r);
        }

        public Response(int n, R r) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubTransaction_Response$__constructor__(int R ), this, n, r);
        }

        public int getResult() {
            return (int)InvokeDynamicSupport.bootstrap("getResult", $$robo$$android_hardware_location_ContextHubTransaction_Response$getResult(), this);
        }

        public R getContents() {
            return (R)InvokeDynamicSupport.bootstrap("getContents", $$robo$$android_hardware_location_ContextHubTransaction_Response$getContents(), this);
        }

        public /* synthetic */ Response() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Response)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Result {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

