/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.hardware.hdmi.HdmiClient;
import android.hardware.hdmi.HdmiHotplugEvent;
import android.hardware.hdmi.HdmiPlaybackClient;
import android.hardware.hdmi.HdmiTvClient;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.hdmi.IHdmiHotplugEventListener;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class HdmiControlManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "HdmiControlManager";
    private IHdmiControlService mService;
    public static String ACTION_OSD_MESSAGE = "android.hardware.hdmi.action.OSD_MESSAGE";
    public static int OSD_MESSAGE_ARC_CONNECTED_INVALID_PORT = 1;
    public static int OSD_MESSAGE_AVR_VOLUME_CHANGED = 2;
    public static String EXTRA_MESSAGE_ID = "android.hardware.hdmi.extra.MESSAGE_ID";
    public static String EXTRA_MESSAGE_EXTRA_PARAM1 = "android.hardware.hdmi.extra.MESSAGE_EXTRA_PARAM1";
    public static int AVR_VOLUME_MUTED = 101;
    public static int POWER_STATUS_UNKNOWN = -1;
    public static int POWER_STATUS_ON = 0;
    public static int POWER_STATUS_STANDBY = 1;
    public static int POWER_STATUS_TRANSIENT_TO_ON = 2;
    public static int POWER_STATUS_TRANSIENT_TO_STANDBY = 3;
    public static int RESULT_SUCCESS = 0;
    public static int RESULT_TIMEOUT = 1;
    public static int RESULT_SOURCE_NOT_AVAILABLE = 2;
    public static int RESULT_TARGET_NOT_AVAILABLE = 3;
    @Deprecated
    public static int RESULT_ALREADY_IN_PROGRESS = 4;
    public static int RESULT_EXCEPTION = 5;
    public static int RESULT_INCORRECT_MODE = 6;
    public static int RESULT_COMMUNICATION_FAILED = 7;
    public static int DEVICE_EVENT_ADD_DEVICE = 1;
    public static int DEVICE_EVENT_REMOVE_DEVICE = 2;
    public static int DEVICE_EVENT_UPDATE_DEVICE = 3;
    public static int ONE_TOUCH_RECORD_RECORDING_CURRENTLY_SELECTED_SOURCE = 1;
    public static int ONE_TOUCH_RECORD_RECORDING_DIGITAL_SERVICE = 2;
    public static int ONE_TOUCH_RECORD_RECORDING_ANALOGUE_SERVICE = 3;
    public static int ONE_TOUCH_RECORD_RECORDING_EXTERNAL_INPUT = 4;
    public static int ONE_TOUCH_RECORD_UNABLE_DIGITAL_SERVICE = 5;
    public static int ONE_TOUCH_RECORD_UNABLE_ANALOGUE_SERVICE = 6;
    public static int ONE_TOUCH_RECORD_UNABLE_SELECTED_SERVICE = 7;
    public static int ONE_TOUCH_RECORD_INVALID_EXTERNAL_PLUG_NUMBER = 9;
    public static int ONE_TOUCH_RECORD_INVALID_EXTERNAL_PHYSICAL_ADDRESS = 10;
    public static int ONE_TOUCH_RECORD_UNSUPPORTED_CA = 11;
    public static int ONE_TOUCH_RECORD_NO_OR_INSUFFICIENT_CA_ENTITLEMENTS = 12;
    public static int ONE_TOUCH_RECORD_DISALLOW_TO_COPY = 13;
    public static int ONE_TOUCH_RECORD_DISALLOW_TO_FUTHER_COPIES = 14;
    public static int ONE_TOUCH_RECORD_NO_MEDIA = 16;
    public static int ONE_TOUCH_RECORD_PLAYING = 17;
    public static int ONE_TOUCH_RECORD_ALREADY_RECORDING = 18;
    public static int ONE_TOUCH_RECORD_MEDIA_PROTECTED = 19;
    public static int ONE_TOUCH_RECORD_NO_SOURCE_SIGNAL = 20;
    public static int ONE_TOUCH_RECORD_MEDIA_PROBLEM = 21;
    public static int ONE_TOUCH_RECORD_NOT_ENOUGH_SPACE = 22;
    public static int ONE_TOUCH_RECORD_PARENT_LOCK_ON = 23;
    public static int ONE_TOUCH_RECORD_RECORDING_TERMINATED_NORMALLY = 26;
    public static int ONE_TOUCH_RECORD_RECORDING_ALREADY_TERMINATED = 27;
    public static int ONE_TOUCH_RECORD_OTHER_REASON = 31;
    public static int ONE_TOUCH_RECORD_PREVIOUS_RECORDING_IN_PROGRESS = 48;
    public static int ONE_TOUCH_RECORD_CHECK_RECORDER_CONNECTION = 49;
    public static int ONE_TOUCH_RECORD_FAIL_TO_RECORD_DISPLAYED_SCREEN = 50;
    public static int ONE_TOUCH_RECORD_CEC_DISABLED = 51;
    public static int TIMER_RECORDING_TYPE_DIGITAL = 1;
    public static int TIMER_RECORDING_TYPE_ANALOGUE = 2;
    public static int TIMER_RECORDING_TYPE_EXTERNAL = 3;
    public static int TIMER_STATUS_MEDIA_INFO_PRESENT_NOT_PROTECTED = 0;
    public static int TIMER_STATUS_MEDIA_INFO_PRESENT_PROTECTED = 1;
    public static int TIMER_STATUS_MEDIA_INFO_NOT_PRESENT = 2;
    public static int TIMER_STATUS_PROGRAMMED_INFO_ENOUGH_SPACE = 8;
    public static int TIMER_STATUS_PROGRAMMED_INFO_NOT_ENOUGH_SPACE = 9;
    public static int TIMER_STATUS_PROGRAMMED_INFO_MIGHT_NOT_ENOUGH_SPACE = 11;
    public static int TIMER_STATUS_PROGRAMMED_INFO_NO_MEDIA_INFO = 10;
    public static int TIMER_STATUS_NOT_PROGRAMMED_NO_FREE_TIME = 1;
    public static int TIMER_STATUS_NOT_PROGRAMMED_DATE_OUT_OF_RANGE = 2;
    public static int TIMER_STATUS_NOT_PROGRAMMED_INVALID_SEQUENCE = 3;
    public static int TIMER_STATUS_NOT_PROGRAMMED_INVALID_EXTERNAL_PLUG_NUMBER = 4;
    public static int TIMER_STATUS_NOT_PROGRAMMED_INVALID_EXTERNAL_PHYSICAL_NUMBER = 5;
    public static int TIMER_STATUS_NOT_PROGRAMMED_CA_NOT_SUPPORTED = 6;
    public static int TIMER_STATUS_NOT_PROGRAMMED_NO_CA_ENTITLEMENTS = 7;
    public static int TIMER_STATUS_NOT_PROGRAMMED_UNSUPPORTED_RESOLUTION = 8;
    public static int TIMER_STATUS_NOT_PROGRAMMED_PARENTAL_LOCK_ON = 9;
    public static int TIMER_STATUS_NOT_PROGRAMMED_CLOCK_FAILURE = 10;
    public static int TIMER_STATUS_NOT_PROGRAMMED_DUPLICATED = 14;
    public static int TIMER_RECORDING_RESULT_EXTRA_NO_ERROR = 0;
    public static int TIMER_RECORDING_RESULT_EXTRA_CHECK_RECORDER_CONNECTION = 1;
    public static int TIMER_RECORDING_RESULT_EXTRA_FAIL_TO_RECORD_SELECTED_SOURCE = 2;
    public static int TIMER_RECORDING_RESULT_EXTRA_CEC_DISABLED = 3;
    public static int CLEAR_TIMER_STATUS_TIMER_NOT_CLEARED_RECORDING = 0;
    public static int CLEAR_TIMER_STATUS_TIMER_NOT_CLEARED_NO_MATCHING = 1;
    public static int CLEAR_TIMER_STATUS_TIMER_NOT_CLEARED_NO_INFO_AVAILABLE = 2;
    public static int CLEAR_TIMER_STATUS_TIMER_CLEARED = 128;
    public static int CLEAR_TIMER_STATUS_CHECK_RECORDER_CONNECTION = 160;
    public static int CLEAR_TIMER_STATUS_FAIL_TO_CLEAR_SELECTED_SOURCE = 161;
    public static int CLEAR_TIMER_STATUS_CEC_DISABLE = 162;
    public static int CONTROL_STATE_CHANGED_REASON_START = 0;
    public static int CONTROL_STATE_CHANGED_REASON_SETTING = 1;
    public static int CONTROL_STATE_CHANGED_REASON_WAKEUP = 2;
    public static int CONTROL_STATE_CHANGED_REASON_STANDBY = 3;
    private boolean mHasPlaybackDevice;
    private boolean mHasTvDevice;
    private ArrayMap<HotplugEventListener, IHdmiHotplugEventListener> mHotplugEventListeners;

    private void $$robo$$android_hardware_hdmi_HdmiControlManager$__constructor__(IHdmiControlService service) {
        this.mHotplugEventListeners = new ArrayMap();
        this.mService = service;
        int[] types = null;
        if (this.mService != null) {
            try {
                types = this.mService.getSupportedTypes();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        this.mHasTvDevice = HdmiControlManager.hasDeviceType(types, 0);
        this.mHasPlaybackDevice = HdmiControlManager.hasDeviceType(types, 4);
    }

    private static final boolean $$robo$$android_hardware_hdmi_HdmiControlManager$hasDeviceType(int[] types, int type) {
        if (types == null) {
            return false;
        }
        for (int t : types) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    @SuppressLint(value={"Doclava125"})
    private final HdmiClient $$robo$$android_hardware_hdmi_HdmiControlManager$getClient(int type) {
        if (this.mService == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return this.mHasTvDevice ? new HdmiTvClient(this.mService) : null;
            }
            case 4: {
                return this.mHasPlaybackDevice ? new HdmiPlaybackClient(this.mService) : null;
            }
        }
        return null;
    }

    @SuppressLint(value={"Doclava125"})
    private final HdmiPlaybackClient $$robo$$android_hardware_hdmi_HdmiControlManager$getPlaybackClient() {
        return (HdmiPlaybackClient)this.getClient(4);
    }

    @SuppressLint(value={"Doclava125"})
    private final HdmiTvClient $$robo$$android_hardware_hdmi_HdmiControlManager$getTvClient() {
        return (HdmiTvClient)this.getClient(0);
    }

    private final void $$robo$$android_hardware_hdmi_HdmiControlManager$setStandbyMode(boolean isStandbyModeOn) {
        try {
            this.mService.setStandbyMode(isStandbyModeOn);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiControlManager$addHotplugEventListener(HotplugEventListener listener) {
        if (this.mService == null) {
            Log.e("HdmiControlManager", "HdmiControlService is not available");
            return;
        }
        if (this.mHotplugEventListeners.containsKey(listener)) {
            Log.e("HdmiControlManager", "listener is already registered");
            return;
        }
        IHdmiHotplugEventListener wrappedListener = this.getHotplugEventListenerWrapper(listener);
        this.mHotplugEventListeners.put(listener, wrappedListener);
        try {
            this.mService.addHotplugEventListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiControlManager$removeHotplugEventListener(HotplugEventListener listener) {
        if (this.mService == null) {
            Log.e("HdmiControlManager", "HdmiControlService is not available");
            return;
        }
        IHdmiHotplugEventListener wrappedListener = this.mHotplugEventListeners.remove(listener);
        if (wrappedListener == null) {
            Log.e("HdmiControlManager", "tried to remove not-registered listener");
            return;
        }
        try {
            this.mService.removeHotplugEventListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final IHdmiHotplugEventListener $$robo$$android_hardware_hdmi_HdmiControlManager$getHotplugEventListenerWrapper(HotplugEventListener listener) {
        return new ShadowedObject(this, listener){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ HotplugEventListener val$listener;
            /* synthetic */ HdmiControlManager this$0;

            private void $$robo$$android_hardware_hdmi_HdmiControlManager_1$__constructor__(HdmiControlManager this$0, HotplugEventListener hotplugEventListener) {
                this.this$0 = this$0;
                this.val$listener = hotplugEventListener;
            }

            private final void $$robo$$android_hardware_hdmi_HdmiControlManager_1$onReceived(HdmiHotplugEvent event) {
                this.val$listener.onReceived(event);
            }

            private void __constructor__(HdmiControlManager hdmiControlManager, HotplugEventListener hotplugEventListener) {
                this.$$robo$$android_hardware_hdmi_HdmiControlManager_1$__constructor__(hdmiControlManager, hotplugEventListener);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiControlManager_1$__constructor__(android.hardware.hdmi.HdmiControlManager android.hardware.hdmi.HdmiControlManager$HotplugEventListener ), this, hdmiControlManager, hotplugEventListener);
            }

            @Override
            public void onReceived(HdmiHotplugEvent hdmiHotplugEvent) {
                InvokeDynamicSupport.bootstrap("onReceived", $$robo$$android_hardware_hdmi_HdmiControlManager_1$onReceived(android.hardware.hdmi.HdmiHotplugEvent ), this, hdmiHotplugEvent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(IHdmiControlService iHdmiControlService) {
        this.$$robo$$android_hardware_hdmi_HdmiControlManager$__constructor__(iHdmiControlService);
    }

    public HdmiControlManager(IHdmiControlService iHdmiControlService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiControlManager$__constructor__(android.hardware.hdmi.IHdmiControlService ), this, iHdmiControlService);
    }

    private static boolean hasDeviceType(int[] nArray, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasDeviceType", $$robo$$android_hardware_hdmi_HdmiControlManager$hasDeviceType(int[] int ), (int[])nArray, (int)n);
    }

    public HdmiClient getClient(int n) {
        return InvokeDynamicSupport.bootstrap("getClient", $$robo$$android_hardware_hdmi_HdmiControlManager$getClient(int ), this, n);
    }

    public HdmiPlaybackClient getPlaybackClient() {
        return InvokeDynamicSupport.bootstrap("getPlaybackClient", $$robo$$android_hardware_hdmi_HdmiControlManager$getPlaybackClient(), this);
    }

    public HdmiTvClient getTvClient() {
        return InvokeDynamicSupport.bootstrap("getTvClient", $$robo$$android_hardware_hdmi_HdmiControlManager$getTvClient(), this);
    }

    public void setStandbyMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStandbyMode", $$robo$$android_hardware_hdmi_HdmiControlManager$setStandbyMode(boolean ), this, bl);
    }

    public void addHotplugEventListener(HotplugEventListener hotplugEventListener) {
        InvokeDynamicSupport.bootstrap("addHotplugEventListener", $$robo$$android_hardware_hdmi_HdmiControlManager$addHotplugEventListener(android.hardware.hdmi.HdmiControlManager$HotplugEventListener ), this, hotplugEventListener);
    }

    public void removeHotplugEventListener(HotplugEventListener hotplugEventListener) {
        InvokeDynamicSupport.bootstrap("removeHotplugEventListener", $$robo$$android_hardware_hdmi_HdmiControlManager$removeHotplugEventListener(android.hardware.hdmi.HdmiControlManager$HotplugEventListener ), this, hotplugEventListener);
    }

    private IHdmiHotplugEventListener getHotplugEventListenerWrapper(HotplugEventListener hotplugEventListener) {
        return InvokeDynamicSupport.bootstrap("getHotplugEventListenerWrapper", $$robo$$android_hardware_hdmi_HdmiControlManager$getHotplugEventListenerWrapper(android.hardware.hdmi.HdmiControlManager$HotplugEventListener ), this, hotplugEventListener);
    }

    public /* synthetic */ HdmiControlManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HdmiControlManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface VendorCommandListener {
        public void onReceived(int var1, int var2, byte[] var3, boolean var4);

        public void onControlStateChanged(boolean var1, int var2);
    }

    public static interface HotplugEventListener {
        public void onReceived(HdmiHotplugEvent var1);
    }
}

