/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import com.android.internal.util.Preconditions;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class TypeReference<T> {
    public /* synthetic */ Object __robo_data__;
    private Type mType;
    private int mHash;

    private void $$robo$$android_hardware_camera2_utils_TypeReference$__constructor__() {
        ParameterizedType thisType = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.mType = thisType.getActualTypeArguments()[0];
        if (TypeReference.containsTypeVariable(this.mType)) {
            throw new IllegalArgumentException("Including a type variable in a type reference is not allowed");
        }
        this.mHash = this.mType.hashCode();
    }

    private final Type $$robo$$android_hardware_camera2_utils_TypeReference$getType() {
        return this.mType;
    }

    private void $$robo$$android_hardware_camera2_utils_TypeReference$__constructor__(Type type) {
        this.mType = type;
        if (TypeReference.containsTypeVariable(this.mType)) {
            throw new IllegalArgumentException("Including a type variable in a type reference is not allowed");
        }
        this.mHash = this.mType.hashCode();
    }

    private static final <T> TypeReference<T> $$robo$$android_hardware_camera2_utils_TypeReference$createSpecializedTypeReference(Class<T> klass) {
        return new SpecializedTypeReference<T>(klass);
    }

    private static final TypeReference<?> $$robo$$android_hardware_camera2_utils_TypeReference$createSpecializedTypeReference(Type type) {
        return new SpecializedBaseTypeReference(type);
    }

    private final Class<? super T> $$robo$$android_hardware_camera2_utils_TypeReference$getRawType() {
        return TypeReference.getRawType(this.mType);
    }

    private static final Class<?> $$robo$$android_hardware_camera2_utils_TypeReference$getRawType(Type type) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            return TypeReference.getArrayClass(TypeReference.getRawType(((GenericArrayType)type).getGenericComponentType()));
        }
        if (type instanceof WildcardType) {
            return TypeReference.getRawType(((WildcardType)type).getUpperBounds());
        }
        if (type instanceof TypeVariable) {
            throw new AssertionError((Object)"Type variables are not allowed in type references");
        }
        throw new AssertionError((Object)("Unhandled branch to get raw type for type " + type));
    }

    private static final Class<?> $$robo$$android_hardware_camera2_utils_TypeReference$getRawType(Type[] types) {
        if (types == null) {
            return null;
        }
        for (Type type : types) {
            Class<?> klass = TypeReference.getRawType(type);
            if (klass == null) continue;
            return klass;
        }
        return null;
    }

    private static final Class<?> $$robo$$android_hardware_camera2_utils_TypeReference$getArrayClass(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    private final TypeReference<?> $$robo$$android_hardware_camera2_utils_TypeReference$getComponentType() {
        Type componentType = TypeReference.getComponentType(this.mType);
        return componentType != null ? TypeReference.createSpecializedTypeReference(componentType) : null;
    }

    private static final Type $$robo$$android_hardware_camera2_utils_TypeReference$getComponentType(Type type) {
        Preconditions.checkNotNull(type, "type must not be null");
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        if (type instanceof ParameterizedType) {
            return null;
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        if (type instanceof WildcardType) {
            throw new UnsupportedOperationException("TODO: support wild card components");
        }
        if (type instanceof TypeVariable) {
            throw new AssertionError((Object)"Type variables are not allowed in type references");
        }
        throw new AssertionError((Object)("Unhandled branch to get component type for type " + type));
    }

    private final boolean $$robo$$android_hardware_camera2_utils_TypeReference$equals(Object o) {
        return o instanceof TypeReference && this.mType.equals(((TypeReference)o).mType);
    }

    private final int $$robo$$android_hardware_camera2_utils_TypeReference$hashCode() {
        return this.mHash;
    }

    private static final boolean $$robo$$android_hardware_camera2_utils_TypeReference$containsTypeVariable(Type type) {
        if (type == null) {
            return false;
        }
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof Class) {
            Class klass = (Class)type;
            if (klass.getTypeParameters().length != 0) {
                return true;
            }
            return TypeReference.containsTypeVariable(klass.getDeclaringClass());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            for (Type arg : p.getActualTypeArguments()) {
                if (!TypeReference.containsTypeVariable(arg)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof WildcardType) {
            WildcardType wild = (WildcardType)type;
            return TypeReference.containsTypeVariable(wild.getLowerBounds()) || TypeReference.containsTypeVariable(wild.getUpperBounds());
        }
        return false;
    }

    private final String $$robo$$android_hardware_camera2_utils_TypeReference$toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TypeReference<");
        TypeReference.toString(this.getType(), builder);
        builder.append(">");
        return builder.toString();
    }

    private static final void $$robo$$android_hardware_camera2_utils_TypeReference$toString(Type type, StringBuilder out) {
        if (type == null) {
            return;
        }
        if (type instanceof TypeVariable) {
            out.append(((TypeVariable)type).getName());
        } else if (type instanceof Class) {
            Class klass = (Class)type;
            out.append(klass.getName());
            TypeReference.toString(klass.getTypeParameters(), out);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            out.append(((Class)p.getRawType()).getName());
            TypeReference.toString(p.getActualTypeArguments(), out);
        } else if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            TypeReference.toString(gat.getGenericComponentType(), out);
            out.append("[]");
        } else {
            out.append(type.toString());
        }
    }

    private static final void $$robo$$android_hardware_camera2_utils_TypeReference$toString(Type[] types, StringBuilder out) {
        if (types == null) {
            return;
        }
        if (types.length == 0) {
            return;
        }
        out.append("<");
        for (int i = 0; i < types.length; ++i) {
            TypeReference.toString(types[i], out);
            if (i == types.length - 1) continue;
            out.append(", ");
        }
        out.append(">");
    }

    private static final boolean $$robo$$android_hardware_camera2_utils_TypeReference$containsTypeVariable(Type[] typeArray) {
        if (typeArray == null) {
            return false;
        }
        for (Type type : typeArray) {
            if (!TypeReference.containsTypeVariable(type)) continue;
            return true;
        }
        return false;
    }

    private /* synthetic */ void $$robo$$android_hardware_camera2_utils_TypeReference$__constructor__(Type x0, 1 x1) {
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_camera2_utils_TypeReference$__constructor__();
    }

    public TypeReference() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_utils_TypeReference$__constructor__(), this);
    }

    public Type getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_hardware_camera2_utils_TypeReference$getType(), this);
    }

    private void __constructor__(Type type) {
        this.$$robo$$android_hardware_camera2_utils_TypeReference$__constructor__(type);
    }

    public TypeReference(Type type) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_utils_TypeReference$__constructor__(java.lang.reflect.Type ), this, type);
    }

    public static <T> TypeReference<T> createSpecializedTypeReference(Class<T> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("createSpecializedTypeReference", $$robo$$android_hardware_camera2_utils_TypeReference$createSpecializedTypeReference(java.lang.Class<T> ), clazz);
    }

    public static TypeReference<?> createSpecializedTypeReference(Type type) {
        return InvokeDynamicSupport.bootstrapStatic("createSpecializedTypeReference", $$robo$$android_hardware_camera2_utils_TypeReference$createSpecializedTypeReference(java.lang.reflect.Type ), (Type)type);
    }

    public Class<? super T> getRawType() {
        return InvokeDynamicSupport.bootstrap("getRawType", $$robo$$android_hardware_camera2_utils_TypeReference$getRawType(), this);
    }

    private static Class<?> getRawType(Type type) {
        return InvokeDynamicSupport.bootstrapStatic("getRawType", $$robo$$android_hardware_camera2_utils_TypeReference$getRawType(java.lang.reflect.Type ), (Type)type);
    }

    private static Class<?> getRawType(Type[] typeArray) {
        return InvokeDynamicSupport.bootstrapStatic("getRawType", $$robo$$android_hardware_camera2_utils_TypeReference$getRawType(java.lang.reflect.Type[] ), (Type[])typeArray);
    }

    private static Class<?> getArrayClass(Class<?> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getArrayClass", $$robo$$android_hardware_camera2_utils_TypeReference$getArrayClass(java.lang.Class<?> ), clazz);
    }

    public TypeReference<?> getComponentType() {
        return InvokeDynamicSupport.bootstrap("getComponentType", $$robo$$android_hardware_camera2_utils_TypeReference$getComponentType(), this);
    }

    private static Type getComponentType(Type type) {
        return InvokeDynamicSupport.bootstrapStatic("getComponentType", $$robo$$android_hardware_camera2_utils_TypeReference$getComponentType(java.lang.reflect.Type ), (Type)type);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_utils_TypeReference$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_camera2_utils_TypeReference$hashCode(), this);
    }

    public static boolean containsTypeVariable(Type type) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsTypeVariable", $$robo$$android_hardware_camera2_utils_TypeReference$containsTypeVariable(java.lang.reflect.Type ), (Type)type);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_camera2_utils_TypeReference$toString(), this);
    }

    private static void toString(Type type, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("toString", $$robo$$android_hardware_camera2_utils_TypeReference$toString(java.lang.reflect.Type java.lang.StringBuilder ), (Type)type, (StringBuilder)stringBuilder);
    }

    private static void toString(Type[] typeArray, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("toString", $$robo$$android_hardware_camera2_utils_TypeReference$toString(java.lang.reflect.Type[] java.lang.StringBuilder ), (Type[])typeArray, (StringBuilder)stringBuilder);
    }

    private static boolean containsTypeVariable(Type[] typeArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsTypeVariable", $$robo$$android_hardware_camera2_utils_TypeReference$containsTypeVariable(java.lang.reflect.Type[] ), (Type[])typeArray);
    }

    private /* synthetic */ void __constructor__(Type type, 1 var2_2) {
        this.$$robo$$android_hardware_camera2_utils_TypeReference$__constructor__(type, var2_2);
    }

    public /* synthetic */ TypeReference(Type type, 1 var2_2) {
        this(type);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_utils_TypeReference$__constructor__(java.lang.reflect.Type android.hardware.camera2.utils.TypeReference$1 ), this, type, var2_2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TypeReference)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class SpecializedBaseTypeReference
    extends TypeReference
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_camera2_utils_TypeReference_SpecializedBaseTypeReference$__constructor__(Type type) {
        }

        @Override
        private void __constructor__(Type type) {
            this.$$robo$$android_hardware_camera2_utils_TypeReference_SpecializedBaseTypeReference$__constructor__(type);
        }

        public SpecializedBaseTypeReference(Type type) {
            super(type, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_utils_TypeReference_SpecializedBaseTypeReference$__constructor__(java.lang.reflect.Type ), this, type);
        }

        public /* synthetic */ SpecializedBaseTypeReference() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpecializedBaseTypeReference)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SpecializedTypeReference<T>
    extends TypeReference<T> {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_camera2_utils_TypeReference_SpecializedTypeReference$__constructor__(Class<T> klass) {
        }

        private void __constructor__(Class<T> clazz) {
            this.$$robo$$android_hardware_camera2_utils_TypeReference_SpecializedTypeReference$__constructor__(clazz);
        }

        public SpecializedTypeReference(Class<T> clazz) {
            super(clazz, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_utils_TypeReference_SpecializedTypeReference$__constructor__(java.lang.Class<T> ), this, clazz);
        }

        public /* synthetic */ SpecializedTypeReference() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpecializedTypeReference)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

