/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.HardwareBuffer;
import android.hardware.Sensor;
import android.hardware.SensorAdditionalInfo;
import android.hardware.SensorDirectChannel;
import android.hardware.SensorEvent;
import android.hardware.SensorEventCallback;
import android.hardware.SensorEventListener;
import android.hardware.SensorEventListener2;
import android.hardware.SensorManager;
import android.hardware.TriggerEvent;
import android.hardware.TriggerEventListener;
import android.os.Handler;
import android.os.Looper;
import android.os.MemoryFile;
import android.os.MessageQueue;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SystemSensorManager
extends SensorManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG_DYNAMIC_SENSOR = true;
    private static int MIN_DIRECT_CHANNEL_BUFFER_SIZE = 104;
    private static int MAX_LISTENER_COUNT = 128;
    private static Object sLock;
    @GuardedBy(value="sLock")
    private static boolean sNativeClassInited;
    @GuardedBy(value="sLock")
    private static InjectEventQueue sInjectEventQueue;
    private ArrayList<Sensor> mFullSensorsList;
    private List<Sensor> mFullDynamicSensorsList;
    private boolean mDynamicSensorListDirty;
    private HashMap<Integer, Sensor> mHandleToSensor;
    private HashMap<SensorEventListener, SensorEventQueue> mSensorListeners;
    private HashMap<TriggerEventListener, TriggerEventQueue> mTriggerListeners;
    private HashMap<SensorManager.DynamicSensorCallback, Handler> mDynamicSensorCallbacks;
    private BroadcastReceiver mDynamicSensorBroadcastReceiver;
    private Looper mMainLooper;
    private int mTargetSdkLevel;
    private Context mContext;
    private long mNativeInstance;

    private static final void $$robo$$android_hardware_SystemSensorManager$nativeClassInit() {
    }

    private static final long $$robo$$android_hardware_SystemSensorManager$nativeCreate(String string2) {
        return 0L;
    }

    private static final boolean $$robo$$android_hardware_SystemSensorManager$nativeGetSensorAtIndex(long l, Sensor sensor, int n) {
        return false;
    }

    private static final void $$robo$$android_hardware_SystemSensorManager$nativeGetDynamicSensors(long l, List<Sensor> list) {
    }

    private static final boolean $$robo$$android_hardware_SystemSensorManager$nativeIsDataInjectionEnabled(long l) {
        return false;
    }

    private static final int $$robo$$android_hardware_SystemSensorManager$nativeCreateDirectChannel(long l, long l2, int n, int n2, HardwareBuffer hardwareBuffer) {
        return 0;
    }

    private static final void $$robo$$android_hardware_SystemSensorManager$nativeDestroyDirectChannel(long l, int n) {
    }

    private static final int $$robo$$android_hardware_SystemSensorManager$nativeConfigDirectChannel(long l, int n, int n2, int n3) {
        return 0;
    }

    private static final int $$robo$$android_hardware_SystemSensorManager$nativeSetOperationParameter(long l, int n, int n2, float[] fArray, int[] nArray) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_hardware_SystemSensorManager$__constructor__(Context context, Looper mainLooper) {
        Sensor sensor;
        this.mFullSensorsList = new ArrayList();
        this.mFullDynamicSensorsList = new ArrayList<Sensor>();
        this.mDynamicSensorListDirty = true;
        this.mHandleToSensor = new HashMap();
        this.mSensorListeners = new HashMap();
        this.mTriggerListeners = new HashMap();
        this.mDynamicSensorCallbacks = new HashMap();
        Object object = sLock;
        synchronized (object) {
            if (!sNativeClassInited) {
                sNativeClassInited = true;
                SystemSensorManager.nativeClassInit();
            }
        }
        this.mMainLooper = mainLooper;
        this.mTargetSdkLevel = context.getApplicationInfo().targetSdkVersion;
        this.mContext = context;
        this.mNativeInstance = SystemSensorManager.nativeCreate(context.getOpPackageName());
        int index = 0;
        while (SystemSensorManager.nativeGetSensorAtIndex(this.mNativeInstance, sensor = new Sensor(), index)) {
            this.mFullSensorsList.add(sensor);
            this.mHandleToSensor.put(sensor.getHandle(), sensor);
            ++index;
        }
    }

    private final List<Sensor> $$robo$$android_hardware_SystemSensorManager$getFullSensorList() {
        return this.mFullSensorsList;
    }

    private final List<Sensor> $$robo$$android_hardware_SystemSensorManager$getFullDynamicSensorList() {
        this.setupDynamicSensorBroadcastReceiver();
        this.updateDynamicSensorList();
        return this.mFullDynamicSensorsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_SystemSensorManager$registerListenerImpl(SensorEventListener listener, Sensor sensor, int delayUs, Handler handler, int maxBatchReportLatencyUs, int reservedFlags) {
        if (listener == null || sensor == null) {
            Log.e("SensorManager", "sensor or listener is null");
            return false;
        }
        if (sensor.getReportingMode() == 2) {
            Log.e("SensorManager", "Trigger Sensors should use the requestTriggerSensor.");
            return false;
        }
        if (maxBatchReportLatencyUs < 0 || delayUs < 0) {
            Log.e("SensorManager", "maxBatchReportLatencyUs and delayUs should be non-negative");
            return false;
        }
        if (this.mSensorListeners.size() >= 128) {
            throw new IllegalStateException("register failed, the sensor listeners size has exceeded the maximum limit 128");
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue == null) {
                String fullClassName;
                Looper looper = handler != null ? handler.getLooper() : this.mMainLooper;
                queue = new SensorEventQueue(listener, looper, this, fullClassName = listener.getClass().getEnclosingClass() != null ? listener.getClass().getEnclosingClass().getName() : listener.getClass().getName());
                if (!queue.addSensor(sensor, delayUs, maxBatchReportLatencyUs)) {
                    queue.dispose();
                    return false;
                }
                this.mSensorListeners.put(listener, queue);
                return true;
            }
            return queue.addSensor(sensor, delayUs, maxBatchReportLatencyUs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_SystemSensorManager$unregisterListenerImpl(SensorEventListener listener, Sensor sensor) {
        if (sensor != null && sensor.getReportingMode() == 2) {
            return;
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            boolean result;
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue != null && (result = sensor == null ? queue.removeAllSensors() : queue.removeSensor(sensor, true)) && !queue.hasSensors()) {
                this.mSensorListeners.remove(listener);
                queue.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_SystemSensorManager$requestTriggerSensorImpl(TriggerEventListener listener, Sensor sensor) {
        if (sensor == null) {
            throw new IllegalArgumentException("sensor cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (sensor.getReportingMode() != 2) {
            return false;
        }
        if (this.mTriggerListeners.size() >= 128) {
            throw new IllegalStateException("request failed, the trigger listeners size has exceeded the maximum limit 128");
        }
        HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
        synchronized (hashMap) {
            TriggerEventQueue queue = this.mTriggerListeners.get(listener);
            if (queue == null) {
                String fullClassName = listener.getClass().getEnclosingClass() != null ? listener.getClass().getEnclosingClass().getName() : listener.getClass().getName();
                queue = new TriggerEventQueue(listener, this.mMainLooper, this, fullClassName);
                if (!queue.addSensor(sensor, 0, 0)) {
                    queue.dispose();
                    return false;
                }
                this.mTriggerListeners.put(listener, queue);
                return true;
            }
            return queue.addSensor(sensor, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_SystemSensorManager$cancelTriggerSensorImpl(TriggerEventListener listener, Sensor sensor, boolean disable) {
        if (sensor != null && sensor.getReportingMode() != 2) {
            return false;
        }
        HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
        synchronized (hashMap) {
            TriggerEventQueue queue = this.mTriggerListeners.get(listener);
            if (queue != null) {
                boolean result = sensor == null ? queue.removeAllSensors() : queue.removeSensor(sensor, disable);
                if (result && !queue.hasSensors()) {
                    this.mTriggerListeners.remove(listener);
                    queue.dispose();
                }
                return result;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_SystemSensorManager$flushImpl(SensorEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue == null) {
                return false;
            }
            return queue.flush() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_SystemSensorManager$initDataInjectionImpl(boolean enable) {
        Object object = sLock;
        synchronized (object) {
            if (enable) {
                boolean isDataInjectionModeEnabled = SystemSensorManager.nativeIsDataInjectionEnabled(this.mNativeInstance);
                if (!isDataInjectionModeEnabled) {
                    Log.e("SensorManager", "Data Injection mode not enabled");
                    return false;
                }
                if (sInjectEventQueue == null) {
                    try {
                        sInjectEventQueue = new InjectEventQueue(this, this.mMainLooper, this, this.mContext.getPackageName());
                    }
                    catch (RuntimeException e) {
                        Log.e("SensorManager", "Cannot create InjectEventQueue: " + e);
                    }
                }
                return sInjectEventQueue != null;
            }
            if (sInjectEventQueue != null) {
                sInjectEventQueue.dispose();
                sInjectEventQueue = null;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_SystemSensorManager$injectSensorDataImpl(Sensor sensor, float[] values, int accuracy, long timestamp) {
        Object object = sLock;
        synchronized (object) {
            if (sInjectEventQueue == null) {
                Log.e("SensorManager", "Data injection mode not activated before calling injectSensorData");
                return false;
            }
            int ret = sInjectEventQueue.injectSensorData(sensor.getHandle(), values, accuracy, timestamp);
            if (ret != 0) {
                sInjectEventQueue.dispose();
                sInjectEventQueue = null;
            }
            return ret == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_SystemSensorManager$cleanupSensorConnection(Sensor sensor) {
        this.mHandleToSensor.remove(sensor.getHandle());
        if (sensor.getReportingMode() == 2) {
            HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
            synchronized (hashMap) {
                HashMap<TriggerEventListener, TriggerEventQueue> triggerListeners = new HashMap<TriggerEventListener, TriggerEventQueue>(this.mTriggerListeners);
                for (TriggerEventListener l : triggerListeners.keySet()) {
                    Log.i("SensorManager", "removed trigger listener" + l.toString() + " due to sensor disconnection");
                    this.cancelTriggerSensorImpl(l, sensor, true);
                }
            }
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            HashMap<SensorEventListener, SensorEventQueue> sensorListeners = new HashMap<SensorEventListener, SensorEventQueue>(this.mSensorListeners);
            for (SensorEventListener l : sensorListeners.keySet()) {
                Log.i("SensorManager", "removed event listener" + l.toString() + " due to sensor disconnection");
                this.unregisterListenerImpl(l, sensor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_SystemSensorManager$updateDynamicSensorList() {
        List<Sensor> list = this.mFullDynamicSensorsList;
        synchronized (list) {
            if (this.mDynamicSensorListDirty) {
                ArrayList<Sensor> list2 = new ArrayList<Sensor>();
                SystemSensorManager.nativeGetDynamicSensors(this.mNativeInstance, list2);
                ArrayList<Sensor> updatedList = new ArrayList<Sensor>();
                ArrayList<Sensor> addedList = new ArrayList<Sensor>();
                ArrayList<Sensor> removedList = new ArrayList<Sensor>();
                boolean changed = SystemSensorManager.diffSortedSensorList(this.mFullDynamicSensorsList, list2, updatedList, addedList, removedList);
                if (changed) {
                    Log.i("SensorManager", "DYNS dynamic sensor list cached should be updated");
                    this.mFullDynamicSensorsList = updatedList;
                    for (Sensor s : addedList) {
                        this.mHandleToSensor.put(s.getHandle(), s);
                    }
                    Handler mainHandler = new Handler(this.mContext.getMainLooper());
                    for (Map.Entry<SensorManager.DynamicSensorCallback, Handler> entry : this.mDynamicSensorCallbacks.entrySet()) {
                        SensorManager.DynamicSensorCallback callback = entry.getKey();
                        Handler handler = entry.getValue() == null ? mainHandler : entry.getValue();
                        handler.post(new Runnable(this, addedList, callback, removedList){
                            public /* synthetic */ Object __robo_data__;
                            /* synthetic */ List val$addedList;
                            /* synthetic */ SensorManager.DynamicSensorCallback val$callback;
                            /* synthetic */ List val$removedList;
                            /* synthetic */ SystemSensorManager this$0;

                            private void $$robo$$android_hardware_SystemSensorManager_1$__constructor__(SystemSensorManager this$0, List list, SensorManager.DynamicSensorCallback dynamicSensorCallback, List list2) {
                                this.this$0 = this$0;
                                this.val$addedList = list;
                                this.val$callback = dynamicSensorCallback;
                                this.val$removedList = list2;
                            }

                            private final void $$robo$$android_hardware_SystemSensorManager_1$run() {
                                for (Sensor s : this.val$addedList) {
                                    this.val$callback.onDynamicSensorConnected(s);
                                }
                                for (Sensor s : this.val$removedList) {
                                    this.val$callback.onDynamicSensorDisconnected(s);
                                }
                            }

                            private void __constructor__(SystemSensorManager systemSensorManager, List list, SensorManager.DynamicSensorCallback dynamicSensorCallback, List list2) {
                                this.$$robo$$android_hardware_SystemSensorManager_1$__constructor__(systemSensorManager, list, dynamicSensorCallback, list2);
                            }
                            {
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_SystemSensorManager_1$__constructor__(android.hardware.SystemSensorManager java.util.List android.hardware.SensorManager$DynamicSensorCallback java.util.List ), this, systemSensorManager, list, dynamicSensorCallback, list2);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_SystemSensorManager_1$run(), this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        });
                    }
                    for (Sensor s : removedList) {
                        this.cleanupSensorConnection(s);
                    }
                }
                this.mDynamicSensorListDirty = false;
            }
        }
    }

    private final void $$robo$$android_hardware_SystemSensorManager$setupDynamicSensorBroadcastReceiver() {
        if (this.mDynamicSensorBroadcastReceiver == null) {
            this.mDynamicSensorBroadcastReceiver = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ SystemSensorManager this$0;

                private void $$robo$$android_hardware_SystemSensorManager_2$__constructor__(SystemSensorManager this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$android_hardware_SystemSensorManager_2$onReceive(Context context, Intent intent) {
                    if (intent.getAction() == "android.intent.action.DYNAMIC_SENSOR_CHANGED") {
                        Log.i("SensorManager", "DYNS received DYNAMIC_SENSOR_CHANED broadcast");
                        this.this$0.mDynamicSensorListDirty = true;
                        this.this$0.updateDynamicSensorList();
                    }
                }

                private void __constructor__(SystemSensorManager systemSensorManager) {
                    this.$$robo$$android_hardware_SystemSensorManager_2$__constructor__(systemSensorManager);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_SystemSensorManager_2$__constructor__(android.hardware.SystemSensorManager ), this, systemSensorManager);
                }

                @Override
                public void onReceive(Context context, Intent intent) {
                    InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_hardware_SystemSensorManager_2$onReceive(android.content.Context android.content.Intent ), this, context, intent);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            IntentFilter filter = new IntentFilter("dynamic_sensor_change");
            filter.addAction("android.intent.action.DYNAMIC_SENSOR_CHANGED");
            this.mContext.registerReceiver(this.mDynamicSensorBroadcastReceiver, filter);
        }
    }

    private final void $$robo$$android_hardware_SystemSensorManager$teardownDynamicSensorBroadcastReceiver() {
        this.mDynamicSensorCallbacks.clear();
        this.mContext.unregisterReceiver(this.mDynamicSensorBroadcastReceiver);
        this.mDynamicSensorBroadcastReceiver = null;
    }

    private final void $$robo$$android_hardware_SystemSensorManager$registerDynamicSensorCallbackImpl(SensorManager.DynamicSensorCallback callback, Handler handler) {
        Log.i("SensorManager", "DYNS Register dynamic sensor callback");
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (this.mDynamicSensorCallbacks.containsKey(callback)) {
            return;
        }
        this.setupDynamicSensorBroadcastReceiver();
        this.mDynamicSensorCallbacks.put(callback, handler);
    }

    private final void $$robo$$android_hardware_SystemSensorManager$unregisterDynamicSensorCallbackImpl(SensorManager.DynamicSensorCallback callback) {
        Log.i("SensorManager", "Removing dynamic sensor listerner");
        this.mDynamicSensorCallbacks.remove(callback);
    }

    private static final boolean $$robo$$android_hardware_SystemSensorManager$diffSortedSensorList(List<Sensor> oldList, List<Sensor> newList, List<Sensor> updated, List<Sensor> added, List<Sensor> removed) {
        boolean changed = false;
        int i = 0;
        int j = 0;
        while (true) {
            if (j < oldList.size() && (i >= newList.size() || newList.get(i).getHandle() > oldList.get(j).getHandle())) {
                changed = true;
                if (removed != null) {
                    removed.add(oldList.get(j));
                }
                ++j;
                continue;
            }
            if (i < newList.size() && (j >= oldList.size() || newList.get(i).getHandle() < oldList.get(j).getHandle())) {
                changed = true;
                if (added != null) {
                    added.add(newList.get(i));
                }
                if (updated != null) {
                    updated.add(newList.get(i));
                }
                ++i;
                continue;
            }
            if (i >= newList.size() || j >= oldList.size() || newList.get(i).getHandle() != oldList.get(j).getHandle()) break;
            if (updated != null) {
                updated.add(oldList.get(j));
            }
            ++i;
            ++j;
        }
        return changed;
    }

    private final int $$robo$$android_hardware_SystemSensorManager$configureDirectChannelImpl(SensorDirectChannel channel, Sensor sensor, int rate) {
        if (!channel.isOpen()) {
            throw new IllegalStateException("channel is closed");
        }
        if (rate < 0 || rate > 3) {
            throw new IllegalArgumentException("rate parameter invalid");
        }
        if (sensor == null && rate != 0) {
            throw new IllegalArgumentException("when sensor is null, rate can only be DIRECT_RATE_STOP");
        }
        int sensorHandle = sensor == null ? -1 : sensor.getHandle();
        int ret = SystemSensorManager.nativeConfigDirectChannel(this.mNativeInstance, channel.getNativeHandle(), sensorHandle, rate);
        if (rate == 0) {
            return ret == 0 ? 1 : 0;
        }
        return ret > 0 ? ret : 0;
    }

    private final SensorDirectChannel $$robo$$android_hardware_SystemSensorManager$createDirectChannelImpl(MemoryFile memoryFile, HardwareBuffer hardwareBuffer) {
        int type;
        int id2;
        long size;
        if (memoryFile != null) {
            int fd;
            try {
                fd = memoryFile.getFileDescriptor().getInt$();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("MemoryFile object is not valid");
            }
            if (memoryFile.length() < 104) {
                throw new IllegalArgumentException("Size of MemoryFile has to be greater than 104");
            }
            size = memoryFile.length();
            id2 = SystemSensorManager.nativeCreateDirectChannel(this.mNativeInstance, size, 1, fd, null);
            if (id2 <= 0) {
                throw new UncheckedIOException(new IOException("create MemoryFile direct channel failed " + id2));
            }
            type = 1;
        } else if (hardwareBuffer != null) {
            if (hardwareBuffer.getFormat() != 33) {
                throw new IllegalArgumentException("Format of HardwareBuffer must be BLOB");
            }
            if (hardwareBuffer.getHeight() != 1) {
                throw new IllegalArgumentException("Height of HardwareBuffer must be 1");
            }
            if (hardwareBuffer.getWidth() < 104) {
                throw new IllegalArgumentException("Width if HaradwareBuffer must be greater than 104");
            }
            if ((hardwareBuffer.getUsage() & 0x800000L) == 0L) {
                throw new IllegalArgumentException("HardwareBuffer must set usage flag USAGE_SENSOR_DIRECT_DATA");
            }
            size = hardwareBuffer.getWidth();
            id2 = SystemSensorManager.nativeCreateDirectChannel(this.mNativeInstance, size, 2, -1, hardwareBuffer);
            if (id2 <= 0) {
                throw new UncheckedIOException(new IOException("create HardwareBuffer direct channel failed " + id2));
            }
            type = 2;
        } else {
            throw new NullPointerException("shared memory object cannot be null");
        }
        return new SensorDirectChannel(this, id2, type, size);
    }

    private final void $$robo$$android_hardware_SystemSensorManager$destroyDirectChannelImpl(SensorDirectChannel channel) {
        if (channel != null) {
            SystemSensorManager.nativeDestroyDirectChannel(this.mNativeInstance, channel.getNativeHandle());
        }
    }

    private final boolean $$robo$$android_hardware_SystemSensorManager$setOperationParameterImpl(SensorAdditionalInfo parameter) {
        int handle = -1;
        if (parameter.sensor != null) {
            handle = parameter.sensor.getHandle();
        }
        return SystemSensorManager.nativeSetOperationParameter(this.mNativeInstance, handle, parameter.type, parameter.floatValues, parameter.intValues) == 0;
    }

    static void __staticInitializer__() {
        sLock = new Object();
        sNativeClassInited = false;
        sInjectEventQueue = null;
    }

    private static void nativeClassInit() {
        InvokeDynamicSupport.bootstrapStatic("nativeClassInit", $$robo$$android_hardware_SystemSensorManager$nativeClassInit());
    }

    private static long nativeCreate(String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreate", $$robo$$android_hardware_SystemSensorManager$nativeCreate(java.lang.String ), (String)string2);
    }

    private static boolean nativeGetSensorAtIndex(long l, Sensor sensor, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeGetSensorAtIndex", $$robo$$android_hardware_SystemSensorManager$nativeGetSensorAtIndex(long android.hardware.Sensor int ), (long)l, (Sensor)sensor, (int)n);
    }

    private static void nativeGetDynamicSensors(long l, List<Sensor> list) {
        InvokeDynamicSupport.bootstrapStatic("nativeGetDynamicSensors", $$robo$$android_hardware_SystemSensorManager$nativeGetDynamicSensors(long java.util.List<android.hardware.Sensor> ), (long)l, list);
    }

    private static boolean nativeIsDataInjectionEnabled(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeIsDataInjectionEnabled", $$robo$$android_hardware_SystemSensorManager$nativeIsDataInjectionEnabled(long ), (long)l);
    }

    private static int nativeCreateDirectChannel(long l, long l2, int n, int n2, HardwareBuffer hardwareBuffer) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeCreateDirectChannel", $$robo$$android_hardware_SystemSensorManager$nativeCreateDirectChannel(long long int int android.hardware.HardwareBuffer ), (long)l, (long)l2, (int)n, (int)n2, (HardwareBuffer)hardwareBuffer);
    }

    private static void nativeDestroyDirectChannel(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeDestroyDirectChannel", $$robo$$android_hardware_SystemSensorManager$nativeDestroyDirectChannel(long int ), (long)l, (int)n);
    }

    private static int nativeConfigDirectChannel(long l, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeConfigDirectChannel", $$robo$$android_hardware_SystemSensorManager$nativeConfigDirectChannel(long int int int ), (long)l, (int)n, (int)n2, (int)n3);
    }

    private static int nativeSetOperationParameter(long l, int n, int n2, float[] fArray, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeSetOperationParameter", $$robo$$android_hardware_SystemSensorManager$nativeSetOperationParameter(long int int float[] int[] ), (long)l, (int)n, (int)n2, (float[])fArray, (int[])nArray);
    }

    private void __constructor__(Context context, Looper looper) {
        this.$$robo$$android_hardware_SystemSensorManager$__constructor__(context, looper);
    }

    public SystemSensorManager(Context context, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_SystemSensorManager$__constructor__(android.content.Context android.os.Looper ), this, context, looper);
    }

    @Override
    protected List<Sensor> getFullSensorList() {
        return InvokeDynamicSupport.bootstrap("getFullSensorList", $$robo$$android_hardware_SystemSensorManager$getFullSensorList(), this);
    }

    @Override
    protected List<Sensor> getFullDynamicSensorList() {
        return InvokeDynamicSupport.bootstrap("getFullDynamicSensorList", $$robo$$android_hardware_SystemSensorManager$getFullDynamicSensorList(), this);
    }

    @Override
    protected boolean registerListenerImpl(SensorEventListener sensorEventListener, Sensor sensor, int n, Handler handler, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerListenerImpl", $$robo$$android_hardware_SystemSensorManager$registerListenerImpl(android.hardware.SensorEventListener android.hardware.Sensor int android.os.Handler int int ), this, sensorEventListener, sensor, n, handler, n2, n3);
    }

    @Override
    protected void unregisterListenerImpl(SensorEventListener sensorEventListener, Sensor sensor) {
        InvokeDynamicSupport.bootstrap("unregisterListenerImpl", $$robo$$android_hardware_SystemSensorManager$unregisterListenerImpl(android.hardware.SensorEventListener android.hardware.Sensor ), this, sensorEventListener, sensor);
    }

    @Override
    protected boolean requestTriggerSensorImpl(TriggerEventListener triggerEventListener, Sensor sensor) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestTriggerSensorImpl", $$robo$$android_hardware_SystemSensorManager$requestTriggerSensorImpl(android.hardware.TriggerEventListener android.hardware.Sensor ), this, triggerEventListener, sensor);
    }

    @Override
    protected boolean cancelTriggerSensorImpl(TriggerEventListener triggerEventListener, Sensor sensor, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("cancelTriggerSensorImpl", $$robo$$android_hardware_SystemSensorManager$cancelTriggerSensorImpl(android.hardware.TriggerEventListener android.hardware.Sensor boolean ), this, triggerEventListener, sensor, bl);
    }

    @Override
    protected boolean flushImpl(SensorEventListener sensorEventListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("flushImpl", $$robo$$android_hardware_SystemSensorManager$flushImpl(android.hardware.SensorEventListener ), this, sensorEventListener);
    }

    @Override
    protected boolean initDataInjectionImpl(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("initDataInjectionImpl", $$robo$$android_hardware_SystemSensorManager$initDataInjectionImpl(boolean ), this, bl);
    }

    @Override
    protected boolean injectSensorDataImpl(Sensor sensor, float[] fArray, int n, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("injectSensorDataImpl", $$robo$$android_hardware_SystemSensorManager$injectSensorDataImpl(android.hardware.Sensor float[] int long ), this, sensor, fArray, n, l);
    }

    private void cleanupSensorConnection(Sensor sensor) {
        InvokeDynamicSupport.bootstrap("cleanupSensorConnection", $$robo$$android_hardware_SystemSensorManager$cleanupSensorConnection(android.hardware.Sensor ), this, sensor);
    }

    private void updateDynamicSensorList() {
        InvokeDynamicSupport.bootstrap("updateDynamicSensorList", $$robo$$android_hardware_SystemSensorManager$updateDynamicSensorList(), this);
    }

    private void setupDynamicSensorBroadcastReceiver() {
        InvokeDynamicSupport.bootstrap("setupDynamicSensorBroadcastReceiver", $$robo$$android_hardware_SystemSensorManager$setupDynamicSensorBroadcastReceiver(), this);
    }

    private void teardownDynamicSensorBroadcastReceiver() {
        InvokeDynamicSupport.bootstrap("teardownDynamicSensorBroadcastReceiver", $$robo$$android_hardware_SystemSensorManager$teardownDynamicSensorBroadcastReceiver(), this);
    }

    @Override
    protected void registerDynamicSensorCallbackImpl(SensorManager.DynamicSensorCallback dynamicSensorCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerDynamicSensorCallbackImpl", $$robo$$android_hardware_SystemSensorManager$registerDynamicSensorCallbackImpl(android.hardware.SensorManager$DynamicSensorCallback android.os.Handler ), this, dynamicSensorCallback, handler);
    }

    @Override
    protected void unregisterDynamicSensorCallbackImpl(SensorManager.DynamicSensorCallback dynamicSensorCallback) {
        InvokeDynamicSupport.bootstrap("unregisterDynamicSensorCallbackImpl", $$robo$$android_hardware_SystemSensorManager$unregisterDynamicSensorCallbackImpl(android.hardware.SensorManager$DynamicSensorCallback ), this, dynamicSensorCallback);
    }

    private static boolean diffSortedSensorList(List<Sensor> list, List<Sensor> list2, List<Sensor> list3, List<Sensor> list4, List<Sensor> list5) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("diffSortedSensorList", $$robo$$android_hardware_SystemSensorManager$diffSortedSensorList(java.util.List<android.hardware.Sensor> java.util.List<android.hardware.Sensor> java.util.List<android.hardware.Sensor> java.util.List<android.hardware.Sensor> java.util.List<android.hardware.Sensor> ), list, list2, list3, list4, list5);
    }

    @Override
    protected int configureDirectChannelImpl(SensorDirectChannel sensorDirectChannel, Sensor sensor, int n) {
        return (int)InvokeDynamicSupport.bootstrap("configureDirectChannelImpl", $$robo$$android_hardware_SystemSensorManager$configureDirectChannelImpl(android.hardware.SensorDirectChannel android.hardware.Sensor int ), this, sensorDirectChannel, sensor, n);
    }

    @Override
    protected SensorDirectChannel createDirectChannelImpl(MemoryFile memoryFile, HardwareBuffer hardwareBuffer) {
        return InvokeDynamicSupport.bootstrap("createDirectChannelImpl", $$robo$$android_hardware_SystemSensorManager$createDirectChannelImpl(android.os.MemoryFile android.hardware.HardwareBuffer ), this, memoryFile, hardwareBuffer);
    }

    @Override
    protected void destroyDirectChannelImpl(SensorDirectChannel sensorDirectChannel) {
        InvokeDynamicSupport.bootstrap("destroyDirectChannelImpl", $$robo$$android_hardware_SystemSensorManager$destroyDirectChannelImpl(android.hardware.SensorDirectChannel ), this, sensorDirectChannel);
    }

    @Override
    protected boolean setOperationParameterImpl(SensorAdditionalInfo sensorAdditionalInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("setOperationParameterImpl", $$robo$$android_hardware_SystemSensorManager$setOperationParameterImpl(android.hardware.SensorAdditionalInfo ), this, sensorAdditionalInfo);
    }

    static {
        RobolectricInternals.classInitializing(SystemSensorManager.class);
    }

    public /* synthetic */ SystemSensorManager() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SystemSensorManager)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class InjectEventQueue
    extends BaseEventQueue
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ SystemSensorManager this$0;

        private void $$robo$$android_hardware_SystemSensorManager_InjectEventQueue$__constructor__(SystemSensorManager this$0, Looper looper, SystemSensorManager manager, String packageName) {
            this.this$0 = this$0;
        }

        private final int $$robo$$android_hardware_SystemSensorManager_InjectEventQueue$injectSensorData(int handle, float[] values, int accuracy, long timestamp) {
            return this.injectSensorDataBase(handle, values, accuracy, timestamp);
        }

        private final void $$robo$$android_hardware_SystemSensorManager_InjectEventQueue$dispatchSensorEvent(int handle, float[] values, int accuracy, long timestamp) {
        }

        private final void $$robo$$android_hardware_SystemSensorManager_InjectEventQueue$dispatchFlushCompleteEvent(int handle) {
        }

        private final void $$robo$$android_hardware_SystemSensorManager_InjectEventQueue$addSensorEvent(Sensor sensor) {
        }

        private final void $$robo$$android_hardware_SystemSensorManager_InjectEventQueue$removeSensorEvent(Sensor sensor) {
        }

        private void __constructor__(SystemSensorManager systemSensorManager, Looper looper, SystemSensorManager systemSensorManager2, String string2) {
            this.$$robo$$android_hardware_SystemSensorManager_InjectEventQueue$__constructor__(systemSensorManager, looper, systemSensorManager2, string2);
        }

        public InjectEventQueue(SystemSensorManager systemSensorManager, Looper looper, SystemSensorManager systemSensorManager2, String string2) {
            super(looper, systemSensorManager2, 1, string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_SystemSensorManager_InjectEventQueue$__constructor__(android.hardware.SystemSensorManager android.os.Looper android.hardware.SystemSensorManager java.lang.String ), this, systemSensorManager, looper, systemSensorManager2, string2);
        }

        int injectSensorData(int n, float[] fArray, int n2, long l) {
            return (int)InvokeDynamicSupport.bootstrap("injectSensorData", $$robo$$android_hardware_SystemSensorManager_InjectEventQueue$injectSensorData(int float[] int long ), this, n, fArray, n2, l);
        }

        @Override
        protected void dispatchSensorEvent(int n, float[] fArray, int n2, long l) {
            InvokeDynamicSupport.bootstrap("dispatchSensorEvent", $$robo$$android_hardware_SystemSensorManager_InjectEventQueue$dispatchSensorEvent(int float[] int long ), this, n, fArray, n2, l);
        }

        @Override
        protected void dispatchFlushCompleteEvent(int n) {
            InvokeDynamicSupport.bootstrap("dispatchFlushCompleteEvent", $$robo$$android_hardware_SystemSensorManager_InjectEventQueue$dispatchFlushCompleteEvent(int ), this, n);
        }

        @Override
        protected void addSensorEvent(Sensor sensor) {
            InvokeDynamicSupport.bootstrap("addSensorEvent", $$robo$$android_hardware_SystemSensorManager_InjectEventQueue$addSensorEvent(android.hardware.Sensor ), this, sensor);
        }

        @Override
        protected void removeSensorEvent(Sensor sensor) {
            InvokeDynamicSupport.bootstrap("removeSensorEvent", $$robo$$android_hardware_SystemSensorManager_InjectEventQueue$removeSensorEvent(android.hardware.Sensor ), this, sensor);
        }

        public /* synthetic */ InjectEventQueue() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InjectEventQueue)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class TriggerEventQueue
    extends BaseEventQueue
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private TriggerEventListener mListener;
        private SparseArray<TriggerEvent> mTriggerEvents;

        private void $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$__constructor__(TriggerEventListener listener, Looper looper, SystemSensorManager manager, String packageName) {
            this.mTriggerEvents = new SparseArray();
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$addSensorEvent(Sensor sensor) {
            TriggerEvent t = new TriggerEvent(Sensor.getMaxLengthValuesArray(sensor, this.mManager.mTargetSdkLevel));
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                this.mTriggerEvents.put(sensor.getHandle(), t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$removeSensorEvent(Sensor sensor) {
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                this.mTriggerEvents.delete(sensor.getHandle());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$dispatchSensorEvent(int handle, float[] values, int accuracy, long timestamp) {
            Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
            if (sensor == null) {
                return;
            }
            TriggerEvent t = null;
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                t = this.mTriggerEvents.get(handle);
            }
            if (t == null) {
                Log.e("SensorManager", "Error: Trigger Event is null for Sensor: " + sensor);
                return;
            }
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)values, (int)0, (Object)t.values, (int)0, (int)t.values.length);
            t.timestamp = timestamp;
            t.sensor = sensor;
            this.mManager.cancelTriggerSensorImpl(this.mListener, sensor, false);
            this.mListener.onTrigger(t);
        }

        private final void $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$dispatchFlushCompleteEvent(int handle) {
        }

        private void __constructor__(TriggerEventListener triggerEventListener, Looper looper, SystemSensorManager systemSensorManager, String string2) {
            this.$$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$__constructor__(triggerEventListener, looper, systemSensorManager, string2);
        }

        public TriggerEventQueue(TriggerEventListener triggerEventListener, Looper looper, SystemSensorManager systemSensorManager, String string2) {
            super(looper, systemSensorManager, 0, string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$__constructor__(android.hardware.TriggerEventListener android.os.Looper android.hardware.SystemSensorManager java.lang.String ), this, triggerEventListener, looper, systemSensorManager, string2);
        }

        @Override
        public void addSensorEvent(Sensor sensor) {
            InvokeDynamicSupport.bootstrap("addSensorEvent", $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$addSensorEvent(android.hardware.Sensor ), this, sensor);
        }

        @Override
        public void removeSensorEvent(Sensor sensor) {
            InvokeDynamicSupport.bootstrap("removeSensorEvent", $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$removeSensorEvent(android.hardware.Sensor ), this, sensor);
        }

        @Override
        protected void dispatchSensorEvent(int n, float[] fArray, int n2, long l) {
            InvokeDynamicSupport.bootstrap("dispatchSensorEvent", $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$dispatchSensorEvent(int float[] int long ), this, n, fArray, n2, l);
        }

        @Override
        protected void dispatchFlushCompleteEvent(int n) {
            InvokeDynamicSupport.bootstrap("dispatchFlushCompleteEvent", $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$dispatchFlushCompleteEvent(int ), this, n);
        }

        public /* synthetic */ TriggerEventQueue() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TriggerEventQueue)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class SensorEventQueue
    extends BaseEventQueue
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private SensorEventListener mListener;
        private SparseArray<SensorEvent> mSensorsEvents;

        private void $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$__constructor__(SensorEventListener listener, Looper looper, SystemSensorManager manager, String packageName) {
            this.mSensorsEvents = new SparseArray();
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$addSensorEvent(Sensor sensor) {
            SensorEvent t = new SensorEvent(Sensor.getMaxLengthValuesArray(sensor, this.mManager.mTargetSdkLevel));
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                this.mSensorsEvents.put(sensor.getHandle(), t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$removeSensorEvent(Sensor sensor) {
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                this.mSensorsEvents.delete(sensor.getHandle());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$dispatchSensorEvent(int handle, float[] values, int inAccuracy, long timestamp) {
            Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
            if (sensor == null) {
                return;
            }
            SensorEvent t = null;
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                t = this.mSensorsEvents.get(handle);
            }
            if (t == null) {
                return;
            }
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)values, (int)0, (Object)t.values, (int)0, (int)t.values.length);
            t.timestamp = timestamp;
            t.accuracy = inAccuracy;
            t.sensor = sensor;
            int accuracy = this.mSensorAccuracies.get(handle);
            if (t.accuracy >= 0 && accuracy != t.accuracy) {
                this.mSensorAccuracies.put(handle, t.accuracy);
                this.mListener.onAccuracyChanged(t.sensor, t.accuracy);
            }
            this.mListener.onSensorChanged(t);
        }

        private final void $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$dispatchFlushCompleteEvent(int handle) {
            if (this.mListener instanceof SensorEventListener2) {
                Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
                if (sensor == null) {
                    return;
                }
                ((SensorEventListener2)this.mListener).onFlushCompleted(sensor);
            }
        }

        private final void $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$dispatchAdditionalInfoEvent(int handle, int type, int serial, float[] floatValues, int[] intValues) {
            if (this.mListener instanceof SensorEventCallback) {
                Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
                if (sensor == null) {
                    return;
                }
                SensorAdditionalInfo info = new SensorAdditionalInfo(sensor, type, serial, intValues, floatValues);
                ((SensorEventCallback)this.mListener).onSensorAdditionalInfo(info);
            }
        }

        private void __constructor__(SensorEventListener sensorEventListener, Looper looper, SystemSensorManager systemSensorManager, String string2) {
            this.$$robo$$android_hardware_SystemSensorManager_SensorEventQueue$__constructor__(sensorEventListener, looper, systemSensorManager, string2);
        }

        public SensorEventQueue(SensorEventListener sensorEventListener, Looper looper, SystemSensorManager systemSensorManager, String string2) {
            super(looper, systemSensorManager, 0, string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$__constructor__(android.hardware.SensorEventListener android.os.Looper android.hardware.SystemSensorManager java.lang.String ), this, sensorEventListener, looper, systemSensorManager, string2);
        }

        @Override
        public void addSensorEvent(Sensor sensor) {
            InvokeDynamicSupport.bootstrap("addSensorEvent", $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$addSensorEvent(android.hardware.Sensor ), this, sensor);
        }

        @Override
        public void removeSensorEvent(Sensor sensor) {
            InvokeDynamicSupport.bootstrap("removeSensorEvent", $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$removeSensorEvent(android.hardware.Sensor ), this, sensor);
        }

        @Override
        protected void dispatchSensorEvent(int n, float[] fArray, int n2, long l) {
            InvokeDynamicSupport.bootstrap("dispatchSensorEvent", $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$dispatchSensorEvent(int float[] int long ), this, n, fArray, n2, l);
        }

        @Override
        protected void dispatchFlushCompleteEvent(int n) {
            InvokeDynamicSupport.bootstrap("dispatchFlushCompleteEvent", $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$dispatchFlushCompleteEvent(int ), this, n);
        }

        @Override
        protected void dispatchAdditionalInfoEvent(int n, int n2, int n3, float[] fArray, int[] nArray) {
            InvokeDynamicSupport.bootstrap("dispatchAdditionalInfoEvent", $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$dispatchAdditionalInfoEvent(int int int float[] int[] ), this, n, n2, n3, fArray, nArray);
        }

        public /* synthetic */ SensorEventQueue() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SensorEventQueue)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class BaseEventQueue
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private long mNativeSensorEventQueue;
        private SparseBooleanArray mActiveSensors;
        protected SparseIntArray mSensorAccuracies;
        private CloseGuard mCloseGuard;
        protected SystemSensorManager mManager;
        protected static int OPERATING_MODE_NORMAL = 0;
        protected static int OPERATING_MODE_DATA_INJECTION = 1;

        private static final long $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeInitBaseEventQueue(long l, WeakReference<BaseEventQueue> weakReference, MessageQueue messageQueue, String string2, int n, String string3) {
            return 0L;
        }

        private static final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeEnableSensor(long l, int n, int n2, int n3) {
            return 0;
        }

        private static final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeDisableSensor(long l, int n) {
            return 0;
        }

        private static final void $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeDestroySensorEventQueue(long l) {
        }

        private static final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeFlushSensor(long l) {
            return 0;
        }

        private static final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeInjectSensorData(long l, int n, float[] fArray, int n2, long l2) {
            return 0;
        }

        private void $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$__constructor__(Looper looper, SystemSensorManager manager, int mode, String packageName) {
            this.mActiveSensors = new SparseBooleanArray();
            this.mSensorAccuracies = new SparseIntArray();
            this.mCloseGuard = CloseGuard.get();
            if (packageName == null) {
                packageName = "";
            }
            this.mNativeSensorEventQueue = BaseEventQueue.nativeInitBaseEventQueue(manager.mNativeInstance, new WeakReference<BaseEventQueue>(this), looper.getQueue(), packageName, mode, manager.mContext.getOpPackageName());
            this.mCloseGuard.open("dispose");
            this.mManager = manager;
        }

        private final void $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$dispose() {
            this.dispose(false);
        }

        private final boolean $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$addSensor(Sensor sensor, int delayUs, int maxBatchReportLatencyUs) {
            int handle = sensor.getHandle();
            if (this.mActiveSensors.get(handle)) {
                return false;
            }
            this.mActiveSensors.put(handle, true);
            this.addSensorEvent(sensor);
            if (this.enableSensor(sensor, delayUs, maxBatchReportLatencyUs) != 0 && (maxBatchReportLatencyUs == 0 || maxBatchReportLatencyUs > 0 && this.enableSensor(sensor, delayUs, 0) != 0)) {
                this.removeSensor(sensor, false);
                return false;
            }
            return true;
        }

        private final boolean $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$removeAllSensors() {
            for (int i = 0; i < this.mActiveSensors.size(); ++i) {
                if (!this.mActiveSensors.valueAt(i)) continue;
                int handle = this.mActiveSensors.keyAt(i);
                Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
                if (sensor == null) continue;
                this.disableSensor(sensor);
                this.mActiveSensors.put(handle, false);
                this.removeSensorEvent(sensor);
            }
            return true;
        }

        private final boolean $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$removeSensor(Sensor sensor, boolean disable) {
            int handle = sensor.getHandle();
            if (this.mActiveSensors.get(handle)) {
                if (disable) {
                    this.disableSensor(sensor);
                }
                this.mActiveSensors.put(sensor.getHandle(), false);
                this.removeSensorEvent(sensor);
                return true;
            }
            return false;
        }

        private final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$flush() {
            if (this.mNativeSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeFlushSensor(this.mNativeSensorEventQueue);
        }

        private final boolean $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$hasSensors() {
            return this.mActiveSensors.indexOfValue(true) >= 0;
        }

        private final void $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$finalize() throws Throwable {
            try {
                this.dispose(true);
            }
            finally {
                super.finalize();
            }
        }

        private final void $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$dispose(boolean finalized) {
            if (this.mCloseGuard != null) {
                if (finalized) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.mCloseGuard.close();
            }
            if (this.mNativeSensorEventQueue != 0L) {
                BaseEventQueue.nativeDestroySensorEventQueue(this.mNativeSensorEventQueue);
                this.mNativeSensorEventQueue = 0L;
            }
        }

        private final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$enableSensor(Sensor sensor, int rateUs, int maxBatchReportLatencyUs) {
            if (this.mNativeSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            if (sensor == null) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeEnableSensor(this.mNativeSensorEventQueue, sensor.getHandle(), rateUs, maxBatchReportLatencyUs);
        }

        private final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$injectSensorDataBase(int handle, float[] values, int accuracy, long timestamp) {
            return BaseEventQueue.nativeInjectSensorData(this.mNativeSensorEventQueue, handle, values, accuracy, timestamp);
        }

        private final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$disableSensor(Sensor sensor) {
            if (this.mNativeSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            if (sensor == null) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeDisableSensor(this.mNativeSensorEventQueue, sensor.getHandle());
        }

        protected abstract void dispatchSensorEvent(int var1, float[] var2, int var3, long var4);

        protected abstract void dispatchFlushCompleteEvent(int var1);

        private final void $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$dispatchAdditionalInfoEvent(int handle, int type, int serial, float[] floatValues, int[] intValues) {
        }

        protected abstract void addSensorEvent(Sensor var1);

        protected abstract void removeSensorEvent(Sensor var1);

        private static long nativeInitBaseEventQueue(long l, WeakReference<BaseEventQueue> weakReference, MessageQueue messageQueue, String string2, int n, String string3) {
            return (long)InvokeDynamicSupport.bootstrapStatic("nativeInitBaseEventQueue", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeInitBaseEventQueue(long java.lang.ref.WeakReference<android.hardware.SystemSensorManager$BaseEventQueue> android.os.MessageQueue java.lang.String int java.lang.String ), (long)l, weakReference, (MessageQueue)messageQueue, (String)string2, (int)n, (String)string3);
        }

        private static int nativeEnableSensor(long l, int n, int n2, int n3) {
            return (int)InvokeDynamicSupport.bootstrapStatic("nativeEnableSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeEnableSensor(long int int int ), (long)l, (int)n, (int)n2, (int)n3);
        }

        private static int nativeDisableSensor(long l, int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("nativeDisableSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeDisableSensor(long int ), (long)l, (int)n);
        }

        private static void nativeDestroySensorEventQueue(long l) {
            InvokeDynamicSupport.bootstrapStatic("nativeDestroySensorEventQueue", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeDestroySensorEventQueue(long ), (long)l);
        }

        private static int nativeFlushSensor(long l) {
            return (int)InvokeDynamicSupport.bootstrapStatic("nativeFlushSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeFlushSensor(long ), (long)l);
        }

        private static int nativeInjectSensorData(long l, int n, float[] fArray, int n2, long l2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("nativeInjectSensorData", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeInjectSensorData(long int float[] int long ), (long)l, (int)n, (float[])fArray, (int)n2, (long)l2);
        }

        private void __constructor__(Looper looper, SystemSensorManager systemSensorManager, int n, String string2) {
            this.$$robo$$android_hardware_SystemSensorManager_BaseEventQueue$__constructor__(looper, systemSensorManager, n, string2);
        }

        public BaseEventQueue(Looper looper, SystemSensorManager systemSensorManager, int n, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$__constructor__(android.os.Looper android.hardware.SystemSensorManager int java.lang.String ), this, looper, systemSensorManager, n, string2);
        }

        public void dispose() {
            InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$dispose(), this);
        }

        public boolean addSensor(Sensor sensor, int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("addSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$addSensor(android.hardware.Sensor int int ), this, sensor, n, n2);
        }

        public boolean removeAllSensors() {
            return (boolean)InvokeDynamicSupport.bootstrap("removeAllSensors", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$removeAllSensors(), this);
        }

        public boolean removeSensor(Sensor sensor, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("removeSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$removeSensor(android.hardware.Sensor boolean ), this, sensor, bl);
        }

        public int flush() {
            return (int)InvokeDynamicSupport.bootstrap("flush", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$flush(), this);
        }

        public boolean hasSensors() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSensors", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$hasSensors(), this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$finalize(), this);
        }

        private void dispose(boolean bl) {
            InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$dispose(boolean ), this, bl);
        }

        private int enableSensor(Sensor sensor, int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("enableSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$enableSensor(android.hardware.Sensor int int ), this, sensor, n, n2);
        }

        protected int injectSensorDataBase(int n, float[] fArray, int n2, long l) {
            return (int)InvokeDynamicSupport.bootstrap("injectSensorDataBase", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$injectSensorDataBase(int float[] int long ), this, n, fArray, n2, l);
        }

        private int disableSensor(Sensor sensor) {
            return (int)InvokeDynamicSupport.bootstrap("disableSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$disableSensor(android.hardware.Sensor ), this, sensor);
        }

        protected void dispatchAdditionalInfoEvent(int n, int n2, int n3, float[] fArray, int[] nArray) {
            InvokeDynamicSupport.bootstrap("dispatchAdditionalInfoEvent", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$dispatchAdditionalInfoEvent(int int int float[] int[] ), this, n, n2, n3, fArray, nArray);
        }

        public /* synthetic */ BaseEventQueue() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseEventQueue)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

