/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.util.AttributeSet;
import android.util.MathUtils;
import android.util.TypedValue;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RotateDrawable
extends DrawableWrapper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int MAX_LEVEL = 10000;
    private RotateState mState;

    private void $$robo$$android_graphics_drawable_RotateDrawable$__constructor__() {
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = RotateDrawable.obtainAttributes(r, theme, attrs, R.styleable.RotateDrawable);
        super.inflate(r, parser, attrs, theme);
        this.updateStateFromTypedArray(a);
        this.verifyRequiredAttributes(a);
        a.recycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_drawable_RotateDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        RotateState state = this.mState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.RotateDrawable);
            try {
                this.updateStateFromTypedArray(a);
                this.verifyRequiredAttributes(a);
            }
            catch (XmlPullParserException e) {
                RotateDrawable.rethrowAsRuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.getDrawable() == null && (this.mState.mThemeAttrs == null || this.mState.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <rotate> tag requires a 'drawable' attribute or child tag defining a drawable");
        }
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$updateStateFromTypedArray(TypedArray a) {
        TypedValue tv;
        RotateState state = this.mState;
        if (state == null) {
            return;
        }
        state.mChangingConfigurations |= a.getChangingConfigurations();
        RotateState.access$002(state, a.extractThemeAttrs());
        if (a.hasValue(4)) {
            tv = a.peekValue(4);
            state.mPivotXRel = tv.type == 6;
            float f = state.mPivotX = state.mPivotXRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        if (a.hasValue(5)) {
            tv = a.peekValue(5);
            state.mPivotYRel = tv.type == 6;
            state.mPivotY = state.mPivotYRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        state.mFromDegrees = a.getFloat(2, state.mFromDegrees);
        state.mToDegrees = a.getFloat(3, state.mToDegrees);
        state.mCurrentDegrees = state.mFromDegrees;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$draw(Canvas canvas) {
        Drawable d = this.getDrawable();
        Rect bounds = d.getBounds();
        int w = bounds.right - bounds.left;
        int h = bounds.bottom - bounds.top;
        RotateState st = this.mState;
        float px = st.mPivotXRel ? (float)w * st.mPivotX : st.mPivotX;
        float py = st.mPivotYRel ? (float)h * st.mPivotY : st.mPivotY;
        int saveCount = canvas.save();
        canvas.rotate(st.mCurrentDegrees, px + (float)bounds.left, py + (float)bounds.top);
        d.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setFromDegrees(float fromDegrees) {
        if (this.mState.mFromDegrees != fromDegrees) {
            this.mState.mFromDegrees = fromDegrees;
            this.invalidateSelf();
        }
    }

    private final float $$robo$$android_graphics_drawable_RotateDrawable$getFromDegrees() {
        return this.mState.mFromDegrees;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setToDegrees(float toDegrees) {
        if (this.mState.mToDegrees != toDegrees) {
            this.mState.mToDegrees = toDegrees;
            this.invalidateSelf();
        }
    }

    private final float $$robo$$android_graphics_drawable_RotateDrawable$getToDegrees() {
        return this.mState.mToDegrees;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setPivotX(float pivotX) {
        if (this.mState.mPivotX != pivotX) {
            this.mState.mPivotX = pivotX;
            this.invalidateSelf();
        }
    }

    private final float $$robo$$android_graphics_drawable_RotateDrawable$getPivotX() {
        return this.mState.mPivotX;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setPivotXRelative(boolean relative) {
        if (this.mState.mPivotXRel != relative) {
            this.mState.mPivotXRel = relative;
            this.invalidateSelf();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_RotateDrawable$isPivotXRelative() {
        return this.mState.mPivotXRel;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setPivotY(float pivotY) {
        if (this.mState.mPivotY != pivotY) {
            this.mState.mPivotY = pivotY;
            this.invalidateSelf();
        }
    }

    private final float $$robo$$android_graphics_drawable_RotateDrawable$getPivotY() {
        return this.mState.mPivotY;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setPivotYRelative(boolean relative) {
        if (this.mState.mPivotYRel != relative) {
            this.mState.mPivotYRel = relative;
            this.invalidateSelf();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_RotateDrawable$isPivotYRelative() {
        return this.mState.mPivotYRel;
    }

    private final boolean $$robo$$android_graphics_drawable_RotateDrawable$onLevelChange(int level) {
        float degrees;
        super.onLevelChange(level);
        float value = (float)level / 10000.0f;
        this.mState.mCurrentDegrees = degrees = MathUtils.lerp(this.mState.mFromDegrees, this.mState.mToDegrees, value);
        this.invalidateSelf();
        return true;
    }

    private final DrawableWrapper.DrawableWrapperState $$robo$$android_graphics_drawable_RotateDrawable$mutateConstantState() {
        this.mState = new RotateState(this.mState, null);
        return this.mState;
    }

    private void $$robo$$android_graphics_drawable_RotateDrawable$__constructor__(RotateState state, Resources res) {
        this.mState = state;
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_RotateDrawable$__constructor__(RotateState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_RotateDrawable$__constructor__();
    }

    public RotateDrawable() {
        this(new RotateState(null, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RotateDrawable$__constructor__(), this);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_RotateDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_RotateDrawable$applyTheme(android.content.res.Resources$Theme ), this, theme);
    }

    private void verifyRequiredAttributes(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("verifyRequiredAttributes", $$robo$$android_graphics_drawable_RotateDrawable$verifyRequiredAttributes(android.content.res.TypedArray ), this, typedArray);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_RotateDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), this, typedArray);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_RotateDrawable$draw(android.graphics.Canvas ), this, canvas);
    }

    public void setFromDegrees(float f) {
        InvokeDynamicSupport.bootstrap("setFromDegrees", $$robo$$android_graphics_drawable_RotateDrawable$setFromDegrees(float ), this, f);
    }

    public float getFromDegrees() {
        return (float)InvokeDynamicSupport.bootstrap("getFromDegrees", $$robo$$android_graphics_drawable_RotateDrawable$getFromDegrees(), this);
    }

    public void setToDegrees(float f) {
        InvokeDynamicSupport.bootstrap("setToDegrees", $$robo$$android_graphics_drawable_RotateDrawable$setToDegrees(float ), this, f);
    }

    public float getToDegrees() {
        return (float)InvokeDynamicSupport.bootstrap("getToDegrees", $$robo$$android_graphics_drawable_RotateDrawable$getToDegrees(), this);
    }

    public void setPivotX(float f) {
        InvokeDynamicSupport.bootstrap("setPivotX", $$robo$$android_graphics_drawable_RotateDrawable$setPivotX(float ), this, f);
    }

    public float getPivotX() {
        return (float)InvokeDynamicSupport.bootstrap("getPivotX", $$robo$$android_graphics_drawable_RotateDrawable$getPivotX(), this);
    }

    public void setPivotXRelative(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPivotXRelative", $$robo$$android_graphics_drawable_RotateDrawable$setPivotXRelative(boolean ), this, bl);
    }

    public boolean isPivotXRelative() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPivotXRelative", $$robo$$android_graphics_drawable_RotateDrawable$isPivotXRelative(), this);
    }

    public void setPivotY(float f) {
        InvokeDynamicSupport.bootstrap("setPivotY", $$robo$$android_graphics_drawable_RotateDrawable$setPivotY(float ), this, f);
    }

    public float getPivotY() {
        return (float)InvokeDynamicSupport.bootstrap("getPivotY", $$robo$$android_graphics_drawable_RotateDrawable$getPivotY(), this);
    }

    public void setPivotYRelative(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPivotYRelative", $$robo$$android_graphics_drawable_RotateDrawable$setPivotYRelative(boolean ), this, bl);
    }

    public boolean isPivotYRelative() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPivotYRelative", $$robo$$android_graphics_drawable_RotateDrawable$isPivotYRelative(), this);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_RotateDrawable$onLevelChange(int ), this, n);
    }

    @Override
    DrawableWrapper.DrawableWrapperState mutateConstantState() {
        return InvokeDynamicSupport.bootstrap("mutateConstantState", $$robo$$android_graphics_drawable_RotateDrawable$mutateConstantState(), this);
    }

    private void __constructor__(RotateState rotateState, Resources resources) {
        this.$$robo$$android_graphics_drawable_RotateDrawable$__constructor__(rotateState, resources);
    }

    public RotateDrawable(RotateState rotateState, Resources resources) {
        super(rotateState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RotateDrawable$__constructor__(android.graphics.drawable.RotateDrawable$RotateState android.content.res.Resources ), this, rotateState, resources);
    }

    private /* synthetic */ void __constructor__(RotateState rotateState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_RotateDrawable$__constructor__(rotateState, resources, var3_3);
    }

    public /* synthetic */ RotateDrawable(RotateState rotateState, Resources resources, 1 var3_3) {
        this(rotateState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RotateDrawable$__constructor__(android.graphics.drawable.RotateDrawable$RotateState android.content.res.Resources android.graphics.drawable.RotateDrawable$1 ), this, rotateState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RotateDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class RotateState
    extends DrawableWrapper.DrawableWrapperState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int[] mThemeAttrs;
        boolean mPivotXRel;
        float mPivotX;
        boolean mPivotYRel;
        float mPivotY;
        float mFromDegrees;
        float mToDegrees;
        float mCurrentDegrees;

        private void $$robo$$android_graphics_drawable_RotateDrawable_RotateState$__constructor__(RotateState orig, Resources res) {
            this.mPivotXRel = true;
            this.mPivotX = 0.5f;
            this.mPivotYRel = true;
            this.mPivotY = 0.5f;
            this.mFromDegrees = 0.0f;
            this.mToDegrees = 360.0f;
            this.mCurrentDegrees = 0.0f;
            if (orig != null) {
                this.mPivotXRel = orig.mPivotXRel;
                this.mPivotX = orig.mPivotX;
                this.mPivotYRel = orig.mPivotYRel;
                this.mPivotY = orig.mPivotY;
                this.mFromDegrees = orig.mFromDegrees;
                this.mToDegrees = orig.mToDegrees;
                this.mCurrentDegrees = orig.mCurrentDegrees;
            }
        }

        private final Drawable $$robo$$android_graphics_drawable_RotateDrawable_RotateState$newDrawable(Resources res) {
            return new RotateDrawable(this, res, null);
        }

        static /* synthetic */ int[] access$002(RotateState x0, int[] x1) {
            x0.mThemeAttrs = x1;
            return x1;
        }

        private void __constructor__(RotateState rotateState, Resources resources) {
            this.$$robo$$android_graphics_drawable_RotateDrawable_RotateState$__constructor__(rotateState, resources);
        }

        public RotateState(RotateState rotateState, Resources resources) {
            super(rotateState, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RotateDrawable_RotateState$__constructor__(android.graphics.drawable.RotateDrawable$RotateState android.content.res.Resources ), this, rotateState, resources);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_RotateDrawable_RotateState$newDrawable(android.content.res.Resources ), this, resources);
        }

        public /* synthetic */ RotateState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RotateState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

