/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleBackground;
import android.graphics.drawable.RippleForeground;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RippleDrawable
extends LayerDrawable
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int RADIUS_AUTO = -1;
    private static int MASK_UNKNOWN = -1;
    private static int MASK_NONE = 0;
    private static int MASK_CONTENT = 1;
    private static int MASK_EXPLICIT = 2;
    private static int MAX_RIPPLES = 10;
    private Rect mTempRect;
    private Rect mHotspotBounds;
    private Rect mDrawingBounds;
    private Rect mDirtyBounds;
    private RippleState mState;
    private Drawable mMask;
    private RippleBackground mBackground;
    private Bitmap mMaskBuffer;
    private BitmapShader mMaskShader;
    private Canvas mMaskCanvas;
    private Matrix mMaskMatrix;
    private PorterDuffColorFilter mMaskColorFilter;
    private boolean mHasValidMask;
    private RippleForeground mRipple;
    private boolean mRippleActive;
    private float mPendingX;
    private float mPendingY;
    private boolean mHasPending;
    private RippleForeground[] mExitingRipples;
    private int mExitingRipplesCount;
    private Paint mRipplePaint;
    private int mDensity;
    private boolean mOverrideBounds;
    private boolean mForceSoftware;

    private void $$robo$$android_graphics_drawable_RippleDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_RippleDrawable$__constructor__(ColorStateList color2, Drawable content, Drawable mask) {
        if (color2 == null) {
            throw new IllegalArgumentException("RippleDrawable requires a non-null color");
        }
        if (content != null) {
            this.addLayer(content, null, 0, 0, 0, 0, 0);
        }
        if (mask != null) {
            this.addLayer(mask, null, 16908334, 0, 0, 0, 0);
        }
        this.setColor(color2);
        this.ensurePadding();
        this.refreshPadding();
        this.updateLocalState();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mRipple != null) {
            this.mRipple.end();
        }
        if (this.mBackground != null) {
            this.mBackground.jumpToFinal();
        }
        this.cancelExitingRipples();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$cancelExitingRipples() {
        int count = this.mExitingRipplesCount;
        Object[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].end();
        }
        if (ripples != null) {
            Arrays.fill(ripples, 0, count, null);
        }
        this.mExitingRipplesCount = 0;
        this.invalidateSelf(false);
    }

    private final int $$robo$$android_graphics_drawable_RippleDrawable$getOpacity() {
        return -3;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$onStateChange(int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        boolean enabled = false;
        boolean pressed = false;
        boolean focused = false;
        boolean hovered = false;
        for (int state : stateSet) {
            if (state == 16842910) {
                enabled = true;
                continue;
            }
            if (state == 16842908) {
                focused = true;
                continue;
            }
            if (state == 16842919) {
                pressed = true;
                continue;
            }
            if (state != 16843623) continue;
            hovered = true;
        }
        this.setRippleActive(enabled && pressed);
        this.setBackgroundActive(hovered, focused, pressed);
        return changed;
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setRippleActive(boolean active) {
        if (this.mRippleActive != active) {
            this.mRippleActive = active;
            if (active) {
                this.tryRippleEnter();
            } else {
                this.tryRippleExit();
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setBackgroundActive(boolean hovered, boolean focused, boolean pressed) {
        if (this.mBackground == null && (hovered || focused)) {
            this.mBackground = new RippleBackground(this, this.mHotspotBounds, this.isBounded());
            this.mBackground.setup(this.mState.mMaxRadius, this.mDensity);
        }
        if (this.mBackground != null) {
            this.mBackground.setState(focused, hovered, pressed);
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (!this.mOverrideBounds) {
            this.mHotspotBounds.set(bounds);
            this.onHotspotBoundsChanged();
        }
        int count = this.mExitingRipplesCount;
        RippleForeground[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].onBoundsChange();
        }
        if (this.mBackground != null) {
            this.mBackground.onBoundsChange();
        }
        if (this.mRipple != null) {
            this.mRipple.onBoundsChange();
        }
        this.invalidateSelf();
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (!visible) {
            this.clearHotspots();
        } else if (changed) {
            if (this.mRippleActive) {
                this.tryRippleEnter();
            }
            this.jumpToCurrentState();
        }
        return changed;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$isProjected() {
        if (this.isBounded()) {
            return false;
        }
        int radius = this.mState.mMaxRadius;
        Rect drawableBounds = this.getBounds();
        Rect hotspotBounds = this.mHotspotBounds;
        return radius == -1 || radius > hotspotBounds.width() / 2 || radius > hotspotBounds.height() / 2 || !drawableBounds.equals(hotspotBounds) && !drawableBounds.contains(hotspotBounds);
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$isBounded() {
        return this.getNumberOfLayers() > 0;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$isStateful() {
        return true;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$hasFocusStateSpecified() {
        return true;
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setColor(ColorStateList color2) {
        this.mState.mColor = color2;
        this.invalidateSelf(false);
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setRadius(int radius) {
        this.mState.mMaxRadius = radius;
        this.invalidateSelf(false);
    }

    private final int $$robo$$android_graphics_drawable_RippleDrawable$getRadius() {
        return this.mState.mMaxRadius;
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = RippleDrawable.obtainAttributes(r, theme, attrs, R.styleable.RippleDrawable);
        this.setPaddingMode(1);
        super.inflate(r, parser, attrs, theme);
        this.updateStateFromTypedArray(a);
        this.verifyRequiredAttributes(a);
        a.recycle();
        this.updateLocalState();
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$setDrawableByLayerId(int id2, Drawable drawable2) {
        if (super.setDrawableByLayerId(id2, drawable2)) {
            if (id2 == 16908334) {
                this.mMask = drawable2;
                this.mHasValidMask = false;
            }
            return true;
        }
        return false;
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setPaddingMode(int mode) {
        super.setPaddingMode(mode);
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$updateStateFromTypedArray(TypedArray a) throws XmlPullParserException {
        RippleState state = this.mState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mTouchThemeAttrs = a.extractThemeAttrs();
        ColorStateList color2 = a.getColorStateList(0);
        if (color2 != null) {
            this.mState.mColor = color2;
        }
        this.mState.mMaxRadius = a.getDimensionPixelSize(1, this.mState.mMaxRadius);
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.mState.mColor == null && (this.mState.mTouchThemeAttrs == null || this.mState.mTouchThemeAttrs[0] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <ripple> requires a valid color attribute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_drawable_RippleDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        RippleState state = this.mState;
        if (state == null) {
            return;
        }
        if (state.mTouchThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mTouchThemeAttrs, R.styleable.RippleDrawable);
            try {
                this.updateStateFromTypedArray(a);
                this.verifyRequiredAttributes(a);
            }
            catch (XmlPullParserException e) {
                RippleDrawable.rethrowAsRuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
        if (state.mColor != null && state.mColor.canApplyTheme()) {
            state.mColor = state.mColor.obtainForTheme(t);
        }
        this.updateLocalState();
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$canApplyTheme() {
        return this.mState != null && this.mState.canApplyTheme() || super.canApplyTheme();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setHotspot(float x, float y) {
        if (this.mRipple == null || this.mBackground == null) {
            this.mPendingX = x;
            this.mPendingY = y;
            this.mHasPending = true;
        }
        if (this.mRipple != null) {
            this.mRipple.move(x, y);
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$tryRippleEnter() {
        if (this.mExitingRipplesCount >= 10) {
            return;
        }
        if (this.mRipple == null) {
            float y;
            float x;
            if (this.mHasPending) {
                this.mHasPending = false;
                x = this.mPendingX;
                y = this.mPendingY;
            } else {
                x = this.mHotspotBounds.exactCenterX();
                y = this.mHotspotBounds.exactCenterY();
            }
            this.mRipple = new RippleForeground(this, this.mHotspotBounds, x, y, this.mForceSoftware);
        }
        this.mRipple.setup(this.mState.mMaxRadius, this.mDensity);
        this.mRipple.enter();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$tryRippleExit() {
        if (this.mRipple != null) {
            if (this.mExitingRipples == null) {
                this.mExitingRipples = new RippleForeground[10];
            }
            this.mExitingRipples[this.mExitingRipplesCount++] = this.mRipple;
            this.mRipple.exit();
            this.mRipple = null;
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$clearHotspots() {
        if (this.mRipple != null) {
            this.mRipple.end();
            this.mRipple = null;
            this.mRippleActive = false;
        }
        if (this.mBackground != null) {
            this.mBackground.setState(false, false, false);
        }
        this.cancelExitingRipples();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setHotspotBounds(int left, int top, int right, int bottom) {
        this.mOverrideBounds = true;
        this.mHotspotBounds.set(left, top, right, bottom);
        this.onHotspotBoundsChanged();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$getHotspotBounds(Rect outRect) {
        outRect.set(this.mHotspotBounds);
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$onHotspotBoundsChanged() {
        int count = this.mExitingRipplesCount;
        RippleForeground[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].onHotspotBoundsChanged();
        }
        if (this.mRipple != null) {
            this.mRipple.onHotspotBoundsChanged();
        }
        if (this.mBackground != null) {
            this.mBackground.onHotspotBoundsChanged();
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$getOutline(Outline outline) {
        LayerDrawable.LayerState state = this.mLayerState;
        LayerDrawable.ChildDrawable[] children = state.mChildren;
        int N = state.mNumChildren;
        for (int i = 0; i < N; ++i) {
            if (children[i].mId == 16908334) continue;
            children[i].mDrawable.getOutline(outline);
            if (outline.isEmpty()) continue;
            return;
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$draw(Canvas canvas) {
        this.pruneRipples();
        Rect bounds = this.getDirtyBounds();
        int saveCount = canvas.save(2);
        if (this.isBounded()) {
            canvas.clipRect(bounds);
        }
        this.drawContent(canvas);
        this.drawBackgroundAndRipples(canvas);
        canvas.restoreToCount(saveCount);
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$invalidateSelf() {
        this.invalidateSelf(true);
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$invalidateSelf(boolean invalidateMask) {
        super.invalidateSelf();
        if (invalidateMask) {
            this.mHasValidMask = false;
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$pruneRipples() {
        int i;
        int remaining = 0;
        RippleForeground[] ripples = this.mExitingRipples;
        int count = this.mExitingRipplesCount;
        for (i = 0; i < count; ++i) {
            if (ripples[i].hasFinishedExit()) continue;
            ripples[remaining++] = ripples[i];
        }
        for (i = remaining; i < count; ++i) {
            ripples[i] = null;
        }
        this.mExitingRipplesCount = remaining;
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$updateMaskShaderIfNeeded() {
        if (this.mHasValidMask) {
            return;
        }
        int maskType = this.getMaskType();
        if (maskType == -1) {
            return;
        }
        this.mHasValidMask = true;
        Rect bounds = this.getBounds();
        if (maskType == 0 || bounds.isEmpty()) {
            if (this.mMaskBuffer != null) {
                this.mMaskBuffer.recycle();
                this.mMaskBuffer = null;
                this.mMaskShader = null;
                this.mMaskCanvas = null;
            }
            this.mMaskMatrix = null;
            this.mMaskColorFilter = null;
            return;
        }
        if (this.mMaskBuffer == null || this.mMaskBuffer.getWidth() != bounds.width() || this.mMaskBuffer.getHeight() != bounds.height()) {
            if (this.mMaskBuffer != null) {
                this.mMaskBuffer.recycle();
            }
            this.mMaskBuffer = Bitmap.createBitmap(bounds.width(), bounds.height(), Bitmap.Config.ALPHA_8);
            this.mMaskShader = new BitmapShader(this.mMaskBuffer, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mMaskCanvas = new Canvas(this.mMaskBuffer);
        } else {
            this.mMaskBuffer.eraseColor(0);
        }
        if (this.mMaskMatrix == null) {
            this.mMaskMatrix = new Matrix();
        } else {
            this.mMaskMatrix.reset();
        }
        if (this.mMaskColorFilter == null) {
            this.mMaskColorFilter = new PorterDuffColorFilter(0, PorterDuff.Mode.SRC_IN);
        }
        int left = bounds.left;
        int top = bounds.top;
        this.mMaskCanvas.translate(-left, -top);
        if (maskType == 2) {
            this.drawMask(this.mMaskCanvas);
        } else if (maskType == 1) {
            this.drawContent(this.mMaskCanvas);
        }
        this.mMaskCanvas.translate(left, top);
    }

    private final int $$robo$$android_graphics_drawable_RippleDrawable$getMaskType() {
        if (!(this.mRipple != null || this.mExitingRipplesCount > 0 || this.mBackground != null && this.mBackground.isVisible())) {
            return -1;
        }
        if (this.mMask != null) {
            if (this.mMask.getOpacity() == -1) {
                return 0;
            }
            return 2;
        }
        LayerDrawable.ChildDrawable[] array2 = this.mLayerState.mChildren;
        int count = this.mLayerState.mNumChildren;
        for (int i = 0; i < count; ++i) {
            if (array2[i].mDrawable.getOpacity() == -1) continue;
            return 1;
        }
        return 0;
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$drawContent(Canvas canvas) {
        LayerDrawable.ChildDrawable[] array2 = this.mLayerState.mChildren;
        int count = this.mLayerState.mNumChildren;
        for (int i = 0; i < count; ++i) {
            if (array2[i].mId == 16908334) continue;
            array2[i].mDrawable.draw(canvas);
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$drawBackgroundAndRipples(Canvas canvas) {
        RippleForeground active = this.mRipple;
        RippleBackground background = this.mBackground;
        int count = this.mExitingRipplesCount;
        if (!(active != null || count > 0 || background != null && background.isVisible())) {
            return;
        }
        float x = this.mHotspotBounds.exactCenterX();
        float y = this.mHotspotBounds.exactCenterY();
        canvas.translate(x, y);
        Paint p = this.getRipplePaint();
        if (background != null && background.isVisible()) {
            background.draw(canvas, p);
        }
        if (count > 0) {
            RippleForeground[] ripples = this.mExitingRipples;
            for (int i = 0; i < count; ++i) {
                ripples[i].draw(canvas, p);
            }
        }
        if (active != null) {
            active.draw(canvas, p);
        }
        canvas.translate(-x, -y);
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$drawMask(Canvas canvas) {
        this.mMask.draw(canvas);
    }

    private final Paint $$robo$$android_graphics_drawable_RippleDrawable$getRipplePaint() {
        int color2;
        if (this.mRipplePaint == null) {
            this.mRipplePaint = new Paint();
            this.mRipplePaint.setAntiAlias(true);
            this.mRipplePaint.setStyle(Paint.Style.FILL);
        }
        float x = this.mHotspotBounds.exactCenterX();
        float y = this.mHotspotBounds.exactCenterY();
        this.updateMaskShaderIfNeeded();
        if (this.mMaskShader != null) {
            Rect bounds = this.getBounds();
            this.mMaskMatrix.setTranslate((float)bounds.left - x, (float)bounds.top - y);
            this.mMaskShader.setLocalMatrix(this.mMaskMatrix);
        }
        if (Color.alpha(color2 = this.mState.mColor.getColorForState(this.getState(), -16777216)) > 128) {
            color2 = color2 & 0xFFFFFF | Integer.MIN_VALUE;
        }
        Paint p = this.mRipplePaint;
        if (this.mMaskColorFilter != null) {
            this.mMaskColorFilter.setColor(color2 | 0xFF000000);
            p.setColor(color2 & 0xFF000000);
            p.setColorFilter(this.mMaskColorFilter);
            p.setShader(this.mMaskShader);
        } else {
            p.setColor(color2);
            p.setColorFilter(null);
            p.setShader(null);
        }
        return p;
    }

    private final Rect $$robo$$android_graphics_drawable_RippleDrawable$getDirtyBounds() {
        if (!this.isBounded()) {
            Rect drawingBounds = this.mDrawingBounds;
            Rect dirtyBounds = this.mDirtyBounds;
            dirtyBounds.set(drawingBounds);
            drawingBounds.setEmpty();
            int cX = (int)this.mHotspotBounds.exactCenterX();
            int cY = (int)this.mHotspotBounds.exactCenterY();
            Rect rippleBounds = this.mTempRect;
            RippleForeground[] activeRipples = this.mExitingRipples;
            int N = this.mExitingRipplesCount;
            for (int i = 0; i < N; ++i) {
                activeRipples[i].getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            RippleBackground background = this.mBackground;
            if (background != null) {
                background.getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            dirtyBounds.union(drawingBounds);
            dirtyBounds.union(super.getDirtyBounds());
            return dirtyBounds;
        }
        return this.getBounds();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setForceSoftware(boolean forceSoftware) {
        this.mForceSoftware = forceSoftware;
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_RippleDrawable$getConstantState() {
        return this.mState;
    }

    private final Drawable $$robo$$android_graphics_drawable_RippleDrawable$mutate() {
        super.mutate();
        this.mState = (RippleState)this.mLayerState;
        this.mMask = this.findDrawableByLayerId(16908334);
        return this;
    }

    private final RippleState $$robo$$android_graphics_drawable_RippleDrawable$createConstantState(LayerDrawable.LayerState state, Resources res) {
        return new RippleState(state, this, res);
    }

    private void $$robo$$android_graphics_drawable_RippleDrawable$__constructor__(RippleState state, Resources res) {
        this.mTempRect = new Rect();
        this.mHotspotBounds = new Rect();
        this.mDrawingBounds = new Rect();
        this.mDirtyBounds = new Rect();
        this.mExitingRipplesCount = 0;
        this.mState = new RippleState((LayerDrawable.LayerState)state, this, res);
        this.mLayerState = this.mState;
        this.mDensity = Drawable.resolveDensity(res, this.mState.mDensity);
        if (this.mState.mNumChildren > 0) {
            this.ensurePadding();
            this.refreshPadding();
        }
        this.updateLocalState();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$updateLocalState() {
        this.mMask = this.findDrawableByLayerId(16908334);
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_RippleDrawable$__constructor__(RippleState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_RippleDrawable$__constructor__();
    }

    public RippleDrawable() {
        this(new RippleState(null, null, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleDrawable$__constructor__(), this);
    }

    private void __constructor__(ColorStateList colorStateList, Drawable drawable2, Drawable drawable3) {
        this.$$robo$$android_graphics_drawable_RippleDrawable$__constructor__(colorStateList, drawable2, drawable3);
    }

    public RippleDrawable(ColorStateList colorStateList, Drawable drawable2, Drawable drawable3) {
        this(new RippleState(null, null, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleDrawable$__constructor__(android.content.res.ColorStateList android.graphics.drawable.Drawable android.graphics.drawable.Drawable ), this, colorStateList, drawable2, drawable3);
    }

    @Override
    public void jumpToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpToCurrentState", $$robo$$android_graphics_drawable_RippleDrawable$jumpToCurrentState(), this);
    }

    private void cancelExitingRipples() {
        InvokeDynamicSupport.bootstrap("cancelExitingRipples", $$robo$$android_graphics_drawable_RippleDrawable$cancelExitingRipples(), this);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_RippleDrawable$getOpacity(), this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_RippleDrawable$onStateChange(int[] ), this, nArray);
    }

    private void setRippleActive(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRippleActive", $$robo$$android_graphics_drawable_RippleDrawable$setRippleActive(boolean ), this, bl);
    }

    private void setBackgroundActive(boolean bl, boolean bl2, boolean bl3) {
        InvokeDynamicSupport.bootstrap("setBackgroundActive", $$robo$$android_graphics_drawable_RippleDrawable$setBackgroundActive(boolean boolean boolean ), this, bl, bl2, bl3);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_RippleDrawable$onBoundsChange(android.graphics.Rect ), this, rect);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_RippleDrawable$setVisible(boolean boolean ), this, bl, bl2);
    }

    @Override
    public boolean isProjected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProjected", $$robo$$android_graphics_drawable_RippleDrawable$isProjected(), this);
    }

    private boolean isBounded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBounded", $$robo$$android_graphics_drawable_RippleDrawable$isBounded(), this);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_RippleDrawable$isStateful(), this);
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_RippleDrawable$hasFocusStateSpecified(), this);
    }

    public void setColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_graphics_drawable_RippleDrawable$setColor(android.content.res.ColorStateList ), this, colorStateList);
    }

    public void setRadius(int n) {
        InvokeDynamicSupport.bootstrap("setRadius", $$robo$$android_graphics_drawable_RippleDrawable$setRadius(int ), this, n);
    }

    public int getRadius() {
        return (int)InvokeDynamicSupport.bootstrap("getRadius", $$robo$$android_graphics_drawable_RippleDrawable$getRadius(), this);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_RippleDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public boolean setDrawableByLayerId(int n, Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDrawableByLayerId", $$robo$$android_graphics_drawable_RippleDrawable$setDrawableByLayerId(int android.graphics.drawable.Drawable ), this, n, drawable2);
    }

    @Override
    public void setPaddingMode(int n) {
        InvokeDynamicSupport.bootstrap("setPaddingMode", $$robo$$android_graphics_drawable_RippleDrawable$setPaddingMode(int ), this, n);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_RippleDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), this, typedArray);
    }

    private void verifyRequiredAttributes(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("verifyRequiredAttributes", $$robo$$android_graphics_drawable_RippleDrawable$verifyRequiredAttributes(android.content.res.TypedArray ), this, typedArray);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_RippleDrawable$applyTheme(android.content.res.Resources$Theme ), this, theme);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_RippleDrawable$canApplyTheme(), this);
    }

    @Override
    public void setHotspot(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setHotspot", $$robo$$android_graphics_drawable_RippleDrawable$setHotspot(float float ), this, f, f2);
    }

    private void tryRippleEnter() {
        InvokeDynamicSupport.bootstrap("tryRippleEnter", $$robo$$android_graphics_drawable_RippleDrawable$tryRippleEnter(), this);
    }

    private void tryRippleExit() {
        InvokeDynamicSupport.bootstrap("tryRippleExit", $$robo$$android_graphics_drawable_RippleDrawable$tryRippleExit(), this);
    }

    private void clearHotspots() {
        InvokeDynamicSupport.bootstrap("clearHotspots", $$robo$$android_graphics_drawable_RippleDrawable$clearHotspots(), this);
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setHotspotBounds", $$robo$$android_graphics_drawable_RippleDrawable$setHotspotBounds(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    public void getHotspotBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getHotspotBounds", $$robo$$android_graphics_drawable_RippleDrawable$getHotspotBounds(android.graphics.Rect ), this, rect);
    }

    private void onHotspotBoundsChanged() {
        InvokeDynamicSupport.bootstrap("onHotspotBoundsChanged", $$robo$$android_graphics_drawable_RippleDrawable$onHotspotBoundsChanged(), this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_RippleDrawable$getOutline(android.graphics.Outline ), this, outline);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_RippleDrawable$draw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    public void invalidateSelf() {
        InvokeDynamicSupport.bootstrap("invalidateSelf", $$robo$$android_graphics_drawable_RippleDrawable$invalidateSelf(), this);
    }

    void invalidateSelf(boolean bl) {
        InvokeDynamicSupport.bootstrap("invalidateSelf", $$robo$$android_graphics_drawable_RippleDrawable$invalidateSelf(boolean ), this, bl);
    }

    private void pruneRipples() {
        InvokeDynamicSupport.bootstrap("pruneRipples", $$robo$$android_graphics_drawable_RippleDrawable$pruneRipples(), this);
    }

    private void updateMaskShaderIfNeeded() {
        InvokeDynamicSupport.bootstrap("updateMaskShaderIfNeeded", $$robo$$android_graphics_drawable_RippleDrawable$updateMaskShaderIfNeeded(), this);
    }

    private int getMaskType() {
        return (int)InvokeDynamicSupport.bootstrap("getMaskType", $$robo$$android_graphics_drawable_RippleDrawable$getMaskType(), this);
    }

    private void drawContent(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawContent", $$robo$$android_graphics_drawable_RippleDrawable$drawContent(android.graphics.Canvas ), this, canvas);
    }

    private void drawBackgroundAndRipples(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawBackgroundAndRipples", $$robo$$android_graphics_drawable_RippleDrawable$drawBackgroundAndRipples(android.graphics.Canvas ), this, canvas);
    }

    private void drawMask(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawMask", $$robo$$android_graphics_drawable_RippleDrawable$drawMask(android.graphics.Canvas ), this, canvas);
    }

    Paint getRipplePaint() {
        return InvokeDynamicSupport.bootstrap("getRipplePaint", $$robo$$android_graphics_drawable_RippleDrawable$getRipplePaint(), this);
    }

    @Override
    public Rect getDirtyBounds() {
        return InvokeDynamicSupport.bootstrap("getDirtyBounds", $$robo$$android_graphics_drawable_RippleDrawable$getDirtyBounds(), this);
    }

    public void setForceSoftware(boolean bl) {
        InvokeDynamicSupport.bootstrap("setForceSoftware", $$robo$$android_graphics_drawable_RippleDrawable$setForceSoftware(boolean ), this, bl);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_RippleDrawable$getConstantState(), this);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_RippleDrawable$mutate(), this);
    }

    @Override
    RippleState createConstantState(LayerDrawable.LayerState layerState, Resources resources) {
        return InvokeDynamicSupport.bootstrap("createConstantState", $$robo$$android_graphics_drawable_RippleDrawable$createConstantState(android.graphics.drawable.LayerDrawable$LayerState android.content.res.Resources ), this, layerState, resources);
    }

    private void __constructor__(RippleState rippleState, Resources resources) {
        this.$$robo$$android_graphics_drawable_RippleDrawable$__constructor__(rippleState, resources);
    }

    public RippleDrawable(RippleState rippleState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleDrawable$__constructor__(android.graphics.drawable.RippleDrawable$RippleState android.content.res.Resources ), this, rippleState, resources);
    }

    private void updateLocalState() {
        InvokeDynamicSupport.bootstrap("updateLocalState", $$robo$$android_graphics_drawable_RippleDrawable$updateLocalState(), this);
    }

    private /* synthetic */ void __constructor__(RippleState rippleState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_RippleDrawable$__constructor__(rippleState, resources, var3_3);
    }

    public /* synthetic */ RippleDrawable(RippleState rippleState, Resources resources, 1 var3_3) {
        this(rippleState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleDrawable$__constructor__(android.graphics.drawable.RippleDrawable$RippleState android.content.res.Resources android.graphics.drawable.RippleDrawable$1 ), this, rippleState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RippleDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class RippleState
    extends LayerDrawable.LayerState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int[] mTouchThemeAttrs;
        ColorStateList mColor;
        int mMaxRadius;

        private void $$robo$$android_graphics_drawable_RippleDrawable_RippleState$__constructor__(LayerDrawable.LayerState orig, RippleDrawable owner, Resources res) {
            this.mColor = ColorStateList.valueOf(-65281);
            this.mMaxRadius = -1;
            if (orig != null && orig instanceof RippleState) {
                RippleState origs = (RippleState)orig;
                this.mTouchThemeAttrs = origs.mTouchThemeAttrs;
                this.mColor = origs.mColor;
                this.mMaxRadius = origs.mMaxRadius;
                if (origs.mDensity != this.mDensity) {
                    this.applyDensityScaling(orig.mDensity, this.mDensity);
                }
            }
        }

        private final void $$robo$$android_graphics_drawable_RippleDrawable_RippleState$onDensityChanged(int sourceDensity, int targetDensity) {
            super.onDensityChanged(sourceDensity, targetDensity);
            this.applyDensityScaling(sourceDensity, targetDensity);
        }

        private final void $$robo$$android_graphics_drawable_RippleDrawable_RippleState$applyDensityScaling(int sourceDensity, int targetDensity) {
            if (this.mMaxRadius != -1) {
                this.mMaxRadius = Drawable.scaleFromDensity(this.mMaxRadius, sourceDensity, targetDensity, true);
            }
        }

        private final boolean $$robo$$android_graphics_drawable_RippleDrawable_RippleState$canApplyTheme() {
            return this.mTouchThemeAttrs != null || this.mColor != null && this.mColor.canApplyTheme() || super.canApplyTheme();
        }

        private final Drawable $$robo$$android_graphics_drawable_RippleDrawable_RippleState$newDrawable() {
            return new RippleDrawable(this, null, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_RippleDrawable_RippleState$newDrawable(Resources res) {
            return new RippleDrawable(this, res, null);
        }

        private final int $$robo$$android_graphics_drawable_RippleDrawable_RippleState$getChangingConfigurations() {
            return super.getChangingConfigurations() | (this.mColor != null ? this.mColor.getChangingConfigurations() : 0);
        }

        private void __constructor__(LayerDrawable.LayerState layerState, RippleDrawable rippleDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_RippleDrawable_RippleState$__constructor__(layerState, rippleDrawable, resources);
        }

        public RippleState(LayerDrawable.LayerState layerState, RippleDrawable rippleDrawable, Resources resources) {
            super(layerState, rippleDrawable, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleDrawable_RippleState$__constructor__(android.graphics.drawable.LayerDrawable$LayerState android.graphics.drawable.RippleDrawable android.content.res.Resources ), this, layerState, rippleDrawable, resources);
        }

        @Override
        protected void onDensityChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onDensityChanged", $$robo$$android_graphics_drawable_RippleDrawable_RippleState$onDensityChanged(int int ), this, n, n2);
        }

        private void applyDensityScaling(int n, int n2) {
            InvokeDynamicSupport.bootstrap("applyDensityScaling", $$robo$$android_graphics_drawable_RippleDrawable_RippleState$applyDensityScaling(int int ), this, n, n2);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_RippleDrawable_RippleState$canApplyTheme(), this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_RippleDrawable_RippleState$newDrawable(), this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_RippleDrawable_RippleState$newDrawable(android.content.res.Resources ), this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_RippleDrawable_RippleState$getChangingConfigurations(), this);
        }

        public /* synthetic */ RippleState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RippleState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

