/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.PathParser;
import com.android.internal.R;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AdaptiveIconDrawable
extends Drawable
implements Drawable.Callback,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static float MASK_SIZE = 100.0f;
    private static float SAFEZONE_SCALE = 0.9166667f;
    private static float EXTRA_INSET_PERCENTAGE = 0.25f;
    private static float DEFAULT_VIEW_PORT_SCALE = 0.6666667f;
    private static Path sMask;
    private Path mMask;
    private Matrix mMaskMatrix;
    private Region mTransparentRegion;
    private Bitmap mMaskBitmap;
    private static int BACKGROUND_ID = 0;
    private static int FOREGROUND_ID = 1;
    LayerState mLayerState;
    private Shader mLayersShader;
    private Bitmap mLayersBitmap;
    private Rect mTmpOutRect;
    private Rect mHotspotBounds;
    private boolean mMutated;
    private boolean mSuspendChildInvalidation;
    private boolean mChildRequestedInvalidation;
    private Canvas mCanvas;
    private Paint mPaint;

    private void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$__constructor__(LayerState state, Resources res) {
        this.mTmpOutRect = new Rect();
        this.mPaint = new Paint(7);
        this.mLayerState = this.createConstantState(state, res);
        if (sMask == null) {
            sMask = PathParser.createPathFromPathData(Resources.getSystem().getString(17039688));
        }
        this.mMask = PathParser.createPathFromPathData(Resources.getSystem().getString(17039688));
        this.mMaskMatrix = new Matrix();
        this.mCanvas = new Canvas();
        this.mTransparentRegion = new Region();
    }

    private final ChildDrawable $$robo$$android_graphics_drawable_AdaptiveIconDrawable$createChildDrawable(Drawable drawable2) {
        ChildDrawable layer = new ChildDrawable(this.mLayerState.mDensity);
        layer.mDrawable = drawable2;
        layer.mDrawable.setCallback(this);
        this.mLayerState.mChildrenChangingConfigurations |= layer.mDrawable.getChangingConfigurations();
        return layer;
    }

    private final LayerState $$robo$$android_graphics_drawable_AdaptiveIconDrawable$createConstantState(LayerState state, Resources res) {
        return new LayerState(state, this, res);
    }

    private void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$__constructor__(Drawable backgroundDrawable, Drawable foregroundDrawable) {
        if (backgroundDrawable != null) {
            this.addLayer(0, this.createChildDrawable(backgroundDrawable));
        }
        if (foregroundDrawable != null) {
            this.addLayer(1, this.createChildDrawable(foregroundDrawable));
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$addLayer(int index, ChildDrawable layer) {
        this.mLayerState.mChildren[index] = layer;
        this.mLayerState.invalidateCache();
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        LayerState state = this.mLayerState;
        if (state == null) {
            return;
        }
        int deviceDensity = Drawable.resolveDensity(r, 0);
        state.setDensity(deviceDensity);
        state.mSrcDensityOverride = this.mSrcDensityOverride;
        ChildDrawable[] array2 = state.mChildren;
        for (int i = 0; i < state.mChildren.length; ++i) {
            ChildDrawable layer = array2[i];
            layer.setDensity(deviceDensity);
        }
        this.inflateLayers(r, parser, attrs, theme);
    }

    private static final float $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getExtraInsetFraction() {
        return 0.25f;
    }

    private static final float $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getExtraInsetPercentage() {
        return 0.25f;
    }

    private final Path $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getIconMask() {
        return this.mMask;
    }

    private final Drawable $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getForeground() {
        return this.mLayerState.mChildren[1].mDrawable;
    }

    private final Drawable $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getBackground() {
        return this.mLayerState.mChildren[0].mDrawable;
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$onBoundsChange(Rect bounds) {
        if (bounds.isEmpty()) {
            return;
        }
        this.updateLayerBounds(bounds);
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$updateLayerBounds(Rect bounds) {
        if (bounds.isEmpty()) {
            return;
        }
        try {
            this.suspendChildInvalidation();
            this.updateLayerBoundsInternal(bounds);
            this.updateMaskBoundsInternal(bounds);
        }
        finally {
            this.resumeChildInvalidation();
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$updateLayerBoundsInternal(Rect bounds) {
        int cX = bounds.width() / 2;
        int cY = bounds.height() / 2;
        int count = 2;
        for (int i = 0; i < count; ++i) {
            Drawable d;
            ChildDrawable r = this.mLayerState.mChildren[i];
            if (r == null || (d = r.mDrawable) == null) continue;
            int insetWidth = (int)((float)bounds.width() / 1.3333334f);
            int insetHeight = (int)((float)bounds.height() / 1.3333334f);
            Rect outRect = this.mTmpOutRect;
            outRect.set(cX - insetWidth, cY - insetHeight, cX + insetWidth, cY + insetHeight);
            d.setBounds(outRect);
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$updateMaskBoundsInternal(Rect b) {
        this.mMaskMatrix.setScale((float)b.width() / 100.0f, (float)b.height() / 100.0f);
        sMask.transform(this.mMaskMatrix, this.mMask);
        if (this.mMaskBitmap == null || this.mMaskBitmap.getWidth() != b.width() || this.mMaskBitmap.getHeight() != b.height()) {
            this.mMaskBitmap = Bitmap.createBitmap(b.width(), b.height(), Bitmap.Config.ALPHA_8);
            this.mLayersBitmap = Bitmap.createBitmap(b.width(), b.height(), Bitmap.Config.ARGB_8888);
        }
        this.mCanvas.setBitmap(this.mMaskBitmap);
        this.mPaint.setShader(null);
        this.mCanvas.drawPath(this.mMask, this.mPaint);
        this.mMaskMatrix.postTranslate(b.left, b.top);
        this.mMask.reset();
        sMask.transform(this.mMaskMatrix, this.mMask);
        this.mTransparentRegion.setEmpty();
        this.mLayersShader = null;
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$draw(Canvas canvas) {
        if (this.mLayersBitmap == null) {
            return;
        }
        if (this.mLayersShader == null) {
            this.mCanvas.setBitmap(this.mLayersBitmap);
            this.mCanvas.drawColor(-16777216);
            int i = 0;
            while (true) {
                Drawable dr;
                if (i >= 2) break;
                if (this.mLayerState.mChildren[i] != null && (dr = this.mLayerState.mChildren[i].mDrawable) != null) {
                    dr.draw(this.mCanvas);
                }
                ++i;
            }
            this.mLayersShader = new BitmapShader(this.mLayersBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mPaint.setShader(this.mLayersShader);
        }
        if (this.mMaskBitmap != null) {
            Rect bounds = this.getBounds();
            canvas.drawBitmap(this.mMaskBitmap, bounds.left, bounds.top, this.mPaint);
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$invalidateSelf() {
        this.mLayersShader = null;
        super.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getOutline(Outline outline) {
        outline.setConvexPath(this.mMask);
    }

    private final Region $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getSafeZone() {
        this.mMaskMatrix.reset();
        this.mMaskMatrix.setScale(0.9166667f, 0.9166667f, this.getBounds().centerX(), this.getBounds().centerY());
        Path p = new Path();
        this.mMask.transform(this.mMaskMatrix, p);
        Region safezoneRegion = new Region(this.getBounds());
        safezoneRegion.setPath(p, safezoneRegion);
        return safezoneRegion;
    }

    private final Region $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getTransparentRegion() {
        if (this.mTransparentRegion.isEmpty()) {
            this.mMask.toggleInverseFillType();
            this.mTransparentRegion.set(this.getBounds());
            this.mTransparentRegion.setPath(this.mMask, this.mTransparentRegion);
            this.mMask.toggleInverseFillType();
        }
        return this.mTransparentRegion;
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        LayerState state = this.mLayerState;
        if (state == null) {
            return;
        }
        int density = Drawable.resolveDensity(t.getResources(), 0);
        state.setDensity(density);
        ChildDrawable[] array2 = state.mChildren;
        int i = 0;
        while (true) {
            Drawable d;
            if (i >= 2) break;
            ChildDrawable layer = array2[i];
            layer.setDensity(density);
            if (layer.mThemeAttrs != null) {
                TypedArray a = t.resolveAttributes(layer.mThemeAttrs, R.styleable.AdaptiveIconDrawableLayer);
                this.updateLayerFromTypedArray(layer, a);
                a.recycle();
            }
            if ((d = layer.mDrawable) != null && d.canApplyTheme()) {
                d.applyTheme(t);
                state.mChildrenChangingConfigurations |= d.getChangingConfigurations();
            }
            ++i;
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$inflateLayers(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        LayerState state = this.mLayerState;
        int innerDepth = parser.getDepth() + 1;
        int childIndex = 0;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth) continue;
            String tagName = parser.getName();
            if (tagName.equals("background")) {
                childIndex = 0;
            } else {
                if (!tagName.equals("foreground")) continue;
                childIndex = 1;
            }
            ChildDrawable layer = new ChildDrawable(state.mDensity);
            TypedArray a = AdaptiveIconDrawable.obtainAttributes(r, theme, attrs, R.styleable.AdaptiveIconDrawableLayer);
            this.updateLayerFromTypedArray(layer, a);
            a.recycle();
            if (layer.mDrawable == null && layer.mThemeAttrs == null) {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <foreground> or <background> tag requires a 'drawable'attribute or child tag defining a drawable");
                }
                layer.mDrawable = Drawable.createFromXmlInnerForDensity(r, parser, attrs, this.mLayerState.mSrcDensityOverride, theme);
                layer.mDrawable.setCallback(this);
                state.mChildrenChangingConfigurations |= layer.mDrawable.getChangingConfigurations();
            }
            this.addLayer(childIndex, layer);
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$updateLayerFromTypedArray(ChildDrawable layer, TypedArray a) {
        LayerState state = this.mLayerState;
        state.mChildrenChangingConfigurations |= a.getChangingConfigurations();
        layer.mThemeAttrs = a.extractThemeAttrs();
        Drawable dr = a.getDrawableForDensity(0, state.mSrcDensityOverride);
        if (dr != null) {
            if (layer.mDrawable != null) {
                layer.mDrawable.setCallback(null);
            }
            layer.mDrawable = dr;
            layer.mDrawable.setCallback(this);
            state.mChildrenChangingConfigurations |= layer.mDrawable.getChangingConfigurations();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_AdaptiveIconDrawable$canApplyTheme() {
        return this.mLayerState != null && this.mLayerState.canApplyTheme() || super.canApplyTheme();
    }

    private final boolean $$robo$$android_graphics_drawable_AdaptiveIconDrawable$isProjected() {
        if (super.isProjected()) {
            return true;
        }
        ChildDrawable[] layers = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            if (layers[i].mDrawable.isProjected()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$suspendChildInvalidation() {
        this.mSuspendChildInvalidation = true;
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$resumeChildInvalidation() {
        this.mSuspendChildInvalidation = false;
        if (this.mChildRequestedInvalidation) {
            this.mChildRequestedInvalidation = false;
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$invalidateDrawable(Drawable who) {
        if (this.mSuspendChildInvalidation) {
            this.mChildRequestedInvalidation = true;
        } else {
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    private final int $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mLayerState.getChangingConfigurations();
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setHotspot(float x, float y) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.setHotspot(x, y);
            }
            ++i;
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setHotspotBounds(int left, int top, int right, int bottom) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.setHotspotBounds(left, top, right, bottom);
            }
            ++i;
        }
        if (this.mHotspotBounds == null) {
            this.mHotspotBounds = new Rect(left, top, right, bottom);
        } else {
            this.mHotspotBounds.set(left, top, right, bottom);
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getHotspotBounds(Rect outRect) {
        if (this.mHotspotBounds != null) {
            outRect.set(this.mHotspotBounds);
        } else {
            super.getHotspotBounds(outRect);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.setVisible(visible, restart);
            }
            ++i;
        }
        return changed;
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setDither(boolean dither) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.setDither(dither);
            }
            ++i;
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    private final int $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getAlpha() {
        return -3;
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setColorFilter(ColorFilter colorFilter) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.setColorFilter(colorFilter);
            }
            ++i;
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setTintList(ColorStateList tint) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = 2;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.setTintList(tint);
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setTintMode(PorterDuff.Mode tintMode) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = 2;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.setTintMode(tintMode);
        }
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setOpacity(int opacity) {
        this.mLayerState.mOpacityOverride = opacity;
    }

    private final int $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getOpacity() {
        if (this.mLayerState.mOpacityOverride != 0) {
            return this.mLayerState.mOpacityOverride;
        }
        return this.mLayerState.getOpacity();
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setAutoMirrored(boolean mirrored) {
        this.mLayerState.mAutoMirrored = mirrored;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.setAutoMirrored(mirrored);
            }
            ++i;
        }
    }

    private final boolean $$robo$$android_graphics_drawable_AdaptiveIconDrawable$isAutoMirrored() {
        return this.mLayerState.mAutoMirrored;
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$jumpToCurrentState() {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.jumpToCurrentState();
            }
            ++i;
        }
    }

    private final boolean $$robo$$android_graphics_drawable_AdaptiveIconDrawable$isStateful() {
        return this.mLayerState.isStateful();
    }

    private final boolean $$robo$$android_graphics_drawable_AdaptiveIconDrawable$hasFocusStateSpecified() {
        return this.mLayerState.hasFocusStateSpecified();
    }

    private final boolean $$robo$$android_graphics_drawable_AdaptiveIconDrawable$onStateChange(int[] state) {
        boolean changed = false;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null && dr.isStateful() && dr.setState(state)) {
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.updateLayerBounds(this.getBounds());
        }
        return changed;
    }

    private final boolean $$robo$$android_graphics_drawable_AdaptiveIconDrawable$onLevelChange(int level) {
        boolean changed = false;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null && dr.setLevel(level)) {
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.updateLayerBounds(this.getBounds());
        }
        return changed;
    }

    private final int $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getIntrinsicWidth() {
        return (int)((float)this.getMaxIntrinsicWidth() * 0.6666667f);
    }

    private final int $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getMaxIntrinsicWidth() {
        int width = -1;
        int i = 0;
        while (true) {
            int w;
            if (i >= 2) break;
            ChildDrawable r = this.mLayerState.mChildren[i];
            if (r.mDrawable != null && (w = r.mDrawable.getIntrinsicWidth()) > width) {
                width = w;
            }
            ++i;
        }
        return width;
    }

    private final int $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getIntrinsicHeight() {
        return (int)((float)this.getMaxIntrinsicHeight() * 0.6666667f);
    }

    private final int $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getMaxIntrinsicHeight() {
        int height = -1;
        int i = 0;
        while (true) {
            int h;
            if (i >= 2) break;
            ChildDrawable r = this.mLayerState.mChildren[i];
            if (r.mDrawable != null && (h = r.mDrawable.getIntrinsicHeight()) > height) {
                height = h;
            }
            ++i;
        }
        return height;
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getConstantState() {
        if (this.mLayerState.canConstantState()) {
            this.mLayerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mLayerState;
        }
        return null;
    }

    private final Drawable $$robo$$android_graphics_drawable_AdaptiveIconDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mLayerState = this.createConstantState(this.mLayerState, null);
            int i = 0;
            while (true) {
                if (i >= 2) break;
                Drawable dr = this.mLayerState.mChildren[i].mDrawable;
                if (dr != null) {
                    dr.mutate();
                }
                ++i;
            }
            this.mMutated = true;
        }
        return this;
    }

    private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable$clearMutated() {
        super.clearMutated();
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.clearMutated();
            }
            ++i;
        }
        this.mMutated = false;
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_AdaptiveIconDrawable$__constructor__();
    }

    public AdaptiveIconDrawable() {
        this((LayerState)null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$__constructor__(), this);
    }

    private void __constructor__(LayerState layerState, Resources resources) {
        this.$$robo$$android_graphics_drawable_AdaptiveIconDrawable$__constructor__(layerState, resources);
    }

    public AdaptiveIconDrawable(LayerState layerState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$__constructor__(android.graphics.drawable.AdaptiveIconDrawable$LayerState android.content.res.Resources ), this, layerState, resources);
    }

    private ChildDrawable createChildDrawable(Drawable drawable2) {
        return InvokeDynamicSupport.bootstrap("createChildDrawable", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$createChildDrawable(android.graphics.drawable.Drawable ), this, drawable2);
    }

    LayerState createConstantState(LayerState layerState, Resources resources) {
        return InvokeDynamicSupport.bootstrap("createConstantState", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$createConstantState(android.graphics.drawable.AdaptiveIconDrawable$LayerState android.content.res.Resources ), this, layerState, resources);
    }

    private void __constructor__(Drawable drawable2, Drawable drawable3) {
        this.$$robo$$android_graphics_drawable_AdaptiveIconDrawable$__constructor__(drawable2, drawable3);
    }

    public AdaptiveIconDrawable(Drawable drawable2, Drawable drawable3) {
        this((LayerState)null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$__constructor__(android.graphics.drawable.Drawable android.graphics.drawable.Drawable ), this, drawable2, drawable3);
    }

    private void addLayer(int n, ChildDrawable childDrawable) {
        InvokeDynamicSupport.bootstrap("addLayer", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$addLayer(int android.graphics.drawable.AdaptiveIconDrawable$ChildDrawable ), this, n, childDrawable);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    public static float getExtraInsetFraction() {
        return (float)InvokeDynamicSupport.bootstrapStatic("getExtraInsetFraction", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getExtraInsetFraction());
    }

    public static float getExtraInsetPercentage() {
        return (float)InvokeDynamicSupport.bootstrapStatic("getExtraInsetPercentage", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getExtraInsetPercentage());
    }

    public Path getIconMask() {
        return InvokeDynamicSupport.bootstrap("getIconMask", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getIconMask(), this);
    }

    public Drawable getForeground() {
        return InvokeDynamicSupport.bootstrap("getForeground", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getForeground(), this);
    }

    public Drawable getBackground() {
        return InvokeDynamicSupport.bootstrap("getBackground", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getBackground(), this);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$onBoundsChange(android.graphics.Rect ), this, rect);
    }

    private void updateLayerBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("updateLayerBounds", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$updateLayerBounds(android.graphics.Rect ), this, rect);
    }

    private void updateLayerBoundsInternal(Rect rect) {
        InvokeDynamicSupport.bootstrap("updateLayerBoundsInternal", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$updateLayerBoundsInternal(android.graphics.Rect ), this, rect);
    }

    private void updateMaskBoundsInternal(Rect rect) {
        InvokeDynamicSupport.bootstrap("updateMaskBoundsInternal", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$updateMaskBoundsInternal(android.graphics.Rect ), this, rect);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$draw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    public void invalidateSelf() {
        InvokeDynamicSupport.bootstrap("invalidateSelf", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$invalidateSelf(), this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getOutline(android.graphics.Outline ), this, outline);
    }

    public Region getSafeZone() {
        return InvokeDynamicSupport.bootstrap("getSafeZone", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getSafeZone(), this);
    }

    @Override
    public Region getTransparentRegion() {
        return InvokeDynamicSupport.bootstrap("getTransparentRegion", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getTransparentRegion(), this);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$applyTheme(android.content.res.Resources$Theme ), this, theme);
    }

    private void inflateLayers(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflateLayers", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$inflateLayers(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateLayerFromTypedArray(ChildDrawable childDrawable, TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateLayerFromTypedArray", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$updateLayerFromTypedArray(android.graphics.drawable.AdaptiveIconDrawable$ChildDrawable android.content.res.TypedArray ), this, childDrawable, typedArray);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$canApplyTheme(), this);
    }

    @Override
    public boolean isProjected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProjected", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$isProjected(), this);
    }

    private void suspendChildInvalidation() {
        InvokeDynamicSupport.bootstrap("suspendChildInvalidation", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$suspendChildInvalidation(), this);
    }

    private void resumeChildInvalidation() {
        InvokeDynamicSupport.bootstrap("resumeChildInvalidation", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$resumeChildInvalidation(), this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$invalidateDrawable(android.graphics.drawable.Drawable ), this, drawable2);
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        InvokeDynamicSupport.bootstrap("scheduleDrawable", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$scheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable long ), this, drawable2, runnable, l);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("unscheduleDrawable", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$unscheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable ), this, drawable2, runnable);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getChangingConfigurations(), this);
    }

    @Override
    public void setHotspot(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setHotspot", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setHotspot(float float ), this, f, f2);
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setHotspotBounds", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setHotspotBounds(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    public void getHotspotBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getHotspotBounds", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getHotspotBounds(android.graphics.Rect ), this, rect);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setVisible(boolean boolean ), this, bl, bl2);
    }

    @Override
    public void setDither(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setDither(boolean ), this, bl);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setAlpha(int ), this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getAlpha(), this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setColorFilter(android.graphics.ColorFilter ), this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setTintList(android.content.res.ColorStateList ), this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setTintMode(android.graphics.PorterDuff$Mode ), this, mode);
    }

    public void setOpacity(int n) {
        InvokeDynamicSupport.bootstrap("setOpacity", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setOpacity(int ), this, n);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getOpacity(), this);
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoMirrored", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$setAutoMirrored(boolean ), this, bl);
    }

    @Override
    public boolean isAutoMirrored() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutoMirrored", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$isAutoMirrored(), this);
    }

    @Override
    public void jumpToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpToCurrentState", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$jumpToCurrentState(), this);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$isStateful(), this);
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$hasFocusStateSpecified(), this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$onStateChange(int[] ), this, nArray);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$onLevelChange(int ), this, n);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getIntrinsicWidth(), this);
    }

    private int getMaxIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxIntrinsicWidth", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getMaxIntrinsicWidth(), this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getIntrinsicHeight(), this);
    }

    private int getMaxIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxIntrinsicHeight", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getMaxIntrinsicHeight(), this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$getConstantState(), this);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$mutate(), this);
    }

    @Override
    public void clearMutated() {
        InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_AdaptiveIconDrawable$clearMutated(), this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdaptiveIconDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LayerState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int[] mThemeAttrs;
        static int N_CHILDREN = 2;
        ChildDrawable[] mChildren;
        int mDensity;
        int mSrcDensityOverride;
        int mOpacityOverride;
        int mChangingConfigurations;
        int mChildrenChangingConfigurations;
        private boolean mCheckedOpacity;
        private int mOpacity;
        private boolean mCheckedStateful;
        private boolean mIsStateful;
        private boolean mAutoMirrored;

        private void $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$__constructor__(LayerState orig, AdaptiveIconDrawable owner, Resources res) {
            this.mSrcDensityOverride = 0;
            this.mOpacityOverride = 0;
            this.mAutoMirrored = false;
            this.mDensity = Drawable.resolveDensity(res, orig != null ? orig.mDensity : 0);
            this.mChildren = new ChildDrawable[2];
            if (orig != null) {
                ChildDrawable[] origChildDrawable = orig.mChildren;
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mChildrenChangingConfigurations = orig.mChildrenChangingConfigurations;
                for (int i = 0; i < 2; ++i) {
                    ChildDrawable or = origChildDrawable[i];
                    this.mChildren[i] = new ChildDrawable(or, owner, res);
                }
                this.mCheckedOpacity = orig.mCheckedOpacity;
                this.mOpacity = orig.mOpacity;
                this.mCheckedStateful = orig.mCheckedStateful;
                this.mIsStateful = orig.mIsStateful;
                this.mAutoMirrored = orig.mAutoMirrored;
                this.mThemeAttrs = orig.mThemeAttrs;
                this.mOpacityOverride = orig.mOpacityOverride;
                this.mSrcDensityOverride = orig.mSrcDensityOverride;
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.mChildren[i] = new ChildDrawable(this.mDensity);
                }
            }
        }

        private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                this.mDensity = targetDensity;
            }
        }

        private final boolean $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$canApplyTheme() {
            if (this.mThemeAttrs != null || super.canApplyTheme()) {
                return true;
            }
            ChildDrawable[] array2 = this.mChildren;
            for (int i = 0; i < 2; ++i) {
                ChildDrawable layer = array2[i];
                if (!layer.canApplyTheme()) continue;
                return true;
            }
            return false;
        }

        private final Drawable $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$newDrawable() {
            return new AdaptiveIconDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$newDrawable(Resources res) {
            return new AdaptiveIconDrawable(this, res);
        }

        private final int $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$getChangingConfigurations() {
            return this.mChangingConfigurations | this.mChildrenChangingConfigurations;
        }

        private final int $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$getOpacity() {
            if (this.mCheckedOpacity) {
                return this.mOpacity;
            }
            ChildDrawable[] array2 = this.mChildren;
            int firstIndex = -1;
            for (int i = 0; i < 2; ++i) {
                if (array2[i].mDrawable == null) continue;
                firstIndex = i;
                break;
            }
            int op = firstIndex >= 0 ? array2[firstIndex].mDrawable.getOpacity() : -2;
            for (int i = firstIndex + 1; i < 2; ++i) {
                Drawable dr = array2[i].mDrawable;
                if (dr == null) continue;
                op = Drawable.resolveOpacity(op, dr.getOpacity());
            }
            this.mOpacity = op;
            this.mCheckedOpacity = true;
            return op;
        }

        private final boolean $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$isStateful() {
            if (this.mCheckedStateful) {
                return this.mIsStateful;
            }
            ChildDrawable[] array2 = this.mChildren;
            boolean isStateful = false;
            for (int i = 0; i < 2; ++i) {
                Drawable dr = array2[i].mDrawable;
                if (dr == null || !dr.isStateful()) continue;
                isStateful = true;
                break;
            }
            this.mIsStateful = isStateful;
            this.mCheckedStateful = true;
            return isStateful;
        }

        private final boolean $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$hasFocusStateSpecified() {
            ChildDrawable[] array2 = this.mChildren;
            for (int i = 0; i < 2; ++i) {
                Drawable dr = array2[i].mDrawable;
                if (dr == null || !dr.hasFocusStateSpecified()) continue;
                return true;
            }
            return false;
        }

        private final boolean $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$canConstantState() {
            ChildDrawable[] array2 = this.mChildren;
            for (int i = 0; i < 2; ++i) {
                Drawable dr = array2[i].mDrawable;
                if (dr == null || dr.getConstantState() != null) continue;
                return false;
            }
            return true;
        }

        private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$invalidateCache() {
            this.mCheckedOpacity = false;
            this.mCheckedStateful = false;
        }

        private void __constructor__(LayerState layerState, AdaptiveIconDrawable adaptiveIconDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$__constructor__(layerState, adaptiveIconDrawable, resources);
        }

        public LayerState(LayerState layerState, AdaptiveIconDrawable adaptiveIconDrawable, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$__constructor__(android.graphics.drawable.AdaptiveIconDrawable$LayerState android.graphics.drawable.AdaptiveIconDrawable android.content.res.Resources ), this, layerState, adaptiveIconDrawable, resources);
        }

        public void setDensity(int n) {
            InvokeDynamicSupport.bootstrap("setDensity", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$setDensity(int ), this, n);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$canApplyTheme(), this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$newDrawable(), this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$newDrawable(android.content.res.Resources ), this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$getChangingConfigurations(), this);
        }

        public int getOpacity() {
            return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$getOpacity(), this);
        }

        public boolean isStateful() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$isStateful(), this);
        }

        public boolean hasFocusStateSpecified() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$hasFocusStateSpecified(), this);
        }

        public boolean canConstantState() {
            return (boolean)InvokeDynamicSupport.bootstrap("canConstantState", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$canConstantState(), this);
        }

        public void invalidateCache() {
            InvokeDynamicSupport.bootstrap("invalidateCache", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_LayerState$invalidateCache(), this);
        }

        public /* synthetic */ LayerState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayerState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ChildDrawable
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public Drawable mDrawable;
        public int[] mThemeAttrs;
        public int mDensity;

        private void $$robo$$android_graphics_drawable_AdaptiveIconDrawable_ChildDrawable$__constructor__(int density) {
            this.mDensity = 160;
            this.mDensity = density;
        }

        private void $$robo$$android_graphics_drawable_AdaptiveIconDrawable_ChildDrawable$__constructor__(ChildDrawable orig, AdaptiveIconDrawable owner, Resources res) {
            Drawable clone;
            this.mDensity = 160;
            Drawable dr = orig.mDrawable;
            if (dr != null) {
                Drawable.ConstantState cs = dr.getConstantState();
                clone = cs == null ? dr : (res != null ? cs.newDrawable(res) : cs.newDrawable());
                clone.setCallback(owner);
                clone.setBounds(dr.getBounds());
                clone.setLevel(dr.getLevel());
            } else {
                clone = null;
            }
            this.mDrawable = clone;
            this.mThemeAttrs = orig.mThemeAttrs;
            this.mDensity = Drawable.resolveDensity(res, orig.mDensity);
        }

        private final boolean $$robo$$android_graphics_drawable_AdaptiveIconDrawable_ChildDrawable$canApplyTheme() {
            return this.mThemeAttrs != null || this.mDrawable != null && this.mDrawable.canApplyTheme();
        }

        private final void $$robo$$android_graphics_drawable_AdaptiveIconDrawable_ChildDrawable$setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                this.mDensity = targetDensity;
            }
        }

        private void __constructor__(int n) {
            this.$$robo$$android_graphics_drawable_AdaptiveIconDrawable_ChildDrawable$__constructor__(n);
        }

        public ChildDrawable(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_ChildDrawable$__constructor__(int ), this, n);
        }

        private void __constructor__(ChildDrawable childDrawable, AdaptiveIconDrawable adaptiveIconDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_AdaptiveIconDrawable_ChildDrawable$__constructor__(childDrawable, adaptiveIconDrawable, resources);
        }

        public ChildDrawable(ChildDrawable childDrawable, AdaptiveIconDrawable adaptiveIconDrawable, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_ChildDrawable$__constructor__(android.graphics.drawable.AdaptiveIconDrawable$ChildDrawable android.graphics.drawable.AdaptiveIconDrawable android.content.res.Resources ), this, childDrawable, adaptiveIconDrawable, resources);
        }

        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_ChildDrawable$canApplyTheme(), this);
        }

        public void setDensity(int n) {
            InvokeDynamicSupport.bootstrap("setDensity", $$robo$$android_graphics_drawable_AdaptiveIconDrawable_ChildDrawable$setDensity(int ), this, n);
        }

        public /* synthetic */ ChildDrawable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChildDrawable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

