/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Rect;
import java.io.OutputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class YuvImage
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int WORKING_COMPRESS_STORAGE = 4096;
    private int mFormat;
    private byte[] mData;
    private int[] mStrides;
    private int mWidth;
    private int mHeight;

    private void $$robo$$android_graphics_YuvImage$__constructor__(byte[] yuv, int format, int width, int height, int[] strides) {
        if (format != 17 && format != 20) {
            throw new IllegalArgumentException("only support ImageFormat.NV21 and ImageFormat.YUY2 for now");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must large than 0");
        }
        if (yuv == null) {
            throw new IllegalArgumentException("yuv cannot be null");
        }
        this.mStrides = strides == null ? this.calculateStrides(width, format) : strides;
        this.mData = yuv;
        this.mFormat = format;
        this.mWidth = width;
        this.mHeight = height;
    }

    private final boolean $$robo$$android_graphics_YuvImage$compressToJpeg(Rect rectangle, int quality, OutputStream stream) {
        Rect wholeImage = new Rect(0, 0, this.mWidth, this.mHeight);
        if (!wholeImage.contains(rectangle)) {
            throw new IllegalArgumentException("rectangle is not inside the image");
        }
        if (quality < 0 || quality > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        this.adjustRectangle(rectangle);
        int[] offsets = this.calculateOffsets(rectangle.left, rectangle.top);
        return YuvImage.nativeCompressToJpeg(this.mData, this.mFormat, rectangle.width(), rectangle.height(), offsets, this.mStrides, quality, stream, new byte[4096]);
    }

    private final byte[] $$robo$$android_graphics_YuvImage$getYuvData() {
        return this.mData;
    }

    private final int $$robo$$android_graphics_YuvImage$getYuvFormat() {
        return this.mFormat;
    }

    private final int[] $$robo$$android_graphics_YuvImage$getStrides() {
        return this.mStrides;
    }

    private final int $$robo$$android_graphics_YuvImage$getWidth() {
        return this.mWidth;
    }

    private final int $$robo$$android_graphics_YuvImage$getHeight() {
        return this.mHeight;
    }

    private final int[] $$robo$$android_graphics_YuvImage$calculateOffsets(int left, int top) {
        int[] offsets = null;
        if (this.mFormat == 17) {
            offsets = new int[]{top * this.mStrides[0] + left, this.mHeight * this.mStrides[0] + top / 2 * this.mStrides[1] + left / 2 * 2};
            return offsets;
        }
        if (this.mFormat == 20) {
            offsets = new int[]{top * this.mStrides[0] + left / 2 * 4};
            return offsets;
        }
        return offsets;
    }

    private final int[] $$robo$$android_graphics_YuvImage$calculateStrides(int width, int format) {
        int[] strides = null;
        if (format == 17) {
            strides = new int[]{width, width};
            return strides;
        }
        if (format == 20) {
            strides = new int[]{width * 2};
            return strides;
        }
        return strides;
    }

    private final void $$robo$$android_graphics_YuvImage$adjustRectangle(Rect rect) {
        int width = rect.width();
        int height = rect.height();
        if (this.mFormat == 17) {
            rect.left &= 0xFFFFFFFE;
            rect.top &= 0xFFFFFFFE;
            rect.right = rect.left + (width &= 0xFFFFFFFE);
            rect.bottom = rect.top + (height &= 0xFFFFFFFE);
        }
        if (this.mFormat == 20) {
            rect.left &= 0xFFFFFFFE;
            rect.right = rect.left + (width &= 0xFFFFFFFE);
        }
    }

    private static final boolean $$robo$$android_graphics_YuvImage$nativeCompressToJpeg(byte[] byArray, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, OutputStream outputStream, byte[] byArray2) {
        return false;
    }

    private void __constructor__(byte[] byArray, int n, int n2, int n3, int[] nArray) {
        this.$$robo$$android_graphics_YuvImage$__constructor__(byArray, n, n2, n3, nArray);
    }

    public YuvImage(byte[] byArray, int n, int n2, int n3, int[] nArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_YuvImage$__constructor__(byte[] int int int int[] ), this, byArray, n, n2, n3, nArray);
    }

    public boolean compressToJpeg(Rect rect, int n, OutputStream outputStream) {
        return (boolean)InvokeDynamicSupport.bootstrap("compressToJpeg", $$robo$$android_graphics_YuvImage$compressToJpeg(android.graphics.Rect int java.io.OutputStream ), this, rect, n, outputStream);
    }

    public byte[] getYuvData() {
        return InvokeDynamicSupport.bootstrap("getYuvData", $$robo$$android_graphics_YuvImage$getYuvData(), this);
    }

    public int getYuvFormat() {
        return (int)InvokeDynamicSupport.bootstrap("getYuvFormat", $$robo$$android_graphics_YuvImage$getYuvFormat(), this);
    }

    public int[] getStrides() {
        return InvokeDynamicSupport.bootstrap("getStrides", $$robo$$android_graphics_YuvImage$getStrides(), this);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_graphics_YuvImage$getWidth(), this);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_graphics_YuvImage$getHeight(), this);
    }

    int[] calculateOffsets(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("calculateOffsets", $$robo$$android_graphics_YuvImage$calculateOffsets(int int ), this, n, n2);
    }

    private int[] calculateStrides(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("calculateStrides", $$robo$$android_graphics_YuvImage$calculateStrides(int int ), this, n, n2);
    }

    private void adjustRectangle(Rect rect) {
        InvokeDynamicSupport.bootstrap("adjustRectangle", $$robo$$android_graphics_YuvImage$adjustRectangle(android.graphics.Rect ), this, rect);
    }

    private static boolean nativeCompressToJpeg(byte[] byArray, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, OutputStream outputStream, byte[] byArray2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeCompressToJpeg", $$robo$$android_graphics_YuvImage$nativeCompressToJpeg(byte[] int int int int[] int[] int java.io.OutputStream byte[] ), (byte[])byArray, (int)n, (int)n2, (int)n3, (int[])nArray, (int[])nArray2, (int)n4, (OutputStream)outputStream, (byte[])byArray2);
    }

    public /* synthetic */ YuvImage() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (YuvImage)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

