/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import java.io.InputStream;
import java.io.OutputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Picture
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private PictureCanvas mRecordingCanvas;
    private long mNativePicture;
    private boolean mRequiresHwAcceleration;
    private static int WORKING_STREAM_STORAGE = 16384;

    private void $$robo$$android_graphics_Picture$__constructor__() {
    }

    private void $$robo$$android_graphics_Picture$__constructor__(Picture src) {
    }

    private void $$robo$$android_graphics_Picture$__constructor__(long nativePicture) {
        if (nativePicture == 0L) {
            throw new RuntimeException();
        }
        this.mNativePicture = nativePicture;
    }

    private final void $$robo$$android_graphics_Picture$finalize() throws Throwable {
        try {
            Picture.nativeDestructor(this.mNativePicture);
            this.mNativePicture = 0L;
        }
        finally {
            super.finalize();
        }
    }

    private final Canvas $$robo$$android_graphics_Picture$beginRecording(int width, int height) {
        if (this.mRecordingCanvas != null) {
            throw new IllegalStateException("Picture already recording, must call #endRecording()");
        }
        long ni = Picture.nativeBeginRecording(this.mNativePicture, width, height);
        this.mRecordingCanvas = new PictureCanvas(this, ni);
        this.mRequiresHwAcceleration = false;
        return this.mRecordingCanvas;
    }

    private final void $$robo$$android_graphics_Picture$endRecording() {
        if (this.mRecordingCanvas != null) {
            this.mRequiresHwAcceleration = this.mRecordingCanvas.mHoldsHwBitmap;
            this.mRecordingCanvas = null;
            Picture.nativeEndRecording(this.mNativePicture);
        }
    }

    private final int $$robo$$android_graphics_Picture$getWidth() {
        return Picture.nativeGetWidth(this.mNativePicture);
    }

    private final int $$robo$$android_graphics_Picture$getHeight() {
        return Picture.nativeGetHeight(this.mNativePicture);
    }

    private final boolean $$robo$$android_graphics_Picture$requiresHardwareAcceleration() {
        return this.mRequiresHwAcceleration;
    }

    private final void $$robo$$android_graphics_Picture$draw(Canvas canvas) {
        if (this.mRecordingCanvas != null) {
            this.endRecording();
        }
        if (this.mRequiresHwAcceleration && !canvas.isHardwareAccelerated()) {
            canvas.onHwBitmapInSwMode();
        }
        Picture.nativeDraw(canvas.getNativeCanvasWrapper(), this.mNativePicture);
    }

    @Deprecated
    private static final Picture $$robo$$android_graphics_Picture$createFromStream(InputStream stream) {
        return new Picture(Picture.nativeCreateFromStream(stream, new byte[16384]));
    }

    @Deprecated
    private final void $$robo$$android_graphics_Picture$writeToStream(OutputStream stream) {
        if (stream == null) {
            throw new NullPointerException();
        }
        if (!Picture.nativeWriteToStream(this.mNativePicture, stream, new byte[16384])) {
            throw new RuntimeException();
        }
    }

    private static final long $$robo$$android_graphics_Picture$nativeConstructor(long l) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Picture$nativeCreateFromStream(InputStream inputStream, byte[] byArray) {
        return 0L;
    }

    private static final int $$robo$$android_graphics_Picture$nativeGetWidth(long l) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Picture$nativeGetHeight(long l) {
        return 0;
    }

    private static final long $$robo$$android_graphics_Picture$nativeBeginRecording(long l, int n, int n2) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_Picture$nativeEndRecording(long l) {
    }

    private static final void $$robo$$android_graphics_Picture$nativeDraw(long l, long l2) {
    }

    private static final boolean $$robo$$android_graphics_Picture$nativeWriteToStream(long l, OutputStream outputStream, byte[] byArray) {
        return false;
    }

    private static final void $$robo$$android_graphics_Picture$nativeDestructor(long l) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_Picture$__constructor__();
    }

    public Picture() {
        this(Picture.nativeConstructor(0L));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Picture$__constructor__(), this);
    }

    private void __constructor__(Picture picture) {
        this.$$robo$$android_graphics_Picture$__constructor__(picture);
    }

    public Picture(Picture picture) {
        this(Picture.nativeConstructor(picture != null ? picture.mNativePicture : 0L));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Picture$__constructor__(android.graphics.Picture ), this, picture);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_graphics_Picture$__constructor__(l);
    }

    public Picture(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Picture$__constructor__(long ), this, l);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_Picture$finalize(), this);
    }

    public Canvas beginRecording(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("beginRecording", $$robo$$android_graphics_Picture$beginRecording(int int ), this, n, n2);
    }

    public void endRecording() {
        InvokeDynamicSupport.bootstrap("endRecording", $$robo$$android_graphics_Picture$endRecording(), this);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_graphics_Picture$getWidth(), this);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_graphics_Picture$getHeight(), this);
    }

    public boolean requiresHardwareAcceleration() {
        return (boolean)InvokeDynamicSupport.bootstrap("requiresHardwareAcceleration", $$robo$$android_graphics_Picture$requiresHardwareAcceleration(), this);
    }

    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_Picture$draw(android.graphics.Canvas ), this, canvas);
    }

    @Deprecated
    public static Picture createFromStream(InputStream inputStream) {
        return InvokeDynamicSupport.bootstrapStatic("createFromStream", $$robo$$android_graphics_Picture$createFromStream(java.io.InputStream ), (InputStream)inputStream);
    }

    @Deprecated
    public void writeToStream(OutputStream outputStream) {
        InvokeDynamicSupport.bootstrap("writeToStream", $$robo$$android_graphics_Picture$writeToStream(java.io.OutputStream ), this, outputStream);
    }

    private static long nativeConstructor(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeConstructor", $$robo$$android_graphics_Picture$nativeConstructor(long ), (long)l);
    }

    private static long nativeCreateFromStream(InputStream inputStream, byte[] byArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateFromStream", $$robo$$android_graphics_Picture$nativeCreateFromStream(java.io.InputStream byte[] ), (InputStream)inputStream, (byte[])byArray);
    }

    private static int nativeGetWidth(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetWidth", $$robo$$android_graphics_Picture$nativeGetWidth(long ), (long)l);
    }

    private static int nativeGetHeight(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetHeight", $$robo$$android_graphics_Picture$nativeGetHeight(long ), (long)l);
    }

    private static long nativeBeginRecording(long l, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeBeginRecording", $$robo$$android_graphics_Picture$nativeBeginRecording(long int int ), (long)l, (int)n, (int)n2);
    }

    private static void nativeEndRecording(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeEndRecording", $$robo$$android_graphics_Picture$nativeEndRecording(long ), (long)l);
    }

    private static void nativeDraw(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nativeDraw", $$robo$$android_graphics_Picture$nativeDraw(long long ), (long)l, (long)l2);
    }

    private static boolean nativeWriteToStream(long l, OutputStream outputStream, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeWriteToStream", $$robo$$android_graphics_Picture$nativeWriteToStream(long java.io.OutputStream byte[] ), (long)l, (OutputStream)outputStream, (byte[])byArray);
    }

    private static void nativeDestructor(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeDestructor", $$robo$$android_graphics_Picture$nativeDestructor(long ), (long)l);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Picture)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class PictureCanvas
    extends Canvas
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Picture mPicture;
        boolean mHoldsHwBitmap;

        private void $$robo$$android_graphics_Picture_PictureCanvas$__constructor__(Picture pict, long nativeCanvas) {
            this.mPicture = pict;
            this.mDensity = 0;
        }

        private final void $$robo$$android_graphics_Picture_PictureCanvas$setBitmap(Bitmap bitmap) {
            throw new RuntimeException("Cannot call setBitmap on a picture canvas");
        }

        private final void $$robo$$android_graphics_Picture_PictureCanvas$drawPicture(Picture picture) {
            if (this.mPicture == picture) {
                throw new RuntimeException("Cannot draw a picture into its recording canvas");
            }
            super.drawPicture(picture);
        }

        private final void $$robo$$android_graphics_Picture_PictureCanvas$onHwBitmapInSwMode() {
            this.mHoldsHwBitmap = true;
        }

        private void __constructor__(Picture picture, long l) {
            this.$$robo$$android_graphics_Picture_PictureCanvas$__constructor__(picture, l);
        }

        public PictureCanvas(Picture picture, long l) {
            super(l);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Picture_PictureCanvas$__constructor__(android.graphics.Picture long ), this, picture, l);
        }

        @Override
        public void setBitmap(Bitmap bitmap) {
            InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_graphics_Picture_PictureCanvas$setBitmap(android.graphics.Bitmap ), this, bitmap);
        }

        @Override
        public void drawPicture(Picture picture) {
            InvokeDynamicSupport.bootstrap("drawPicture", $$robo$$android_graphics_Picture_PictureCanvas$drawPicture(android.graphics.Picture ), this, picture);
        }

        @Override
        protected void onHwBitmapInSwMode() {
            InvokeDynamicSupport.bootstrap("onHwBitmapInSwMode", $$robo$$android_graphics_Picture_PictureCanvas$onHwBitmapInSwMode(), this);
        }

        public /* synthetic */ PictureCanvas() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PictureCanvas)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

