/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.fonts.FontVariationAxis;
import android.text.TextUtils;
import android.util.Log;
import dalvik.annotation.optimization.CriticalNative;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import libcore.util.NativeAllocationRegistry;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FontFamily
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static NativeAllocationRegistry sBuilderRegistry;
    private Runnable mNativeBuilderCleaner;
    private static NativeAllocationRegistry sFamilyRegistry;
    public long mNativePtr;
    private long mBuilderPtr;

    private void $$robo$$android_graphics_FontFamily$__constructor__() {
        this.mBuilderPtr = FontFamily.nInitBuilder(null, 0);
        this.mNativeBuilderCleaner = sBuilderRegistry.registerNativeAllocation((Object)this, this.mBuilderPtr);
    }

    private void $$robo$$android_graphics_FontFamily$__constructor__(String[] langs, int variant) {
        String langsString = langs == null || langs.length == 0 ? null : (langs.length == 1 ? langs[0] : TextUtils.join((CharSequence)",", langs));
        this.mBuilderPtr = FontFamily.nInitBuilder(langsString, variant);
        this.mNativeBuilderCleaner = sBuilderRegistry.registerNativeAllocation((Object)this, this.mBuilderPtr);
    }

    private final boolean $$robo$$android_graphics_FontFamily$freeze() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen");
        }
        this.mNativePtr = FontFamily.nCreateFamily(this.mBuilderPtr);
        this.mNativeBuilderCleaner.run();
        this.mBuilderPtr = 0L;
        if (this.mNativePtr != 0L) {
            sFamilyRegistry.registerNativeAllocation((Object)this, this.mNativePtr);
        }
        return this.mNativePtr != 0L;
    }

    private final void $$robo$$android_graphics_FontFamily$abortCreation() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen or abandoned");
        }
        this.mNativeBuilderCleaner.run();
        this.mBuilderPtr = 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean $$robo$$android_graphics_FontFamily$addFont(String path, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFont after freezing.");
        }
        try (FileInputStream file = new FileInputStream(path);){
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            MappedByteBuffer fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
            if (axes != null) {
                for (FontVariationAxis axis : axes) {
                    FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
                }
            }
            boolean bl = FontFamily.nAddFont(this.mBuilderPtr, fontBuffer, ttcIndex, weight, italic);
            return bl;
        }
        catch (IOException e) {
            Log.e(TAG, "Error mapping font file " + path);
            return false;
        }
    }

    private final boolean $$robo$$android_graphics_FontFamily$addFontFromBuffer(ByteBuffer font, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontWeightStyle after freezing.");
        }
        if (axes != null) {
            for (FontVariationAxis axis : axes) {
                FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
            }
        }
        return FontFamily.nAddFontWeightStyle(this.mBuilderPtr, font, ttcIndex, weight, italic);
    }

    private final boolean $$robo$$android_graphics_FontFamily$addFontFromAssetManager(AssetManager mgr, String path, int cookie, boolean isAsset, int ttcIndex, int weight, int isItalic, FontVariationAxis[] axes) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontFromAsset after freezing.");
        }
        if (axes != null) {
            for (FontVariationAxis axis : axes) {
                FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
            }
        }
        return FontFamily.nAddFontFromAssetManager(this.mBuilderPtr, mgr, path, cookie, isAsset, ttcIndex, weight, isItalic);
    }

    private static final boolean $$robo$$android_graphics_FontFamily$nAddFont(long builderPtr, ByteBuffer font, int ttcIndex) {
        return FontFamily.nAddFont(builderPtr, font, ttcIndex, -1, -1);
    }

    private static final long $$robo$$android_graphics_FontFamily$nInitBuilder(String string2, int n) {
        return 0L;
    }

    @CriticalNative
    private static final long $$robo$$android_graphics_FontFamily$nCreateFamily(long l) {
        return 0L;
    }

    @CriticalNative
    private static final long $$robo$$android_graphics_FontFamily$nGetBuilderReleaseFunc() {
        return 0L;
    }

    @CriticalNative
    private static final long $$robo$$android_graphics_FontFamily$nGetFamilyReleaseFunc() {
        return 0L;
    }

    private static final boolean $$robo$$android_graphics_FontFamily$nAddFont(long l, ByteBuffer byteBuffer, int n, int n2, int n3) {
        return false;
    }

    private static final boolean $$robo$$android_graphics_FontFamily$nAddFontWeightStyle(long l, ByteBuffer byteBuffer, int n, int n2, int n3) {
        return false;
    }

    private static final boolean $$robo$$android_graphics_FontFamily$nAddFontFromAssetManager(long l, AssetManager assetManager, String string2, int n, boolean bl, int n2, int n3, int n4) {
        return false;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_FontFamily$nAddAxisValue(long l, int n, float f) {
    }

    static void __staticInitializer__() {
        TAG = "FontFamily";
        sBuilderRegistry = new NativeAllocationRegistry(FontFamily.class.getClassLoader(), FontFamily.nGetBuilderReleaseFunc(), 64L);
        sFamilyRegistry = new NativeAllocationRegistry(FontFamily.class.getClassLoader(), FontFamily.nGetFamilyReleaseFunc(), 64L);
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_FontFamily$__constructor__();
    }

    public FontFamily() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_FontFamily$__constructor__(), this);
    }

    private void __constructor__(String[] stringArray, int n) {
        this.$$robo$$android_graphics_FontFamily$__constructor__(stringArray, n);
    }

    public FontFamily(String[] stringArray, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_FontFamily$__constructor__(java.lang.String[] int ), this, stringArray, n);
    }

    public boolean freeze() {
        return (boolean)InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_graphics_FontFamily$freeze(), this);
    }

    public void abortCreation() {
        InvokeDynamicSupport.bootstrap("abortCreation", $$robo$$android_graphics_FontFamily$abortCreation(), this);
    }

    public boolean addFont(String string2, int n, FontVariationAxis[] fontVariationAxisArray, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("addFont", $$robo$$android_graphics_FontFamily$addFont(java.lang.String int android.graphics.fonts.FontVariationAxis[] int int ), this, string2, n, fontVariationAxisArray, n2, n3);
    }

    public boolean addFontFromBuffer(ByteBuffer byteBuffer, int n, FontVariationAxis[] fontVariationAxisArray, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("addFontFromBuffer", $$robo$$android_graphics_FontFamily$addFontFromBuffer(java.nio.ByteBuffer int android.graphics.fonts.FontVariationAxis[] int int ), this, byteBuffer, n, fontVariationAxisArray, n2, n3);
    }

    public boolean addFontFromAssetManager(AssetManager assetManager, String string2, int n, boolean bl, int n2, int n3, int n4, FontVariationAxis[] fontVariationAxisArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("addFontFromAssetManager", $$robo$$android_graphics_FontFamily$addFontFromAssetManager(android.content.res.AssetManager java.lang.String int boolean int int int android.graphics.fonts.FontVariationAxis[] ), this, assetManager, string2, n, bl, n2, n3, n4, fontVariationAxisArray);
    }

    private static boolean nAddFont(long l, ByteBuffer byteBuffer, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nAddFont", $$robo$$android_graphics_FontFamily$nAddFont(long java.nio.ByteBuffer int ), (long)l, (ByteBuffer)byteBuffer, (int)n);
    }

    private static long nInitBuilder(String string2, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nInitBuilder", $$robo$$android_graphics_FontFamily$nInitBuilder(java.lang.String int ), (String)string2, (int)n);
    }

    private static long nCreateFamily(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateFamily", $$robo$$android_graphics_FontFamily$nCreateFamily(long ), (long)l);
    }

    private static long nGetBuilderReleaseFunc() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nGetBuilderReleaseFunc", $$robo$$android_graphics_FontFamily$nGetBuilderReleaseFunc());
    }

    private static long nGetFamilyReleaseFunc() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nGetFamilyReleaseFunc", $$robo$$android_graphics_FontFamily$nGetFamilyReleaseFunc());
    }

    private static boolean nAddFont(long l, ByteBuffer byteBuffer, int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nAddFont", $$robo$$android_graphics_FontFamily$nAddFont(long java.nio.ByteBuffer int int int ), (long)l, (ByteBuffer)byteBuffer, (int)n, (int)n2, (int)n3);
    }

    private static boolean nAddFontWeightStyle(long l, ByteBuffer byteBuffer, int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nAddFontWeightStyle", $$robo$$android_graphics_FontFamily$nAddFontWeightStyle(long java.nio.ByteBuffer int int int ), (long)l, (ByteBuffer)byteBuffer, (int)n, (int)n2, (int)n3);
    }

    private static boolean nAddFontFromAssetManager(long l, AssetManager assetManager, String string2, int n, boolean bl, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nAddFontFromAssetManager", $$robo$$android_graphics_FontFamily$nAddFontFromAssetManager(long android.content.res.AssetManager java.lang.String int boolean int int int ), (long)l, (AssetManager)assetManager, (String)string2, (int)n, (boolean)bl, (int)n2, (int)n3, (int)n4);
    }

    private static void nAddAxisValue(long l, int n, float f) {
        InvokeDynamicSupport.bootstrapStatic("nAddAxisValue", $$robo$$android_graphics_FontFamily$nAddAxisValue(long int float ), (long)l, (int)n, (float)f);
    }

    static {
        RobolectricInternals.classInitializing(FontFamily.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontFamily)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

