/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.GraphRunner;
import android.filterfw.core.Scheduler;
import android.filterfw.core.StopWatchMap;
import android.os.ConditionVariable;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SyncRunner
extends GraphRunner
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Scheduler mScheduler;
    private GraphRunner.OnRunnerDoneListener mDoneListener;
    private ScheduledThreadPoolExecutor mWakeExecutor;
    private ConditionVariable mWakeCondition;
    private StopWatchMap mTimer;
    private boolean mLogVerbose;
    private static String TAG = "SyncRunner";

    private void $$robo$$android_filterfw_core_SyncRunner$__constructor__(FilterContext context, FilterGraph graph, Class schedulerClass) {
        this.mScheduler = null;
        this.mDoneListener = null;
        this.mWakeExecutor = new ScheduledThreadPoolExecutor(1);
        this.mWakeCondition = new ConditionVariable();
        this.mTimer = null;
        this.mLogVerbose = Log.isLoggable("SyncRunner", 2);
        if (this.mLogVerbose) {
            Log.v("SyncRunner", "Initializing SyncRunner");
        }
        if (Scheduler.class.isAssignableFrom(schedulerClass)) {
            try {
                Constructor schedulerConstructor = schedulerClass.getConstructor(FilterGraph.class);
                this.mScheduler = (Scheduler)schedulerConstructor.newInstance(graph);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Scheduler does not have constructor <init>(FilterGraph)!", e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Could not instantiate the Scheduler instance!", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot access Scheduler constructor!", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Scheduler constructor threw an exception", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate Scheduler", e);
            }
        } else {
            throw new IllegalArgumentException("Class provided is not a Scheduler subclass!");
        }
        this.mFilterContext = context;
        this.mFilterContext.addGraph(graph);
        this.mTimer = new StopWatchMap();
        if (this.mLogVerbose) {
            Log.v("SyncRunner", "Setting up filters");
        }
        graph.setupFilters();
    }

    private final FilterGraph $$robo$$android_filterfw_core_SyncRunner$getGraph() {
        return this.mScheduler != null ? this.mScheduler.getGraph() : null;
    }

    private final int $$robo$$android_filterfw_core_SyncRunner$step() {
        this.assertReadyToStep();
        if (!this.getGraph().isReady()) {
            throw new RuntimeException("Trying to process graph that is not open!");
        }
        return this.performStep() ? 1 : this.determinePostRunState();
    }

    private final void $$robo$$android_filterfw_core_SyncRunner$beginProcessing() {
        this.mScheduler.reset();
        this.getGraph().beginProcessing();
    }

    private final void $$robo$$android_filterfw_core_SyncRunner$close() {
        if (this.mLogVerbose) {
            Log.v("SyncRunner", "Closing graph.");
        }
        this.getGraph().closeFilters(this.mFilterContext);
        this.mScheduler.reset();
    }

    private final void $$robo$$android_filterfw_core_SyncRunner$run() {
        if (this.mLogVerbose) {
            Log.v("SyncRunner", "Beginning run.");
        }
        this.assertReadyToStep();
        this.beginProcessing();
        boolean glActivated = this.activateGlContext();
        boolean keepRunning = true;
        while (keepRunning) {
            keepRunning = this.performStep();
        }
        if (glActivated) {
            this.deactivateGlContext();
        }
        if (this.mDoneListener != null) {
            if (this.mLogVerbose) {
                Log.v("SyncRunner", "Calling completion listener.");
            }
            this.mDoneListener.onRunnerDone(this.determinePostRunState());
        }
        if (this.mLogVerbose) {
            Log.v("SyncRunner", "Run complete");
        }
    }

    private final boolean $$robo$$android_filterfw_core_SyncRunner$isRunning() {
        return false;
    }

    private final void $$robo$$android_filterfw_core_SyncRunner$setDoneCallback(GraphRunner.OnRunnerDoneListener listener) {
        this.mDoneListener = listener;
    }

    private final void $$robo$$android_filterfw_core_SyncRunner$stop() {
        throw new RuntimeException("SyncRunner does not support stopping a graph!");
    }

    private final synchronized Exception $$robo$$android_filterfw_core_SyncRunner$getError() {
        return null;
    }

    private final void $$robo$$android_filterfw_core_SyncRunner$waitUntilWake() {
        this.mWakeCondition.block();
    }

    private final void $$robo$$android_filterfw_core_SyncRunner$processFilterNode(Filter filter) {
        if (this.mLogVerbose) {
            Log.v("SyncRunner", "Processing filter node");
        }
        filter.performProcess(this.mFilterContext);
        if (filter.getStatus() == 6) {
            throw new RuntimeException("There was an error executing " + filter + "!");
        }
        if (filter.getStatus() == 4) {
            if (this.mLogVerbose) {
                Log.v("SyncRunner", "Scheduling filter wakeup");
            }
            this.scheduleFilterWake(filter, filter.getSleepDelay());
        }
    }

    private final void $$robo$$android_filterfw_core_SyncRunner$scheduleFilterWake(Filter filter, int delay) {
        this.mWakeCondition.close();
        Filter filterToSchedule = filter;
        ConditionVariable conditionToWake = this.mWakeCondition;
        this.mWakeExecutor.schedule(new Runnable(this, filterToSchedule, conditionToWake){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Filter val$filterToSchedule;
            /* synthetic */ ConditionVariable val$conditionToWake;
            /* synthetic */ SyncRunner this$0;

            private void $$robo$$android_filterfw_core_SyncRunner_1$__constructor__(SyncRunner this$0, Filter filter, ConditionVariable conditionVariable) {
                this.this$0 = this$0;
                this.val$filterToSchedule = filter;
                this.val$conditionToWake = conditionVariable;
            }

            private final void $$robo$$android_filterfw_core_SyncRunner_1$run() {
                this.val$filterToSchedule.unsetStatus(4);
                this.val$conditionToWake.open();
            }

            private void __constructor__(SyncRunner syncRunner, Filter filter, ConditionVariable conditionVariable) {
                this.$$robo$$android_filterfw_core_SyncRunner_1$__constructor__(syncRunner, filter, conditionVariable);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_SyncRunner_1$__constructor__(android.filterfw.core.SyncRunner android.filterfw.core.Filter android.os.ConditionVariable ), this, syncRunner, filter, conditionVariable);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_filterfw_core_SyncRunner_1$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, (long)delay, TimeUnit.MILLISECONDS);
    }

    private final int $$robo$$android_filterfw_core_SyncRunner$determinePostRunState() {
        boolean isBlocked = false;
        for (Filter filter : this.mScheduler.getGraph().getFilters()) {
            if (!filter.isOpen()) continue;
            if (filter.getStatus() == 4) {
                return 3;
            }
            return 4;
        }
        return 2;
    }

    private final boolean $$robo$$android_filterfw_core_SyncRunner$performStep() {
        Filter filter;
        if (this.mLogVerbose) {
            Log.v("SyncRunner", "Performing one step.");
        }
        if ((filter = this.mScheduler.scheduleNextNode()) != null) {
            this.mTimer.start(filter.getName());
            this.processFilterNode(filter);
            this.mTimer.stop(filter.getName());
            return true;
        }
        return false;
    }

    private final void $$robo$$android_filterfw_core_SyncRunner$assertReadyToStep() {
        if (this.mScheduler == null) {
            throw new RuntimeException("Attempting to run schedule with no scheduler in place!");
        }
        if (this.getGraph() == null) {
            throw new RuntimeException("Calling step on scheduler with no graph in place!");
        }
    }

    private void __constructor__(FilterContext filterContext, FilterGraph filterGraph, Class clazz) {
        this.$$robo$$android_filterfw_core_SyncRunner$__constructor__(filterContext, filterGraph, clazz);
    }

    public SyncRunner(FilterContext filterContext, FilterGraph filterGraph, Class clazz) {
        super(filterContext);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_SyncRunner$__constructor__(android.filterfw.core.FilterContext android.filterfw.core.FilterGraph java.lang.Class ), this, filterContext, filterGraph, clazz);
    }

    @Override
    public FilterGraph getGraph() {
        return InvokeDynamicSupport.bootstrap("getGraph", $$robo$$android_filterfw_core_SyncRunner$getGraph(), this);
    }

    public int step() {
        return (int)InvokeDynamicSupport.bootstrap("step", $$robo$$android_filterfw_core_SyncRunner$step(), this);
    }

    public void beginProcessing() {
        InvokeDynamicSupport.bootstrap("beginProcessing", $$robo$$android_filterfw_core_SyncRunner$beginProcessing(), this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_filterfw_core_SyncRunner$close(), this);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$android_filterfw_core_SyncRunner$run(), this);
    }

    @Override
    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_filterfw_core_SyncRunner$isRunning(), this);
    }

    @Override
    public void setDoneCallback(GraphRunner.OnRunnerDoneListener onRunnerDoneListener) {
        InvokeDynamicSupport.bootstrap("setDoneCallback", $$robo$$android_filterfw_core_SyncRunner$setDoneCallback(android.filterfw.core.GraphRunner$OnRunnerDoneListener ), this, onRunnerDoneListener);
    }

    @Override
    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_filterfw_core_SyncRunner$stop(), this);
    }

    @Override
    public synchronized Exception getError() {
        return InvokeDynamicSupport.bootstrap("getError", $$robo$$android_filterfw_core_SyncRunner$getError(), this);
    }

    protected void waitUntilWake() {
        InvokeDynamicSupport.bootstrap("waitUntilWake", $$robo$$android_filterfw_core_SyncRunner$waitUntilWake(), this);
    }

    protected void processFilterNode(Filter filter) {
        InvokeDynamicSupport.bootstrap("processFilterNode", $$robo$$android_filterfw_core_SyncRunner$processFilterNode(android.filterfw.core.Filter ), this, filter);
    }

    protected void scheduleFilterWake(Filter filter, int n) {
        InvokeDynamicSupport.bootstrap("scheduleFilterWake", $$robo$$android_filterfw_core_SyncRunner$scheduleFilterWake(android.filterfw.core.Filter int ), this, filter, n);
    }

    protected int determinePostRunState() {
        return (int)InvokeDynamicSupport.bootstrap("determinePostRunState", $$robo$$android_filterfw_core_SyncRunner$determinePostRunState(), this);
    }

    boolean performStep() {
        return (boolean)InvokeDynamicSupport.bootstrap("performStep", $$robo$$android_filterfw_core_SyncRunner$performStep(), this);
    }

    void assertReadyToStep() {
        InvokeDynamicSupport.bootstrap("assertReadyToStep", $$robo$$android_filterfw_core_SyncRunner$assertReadyToStep(), this);
    }

    public /* synthetic */ SyncRunner() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SyncRunner)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

