/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.Context;
import android.database.DatabaseErrorHandler;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.FileUtils;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.io.File;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class SQLiteOpenHelper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    private Context mContext;
    private String mName;
    private int mNewVersion;
    private int mMinimumSupportedVersion;
    private SQLiteDatabase mDatabase;
    private boolean mIsInitializing;
    private SQLiteDatabase.OpenParams.Builder mOpenParamsBuilder;

    private void $$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
    }

    private void $$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, DatabaseErrorHandler errorHandler) {
    }

    private void $$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(Context context, String name, int version, SQLiteDatabase.OpenParams openParams) {
    }

    private void $$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, int minimumSupportedVersion, DatabaseErrorHandler errorHandler) {
        this.mOpenParamsBuilder.setCursorFactory(factory);
        this.mOpenParamsBuilder.setErrorHandler(errorHandler);
    }

    private void $$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(Context context, String name, int version, int minimumSupportedVersion, SQLiteDatabase.OpenParams.Builder openParamsBuilder) {
        Preconditions.checkNotNull(openParamsBuilder);
        if (version < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + version);
        }
        this.mContext = context;
        this.mName = name;
        this.mNewVersion = version;
        this.mMinimumSupportedVersion = Math.max(0, minimumSupportedVersion);
        this.setOpenParamsBuilder(openParamsBuilder);
    }

    private final String $$robo$$android_database_sqlite_SQLiteOpenHelper$getDatabaseName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteOpenHelper$setWriteAheadLoggingEnabled(boolean enabled) {
        SQLiteOpenHelper sQLiteOpenHelper = this;
        synchronized (sQLiteOpenHelper) {
            if (this.mOpenParamsBuilder.isWriteAheadLoggingEnabled() != enabled) {
                if (this.mDatabase != null && this.mDatabase.isOpen() && !this.mDatabase.isReadOnly()) {
                    if (enabled) {
                        this.mDatabase.enableWriteAheadLogging();
                    } else {
                        this.mDatabase.disableWriteAheadLogging();
                    }
                }
                this.mOpenParamsBuilder.setWriteAheadLoggingEnabled(enabled);
            }
            this.mOpenParamsBuilder.addOpenFlags(0x40000000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteOpenHelper$setLookasideConfig(int slotSize, int slotCount) {
        SQLiteOpenHelper sQLiteOpenHelper = this;
        synchronized (sQLiteOpenHelper) {
            if (this.mDatabase != null && this.mDatabase.isOpen()) {
                throw new IllegalStateException("Lookaside memory config cannot be changed after opening the database");
            }
            this.mOpenParamsBuilder.setLookasideConfig(slotSize, slotCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteOpenHelper$setOpenParams(SQLiteDatabase.OpenParams openParams) {
        Preconditions.checkNotNull(openParams);
        SQLiteOpenHelper sQLiteOpenHelper = this;
        synchronized (sQLiteOpenHelper) {
            if (this.mDatabase != null && this.mDatabase.isOpen()) {
                throw new IllegalStateException("OpenParams cannot be set after opening the database");
            }
            this.setOpenParamsBuilder(new SQLiteDatabase.OpenParams.Builder(openParams));
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteOpenHelper$setOpenParamsBuilder(SQLiteDatabase.OpenParams.Builder openParamsBuilder) {
        this.mOpenParamsBuilder = openParamsBuilder;
        this.mOpenParamsBuilder.addOpenFlags(0x10000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteOpenHelper$setIdleConnectionTimeout(long idleConnectionTimeoutMs) {
        SQLiteOpenHelper sQLiteOpenHelper = this;
        synchronized (sQLiteOpenHelper) {
            if (this.mDatabase != null && this.mDatabase.isOpen()) {
                throw new IllegalStateException("Connection timeout setting cannot be changed after opening the database");
            }
            this.mOpenParamsBuilder.setIdleConnectionTimeout(idleConnectionTimeoutMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteOpenHelper$getWritableDatabase() {
        SQLiteOpenHelper sQLiteOpenHelper = this;
        synchronized (sQLiteOpenHelper) {
            return this.getDatabaseLocked(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteOpenHelper$getReadableDatabase() {
        SQLiteOpenHelper sQLiteOpenHelper = this;
        synchronized (sQLiteOpenHelper) {
            return this.getDatabaseLocked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteOpenHelper$getDatabaseLocked(boolean writable) {
        if (this.mDatabase != null) {
            if (!this.mDatabase.isOpen()) {
                this.mDatabase = null;
            } else if (!writable || !this.mDatabase.isReadOnly()) {
                return this.mDatabase;
            }
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getDatabase called recursively");
        }
        SQLiteDatabase db = this.mDatabase;
        try {
            this.mIsInitializing = true;
            if (db != null) {
                if (writable && db.isReadOnly()) {
                    db.reopenReadWrite();
                }
            } else if (this.mName == null) {
                db = SQLiteDatabase.createInMemory(this.mOpenParamsBuilder.build());
            } else {
                File filePath = this.mContext.getDatabasePath(this.mName);
                SQLiteDatabase.OpenParams params = this.mOpenParamsBuilder.build();
                try {
                    db = SQLiteDatabase.openDatabase(filePath, params);
                    SQLiteOpenHelper.setFilePermissionsForDb(filePath.getPath());
                }
                catch (SQLException ex) {
                    if (writable) {
                        throw ex;
                    }
                    Log.e(TAG, "Couldn't open " + this.mName + " for writing (will try read-only):", ex);
                    params = params.toBuilder().addOpenFlags(1).build();
                    db = SQLiteDatabase.openDatabase(filePath, params);
                }
            }
            this.onConfigure(db);
            int version = db.getVersion();
            if (version != this.mNewVersion) {
                if (db.isReadOnly()) {
                    throw new SQLiteException("Can't upgrade read-only database from version " + db.getVersion() + " to " + this.mNewVersion + ": " + this.mName);
                }
                if (version > 0 && version < this.mMinimumSupportedVersion) {
                    File databaseFile = new File(db.getPath());
                    this.onBeforeDelete(db);
                    db.close();
                    if (SQLiteDatabase.deleteDatabase(databaseFile)) {
                        this.mIsInitializing = false;
                        SQLiteDatabase sQLiteDatabase = this.getDatabaseLocked(writable);
                        return sQLiteDatabase;
                    }
                    throw new IllegalStateException("Unable to delete obsolete database " + this.mName + " with version " + version);
                }
                db.beginTransaction();
                try {
                    if (version == 0) {
                        this.onCreate(db);
                    } else if (version > this.mNewVersion) {
                        this.onDowngrade(db, version, this.mNewVersion);
                    } else {
                        this.onUpgrade(db, version, this.mNewVersion);
                    }
                    db.setVersion(this.mNewVersion);
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            this.onOpen(db);
            if (db.isReadOnly()) {
                Log.w(TAG, "Opened " + this.mName + " in read-only mode");
            }
            this.mDatabase = db;
            SQLiteDatabase sQLiteDatabase = db;
            return sQLiteDatabase;
        }
        finally {
            this.mIsInitializing = false;
            if (db != null && db != this.mDatabase) {
                db.close();
            }
        }
    }

    private static final void $$robo$$android_database_sqlite_SQLiteOpenHelper$setFilePermissionsForDb(String dbPath) {
        int perms = 432;
        FileUtils.setPermissions(dbPath, perms, -1, -1);
    }

    private final synchronized void $$robo$$android_database_sqlite_SQLiteOpenHelper$close() {
        if (this.mIsInitializing) {
            throw new IllegalStateException("Closed during initialization");
        }
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.mDatabase = null;
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteOpenHelper$onConfigure(SQLiteDatabase db) {
    }

    private final void $$robo$$android_database_sqlite_SQLiteOpenHelper$onBeforeDelete(SQLiteDatabase db) {
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);

    private final void $$robo$$android_database_sqlite_SQLiteOpenHelper$onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        throw new SQLiteException("Can't downgrade database from version " + oldVersion + " to " + newVersion);
    }

    private final void $$robo$$android_database_sqlite_SQLiteOpenHelper$onOpen(SQLiteDatabase db) {
    }

    static void __staticInitializer__() {
        TAG = SQLiteOpenHelper.class.getSimpleName();
    }

    private void __constructor__(Context context, String string2, SQLiteDatabase.CursorFactory cursorFactory, int n) {
        this.$$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(context, string2, cursorFactory, n);
    }

    public SQLiteOpenHelper(Context context, String string2, SQLiteDatabase.CursorFactory cursorFactory, int n) {
        this(context, string2, cursorFactory, n, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(android.content.Context java.lang.String android.database.sqlite.SQLiteDatabase$CursorFactory int ), this, context, string2, cursorFactory, n);
    }

    private void __constructor__(Context context, String string2, SQLiteDatabase.CursorFactory cursorFactory, int n, DatabaseErrorHandler databaseErrorHandler) {
        this.$$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(context, string2, cursorFactory, n, databaseErrorHandler);
    }

    public SQLiteOpenHelper(Context context, String string2, SQLiteDatabase.CursorFactory cursorFactory, int n, DatabaseErrorHandler databaseErrorHandler) {
        this(context, string2, cursorFactory, n, 0, databaseErrorHandler);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(android.content.Context java.lang.String android.database.sqlite.SQLiteDatabase$CursorFactory int android.database.DatabaseErrorHandler ), this, context, string2, cursorFactory, n, databaseErrorHandler);
    }

    private void __constructor__(Context context, String string2, int n, SQLiteDatabase.OpenParams openParams) {
        this.$$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(context, string2, n, openParams);
    }

    public SQLiteOpenHelper(Context context, String string2, int n, SQLiteDatabase.OpenParams openParams) {
        this(context, string2, n, 0, openParams.toBuilder());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(android.content.Context java.lang.String int android.database.sqlite.SQLiteDatabase$OpenParams ), this, context, string2, n, openParams);
    }

    private void __constructor__(Context context, String string2, SQLiteDatabase.CursorFactory cursorFactory, int n, int n2, DatabaseErrorHandler databaseErrorHandler) {
        this.$$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(context, string2, cursorFactory, n, n2, databaseErrorHandler);
    }

    public SQLiteOpenHelper(Context context, String string2, SQLiteDatabase.CursorFactory cursorFactory, int n, int n2, DatabaseErrorHandler databaseErrorHandler) {
        this(context, string2, n, n2, new SQLiteDatabase.OpenParams.Builder());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(android.content.Context java.lang.String android.database.sqlite.SQLiteDatabase$CursorFactory int int android.database.DatabaseErrorHandler ), this, context, string2, cursorFactory, n, n2, databaseErrorHandler);
    }

    private void __constructor__(Context context, String string2, int n, int n2, SQLiteDatabase.OpenParams.Builder builder) {
        this.$$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(context, string2, n, n2, builder);
    }

    public SQLiteOpenHelper(Context context, String string2, int n, int n2, SQLiteDatabase.OpenParams.Builder builder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteOpenHelper$__constructor__(android.content.Context java.lang.String int int android.database.sqlite.SQLiteDatabase$OpenParams$Builder ), this, context, string2, n, n2, builder);
    }

    public String getDatabaseName() {
        return InvokeDynamicSupport.bootstrap("getDatabaseName", $$robo$$android_database_sqlite_SQLiteOpenHelper$getDatabaseName(), this);
    }

    public void setWriteAheadLoggingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setWriteAheadLoggingEnabled", $$robo$$android_database_sqlite_SQLiteOpenHelper$setWriteAheadLoggingEnabled(boolean ), this, bl);
    }

    public void setLookasideConfig(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLookasideConfig", $$robo$$android_database_sqlite_SQLiteOpenHelper$setLookasideConfig(int int ), this, n, n2);
    }

    public void setOpenParams(SQLiteDatabase.OpenParams openParams) {
        InvokeDynamicSupport.bootstrap("setOpenParams", $$robo$$android_database_sqlite_SQLiteOpenHelper$setOpenParams(android.database.sqlite.SQLiteDatabase$OpenParams ), this, openParams);
    }

    private void setOpenParamsBuilder(SQLiteDatabase.OpenParams.Builder builder) {
        InvokeDynamicSupport.bootstrap("setOpenParamsBuilder", $$robo$$android_database_sqlite_SQLiteOpenHelper$setOpenParamsBuilder(android.database.sqlite.SQLiteDatabase$OpenParams$Builder ), this, builder);
    }

    public void setIdleConnectionTimeout(long l) {
        InvokeDynamicSupport.bootstrap("setIdleConnectionTimeout", $$robo$$android_database_sqlite_SQLiteOpenHelper$setIdleConnectionTimeout(long ), this, l);
    }

    public SQLiteDatabase getWritableDatabase() {
        return InvokeDynamicSupport.bootstrap("getWritableDatabase", $$robo$$android_database_sqlite_SQLiteOpenHelper$getWritableDatabase(), this);
    }

    public SQLiteDatabase getReadableDatabase() {
        return InvokeDynamicSupport.bootstrap("getReadableDatabase", $$robo$$android_database_sqlite_SQLiteOpenHelper$getReadableDatabase(), this);
    }

    private SQLiteDatabase getDatabaseLocked(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getDatabaseLocked", $$robo$$android_database_sqlite_SQLiteOpenHelper$getDatabaseLocked(boolean ), this, bl);
    }

    private static void setFilePermissionsForDb(String string2) {
        InvokeDynamicSupport.bootstrapStatic("setFilePermissionsForDb", $$robo$$android_database_sqlite_SQLiteOpenHelper$setFilePermissionsForDb(java.lang.String ), (String)string2);
    }

    public synchronized void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_database_sqlite_SQLiteOpenHelper$close(), this);
    }

    public void onConfigure(SQLiteDatabase sQLiteDatabase) {
        InvokeDynamicSupport.bootstrap("onConfigure", $$robo$$android_database_sqlite_SQLiteOpenHelper$onConfigure(android.database.sqlite.SQLiteDatabase ), this, sQLiteDatabase);
    }

    public void onBeforeDelete(SQLiteDatabase sQLiteDatabase) {
        InvokeDynamicSupport.bootstrap("onBeforeDelete", $$robo$$android_database_sqlite_SQLiteOpenHelper$onBeforeDelete(android.database.sqlite.SQLiteDatabase ), this, sQLiteDatabase);
    }

    public void onDowngrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        InvokeDynamicSupport.bootstrap("onDowngrade", $$robo$$android_database_sqlite_SQLiteOpenHelper$onDowngrade(android.database.sqlite.SQLiteDatabase int int ), this, sQLiteDatabase, n, n2);
    }

    public void onOpen(SQLiteDatabase sQLiteDatabase) {
        InvokeDynamicSupport.bootstrap("onOpen", $$robo$$android_database_sqlite_SQLiteOpenHelper$onOpen(android.database.sqlite.SQLiteDatabase ), this, sQLiteDatabase);
    }

    static {
        RobolectricInternals.classInitializing(SQLiteOpenHelper.class);
    }

    public /* synthetic */ SQLiteOpenHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SQLiteOpenHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

