/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.app.ActivityManager;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.DatabaseUtils;
import android.database.DefaultDatabaseErrorHandler;
import android.database.SQLException;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteCompatibilityWalFlags;
import android.database.sqlite.SQLiteConnectionPool;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteCustomFunction;
import android.database.sqlite.SQLiteDatabaseConfiguration;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteDirectCursorDriver;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteGlobal;
import android.database.sqlite.SQLiteQuery;
import android.database.sqlite.SQLiteQueryBuilder;
import android.database.sqlite.SQLiteSession;
import android.database.sqlite.SQLiteStatement;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.CancellationSignal;
import android.os.Looper;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.Printer;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileFilter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SQLiteDatabase
extends SQLiteClosable
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "SQLiteDatabase";
    private static int EVENT_DB_CORRUPT = 75004;
    private static boolean DEBUG_CLOSE_IDLE_CONNECTIONS;
    private static WeakHashMap<SQLiteDatabase, Object> sActiveDatabases;
    private ThreadLocal<SQLiteSession> mThreadSession;
    private CursorFactory mCursorFactory;
    private DatabaseErrorHandler mErrorHandler;
    private Object mLock;
    private CloseGuard mCloseGuardLocked;
    private SQLiteDatabaseConfiguration mConfigurationLocked;
    private SQLiteConnectionPool mConnectionPoolLocked;
    private boolean mHasAttachedDbsLocked;
    public static int CONFLICT_ROLLBACK = 1;
    public static int CONFLICT_ABORT = 2;
    public static int CONFLICT_FAIL = 3;
    public static int CONFLICT_IGNORE = 4;
    public static int CONFLICT_REPLACE = 5;
    public static int CONFLICT_NONE = 0;
    private static String[] CONFLICT_VALUES;
    public static int SQLITE_MAX_LIKE_PATTERN_LENGTH = 50000;
    public static int OPEN_READWRITE = 0;
    public static int OPEN_READONLY = 1;
    private static int OPEN_READ_MASK = 1;
    public static int NO_LOCALIZED_COLLATORS = 16;
    public static int CREATE_IF_NECESSARY = 0x10000000;
    public static int ENABLE_WRITE_AHEAD_LOGGING = 0x20000000;
    public static int DISABLE_COMPATIBILITY_WAL = 0x40000000;
    public static int MAX_SQL_CACHE_SIZE = 100;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_database_sqlite_SQLiteDatabase$__constructor__(String path, int openFlags, CursorFactory cursorFactory, DatabaseErrorHandler errorHandler, int lookasideSlotSize, int lookasideSlotCount, long idleConnectionTimeoutMs, String journalMode, String syncMode) {
        this.mThreadSession = ThreadLocal.withInitial(this::createSession);
        this.mLock = new Object();
        this.mCloseGuardLocked = CloseGuard.get();
        this.mCursorFactory = cursorFactory;
        this.mErrorHandler = errorHandler != null ? errorHandler : new DefaultDatabaseErrorHandler();
        this.mConfigurationLocked = new SQLiteDatabaseConfiguration(path, openFlags);
        this.mConfigurationLocked.lookasideSlotSize = lookasideSlotSize;
        this.mConfigurationLocked.lookasideSlotCount = lookasideSlotCount;
        if (ActivityManager.isLowRamDeviceStatic()) {
            this.mConfigurationLocked.lookasideSlotCount = 0;
            this.mConfigurationLocked.lookasideSlotSize = 0;
        }
        long effectiveTimeoutMs = Long.MAX_VALUE;
        if (!this.mConfigurationLocked.isInMemoryDb()) {
            if (idleConnectionTimeoutMs >= 0L) {
                effectiveTimeoutMs = idleConnectionTimeoutMs;
            } else if (DEBUG_CLOSE_IDLE_CONNECTIONS) {
                effectiveTimeoutMs = SQLiteGlobal.getIdleConnectionTimeout();
            }
        }
        this.mConfigurationLocked.idleConnectionTimeoutMs = effectiveTimeoutMs;
        this.mConfigurationLocked.journalMode = journalMode;
        this.mConfigurationLocked.syncMode = syncMode;
        if (!SQLiteGlobal.isCompatibilityWalSupported() || SQLiteCompatibilityWalFlags.areFlagsSet() && !SQLiteCompatibilityWalFlags.isCompatibilityWalSupported()) {
            this.mConfigurationLocked.openFlags |= 0x40000000;
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$onAllReferencesReleased() {
        this.dispose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteDatabase$dispose(boolean finalized) {
        SQLiteConnectionPool pool;
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = this.mLock;
        synchronized (weakHashMap) {
            if (this.mCloseGuardLocked != null) {
                if (finalized) {
                    this.mCloseGuardLocked.warnIfOpen();
                }
                this.mCloseGuardLocked.close();
            }
            pool = this.mConnectionPoolLocked;
            this.mConnectionPoolLocked = null;
        }
        if (!finalized) {
            weakHashMap = sActiveDatabases;
            synchronized (weakHashMap) {
                sActiveDatabases.remove(this);
            }
            if (pool != null) {
                pool.close();
            }
        }
    }

    private static final int $$robo$$android_database_sqlite_SQLiteDatabase$releaseMemory() {
        return SQLiteGlobal.releaseMemory();
    }

    @Deprecated
    private final void $$robo$$android_database_sqlite_SQLiteDatabase$setLockingEnabled(boolean lockingEnabled) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_database_sqlite_SQLiteDatabase$getLabel() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.label;
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$onCorruption() {
        EventLog.writeEvent(75004, this.getLabel());
        this.mErrorHandler.onCorruption(this);
    }

    private final SQLiteSession $$robo$$android_database_sqlite_SQLiteDatabase$getThreadSession() {
        return this.mThreadSession.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLiteSession $$robo$$android_database_sqlite_SQLiteDatabase$createSession() {
        SQLiteConnectionPool pool;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            pool = this.mConnectionPoolLocked;
        }
        return new SQLiteSession(pool);
    }

    private final int $$robo$$android_database_sqlite_SQLiteDatabase$getThreadDefaultConnectionFlags(boolean readOnly) {
        int flags;
        int n = flags = readOnly ? 1 : 2;
        if (SQLiteDatabase.isMainThread()) {
            flags |= 4;
        }
        return flags;
    }

    private static final boolean $$robo$$android_database_sqlite_SQLiteDatabase$isMainThread() {
        Looper looper = Looper.myLooper();
        return looper != null && looper == Looper.getMainLooper();
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$beginTransaction() {
        this.beginTransaction(null, true);
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$beginTransactionNonExclusive() {
        this.beginTransaction(null, false);
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$beginTransactionWithListener(SQLiteTransactionListener transactionListener) {
        this.beginTransaction(transactionListener, true);
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$beginTransactionWithListenerNonExclusive(SQLiteTransactionListener transactionListener) {
        this.beginTransaction(transactionListener, false);
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$beginTransaction(SQLiteTransactionListener transactionListener, boolean exclusive) {
        this.acquireReference();
        try {
            this.getThreadSession().beginTransaction(exclusive ? 2 : 1, transactionListener, this.getThreadDefaultConnectionFlags(false), null);
        }
        finally {
            this.releaseReference();
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$endTransaction() {
        this.acquireReference();
        try {
            this.getThreadSession().endTransaction(null);
        }
        finally {
            this.releaseReference();
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$setTransactionSuccessful() {
        this.acquireReference();
        try {
            this.getThreadSession().setTransactionSuccessful();
        }
        finally {
            this.releaseReference();
        }
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$inTransaction() {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().hasTransaction();
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$isDbLockedByCurrentThread() {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().hasConnection();
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$isDbLockedByOtherThreads() {
        return false;
    }

    @Deprecated
    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$yieldIfContended() {
        return this.yieldIfContendedHelper(false, -1L);
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$yieldIfContendedSafely() {
        return this.yieldIfContendedHelper(true, -1L);
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$yieldIfContendedSafely(long sleepAfterYieldDelay) {
        return this.yieldIfContendedHelper(true, sleepAfterYieldDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$yieldIfContendedHelper(boolean throwIfUnsafe, long sleepAfterYieldDelay) {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().yieldTransaction(sleepAfterYieldDelay, throwIfUnsafe, null);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    @Deprecated
    private final Map<String, String> $$robo$$android_database_sqlite_SQLiteDatabase$getSyncedTables() {
        return new HashMap<String, String>(0);
    }

    private static final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteDatabase$openDatabase(String path, CursorFactory factory, int flags) {
        return SQLiteDatabase.openDatabase(path, factory, flags, null);
    }

    private static final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteDatabase$openDatabase(File path, OpenParams openParams) {
        return SQLiteDatabase.openDatabase(path.getPath(), openParams);
    }

    private static final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteDatabase$openDatabase(String path, OpenParams openParams) {
        Preconditions.checkArgument(openParams != null, "OpenParams cannot be null");
        SQLiteDatabase db = new SQLiteDatabase(path, openParams.mOpenFlags, openParams.mCursorFactory, openParams.mErrorHandler, openParams.mLookasideSlotSize, openParams.mLookasideSlotCount, openParams.mIdleConnectionTimeout, openParams.mJournalMode, openParams.mSyncMode);
        db.open();
        return db;
    }

    private static final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteDatabase$openDatabase(String path, CursorFactory factory, int flags, DatabaseErrorHandler errorHandler) {
        SQLiteDatabase db = new SQLiteDatabase(path, flags, factory, errorHandler, -1, -1, -1L, null, null);
        db.open();
        return db;
    }

    private static final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteDatabase$openOrCreateDatabase(File file, CursorFactory factory) {
        return SQLiteDatabase.openOrCreateDatabase(file.getPath(), factory);
    }

    private static final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteDatabase$openOrCreateDatabase(String path, CursorFactory factory) {
        return SQLiteDatabase.openDatabase(path, factory, 0x10000000, null);
    }

    private static final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteDatabase$openOrCreateDatabase(String path, CursorFactory factory, DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openDatabase(path, factory, 0x10000000, errorHandler);
    }

    private static final boolean $$robo$$android_database_sqlite_SQLiteDatabase$deleteDatabase(File file) {
        String prefix;
        File[] files;
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        boolean deleted = false;
        deleted |= file.delete();
        deleted |= new File(file.getPath() + "-journal").delete();
        deleted |= new File(file.getPath() + "-shm").delete();
        deleted |= new File(file.getPath() + "-wal").delete();
        File dir = file.getParentFile();
        if (dir != null && (files = dir.listFiles(new FileFilter(prefix = file.getName() + "-mj"){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$prefix;

            private void $$robo$$android_database_sqlite_SQLiteDatabase_1$__constructor__(String string2) {
                this.val$prefix = string2;
            }

            private final boolean $$robo$$android_database_sqlite_SQLiteDatabase_1$accept(File candidate) {
                return candidate.getName().startsWith(this.val$prefix);
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_database_sqlite_SQLiteDatabase_1$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteDatabase_1$__constructor__(java.lang.String ), this, string2);
            }

            @Override
            public boolean accept(File file) {
                return (boolean)InvokeDynamicSupport.bootstrap("accept", $$robo$$android_database_sqlite_SQLiteDatabase_1$accept(java.io.File ), this, file);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        })) != null) {
            for (File masterJournal : files) {
                deleted |= masterJournal.delete();
            }
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteDatabase$reopenReadWrite() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if (!this.isReadOnlyLocked()) {
                return;
            }
            int oldOpenFlags = this.mConfigurationLocked.openFlags;
            this.mConfigurationLocked.openFlags = this.mConfigurationLocked.openFlags & 0xFFFFFFFE | 0;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.openFlags = oldOpenFlags;
                throw ex;
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$open() {
        try {
            try {
                this.openInner();
            }
            catch (SQLiteDatabaseCorruptException ex) {
                this.onCorruption();
                this.openInner();
            }
        }
        catch (SQLiteException ex) {
            Log.e("SQLiteDatabase", "Failed to open database '" + this.getLabel() + "'.", ex);
            this.close();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteDatabase$openInner() {
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = this.mLock;
        synchronized (weakHashMap) {
            if (!$assertionsDisabled && this.mConnectionPoolLocked != null) {
                throw new AssertionError();
            }
            this.mConnectionPoolLocked = SQLiteConnectionPool.open(this.mConfigurationLocked);
            this.mCloseGuardLocked.open("close");
        }
        weakHashMap = sActiveDatabases;
        synchronized (weakHashMap) {
            sActiveDatabases.put(this, null);
        }
    }

    private static final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteDatabase$create(CursorFactory factory) {
        return SQLiteDatabase.openDatabase(":memory:", factory, 0x10000000);
    }

    private static final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteDatabase$createInMemory(OpenParams openParams) {
        return SQLiteDatabase.openDatabase(":memory:", openParams.toBuilder().addOpenFlags(0x10000000).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteDatabase$addCustomFunction(String name, int numArgs, CustomFunction function) {
        SQLiteCustomFunction wrapper = new SQLiteCustomFunction(name, numArgs, function);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            this.mConfigurationLocked.customFunctions.add(wrapper);
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.customFunctions.remove(wrapper);
                throw ex;
            }
        }
    }

    private final int $$robo$$android_database_sqlite_SQLiteDatabase$getVersion() {
        return Long.valueOf(DatabaseUtils.longForQuery(this, "PRAGMA user_version;", null)).intValue();
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$setVersion(int version) {
        this.execSQL("PRAGMA user_version = " + version);
    }

    private final long $$robo$$android_database_sqlite_SQLiteDatabase$getMaximumSize() {
        long pageCount = DatabaseUtils.longForQuery(this, "PRAGMA max_page_count;", null);
        return pageCount * this.getPageSize();
    }

    private final long $$robo$$android_database_sqlite_SQLiteDatabase$setMaximumSize(long numBytes) {
        long pageSize = this.getPageSize();
        long numPages = numBytes / pageSize;
        if (numBytes % pageSize != 0L) {
            ++numPages;
        }
        long newPageCount = DatabaseUtils.longForQuery(this, "PRAGMA max_page_count = " + numPages, null);
        return newPageCount * pageSize;
    }

    private final long $$robo$$android_database_sqlite_SQLiteDatabase$getPageSize() {
        return DatabaseUtils.longForQuery(this, "PRAGMA page_size;", null);
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$setPageSize(long numBytes) {
        this.execSQL("PRAGMA page_size = " + numBytes);
    }

    @Deprecated
    private final void $$robo$$android_database_sqlite_SQLiteDatabase$markTableSyncable(String table, String deletedTable) {
    }

    @Deprecated
    private final void $$robo$$android_database_sqlite_SQLiteDatabase$markTableSyncable(String table, String foreignKey, String updateTable) {
    }

    private static final String $$robo$$android_database_sqlite_SQLiteDatabase$findEditTable(String tables) {
        if (!TextUtils.isEmpty(tables)) {
            int spacepos = tables.indexOf(32);
            int commapos = tables.indexOf(44);
            if (spacepos > 0 && (spacepos < commapos || commapos < 0)) {
                return tables.substring(0, spacepos);
            }
            if (commapos > 0 && (commapos < spacepos || spacepos < 0)) {
                return tables.substring(0, commapos);
            }
            return tables;
        }
        throw new IllegalStateException("Invalid tables");
    }

    private final SQLiteStatement $$robo$$android_database_sqlite_SQLiteDatabase$compileStatement(String sql) throws SQLException {
        this.acquireReference();
        try {
            SQLiteStatement sQLiteStatement = new SQLiteStatement(this, sql, null);
            return sQLiteStatement;
        }
        finally {
            this.releaseReference();
        }
    }

    private final Cursor $$robo$$android_database_sqlite_SQLiteDatabase$query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.queryWithFactory(null, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, null);
    }

    private final Cursor $$robo$$android_database_sqlite_SQLiteDatabase$query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit, CancellationSignal cancellationSignal) {
        return this.queryWithFactory(null, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, cancellationSignal);
    }

    private final Cursor $$robo$$android_database_sqlite_SQLiteDatabase$queryWithFactory(CursorFactory cursorFactory, boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.queryWithFactory(cursorFactory, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Cursor $$robo$$android_database_sqlite_SQLiteDatabase$queryWithFactory(CursorFactory cursorFactory, boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit, CancellationSignal cancellationSignal) {
        this.acquireReference();
        try {
            String sql = SQLiteQueryBuilder.buildQueryString(distinct, table, columns, selection, groupBy, having, orderBy, limit);
            Cursor cursor = this.rawQueryWithFactory(cursorFactory, sql, selectionArgs, SQLiteDatabase.findEditTable(table), cancellationSignal);
            return cursor;
        }
        finally {
            this.releaseReference();
        }
    }

    private final Cursor $$robo$$android_database_sqlite_SQLiteDatabase$query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, null);
    }

    private final Cursor $$robo$$android_database_sqlite_SQLiteDatabase$query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    private final Cursor $$robo$$android_database_sqlite_SQLiteDatabase$rawQuery(String sql, String[] selectionArgs) {
        return this.rawQueryWithFactory(null, sql, selectionArgs, null, null);
    }

    private final Cursor $$robo$$android_database_sqlite_SQLiteDatabase$rawQuery(String sql, String[] selectionArgs, CancellationSignal cancellationSignal) {
        return this.rawQueryWithFactory(null, sql, selectionArgs, null, cancellationSignal);
    }

    private final Cursor $$robo$$android_database_sqlite_SQLiteDatabase$rawQueryWithFactory(CursorFactory cursorFactory, String sql, String[] selectionArgs, String editTable) {
        return this.rawQueryWithFactory(cursorFactory, sql, selectionArgs, editTable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Cursor $$robo$$android_database_sqlite_SQLiteDatabase$rawQueryWithFactory(CursorFactory cursorFactory, String sql, String[] selectionArgs, String editTable, CancellationSignal cancellationSignal) {
        this.acquireReference();
        try {
            SQLiteDirectCursorDriver driver = new SQLiteDirectCursorDriver(this, sql, editTable, cancellationSignal);
            Cursor cursor = driver.query(cursorFactory != null ? cursorFactory : this.mCursorFactory, selectionArgs);
            return cursor;
        }
        finally {
            this.releaseReference();
        }
    }

    private final long $$robo$$android_database_sqlite_SQLiteDatabase$insert(String table, String nullColumnHack, ContentValues values) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, values, 0);
        }
        catch (SQLException e) {
            Log.e("SQLiteDatabase", "Error inserting " + values, e);
            return -1L;
        }
    }

    private final long $$robo$$android_database_sqlite_SQLiteDatabase$insertOrThrow(String table, String nullColumnHack, ContentValues values) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, values, 0);
    }

    private final long $$robo$$android_database_sqlite_SQLiteDatabase$replace(String table, String nullColumnHack, ContentValues initialValues) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
        }
        catch (SQLException e) {
            Log.e("SQLiteDatabase", "Error inserting " + initialValues, e);
            return -1L;
        }
    }

    private final long $$robo$$android_database_sqlite_SQLiteDatabase$replaceOrThrow(String table, String nullColumnHack, ContentValues initialValues) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_database_sqlite_SQLiteDatabase$insertWithOnConflict(String table, String nullColumnHack, ContentValues initialValues, int conflictAlgorithm) {
        this.acquireReference();
        try {
            long l;
            int size;
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT");
            sql.append(CONFLICT_VALUES[conflictAlgorithm]);
            sql.append(" INTO ");
            sql.append(table);
            sql.append('(');
            Object[] bindArgs = null;
            int n = size = initialValues != null && !initialValues.isEmpty() ? initialValues.size() : 0;
            if (size > 0) {
                bindArgs = new Object[size];
                int i = 0;
                for (String colName : initialValues.keySet()) {
                    sql.append(i > 0 ? "," : "");
                    sql.append(colName);
                    bindArgs[i++] = initialValues.get(colName);
                }
                sql.append(')');
                sql.append(" VALUES (");
                for (i = 0; i < size; ++i) {
                    sql.append(i > 0 ? ",?" : "?");
                }
            } else {
                sql.append(nullColumnHack + ") VALUES (NULL");
            }
            sql.append(')');
            SQLiteStatement statement = new SQLiteStatement(this, sql.toString(), bindArgs);
            try {
                l = statement.executeInsert();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return l;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_database_sqlite_SQLiteDatabase$delete(String table, String whereClause, String[] whereArgs) {
        this.acquireReference();
        try {
            int n;
            SQLiteStatement statement = new SQLiteStatement(this, "DELETE FROM " + table + (!TextUtils.isEmpty(whereClause) ? " WHERE " + whereClause : ""), whereArgs);
            try {
                n = statement.executeUpdateDelete();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    private final int $$robo$$android_database_sqlite_SQLiteDatabase$update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        return this.updateWithOnConflict(table, values, whereClause, whereArgs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_database_sqlite_SQLiteDatabase$updateWithOnConflict(String table, ContentValues values, String whereClause, String[] whereArgs, int conflictAlgorithm) {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("Empty values");
        }
        this.acquireReference();
        try {
            int n;
            StringBuilder sql = new StringBuilder(120);
            sql.append("UPDATE ");
            sql.append(CONFLICT_VALUES[conflictAlgorithm]);
            sql.append(table);
            sql.append(" SET ");
            int setValuesSize = values.size();
            int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
            Object[] bindArgs = new Object[bindArgsSize];
            int i = 0;
            for (String colName : values.keySet()) {
                sql.append(i > 0 ? "," : "");
                sql.append(colName);
                bindArgs[i++] = values.get(colName);
                sql.append("=?");
            }
            if (whereArgs != null) {
                for (i = setValuesSize; i < bindArgsSize; ++i) {
                    bindArgs[i] = whereArgs[i - setValuesSize];
                }
            }
            if (!TextUtils.isEmpty(whereClause)) {
                sql.append(" WHERE ");
                sql.append(whereClause);
            }
            SQLiteStatement statement = new SQLiteStatement(this, sql.toString(), bindArgs);
            try {
                n = statement.executeUpdateDelete();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$execSQL(String sql) throws SQLException {
        this.executeSql(sql, null);
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$execSQL(String sql, Object[] bindArgs) throws SQLException {
        if (bindArgs == null) {
            throw new IllegalArgumentException("Empty bindArgs");
        }
        this.executeSql(sql, bindArgs);
    }

    /*
     * Exception decompiling
     */
    private final int $$robo$$android_database_sqlite_SQLiteDatabase$executeSql(String sql, Object[] bindArgs) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$validateSql(String sql, CancellationSignal cancellationSignal) {
        this.getThreadSession().prepare(sql, this.getThreadDefaultConnectionFlags(true), cancellationSignal, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$isReadOnly() {
        Object object = this.mLock;
        synchronized (object) {
            return this.isReadOnlyLocked();
        }
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$isReadOnlyLocked() {
        return (this.mConfigurationLocked.openFlags & 1) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$isInMemoryDatabase() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.isInMemoryDb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$isOpen() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConnectionPoolLocked != null;
        }
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$needUpgrade(int newVersion) {
        return newVersion > this.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_database_sqlite_SQLiteDatabase$getPath() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteDatabase$setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale must not be null.");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            Locale oldLocale = this.mConfigurationLocked.locale;
            this.mConfigurationLocked.locale = locale;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.locale = oldLocale;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteDatabase$setMaxSqlCacheSize(int cacheSize) {
        if (cacheSize > 100 || cacheSize < 0) {
            throw new IllegalStateException("expected value between 0 and 100");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            int oldMaxSqlCacheSize = this.mConfigurationLocked.maxSqlCacheSize;
            this.mConfigurationLocked.maxSqlCacheSize = cacheSize;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.maxSqlCacheSize = oldMaxSqlCacheSize;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteDatabase$setForeignKeyConstraintsEnabled(boolean enable) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if (this.mConfigurationLocked.foreignKeyConstraintsEnabled == enable) {
                return;
            }
            this.mConfigurationLocked.foreignKeyConstraintsEnabled = enable;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.foreignKeyConstraintsEnabled = !enable;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$enableWriteAheadLogging() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if ((this.mConfigurationLocked.openFlags & 0x20000000) != 0) {
                return true;
            }
            if (this.isReadOnlyLocked()) {
                return false;
            }
            if (this.mConfigurationLocked.isInMemoryDb()) {
                Log.i("SQLiteDatabase", "can't enable WAL for memory databases.");
                return false;
            }
            if (this.mHasAttachedDbsLocked) {
                if (Log.isLoggable("SQLiteDatabase", 3)) {
                    Log.d("SQLiteDatabase", "this database: " + this.mConfigurationLocked.label + " has attached databases. can't  enable WAL.");
                }
                return false;
            }
            this.mConfigurationLocked.openFlags |= 0x20000000;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.openFlags &= 0xDFFFFFFF;
                throw ex;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteDatabase$disableWriteAheadLogging() {
        Object object = this.mLock;
        synchronized (object) {
            boolean compatibilityWalDisabled;
            this.throwIfNotOpenLocked();
            int oldFlags = this.mConfigurationLocked.openFlags;
            boolean walDisabled = (oldFlags & 0x20000000) == 0;
            boolean bl = compatibilityWalDisabled = (oldFlags & 0x40000000) != 0;
            if (walDisabled && compatibilityWalDisabled) {
                return;
            }
            this.mConfigurationLocked.openFlags &= 0xDFFFFFFF;
            this.mConfigurationLocked.openFlags |= 0x40000000;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.openFlags = oldFlags;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$isWriteAheadLoggingEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            return (this.mConfigurationLocked.openFlags & 0x20000000) != 0;
        }
    }

    private static final ArrayList<SQLiteDebug.DbStats> $$robo$$android_database_sqlite_SQLiteDatabase$getDbStats() {
        ArrayList<SQLiteDebug.DbStats> dbStatsList = new ArrayList<SQLiteDebug.DbStats>();
        for (SQLiteDatabase db : SQLiteDatabase.getActiveDatabases()) {
            db.collectDbStats(dbStatsList);
        }
        return dbStatsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteDatabase$collectDbStats(ArrayList<SQLiteDebug.DbStats> dbStatsList) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked != null) {
                this.mConnectionPoolLocked.collectDbStats(dbStatsList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ArrayList<SQLiteDatabase> $$robo$$android_database_sqlite_SQLiteDatabase$getActiveDatabases() {
        ArrayList<SQLiteDatabase> databases = new ArrayList<SQLiteDatabase>();
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = sActiveDatabases;
        synchronized (weakHashMap) {
            databases.addAll(sActiveDatabases.keySet());
        }
        return databases;
    }

    private static final void $$robo$$android_database_sqlite_SQLiteDatabase$dumpAll(Printer printer, boolean verbose) {
        for (SQLiteDatabase db : SQLiteDatabase.getActiveDatabases()) {
            db.dump(printer, verbose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteDatabase$dump(Printer printer, boolean verbose) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked != null) {
                printer.println("");
                this.mConnectionPoolLocked.dump(printer, verbose);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Pair<String, String>> $$robo$$android_database_sqlite_SQLiteDatabase$getAttachedDbs() {
        ArrayList<Pair<String, String>> attachedDbs = new ArrayList<Pair<String, String>>();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked == null) {
                return null;
            }
            if (!this.mHasAttachedDbsLocked) {
                attachedDbs.add(new Pair<String, String>("main", this.mConfigurationLocked.path));
                return attachedDbs;
            }
            this.acquireReference();
        }
        try {
            try (Cursor c = null;){
                c = this.rawQuery("pragma database_list;", null);
                while (c.moveToNext()) {
                    attachedDbs.add(new Pair<String, String>(c.getString(1), c.getString(2)));
                }
            }
            ArrayList<Pair<String, String>> arrayList = attachedDbs;
            return arrayList;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_sqlite_SQLiteDatabase$isDatabaseIntegrityOk() {
        this.acquireReference();
        try {
            List<Pair<String, String>> attachedDbs = null;
            try {
                attachedDbs = this.getAttachedDbs();
                if (attachedDbs == null) {
                    throw new IllegalStateException("databaselist for: " + this.getPath() + " couldn't be retrieved. probably because the database is closed");
                }
            }
            catch (SQLiteException e) {
                attachedDbs = new ArrayList<Pair<String, String>>();
                attachedDbs.add(new Pair<String, String>("main", this.getPath()));
            }
            for (int i = 0; i < attachedDbs.size(); ++i) {
                Pair<String, String> p = attachedDbs.get(i);
                try (SQLiteClosable prog = null;){
                    prog = this.compileStatement("PRAGMA " + (String)p.first + ".integrity_check(1);");
                    String rslt = ((SQLiteStatement)prog).simpleQueryForString();
                    if (rslt.equalsIgnoreCase("ok")) continue;
                    Log.e("SQLiteDatabase", "PRAGMA integrity_check on " + (String)p.second + " returned: " + rslt);
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.releaseReference();
        }
        return true;
    }

    private final String $$robo$$android_database_sqlite_SQLiteDatabase$toString() {
        return "SQLiteDatabase: " + this.getPath();
    }

    private final void $$robo$$android_database_sqlite_SQLiteDatabase$throwIfNotOpenLocked() {
        if (this.mConnectionPoolLocked == null) {
            throw new IllegalStateException("The database '" + this.mConfigurationLocked.label + "' is not open.");
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !SQLiteDatabase.class.desiredAssertionStatus();
        DEBUG_CLOSE_IDLE_CONNECTIONS = SystemProperties.getBoolean("persist.debug.sqlite.close_idle_connections", false);
        sActiveDatabases = new WeakHashMap();
        CONFLICT_VALUES = new String[]{"", " OR ROLLBACK ", " OR ABORT ", " OR FAIL ", " OR IGNORE ", " OR REPLACE "};
    }

    private void __constructor__(String string2, int n, CursorFactory cursorFactory, DatabaseErrorHandler databaseErrorHandler, int n2, int n3, long l, String string3, String string4) {
        this.$$robo$$android_database_sqlite_SQLiteDatabase$__constructor__(string2, n, cursorFactory, databaseErrorHandler, n2, n3, l, string3, string4);
    }

    public SQLiteDatabase(String string2, int n, CursorFactory cursorFactory, DatabaseErrorHandler databaseErrorHandler, int n2, int n3, long l, String string3, String string4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteDatabase$__constructor__(java.lang.String int android.database.sqlite.SQLiteDatabase$CursorFactory android.database.DatabaseErrorHandler int int long java.lang.String java.lang.String ), this, string2, n, cursorFactory, databaseErrorHandler, n2, n3, l, string3, string4);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_database_sqlite_SQLiteDatabase$finalize(), this);
    }

    @Override
    protected void onAllReferencesReleased() {
        InvokeDynamicSupport.bootstrap("onAllReferencesReleased", $$robo$$android_database_sqlite_SQLiteDatabase$onAllReferencesReleased(), this);
    }

    private void dispose(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_database_sqlite_SQLiteDatabase$dispose(boolean ), this, bl);
    }

    public static int releaseMemory() {
        return (int)InvokeDynamicSupport.bootstrapStatic("releaseMemory", $$robo$$android_database_sqlite_SQLiteDatabase$releaseMemory());
    }

    @Deprecated
    public void setLockingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLockingEnabled", $$robo$$android_database_sqlite_SQLiteDatabase$setLockingEnabled(boolean ), this, bl);
    }

    String getLabel() {
        return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_database_sqlite_SQLiteDatabase$getLabel(), this);
    }

    void onCorruption() {
        InvokeDynamicSupport.bootstrap("onCorruption", $$robo$$android_database_sqlite_SQLiteDatabase$onCorruption(), this);
    }

    SQLiteSession getThreadSession() {
        return InvokeDynamicSupport.bootstrap("getThreadSession", $$robo$$android_database_sqlite_SQLiteDatabase$getThreadSession(), this);
    }

    SQLiteSession createSession() {
        return InvokeDynamicSupport.bootstrap("createSession", $$robo$$android_database_sqlite_SQLiteDatabase$createSession(), this);
    }

    int getThreadDefaultConnectionFlags(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getThreadDefaultConnectionFlags", $$robo$$android_database_sqlite_SQLiteDatabase$getThreadDefaultConnectionFlags(boolean ), this, bl);
    }

    private static boolean isMainThread() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMainThread", $$robo$$android_database_sqlite_SQLiteDatabase$isMainThread());
    }

    public void beginTransaction() {
        InvokeDynamicSupport.bootstrap("beginTransaction", $$robo$$android_database_sqlite_SQLiteDatabase$beginTransaction(), this);
    }

    public void beginTransactionNonExclusive() {
        InvokeDynamicSupport.bootstrap("beginTransactionNonExclusive", $$robo$$android_database_sqlite_SQLiteDatabase$beginTransactionNonExclusive(), this);
    }

    public void beginTransactionWithListener(SQLiteTransactionListener sQLiteTransactionListener) {
        InvokeDynamicSupport.bootstrap("beginTransactionWithListener", $$robo$$android_database_sqlite_SQLiteDatabase$beginTransactionWithListener(android.database.sqlite.SQLiteTransactionListener ), this, sQLiteTransactionListener);
    }

    public void beginTransactionWithListenerNonExclusive(SQLiteTransactionListener sQLiteTransactionListener) {
        InvokeDynamicSupport.bootstrap("beginTransactionWithListenerNonExclusive", $$robo$$android_database_sqlite_SQLiteDatabase$beginTransactionWithListenerNonExclusive(android.database.sqlite.SQLiteTransactionListener ), this, sQLiteTransactionListener);
    }

    private void beginTransaction(SQLiteTransactionListener sQLiteTransactionListener, boolean bl) {
        InvokeDynamicSupport.bootstrap("beginTransaction", $$robo$$android_database_sqlite_SQLiteDatabase$beginTransaction(android.database.sqlite.SQLiteTransactionListener boolean ), this, sQLiteTransactionListener, bl);
    }

    public void endTransaction() {
        InvokeDynamicSupport.bootstrap("endTransaction", $$robo$$android_database_sqlite_SQLiteDatabase$endTransaction(), this);
    }

    public void setTransactionSuccessful() {
        InvokeDynamicSupport.bootstrap("setTransactionSuccessful", $$robo$$android_database_sqlite_SQLiteDatabase$setTransactionSuccessful(), this);
    }

    public boolean inTransaction() {
        return (boolean)InvokeDynamicSupport.bootstrap("inTransaction", $$robo$$android_database_sqlite_SQLiteDatabase$inTransaction(), this);
    }

    public boolean isDbLockedByCurrentThread() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDbLockedByCurrentThread", $$robo$$android_database_sqlite_SQLiteDatabase$isDbLockedByCurrentThread(), this);
    }

    @Deprecated
    public boolean isDbLockedByOtherThreads() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDbLockedByOtherThreads", $$robo$$android_database_sqlite_SQLiteDatabase$isDbLockedByOtherThreads(), this);
    }

    @Deprecated
    public boolean yieldIfContended() {
        return (boolean)InvokeDynamicSupport.bootstrap("yieldIfContended", $$robo$$android_database_sqlite_SQLiteDatabase$yieldIfContended(), this);
    }

    public boolean yieldIfContendedSafely() {
        return (boolean)InvokeDynamicSupport.bootstrap("yieldIfContendedSafely", $$robo$$android_database_sqlite_SQLiteDatabase$yieldIfContendedSafely(), this);
    }

    public boolean yieldIfContendedSafely(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("yieldIfContendedSafely", $$robo$$android_database_sqlite_SQLiteDatabase$yieldIfContendedSafely(long ), this, l);
    }

    private boolean yieldIfContendedHelper(boolean bl, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("yieldIfContendedHelper", $$robo$$android_database_sqlite_SQLiteDatabase$yieldIfContendedHelper(boolean long ), this, bl, l);
    }

    @Deprecated
    public Map<String, String> getSyncedTables() {
        return InvokeDynamicSupport.bootstrap("getSyncedTables", $$robo$$android_database_sqlite_SQLiteDatabase$getSyncedTables(), this);
    }

    public static SQLiteDatabase openDatabase(String string2, CursorFactory cursorFactory, int n) {
        return InvokeDynamicSupport.bootstrapStatic("openDatabase", $$robo$$android_database_sqlite_SQLiteDatabase$openDatabase(java.lang.String android.database.sqlite.SQLiteDatabase$CursorFactory int ), (String)string2, (CursorFactory)cursorFactory, (int)n);
    }

    public static SQLiteDatabase openDatabase(File file, OpenParams openParams) {
        return InvokeDynamicSupport.bootstrapStatic("openDatabase", $$robo$$android_database_sqlite_SQLiteDatabase$openDatabase(java.io.File android.database.sqlite.SQLiteDatabase$OpenParams ), (File)file, (OpenParams)openParams);
    }

    private static SQLiteDatabase openDatabase(String string2, OpenParams openParams) {
        return InvokeDynamicSupport.bootstrapStatic("openDatabase", $$robo$$android_database_sqlite_SQLiteDatabase$openDatabase(java.lang.String android.database.sqlite.SQLiteDatabase$OpenParams ), (String)string2, (OpenParams)openParams);
    }

    public static SQLiteDatabase openDatabase(String string2, CursorFactory cursorFactory, int n, DatabaseErrorHandler databaseErrorHandler) {
        return InvokeDynamicSupport.bootstrapStatic("openDatabase", $$robo$$android_database_sqlite_SQLiteDatabase$openDatabase(java.lang.String android.database.sqlite.SQLiteDatabase$CursorFactory int android.database.DatabaseErrorHandler ), (String)string2, (CursorFactory)cursorFactory, (int)n, (DatabaseErrorHandler)databaseErrorHandler);
    }

    public static SQLiteDatabase openOrCreateDatabase(File file, CursorFactory cursorFactory) {
        return InvokeDynamicSupport.bootstrapStatic("openOrCreateDatabase", $$robo$$android_database_sqlite_SQLiteDatabase$openOrCreateDatabase(java.io.File android.database.sqlite.SQLiteDatabase$CursorFactory ), (File)file, (CursorFactory)cursorFactory);
    }

    public static SQLiteDatabase openOrCreateDatabase(String string2, CursorFactory cursorFactory) {
        return InvokeDynamicSupport.bootstrapStatic("openOrCreateDatabase", $$robo$$android_database_sqlite_SQLiteDatabase$openOrCreateDatabase(java.lang.String android.database.sqlite.SQLiteDatabase$CursorFactory ), (String)string2, (CursorFactory)cursorFactory);
    }

    public static SQLiteDatabase openOrCreateDatabase(String string2, CursorFactory cursorFactory, DatabaseErrorHandler databaseErrorHandler) {
        return InvokeDynamicSupport.bootstrapStatic("openOrCreateDatabase", $$robo$$android_database_sqlite_SQLiteDatabase$openOrCreateDatabase(java.lang.String android.database.sqlite.SQLiteDatabase$CursorFactory android.database.DatabaseErrorHandler ), (String)string2, (CursorFactory)cursorFactory, (DatabaseErrorHandler)databaseErrorHandler);
    }

    public static boolean deleteDatabase(File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deleteDatabase", $$robo$$android_database_sqlite_SQLiteDatabase$deleteDatabase(java.io.File ), (File)file);
    }

    public void reopenReadWrite() {
        InvokeDynamicSupport.bootstrap("reopenReadWrite", $$robo$$android_database_sqlite_SQLiteDatabase$reopenReadWrite(), this);
    }

    private void open() {
        InvokeDynamicSupport.bootstrap("open", $$robo$$android_database_sqlite_SQLiteDatabase$open(), this);
    }

    private void openInner() {
        InvokeDynamicSupport.bootstrap("openInner", $$robo$$android_database_sqlite_SQLiteDatabase$openInner(), this);
    }

    public static SQLiteDatabase create(CursorFactory cursorFactory) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_database_sqlite_SQLiteDatabase$create(android.database.sqlite.SQLiteDatabase$CursorFactory ), (CursorFactory)cursorFactory);
    }

    public static SQLiteDatabase createInMemory(OpenParams openParams) {
        return InvokeDynamicSupport.bootstrapStatic("createInMemory", $$robo$$android_database_sqlite_SQLiteDatabase$createInMemory(android.database.sqlite.SQLiteDatabase$OpenParams ), (OpenParams)openParams);
    }

    public void addCustomFunction(String string2, int n, CustomFunction customFunction) {
        InvokeDynamicSupport.bootstrap("addCustomFunction", $$robo$$android_database_sqlite_SQLiteDatabase$addCustomFunction(java.lang.String int android.database.sqlite.SQLiteDatabase$CustomFunction ), this, string2, n, customFunction);
    }

    public int getVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getVersion", $$robo$$android_database_sqlite_SQLiteDatabase$getVersion(), this);
    }

    public void setVersion(int n) {
        InvokeDynamicSupport.bootstrap("setVersion", $$robo$$android_database_sqlite_SQLiteDatabase$setVersion(int ), this, n);
    }

    public long getMaximumSize() {
        return (long)InvokeDynamicSupport.bootstrap("getMaximumSize", $$robo$$android_database_sqlite_SQLiteDatabase$getMaximumSize(), this);
    }

    public long setMaximumSize(long l) {
        return (long)InvokeDynamicSupport.bootstrap("setMaximumSize", $$robo$$android_database_sqlite_SQLiteDatabase$setMaximumSize(long ), this, l);
    }

    public long getPageSize() {
        return (long)InvokeDynamicSupport.bootstrap("getPageSize", $$robo$$android_database_sqlite_SQLiteDatabase$getPageSize(), this);
    }

    public void setPageSize(long l) {
        InvokeDynamicSupport.bootstrap("setPageSize", $$robo$$android_database_sqlite_SQLiteDatabase$setPageSize(long ), this, l);
    }

    @Deprecated
    public void markTableSyncable(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("markTableSyncable", $$robo$$android_database_sqlite_SQLiteDatabase$markTableSyncable(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Deprecated
    public void markTableSyncable(String string2, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("markTableSyncable", $$robo$$android_database_sqlite_SQLiteDatabase$markTableSyncable(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    public static String findEditTable(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("findEditTable", $$robo$$android_database_sqlite_SQLiteDatabase$findEditTable(java.lang.String ), (String)string2);
    }

    public SQLiteStatement compileStatement(String string2) throws SQLException {
        return InvokeDynamicSupport.bootstrap("compileStatement", $$robo$$android_database_sqlite_SQLiteDatabase$compileStatement(java.lang.String ), this, string2);
    }

    public Cursor query(boolean bl, String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_database_sqlite_SQLiteDatabase$query(boolean java.lang.String java.lang.String[] java.lang.String java.lang.String[] java.lang.String java.lang.String java.lang.String java.lang.String ), this, bl, string2, stringArray, string3, stringArray2, string4, string5, string6, string7);
    }

    public Cursor query(boolean bl, String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_database_sqlite_SQLiteDatabase$query(boolean java.lang.String java.lang.String[] java.lang.String java.lang.String[] java.lang.String java.lang.String java.lang.String java.lang.String android.os.CancellationSignal ), this, bl, string2, stringArray, string3, stringArray2, string4, string5, string6, string7, cancellationSignal);
    }

    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean bl, String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7) {
        return InvokeDynamicSupport.bootstrap("queryWithFactory", $$robo$$android_database_sqlite_SQLiteDatabase$queryWithFactory(android.database.sqlite.SQLiteDatabase$CursorFactory boolean java.lang.String java.lang.String[] java.lang.String java.lang.String[] java.lang.String java.lang.String java.lang.String java.lang.String ), this, cursorFactory, bl, string2, stringArray, string3, stringArray2, string4, string5, string6, string7);
    }

    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean bl, String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("queryWithFactory", $$robo$$android_database_sqlite_SQLiteDatabase$queryWithFactory(android.database.sqlite.SQLiteDatabase$CursorFactory boolean java.lang.String java.lang.String[] java.lang.String java.lang.String[] java.lang.String java.lang.String java.lang.String java.lang.String android.os.CancellationSignal ), this, cursorFactory, bl, string2, stringArray, string3, stringArray2, string4, string5, string6, string7, cancellationSignal);
    }

    public Cursor query(String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_database_sqlite_SQLiteDatabase$query(java.lang.String java.lang.String[] java.lang.String java.lang.String[] java.lang.String java.lang.String java.lang.String ), this, string2, stringArray, string3, stringArray2, string4, string5, string6);
    }

    public Cursor query(String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_database_sqlite_SQLiteDatabase$query(java.lang.String java.lang.String[] java.lang.String java.lang.String[] java.lang.String java.lang.String java.lang.String java.lang.String ), this, string2, stringArray, string3, stringArray2, string4, string5, string6, string7);
    }

    public Cursor rawQuery(String string2, String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("rawQuery", $$robo$$android_database_sqlite_SQLiteDatabase$rawQuery(java.lang.String java.lang.String[] ), this, string2, stringArray);
    }

    public Cursor rawQuery(String string2, String[] stringArray, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("rawQuery", $$robo$$android_database_sqlite_SQLiteDatabase$rawQuery(java.lang.String java.lang.String[] android.os.CancellationSignal ), this, string2, stringArray, cancellationSignal);
    }

    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String string2, String[] stringArray, String string3) {
        return InvokeDynamicSupport.bootstrap("rawQueryWithFactory", $$robo$$android_database_sqlite_SQLiteDatabase$rawQueryWithFactory(android.database.sqlite.SQLiteDatabase$CursorFactory java.lang.String java.lang.String[] java.lang.String ), this, cursorFactory, string2, stringArray, string3);
    }

    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String string2, String[] stringArray, String string3, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("rawQueryWithFactory", $$robo$$android_database_sqlite_SQLiteDatabase$rawQueryWithFactory(android.database.sqlite.SQLiteDatabase$CursorFactory java.lang.String java.lang.String[] java.lang.String android.os.CancellationSignal ), this, cursorFactory, string2, stringArray, string3, cancellationSignal);
    }

    public long insert(String string2, String string3, ContentValues contentValues) {
        return (long)InvokeDynamicSupport.bootstrap("insert", $$robo$$android_database_sqlite_SQLiteDatabase$insert(java.lang.String java.lang.String android.content.ContentValues ), this, string2, string3, contentValues);
    }

    public long insertOrThrow(String string2, String string3, ContentValues contentValues) throws SQLException {
        return (long)InvokeDynamicSupport.bootstrap("insertOrThrow", $$robo$$android_database_sqlite_SQLiteDatabase$insertOrThrow(java.lang.String java.lang.String android.content.ContentValues ), this, string2, string3, contentValues);
    }

    public long replace(String string2, String string3, ContentValues contentValues) {
        return (long)InvokeDynamicSupport.bootstrap("replace", $$robo$$android_database_sqlite_SQLiteDatabase$replace(java.lang.String java.lang.String android.content.ContentValues ), this, string2, string3, contentValues);
    }

    public long replaceOrThrow(String string2, String string3, ContentValues contentValues) throws SQLException {
        return (long)InvokeDynamicSupport.bootstrap("replaceOrThrow", $$robo$$android_database_sqlite_SQLiteDatabase$replaceOrThrow(java.lang.String java.lang.String android.content.ContentValues ), this, string2, string3, contentValues);
    }

    public long insertWithOnConflict(String string2, String string3, ContentValues contentValues, int n) {
        return (long)InvokeDynamicSupport.bootstrap("insertWithOnConflict", $$robo$$android_database_sqlite_SQLiteDatabase$insertWithOnConflict(java.lang.String java.lang.String android.content.ContentValues int ), this, string2, string3, contentValues, n);
    }

    public int delete(String string2, String string3, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("delete", $$robo$$android_database_sqlite_SQLiteDatabase$delete(java.lang.String java.lang.String java.lang.String[] ), this, string2, string3, stringArray);
    }

    public int update(String string2, ContentValues contentValues, String string3, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("update", $$robo$$android_database_sqlite_SQLiteDatabase$update(java.lang.String android.content.ContentValues java.lang.String java.lang.String[] ), this, string2, contentValues, string3, stringArray);
    }

    public int updateWithOnConflict(String string2, ContentValues contentValues, String string3, String[] stringArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("updateWithOnConflict", $$robo$$android_database_sqlite_SQLiteDatabase$updateWithOnConflict(java.lang.String android.content.ContentValues java.lang.String java.lang.String[] int ), this, string2, contentValues, string3, stringArray, n);
    }

    public void execSQL(String string2) throws SQLException {
        InvokeDynamicSupport.bootstrap("execSQL", $$robo$$android_database_sqlite_SQLiteDatabase$execSQL(java.lang.String ), this, string2);
    }

    public void execSQL(String string2, Object[] objectArray) throws SQLException {
        InvokeDynamicSupport.bootstrap("execSQL", $$robo$$android_database_sqlite_SQLiteDatabase$execSQL(java.lang.String java.lang.Object[] ), this, string2, objectArray);
    }

    private int executeSql(String string2, Object[] objectArray) throws SQLException {
        return (int)InvokeDynamicSupport.bootstrap("executeSql", $$robo$$android_database_sqlite_SQLiteDatabase$executeSql(java.lang.String java.lang.Object[] ), this, string2, objectArray);
    }

    public void validateSql(String string2, CancellationSignal cancellationSignal) {
        InvokeDynamicSupport.bootstrap("validateSql", $$robo$$android_database_sqlite_SQLiteDatabase$validateSql(java.lang.String android.os.CancellationSignal ), this, string2, cancellationSignal);
    }

    public boolean isReadOnly() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReadOnly", $$robo$$android_database_sqlite_SQLiteDatabase$isReadOnly(), this);
    }

    private boolean isReadOnlyLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReadOnlyLocked", $$robo$$android_database_sqlite_SQLiteDatabase$isReadOnlyLocked(), this);
    }

    public boolean isInMemoryDatabase() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInMemoryDatabase", $$robo$$android_database_sqlite_SQLiteDatabase$isInMemoryDatabase(), this);
    }

    public boolean isOpen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpen", $$robo$$android_database_sqlite_SQLiteDatabase$isOpen(), this);
    }

    public boolean needUpgrade(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("needUpgrade", $$robo$$android_database_sqlite_SQLiteDatabase$needUpgrade(int ), this, n);
    }

    public String getPath() {
        return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_database_sqlite_SQLiteDatabase$getPath(), this);
    }

    public void setLocale(Locale locale) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_database_sqlite_SQLiteDatabase$setLocale(java.util.Locale ), this, locale);
    }

    public void setMaxSqlCacheSize(int n) {
        InvokeDynamicSupport.bootstrap("setMaxSqlCacheSize", $$robo$$android_database_sqlite_SQLiteDatabase$setMaxSqlCacheSize(int ), this, n);
    }

    public void setForeignKeyConstraintsEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setForeignKeyConstraintsEnabled", $$robo$$android_database_sqlite_SQLiteDatabase$setForeignKeyConstraintsEnabled(boolean ), this, bl);
    }

    public boolean enableWriteAheadLogging() {
        return (boolean)InvokeDynamicSupport.bootstrap("enableWriteAheadLogging", $$robo$$android_database_sqlite_SQLiteDatabase$enableWriteAheadLogging(), this);
    }

    public void disableWriteAheadLogging() {
        InvokeDynamicSupport.bootstrap("disableWriteAheadLogging", $$robo$$android_database_sqlite_SQLiteDatabase$disableWriteAheadLogging(), this);
    }

    public boolean isWriteAheadLoggingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWriteAheadLoggingEnabled", $$robo$$android_database_sqlite_SQLiteDatabase$isWriteAheadLoggingEnabled(), this);
    }

    static ArrayList<SQLiteDebug.DbStats> getDbStats() {
        return InvokeDynamicSupport.bootstrapStatic("getDbStats", $$robo$$android_database_sqlite_SQLiteDatabase$getDbStats());
    }

    private void collectDbStats(ArrayList<SQLiteDebug.DbStats> arrayList) {
        InvokeDynamicSupport.bootstrap("collectDbStats", $$robo$$android_database_sqlite_SQLiteDatabase$collectDbStats(java.util.ArrayList<android.database.sqlite.SQLiteDebug$DbStats> ), this, arrayList);
    }

    private static ArrayList<SQLiteDatabase> getActiveDatabases() {
        return InvokeDynamicSupport.bootstrapStatic("getActiveDatabases", $$robo$$android_database_sqlite_SQLiteDatabase$getActiveDatabases());
    }

    static void dumpAll(Printer printer, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("dumpAll", $$robo$$android_database_sqlite_SQLiteDatabase$dumpAll(android.util.Printer boolean ), (Printer)printer, (boolean)bl);
    }

    private void dump(Printer printer, boolean bl) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_database_sqlite_SQLiteDatabase$dump(android.util.Printer boolean ), this, printer, bl);
    }

    public List<Pair<String, String>> getAttachedDbs() {
        return InvokeDynamicSupport.bootstrap("getAttachedDbs", $$robo$$android_database_sqlite_SQLiteDatabase$getAttachedDbs(), this);
    }

    public boolean isDatabaseIntegrityOk() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDatabaseIntegrityOk", $$robo$$android_database_sqlite_SQLiteDatabase$isDatabaseIntegrityOk(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_database_sqlite_SQLiteDatabase$toString(), this);
    }

    private void throwIfNotOpenLocked() {
        InvokeDynamicSupport.bootstrap("throwIfNotOpenLocked", $$robo$$android_database_sqlite_SQLiteDatabase$throwIfNotOpenLocked(), this);
    }

    static {
        RobolectricInternals.classInitializing(SQLiteDatabase.class);
    }

    public /* synthetic */ SQLiteDatabase() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SQLiteDatabase)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DatabaseOpenFlags {
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class OpenParams
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mOpenFlags;
        private CursorFactory mCursorFactory;
        private DatabaseErrorHandler mErrorHandler;
        private int mLookasideSlotSize;
        private int mLookasideSlotCount;
        private long mIdleConnectionTimeout;
        private String mJournalMode;
        private String mSyncMode;

        private void $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$__constructor__(int openFlags, CursorFactory cursorFactory, DatabaseErrorHandler errorHandler, int lookasideSlotSize, int lookasideSlotCount, long idleConnectionTimeout, String journalMode, String syncMode) {
            this.mOpenFlags = openFlags;
            this.mCursorFactory = cursorFactory;
            this.mErrorHandler = errorHandler;
            this.mLookasideSlotSize = lookasideSlotSize;
            this.mLookasideSlotCount = lookasideSlotCount;
            this.mIdleConnectionTimeout = idleConnectionTimeout;
            this.mJournalMode = journalMode;
            this.mSyncMode = syncMode;
        }

        private final int $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getLookasideSlotSize() {
            return this.mLookasideSlotSize;
        }

        private final int $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getLookasideSlotCount() {
            return this.mLookasideSlotCount;
        }

        private final int $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getOpenFlags() {
            return this.mOpenFlags;
        }

        private final CursorFactory $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getCursorFactory() {
            return this.mCursorFactory;
        }

        private final DatabaseErrorHandler $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getErrorHandler() {
            return this.mErrorHandler;
        }

        private final long $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getIdleConnectionTimeout() {
            return this.mIdleConnectionTimeout;
        }

        private final String $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getJournalMode() {
            return this.mJournalMode;
        }

        private final String $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getSynchronousMode() {
            return this.mSyncMode;
        }

        private final Builder $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$toBuilder() {
            return new Builder(this);
        }

        private /* synthetic */ void $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$__constructor__(int x0, CursorFactory x1, DatabaseErrorHandler x2, int x3, int x4, long x5, String x6, String x7, 1 x8) {
        }

        private void __constructor__(int n, CursorFactory cursorFactory, DatabaseErrorHandler databaseErrorHandler, int n2, int n3, long l, String string2, String string3) {
            this.$$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$__constructor__(n, cursorFactory, databaseErrorHandler, n2, n3, l, string2, string3);
        }

        public OpenParams(int n, CursorFactory cursorFactory, DatabaseErrorHandler databaseErrorHandler, int n2, int n3, long l, String string2, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$__constructor__(int android.database.sqlite.SQLiteDatabase$CursorFactory android.database.DatabaseErrorHandler int int long java.lang.String java.lang.String ), this, n, cursorFactory, databaseErrorHandler, n2, n3, l, string2, string3);
        }

        public int getLookasideSlotSize() {
            return (int)InvokeDynamicSupport.bootstrap("getLookasideSlotSize", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getLookasideSlotSize(), this);
        }

        public int getLookasideSlotCount() {
            return (int)InvokeDynamicSupport.bootstrap("getLookasideSlotCount", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getLookasideSlotCount(), this);
        }

        public int getOpenFlags() {
            return (int)InvokeDynamicSupport.bootstrap("getOpenFlags", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getOpenFlags(), this);
        }

        public CursorFactory getCursorFactory() {
            return InvokeDynamicSupport.bootstrap("getCursorFactory", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getCursorFactory(), this);
        }

        public DatabaseErrorHandler getErrorHandler() {
            return InvokeDynamicSupport.bootstrap("getErrorHandler", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getErrorHandler(), this);
        }

        public long getIdleConnectionTimeout() {
            return (long)InvokeDynamicSupport.bootstrap("getIdleConnectionTimeout", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getIdleConnectionTimeout(), this);
        }

        public String getJournalMode() {
            return InvokeDynamicSupport.bootstrap("getJournalMode", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getJournalMode(), this);
        }

        public String getSynchronousMode() {
            return InvokeDynamicSupport.bootstrap("getSynchronousMode", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$getSynchronousMode(), this);
        }

        public Builder toBuilder() {
            return InvokeDynamicSupport.bootstrap("toBuilder", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$toBuilder(), this);
        }

        private /* synthetic */ void __constructor__(int n, CursorFactory cursorFactory, DatabaseErrorHandler databaseErrorHandler, int n2, int n3, long l, String string2, String string3, 1 var10_9) {
            this.$$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$__constructor__(n, cursorFactory, databaseErrorHandler, n2, n3, l, string2, string3, var10_9);
        }

        public /* synthetic */ OpenParams(int n, CursorFactory cursorFactory, DatabaseErrorHandler databaseErrorHandler, int n2, int n3, long l, String string2, String string3, 1 var10_9) {
            this(n, cursorFactory, databaseErrorHandler, n2, n3, l, string2, string3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams$__constructor__(int android.database.sqlite.SQLiteDatabase$CursorFactory android.database.DatabaseErrorHandler int int long java.lang.String java.lang.String android.database.sqlite.SQLiteDatabase$1 ), this, n, cursorFactory, databaseErrorHandler, n2, n3, l, string2, string3, var10_9);
        }

        public /* synthetic */ OpenParams() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OpenParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Builder
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private int mLookasideSlotSize;
            private int mLookasideSlotCount;
            private long mIdleConnectionTimeout;
            private int mOpenFlags;
            private CursorFactory mCursorFactory;
            private DatabaseErrorHandler mErrorHandler;
            private String mJournalMode;
            private String mSyncMode;

            private void $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$__constructor__() {
                this.mLookasideSlotSize = -1;
                this.mLookasideSlotCount = -1;
                this.mIdleConnectionTimeout = -1L;
            }

            private void $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$__constructor__(OpenParams params) {
                this.mLookasideSlotSize = -1;
                this.mLookasideSlotCount = -1;
                this.mIdleConnectionTimeout = -1L;
                this.mLookasideSlotSize = params.mLookasideSlotSize;
                this.mLookasideSlotCount = params.mLookasideSlotCount;
                this.mOpenFlags = params.mOpenFlags;
                this.mCursorFactory = params.mCursorFactory;
                this.mErrorHandler = params.mErrorHandler;
                this.mJournalMode = params.mJournalMode;
                this.mSyncMode = params.mSyncMode;
            }

            private final Builder $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setLookasideConfig(int slotSize, int slotCount) {
                Preconditions.checkArgument(slotSize >= 0, "lookasideSlotCount cannot be negative");
                Preconditions.checkArgument(slotCount >= 0, "lookasideSlotSize cannot be negative");
                Preconditions.checkArgument(slotSize > 0 && slotCount > 0 || slotCount == 0 && slotSize == 0, "Invalid configuration: " + slotSize + ", " + slotCount);
                this.mLookasideSlotSize = slotSize;
                this.mLookasideSlotCount = slotCount;
                return this;
            }

            private final boolean $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$isWriteAheadLoggingEnabled() {
                return (this.mOpenFlags & 0x20000000) != 0;
            }

            private final Builder $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setOpenFlags(int openFlags) {
                this.mOpenFlags = openFlags;
                return this;
            }

            private final Builder $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$addOpenFlags(int openFlags) {
                this.mOpenFlags |= openFlags;
                return this;
            }

            private final Builder $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$removeOpenFlags(int openFlags) {
                this.mOpenFlags &= ~openFlags;
                return this;
            }

            private final void $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setWriteAheadLoggingEnabled(boolean enabled) {
                if (enabled) {
                    this.addOpenFlags(0x20000000);
                } else {
                    this.removeOpenFlags(0x20000000);
                }
            }

            private final Builder $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setCursorFactory(CursorFactory cursorFactory) {
                this.mCursorFactory = cursorFactory;
                return this;
            }

            private final Builder $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setErrorHandler(DatabaseErrorHandler errorHandler) {
                this.mErrorHandler = errorHandler;
                return this;
            }

            private final Builder $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setIdleConnectionTimeout(long idleConnectionTimeoutMs) {
                Preconditions.checkArgument(idleConnectionTimeoutMs >= 0L, "idle connection timeout cannot be negative");
                this.mIdleConnectionTimeout = idleConnectionTimeoutMs;
                return this;
            }

            private final Builder $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setJournalMode(String journalMode) {
                Preconditions.checkNotNull(journalMode);
                this.mJournalMode = journalMode;
                return this;
            }

            private final Builder $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setSynchronousMode(String syncMode) {
                Preconditions.checkNotNull(syncMode);
                this.mSyncMode = syncMode;
                return this;
            }

            private final OpenParams $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$build() {
                return new OpenParams(this.mOpenFlags, this.mCursorFactory, this.mErrorHandler, this.mLookasideSlotSize, this.mLookasideSlotCount, this.mIdleConnectionTimeout, this.mJournalMode, this.mSyncMode, null);
            }

            private void __constructor__() {
                this.$$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$__constructor__();
            }

            public Builder() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$__constructor__(), this);
            }

            private void __constructor__(OpenParams openParams) {
                this.$$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$__constructor__(openParams);
            }

            public Builder(OpenParams openParams) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$__constructor__(android.database.sqlite.SQLiteDatabase$OpenParams ), this, openParams);
            }

            public Builder setLookasideConfig(int n, int n2) {
                return InvokeDynamicSupport.bootstrap("setLookasideConfig", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setLookasideConfig(int int ), this, n, n2);
            }

            public boolean isWriteAheadLoggingEnabled() {
                return (boolean)InvokeDynamicSupport.bootstrap("isWriteAheadLoggingEnabled", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$isWriteAheadLoggingEnabled(), this);
            }

            public Builder setOpenFlags(int n) {
                return InvokeDynamicSupport.bootstrap("setOpenFlags", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setOpenFlags(int ), this, n);
            }

            public Builder addOpenFlags(int n) {
                return InvokeDynamicSupport.bootstrap("addOpenFlags", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$addOpenFlags(int ), this, n);
            }

            public Builder removeOpenFlags(int n) {
                return InvokeDynamicSupport.bootstrap("removeOpenFlags", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$removeOpenFlags(int ), this, n);
            }

            public void setWriteAheadLoggingEnabled(boolean bl) {
                InvokeDynamicSupport.bootstrap("setWriteAheadLoggingEnabled", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setWriteAheadLoggingEnabled(boolean ), this, bl);
            }

            public Builder setCursorFactory(CursorFactory cursorFactory) {
                return InvokeDynamicSupport.bootstrap("setCursorFactory", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setCursorFactory(android.database.sqlite.SQLiteDatabase$CursorFactory ), this, cursorFactory);
            }

            public Builder setErrorHandler(DatabaseErrorHandler databaseErrorHandler) {
                return InvokeDynamicSupport.bootstrap("setErrorHandler", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setErrorHandler(android.database.DatabaseErrorHandler ), this, databaseErrorHandler);
            }

            public Builder setIdleConnectionTimeout(long l) {
                return InvokeDynamicSupport.bootstrap("setIdleConnectionTimeout", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setIdleConnectionTimeout(long ), this, l);
            }

            public Builder setJournalMode(String string2) {
                return InvokeDynamicSupport.bootstrap("setJournalMode", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setJournalMode(java.lang.String ), this, string2);
            }

            public Builder setSynchronousMode(String string2) {
                return InvokeDynamicSupport.bootstrap("setSynchronousMode", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$setSynchronousMode(java.lang.String ), this, string2);
            }

            public OpenParams build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_database_sqlite_SQLiteDatabase_OpenParams_Builder$build(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static interface CustomFunction {
        public void callback(String[] var1);
    }

    public static interface CursorFactory {
        public Cursor newCursor(SQLiteDatabase var1, SQLiteCursorDriver var2, String var3, SQLiteQuery var4);
    }
}

