/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.app.ActivityThread;
import android.app.Application;
import android.database.sqlite.SQLiteGlobal;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.KeyValueListParser;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SQLiteCompatibilityWalFlags
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "SQLiteCompatibilityWalFlags";
    private static volatile boolean sInitialized;
    private static volatile boolean sFlagsSet;
    private static volatile boolean sCompatibilityWalSupported;
    private static volatile String sWALSyncMode;
    private static volatile boolean sCallingGlobalSettings;

    private void $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$__constructor__() {
    }

    @VisibleForTesting
    private static final boolean $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$areFlagsSet() {
        SQLiteCompatibilityWalFlags.initIfNeeded();
        return sFlagsSet;
    }

    @VisibleForTesting
    private static final boolean $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$isCompatibilityWalSupported() {
        SQLiteCompatibilityWalFlags.initIfNeeded();
        return sCompatibilityWalSupported;
    }

    @VisibleForTesting
    private static final String $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$getWALSyncMode() {
        SQLiteCompatibilityWalFlags.initIfNeeded();
        return sWALSyncMode;
    }

    private static final void $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$initIfNeeded() {
        if (sInitialized || sCallingGlobalSettings) {
            return;
        }
        ActivityThread activityThread = ActivityThread.currentActivityThread();
        Application app = activityThread == null ? null : activityThread.getApplication();
        String flags = null;
        if (app == null) {
            Log.w("SQLiteCompatibilityWalFlags", "Cannot read global setting sqlite_compatibility_wal_flags - Application state not available");
        } else {
            try {
                sCallingGlobalSettings = true;
                flags = Settings.Global.getString(app.getContentResolver(), "sqlite_compatibility_wal_flags");
            }
            finally {
                sCallingGlobalSettings = false;
            }
        }
        SQLiteCompatibilityWalFlags.init(flags);
    }

    @VisibleForTesting
    private static final void $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$init(String flags) {
        if (TextUtils.isEmpty(flags)) {
            sInitialized = true;
            return;
        }
        KeyValueListParser parser = new KeyValueListParser(',');
        try {
            parser.setString(flags);
        }
        catch (IllegalArgumentException e) {
            Log.e("SQLiteCompatibilityWalFlags", "Setting has invalid format: " + flags, e);
            sInitialized = true;
            return;
        }
        sCompatibilityWalSupported = parser.getBoolean("compatibility_wal_supported", SQLiteGlobal.isCompatibilityWalSupported());
        sWALSyncMode = parser.getString("wal_syncmode", SQLiteGlobal.getWALSyncMode());
        Log.i("SQLiteCompatibilityWalFlags", "Read compatibility WAL flags: compatibility_wal_supported=" + sCompatibilityWalSupported + ", wal_syncmode=" + sWALSyncMode);
        sFlagsSet = true;
        sInitialized = true;
    }

    @VisibleForTesting
    private static final void $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$reset() {
        sInitialized = false;
        sFlagsSet = false;
        sCompatibilityWalSupported = false;
        sWALSyncMode = null;
    }

    private void __constructor__() {
        this.$$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$__constructor__();
    }

    public SQLiteCompatibilityWalFlags() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$__constructor__(), this);
    }

    public static boolean areFlagsSet() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("areFlagsSet", $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$areFlagsSet());
    }

    public static boolean isCompatibilityWalSupported() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCompatibilityWalSupported", $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$isCompatibilityWalSupported());
    }

    public static String getWALSyncMode() {
        return InvokeDynamicSupport.bootstrapStatic("getWALSyncMode", $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$getWALSyncMode());
    }

    private static void initIfNeeded() {
        InvokeDynamicSupport.bootstrapStatic("initIfNeeded", $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$initIfNeeded());
    }

    public static void init(String string2) {
        InvokeDynamicSupport.bootstrapStatic("init", $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$init(java.lang.String ), (String)string2);
    }

    public static void reset() {
        InvokeDynamicSupport.bootstrapStatic("reset", $$robo$$android_database_sqlite_SQLiteCompatibilityWalFlags$reset());
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SQLiteCompatibilityWalFlags)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

