/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.ComplexColor;
import android.content.res.ConstantState;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.LinearGradient;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import com.android.internal.util.GrowingArrayUtils;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GradientColor
extends ComplexColor
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "GradientColor";
    private static boolean DBG_GRADIENT = false;
    private static int TILE_MODE_CLAMP = 0;
    private static int TILE_MODE_REPEAT = 1;
    private static int TILE_MODE_MIRROR = 2;
    private GradientColorFactory mFactory;
    private int mChangingConfigurations;
    private int mDefaultColor;
    private Shader mShader;
    private int mGradientType;
    private float mCenterX;
    private float mCenterY;
    private float mStartX;
    private float mStartY;
    private float mEndX;
    private float mEndY;
    private int mStartColor;
    private int mCenterColor;
    private int mEndColor;
    private boolean mHasCenterColor;
    private int mTileMode;
    private float mGradientRadius;
    private int[] mItemColors;
    private float[] mItemOffsets;
    private int[] mThemeAttrs;
    private int[][] mItemsThemeAttrs;

    private void $$robo$$android_content_res_GradientColor$__constructor__() {
        this.mShader = null;
        this.mGradientType = 0;
        this.mCenterX = 0.0f;
        this.mCenterY = 0.0f;
        this.mStartX = 0.0f;
        this.mStartY = 0.0f;
        this.mEndX = 0.0f;
        this.mEndY = 0.0f;
        this.mStartColor = 0;
        this.mCenterColor = 0;
        this.mEndColor = 0;
        this.mHasCenterColor = false;
        this.mTileMode = 0;
        this.mGradientRadius = 0.0f;
    }

    private void $$robo$$android_content_res_GradientColor$__constructor__(GradientColor copy) {
        this.mShader = null;
        this.mGradientType = 0;
        this.mCenterX = 0.0f;
        this.mCenterY = 0.0f;
        this.mStartX = 0.0f;
        this.mStartY = 0.0f;
        this.mEndX = 0.0f;
        this.mEndY = 0.0f;
        this.mStartColor = 0;
        this.mCenterColor = 0;
        this.mEndColor = 0;
        this.mHasCenterColor = false;
        this.mTileMode = 0;
        this.mGradientRadius = 0.0f;
        if (copy != null) {
            this.mChangingConfigurations = copy.mChangingConfigurations;
            this.mDefaultColor = copy.mDefaultColor;
            this.mShader = copy.mShader;
            this.mGradientType = copy.mGradientType;
            this.mCenterX = copy.mCenterX;
            this.mCenterY = copy.mCenterY;
            this.mStartX = copy.mStartX;
            this.mStartY = copy.mStartY;
            this.mEndX = copy.mEndX;
            this.mEndY = copy.mEndY;
            this.mStartColor = copy.mStartColor;
            this.mCenterColor = copy.mCenterColor;
            this.mEndColor = copy.mEndColor;
            this.mHasCenterColor = copy.mHasCenterColor;
            this.mGradientRadius = copy.mGradientRadius;
            this.mTileMode = copy.mTileMode;
            if (copy.mItemColors != null) {
                this.mItemColors = (int[])copy.mItemColors.clone();
            }
            if (copy.mItemOffsets != null) {
                this.mItemOffsets = (float[])copy.mItemOffsets.clone();
            }
            if (copy.mThemeAttrs != null) {
                this.mThemeAttrs = (int[])copy.mThemeAttrs.clone();
            }
            if (copy.mItemsThemeAttrs != null) {
                this.mItemsThemeAttrs = (int[][])copy.mItemsThemeAttrs.clone();
            }
        }
    }

    private static final Shader.TileMode $$robo$$android_content_res_GradientColor$parseTileMode(int tileMode) {
        switch (tileMode) {
            case 0: {
                return Shader.TileMode.CLAMP;
            }
            case 1: {
                return Shader.TileMode.REPEAT;
            }
            case 2: {
                return Shader.TileMode.MIRROR;
            }
        }
        return Shader.TileMode.CLAMP;
    }

    private final void $$robo$$android_content_res_GradientColor$updateRootElementState(TypedArray a) {
        this.mThemeAttrs = a.extractThemeAttrs();
        this.mStartX = a.getFloat(8, this.mStartX);
        this.mStartY = a.getFloat(9, this.mStartY);
        this.mEndX = a.getFloat(10, this.mEndX);
        this.mEndY = a.getFloat(11, this.mEndY);
        this.mCenterX = a.getFloat(3, this.mCenterX);
        this.mCenterY = a.getFloat(4, this.mCenterY);
        this.mGradientType = a.getInt(2, this.mGradientType);
        this.mStartColor = a.getColor(0, this.mStartColor);
        this.mHasCenterColor |= a.hasValue(7);
        this.mCenterColor = a.getColor(7, this.mCenterColor);
        this.mEndColor = a.getColor(1, this.mEndColor);
        this.mTileMode = a.getInt(6, this.mTileMode);
        this.mGradientRadius = a.getFloat(5, this.mGradientRadius);
    }

    private final void $$robo$$android_content_res_GradientColor$validateXmlContent() throws XmlPullParserException {
        if (this.mGradientRadius <= 0.0f && this.mGradientType == 1) {
            throw new XmlPullParserException("<gradient> tag requires 'gradientRadius' attribute with radial type");
        }
    }

    private final Shader $$robo$$android_content_res_GradientColor$getShader() {
        return this.mShader;
    }

    private static final GradientColor $$robo$$android_content_res_GradientColor$createFromXml(Resources r, XmlResourceParser parser, Resources.Theme theme) throws XmlPullParserException, IOException {
        int type;
        AttributeSet attrs = Xml.asAttributeSet(parser);
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        return GradientColor.createFromXmlInner(r, parser, attrs, theme);
    }

    private static final GradientColor $$robo$$android_content_res_GradientColor$createFromXmlInner(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        String name = parser.getName();
        if (!name.equals("gradient")) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": invalid gradient color tag " + name);
        }
        GradientColor gradientColor = new GradientColor();
        gradientColor.inflate(r, parser, attrs, theme);
        return gradientColor;
    }

    private final void $$robo$$android_content_res_GradientColor$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = Resources.obtainAttributes(r, theme, attrs, R.styleable.GradientColor);
        this.updateRootElementState(a);
        this.mChangingConfigurations |= a.getChangingConfigurations();
        a.recycle();
        this.validateXmlContent();
        this.inflateChildElements(r, parser, attrs, theme);
        this.onColorsChange();
    }

    private final void $$robo$$android_content_res_GradientColor$inflateChildElements(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        float[] offsetList = new float[20];
        int[] colorList = new int[offsetList.length];
        Object themeAttrsList = new int[offsetList.length][];
        int listSize = 0;
        boolean hasUnresolvedAttrs = false;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            TypedArray a = Resources.obtainAttributes(r, theme, attrs, R.styleable.GradientColorItem);
            boolean hasColor = a.hasValue(0);
            boolean hasOffset = a.hasValue(1);
            if (!hasColor || !hasOffset) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'color' attribute and a 'offset' attribute!");
            }
            int[] themeAttrs = a.extractThemeAttrs();
            int color2 = a.getColor(0, 0);
            float offset = a.getFloat(1, 0.0f);
            this.mChangingConfigurations |= a.getChangingConfigurations();
            a.recycle();
            if (themeAttrs != null) {
                hasUnresolvedAttrs = true;
            }
            colorList = GrowingArrayUtils.append(colorList, listSize, color2);
            offsetList = GrowingArrayUtils.append(offsetList, listSize, offset);
            themeAttrsList = GrowingArrayUtils.append(themeAttrsList, listSize, themeAttrs);
            ++listSize;
        }
        if (listSize > 0) {
            if (hasUnresolvedAttrs) {
                this.mItemsThemeAttrs = new int[listSize][];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)themeAttrsList, (int)0, (Object)this.mItemsThemeAttrs, (int)0, (int)listSize);
            } else {
                this.mItemsThemeAttrs = null;
            }
            this.mItemColors = new int[listSize];
            this.mItemOffsets = new float[listSize];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)colorList, (int)0, (Object)this.mItemColors, (int)0, (int)listSize);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)offsetList, (int)0, (Object)this.mItemOffsets, (int)0, (int)listSize);
        }
    }

    private final void $$robo$$android_content_res_GradientColor$applyItemsAttrsTheme(Resources.Theme t) {
        if (this.mItemsThemeAttrs == null) {
            return;
        }
        boolean hasUnresolvedAttrs = false;
        int[][] themeAttrsList = this.mItemsThemeAttrs;
        int N = themeAttrsList.length;
        for (int i = 0; i < N; ++i) {
            if (themeAttrsList[i] == null) continue;
            TypedArray a = t.resolveAttributes(themeAttrsList[i], R.styleable.GradientColorItem);
            themeAttrsList[i] = a.extractThemeAttrs(themeAttrsList[i]);
            if (themeAttrsList[i] != null) {
                hasUnresolvedAttrs = true;
            }
            this.mItemColors[i] = a.getColor(0, this.mItemColors[i]);
            this.mItemOffsets[i] = a.getFloat(1, this.mItemOffsets[i]);
            this.mChangingConfigurations |= a.getChangingConfigurations();
            a.recycle();
        }
        if (!hasUnresolvedAttrs) {
            this.mItemsThemeAttrs = null;
        }
    }

    private final void $$robo$$android_content_res_GradientColor$onColorsChange() {
        int[] tempColors = null;
        float[] tempOffsets = null;
        if (this.mItemColors != null) {
            int length = this.mItemColors.length;
            tempColors = new int[length];
            tempOffsets = new float[length];
            for (int i = 0; i < length; ++i) {
                tempColors[i] = this.mItemColors[i];
                tempOffsets[i] = this.mItemOffsets[i];
            }
        } else if (this.mHasCenterColor) {
            tempColors = new int[]{this.mStartColor, this.mCenterColor, this.mEndColor};
            tempOffsets = new float[]{0.0f, 0.5f, 1.0f};
        } else {
            tempColors = new int[]{this.mStartColor, this.mEndColor};
        }
        if (tempColors.length < 2) {
            Log.w("GradientColor", "<gradient> tag requires 2 color values specified!" + tempColors.length + " " + tempColors);
        }
        this.mShader = this.mGradientType == 0 ? new LinearGradient(this.mStartX, this.mStartY, this.mEndX, this.mEndY, tempColors, tempOffsets, GradientColor.parseTileMode(this.mTileMode)) : (this.mGradientType == 1 ? new RadialGradient(this.mCenterX, this.mCenterY, this.mGradientRadius, tempColors, tempOffsets, GradientColor.parseTileMode(this.mTileMode)) : new SweepGradient(this.mCenterX, this.mCenterY, tempColors, tempOffsets));
        this.mDefaultColor = tempColors[0];
    }

    private final int $$robo$$android_content_res_GradientColor$getDefaultColor() {
        return this.mDefaultColor;
    }

    private final ConstantState<ComplexColor> $$robo$$android_content_res_GradientColor$getConstantState() {
        if (this.mFactory == null) {
            this.mFactory = new GradientColorFactory(this);
        }
        return this.mFactory;
    }

    private final GradientColor $$robo$$android_content_res_GradientColor$obtainForTheme(Resources.Theme t) {
        if (t == null || !this.canApplyTheme()) {
            return this;
        }
        GradientColor clone = new GradientColor(this);
        clone.applyTheme(t);
        return clone;
    }

    private final int $$robo$$android_content_res_GradientColor$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mChangingConfigurations;
    }

    private final void $$robo$$android_content_res_GradientColor$applyTheme(Resources.Theme t) {
        if (this.mThemeAttrs != null) {
            this.applyRootAttrsTheme(t);
        }
        if (this.mItemsThemeAttrs != null) {
            this.applyItemsAttrsTheme(t);
        }
        this.onColorsChange();
    }

    private final void $$robo$$android_content_res_GradientColor$applyRootAttrsTheme(Resources.Theme t) {
        TypedArray a = t.resolveAttributes(this.mThemeAttrs, R.styleable.GradientColor);
        this.mThemeAttrs = a.extractThemeAttrs(this.mThemeAttrs);
        this.updateRootElementState(a);
        this.mChangingConfigurations |= a.getChangingConfigurations();
        a.recycle();
    }

    private final boolean $$robo$$android_content_res_GradientColor$canApplyTheme() {
        return this.mThemeAttrs != null || this.mItemsThemeAttrs != null;
    }

    private void __constructor__() {
        this.$$robo$$android_content_res_GradientColor$__constructor__();
    }

    public GradientColor() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_GradientColor$__constructor__(), this);
    }

    private void __constructor__(GradientColor gradientColor) {
        this.$$robo$$android_content_res_GradientColor$__constructor__(gradientColor);
    }

    public GradientColor(GradientColor gradientColor) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_GradientColor$__constructor__(android.content.res.GradientColor ), this, gradientColor);
    }

    private static Shader.TileMode parseTileMode(int n) {
        return InvokeDynamicSupport.bootstrapStatic("parseTileMode", $$robo$$android_content_res_GradientColor$parseTileMode(int ), (int)n);
    }

    private void updateRootElementState(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateRootElementState", $$robo$$android_content_res_GradientColor$updateRootElementState(android.content.res.TypedArray ), this, typedArray);
    }

    private void validateXmlContent() throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("validateXmlContent", $$robo$$android_content_res_GradientColor$validateXmlContent(), this);
    }

    public Shader getShader() {
        return InvokeDynamicSupport.bootstrap("getShader", $$robo$$android_content_res_GradientColor$getShader(), this);
    }

    public static GradientColor createFromXml(Resources resources, XmlResourceParser xmlResourceParser, Resources.Theme theme) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromXml", $$robo$$android_content_res_GradientColor$createFromXml(android.content.res.Resources android.content.res.XmlResourceParser android.content.res.Resources$Theme ), (Resources)resources, (XmlResourceParser)xmlResourceParser, (Resources.Theme)theme);
    }

    static GradientColor createFromXmlInner(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromXmlInner", $$robo$$android_content_res_GradientColor$createFromXmlInner(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), (Resources)resources, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (Resources.Theme)theme);
    }

    private void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_content_res_GradientColor$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    private void inflateChildElements(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflateChildElements", $$robo$$android_content_res_GradientColor$inflateChildElements(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    private void applyItemsAttrsTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyItemsAttrsTheme", $$robo$$android_content_res_GradientColor$applyItemsAttrsTheme(android.content.res.Resources$Theme ), this, theme);
    }

    private void onColorsChange() {
        InvokeDynamicSupport.bootstrap("onColorsChange", $$robo$$android_content_res_GradientColor$onColorsChange(), this);
    }

    @Override
    public int getDefaultColor() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultColor", $$robo$$android_content_res_GradientColor$getDefaultColor(), this);
    }

    @Override
    public ConstantState<ComplexColor> getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_content_res_GradientColor$getConstantState(), this);
    }

    @Override
    public GradientColor obtainForTheme(Resources.Theme theme) {
        return InvokeDynamicSupport.bootstrap("obtainForTheme", $$robo$$android_content_res_GradientColor$obtainForTheme(android.content.res.Resources$Theme ), this, theme);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_content_res_GradientColor$getChangingConfigurations(), this);
    }

    private void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_content_res_GradientColor$applyTheme(android.content.res.Resources$Theme ), this, theme);
    }

    private void applyRootAttrsTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyRootAttrsTheme", $$robo$$android_content_res_GradientColor$applyRootAttrsTheme(android.content.res.Resources$Theme ), this, theme);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_content_res_GradientColor$canApplyTheme(), this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GradientColor)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class GradientColorFactory
    extends ConstantState<ComplexColor> {
        public /* synthetic */ Object __robo_data__;
        private GradientColor mSrc;

        private void $$robo$$android_content_res_GradientColor_GradientColorFactory$__constructor__(GradientColor src) {
            this.mSrc = src;
        }

        private final int $$robo$$android_content_res_GradientColor_GradientColorFactory$getChangingConfigurations() {
            return this.mSrc.mChangingConfigurations;
        }

        private final GradientColor $$robo$$android_content_res_GradientColor_GradientColorFactory$newInstance() {
            return this.mSrc;
        }

        private final GradientColor $$robo$$android_content_res_GradientColor_GradientColorFactory$newInstance(Resources res, Resources.Theme theme) {
            return this.mSrc.obtainForTheme(theme);
        }

        private void __constructor__(GradientColor gradientColor) {
            this.$$robo$$android_content_res_GradientColor_GradientColorFactory$__constructor__(gradientColor);
        }

        public GradientColorFactory(GradientColor gradientColor) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_GradientColor_GradientColorFactory$__constructor__(android.content.res.GradientColor ), this, gradientColor);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_content_res_GradientColor_GradientColorFactory$getChangingConfigurations(), this);
        }

        @Override
        public GradientColor newInstance() {
            return InvokeDynamicSupport.bootstrap("newInstance", $$robo$$android_content_res_GradientColor_GradientColorFactory$newInstance(), this);
        }

        @Override
        public GradientColor newInstance(Resources resources, Resources.Theme theme) {
            return InvokeDynamicSupport.bootstrap("newInstance", $$robo$$android_content_res_GradientColor_GradientColorFactory$newInstance(android.content.res.Resources android.content.res.Resources$Theme ), this, resources, theme);
        }

        public /* synthetic */ GradientColorFactory() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GradientColorFactory)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface GradientTileMode {
    }
}

