/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.WindowManager;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CompatibilityInfo
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static CompatibilityInfo DEFAULT_COMPATIBILITY_INFO;
    public static int DEFAULT_NORMAL_SHORT_DIMENSION = 320;
    public static float MAXIMUM_ASPECT_RATIO = 1.7791667f;
    private int mCompatibilityFlags;
    private static int SCALING_REQUIRED = 1;
    private static int ALWAYS_NEEDS_COMPAT = 2;
    private static int NEVER_NEEDS_COMPAT = 4;
    private static int NEEDS_SCREEN_COMPAT = 8;
    private static int NEEDS_COMPAT_RES = 16;
    public int applicationDensity;
    public float applicationScale;
    public float applicationInvertedScale;
    public static Parcelable.Creator<CompatibilityInfo> CREATOR;

    private void $$robo$$android_content_res_CompatibilityInfo$__constructor__(ApplicationInfo appInfo, int screenLayout, int sw, boolean forceCompat) {
        int compatFlags = 0;
        if (appInfo.targetSdkVersion < 26) {
            compatFlags |= 0x10;
        }
        if (appInfo.requiresSmallestWidthDp != 0 || appInfo.compatibleWidthLimitDp != 0 || appInfo.largestWidthLimitDp != 0) {
            int compat;
            int required;
            int n = required = appInfo.requiresSmallestWidthDp != 0 ? appInfo.requiresSmallestWidthDp : appInfo.compatibleWidthLimitDp;
            if (required == 0) {
                required = appInfo.largestWidthLimitDp;
            }
            int n2 = compat = appInfo.compatibleWidthLimitDp != 0 ? appInfo.compatibleWidthLimitDp : required;
            if (compat < required) {
                compat = required;
            }
            int largest = appInfo.largestWidthLimitDp;
            if (required > 320) {
                compatFlags |= 4;
            } else if (largest != 0 && sw > largest) {
                compatFlags |= 0xA;
            } else if (compat >= sw) {
                compatFlags |= 4;
            } else if (forceCompat) {
                compatFlags |= 8;
            }
            this.applicationDensity = DisplayMetrics.DENSITY_DEVICE;
            this.applicationScale = 1.0f;
            this.applicationInvertedScale = 1.0f;
        } else {
            int EXPANDABLE = 2;
            int LARGE_SCREENS = 8;
            int XLARGE_SCREENS = 32;
            int sizeInfo = 0;
            boolean anyResizeable = false;
            if ((appInfo.flags & 0x800) != 0) {
                sizeInfo |= 8;
                anyResizeable = true;
                if (!forceCompat) {
                    sizeInfo |= 0x22;
                }
            }
            if ((appInfo.flags & 0x80000) != 0) {
                anyResizeable = true;
                if (!forceCompat) {
                    sizeInfo |= 0x22;
                }
            }
            if ((appInfo.flags & 0x1000) != 0) {
                anyResizeable = true;
                sizeInfo |= 2;
            }
            if (forceCompat) {
                sizeInfo &= 0xFFFFFFFD;
            }
            compatFlags |= 8;
            switch (screenLayout & 0xF) {
                case 4: {
                    if ((sizeInfo & 0x20) != 0) {
                        compatFlags &= 0xFFFFFFF7;
                    }
                    if ((appInfo.flags & 0x80000) == 0) break;
                    compatFlags |= 4;
                    break;
                }
                case 3: {
                    if ((sizeInfo & 8) != 0) {
                        compatFlags &= 0xFFFFFFF7;
                    }
                    if ((appInfo.flags & 0x800) == 0) break;
                    compatFlags |= 4;
                }
            }
            if ((screenLayout & 0x10000000) != 0) {
                if ((sizeInfo & 2) != 0) {
                    compatFlags &= 0xFFFFFFF7;
                } else if (!anyResizeable) {
                    compatFlags |= 2;
                }
            } else {
                compatFlags &= 0xFFFFFFF7;
                compatFlags |= 4;
            }
            if ((appInfo.flags & 0x2000) != 0) {
                this.applicationDensity = DisplayMetrics.DENSITY_DEVICE;
                this.applicationScale = 1.0f;
                this.applicationInvertedScale = 1.0f;
            } else {
                this.applicationDensity = 160;
                this.applicationScale = (float)DisplayMetrics.DENSITY_DEVICE / 160.0f;
                this.applicationInvertedScale = 1.0f / this.applicationScale;
                compatFlags |= 1;
            }
        }
        this.mCompatibilityFlags = compatFlags;
    }

    private void $$robo$$android_content_res_CompatibilityInfo$__constructor__(int compFlags, int dens, float scale, float invertedScale) {
        this.mCompatibilityFlags = compFlags;
        this.applicationDensity = dens;
        this.applicationScale = scale;
        this.applicationInvertedScale = invertedScale;
    }

    private void $$robo$$android_content_res_CompatibilityInfo$__constructor__() {
    }

    private final boolean $$robo$$android_content_res_CompatibilityInfo$isScalingRequired() {
        return (this.mCompatibilityFlags & 1) != 0;
    }

    private final boolean $$robo$$android_content_res_CompatibilityInfo$supportsScreen() {
        return (this.mCompatibilityFlags & 8) == 0;
    }

    private final boolean $$robo$$android_content_res_CompatibilityInfo$neverSupportsScreen() {
        return (this.mCompatibilityFlags & 2) != 0;
    }

    private final boolean $$robo$$android_content_res_CompatibilityInfo$alwaysSupportsScreen() {
        return (this.mCompatibilityFlags & 4) != 0;
    }

    private final boolean $$robo$$android_content_res_CompatibilityInfo$needsCompatResources() {
        return (this.mCompatibilityFlags & 0x10) != 0;
    }

    private final Translator $$robo$$android_content_res_CompatibilityInfo$getTranslator() {
        return this.isScalingRequired() ? new Translator(this) : null;
    }

    private final void $$robo$$android_content_res_CompatibilityInfo$applyToDisplayMetrics(DisplayMetrics inoutDm) {
        if (!this.supportsScreen()) {
            CompatibilityInfo.computeCompatibleScaling(inoutDm, inoutDm);
        } else {
            inoutDm.widthPixels = inoutDm.noncompatWidthPixels;
            inoutDm.heightPixels = inoutDm.noncompatHeightPixels;
        }
        if (this.isScalingRequired()) {
            float invertedRatio = this.applicationInvertedScale;
            inoutDm.density = inoutDm.noncompatDensity * invertedRatio;
            inoutDm.densityDpi = (int)((float)inoutDm.noncompatDensityDpi * invertedRatio + 0.5f);
            inoutDm.scaledDensity = inoutDm.noncompatScaledDensity * invertedRatio;
            inoutDm.xdpi = inoutDm.noncompatXdpi * invertedRatio;
            inoutDm.ydpi = inoutDm.noncompatYdpi * invertedRatio;
            inoutDm.widthPixels = (int)((float)inoutDm.widthPixels * invertedRatio + 0.5f);
            inoutDm.heightPixels = (int)((float)inoutDm.heightPixels * invertedRatio + 0.5f);
        }
    }

    private final void $$robo$$android_content_res_CompatibilityInfo$applyToConfiguration(int displayDensity, Configuration inoutConfig) {
        if (!this.supportsScreen()) {
            inoutConfig.screenLayout = inoutConfig.screenLayout & 0xFFFFFFF0 | 2;
            inoutConfig.screenWidthDp = inoutConfig.compatScreenWidthDp;
            inoutConfig.screenHeightDp = inoutConfig.compatScreenHeightDp;
            inoutConfig.smallestScreenWidthDp = inoutConfig.compatSmallestScreenWidthDp;
        }
        inoutConfig.densityDpi = displayDensity;
        if (this.isScalingRequired()) {
            float invertedRatio = this.applicationInvertedScale;
            inoutConfig.densityDpi = (int)((float)inoutConfig.densityDpi * invertedRatio + 0.5f);
        }
    }

    private static final float $$robo$$android_content_res_CompatibilityInfo$computeCompatibleScaling(DisplayMetrics dm, DisplayMetrics outDm) {
        float scale;
        int newHeight;
        int newWidth;
        int longSize;
        int shortSize;
        int width = dm.noncompatWidthPixels;
        int height = dm.noncompatHeightPixels;
        if (width < height) {
            shortSize = width;
            longSize = height;
        } else {
            shortSize = height;
            longSize = width;
        }
        int newShortSize = (int)(320.0f * dm.density + 0.5f);
        float aspect = (float)longSize / (float)shortSize;
        if (aspect > 1.7791667f) {
            aspect = 1.7791667f;
        }
        int newLongSize = (int)((float)newShortSize * aspect + 0.5f);
        if (width < height) {
            newWidth = newShortSize;
            newHeight = newLongSize;
        } else {
            newWidth = newLongSize;
            newHeight = newShortSize;
        }
        float sw = (float)width / (float)newWidth;
        float sh = (float)height / (float)newHeight;
        float f = scale = sw < sh ? sw : sh;
        if (scale < 1.0f) {
            scale = 1.0f;
        }
        if (outDm != null) {
            outDm.widthPixels = newWidth;
            outDm.heightPixels = newHeight;
        }
        return scale;
    }

    private final boolean $$robo$$android_content_res_CompatibilityInfo$equals(Object o) {
        if (this == o) {
            return true;
        }
        try {
            CompatibilityInfo oc = (CompatibilityInfo)o;
            if (this.mCompatibilityFlags != oc.mCompatibilityFlags) {
                return false;
            }
            if (this.applicationDensity != oc.applicationDensity) {
                return false;
            }
            if (this.applicationScale != oc.applicationScale) {
                return false;
            }
            return this.applicationInvertedScale == oc.applicationInvertedScale;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private final String $$robo$$android_content_res_CompatibilityInfo$toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("{");
        sb.append(this.applicationDensity);
        sb.append("dpi");
        if (this.isScalingRequired()) {
            sb.append(" ");
            sb.append(this.applicationScale);
            sb.append("x");
        }
        if (!this.supportsScreen()) {
            sb.append(" resizing");
        }
        if (this.neverSupportsScreen()) {
            sb.append(" never-compat");
        }
        if (this.alwaysSupportsScreen()) {
            sb.append(" always-compat");
        }
        sb.append("}");
        return sb.toString();
    }

    private final int $$robo$$android_content_res_CompatibilityInfo$hashCode() {
        int result = 17;
        result = 31 * result + this.mCompatibilityFlags;
        result = 31 * result + this.applicationDensity;
        result = 31 * result + Float.floatToIntBits(this.applicationScale);
        result = 31 * result + Float.floatToIntBits(this.applicationInvertedScale);
        return result;
    }

    private final int $$robo$$android_content_res_CompatibilityInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_res_CompatibilityInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mCompatibilityFlags);
        dest.writeInt(this.applicationDensity);
        dest.writeFloat(this.applicationScale);
        dest.writeFloat(this.applicationInvertedScale);
    }

    private void $$robo$$android_content_res_CompatibilityInfo$__constructor__(Parcel source) {
        this.mCompatibilityFlags = source.readInt();
        this.applicationDensity = source.readInt();
        this.applicationScale = source.readFloat();
        this.applicationInvertedScale = source.readFloat();
    }

    private /* synthetic */ void $$robo$$android_content_res_CompatibilityInfo$__constructor__(1 x0) {
    }

    private /* synthetic */ void $$robo$$android_content_res_CompatibilityInfo$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        DEFAULT_COMPATIBILITY_INFO = new ShadowedObject(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_res_CompatibilityInfo_1$__constructor__() {
            }

            @Override
            private void __constructor__() {
                this.$$robo$$android_content_res_CompatibilityInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_CompatibilityInfo_1$__constructor__(), this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        CREATOR = new Parcelable.Creator<CompatibilityInfo>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_res_CompatibilityInfo_2$__constructor__() {
            }

            private final CompatibilityInfo $$robo$$android_content_res_CompatibilityInfo_2$createFromParcel(Parcel source) {
                return new CompatibilityInfo(source, null);
            }

            private final CompatibilityInfo[] $$robo$$android_content_res_CompatibilityInfo_2$newArray(int size) {
                return new CompatibilityInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_res_CompatibilityInfo_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_CompatibilityInfo_2$__constructor__(), this);
            }

            @Override
            public CompatibilityInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_res_CompatibilityInfo_2$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public CompatibilityInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_res_CompatibilityInfo_2$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(ApplicationInfo applicationInfo, int n, int n2, boolean bl) {
        this.$$robo$$android_content_res_CompatibilityInfo$__constructor__(applicationInfo, n, n2, bl);
    }

    public CompatibilityInfo(ApplicationInfo applicationInfo, int n, int n2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_CompatibilityInfo$__constructor__(android.content.pm.ApplicationInfo int int boolean ), this, applicationInfo, n, n2, bl);
    }

    private void __constructor__(int n, int n2, float f, float f2) {
        this.$$robo$$android_content_res_CompatibilityInfo$__constructor__(n, n2, f, f2);
    }

    public CompatibilityInfo(int n, int n2, float f, float f2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_CompatibilityInfo$__constructor__(int int float float ), this, n, n2, f, f2);
    }

    private void __constructor__() {
        this.$$robo$$android_content_res_CompatibilityInfo$__constructor__();
    }

    public CompatibilityInfo() {
        this(4, DisplayMetrics.DENSITY_DEVICE, 1.0f, 1.0f);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_CompatibilityInfo$__constructor__(), this);
    }

    public boolean isScalingRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isScalingRequired", $$robo$$android_content_res_CompatibilityInfo$isScalingRequired(), this);
    }

    public boolean supportsScreen() {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsScreen", $$robo$$android_content_res_CompatibilityInfo$supportsScreen(), this);
    }

    public boolean neverSupportsScreen() {
        return (boolean)InvokeDynamicSupport.bootstrap("neverSupportsScreen", $$robo$$android_content_res_CompatibilityInfo$neverSupportsScreen(), this);
    }

    public boolean alwaysSupportsScreen() {
        return (boolean)InvokeDynamicSupport.bootstrap("alwaysSupportsScreen", $$robo$$android_content_res_CompatibilityInfo$alwaysSupportsScreen(), this);
    }

    public boolean needsCompatResources() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsCompatResources", $$robo$$android_content_res_CompatibilityInfo$needsCompatResources(), this);
    }

    public Translator getTranslator() {
        return InvokeDynamicSupport.bootstrap("getTranslator", $$robo$$android_content_res_CompatibilityInfo$getTranslator(), this);
    }

    public void applyToDisplayMetrics(DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("applyToDisplayMetrics", $$robo$$android_content_res_CompatibilityInfo$applyToDisplayMetrics(android.util.DisplayMetrics ), this, displayMetrics);
    }

    public void applyToConfiguration(int n, Configuration configuration) {
        InvokeDynamicSupport.bootstrap("applyToConfiguration", $$robo$$android_content_res_CompatibilityInfo$applyToConfiguration(int android.content.res.Configuration ), this, n, configuration);
    }

    public static float computeCompatibleScaling(DisplayMetrics displayMetrics, DisplayMetrics displayMetrics2) {
        return (float)InvokeDynamicSupport.bootstrapStatic("computeCompatibleScaling", $$robo$$android_content_res_CompatibilityInfo$computeCompatibleScaling(android.util.DisplayMetrics android.util.DisplayMetrics ), (DisplayMetrics)displayMetrics, (DisplayMetrics)displayMetrics2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_content_res_CompatibilityInfo$equals(java.lang.Object ), this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_res_CompatibilityInfo$toString(), this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_content_res_CompatibilityInfo$hashCode(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_res_CompatibilityInfo$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_res_CompatibilityInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_res_CompatibilityInfo$__constructor__(parcel);
    }

    public CompatibilityInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_CompatibilityInfo$__constructor__(android.os.Parcel ), this, parcel);
    }

    private /* synthetic */ void __constructor__(1 var1_1) {
        this.$$robo$$android_content_res_CompatibilityInfo$__constructor__(var1_1);
    }

    public /* synthetic */ CompatibilityInfo(1 var1_1) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_CompatibilityInfo$__constructor__(android.content.res.CompatibilityInfo$1 ), this, var1_1);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_content_res_CompatibilityInfo$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ CompatibilityInfo(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_CompatibilityInfo$__constructor__(android.os.Parcel android.content.res.CompatibilityInfo$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(CompatibilityInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompatibilityInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class Translator
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public float applicationScale;
        public float applicationInvertedScale;
        private Rect mContentInsetsBuffer;
        private Rect mVisibleInsetsBuffer;
        private Region mTouchableAreaBuffer;
        /* synthetic */ CompatibilityInfo this$0;

        private void $$robo$$android_content_res_CompatibilityInfo_Translator$__constructor__(CompatibilityInfo this$0, float applicationScale, float applicationInvertedScale) {
            this.this$0 = this$0;
            this.mContentInsetsBuffer = null;
            this.mVisibleInsetsBuffer = null;
            this.mTouchableAreaBuffer = null;
            this.applicationScale = applicationScale;
            this.applicationInvertedScale = applicationInvertedScale;
        }

        private void $$robo$$android_content_res_CompatibilityInfo_Translator$__constructor__(CompatibilityInfo this$0) {
        }

        private final void $$robo$$android_content_res_CompatibilityInfo_Translator$translateRectInScreenToAppWinFrame(Rect rect) {
            rect.scale(this.applicationInvertedScale);
        }

        private final void $$robo$$android_content_res_CompatibilityInfo_Translator$translateRegionInWindowToScreen(Region transparentRegion) {
            transparentRegion.scale(this.applicationScale);
        }

        private final void $$robo$$android_content_res_CompatibilityInfo_Translator$translateCanvas(Canvas canvas) {
            if (this.applicationScale == 1.5f) {
                float tinyOffset = 0.0026143792f;
                canvas.translate(0.0026143792f, 0.0026143792f);
            }
            canvas.scale(this.applicationScale, this.applicationScale);
        }

        private final void $$robo$$android_content_res_CompatibilityInfo_Translator$translateEventInScreenToAppWindow(MotionEvent event) {
            event.scale(this.applicationInvertedScale);
        }

        private final void $$robo$$android_content_res_CompatibilityInfo_Translator$translateWindowLayout(WindowManager.LayoutParams params) {
            params.scale(this.applicationScale);
        }

        private final void $$robo$$android_content_res_CompatibilityInfo_Translator$translateRectInAppWindowToScreen(Rect rect) {
            rect.scale(this.applicationScale);
        }

        private final void $$robo$$android_content_res_CompatibilityInfo_Translator$translateRectInScreenToAppWindow(Rect rect) {
            rect.scale(this.applicationInvertedScale);
        }

        private final void $$robo$$android_content_res_CompatibilityInfo_Translator$translatePointInScreenToAppWindow(PointF point) {
            float scale = this.applicationInvertedScale;
            if (scale != 1.0f) {
                point.x *= scale;
                point.y *= scale;
            }
        }

        private final void $$robo$$android_content_res_CompatibilityInfo_Translator$translateLayoutParamsInAppWindowToScreen(WindowManager.LayoutParams params) {
            params.scale(this.applicationScale);
        }

        private final Rect $$robo$$android_content_res_CompatibilityInfo_Translator$getTranslatedContentInsets(Rect contentInsets) {
            if (this.mContentInsetsBuffer == null) {
                this.mContentInsetsBuffer = new Rect();
            }
            this.mContentInsetsBuffer.set(contentInsets);
            this.translateRectInAppWindowToScreen(this.mContentInsetsBuffer);
            return this.mContentInsetsBuffer;
        }

        private final Rect $$robo$$android_content_res_CompatibilityInfo_Translator$getTranslatedVisibleInsets(Rect visibleInsets) {
            if (this.mVisibleInsetsBuffer == null) {
                this.mVisibleInsetsBuffer = new Rect();
            }
            this.mVisibleInsetsBuffer.set(visibleInsets);
            this.translateRectInAppWindowToScreen(this.mVisibleInsetsBuffer);
            return this.mVisibleInsetsBuffer;
        }

        private final Region $$robo$$android_content_res_CompatibilityInfo_Translator$getTranslatedTouchableArea(Region touchableArea) {
            if (this.mTouchableAreaBuffer == null) {
                this.mTouchableAreaBuffer = new Region();
            }
            this.mTouchableAreaBuffer.set(touchableArea);
            this.mTouchableAreaBuffer.scale(this.applicationScale);
            return this.mTouchableAreaBuffer;
        }

        private void __constructor__(CompatibilityInfo compatibilityInfo, float f, float f2) {
            this.$$robo$$android_content_res_CompatibilityInfo_Translator$__constructor__(compatibilityInfo, f, f2);
        }

        public Translator(CompatibilityInfo compatibilityInfo, float f, float f2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_CompatibilityInfo_Translator$__constructor__(android.content.res.CompatibilityInfo float float ), this, compatibilityInfo, f, f2);
        }

        private void __constructor__(CompatibilityInfo compatibilityInfo) {
            this.$$robo$$android_content_res_CompatibilityInfo_Translator$__constructor__(compatibilityInfo);
        }

        public Translator(CompatibilityInfo compatibilityInfo) {
            this(compatibilityInfo, compatibilityInfo.applicationScale, compatibilityInfo.applicationInvertedScale);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_CompatibilityInfo_Translator$__constructor__(android.content.res.CompatibilityInfo ), this, compatibilityInfo);
        }

        public void translateRectInScreenToAppWinFrame(Rect rect) {
            InvokeDynamicSupport.bootstrap("translateRectInScreenToAppWinFrame", $$robo$$android_content_res_CompatibilityInfo_Translator$translateRectInScreenToAppWinFrame(android.graphics.Rect ), this, rect);
        }

        public void translateRegionInWindowToScreen(Region region) {
            InvokeDynamicSupport.bootstrap("translateRegionInWindowToScreen", $$robo$$android_content_res_CompatibilityInfo_Translator$translateRegionInWindowToScreen(android.graphics.Region ), this, region);
        }

        public void translateCanvas(Canvas canvas) {
            InvokeDynamicSupport.bootstrap("translateCanvas", $$robo$$android_content_res_CompatibilityInfo_Translator$translateCanvas(android.graphics.Canvas ), this, canvas);
        }

        public void translateEventInScreenToAppWindow(MotionEvent motionEvent) {
            InvokeDynamicSupport.bootstrap("translateEventInScreenToAppWindow", $$robo$$android_content_res_CompatibilityInfo_Translator$translateEventInScreenToAppWindow(android.view.MotionEvent ), this, motionEvent);
        }

        public void translateWindowLayout(WindowManager.LayoutParams layoutParams) {
            InvokeDynamicSupport.bootstrap("translateWindowLayout", $$robo$$android_content_res_CompatibilityInfo_Translator$translateWindowLayout(android.view.WindowManager$LayoutParams ), this, layoutParams);
        }

        public void translateRectInAppWindowToScreen(Rect rect) {
            InvokeDynamicSupport.bootstrap("translateRectInAppWindowToScreen", $$robo$$android_content_res_CompatibilityInfo_Translator$translateRectInAppWindowToScreen(android.graphics.Rect ), this, rect);
        }

        public void translateRectInScreenToAppWindow(Rect rect) {
            InvokeDynamicSupport.bootstrap("translateRectInScreenToAppWindow", $$robo$$android_content_res_CompatibilityInfo_Translator$translateRectInScreenToAppWindow(android.graphics.Rect ), this, rect);
        }

        public void translatePointInScreenToAppWindow(PointF pointF) {
            InvokeDynamicSupport.bootstrap("translatePointInScreenToAppWindow", $$robo$$android_content_res_CompatibilityInfo_Translator$translatePointInScreenToAppWindow(android.graphics.PointF ), this, pointF);
        }

        public void translateLayoutParamsInAppWindowToScreen(WindowManager.LayoutParams layoutParams) {
            InvokeDynamicSupport.bootstrap("translateLayoutParamsInAppWindowToScreen", $$robo$$android_content_res_CompatibilityInfo_Translator$translateLayoutParamsInAppWindowToScreen(android.view.WindowManager$LayoutParams ), this, layoutParams);
        }

        public Rect getTranslatedContentInsets(Rect rect) {
            return InvokeDynamicSupport.bootstrap("getTranslatedContentInsets", $$robo$$android_content_res_CompatibilityInfo_Translator$getTranslatedContentInsets(android.graphics.Rect ), this, rect);
        }

        public Rect getTranslatedVisibleInsets(Rect rect) {
            return InvokeDynamicSupport.bootstrap("getTranslatedVisibleInsets", $$robo$$android_content_res_CompatibilityInfo_Translator$getTranslatedVisibleInsets(android.graphics.Rect ), this, rect);
        }

        public Region getTranslatedTouchableArea(Region region) {
            return InvokeDynamicSupport.bootstrap("getTranslatedTouchableArea", $$robo$$android_content_res_CompatibilityInfo_Translator$getTranslatedTouchableArea(android.graphics.Region ), this, region);
        }

        public /* synthetic */ Translator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Translator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

