/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.split;

import android.content.pm.PackageParser;
import android.content.pm.split.SplitAssetLoader;
import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import android.os.Build;
import com.android.internal.util.ArrayUtils;
import java.io.IOException;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DefaultSplitAssetLoader
implements SplitAssetLoader,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private String mBaseCodePath;
    private String[] mSplitCodePaths;
    private int mFlags;
    private AssetManager mCachedAssetManager;

    private void $$robo$$android_content_pm_split_DefaultSplitAssetLoader$__constructor__(PackageParser.PackageLite pkg, int flags) {
        this.mBaseCodePath = pkg.baseCodePath;
        this.mSplitCodePaths = pkg.splitCodePaths;
        this.mFlags = flags;
    }

    private static final ApkAssets $$robo$$android_content_pm_split_DefaultSplitAssetLoader$loadApkAssets(String path, int flags) throws PackageParser.PackageParserException {
        if ((flags & 1) != 0 && !PackageParser.isApkPath(path)) {
            throw new PackageParser.PackageParserException(-100, "Invalid package file: " + path);
        }
        try {
            return ApkAssets.loadFromPath(path);
        }
        catch (IOException e) {
            throw new PackageParser.PackageParserException(-2, "Failed to load APK at path " + path, e);
        }
    }

    private final AssetManager $$robo$$android_content_pm_split_DefaultSplitAssetLoader$getBaseAssetManager() throws PackageParser.PackageParserException {
        if (this.mCachedAssetManager != null) {
            return this.mCachedAssetManager;
        }
        ApkAssets[] apkAssets = new ApkAssets[(this.mSplitCodePaths != null ? this.mSplitCodePaths.length : 0) + 1];
        int splitIdx = 0;
        apkAssets[splitIdx++] = DefaultSplitAssetLoader.loadApkAssets(this.mBaseCodePath, this.mFlags);
        if (!ArrayUtils.isEmpty(this.mSplitCodePaths)) {
            for (String apkPath : this.mSplitCodePaths) {
                apkAssets[splitIdx++] = DefaultSplitAssetLoader.loadApkAssets(apkPath, this.mFlags);
            }
        }
        AssetManager assets = new AssetManager();
        assets.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
        assets.setApkAssets(apkAssets, false);
        this.mCachedAssetManager = assets;
        return this.mCachedAssetManager;
    }

    private final AssetManager $$robo$$android_content_pm_split_DefaultSplitAssetLoader$getSplitAssetManager(int splitIdx) throws PackageParser.PackageParserException {
        return this.getBaseAssetManager();
    }

    private final void $$robo$$android_content_pm_split_DefaultSplitAssetLoader$close() throws Exception {
        IoUtils.closeQuietly(this.mCachedAssetManager);
    }

    private void __constructor__(PackageParser.PackageLite packageLite, int n) {
        this.$$robo$$android_content_pm_split_DefaultSplitAssetLoader$__constructor__(packageLite, n);
    }

    public DefaultSplitAssetLoader(PackageParser.PackageLite packageLite, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_split_DefaultSplitAssetLoader$__constructor__(android.content.pm.PackageParser$PackageLite int ), this, packageLite, n);
    }

    private static ApkAssets loadApkAssets(String string2, int n) throws PackageParser.PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("loadApkAssets", $$robo$$android_content_pm_split_DefaultSplitAssetLoader$loadApkAssets(java.lang.String int ), (String)string2, (int)n);
    }

    @Override
    public AssetManager getBaseAssetManager() throws PackageParser.PackageParserException {
        return InvokeDynamicSupport.bootstrap("getBaseAssetManager", $$robo$$android_content_pm_split_DefaultSplitAssetLoader$getBaseAssetManager(), this);
    }

    @Override
    public AssetManager getSplitAssetManager(int n) throws PackageParser.PackageParserException {
        return InvokeDynamicSupport.bootstrap("getSplitAssetManager", $$robo$$android_content_pm_split_DefaultSplitAssetLoader$getSplitAssetManager(int ), this, n);
    }

    @Override
    public void close() throws Exception {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_content_pm_split_DefaultSplitAssetLoader$close(), this);
    }

    public /* synthetic */ DefaultSplitAssetLoader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultSplitAssetLoader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

