/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.SystemApi;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.text.Html;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Printer;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.Collator;
import java.util.BitSet;
import java.util.Comparator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PackageItemInfo
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int LINE_FEED_CODE_POINT = 10;
    private static int NBSP_CODE_POINT = 160;
    public static int SAFE_LABEL_FLAG_TRIM = 1;
    public static int SAFE_LABEL_FLAG_SINGLE_LINE = 2;
    public static int SAFE_LABEL_FLAG_FIRST_LINE = 4;
    private static float MAX_LABEL_SIZE_PX = 500.0f;
    private static int MAX_SAFE_LABEL_LENGTH = 50000;
    private static volatile boolean sForceSafeLabels;
    public String name;
    public String packageName;
    public int labelRes;
    public CharSequence nonLocalizedLabel;
    public int icon;
    public int banner;
    public int logo;
    public Bundle metaData;
    public int showUserIcon;
    public static int DUMP_FLAG_DETAILS = 1;
    public static int DUMP_FLAG_APPLICATION = 2;
    public static int DUMP_FLAG_ALL = 3;

    private static final void $$robo$$android_content_pm_PackageItemInfo$setForceSafeLabels(boolean forceSafeLabels) {
        sForceSafeLabels = forceSafeLabels;
    }

    private void $$robo$$android_content_pm_PackageItemInfo$__constructor__() {
        this.showUserIcon = -10000;
    }

    private void $$robo$$android_content_pm_PackageItemInfo$__constructor__(PackageItemInfo orig) {
        this.name = orig.name;
        if (this.name != null) {
            this.name = this.name.trim();
        }
        this.packageName = orig.packageName;
        this.labelRes = orig.labelRes;
        this.nonLocalizedLabel = orig.nonLocalizedLabel;
        if (this.nonLocalizedLabel != null) {
            this.nonLocalizedLabel = this.nonLocalizedLabel.toString().trim();
        }
        this.icon = orig.icon;
        this.banner = orig.banner;
        this.logo = orig.logo;
        this.metaData = orig.metaData;
        this.showUserIcon = orig.showUserIcon;
    }

    private final CharSequence $$robo$$android_content_pm_PackageItemInfo$loadLabel(PackageManager pm) {
        if (sForceSafeLabels) {
            return this.loadSafeLabel(pm);
        }
        return this.loadUnsafeLabel(pm);
    }

    private final CharSequence $$robo$$android_content_pm_PackageItemInfo$loadUnsafeLabel(PackageManager pm) {
        CharSequence label;
        if (this.nonLocalizedLabel != null) {
            return this.nonLocalizedLabel;
        }
        if (this.labelRes != 0 && (label = pm.getText(this.packageName, this.labelRes, this.getApplicationInfo())) != null) {
            return label.toString().trim();
        }
        if (this.name != null) {
            return this.name;
        }
        return this.packageName;
    }

    @SystemApi
    private final CharSequence $$robo$$android_content_pm_PackageItemInfo$loadSafeLabel(PackageManager pm) {
        int charCount;
        String label = this.loadUnsafeLabel(pm).toString();
        String labelStr = Html.fromHtml(label).toString();
        int labelLength = Math.min(labelStr.length(), 50000);
        StringBuffer sb = new StringBuffer(labelLength);
        for (int offset = 0; offset < labelLength; offset += charCount) {
            int codePoint = labelStr.codePointAt(offset);
            int type = Character.getType(codePoint);
            if (type == 13 || type == 15 || type == 14) {
                labelStr = labelStr.substring(0, offset);
                break;
            }
            charCount = Character.charCount(codePoint);
            if (type == 12) {
                sb.append(' ');
                continue;
            }
            sb.append(labelStr.charAt(offset));
            if (charCount != 2) continue;
            sb.append(labelStr.charAt(offset + 1));
        }
        if ((labelStr = sb.toString().trim()).isEmpty()) {
            return this.packageName;
        }
        TextPaint paint = new TextPaint();
        paint.setTextSize(42.0f);
        return TextUtils.ellipsize(labelStr, paint, 500.0f, TextUtils.TruncateAt.END);
    }

    private static final boolean $$robo$$android_content_pm_PackageItemInfo$isNewline(int codePoint) {
        int type = Character.getType(codePoint);
        return type == 14 || type == 13 || codePoint == 10;
    }

    private static final boolean $$robo$$android_content_pm_PackageItemInfo$isWhiteSpace(int codePoint) {
        return Character.isWhitespace(codePoint) || codePoint == 160;
    }

    private final CharSequence $$robo$$android_content_pm_PackageItemInfo$loadSafeLabel(PackageManager pm, float ellipsizeDip, int flags) {
        int codePointLen;
        boolean onlyKeepFirstLine = (flags & 4) != 0;
        boolean forceSingleLine = (flags & 2) != 0;
        boolean trim = (flags & 1) != 0;
        Preconditions.checkNotNull(pm);
        Preconditions.checkArgument(ellipsizeDip >= 0.0f);
        Preconditions.checkFlagsArgument(flags, 7);
        Preconditions.checkArgument(!onlyKeepFirstLine || !forceSingleLine, "Cannot set SAFE_LABEL_FLAG_SINGLE_LINE and SAFE_LABEL_FLAG_FIRST_LINE at the same time");
        String label = this.loadUnsafeLabel(pm).toString();
        StringWithRemovedChars labelStr = new StringWithRemovedChars(Html.fromHtml(label).toString());
        int firstNonWhiteSpace = -1;
        int firstTrailingWhiteSpace = -1;
        int labelLength = labelStr.length();
        for (int offset = 0; offset < labelLength; offset += codePointLen) {
            int codePoint = labelStr.codePointAt(offset);
            int type = Character.getType(codePoint);
            codePointLen = Character.charCount(codePoint);
            boolean isNewline = PackageItemInfo.isNewline(codePoint);
            if (offset > 50000 || onlyKeepFirstLine && isNewline) {
                labelStr.removeAllCharAfter(offset);
                break;
            }
            if (forceSingleLine && isNewline) {
                labelStr.removeRange(offset, offset + codePointLen);
                continue;
            }
            if (type == 15 && !isNewline) {
                labelStr.removeRange(offset, offset + codePointLen);
                continue;
            }
            if (!trim || PackageItemInfo.isWhiteSpace(codePoint)) continue;
            if (firstNonWhiteSpace == -1) {
                firstNonWhiteSpace = offset;
            }
            firstTrailingWhiteSpace = offset + codePointLen;
        }
        if (trim) {
            if (firstNonWhiteSpace == -1) {
                labelStr.removeAllCharAfter(0);
            } else {
                if (firstNonWhiteSpace > 0) {
                    labelStr.removeAllCharBefore(firstNonWhiteSpace);
                }
                if (firstTrailingWhiteSpace < labelLength) {
                    labelStr.removeAllCharAfter(firstTrailingWhiteSpace);
                }
            }
        }
        if (ellipsizeDip == 0.0f) {
            return labelStr.toString();
        }
        TextPaint paint = new TextPaint();
        paint.setTextSize(42.0f);
        return TextUtils.ellipsize(labelStr.toString(), paint, ellipsizeDip, TextUtils.TruncateAt.END);
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadIcon(PackageManager pm) {
        return pm.loadItemIcon(this, this.getApplicationInfo());
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadUnbadgedIcon(PackageManager pm) {
        return pm.loadUnbadgedItemIcon(this, this.getApplicationInfo());
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadBanner(PackageManager pm) {
        Drawable dr;
        if (this.banner != 0 && (dr = pm.getDrawable(this.packageName, this.banner, this.getApplicationInfo())) != null) {
            return dr;
        }
        return this.loadDefaultBanner(pm);
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadDefaultIcon(PackageManager pm) {
        return pm.getDefaultActivityIcon();
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadDefaultBanner(PackageManager pm) {
        return null;
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadLogo(PackageManager pm) {
        Drawable d;
        if (this.logo != 0 && (d = pm.getDrawable(this.packageName, this.logo, this.getApplicationInfo())) != null) {
            return d;
        }
        return this.loadDefaultLogo(pm);
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadDefaultLogo(PackageManager pm) {
        return null;
    }

    private final XmlResourceParser $$robo$$android_content_pm_PackageItemInfo$loadXmlMetaData(PackageManager pm, String name) {
        int resid;
        if (this.metaData != null && (resid = this.metaData.getInt(name)) != 0) {
            return pm.getXml(this.packageName, resid, this.getApplicationInfo());
        }
        return null;
    }

    private final void $$robo$$android_content_pm_PackageItemInfo$dumpFront(Printer pw, String prefix) {
        if (this.name != null) {
            pw.println(prefix + "name=" + this.name);
        }
        pw.println(prefix + "packageName=" + this.packageName);
        if (this.labelRes != 0 || this.nonLocalizedLabel != null || this.icon != 0 || this.banner != 0) {
            pw.println(prefix + "labelRes=0x" + Integer.toHexString(this.labelRes) + " nonLocalizedLabel=" + this.nonLocalizedLabel + " icon=0x" + Integer.toHexString(this.icon) + " banner=0x" + Integer.toHexString(this.banner));
        }
    }

    private final void $$robo$$android_content_pm_PackageItemInfo$dumpBack(Printer pw, String prefix) {
    }

    private final void $$robo$$android_content_pm_PackageItemInfo$writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeString(this.name);
        dest.writeString(this.packageName);
        dest.writeInt(this.labelRes);
        TextUtils.writeToParcel(this.nonLocalizedLabel, dest, parcelableFlags);
        dest.writeInt(this.icon);
        dest.writeInt(this.logo);
        dest.writeBundle(this.metaData);
        dest.writeInt(this.banner);
        dest.writeInt(this.showUserIcon);
    }

    private final void $$robo$$android_content_pm_PackageItemInfo$writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        if (this.name != null) {
            proto.write(0x10900000001L, this.name);
        }
        proto.write(1138166333442L, this.packageName);
        if (this.labelRes != 0 || this.nonLocalizedLabel != null || this.icon != 0 || this.banner != 0) {
            proto.write(1120986464259L, this.labelRes);
            proto.write(1138166333444L, this.nonLocalizedLabel.toString());
            proto.write(0x10500000005L, this.icon);
            proto.write(1120986464262L, this.banner);
        }
        proto.end(token);
    }

    private void $$robo$$android_content_pm_PackageItemInfo$__constructor__(Parcel source) {
        this.name = source.readString();
        this.packageName = source.readString();
        this.labelRes = source.readInt();
        this.nonLocalizedLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
        this.icon = source.readInt();
        this.logo = source.readInt();
        this.metaData = source.readBundle();
        this.banner = source.readInt();
        this.showUserIcon = source.readInt();
    }

    private final ApplicationInfo $$robo$$android_content_pm_PackageItemInfo$getApplicationInfo() {
        return null;
    }

    static void __staticInitializer__() {
        sForceSafeLabels = false;
    }

    public static void setForceSafeLabels(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setForceSafeLabels", $$robo$$android_content_pm_PackageItemInfo$setForceSafeLabels(boolean ), (boolean)bl);
    }

    private void __constructor__() {
        this.$$robo$$android_content_pm_PackageItemInfo$__constructor__();
    }

    public PackageItemInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageItemInfo$__constructor__(), this);
    }

    private void __constructor__(PackageItemInfo packageItemInfo) {
        this.$$robo$$android_content_pm_PackageItemInfo$__constructor__(packageItemInfo);
    }

    public PackageItemInfo(PackageItemInfo packageItemInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageItemInfo$__constructor__(android.content.pm.PackageItemInfo ), this, packageItemInfo);
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadLabel", $$robo$$android_content_pm_PackageItemInfo$loadLabel(android.content.pm.PackageManager ), this, packageManager);
    }

    public CharSequence loadUnsafeLabel(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadUnsafeLabel", $$robo$$android_content_pm_PackageItemInfo$loadUnsafeLabel(android.content.pm.PackageManager ), this, packageManager);
    }

    @SystemApi
    public CharSequence loadSafeLabel(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadSafeLabel", $$robo$$android_content_pm_PackageItemInfo$loadSafeLabel(android.content.pm.PackageManager ), this, packageManager);
    }

    private static boolean isNewline(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNewline", $$robo$$android_content_pm_PackageItemInfo$isNewline(int ), (int)n);
    }

    private static boolean isWhiteSpace(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isWhiteSpace", $$robo$$android_content_pm_PackageItemInfo$isWhiteSpace(int ), (int)n);
    }

    public CharSequence loadSafeLabel(PackageManager packageManager, float f, int n) {
        return InvokeDynamicSupport.bootstrap("loadSafeLabel", $$robo$$android_content_pm_PackageItemInfo$loadSafeLabel(android.content.pm.PackageManager float int ), this, packageManager, f, n);
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadIcon", $$robo$$android_content_pm_PackageItemInfo$loadIcon(android.content.pm.PackageManager ), this, packageManager);
    }

    public Drawable loadUnbadgedIcon(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadUnbadgedIcon", $$robo$$android_content_pm_PackageItemInfo$loadUnbadgedIcon(android.content.pm.PackageManager ), this, packageManager);
    }

    public Drawable loadBanner(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadBanner", $$robo$$android_content_pm_PackageItemInfo$loadBanner(android.content.pm.PackageManager ), this, packageManager);
    }

    public Drawable loadDefaultIcon(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadDefaultIcon", $$robo$$android_content_pm_PackageItemInfo$loadDefaultIcon(android.content.pm.PackageManager ), this, packageManager);
    }

    protected Drawable loadDefaultBanner(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadDefaultBanner", $$robo$$android_content_pm_PackageItemInfo$loadDefaultBanner(android.content.pm.PackageManager ), this, packageManager);
    }

    public Drawable loadLogo(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadLogo", $$robo$$android_content_pm_PackageItemInfo$loadLogo(android.content.pm.PackageManager ), this, packageManager);
    }

    protected Drawable loadDefaultLogo(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadDefaultLogo", $$robo$$android_content_pm_PackageItemInfo$loadDefaultLogo(android.content.pm.PackageManager ), this, packageManager);
    }

    public XmlResourceParser loadXmlMetaData(PackageManager packageManager, String string2) {
        return InvokeDynamicSupport.bootstrap("loadXmlMetaData", $$robo$$android_content_pm_PackageItemInfo$loadXmlMetaData(android.content.pm.PackageManager java.lang.String ), this, packageManager, string2);
    }

    protected void dumpFront(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dumpFront", $$robo$$android_content_pm_PackageItemInfo$dumpFront(android.util.Printer java.lang.String ), this, printer, string2);
    }

    protected void dumpBack(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dumpBack", $$robo$$android_content_pm_PackageItemInfo$dumpBack(android.util.Printer java.lang.String ), this, printer, string2);
    }

    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PackageItemInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long l) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_content_pm_PackageItemInfo$writeToProto(android.util.proto.ProtoOutputStream long ), this, protoOutputStream, l);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_pm_PackageItemInfo$__constructor__(parcel);
    }

    public PackageItemInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageItemInfo$__constructor__(android.os.Parcel ), this, parcel);
    }

    protected ApplicationInfo getApplicationInfo() {
        return InvokeDynamicSupport.bootstrap("getApplicationInfo", $$robo$$android_content_pm_PackageItemInfo$getApplicationInfo(), this);
    }

    static {
        RobolectricInternals.classInitializing(PackageItemInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageItemInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class DisplayNameComparator
    implements Comparator<PackageItemInfo> {
        public /* synthetic */ Object __robo_data__;
        private Collator sCollator;
        private PackageManager mPM;

        private void $$robo$$android_content_pm_PackageItemInfo_DisplayNameComparator$__constructor__(PackageManager pm) {
            this.sCollator = Collator.getInstance();
            this.mPM = pm;
        }

        private final int $$robo$$android_content_pm_PackageItemInfo_DisplayNameComparator$compare(PackageItemInfo aa, PackageItemInfo ab) {
            CharSequence sb;
            CharSequence sa = aa.loadLabel(this.mPM);
            if (sa == null) {
                sa = aa.name;
            }
            if ((sb = ab.loadLabel(this.mPM)) == null) {
                sb = ab.name;
            }
            return this.sCollator.compare(sa.toString(), sb.toString());
        }

        private void __constructor__(PackageManager packageManager) {
            this.$$robo$$android_content_pm_PackageItemInfo_DisplayNameComparator$__constructor__(packageManager);
        }

        public DisplayNameComparator(PackageManager packageManager) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageItemInfo_DisplayNameComparator$__constructor__(android.content.pm.PackageManager ), this, packageManager);
        }

        @Override
        public int compare(PackageItemInfo packageItemInfo, PackageItemInfo packageItemInfo2) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_content_pm_PackageItemInfo_DisplayNameComparator$compare(android.content.pm.PackageItemInfo android.content.pm.PackageItemInfo ), this, packageItemInfo, packageItemInfo2);
        }

        public /* synthetic */ DisplayNameComparator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisplayNameComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StringWithRemovedChars
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String mOriginal;
        private BitSet mRemovedChars;

        private void $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$__constructor__(String original) {
            this.mOriginal = original;
        }

        private final void $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$removeRange(int firstRemoved, int firstNonRemoved) {
            if (this.mRemovedChars == null) {
                this.mRemovedChars = new BitSet(this.mOriginal.length());
            }
            this.mRemovedChars.set(firstRemoved, firstNonRemoved);
        }

        private final void $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$removeAllCharBefore(int firstNonRemoved) {
            if (this.mRemovedChars == null) {
                this.mRemovedChars = new BitSet(this.mOriginal.length());
            }
            this.mRemovedChars.set(0, firstNonRemoved);
        }

        private final void $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$removeAllCharAfter(int firstRemoved) {
            if (this.mRemovedChars == null) {
                this.mRemovedChars = new BitSet(this.mOriginal.length());
            }
            this.mRemovedChars.set(firstRemoved, this.mOriginal.length());
        }

        private final String $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$toString() {
            if (this.mRemovedChars == null) {
                return this.mOriginal;
            }
            StringBuilder sb = new StringBuilder(this.mOriginal.length());
            for (int i = 0; i < this.mOriginal.length(); ++i) {
                if (this.mRemovedChars.get(i)) continue;
                sb.append(this.mOriginal.charAt(i));
            }
            return sb.toString();
        }

        private final int $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$length() {
            return this.mOriginal.length();
        }

        private final boolean $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$isRemoved(int offset) {
            return this.mRemovedChars != null && this.mRemovedChars.get(offset);
        }

        private final int $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$codePointAt(int offset) {
            return this.mOriginal.codePointAt(offset);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$__constructor__(string2);
        }

        public StringWithRemovedChars(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$__constructor__(java.lang.String ), this, string2);
        }

        void removeRange(int n, int n2) {
            InvokeDynamicSupport.bootstrap("removeRange", $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$removeRange(int int ), this, n, n2);
        }

        void removeAllCharBefore(int n) {
            InvokeDynamicSupport.bootstrap("removeAllCharBefore", $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$removeAllCharBefore(int ), this, n);
        }

        void removeAllCharAfter(int n) {
            InvokeDynamicSupport.bootstrap("removeAllCharAfter", $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$removeAllCharAfter(int ), this, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$toString(), this);
        }

        int length() {
            return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$length(), this);
        }

        boolean isRemoved(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isRemoved", $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$isRemoved(int ), this, n);
        }

        int codePointAt(int n) {
            return (int)InvokeDynamicSupport.bootstrap("codePointAt", $$robo$$android_content_pm_PackageItemInfo_StringWithRemovedChars$codePointAt(int ), this, n);
        }

        public /* synthetic */ StringWithRemovedChars() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StringWithRemovedChars)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SafeLabelFlags {
    }
}

