/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.app.AppGlobals;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AppsQueryHelper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int GET_NON_LAUNCHABLE_APPS;
    public static int GET_APPS_WITH_INTERACT_ACROSS_USERS_PERM;
    public static int GET_IMES;
    public static int GET_REQUIRED_FOR_SYSTEM_USER;
    private IPackageManager mPackageManager;
    private List<ApplicationInfo> mAllApps;

    private void $$robo$$android_content_pm_AppsQueryHelper$__constructor__(IPackageManager packageManager) {
        this.mPackageManager = packageManager;
    }

    private void $$robo$$android_content_pm_AppsQueryHelper$__constructor__() {
    }

    private final List<String> $$robo$$android_content_pm_AppsQueryHelper$queryApps(int flags, boolean systemAppsOnly, UserHandle user) {
        boolean requiredForSystemUser;
        boolean nonLaunchableApps = (flags & GET_NON_LAUNCHABLE_APPS) > 0;
        boolean interactAcrossUsers = (flags & GET_APPS_WITH_INTERACT_ACROSS_USERS_PERM) > 0;
        boolean imes = (flags & GET_IMES) > 0;
        boolean bl = requiredForSystemUser = (flags & GET_REQUIRED_FOR_SYSTEM_USER) > 0;
        if (this.mAllApps == null) {
            this.mAllApps = this.getAllApps(user.getIdentifier());
        }
        ArrayList<String> result = new ArrayList<String>();
        if (flags == 0) {
            int allAppsSize = this.mAllApps.size();
            for (int i = 0; i < allAppsSize; ++i) {
                ApplicationInfo appInfo = this.mAllApps.get(i);
                if (systemAppsOnly && !appInfo.isSystemApp()) continue;
                result.add(appInfo.packageName);
            }
            return result;
        }
        if (nonLaunchableApps) {
            Intent intent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.LAUNCHER");
            List<ResolveInfo> resolveInfos = this.queryIntentActivitiesAsUser(intent, user.getIdentifier());
            ArraySet<String> appsWithLaunchers = new ArraySet<String>();
            int resolveInfosSize = resolveInfos.size();
            for (int i = 0; i < resolveInfosSize; ++i) {
                appsWithLaunchers.add(resolveInfos.get((int)i).activityInfo.packageName);
            }
            int allAppsSize = this.mAllApps.size();
            for (int i = 0; i < allAppsSize; ++i) {
                String packageName;
                ApplicationInfo appInfo = this.mAllApps.get(i);
                if (systemAppsOnly && !appInfo.isSystemApp() || appsWithLaunchers.contains(packageName = appInfo.packageName)) continue;
                result.add(packageName);
            }
        }
        if (interactAcrossUsers) {
            List<PackageInfo> packagesHoldingPermissions = this.getPackagesHoldingPermission("android.permission.INTERACT_ACROSS_USERS", user.getIdentifier());
            int packagesHoldingPermissionsSize = packagesHoldingPermissions.size();
            for (int i = 0; i < packagesHoldingPermissionsSize; ++i) {
                PackageInfo packageInfo = packagesHoldingPermissions.get(i);
                if (systemAppsOnly && !packageInfo.applicationInfo.isSystemApp() || result.contains(packageInfo.packageName)) continue;
                result.add(packageInfo.packageName);
            }
        }
        if (imes) {
            List<ResolveInfo> resolveInfos = this.queryIntentServicesAsUser(new Intent("android.view.InputMethod"), user.getIdentifier());
            int resolveInfosSize = resolveInfos.size();
            for (int i = 0; i < resolveInfosSize; ++i) {
                ServiceInfo serviceInfo = resolveInfos.get((int)i).serviceInfo;
                if (systemAppsOnly && !serviceInfo.applicationInfo.isSystemApp() || result.contains(serviceInfo.packageName)) continue;
                result.add(serviceInfo.packageName);
            }
        }
        if (requiredForSystemUser) {
            int allAppsSize = this.mAllApps.size();
            for (int i = 0; i < allAppsSize; ++i) {
                ApplicationInfo appInfo = this.mAllApps.get(i);
                if (systemAppsOnly && !appInfo.isSystemApp() || !appInfo.isRequiredForSystemUser()) continue;
                result.add(appInfo.packageName);
            }
        }
        return result;
    }

    @VisibleForTesting
    private final List<ApplicationInfo> $$robo$$android_content_pm_AppsQueryHelper$getAllApps(int userId) {
        try {
            return this.mPackageManager.getInstalledApplications(8704, userId).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @VisibleForTesting
    private final List<ResolveInfo> $$robo$$android_content_pm_AppsQueryHelper$queryIntentActivitiesAsUser(Intent intent, int userId) {
        try {
            return this.mPackageManager.queryIntentActivities(intent, null, 795136, userId).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @VisibleForTesting
    private final List<ResolveInfo> $$robo$$android_content_pm_AppsQueryHelper$queryIntentServicesAsUser(Intent intent, int userId) {
        try {
            return this.mPackageManager.queryIntentServices(intent, null, 819328, userId).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @VisibleForTesting
    private final List<PackageInfo> $$robo$$android_content_pm_AppsQueryHelper$getPackagesHoldingPermission(String perm, int userId) {
        try {
            return this.mPackageManager.getPackagesHoldingPermissions(new String[]{perm}, 0, userId).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void __staticInitializer__() {
        GET_NON_LAUNCHABLE_APPS = 1;
        GET_APPS_WITH_INTERACT_ACROSS_USERS_PERM = 2;
        GET_IMES = 4;
        GET_REQUIRED_FOR_SYSTEM_USER = 8;
    }

    private void __constructor__(IPackageManager iPackageManager) {
        this.$$robo$$android_content_pm_AppsQueryHelper$__constructor__(iPackageManager);
    }

    public AppsQueryHelper(IPackageManager iPackageManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_AppsQueryHelper$__constructor__(android.content.pm.IPackageManager ), this, iPackageManager);
    }

    private void __constructor__() {
        this.$$robo$$android_content_pm_AppsQueryHelper$__constructor__();
    }

    public AppsQueryHelper() {
        this(AppGlobals.getPackageManager());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_AppsQueryHelper$__constructor__(), this);
    }

    public List<String> queryApps(int n, boolean bl, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("queryApps", $$robo$$android_content_pm_AppsQueryHelper$queryApps(int boolean android.os.UserHandle ), this, n, bl, userHandle);
    }

    protected List<ApplicationInfo> getAllApps(int n) {
        return InvokeDynamicSupport.bootstrap("getAllApps", $$robo$$android_content_pm_AppsQueryHelper$getAllApps(int ), this, n);
    }

    protected List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, int n) {
        return InvokeDynamicSupport.bootstrap("queryIntentActivitiesAsUser", $$robo$$android_content_pm_AppsQueryHelper$queryIntentActivitiesAsUser(android.content.Intent int ), this, intent, n);
    }

    protected List<ResolveInfo> queryIntentServicesAsUser(Intent intent, int n) {
        return InvokeDynamicSupport.bootstrap("queryIntentServicesAsUser", $$robo$$android_content_pm_AppsQueryHelper$queryIntentServicesAsUser(android.content.Intent int ), this, intent, n);
    }

    protected List<PackageInfo> getPackagesHoldingPermission(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getPackagesHoldingPermission", $$robo$$android_content_pm_AppsQueryHelper$getPackagesHoldingPermission(java.lang.String int ), this, string2, n);
    }

    static {
        RobolectricInternals.classInitializing(AppsQueryHelper.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppsQueryHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

