/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.SystemApi;
import android.content.Context;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.text.TextUtils;
import android.util.Printer;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.ArrayUtils;
import com.android.server.SystemConfig;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ApplicationInfo
extends PackageItemInfo
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public String taskAffinity;
    public String permission;
    public String processName;
    public String className;
    public int descriptionRes;
    public int theme;
    public String manageSpaceActivityName;
    public String backupAgentName;
    public int fullBackupContent;
    public int uiOptions;
    public static int FLAG_SYSTEM = 1;
    public static int FLAG_DEBUGGABLE = 2;
    public static int FLAG_HAS_CODE = 4;
    public static int FLAG_PERSISTENT = 8;
    public static int FLAG_FACTORY_TEST = 16;
    public static int FLAG_ALLOW_TASK_REPARENTING = 32;
    public static int FLAG_ALLOW_CLEAR_USER_DATA = 64;
    public static int FLAG_UPDATED_SYSTEM_APP = 128;
    public static int FLAG_TEST_ONLY = 256;
    public static int FLAG_SUPPORTS_SMALL_SCREENS = 512;
    public static int FLAG_SUPPORTS_NORMAL_SCREENS = 1024;
    public static int FLAG_SUPPORTS_LARGE_SCREENS = 2048;
    public static int FLAG_RESIZEABLE_FOR_SCREENS = 4096;
    public static int FLAG_SUPPORTS_SCREEN_DENSITIES = 8192;
    public static int FLAG_VM_SAFE_MODE = 16384;
    public static int FLAG_ALLOW_BACKUP = 32768;
    public static int FLAG_KILL_AFTER_RESTORE = 65536;
    public static int FLAG_RESTORE_ANY_VERSION = 131072;
    public static int FLAG_EXTERNAL_STORAGE = 262144;
    public static int FLAG_SUPPORTS_XLARGE_SCREENS = 524288;
    public static int FLAG_LARGE_HEAP = 0x100000;
    public static int FLAG_STOPPED = 0x200000;
    public static int FLAG_SUPPORTS_RTL = 0x400000;
    public static int FLAG_INSTALLED = 0x800000;
    public static int FLAG_IS_DATA_ONLY = 0x1000000;
    @Deprecated
    public static int FLAG_IS_GAME = 0x2000000;
    public static int FLAG_FULL_BACKUP_ONLY = 0x4000000;
    public static int FLAG_USES_CLEARTEXT_TRAFFIC = 0x8000000;
    public static int FLAG_EXTRACT_NATIVE_LIBS = 0x10000000;
    public static int FLAG_HARDWARE_ACCELERATED = 0x20000000;
    public static int FLAG_SUSPENDED = 0x40000000;
    public static int FLAG_MULTIARCH = Integer.MIN_VALUE;
    public int flags;
    public static int PRIVATE_FLAG_HIDDEN = 1;
    public static int PRIVATE_FLAG_CANT_SAVE_STATE = 2;
    public static int PRIVATE_FLAG_FORWARD_LOCK = 4;
    public static int PRIVATE_FLAG_PRIVILEGED = 8;
    public static int PRIVATE_FLAG_HAS_DOMAIN_URLS = 16;
    public static int PRIVATE_FLAG_DEFAULT_TO_DEVICE_PROTECTED_STORAGE = 32;
    public static int PRIVATE_FLAG_DIRECT_BOOT_AWARE = 64;
    public static int PRIVATE_FLAG_INSTANT = 128;
    public static int PRIVATE_FLAG_PARTIALLY_DIRECT_BOOT_AWARE = 256;
    public static int PRIVATE_FLAG_REQUIRED_FOR_SYSTEM_USER = 512;
    public static int PRIVATE_FLAG_ACTIVITIES_RESIZE_MODE_RESIZEABLE = 1024;
    public static int PRIVATE_FLAG_ACTIVITIES_RESIZE_MODE_UNRESIZEABLE = 2048;
    public static int PRIVATE_FLAG_ACTIVITIES_RESIZE_MODE_RESIZEABLE_VIA_SDK_VERSION = 4096;
    public static int PRIVATE_FLAG_BACKUP_IN_FOREGROUND = 8192;
    public static int PRIVATE_FLAG_STATIC_SHARED_LIBRARY = 16384;
    public static int PRIVATE_FLAG_ISOLATED_SPLIT_LOADING = 32768;
    public static int PRIVATE_FLAG_VIRTUAL_PRELOAD = 65536;
    public static int PRIVATE_FLAG_OEM = 131072;
    public static int PRIVATE_FLAG_VENDOR = 262144;
    public static int PRIVATE_FLAG_PRODUCT = 524288;
    public static int PRIVATE_FLAG_SIGNED_WITH_PLATFORM_KEY = 0x100000;
    public int privateFlags;
    public static String METADATA_PRELOADED_FONTS = "preloaded_fonts";
    public int requiresSmallestWidthDp;
    public int compatibleWidthLimitDp;
    public int largestWidthLimitDp;
    public float maxAspectRatio;
    @Deprecated
    public String volumeUuid;
    public UUID storageUuid;
    public String scanSourceDir;
    public String scanPublicSourceDir;
    public String sourceDir;
    public String publicSourceDir;
    public String[] splitNames;
    public String[] splitSourceDirs;
    public String[] splitPublicSourceDirs;
    public SparseArray<int[]> splitDependencies;
    public String[] resourceDirs;
    public String seInfo;
    public String seInfoUser;
    public String[] sharedLibraryFiles;
    public String dataDir;
    public String deviceProtectedDataDir;
    @SystemApi
    public String credentialProtectedDataDir;
    public String nativeLibraryDir;
    public String secondaryNativeLibraryDir;
    public String nativeLibraryRootDir;
    public boolean nativeLibraryRootRequiresIsa;
    public String primaryCpuAbi;
    public String secondaryCpuAbi;
    public int uid;
    public int minSdkVersion;
    public int targetSdkVersion;
    public long longVersionCode;
    @Deprecated
    public int versionCode;
    public int compileSdkVersion;
    public String compileSdkVersionCodename;
    public boolean enabled;
    public int enabledSetting;
    public int installLocation;
    public int networkSecurityConfigRes;
    @SystemApi
    public int targetSandboxVersion;
    public String appComponentFactory;
    public int category;
    public static int CATEGORY_UNDEFINED = -1;
    public static int CATEGORY_GAME = 0;
    public static int CATEGORY_AUDIO = 1;
    public static int CATEGORY_VIDEO = 2;
    public static int CATEGORY_IMAGE = 3;
    public static int CATEGORY_SOCIAL = 4;
    public static int CATEGORY_NEWS = 5;
    public static int CATEGORY_MAPS = 6;
    public static int CATEGORY_PRODUCTIVITY = 7;
    public String classLoaderName;
    public String[] splitClassLoaderNames;
    public boolean hiddenUntilInstalled;
    public static int HIDDEN_API_ENFORCEMENT_DEFAULT = -1;
    public static int HIDDEN_API_ENFORCEMENT_NONE = 0;
    public static int HIDDEN_API_ENFORCEMENT_JUST_WARN = 1;
    public static int HIDDEN_API_ENFORCEMENT_DARK_GREY_AND_BLACK = 2;
    public static int HIDDEN_API_ENFORCEMENT_BLACK = 3;
    private static int HIDDEN_API_ENFORCEMENT_MAX = 3;
    private int mHiddenApiPolicy;
    public static Parcelable.Creator<ApplicationInfo> CREATOR;

    private static final CharSequence $$robo$$android_content_pm_ApplicationInfo$getCategoryTitle(Context context, int category) {
        switch (category) {
            case 0: {
                return context.getText(17039486);
            }
            case 1: {
                return context.getText(17039485);
            }
            case 2: {
                return context.getText(17039492);
            }
            case 3: {
                return context.getText(17039487);
            }
            case 4: {
                return context.getText(17039491);
            }
            case 5: {
                return context.getText(17039489);
            }
            case 6: {
                return context.getText(17039488);
            }
            case 7: {
                return context.getText(17039490);
            }
        }
        return null;
    }

    private static final boolean $$robo$$android_content_pm_ApplicationInfo$isValidHiddenApiEnforcementPolicy(int policy) {
        return policy >= -1 && policy <= 3;
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$dump(Printer pw, String prefix) {
        this.dump(pw, prefix, 3);
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$dump(Printer pw, String prefix, int dumpFlags) {
        super.dumpFront(pw, prefix);
        if ((dumpFlags & 1) != 0 && this.className != null) {
            pw.println(prefix + "className=" + this.className);
        }
        if (this.permission != null) {
            pw.println(prefix + "permission=" + this.permission);
        }
        pw.println(prefix + "processName=" + this.processName);
        if ((dumpFlags & 1) != 0) {
            pw.println(prefix + "taskAffinity=" + this.taskAffinity);
        }
        pw.println(prefix + "uid=" + this.uid + " flags=0x" + Integer.toHexString(this.flags) + " privateFlags=0x" + Integer.toHexString(this.privateFlags) + " theme=0x" + Integer.toHexString(this.theme));
        if ((dumpFlags & 1) != 0) {
            pw.println(prefix + "requiresSmallestWidthDp=" + this.requiresSmallestWidthDp + " compatibleWidthLimitDp=" + this.compatibleWidthLimitDp + " largestWidthLimitDp=" + this.largestWidthLimitDp);
        }
        pw.println(prefix + "sourceDir=" + this.sourceDir);
        if (!Objects.equals(this.sourceDir, this.publicSourceDir)) {
            pw.println(prefix + "publicSourceDir=" + this.publicSourceDir);
        }
        if (!ArrayUtils.isEmpty(this.splitSourceDirs)) {
            pw.println(prefix + "splitSourceDirs=" + Arrays.toString(this.splitSourceDirs));
        }
        if (!ArrayUtils.isEmpty(this.splitPublicSourceDirs) && !Arrays.equals(this.splitSourceDirs, this.splitPublicSourceDirs)) {
            pw.println(prefix + "splitPublicSourceDirs=" + Arrays.toString(this.splitPublicSourceDirs));
        }
        if (this.resourceDirs != null) {
            pw.println(prefix + "resourceDirs=" + Arrays.toString(this.resourceDirs));
        }
        if ((dumpFlags & 1) != 0 && this.seInfo != null) {
            pw.println(prefix + "seinfo=" + this.seInfo);
            pw.println(prefix + "seinfoUser=" + this.seInfoUser);
        }
        pw.println(prefix + "dataDir=" + this.dataDir);
        if ((dumpFlags & 1) != 0) {
            pw.println(prefix + "deviceProtectedDataDir=" + this.deviceProtectedDataDir);
            pw.println(prefix + "credentialProtectedDataDir=" + this.credentialProtectedDataDir);
            if (this.sharedLibraryFiles != null) {
                pw.println(prefix + "sharedLibraryFiles=" + Arrays.toString(this.sharedLibraryFiles));
            }
        }
        if (this.classLoaderName != null) {
            pw.println(prefix + "classLoaderName=" + this.classLoaderName);
        }
        if (!ArrayUtils.isEmpty(this.splitClassLoaderNames)) {
            pw.println(prefix + "splitClassLoaderNames=" + Arrays.toString(this.splitClassLoaderNames));
        }
        pw.println(prefix + "enabled=" + this.enabled + " minSdkVersion=" + this.minSdkVersion + " targetSdkVersion=" + this.targetSdkVersion + " versionCode=" + this.longVersionCode + " targetSandboxVersion=" + this.targetSandboxVersion);
        if ((dumpFlags & 1) != 0) {
            if (this.manageSpaceActivityName != null) {
                pw.println(prefix + "manageSpaceActivityName=" + this.manageSpaceActivityName);
            }
            if (this.descriptionRes != 0) {
                pw.println(prefix + "description=0x" + Integer.toHexString(this.descriptionRes));
            }
            if (this.uiOptions != 0) {
                pw.println(prefix + "uiOptions=0x" + Integer.toHexString(this.uiOptions));
            }
            pw.println(prefix + "supportsRtl=" + (this.hasRtlSupport() ? "true" : "false"));
            if (this.fullBackupContent > 0) {
                pw.println(prefix + "fullBackupContent=@xml/" + this.fullBackupContent);
            } else {
                pw.println(prefix + "fullBackupContent=" + (this.fullBackupContent < 0 ? "false" : "true"));
            }
            if (this.networkSecurityConfigRes != 0) {
                pw.println(prefix + "networkSecurityConfigRes=0x" + Integer.toHexString(this.networkSecurityConfigRes));
            }
            if (this.category != -1) {
                pw.println(prefix + "category=" + this.category);
            }
            pw.println(prefix + "HiddenApiEnforcementPolicy=" + this.getHiddenApiEnforcementPolicy());
        }
        super.dumpBack(pw, prefix);
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$writeToProto(ProtoOutputStream proto, long fieldId, int dumpFlags) {
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L);
        proto.write(1138166333442L, this.permission);
        proto.write(1138166333443L, this.processName);
        proto.write(1120986464260L, this.uid);
        proto.write(0x10500000005L, this.flags);
        proto.write(1120986464262L, this.privateFlags);
        proto.write(1120986464263L, this.theme);
        proto.write(1138166333448L, this.sourceDir);
        if (!Objects.equals(this.sourceDir, this.publicSourceDir)) {
            proto.write(0x10900000009L, this.publicSourceDir);
        }
        if (!ArrayUtils.isEmpty(this.splitSourceDirs)) {
            for (String dir : this.splitSourceDirs) {
                proto.write(2237677961226L, dir);
            }
        }
        if (!ArrayUtils.isEmpty(this.splitPublicSourceDirs) && !Arrays.equals(this.splitSourceDirs, this.splitPublicSourceDirs)) {
            for (String dir : this.splitPublicSourceDirs) {
                proto.write(2237677961227L, dir);
            }
        }
        if (this.resourceDirs != null) {
            for (String dir : this.resourceDirs) {
                proto.write(2237677961228L, dir);
            }
        }
        proto.write(1138166333453L, this.dataDir);
        proto.write(1138166333454L, this.classLoaderName);
        if (!ArrayUtils.isEmpty(this.splitClassLoaderNames)) {
            for (String name : this.splitClassLoaderNames) {
                proto.write(2237677961231L, name);
            }
        }
        long versionToken = proto.start(0x10B00000010L);
        proto.write(0x10800000001L, this.enabled);
        proto.write(1120986464258L, this.minSdkVersion);
        proto.write(1120986464259L, this.targetSdkVersion);
        proto.write(1120986464260L, this.longVersionCode);
        proto.write(0x10500000005L, this.targetSandboxVersion);
        proto.end(versionToken);
        if ((dumpFlags & 1) != 0) {
            long detailToken = proto.start(0x10B00000011L);
            if (this.className != null) {
                proto.write(0x10900000001L, this.className);
            }
            proto.write(1138166333442L, this.taskAffinity);
            proto.write(1120986464259L, this.requiresSmallestWidthDp);
            proto.write(1120986464260L, this.compatibleWidthLimitDp);
            proto.write(0x10500000005L, this.largestWidthLimitDp);
            if (this.seInfo != null) {
                proto.write(1138166333446L, this.seInfo);
                proto.write(1138166333447L, this.seInfoUser);
            }
            proto.write(1138166333448L, this.deviceProtectedDataDir);
            proto.write(0x10900000009L, this.credentialProtectedDataDir);
            if (this.sharedLibraryFiles != null) {
                for (String f : this.sharedLibraryFiles) {
                    proto.write(2237677961226L, f);
                }
            }
            if (this.manageSpaceActivityName != null) {
                proto.write(1138166333451L, this.manageSpaceActivityName);
            }
            if (this.descriptionRes != 0) {
                proto.write(1120986464268L, this.descriptionRes);
            }
            if (this.uiOptions != 0) {
                proto.write(1120986464269L, this.uiOptions);
            }
            proto.write(1133871366158L, this.hasRtlSupport());
            if (this.fullBackupContent > 0) {
                proto.write(1138166333455L, "@xml/" + this.fullBackupContent);
            } else {
                proto.write(0x10800000010L, this.fullBackupContent == 0);
            }
            if (this.networkSecurityConfigRes != 0) {
                proto.write(0x10500000011L, this.networkSecurityConfigRes);
            }
            if (this.category != -1) {
                proto.write(1120986464274L, this.category);
            }
            proto.end(detailToken);
        }
        proto.end(token);
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$hasRtlSupport() {
        return (this.flags & 0x400000) == 0x400000;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$hasCode() {
        return (this.flags & 4) != 0;
    }

    private void $$robo$$android_content_pm_ApplicationInfo$__constructor__() {
        this.fullBackupContent = 0;
        this.uiOptions = 0;
        this.flags = 0;
        this.requiresSmallestWidthDp = 0;
        this.compatibleWidthLimitDp = 0;
        this.largestWidthLimitDp = 0;
        this.enabled = true;
        this.enabledSetting = 0;
        this.installLocation = -1;
        this.category = -1;
        this.mHiddenApiPolicy = -1;
    }

    private void $$robo$$android_content_pm_ApplicationInfo$__constructor__(ApplicationInfo orig) {
        this.fullBackupContent = 0;
        this.uiOptions = 0;
        this.flags = 0;
        this.requiresSmallestWidthDp = 0;
        this.compatibleWidthLimitDp = 0;
        this.largestWidthLimitDp = 0;
        this.enabled = true;
        this.enabledSetting = 0;
        this.installLocation = -1;
        this.category = -1;
        this.mHiddenApiPolicy = -1;
        this.taskAffinity = orig.taskAffinity;
        this.permission = orig.permission;
        this.processName = orig.processName;
        this.className = orig.className;
        this.theme = orig.theme;
        this.flags = orig.flags;
        this.privateFlags = orig.privateFlags;
        this.requiresSmallestWidthDp = orig.requiresSmallestWidthDp;
        this.compatibleWidthLimitDp = orig.compatibleWidthLimitDp;
        this.largestWidthLimitDp = orig.largestWidthLimitDp;
        this.volumeUuid = orig.volumeUuid;
        this.storageUuid = orig.storageUuid;
        this.scanSourceDir = orig.scanSourceDir;
        this.scanPublicSourceDir = orig.scanPublicSourceDir;
        this.sourceDir = orig.sourceDir;
        this.publicSourceDir = orig.publicSourceDir;
        this.splitNames = orig.splitNames;
        this.splitSourceDirs = orig.splitSourceDirs;
        this.splitPublicSourceDirs = orig.splitPublicSourceDirs;
        this.splitDependencies = orig.splitDependencies;
        this.nativeLibraryDir = orig.nativeLibraryDir;
        this.secondaryNativeLibraryDir = orig.secondaryNativeLibraryDir;
        this.nativeLibraryRootDir = orig.nativeLibraryRootDir;
        this.nativeLibraryRootRequiresIsa = orig.nativeLibraryRootRequiresIsa;
        this.primaryCpuAbi = orig.primaryCpuAbi;
        this.secondaryCpuAbi = orig.secondaryCpuAbi;
        this.resourceDirs = orig.resourceDirs;
        this.seInfo = orig.seInfo;
        this.seInfoUser = orig.seInfoUser;
        this.sharedLibraryFiles = orig.sharedLibraryFiles;
        this.dataDir = orig.dataDir;
        this.deviceProtectedDataDir = orig.deviceProtectedDataDir;
        this.credentialProtectedDataDir = orig.credentialProtectedDataDir;
        this.uid = orig.uid;
        this.minSdkVersion = orig.minSdkVersion;
        this.targetSdkVersion = orig.targetSdkVersion;
        this.setVersionCode(orig.longVersionCode);
        this.enabled = orig.enabled;
        this.enabledSetting = orig.enabledSetting;
        this.installLocation = orig.installLocation;
        this.manageSpaceActivityName = orig.manageSpaceActivityName;
        this.descriptionRes = orig.descriptionRes;
        this.uiOptions = orig.uiOptions;
        this.backupAgentName = orig.backupAgentName;
        this.fullBackupContent = orig.fullBackupContent;
        this.networkSecurityConfigRes = orig.networkSecurityConfigRes;
        this.category = orig.category;
        this.targetSandboxVersion = orig.targetSandboxVersion;
        this.classLoaderName = orig.classLoaderName;
        this.splitClassLoaderNames = orig.splitClassLoaderNames;
        this.appComponentFactory = orig.appComponentFactory;
        this.compileSdkVersion = orig.compileSdkVersion;
        this.compileSdkVersionCodename = orig.compileSdkVersionCodename;
        this.mHiddenApiPolicy = orig.mHiddenApiPolicy;
        this.hiddenUntilInstalled = orig.hiddenUntilInstalled;
    }

    private final String $$robo$$android_content_pm_ApplicationInfo$toString() {
        return "ApplicationInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
    }

    private final int $$robo$$android_content_pm_ApplicationInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$writeToParcel(Parcel dest, int parcelableFlags) {
        super.writeToParcel(dest, parcelableFlags);
        dest.writeString(this.taskAffinity);
        dest.writeString(this.permission);
        dest.writeString(this.processName);
        dest.writeString(this.className);
        dest.writeInt(this.theme);
        dest.writeInt(this.flags);
        dest.writeInt(this.privateFlags);
        dest.writeInt(this.requiresSmallestWidthDp);
        dest.writeInt(this.compatibleWidthLimitDp);
        dest.writeInt(this.largestWidthLimitDp);
        if (this.storageUuid != null) {
            dest.writeInt(1);
            dest.writeLong(this.storageUuid.getMostSignificantBits());
            dest.writeLong(this.storageUuid.getLeastSignificantBits());
        } else {
            dest.writeInt(0);
        }
        dest.writeString(this.scanSourceDir);
        dest.writeString(this.scanPublicSourceDir);
        dest.writeString(this.sourceDir);
        dest.writeString(this.publicSourceDir);
        dest.writeStringArray(this.splitNames);
        dest.writeStringArray(this.splitSourceDirs);
        dest.writeStringArray(this.splitPublicSourceDirs);
        dest.writeSparseArray(this.splitDependencies);
        dest.writeString(this.nativeLibraryDir);
        dest.writeString(this.secondaryNativeLibraryDir);
        dest.writeString(this.nativeLibraryRootDir);
        dest.writeInt(this.nativeLibraryRootRequiresIsa ? 1 : 0);
        dest.writeString(this.primaryCpuAbi);
        dest.writeString(this.secondaryCpuAbi);
        dest.writeStringArray(this.resourceDirs);
        dest.writeString(this.seInfo);
        dest.writeString(this.seInfoUser);
        dest.writeStringArray(this.sharedLibraryFiles);
        dest.writeString(this.dataDir);
        dest.writeString(this.deviceProtectedDataDir);
        dest.writeString(this.credentialProtectedDataDir);
        dest.writeInt(this.uid);
        dest.writeInt(this.minSdkVersion);
        dest.writeInt(this.targetSdkVersion);
        dest.writeLong(this.longVersionCode);
        dest.writeInt(this.enabled ? 1 : 0);
        dest.writeInt(this.enabledSetting);
        dest.writeInt(this.installLocation);
        dest.writeString(this.manageSpaceActivityName);
        dest.writeString(this.backupAgentName);
        dest.writeInt(this.descriptionRes);
        dest.writeInt(this.uiOptions);
        dest.writeInt(this.fullBackupContent);
        dest.writeInt(this.networkSecurityConfigRes);
        dest.writeInt(this.category);
        dest.writeInt(this.targetSandboxVersion);
        dest.writeString(this.classLoaderName);
        dest.writeStringArray(this.splitClassLoaderNames);
        dest.writeInt(this.compileSdkVersion);
        dest.writeString(this.compileSdkVersionCodename);
        dest.writeString(this.appComponentFactory);
        dest.writeInt(this.mHiddenApiPolicy);
        dest.writeInt(this.hiddenUntilInstalled ? 1 : 0);
    }

    private void $$robo$$android_content_pm_ApplicationInfo$__constructor__(Parcel source) {
        this.fullBackupContent = 0;
        this.uiOptions = 0;
        this.flags = 0;
        this.requiresSmallestWidthDp = 0;
        this.compatibleWidthLimitDp = 0;
        this.largestWidthLimitDp = 0;
        this.enabled = true;
        this.enabledSetting = 0;
        this.installLocation = -1;
        this.category = -1;
        this.mHiddenApiPolicy = -1;
        this.taskAffinity = source.readString();
        this.permission = source.readString();
        this.processName = source.readString();
        this.className = source.readString();
        this.theme = source.readInt();
        this.flags = source.readInt();
        this.privateFlags = source.readInt();
        this.requiresSmallestWidthDp = source.readInt();
        this.compatibleWidthLimitDp = source.readInt();
        this.largestWidthLimitDp = source.readInt();
        if (source.readInt() != 0) {
            this.storageUuid = new UUID(source.readLong(), source.readLong());
            this.volumeUuid = StorageManager.convert(this.storageUuid);
        }
        this.scanSourceDir = source.readString();
        this.scanPublicSourceDir = source.readString();
        this.sourceDir = source.readString();
        this.publicSourceDir = source.readString();
        this.splitNames = source.readStringArray();
        this.splitSourceDirs = source.readStringArray();
        this.splitPublicSourceDirs = source.readStringArray();
        this.splitDependencies = source.readSparseArray(null);
        this.nativeLibraryDir = source.readString();
        this.secondaryNativeLibraryDir = source.readString();
        this.nativeLibraryRootDir = source.readString();
        this.nativeLibraryRootRequiresIsa = source.readInt() != 0;
        this.primaryCpuAbi = source.readString();
        this.secondaryCpuAbi = source.readString();
        this.resourceDirs = source.readStringArray();
        this.seInfo = source.readString();
        this.seInfoUser = source.readString();
        this.sharedLibraryFiles = source.readStringArray();
        this.dataDir = source.readString();
        this.deviceProtectedDataDir = source.readString();
        this.credentialProtectedDataDir = source.readString();
        this.uid = source.readInt();
        this.minSdkVersion = source.readInt();
        this.targetSdkVersion = source.readInt();
        this.setVersionCode(source.readLong());
        this.enabled = source.readInt() != 0;
        this.enabledSetting = source.readInt();
        this.installLocation = source.readInt();
        this.manageSpaceActivityName = source.readString();
        this.backupAgentName = source.readString();
        this.descriptionRes = source.readInt();
        this.uiOptions = source.readInt();
        this.fullBackupContent = source.readInt();
        this.networkSecurityConfigRes = source.readInt();
        this.category = source.readInt();
        this.targetSandboxVersion = source.readInt();
        this.classLoaderName = source.readString();
        this.splitClassLoaderNames = source.readStringArray();
        this.compileSdkVersion = source.readInt();
        this.compileSdkVersionCodename = source.readString();
        this.appComponentFactory = source.readString();
        this.mHiddenApiPolicy = source.readInt();
        this.hiddenUntilInstalled = source.readInt() != 0;
    }

    private final CharSequence $$robo$$android_content_pm_ApplicationInfo$loadDescription(PackageManager pm) {
        CharSequence label;
        if (this.descriptionRes != 0 && (label = pm.getText(this.packageName, this.descriptionRes, this)) != null) {
            return label;
        }
        return null;
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$disableCompatibilityMode() {
        this.flags |= 0x83E00;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$usesCompatibilityMode() {
        return this.targetSdkVersion < 4 || (this.flags & 0x83E00) == 0;
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$initForUser(int userId) {
        this.uid = UserHandle.getUid(userId, UserHandle.getAppId(this.uid));
        if ("android".equals(this.packageName)) {
            this.dataDir = Environment.getDataSystemDirectory().getAbsolutePath();
            return;
        }
        this.deviceProtectedDataDir = Environment.getDataUserDePackageDirectory(this.volumeUuid, userId, this.packageName).getAbsolutePath();
        this.credentialProtectedDataDir = Environment.getDataUserCePackageDirectory(this.volumeUuid, userId, this.packageName).getAbsolutePath();
        this.dataDir = (this.privateFlags & 0x20) != 0 ? this.deviceProtectedDataDir : this.credentialProtectedDataDir;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isPackageWhitelistedForHiddenApis() {
        return SystemConfig.getInstance().getHiddenApiWhitelistedApps().contains(this.packageName);
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isAllowedToUseHiddenApis() {
        return this.isSignedWithPlatformKey() || this.isPackageWhitelistedForHiddenApis() && (this.isSystemApp() || this.isUpdatedSystemApp());
    }

    private final int $$robo$$android_content_pm_ApplicationInfo$getHiddenApiEnforcementPolicy() {
        if (this.isAllowedToUseHiddenApis()) {
            return 0;
        }
        if (this.mHiddenApiPolicy != -1) {
            return this.mHiddenApiPolicy;
        }
        if (this.targetSdkVersion < 28) {
            return 3;
        }
        return 2;
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$setHiddenApiEnforcementPolicy(int policy) {
        if (!ApplicationInfo.isValidHiddenApiEnforcementPolicy(policy)) {
            throw new IllegalArgumentException("Invalid API enforcement policy: " + policy);
        }
        this.mHiddenApiPolicy = policy;
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$maybeUpdateHiddenApiEnforcementPolicy(int policyPreP, int policyP) {
        if (this.isPackageWhitelistedForHiddenApis()) {
            return;
        }
        if (this.targetSdkVersion < 28) {
            this.setHiddenApiEnforcementPolicy(policyPreP);
        } else if (this.targetSdkVersion >= 28) {
            this.setHiddenApiEnforcementPolicy(policyP);
        }
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$setVersionCode(long newVersionCode) {
        this.longVersionCode = newVersionCode;
        this.versionCode = (int)newVersionCode;
    }

    private final Drawable $$robo$$android_content_pm_ApplicationInfo$loadDefaultIcon(PackageManager pm) {
        if ((this.flags & 0x40000) != 0 && this.isPackageUnavailable(pm)) {
            return Resources.getSystem().getDrawable(17303558);
        }
        return pm.getDefaultActivityIcon();
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isPackageUnavailable(PackageManager pm) {
        try {
            return pm.getPackageInfo(this.packageName, 0) == null;
        }
        catch (PackageManager.NameNotFoundException ex) {
            return true;
        }
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isDefaultToDeviceProtectedStorage() {
        return (this.privateFlags & 0x20) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isDirectBootAware() {
        return (this.privateFlags & 0x40) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isEncryptionAware() {
        return this.isDirectBootAware() || this.isPartiallyDirectBootAware();
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isExternal() {
        return (this.flags & 0x40000) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isExternalAsec() {
        return TextUtils.isEmpty(this.volumeUuid) && this.isExternal();
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isForwardLocked() {
        return (this.privateFlags & 4) != 0;
    }

    @SystemApi
    private final boolean $$robo$$android_content_pm_ApplicationInfo$isInstantApp() {
        return (this.privateFlags & 0x80) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isInternal() {
        return (this.flags & 0x40000) == 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isOem() {
        return (this.privateFlags & 0x20000) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isPartiallyDirectBootAware() {
        return (this.privateFlags & 0x100) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isSignedWithPlatformKey() {
        return (this.privateFlags & 0x100000) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isPrivilegedApp() {
        return (this.privateFlags & 8) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isRequiredForSystemUser() {
        return (this.privateFlags & 0x200) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isStaticSharedLibrary() {
        return (this.privateFlags & 0x4000) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isSystemApp() {
        return (this.flags & 1) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isUpdatedSystemApp() {
        return (this.flags & 0x80) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isVendor() {
        return (this.privateFlags & 0x40000) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isProduct() {
        return (this.privateFlags & 0x80000) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$isVirtualPreload() {
        return (this.privateFlags & 0x10000) != 0;
    }

    private final boolean $$robo$$android_content_pm_ApplicationInfo$requestsIsolatedSplitLoading() {
        return (this.privateFlags & 0x8000) != 0;
    }

    private final ApplicationInfo $$robo$$android_content_pm_ApplicationInfo$getApplicationInfo() {
        return this;
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$setCodePath(String codePath) {
        this.scanSourceDir = codePath;
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$setBaseCodePath(String baseCodePath) {
        this.sourceDir = baseCodePath;
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$setSplitCodePaths(String[] splitCodePaths) {
        this.splitSourceDirs = splitCodePaths;
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$setResourcePath(String resourcePath) {
        this.scanPublicSourceDir = resourcePath;
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$setBaseResourcePath(String baseResourcePath) {
        this.publicSourceDir = baseResourcePath;
    }

    private final void $$robo$$android_content_pm_ApplicationInfo$setSplitResourcePaths(String[] splitResourcePaths) {
        this.splitPublicSourceDirs = splitResourcePaths;
    }

    private final String $$robo$$android_content_pm_ApplicationInfo$getCodePath() {
        return this.scanSourceDir;
    }

    private final String $$robo$$android_content_pm_ApplicationInfo$getBaseCodePath() {
        return this.sourceDir;
    }

    private final String[] $$robo$$android_content_pm_ApplicationInfo$getSplitCodePaths() {
        return this.splitSourceDirs;
    }

    private final String $$robo$$android_content_pm_ApplicationInfo$getResourcePath() {
        return this.scanPublicSourceDir;
    }

    private final String $$robo$$android_content_pm_ApplicationInfo$getBaseResourcePath() {
        return this.publicSourceDir;
    }

    private final String[] $$robo$$android_content_pm_ApplicationInfo$getSplitResourcePaths() {
        return this.splitPublicSourceDirs;
    }

    private /* synthetic */ void $$robo$$android_content_pm_ApplicationInfo$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ApplicationInfo>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_pm_ApplicationInfo_1$__constructor__() {
            }

            private final ApplicationInfo $$robo$$android_content_pm_ApplicationInfo_1$createFromParcel(Parcel source) {
                return new ApplicationInfo(source, null);
            }

            private final ApplicationInfo[] $$robo$$android_content_pm_ApplicationInfo_1$newArray(int size) {
                return new ApplicationInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_pm_ApplicationInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ApplicationInfo_1$__constructor__(), this);
            }

            @Override
            public ApplicationInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_ApplicationInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public ApplicationInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_ApplicationInfo_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static CharSequence getCategoryTitle(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getCategoryTitle", $$robo$$android_content_pm_ApplicationInfo$getCategoryTitle(android.content.Context int ), (Context)context, (int)n);
    }

    public static boolean isValidHiddenApiEnforcementPolicy(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidHiddenApiEnforcementPolicy", $$robo$$android_content_pm_ApplicationInfo$isValidHiddenApiEnforcementPolicy(int ), (int)n);
    }

    public void dump(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_content_pm_ApplicationInfo$dump(android.util.Printer java.lang.String ), this, printer, string2);
    }

    public void dump(Printer printer, String string2, int n) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_content_pm_ApplicationInfo$dump(android.util.Printer java.lang.String int ), this, printer, string2, n);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long l, int n) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_content_pm_ApplicationInfo$writeToProto(android.util.proto.ProtoOutputStream long int ), this, protoOutputStream, l, n);
    }

    public boolean hasRtlSupport() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasRtlSupport", $$robo$$android_content_pm_ApplicationInfo$hasRtlSupport(), this);
    }

    public boolean hasCode() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCode", $$robo$$android_content_pm_ApplicationInfo$hasCode(), this);
    }

    private void __constructor__() {
        this.$$robo$$android_content_pm_ApplicationInfo$__constructor__();
    }

    public ApplicationInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ApplicationInfo$__constructor__(), this);
    }

    private void __constructor__(ApplicationInfo applicationInfo) {
        this.$$robo$$android_content_pm_ApplicationInfo$__constructor__(applicationInfo);
    }

    public ApplicationInfo(ApplicationInfo applicationInfo) {
        super(applicationInfo);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ApplicationInfo$__constructor__(android.content.pm.ApplicationInfo ), this, applicationInfo);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_ApplicationInfo$toString(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_ApplicationInfo$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_ApplicationInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_pm_ApplicationInfo$__constructor__(parcel);
    }

    public ApplicationInfo(Parcel parcel) {
        super(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ApplicationInfo$__constructor__(android.os.Parcel ), this, parcel);
    }

    public CharSequence loadDescription(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadDescription", $$robo$$android_content_pm_ApplicationInfo$loadDescription(android.content.pm.PackageManager ), this, packageManager);
    }

    public void disableCompatibilityMode() {
        InvokeDynamicSupport.bootstrap("disableCompatibilityMode", $$robo$$android_content_pm_ApplicationInfo$disableCompatibilityMode(), this);
    }

    public boolean usesCompatibilityMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("usesCompatibilityMode", $$robo$$android_content_pm_ApplicationInfo$usesCompatibilityMode(), this);
    }

    public void initForUser(int n) {
        InvokeDynamicSupport.bootstrap("initForUser", $$robo$$android_content_pm_ApplicationInfo$initForUser(int ), this, n);
    }

    private boolean isPackageWhitelistedForHiddenApis() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPackageWhitelistedForHiddenApis", $$robo$$android_content_pm_ApplicationInfo$isPackageWhitelistedForHiddenApis(), this);
    }

    private boolean isAllowedToUseHiddenApis() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAllowedToUseHiddenApis", $$robo$$android_content_pm_ApplicationInfo$isAllowedToUseHiddenApis(), this);
    }

    public int getHiddenApiEnforcementPolicy() {
        return (int)InvokeDynamicSupport.bootstrap("getHiddenApiEnforcementPolicy", $$robo$$android_content_pm_ApplicationInfo$getHiddenApiEnforcementPolicy(), this);
    }

    public void setHiddenApiEnforcementPolicy(int n) {
        InvokeDynamicSupport.bootstrap("setHiddenApiEnforcementPolicy", $$robo$$android_content_pm_ApplicationInfo$setHiddenApiEnforcementPolicy(int ), this, n);
    }

    public void maybeUpdateHiddenApiEnforcementPolicy(int n, int n2) {
        InvokeDynamicSupport.bootstrap("maybeUpdateHiddenApiEnforcementPolicy", $$robo$$android_content_pm_ApplicationInfo$maybeUpdateHiddenApiEnforcementPolicy(int int ), this, n, n2);
    }

    public void setVersionCode(long l) {
        InvokeDynamicSupport.bootstrap("setVersionCode", $$robo$$android_content_pm_ApplicationInfo$setVersionCode(long ), this, l);
    }

    @Override
    public Drawable loadDefaultIcon(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadDefaultIcon", $$robo$$android_content_pm_ApplicationInfo$loadDefaultIcon(android.content.pm.PackageManager ), this, packageManager);
    }

    private boolean isPackageUnavailable(PackageManager packageManager) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPackageUnavailable", $$robo$$android_content_pm_ApplicationInfo$isPackageUnavailable(android.content.pm.PackageManager ), this, packageManager);
    }

    public boolean isDefaultToDeviceProtectedStorage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDefaultToDeviceProtectedStorage", $$robo$$android_content_pm_ApplicationInfo$isDefaultToDeviceProtectedStorage(), this);
    }

    public boolean isDirectBootAware() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDirectBootAware", $$robo$$android_content_pm_ApplicationInfo$isDirectBootAware(), this);
    }

    public boolean isEncryptionAware() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEncryptionAware", $$robo$$android_content_pm_ApplicationInfo$isEncryptionAware(), this);
    }

    public boolean isExternal() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExternal", $$robo$$android_content_pm_ApplicationInfo$isExternal(), this);
    }

    public boolean isExternalAsec() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExternalAsec", $$robo$$android_content_pm_ApplicationInfo$isExternalAsec(), this);
    }

    public boolean isForwardLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isForwardLocked", $$robo$$android_content_pm_ApplicationInfo$isForwardLocked(), this);
    }

    @SystemApi
    public boolean isInstantApp() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInstantApp", $$robo$$android_content_pm_ApplicationInfo$isInstantApp(), this);
    }

    public boolean isInternal() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInternal", $$robo$$android_content_pm_ApplicationInfo$isInternal(), this);
    }

    public boolean isOem() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOem", $$robo$$android_content_pm_ApplicationInfo$isOem(), this);
    }

    public boolean isPartiallyDirectBootAware() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPartiallyDirectBootAware", $$robo$$android_content_pm_ApplicationInfo$isPartiallyDirectBootAware(), this);
    }

    public boolean isSignedWithPlatformKey() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSignedWithPlatformKey", $$robo$$android_content_pm_ApplicationInfo$isSignedWithPlatformKey(), this);
    }

    public boolean isPrivilegedApp() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrivilegedApp", $$robo$$android_content_pm_ApplicationInfo$isPrivilegedApp(), this);
    }

    public boolean isRequiredForSystemUser() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRequiredForSystemUser", $$robo$$android_content_pm_ApplicationInfo$isRequiredForSystemUser(), this);
    }

    public boolean isStaticSharedLibrary() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStaticSharedLibrary", $$robo$$android_content_pm_ApplicationInfo$isStaticSharedLibrary(), this);
    }

    public boolean isSystemApp() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSystemApp", $$robo$$android_content_pm_ApplicationInfo$isSystemApp(), this);
    }

    public boolean isUpdatedSystemApp() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUpdatedSystemApp", $$robo$$android_content_pm_ApplicationInfo$isUpdatedSystemApp(), this);
    }

    public boolean isVendor() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVendor", $$robo$$android_content_pm_ApplicationInfo$isVendor(), this);
    }

    public boolean isProduct() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProduct", $$robo$$android_content_pm_ApplicationInfo$isProduct(), this);
    }

    public boolean isVirtualPreload() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVirtualPreload", $$robo$$android_content_pm_ApplicationInfo$isVirtualPreload(), this);
    }

    public boolean requestsIsolatedSplitLoading() {
        return (boolean)InvokeDynamicSupport.bootstrap("requestsIsolatedSplitLoading", $$robo$$android_content_pm_ApplicationInfo$requestsIsolatedSplitLoading(), this);
    }

    @Override
    protected ApplicationInfo getApplicationInfo() {
        return InvokeDynamicSupport.bootstrap("getApplicationInfo", $$robo$$android_content_pm_ApplicationInfo$getApplicationInfo(), this);
    }

    public void setCodePath(String string2) {
        InvokeDynamicSupport.bootstrap("setCodePath", $$robo$$android_content_pm_ApplicationInfo$setCodePath(java.lang.String ), this, string2);
    }

    public void setBaseCodePath(String string2) {
        InvokeDynamicSupport.bootstrap("setBaseCodePath", $$robo$$android_content_pm_ApplicationInfo$setBaseCodePath(java.lang.String ), this, string2);
    }

    public void setSplitCodePaths(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setSplitCodePaths", $$robo$$android_content_pm_ApplicationInfo$setSplitCodePaths(java.lang.String[] ), this, stringArray);
    }

    public void setResourcePath(String string2) {
        InvokeDynamicSupport.bootstrap("setResourcePath", $$robo$$android_content_pm_ApplicationInfo$setResourcePath(java.lang.String ), this, string2);
    }

    public void setBaseResourcePath(String string2) {
        InvokeDynamicSupport.bootstrap("setBaseResourcePath", $$robo$$android_content_pm_ApplicationInfo$setBaseResourcePath(java.lang.String ), this, string2);
    }

    public void setSplitResourcePaths(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setSplitResourcePaths", $$robo$$android_content_pm_ApplicationInfo$setSplitResourcePaths(java.lang.String[] ), this, stringArray);
    }

    public String getCodePath() {
        return InvokeDynamicSupport.bootstrap("getCodePath", $$robo$$android_content_pm_ApplicationInfo$getCodePath(), this);
    }

    public String getBaseCodePath() {
        return InvokeDynamicSupport.bootstrap("getBaseCodePath", $$robo$$android_content_pm_ApplicationInfo$getBaseCodePath(), this);
    }

    public String[] getSplitCodePaths() {
        return InvokeDynamicSupport.bootstrap("getSplitCodePaths", $$robo$$android_content_pm_ApplicationInfo$getSplitCodePaths(), this);
    }

    public String getResourcePath() {
        return InvokeDynamicSupport.bootstrap("getResourcePath", $$robo$$android_content_pm_ApplicationInfo$getResourcePath(), this);
    }

    public String getBaseResourcePath() {
        return InvokeDynamicSupport.bootstrap("getBaseResourcePath", $$robo$$android_content_pm_ApplicationInfo$getBaseResourcePath(), this);
    }

    public String[] getSplitResourcePaths() {
        return InvokeDynamicSupport.bootstrap("getSplitResourcePaths", $$robo$$android_content_pm_ApplicationInfo$getSplitResourcePaths(), this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_content_pm_ApplicationInfo$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ ApplicationInfo(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ApplicationInfo$__constructor__(android.os.Parcel android.content.pm.ApplicationInfo$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(ApplicationInfo.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApplicationInfo)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class DisplayNameComparator
    implements Comparator<ApplicationInfo> {
        public /* synthetic */ Object __robo_data__;
        private Collator sCollator;
        private PackageManager mPM;

        private void $$robo$$android_content_pm_ApplicationInfo_DisplayNameComparator$__constructor__(PackageManager pm) {
            this.sCollator = Collator.getInstance();
            this.mPM = pm;
        }

        private final int $$robo$$android_content_pm_ApplicationInfo_DisplayNameComparator$compare(ApplicationInfo aa, ApplicationInfo ab) {
            CharSequence sb;
            CharSequence sa = this.mPM.getApplicationLabel(aa);
            if (sa == null) {
                sa = aa.packageName;
            }
            if ((sb = this.mPM.getApplicationLabel(ab)) == null) {
                sb = ab.packageName;
            }
            return this.sCollator.compare(sa.toString(), sb.toString());
        }

        private void __constructor__(PackageManager packageManager) {
            this.$$robo$$android_content_pm_ApplicationInfo_DisplayNameComparator$__constructor__(packageManager);
        }

        public DisplayNameComparator(PackageManager packageManager) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ApplicationInfo_DisplayNameComparator$__constructor__(android.content.pm.PackageManager ), this, packageManager);
        }

        @Override
        public int compare(ApplicationInfo applicationInfo, ApplicationInfo applicationInfo2) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_content_pm_ApplicationInfo_DisplayNameComparator$compare(android.content.pm.ApplicationInfo android.content.pm.ApplicationInfo ), this, applicationInfo, applicationInfo2);
        }

        public /* synthetic */ DisplayNameComparator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisplayNameComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HiddenApiEnforcementPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Category {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApplicationInfoPrivateFlags {
    }
}

