/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.AppOpsManager;
import android.content.Context;
import android.os.Binder;
import android.os.Process;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PermissionChecker
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int PERMISSION_GRANTED = 0;
    public static int PERMISSION_DENIED = -1;
    public static int PERMISSION_DENIED_APP_OP = -2;

    private void $$robo$$android_content_PermissionChecker$__constructor__() {
    }

    private static final int $$robo$$android_content_PermissionChecker$checkPermission(Context context, String permission2, int pid, int uid, String packageName) {
        if (context.checkPermission(permission2, pid, uid) == -1) {
            return -1;
        }
        AppOpsManager appOpsManager = context.getSystemService(AppOpsManager.class);
        String op = AppOpsManager.permissionToOp(permission2);
        if (op == null) {
            return 0;
        }
        if (packageName == null) {
            String[] packageNames = context.getPackageManager().getPackagesForUid(uid);
            if (packageNames == null || packageNames.length <= 0) {
                return -1;
            }
            packageName = packageNames[0];
        }
        if (appOpsManager.noteProxyOpNoThrow(op, packageName) != 0) {
            return -2;
        }
        return 0;
    }

    private static final int $$robo$$android_content_PermissionChecker$checkSelfPermission(Context context, String permission2) {
        return PermissionChecker.checkPermission(context, permission2, Process.myPid(), Process.myUid(), context.getPackageName());
    }

    private static final int $$robo$$android_content_PermissionChecker$checkCallingPermission(Context context, String permission2, String packageName) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return -1;
        }
        return PermissionChecker.checkPermission(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), packageName);
    }

    private static final int $$robo$$android_content_PermissionChecker$checkCallingOrSelfPermission(Context context, String permission2) {
        String packageName = Binder.getCallingPid() == Process.myPid() ? context.getPackageName() : null;
        return PermissionChecker.checkPermission(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), packageName);
    }

    private void __constructor__() {
        this.$$robo$$android_content_PermissionChecker$__constructor__();
    }

    public PermissionChecker() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_PermissionChecker$__constructor__(), this);
    }

    public static int checkPermission(Context context, String string2, int n, int n2, String string3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkPermission", $$robo$$android_content_PermissionChecker$checkPermission(android.content.Context java.lang.String int int java.lang.String ), (Context)context, (String)string2, (int)n, (int)n2, (String)string3);
    }

    public static int checkSelfPermission(Context context, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkSelfPermission", $$robo$$android_content_PermissionChecker$checkSelfPermission(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    public static int checkCallingPermission(Context context, String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkCallingPermission", $$robo$$android_content_PermissionChecker$checkCallingPermission(android.content.Context java.lang.String java.lang.String ), (Context)context, (String)string2, (String)string3);
    }

    public static int checkCallingOrSelfPermission(Context context, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkCallingOrSelfPermission", $$robo$$android_content_PermissionChecker$checkCallingOrSelfPermission(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PermissionChecker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionResult {
    }
}

