/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AdvertisingSet
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "AdvertisingSet";
    private IBluetoothGatt mGatt;
    private int mAdvertiserId;

    private void $$robo$$android_bluetooth_le_AdvertisingSet$__constructor__(int advertiserId, IBluetoothManager bluetoothManager) {
        this.mAdvertiserId = advertiserId;
        try {
            this.mGatt = bluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "Failed to get Bluetooth gatt - ", e);
            throw new IllegalStateException("Failed to get Bluetooth");
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setAdvertiserId(int advertiserId) {
        this.mAdvertiserId = advertiserId;
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$enableAdvertising(boolean enable, int duration, int maxExtendedAdvertisingEvents) {
        try {
            this.mGatt.enableAdvertisingSet(this.mAdvertiserId, enable, duration, maxExtendedAdvertisingEvents);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setAdvertisingData(AdvertiseData advertiseData) {
        try {
            this.mGatt.setAdvertisingData(this.mAdvertiserId, advertiseData);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setScanResponseData(AdvertiseData scanResponse) {
        try {
            this.mGatt.setScanResponseData(this.mAdvertiserId, scanResponse);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setAdvertisingParameters(AdvertisingSetParameters parameters) {
        try {
            this.mGatt.setAdvertisingParameters(this.mAdvertiserId, parameters);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setPeriodicAdvertisingParameters(PeriodicAdvertisingParameters parameters) {
        try {
            this.mGatt.setPeriodicAdvertisingParameters(this.mAdvertiserId, parameters);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setPeriodicAdvertisingData(AdvertiseData periodicData) {
        try {
            this.mGatt.setPeriodicAdvertisingData(this.mAdvertiserId, periodicData);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setPeriodicAdvertisingEnabled(boolean enable) {
        try {
            this.mGatt.setPeriodicAdvertisingEnable(this.mAdvertiserId, enable);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$getOwnAddress() {
        try {
            this.mGatt.getOwnAddress(this.mAdvertiserId);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final int $$robo$$android_bluetooth_le_AdvertisingSet$getAdvertiserId() {
        return this.mAdvertiserId;
    }

    private void __constructor__(int n, IBluetoothManager iBluetoothManager) {
        this.$$robo$$android_bluetooth_le_AdvertisingSet$__constructor__(n, iBluetoothManager);
    }

    public AdvertisingSet(int n, IBluetoothManager iBluetoothManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_AdvertisingSet$__constructor__(int android.bluetooth.IBluetoothManager ), this, n, iBluetoothManager);
    }

    void setAdvertiserId(int n) {
        InvokeDynamicSupport.bootstrap("setAdvertiserId", $$robo$$android_bluetooth_le_AdvertisingSet$setAdvertiserId(int ), this, n);
    }

    public void enableAdvertising(boolean bl, int n, int n2) {
        InvokeDynamicSupport.bootstrap("enableAdvertising", $$robo$$android_bluetooth_le_AdvertisingSet$enableAdvertising(boolean int int ), this, bl, n, n2);
    }

    public void setAdvertisingData(AdvertiseData advertiseData) {
        InvokeDynamicSupport.bootstrap("setAdvertisingData", $$robo$$android_bluetooth_le_AdvertisingSet$setAdvertisingData(android.bluetooth.le.AdvertiseData ), this, advertiseData);
    }

    public void setScanResponseData(AdvertiseData advertiseData) {
        InvokeDynamicSupport.bootstrap("setScanResponseData", $$robo$$android_bluetooth_le_AdvertisingSet$setScanResponseData(android.bluetooth.le.AdvertiseData ), this, advertiseData);
    }

    public void setAdvertisingParameters(AdvertisingSetParameters advertisingSetParameters) {
        InvokeDynamicSupport.bootstrap("setAdvertisingParameters", $$robo$$android_bluetooth_le_AdvertisingSet$setAdvertisingParameters(android.bluetooth.le.AdvertisingSetParameters ), this, advertisingSetParameters);
    }

    public void setPeriodicAdvertisingParameters(PeriodicAdvertisingParameters periodicAdvertisingParameters) {
        InvokeDynamicSupport.bootstrap("setPeriodicAdvertisingParameters", $$robo$$android_bluetooth_le_AdvertisingSet$setPeriodicAdvertisingParameters(android.bluetooth.le.PeriodicAdvertisingParameters ), this, periodicAdvertisingParameters);
    }

    public void setPeriodicAdvertisingData(AdvertiseData advertiseData) {
        InvokeDynamicSupport.bootstrap("setPeriodicAdvertisingData", $$robo$$android_bluetooth_le_AdvertisingSet$setPeriodicAdvertisingData(android.bluetooth.le.AdvertiseData ), this, advertiseData);
    }

    public void setPeriodicAdvertisingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPeriodicAdvertisingEnabled", $$robo$$android_bluetooth_le_AdvertisingSet$setPeriodicAdvertisingEnabled(boolean ), this, bl);
    }

    public void getOwnAddress() {
        InvokeDynamicSupport.bootstrap("getOwnAddress", $$robo$$android_bluetooth_le_AdvertisingSet$getOwnAddress(), this);
    }

    public int getAdvertiserId() {
        return (int)InvokeDynamicSupport.bootstrap("getAdvertiserId", $$robo$$android_bluetooth_le_AdvertisingSet$getAdvertiserId(), this);
    }

    public /* synthetic */ AdvertisingSet() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdvertisingSet)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

