/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothInputStream;
import android.bluetooth.BluetoothOutputStream;
import android.bluetooth.IBluetooth;
import android.net.LocalSocket;
import android.os.ParcelFileDescriptor;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothSocket
implements Closeable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothSocket";
    private static boolean DBG;
    private static boolean VDBG;
    public static int MAX_RFCOMM_CHANNEL = 30;
    static int MAX_L2CAP_PACKAGE_SIZE = 65535;
    public static int TYPE_RFCOMM = 1;
    public static int TYPE_SCO = 2;
    public static int TYPE_L2CAP = 3;
    public static int TYPE_L2CAP_BREDR = 3;
    public static int TYPE_L2CAP_LE = 4;
    static int EBADFD = 77;
    static int EADDRINUSE = 98;
    static int SEC_FLAG_ENCRYPT = 1;
    static int SEC_FLAG_AUTH = 2;
    static int BTSOCK_FLAG_NO_SDP = 4;
    static int SEC_FLAG_AUTH_MITM = 8;
    static int SEC_FLAG_AUTH_16_DIGIT = 16;
    private int mType;
    private BluetoothDevice mDevice;
    private String mAddress;
    private boolean mAuth;
    private boolean mEncrypt;
    private BluetoothInputStream mInputStream;
    private BluetoothOutputStream mOutputStream;
    private ParcelUuid mUuid;
    private boolean mExcludeSdp;
    private boolean mAuthMitm;
    private boolean mMin16DigitPin;
    private ParcelFileDescriptor mPfd;
    private LocalSocket mSocket;
    private InputStream mSocketIS;
    private OutputStream mSocketOS;
    private int mPort;
    private int mFd;
    private String mServiceName;
    private static int PROXY_CONNECTION_TIMEOUT = 5000;
    private static int SOCK_SIGNAL_SIZE = 20;
    private ByteBuffer mL2capBuffer;
    private int mMaxTxPacketSize;
    private int mMaxRxPacketSize;
    private volatile SocketState mSocketState;

    private void $$robo$$android_bluetooth_BluetoothSocket$__constructor__(int type, int fd, boolean auth, boolean encrypt, BluetoothDevice device, int port, ParcelUuid uuid) throws IOException {
    }

    private void $$robo$$android_bluetooth_BluetoothSocket$__constructor__(int type, int fd, boolean auth, boolean encrypt, BluetoothDevice device, int port, ParcelUuid uuid, boolean mitm, boolean min16DigitPin) throws IOException {
        this.mExcludeSdp = false;
        this.mAuthMitm = false;
        this.mMin16DigitPin = false;
        this.mL2capBuffer = null;
        this.mMaxTxPacketSize = 0;
        this.mMaxRxPacketSize = 0;
        if (VDBG) {
            Log.d("BluetoothSocket", "Creating new BluetoothSocket of type: " + type);
        }
        if (type == 1 && uuid == null && fd == -1 && port != -2 && (port < 1 || port > 30)) {
            throw new IOException("Invalid RFCOMM channel: " + port);
        }
        this.mUuid = uuid != null ? uuid : new ParcelUuid(new UUID(0L, 0L));
        this.mType = type;
        this.mAuth = auth;
        this.mAuthMitm = mitm;
        this.mMin16DigitPin = min16DigitPin;
        this.mEncrypt = encrypt;
        this.mDevice = device;
        this.mPort = port;
        this.mFd = fd;
        this.mSocketState = SocketState.INIT;
        this.mAddress = device == null ? BluetoothAdapter.getDefaultAdapter().getAddress() : device.getAddress();
        this.mInputStream = new BluetoothInputStream(this);
        this.mOutputStream = new BluetoothOutputStream(this);
    }

    private void $$robo$$android_bluetooth_BluetoothSocket$__constructor__(BluetoothSocket s) {
        this.mExcludeSdp = false;
        this.mAuthMitm = false;
        this.mMin16DigitPin = false;
        this.mL2capBuffer = null;
        this.mMaxTxPacketSize = 0;
        this.mMaxRxPacketSize = 0;
        if (VDBG) {
            Log.d("BluetoothSocket", "Creating new Private BluetoothSocket of type: " + s.mType);
        }
        this.mUuid = s.mUuid;
        this.mType = s.mType;
        this.mAuth = s.mAuth;
        this.mEncrypt = s.mEncrypt;
        this.mPort = s.mPort;
        this.mInputStream = new BluetoothInputStream(this);
        this.mOutputStream = new BluetoothOutputStream(this);
        this.mMaxRxPacketSize = s.mMaxRxPacketSize;
        this.mMaxTxPacketSize = s.mMaxTxPacketSize;
        this.mServiceName = s.mServiceName;
        this.mExcludeSdp = s.mExcludeSdp;
        this.mAuthMitm = s.mAuthMitm;
        this.mMin16DigitPin = s.mMin16DigitPin;
    }

    private final BluetoothSocket $$robo$$android_bluetooth_BluetoothSocket$acceptSocket(String remoteAddr) throws IOException {
        BluetoothSocket as = new BluetoothSocket(this);
        as.mSocketState = SocketState.CONNECTED;
        Object[] fds = this.mSocket.getAncillaryFileDescriptors();
        if (DBG) {
            Log.d("BluetoothSocket", "socket fd passed by stack fds: " + Arrays.toString(fds));
        }
        if (fds == null || fds.length != 1) {
            Log.e("BluetoothSocket", "socket fd passed from stack failed, fds: " + Arrays.toString(fds));
            as.close();
            throw new IOException("bt socket acept failed");
        }
        as.mPfd = new ParcelFileDescriptor((FileDescriptor)fds[0]);
        as.mSocket = LocalSocket.createConnectedLocalSocket((FileDescriptor)fds[0]);
        as.mSocketIS = as.mSocket.getInputStream();
        as.mSocketOS = as.mSocket.getOutputStream();
        as.mAddress = remoteAddr;
        as.mDevice = BluetoothAdapter.getDefaultAdapter().getRemoteDevice(remoteAddr);
        return as;
    }

    private void $$robo$$android_bluetooth_BluetoothSocket$__constructor__(int type, int fd, boolean auth, boolean encrypt, String address, int port) throws IOException {
    }

    private final void $$robo$$android_bluetooth_BluetoothSocket$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final int $$robo$$android_bluetooth_BluetoothSocket$getSecurityFlags() {
        int flags = 0;
        if (this.mAuth) {
            flags |= 2;
        }
        if (this.mEncrypt) {
            flags |= 1;
        }
        if (this.mExcludeSdp) {
            flags |= 4;
        }
        if (this.mAuthMitm) {
            flags |= 8;
        }
        if (this.mMin16DigitPin) {
            flags |= 0x10;
        }
        return flags;
    }

    private final BluetoothDevice $$robo$$android_bluetooth_BluetoothSocket$getRemoteDevice() {
        return this.mDevice;
    }

    private final InputStream $$robo$$android_bluetooth_BluetoothSocket$getInputStream() throws IOException {
        return this.mInputStream;
    }

    private final OutputStream $$robo$$android_bluetooth_BluetoothSocket$getOutputStream() throws IOException {
        return this.mOutputStream;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothSocket$isConnected() {
        return this.mSocketState == SocketState.CONNECTED;
    }

    private final void $$robo$$android_bluetooth_BluetoothSocket$setServiceName(String name) {
        this.mServiceName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothSocket$connect() throws IOException {
        if (this.mDevice == null) {
            throw new IOException("Connect is called on null device");
        }
        try {
            if (this.mSocketState == SocketState.CLOSED) {
                throw new IOException("socket closed");
            }
            IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService(null);
            if (bluetoothProxy == null) {
                throw new IOException("Bluetooth is off");
            }
            this.mPfd = bluetoothProxy.getSocketManager().connectSocket(this.mDevice, this.mType, this.mUuid, this.mPort, this.getSecurityFlags());
            BluetoothSocket bluetoothSocket = this;
            synchronized (bluetoothSocket) {
                if (DBG) {
                    Log.d("BluetoothSocket", "connect(), SocketState: " + (Object)((Object)this.mSocketState) + ", mPfd: " + this.mPfd);
                }
                if (this.mSocketState == SocketState.CLOSED) {
                    throw new IOException("socket closed");
                }
                if (this.mPfd == null) {
                    throw new IOException("bt socket connect failed");
                }
                FileDescriptor fd = this.mPfd.getFileDescriptor();
                this.mSocket = LocalSocket.createConnectedLocalSocket(fd);
                this.mSocketIS = this.mSocket.getInputStream();
                this.mSocketOS = this.mSocket.getOutputStream();
            }
            int channel = this.readInt(this.mSocketIS);
            if (channel <= 0) {
                throw new IOException("bt socket connect failed");
            }
            this.mPort = channel;
            this.waitSocketSignal(this.mSocketIS);
            BluetoothSocket bluetoothSocket2 = this;
            synchronized (bluetoothSocket2) {
                if (this.mSocketState == SocketState.CLOSED) {
                    throw new IOException("bt socket closed");
                }
                this.mSocketState = SocketState.CONNECTED;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothSocket", Log.getStackTraceString(new Throwable()));
            throw new IOException("unable to send RPC: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothSocket$bindListen() {
        int ret;
        if (this.mSocketState == SocketState.CLOSED) {
            return 77;
        }
        IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService(null);
        if (bluetoothProxy == null) {
            Log.e("BluetoothSocket", "bindListen fail, reason: bluetooth is off");
            return -1;
        }
        try {
            if (DBG) {
                Log.d("BluetoothSocket", "bindListen(): mPort=" + this.mPort + ", mType=" + this.mType);
            }
            this.mPfd = bluetoothProxy.getSocketManager().createSocketChannel(this.mType, this.mServiceName, this.mUuid, this.mPort, this.getSecurityFlags());
        }
        catch (RemoteException e) {
            Log.e("BluetoothSocket", Log.getStackTraceString(new Throwable()));
            return -1;
        }
        try {
            Object fd;
            BluetoothSocket e = this;
            synchronized (e) {
                if (DBG) {
                    Log.d("BluetoothSocket", "bindListen(), SocketState: " + (Object)((Object)this.mSocketState) + ", mPfd: " + this.mPfd);
                }
                if (this.mSocketState != SocketState.INIT) {
                    return 77;
                }
                if (this.mPfd == null) {
                    return -1;
                }
                fd = this.mPfd.getFileDescriptor();
                if (fd == null) {
                    Log.e("BluetoothSocket", "bindListen(), null file descriptor");
                    return -1;
                }
                if (DBG) {
                    Log.d("BluetoothSocket", "bindListen(), Create LocalSocket");
                }
                this.mSocket = LocalSocket.createConnectedLocalSocket((FileDescriptor)fd);
                if (DBG) {
                    Log.d("BluetoothSocket", "bindListen(), new LocalSocket.getInputStream()");
                }
                this.mSocketIS = this.mSocket.getInputStream();
                this.mSocketOS = this.mSocket.getOutputStream();
            }
            if (DBG) {
                Log.d("BluetoothSocket", "bindListen(), readInt mSocketIS: " + this.mSocketIS);
            }
            int channel = this.readInt(this.mSocketIS);
            fd = this;
            synchronized (fd) {
                if (this.mSocketState == SocketState.INIT) {
                    this.mSocketState = SocketState.LISTENING;
                }
            }
            if (DBG) {
                Log.d("BluetoothSocket", "bindListen(): channel=" + channel + ", mPort=" + this.mPort);
            }
            if (this.mPort <= -1) {
                this.mPort = channel;
            }
            ret = 0;
        }
        catch (IOException e) {
            if (this.mPfd != null) {
                try {
                    this.mPfd.close();
                }
                catch (IOException e1) {
                    Log.e("BluetoothSocket", "bindListen, close mPfd: " + e1);
                }
                this.mPfd = null;
            }
            Log.e("BluetoothSocket", "bindListen, fail to get port number, exception: " + e);
            return -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BluetoothSocket $$robo$$android_bluetooth_BluetoothSocket$accept(int timeout) throws IOException {
        BluetoothSocket acceptedSocket;
        if (this.mSocketState != SocketState.LISTENING) {
            throw new IOException("bt socket is not in listen state");
        }
        if (timeout > 0) {
            Log.d("BluetoothSocket", "accept() set timeout (ms):" + timeout);
            this.mSocket.setSoTimeout(timeout);
        }
        String RemoteAddr = this.waitSocketSignal(this.mSocketIS);
        if (timeout > 0) {
            this.mSocket.setSoTimeout(0);
        }
        BluetoothSocket bluetoothSocket = this;
        synchronized (bluetoothSocket) {
            if (this.mSocketState != SocketState.LISTENING) {
                throw new IOException("bt socket is not in listen state");
            }
            acceptedSocket = this.acceptSocket(RemoteAddr);
        }
        return acceptedSocket;
    }

    private final int $$robo$$android_bluetooth_BluetoothSocket$available() throws IOException {
        if (VDBG) {
            Log.d("BluetoothSocket", "available: " + this.mSocketIS);
        }
        return this.mSocketIS.available();
    }

    private final void $$robo$$android_bluetooth_BluetoothSocket$flush() throws IOException {
        if (this.mSocketOS == null) {
            throw new IOException("flush is called on null OutputStream");
        }
        if (VDBG) {
            Log.d("BluetoothSocket", "flush: " + this.mSocketOS);
        }
        this.mSocketOS.flush();
    }

    private final int $$robo$$android_bluetooth_BluetoothSocket$read(byte[] b, int offset, int length) throws IOException {
        int ret = 0;
        if (VDBG) {
            Log.d("BluetoothSocket", "read in:  " + this.mSocketIS + " len: " + length);
        }
        if (this.mType == 3 || this.mType == 4) {
            int bytesToRead = length;
            if (VDBG) {
                Log.v("BluetoothSocket", "l2cap: read(): offset: " + offset + " length:" + length + "mL2capBuffer= " + this.mL2capBuffer);
            }
            if (this.mL2capBuffer == null) {
                this.createL2capRxBuffer();
            }
            if (this.mL2capBuffer.remaining() == 0) {
                if (VDBG) {
                    Log.v("BluetoothSocket", "l2cap buffer empty, refilling...");
                }
                if (this.fillL2capRxBuffer() == -1) {
                    return -1;
                }
            }
            if (bytesToRead > this.mL2capBuffer.remaining()) {
                bytesToRead = this.mL2capBuffer.remaining();
            }
            if (VDBG) {
                Log.v("BluetoothSocket", "get(): offset: " + offset + " bytesToRead: " + bytesToRead);
            }
            this.mL2capBuffer.get(b, offset, bytesToRead);
            ret = bytesToRead;
        } else {
            if (VDBG) {
                Log.v("BluetoothSocket", "default: read(): offset: " + offset + " length:" + length);
            }
            ret = this.mSocketIS.read(b, offset, length);
        }
        if (ret < 0) {
            throw new IOException("bt socket closed, read return: " + ret);
        }
        if (VDBG) {
            Log.d("BluetoothSocket", "read out:  " + this.mSocketIS + " ret: " + ret);
        }
        return ret;
    }

    private final int $$robo$$android_bluetooth_BluetoothSocket$write(byte[] b, int offset, int length) throws IOException {
        if (VDBG) {
            Log.d("BluetoothSocket", "write: " + this.mSocketOS + " length: " + length);
        }
        if (this.mType == 3 || this.mType == 4) {
            if (length <= this.mMaxTxPacketSize) {
                this.mSocketOS.write(b, offset, length);
            } else {
                int tmpLength;
                if (DBG) {
                    Log.w("BluetoothSocket", "WARNING: Write buffer larger than L2CAP packet size!\nPacket will be divided into SDU packets of size " + this.mMaxTxPacketSize);
                }
                int tmpOffset = offset;
                for (int bytesToWrite = length; bytesToWrite > 0; bytesToWrite -= tmpLength) {
                    tmpLength = bytesToWrite > this.mMaxTxPacketSize ? this.mMaxTxPacketSize : bytesToWrite;
                    this.mSocketOS.write(b, tmpOffset, tmpLength);
                    tmpOffset += tmpLength;
                }
            }
        } else {
            this.mSocketOS.write(b, offset, length);
        }
        if (VDBG) {
            Log.d("BluetoothSocket", "write out: " + this.mSocketOS + " length: " + length);
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothSocket$close() throws IOException {
        Log.d("BluetoothSocket", "close() this: " + this + ", channel: " + this.mPort + ", mSocketIS: " + this.mSocketIS + ", mSocketOS: " + this.mSocketOS + "mSocket: " + this.mSocket + ", mSocketState: " + (Object)((Object)this.mSocketState));
        if (this.mSocketState == SocketState.CLOSED) {
            return;
        }
        BluetoothSocket bluetoothSocket = this;
        synchronized (bluetoothSocket) {
            if (this.mSocketState == SocketState.CLOSED) {
                return;
            }
            this.mSocketState = SocketState.CLOSED;
            if (this.mSocket != null) {
                if (DBG) {
                    Log.d("BluetoothSocket", "Closing mSocket: " + this.mSocket);
                }
                this.mSocket.shutdownInput();
                this.mSocket.shutdownOutput();
                this.mSocket.close();
                this.mSocket = null;
            }
            if (this.mPfd != null) {
                this.mPfd.close();
                this.mPfd = null;
            }
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothSocket$removeChannel() {
    }

    private final int $$robo$$android_bluetooth_BluetoothSocket$getPort() {
        return this.mPort;
    }

    private final int $$robo$$android_bluetooth_BluetoothSocket$getMaxTransmitPacketSize() {
        return this.mMaxTxPacketSize;
    }

    private final int $$robo$$android_bluetooth_BluetoothSocket$getMaxReceivePacketSize() {
        return this.mMaxRxPacketSize;
    }

    private final int $$robo$$android_bluetooth_BluetoothSocket$getConnectionType() {
        return this.mType;
    }

    private final void $$robo$$android_bluetooth_BluetoothSocket$setExcludeSdp(boolean excludeSdp) {
        this.mExcludeSdp = excludeSdp;
    }

    private final void $$robo$$android_bluetooth_BluetoothSocket$requestMaximumTxDataLength() throws IOException {
        if (this.mDevice == null) {
            throw new IOException("requestMaximumTxDataLength is called on null device");
        }
        try {
            if (this.mSocketState == SocketState.CLOSED) {
                throw new IOException("socket closed");
            }
            IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService(null);
            if (bluetoothProxy == null) {
                throw new IOException("Bluetooth is off");
            }
            if (DBG) {
                Log.d("BluetoothSocket", "requestMaximumTxDataLength");
            }
            bluetoothProxy.getSocketManager().requestMaximumTxDataLength(this.mDevice);
        }
        catch (RemoteException e) {
            Log.e("BluetoothSocket", Log.getStackTraceString(new Throwable()));
            throw new IOException("unable to send RPC: " + e.getMessage());
        }
    }

    private final String $$robo$$android_bluetooth_BluetoothSocket$convertAddr(byte[] addr) {
        return String.format(Locale.US, "%02X:%02X:%02X:%02X:%02X:%02X", addr[0], addr[1], addr[2], addr[3], addr[4], addr[5]);
    }

    private final String $$robo$$android_bluetooth_BluetoothSocket$waitSocketSignal(InputStream is) throws IOException {
        byte[] sig = new byte[20];
        int ret = this.readAll(is, sig);
        if (VDBG) {
            Log.d("BluetoothSocket", "waitSocketSignal read 20 bytes signal ret: " + ret);
        }
        ByteBuffer bb = ByteBuffer.wrap(sig);
        bb.order(ByteOrder.nativeOrder());
        short size = bb.getShort();
        if (size != 20) {
            throw new IOException("Connection failure, wrong signal size: " + size);
        }
        byte[] addr = new byte[6];
        bb.get(addr);
        int channel = bb.getInt();
        int status = bb.getInt();
        this.mMaxTxPacketSize = bb.getShort() & 0xFFFF;
        this.mMaxRxPacketSize = bb.getShort() & 0xFFFF;
        String RemoteAddr = this.convertAddr(addr);
        if (VDBG) {
            Log.d("BluetoothSocket", "waitSocketSignal: sig size: " + size + ", remote addr: " + RemoteAddr + ", channel: " + channel + ", status: " + status + " MaxRxPktSize: " + this.mMaxRxPacketSize + " MaxTxPktSize: " + this.mMaxTxPacketSize);
        }
        if (status != 0) {
            throw new IOException("Connection failure, status: " + status);
        }
        return RemoteAddr;
    }

    private final void $$robo$$android_bluetooth_BluetoothSocket$createL2capRxBuffer() {
        if (this.mType == 3 || this.mType == 4) {
            if (VDBG) {
                Log.v("BluetoothSocket", "  Creating mL2capBuffer: mMaxPacketSize: " + this.mMaxRxPacketSize);
            }
            this.mL2capBuffer = ByteBuffer.wrap(new byte[this.mMaxRxPacketSize]);
            if (VDBG) {
                Log.v("BluetoothSocket", "mL2capBuffer.remaining()" + this.mL2capBuffer.remaining());
            }
            this.mL2capBuffer.limit(0);
            if (VDBG) {
                Log.v("BluetoothSocket", "mL2capBuffer.remaining() after limit(0):" + this.mL2capBuffer.remaining());
            }
        }
    }

    private final int $$robo$$android_bluetooth_BluetoothSocket$readAll(InputStream is, byte[] b) throws IOException {
        int left = b.length;
        while (left > 0) {
            int ret = is.read(b, b.length - left, left);
            if (ret <= 0) {
                throw new IOException("read failed, socket might closed or timeout, read ret: " + ret);
            }
            if ((left -= ret) == 0) continue;
            Log.w("BluetoothSocket", "readAll() looping, read partial size: " + (b.length - left) + ", expect size: " + b.length);
        }
        return b.length;
    }

    private final int $$robo$$android_bluetooth_BluetoothSocket$readInt(InputStream is) throws IOException {
        byte[] ibytes = new byte[4];
        int ret = this.readAll(is, ibytes);
        if (VDBG) {
            Log.d("BluetoothSocket", "inputStream.read ret: " + ret);
        }
        ByteBuffer bb = ByteBuffer.wrap(ibytes);
        bb.order(ByteOrder.nativeOrder());
        return bb.getInt();
    }

    private final int $$robo$$android_bluetooth_BluetoothSocket$fillL2capRxBuffer() throws IOException {
        this.mL2capBuffer.rewind();
        int ret = this.mSocketIS.read(this.mL2capBuffer.array());
        if (ret == -1) {
            this.mL2capBuffer.limit(0);
            return -1;
        }
        this.mL2capBuffer.limit(ret);
        return ret;
    }

    static void __staticInitializer__() {
        DBG = Log.isLoggable("BluetoothSocket", 3);
        VDBG = Log.isLoggable("BluetoothSocket", 2);
    }

    private void __constructor__(int n, int n2, boolean bl, boolean bl2, BluetoothDevice bluetoothDevice, int n3, ParcelUuid parcelUuid) throws IOException {
        this.$$robo$$android_bluetooth_BluetoothSocket$__constructor__(n, n2, bl, bl2, bluetoothDevice, n3, parcelUuid);
    }

    public BluetoothSocket(int n, int n2, boolean bl, boolean bl2, BluetoothDevice bluetoothDevice, int n3, ParcelUuid parcelUuid) throws IOException {
        this(n, n2, bl, bl2, bluetoothDevice, n3, parcelUuid, false, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothSocket$__constructor__(int int boolean boolean android.bluetooth.BluetoothDevice int android.os.ParcelUuid ), this, n, n2, bl, bl2, bluetoothDevice, n3, parcelUuid);
    }

    private void __constructor__(int n, int n2, boolean bl, boolean bl2, BluetoothDevice bluetoothDevice, int n3, ParcelUuid parcelUuid, boolean bl3, boolean bl4) throws IOException {
        this.$$robo$$android_bluetooth_BluetoothSocket$__constructor__(n, n2, bl, bl2, bluetoothDevice, n3, parcelUuid, bl3, bl4);
    }

    public BluetoothSocket(int n, int n2, boolean bl, boolean bl2, BluetoothDevice bluetoothDevice, int n3, ParcelUuid parcelUuid, boolean bl3, boolean bl4) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothSocket$__constructor__(int int boolean boolean android.bluetooth.BluetoothDevice int android.os.ParcelUuid boolean boolean ), this, n, n2, bl, bl2, bluetoothDevice, n3, parcelUuid, bl3, bl4);
    }

    private void __constructor__(BluetoothSocket bluetoothSocket) {
        this.$$robo$$android_bluetooth_BluetoothSocket$__constructor__(bluetoothSocket);
    }

    public BluetoothSocket(BluetoothSocket bluetoothSocket) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothSocket$__constructor__(android.bluetooth.BluetoothSocket ), this, bluetoothSocket);
    }

    private BluetoothSocket acceptSocket(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("acceptSocket", $$robo$$android_bluetooth_BluetoothSocket$acceptSocket(java.lang.String ), this, string2);
    }

    private void __constructor__(int n, int n2, boolean bl, boolean bl2, String string2, int n3) throws IOException {
        this.$$robo$$android_bluetooth_BluetoothSocket$__constructor__(n, n2, bl, bl2, string2, n3);
    }

    public BluetoothSocket(int n, int n2, boolean bl, boolean bl2, String string2, int n3) throws IOException {
        this(n, n2, bl, bl2, new BluetoothDevice(string2), n3, null, false, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothSocket$__constructor__(int int boolean boolean java.lang.String int ), this, n, n2, bl, bl2, string2, n3);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_bluetooth_BluetoothSocket$finalize(), this);
    }

    private int getSecurityFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getSecurityFlags", $$robo$$android_bluetooth_BluetoothSocket$getSecurityFlags(), this);
    }

    public BluetoothDevice getRemoteDevice() {
        return InvokeDynamicSupport.bootstrap("getRemoteDevice", $$robo$$android_bluetooth_BluetoothSocket$getRemoteDevice(), this);
    }

    public InputStream getInputStream() throws IOException {
        return InvokeDynamicSupport.bootstrap("getInputStream", $$robo$$android_bluetooth_BluetoothSocket$getInputStream(), this);
    }

    public OutputStream getOutputStream() throws IOException {
        return InvokeDynamicSupport.bootstrap("getOutputStream", $$robo$$android_bluetooth_BluetoothSocket$getOutputStream(), this);
    }

    public boolean isConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$android_bluetooth_BluetoothSocket$isConnected(), this);
    }

    void setServiceName(String string2) {
        InvokeDynamicSupport.bootstrap("setServiceName", $$robo$$android_bluetooth_BluetoothSocket$setServiceName(java.lang.String ), this, string2);
    }

    public void connect() throws IOException {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothSocket$connect(), this);
    }

    int bindListen() {
        return (int)InvokeDynamicSupport.bootstrap("bindListen", $$robo$$android_bluetooth_BluetoothSocket$bindListen(), this);
    }

    BluetoothSocket accept(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("accept", $$robo$$android_bluetooth_BluetoothSocket$accept(int ), this, n);
    }

    int available() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("available", $$robo$$android_bluetooth_BluetoothSocket$available(), this);
    }

    void flush() throws IOException {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$android_bluetooth_BluetoothSocket$flush(), this);
    }

    int read(byte[] byArray, int n, int n2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_bluetooth_BluetoothSocket$read(byte[] int int ), this, byArray, n, n2);
    }

    int write(byte[] byArray, int n, int n2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_bluetooth_BluetoothSocket$write(byte[] int int ), this, byArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothSocket$close(), this);
    }

    void removeChannel() {
        InvokeDynamicSupport.bootstrap("removeChannel", $$robo$$android_bluetooth_BluetoothSocket$removeChannel(), this);
    }

    int getPort() {
        return (int)InvokeDynamicSupport.bootstrap("getPort", $$robo$$android_bluetooth_BluetoothSocket$getPort(), this);
    }

    public int getMaxTransmitPacketSize() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxTransmitPacketSize", $$robo$$android_bluetooth_BluetoothSocket$getMaxTransmitPacketSize(), this);
    }

    public int getMaxReceivePacketSize() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxReceivePacketSize", $$robo$$android_bluetooth_BluetoothSocket$getMaxReceivePacketSize(), this);
    }

    public int getConnectionType() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionType", $$robo$$android_bluetooth_BluetoothSocket$getConnectionType(), this);
    }

    public void setExcludeSdp(boolean bl) {
        InvokeDynamicSupport.bootstrap("setExcludeSdp", $$robo$$android_bluetooth_BluetoothSocket$setExcludeSdp(boolean ), this, bl);
    }

    public void requestMaximumTxDataLength() throws IOException {
        InvokeDynamicSupport.bootstrap("requestMaximumTxDataLength", $$robo$$android_bluetooth_BluetoothSocket$requestMaximumTxDataLength(), this);
    }

    private String convertAddr(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("convertAddr", $$robo$$android_bluetooth_BluetoothSocket$convertAddr(byte[] ), this, byArray);
    }

    private String waitSocketSignal(InputStream inputStream) throws IOException {
        return InvokeDynamicSupport.bootstrap("waitSocketSignal", $$robo$$android_bluetooth_BluetoothSocket$waitSocketSignal(java.io.InputStream ), this, inputStream);
    }

    private void createL2capRxBuffer() {
        InvokeDynamicSupport.bootstrap("createL2capRxBuffer", $$robo$$android_bluetooth_BluetoothSocket$createL2capRxBuffer(), this);
    }

    private int readAll(InputStream inputStream, byte[] byArray) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("readAll", $$robo$$android_bluetooth_BluetoothSocket$readAll(java.io.InputStream byte[] ), this, inputStream, byArray);
    }

    private int readInt(InputStream inputStream) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("readInt", $$robo$$android_bluetooth_BluetoothSocket$readInt(java.io.InputStream ), this, inputStream);
    }

    private int fillL2capRxBuffer() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("fillL2capRxBuffer", $$robo$$android_bluetooth_BluetoothSocket$fillL2capRxBuffer(), this);
    }

    static {
        RobolectricInternals.classInitializing(BluetoothSocket.class);
    }

    public /* synthetic */ BluetoothSocket() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothSocket)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SocketState
    extends Enum<SocketState> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ SocketState INIT;
        public static /* enum */ SocketState CONNECTED;
        public static /* enum */ SocketState LISTENING;
        public static /* enum */ SocketState CLOSED;
        private static /* synthetic */ SocketState[] $VALUES;

        private static final SocketState[] $$robo$$android_bluetooth_BluetoothSocket_SocketState$values() {
            return (SocketState[])$VALUES.clone();
        }

        private static final SocketState $$robo$$android_bluetooth_BluetoothSocket_SocketState$valueOf(String name) {
            return Enum.valueOf(SocketState.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_bluetooth_BluetoothSocket_SocketState$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            INIT = new SocketState();
            CONNECTED = new SocketState();
            LISTENING = new SocketState();
            CLOSED = new SocketState();
            $VALUES = new SocketState[]{INIT, CONNECTED, LISTENING, CLOSED};
        }

        public static SocketState[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_bluetooth_BluetoothSocket_SocketState$values());
        }

        public static SocketState valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_bluetooth_BluetoothSocket_SocketState$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_bluetooth_BluetoothSocket_SocketState$__constructor__(string2, n);
        }

        public SocketState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothSocket_SocketState$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(SocketState.class);
        }

        public /* synthetic */ SocketState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SocketState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

