/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothSap;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothSap
implements BluetoothProfile,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothSap";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.sap.profile.action.CONNECTION_STATE_CHANGED";
    private volatile IBluetoothSap mService;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private BluetoothAdapter mAdapter;
    public static int STATE_ERROR = -1;
    public static int RESULT_SUCCESS = 1;
    public static int RESULT_CANCELED = 2;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothSap$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothSap this$0;

            private void $$robo$$android_bluetooth_BluetoothSap_1$__constructor__(BluetoothSap this$0) {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothSap_1$onBluetoothStateChange(boolean up) {
                Log.d("BluetoothSap", "onBluetoothStateChange: up=" + up);
                if (!up) {
                    ServiceConnection serviceConnection = this.this$0.mConnection;
                    synchronized (serviceConnection) {
                        try {
                            this.this$0.mService = null;
                            this.this$0.mContext.unbindService(this.this$0.mConnection);
                        }
                        catch (Exception re) {
                            Log.e("BluetoothSap", "", re);
                        }
                    }
                }
                ServiceConnection serviceConnection = this.this$0.mConnection;
                synchronized (serviceConnection) {
                    try {
                        if (this.this$0.mService == null) {
                            this.this$0.doBind();
                        }
                    }
                    catch (Exception re) {
                        Log.e("BluetoothSap", "", re);
                    }
                }
            }

            private void __constructor__(BluetoothSap bluetoothSap) {
                this.$$robo$$android_bluetooth_BluetoothSap_1$__constructor__(bluetoothSap);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothSap_1$__constructor__(android.bluetooth.BluetoothSap ), this, bluetoothSap);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothSap_1$onBluetoothStateChange(boolean ), this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothSap this$0;

            private void $$robo$$android_bluetooth_BluetoothSap_2$__constructor__(BluetoothSap this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_bluetooth_BluetoothSap_2$onServiceConnected(ComponentName className, IBinder service) {
                BluetoothSap.log("Proxy object connected");
                this.this$0.mService = IBluetoothSap.Stub.asInterface(Binder.allowBlocking(service));
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(10, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothSap_2$onServiceDisconnected(ComponentName className) {
                BluetoothSap.log("Proxy object disconnected");
                this.this$0.mService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(10);
                }
            }

            private void __constructor__(BluetoothSap bluetoothSap) {
                this.$$robo$$android_bluetooth_BluetoothSap_2$__constructor__(bluetoothSap);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothSap_2$__constructor__(android.bluetooth.BluetoothSap ), this, bluetoothSap);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothSap_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothSap_2$onServiceDisconnected(android.content.ComponentName ), this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        Log.d("BluetoothSap", "Create BluetoothSap proxy object");
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothSap", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothSap$doBind() {
        Intent intent = new Intent(IBluetoothSap.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, this.mContext.getUser())) {
            Log.e("BluetoothSap", "Could not bind to Bluetooth SAP Service with " + intent);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothSap$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void $$robo$$android_bluetooth_BluetoothSap$close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothSap", "", e);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e("BluetoothSap", "", re);
                }
            }
        }
        this.mServiceListener = null;
    }

    private final int $$robo$$android_bluetooth_BluetoothSap$getState() {
        IBluetoothSap service = this.mService;
        if (service != null) {
            try {
                return service.getState();
            }
            catch (RemoteException e) {
                Log.e("BluetoothSap", e.toString());
            }
        } else {
            Log.w("BluetoothSap", "Proxy not attached to service");
            BluetoothSap.log(Log.getStackTraceString(new Throwable()));
        }
        return -1;
    }

    private final BluetoothDevice $$robo$$android_bluetooth_BluetoothSap$getClient() {
        IBluetoothSap service = this.mService;
        if (service != null) {
            try {
                return service.getClient();
            }
            catch (RemoteException e) {
                Log.e("BluetoothSap", e.toString());
            }
        } else {
            Log.w("BluetoothSap", "Proxy not attached to service");
            BluetoothSap.log(Log.getStackTraceString(new Throwable()));
        }
        return null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothSap$isConnected(BluetoothDevice device) {
        IBluetoothSap service = this.mService;
        if (service != null) {
            try {
                return service.isConnected(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothSap", e.toString());
            }
        } else {
            Log.w("BluetoothSap", "Proxy not attached to service");
            BluetoothSap.log(Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothSap$connect(BluetoothDevice device) {
        BluetoothSap.log("connect(" + device + ")not supported for SAPS");
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothSap$disconnect(BluetoothDevice device) {
        BluetoothSap.log("disconnect(" + device + ")");
        IBluetoothSap service = this.mService;
        if (service != null && this.isEnabled() && BluetoothSap.isValidDevice(device)) {
            try {
                return service.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothSap", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothSap", "Proxy not attached to service");
        }
        return false;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothSap$getConnectedDevices() {
        BluetoothSap.log("getConnectedDevices()");
        IBluetoothSap service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e("BluetoothSap", Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothSap", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothSap$getDevicesMatchingConnectionStates(int[] states) {
        BluetoothSap.log("getDevicesMatchingStates()");
        IBluetoothSap service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e("BluetoothSap", Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothSap", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final int $$robo$$android_bluetooth_BluetoothSap$getConnectionState(BluetoothDevice device) {
        BluetoothSap.log("getConnectionState(" + device + ")");
        IBluetoothSap service = this.mService;
        if (service != null && this.isEnabled() && BluetoothSap.isValidDevice(device)) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothSap", Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w("BluetoothSap", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothSap$setPriority(BluetoothDevice device, int priority) {
        BluetoothSap.log("setPriority(" + device + ", " + priority + ")");
        IBluetoothSap service = this.mService;
        if (service != null && this.isEnabled() && BluetoothSap.isValidDevice(device)) {
            if (priority != 0 && priority != 100) {
                return false;
            }
            try {
                return service.setPriority(device, priority);
            }
            catch (RemoteException e) {
                Log.e("BluetoothSap", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothSap", "Proxy not attached to service");
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothSap$getPriority(BluetoothDevice device) {
        IBluetoothSap service = this.mService;
        if (service != null && this.isEnabled() && BluetoothSap.isValidDevice(device)) {
            try {
                return service.getPriority(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothSap", Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w("BluetoothSap", "Proxy not attached to service");
        }
        return 0;
    }

    private static final void $$robo$$android_bluetooth_BluetoothSap$log(String msg) {
        Log.d("BluetoothSap", msg);
    }

    private final boolean $$robo$$android_bluetooth_BluetoothSap$isEnabled() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && adapter.getState() == 12) {
            return true;
        }
        BluetoothSap.log("Bluetooth is Not enabled");
        return false;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothSap$isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothSap$__constructor__(context, serviceListener);
    }

    public BluetoothSap(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothSap$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothSap$doBind(), this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_bluetooth_BluetoothSap$finalize(), this);
    }

    public synchronized void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothSap$close(), this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_bluetooth_BluetoothSap$getState(), this);
    }

    public BluetoothDevice getClient() {
        return InvokeDynamicSupport.bootstrap("getClient", $$robo$$android_bluetooth_BluetoothSap$getClient(), this);
    }

    public boolean isConnected(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$android_bluetooth_BluetoothSap$isConnected(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothSap$connect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothSap$disconnect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothSap$getConnectedDevices(), this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothSap$getDevicesMatchingConnectionStates(int[] ), this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothSap$getConnectionState(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_bluetooth_BluetoothSap$setPriority(android.bluetooth.BluetoothDevice int ), this, bluetoothDevice, n);
    }

    public int getPriority(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_bluetooth_BluetoothSap$getPriority(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothSap$log(java.lang.String ), (String)string2);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothSap$isEnabled(), this);
    }

    private static boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidDevice", $$robo$$android_bluetooth_BluetoothSap$isValidDevice(android.bluetooth.BluetoothDevice ), (BluetoothDevice)bluetoothDevice);
    }

    public /* synthetic */ BluetoothSap() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothSap)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

