/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothPbapClient;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothPbapClient
implements BluetoothProfile,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothPbapClient";
    private static boolean DBG = false;
    private static boolean VDBG = false;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.pbapclient.profile.action.CONNECTION_STATE_CHANGED";
    private volatile IBluetoothPbapClient mService;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private BluetoothAdapter mAdapter;
    public static int STATE_ERROR = -1;
    public static int RESULT_FAILURE = 0;
    public static int RESULT_SUCCESS = 1;
    public static int RESULT_CANCELED = 2;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothPbapClient$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothPbapClient this$0;

            private void $$robo$$android_bluetooth_BluetoothPbapClient_1$__constructor__(BluetoothPbapClient this$0) {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothPbapClient_1$onBluetoothStateChange(boolean up) {
                if (!up) {
                    ServiceConnection serviceConnection = this.this$0.mConnection;
                    synchronized (serviceConnection) {
                        try {
                            this.this$0.mService = null;
                            this.this$0.mContext.unbindService(this.this$0.mConnection);
                        }
                        catch (Exception re) {
                            Log.e("BluetoothPbapClient", "", re);
                        }
                    }
                }
                ServiceConnection serviceConnection = this.this$0.mConnection;
                synchronized (serviceConnection) {
                    try {
                        if (this.this$0.mService == null) {
                            this.this$0.doBind();
                        }
                    }
                    catch (Exception re) {
                        Log.e("BluetoothPbapClient", "", re);
                    }
                }
            }

            private void __constructor__(BluetoothPbapClient bluetoothPbapClient) {
                this.$$robo$$android_bluetooth_BluetoothPbapClient_1$__constructor__(bluetoothPbapClient);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothPbapClient_1$__constructor__(android.bluetooth.BluetoothPbapClient ), this, bluetoothPbapClient);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothPbapClient_1$onBluetoothStateChange(boolean ), this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothPbapClient this$0;

            private void $$robo$$android_bluetooth_BluetoothPbapClient_2$__constructor__(BluetoothPbapClient this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_bluetooth_BluetoothPbapClient_2$onServiceConnected(ComponentName className, IBinder service) {
                this.this$0.mService = IBluetoothPbapClient.Stub.asInterface(Binder.allowBlocking(service));
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(17, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothPbapClient_2$onServiceDisconnected(ComponentName className) {
                this.this$0.mService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(17);
                }
            }

            private void __constructor__(BluetoothPbapClient bluetoothPbapClient) {
                this.$$robo$$android_bluetooth_BluetoothPbapClient_2$__constructor__(bluetoothPbapClient);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothPbapClient_2$__constructor__(android.bluetooth.BluetoothPbapClient ), this, bluetoothPbapClient);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothPbapClient_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothPbapClient_2$onServiceDisconnected(android.content.ComponentName ), this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbapClient", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPbapClient$doBind() {
        Intent intent = new Intent(IBluetoothPbapClient.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, this.mContext.getUser())) {
            Log.e("BluetoothPbapClient", "Could not bind to Bluetooth PBAP Client Service with " + intent);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothPbapClient$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void $$robo$$android_bluetooth_BluetoothPbapClient$close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothPbapClient", "", e);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e("BluetoothPbapClient", "", re);
                }
            }
        }
        this.mServiceListener = null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPbapClient$connect(BluetoothDevice device) {
        IBluetoothPbapClient service = this.mService;
        if (service != null && this.isEnabled() && BluetoothPbapClient.isValidDevice(device)) {
            try {
                return service.connect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbapClient", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothPbapClient", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPbapClient$disconnect(BluetoothDevice device) {
        IBluetoothPbapClient service = this.mService;
        if (service != null && this.isEnabled() && BluetoothPbapClient.isValidDevice(device)) {
            try {
                service.disconnect(device);
                return true;
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbapClient", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothPbapClient", "Proxy not attached to service");
        }
        return false;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothPbapClient$getConnectedDevices() {
        IBluetoothPbapClient service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbapClient", Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothPbapClient", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothPbapClient$getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothPbapClient service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbapClient", Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothPbapClient", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final int $$robo$$android_bluetooth_BluetoothPbapClient$getConnectionState(BluetoothDevice device) {
        IBluetoothPbapClient service = this.mService;
        if (service != null && this.isEnabled() && BluetoothPbapClient.isValidDevice(device)) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbapClient", Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w("BluetoothPbapClient", "Proxy not attached to service");
        }
        return 0;
    }

    private static final void $$robo$$android_bluetooth_BluetoothPbapClient$log(String msg) {
        Log.d("BluetoothPbapClient", msg);
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPbapClient$isEnabled() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && adapter.getState() == 12) {
            return true;
        }
        BluetoothPbapClient.log("Bluetooth is Not enabled");
        return false;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothPbapClient$isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPbapClient$setPriority(BluetoothDevice device, int priority) {
        IBluetoothPbapClient service = this.mService;
        if (service != null && this.isEnabled() && BluetoothPbapClient.isValidDevice(device)) {
            if (priority != 0 && priority != 100) {
                return false;
            }
            try {
                return service.setPriority(device, priority);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbapClient", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothPbapClient", "Proxy not attached to service");
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothPbapClient$getPriority(BluetoothDevice device) {
        IBluetoothPbapClient service = this.mService;
        if (service != null && this.isEnabled() && BluetoothPbapClient.isValidDevice(device)) {
            try {
                return service.getPriority(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbapClient", Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w("BluetoothPbapClient", "Proxy not attached to service");
        }
        return 0;
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothPbapClient$__constructor__(context, serviceListener);
    }

    public BluetoothPbapClient(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothPbapClient$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), this, context, serviceListener);
    }

    private boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothPbapClient$doBind(), this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_bluetooth_BluetoothPbapClient$finalize(), this);
    }

    public synchronized void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothPbapClient$close(), this);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothPbapClient$connect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothPbapClient$disconnect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothPbapClient$getConnectedDevices(), this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothPbapClient$getDevicesMatchingConnectionStates(int[] ), this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothPbapClient$getConnectionState(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothPbapClient$log(java.lang.String ), (String)string2);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothPbapClient$isEnabled(), this);
    }

    private static boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidDevice", $$robo$$android_bluetooth_BluetoothPbapClient$isValidDevice(android.bluetooth.BluetoothDevice ), (BluetoothDevice)bluetoothDevice);
    }

    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_bluetooth_BluetoothPbapClient$setPriority(android.bluetooth.BluetoothDevice int ), this, bluetoothDevice, n);
    }

    public int getPriority(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_bluetooth_BluetoothPbapClient$getPriority(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public /* synthetic */ BluetoothPbapClient() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothPbapClient)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

