/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHidDeviceAppQosSettings;
import android.bluetooth.BluetoothHidDeviceAppSdpSettings;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHidDevice;
import android.bluetooth.IBluetoothHidDeviceCallback;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothHidDevice
implements BluetoothProfile,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.hiddevice.profile.action.CONNECTION_STATE_CHANGED";
    public static byte SUBCLASS1_NONE = 0;
    public static byte SUBCLASS1_KEYBOARD = 64;
    public static byte SUBCLASS1_MOUSE = -128;
    public static byte SUBCLASS1_COMBO = -64;
    public static byte SUBCLASS2_UNCATEGORIZED = 0;
    public static byte SUBCLASS2_JOYSTICK = 1;
    public static byte SUBCLASS2_GAMEPAD = 2;
    public static byte SUBCLASS2_REMOTE_CONTROL = 3;
    public static byte SUBCLASS2_SENSING_DEVICE = 4;
    public static byte SUBCLASS2_DIGITIZER_TABLET = 5;
    public static byte SUBCLASS2_CARD_READER = 6;
    public static byte REPORT_TYPE_INPUT = 1;
    public static byte REPORT_TYPE_OUTPUT = 2;
    public static byte REPORT_TYPE_FEATURE = 3;
    public static byte ERROR_RSP_SUCCESS = 0;
    public static byte ERROR_RSP_NOT_READY = 1;
    public static byte ERROR_RSP_INVALID_RPT_ID = 2;
    public static byte ERROR_RSP_UNSUPPORTED_REQ = 3;
    public static byte ERROR_RSP_INVALID_PARAM = 4;
    public static byte ERROR_RSP_UNKNOWN = 14;
    public static byte PROTOCOL_BOOT_MODE = 0;
    public static byte PROTOCOL_REPORT_MODE = 1;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private volatile IBluetoothHidDevice mService;
    private BluetoothAdapter mAdapter;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothHidDevice$__constructor__(Context context, BluetoothProfile.ServiceListener listener) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHidDevice this$0;

            private void $$robo$$android_bluetooth_BluetoothHidDevice_1$__constructor__(BluetoothHidDevice this$0) {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothHidDevice_1$onBluetoothStateChange(boolean up) {
                Log.d(TAG, "onBluetoothStateChange: up=" + up);
                ServiceConnection serviceConnection = this.this$0.mConnection;
                synchronized (serviceConnection) {
                    if (up) {
                        try {
                            if (this.this$0.mService == null) {
                                Log.d(TAG, "Binding HID Device service...");
                                this.this$0.doBind();
                            }
                        }
                        catch (IllegalStateException e) {
                            Log.e(TAG, "onBluetoothStateChange: could not bind to HID Dev service: ", e);
                        }
                        catch (SecurityException e) {
                            Log.e(TAG, "onBluetoothStateChange: could not bind to HID Dev service: ", e);
                        }
                    } else {
                        Log.d(TAG, "Unbinding service...");
                        this.this$0.doUnbind();
                    }
                }
            }

            private void __constructor__(BluetoothHidDevice bluetoothHidDevice) {
                this.$$robo$$android_bluetooth_BluetoothHidDevice_1$__constructor__(bluetoothHidDevice);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHidDevice_1$__constructor__(android.bluetooth.BluetoothHidDevice ), this, bluetoothHidDevice);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothHidDevice_1$onBluetoothStateChange(boolean ), this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHidDevice this$0;

            private void $$robo$$android_bluetooth_BluetoothHidDevice_2$__constructor__(BluetoothHidDevice this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_bluetooth_BluetoothHidDevice_2$onServiceConnected(ComponentName className, IBinder service) {
                Log.d(TAG, "onServiceConnected()");
                this.this$0.mService = IBluetoothHidDevice.Stub.asInterface(service);
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(19, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothHidDevice_2$onServiceDisconnected(ComponentName className) {
                Log.d(TAG, "onServiceDisconnected()");
                this.this$0.mService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(19);
                }
            }

            private void __constructor__(BluetoothHidDevice bluetoothHidDevice) {
                this.$$robo$$android_bluetooth_BluetoothHidDevice_2$__constructor__(bluetoothHidDevice);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHidDevice_2$__constructor__(android.bluetooth.BluetoothHidDevice ), this, bluetoothHidDevice);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothHidDevice_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothHidDevice_2$onServiceDisconnected(android.content.ComponentName ), this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = listener;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidDevice$doBind() {
        Intent intent = new Intent(IBluetoothHidDevice.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, this.mContext.getUser())) {
            Log.e(TAG, "Could not bind to Bluetooth HID Device Service with " + intent);
            return false;
        }
        Log.d(TAG, "Bound to HID Device Service");
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothHidDevice$doUnbind() {
        if (this.mService != null) {
            this.mService = null;
            try {
                this.mContext.unbindService(this.mConnection);
            }
            catch (IllegalArgumentException e) {
                Log.e(TAG, "Unable to unbind HidDevService", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothHidDevice$close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            this.doUnbind();
        }
        this.mServiceListener = null;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHidDevice$getConnectedDevices() {
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHidDevice$getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final int $$robo$$android_bluetooth_BluetoothHidDevice$getConnectionState(BluetoothDevice device) {
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidDevice$registerApp(BluetoothHidDeviceAppSdpSettings sdp, BluetoothHidDeviceAppQosSettings inQos, BluetoothHidDeviceAppQosSettings outQos, Executor executor, Callback callback) {
        boolean result = false;
        if (sdp == null) {
            throw new IllegalArgumentException("sdp parameter cannot be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor parameter cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback parameter cannot be null");
        }
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                CallbackWrapper cbw = new CallbackWrapper(executor, callback);
                result = service.registerApp(sdp, inQos, outQos, cbw);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidDevice$unregisterApp() {
        boolean result = false;
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                result = service.unregisterApp();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidDevice$sendReport(BluetoothDevice device, int id2, byte[] data) {
        boolean result = false;
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                result = service.sendReport(device, id2, data);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidDevice$replyReport(BluetoothDevice device, byte type, byte id2, byte[] data) {
        boolean result = false;
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                result = service.replyReport(device, type, id2, data);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidDevice$reportError(BluetoothDevice device, byte error) {
        boolean result = false;
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                result = service.reportError(device, error);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private final String $$robo$$android_bluetooth_BluetoothHidDevice$getUserAppName() {
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                return service.getUserAppName();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return "";
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidDevice$connect(BluetoothDevice device) {
        boolean result = false;
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                result = service.connect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidDevice$disconnect(BluetoothDevice device) {
        boolean result = false;
        IBluetoothHidDevice service = this.mService;
        if (service != null) {
            try {
                result = service.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    static void __staticInitializer__() {
        TAG = BluetoothHidDevice.class.getSimpleName();
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothHidDevice$__constructor__(context, serviceListener);
    }

    public BluetoothHidDevice(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHidDevice$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothHidDevice$doBind(), this);
    }

    void doUnbind() {
        InvokeDynamicSupport.bootstrap("doUnbind", $$robo$$android_bluetooth_BluetoothHidDevice$doUnbind(), this);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothHidDevice$close(), this);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothHidDevice$getConnectedDevices(), this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothHidDevice$getDevicesMatchingConnectionStates(int[] ), this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothHidDevice$getConnectionState(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean registerApp(BluetoothHidDeviceAppSdpSettings bluetoothHidDeviceAppSdpSettings, BluetoothHidDeviceAppQosSettings bluetoothHidDeviceAppQosSettings, BluetoothHidDeviceAppQosSettings bluetoothHidDeviceAppQosSettings2, Executor executor, Callback callback) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerApp", $$robo$$android_bluetooth_BluetoothHidDevice$registerApp(android.bluetooth.BluetoothHidDeviceAppSdpSettings android.bluetooth.BluetoothHidDeviceAppQosSettings android.bluetooth.BluetoothHidDeviceAppQosSettings java.util.concurrent.Executor android.bluetooth.BluetoothHidDevice$Callback ), this, bluetoothHidDeviceAppSdpSettings, bluetoothHidDeviceAppQosSettings, bluetoothHidDeviceAppQosSettings2, executor, callback);
    }

    public boolean unregisterApp() {
        return (boolean)InvokeDynamicSupport.bootstrap("unregisterApp", $$robo$$android_bluetooth_BluetoothHidDevice$unregisterApp(), this);
    }

    public boolean sendReport(BluetoothDevice bluetoothDevice, int n, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendReport", $$robo$$android_bluetooth_BluetoothHidDevice$sendReport(android.bluetooth.BluetoothDevice int byte[] ), this, bluetoothDevice, n, byArray);
    }

    public boolean replyReport(BluetoothDevice bluetoothDevice, byte by, byte by2, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("replyReport", $$robo$$android_bluetooth_BluetoothHidDevice$replyReport(android.bluetooth.BluetoothDevice byte byte byte[] ), this, bluetoothDevice, by, by2, byArray);
    }

    public boolean reportError(BluetoothDevice bluetoothDevice, byte by) {
        return (boolean)InvokeDynamicSupport.bootstrap("reportError", $$robo$$android_bluetooth_BluetoothHidDevice$reportError(android.bluetooth.BluetoothDevice byte ), this, bluetoothDevice, by);
    }

    public String getUserAppName() {
        return InvokeDynamicSupport.bootstrap("getUserAppName", $$robo$$android_bluetooth_BluetoothHidDevice$getUserAppName(), this);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothHidDevice$connect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothHidDevice$disconnect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    static {
        RobolectricInternals.classInitializing(BluetoothHidDevice.class);
    }

    public /* synthetic */ BluetoothHidDevice() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothHidDevice)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CallbackWrapper
    extends IBluetoothHidDeviceCallback.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Executor mExecutor;
        private Callback mCallback;

        private void $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$__constructor__(Executor executor, Callback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onAppStatusChanged(BluetoothDevice pluggedDevice, boolean registered) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onAppStatusChanged(pluggedDevice, registered));
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onConnectionStateChanged(BluetoothDevice device, int state) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onConnectionStateChanged(device, state));
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onGetReport(BluetoothDevice device, byte type, byte id2, int bufferSize) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onGetReport(device, type, id2, bufferSize));
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onSetReport(BluetoothDevice device, byte type, byte id2, byte[] data) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onSetReport(device, type, id2, data));
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onSetProtocol(BluetoothDevice device, byte protocol) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onSetProtocol(device, protocol));
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onInterruptData(BluetoothDevice device, byte reportId, byte[] data) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onInterruptData(device, reportId, data));
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onVirtualCableUnplug(BluetoothDevice device) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onVirtualCableUnplug(device));
        }

        private void __constructor__(Executor executor, Callback callback) {
            this.$$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$__constructor__(executor, callback);
        }

        public CallbackWrapper(Executor executor, Callback callback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$__constructor__(java.util.concurrent.Executor android.bluetooth.BluetoothHidDevice$Callback ), this, executor, callback);
        }

        @Override
        public void onAppStatusChanged(BluetoothDevice bluetoothDevice, boolean bl) {
            InvokeDynamicSupport.bootstrap("onAppStatusChanged", $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onAppStatusChanged(android.bluetooth.BluetoothDevice boolean ), this, bluetoothDevice, bl);
        }

        @Override
        public void onConnectionStateChanged(BluetoothDevice bluetoothDevice, int n) {
            InvokeDynamicSupport.bootstrap("onConnectionStateChanged", $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onConnectionStateChanged(android.bluetooth.BluetoothDevice int ), this, bluetoothDevice, n);
        }

        @Override
        public void onGetReport(BluetoothDevice bluetoothDevice, byte by, byte by2, int n) {
            InvokeDynamicSupport.bootstrap("onGetReport", $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onGetReport(android.bluetooth.BluetoothDevice byte byte int ), this, bluetoothDevice, by, by2, n);
        }

        @Override
        public void onSetReport(BluetoothDevice bluetoothDevice, byte by, byte by2, byte[] byArray) {
            InvokeDynamicSupport.bootstrap("onSetReport", $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onSetReport(android.bluetooth.BluetoothDevice byte byte byte[] ), this, bluetoothDevice, by, by2, byArray);
        }

        @Override
        public void onSetProtocol(BluetoothDevice bluetoothDevice, byte by) {
            InvokeDynamicSupport.bootstrap("onSetProtocol", $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onSetProtocol(android.bluetooth.BluetoothDevice byte ), this, bluetoothDevice, by);
        }

        @Override
        public void onInterruptData(BluetoothDevice bluetoothDevice, byte by, byte[] byArray) {
            InvokeDynamicSupport.bootstrap("onInterruptData", $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onInterruptData(android.bluetooth.BluetoothDevice byte byte[] ), this, bluetoothDevice, by, byArray);
        }

        @Override
        public void onVirtualCableUnplug(BluetoothDevice bluetoothDevice) {
            InvokeDynamicSupport.bootstrap("onVirtualCableUnplug", $$robo$$android_bluetooth_BluetoothHidDevice_CallbackWrapper$onVirtualCableUnplug(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
        }

        public /* synthetic */ CallbackWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String TAG = "BluetoothHidDevCallback";

        private void $$robo$$android_bluetooth_BluetoothHidDevice_Callback$__constructor__() {
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onAppStatusChanged(BluetoothDevice pluggedDevice, boolean registered) {
            Log.d("BluetoothHidDevCallback", "onAppStatusChanged: pluggedDevice=" + pluggedDevice + " registered=" + registered);
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onConnectionStateChanged(BluetoothDevice device, int state) {
            Log.d("BluetoothHidDevCallback", "onConnectionStateChanged: device=" + device + " state=" + state);
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onGetReport(BluetoothDevice device, byte type, byte id2, int bufferSize) {
            Log.d("BluetoothHidDevCallback", "onGetReport: device=" + device + " type=" + type + " id=" + id2 + " bufferSize=" + bufferSize);
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onSetReport(BluetoothDevice device, byte type, byte id2, byte[] data) {
            Log.d("BluetoothHidDevCallback", "onSetReport: device=" + device + " type=" + type + " id=" + id2);
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onSetProtocol(BluetoothDevice device, byte protocol) {
            Log.d("BluetoothHidDevCallback", "onSetProtocol: device=" + device + " protocol=" + protocol);
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onInterruptData(BluetoothDevice device, byte reportId, byte[] data) {
            Log.d("BluetoothHidDevCallback", "onInterruptData: device=" + device + " reportId=" + reportId);
        }

        private final void $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onVirtualCableUnplug(BluetoothDevice device) {
            Log.d("BluetoothHidDevCallback", "onVirtualCableUnplug: device=" + device);
        }

        private void __constructor__() {
            this.$$robo$$android_bluetooth_BluetoothHidDevice_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHidDevice_Callback$__constructor__(), this);
        }

        public void onAppStatusChanged(BluetoothDevice bluetoothDevice, boolean bl) {
            InvokeDynamicSupport.bootstrap("onAppStatusChanged", $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onAppStatusChanged(android.bluetooth.BluetoothDevice boolean ), this, bluetoothDevice, bl);
        }

        public void onConnectionStateChanged(BluetoothDevice bluetoothDevice, int n) {
            InvokeDynamicSupport.bootstrap("onConnectionStateChanged", $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onConnectionStateChanged(android.bluetooth.BluetoothDevice int ), this, bluetoothDevice, n);
        }

        public void onGetReport(BluetoothDevice bluetoothDevice, byte by, byte by2, int n) {
            InvokeDynamicSupport.bootstrap("onGetReport", $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onGetReport(android.bluetooth.BluetoothDevice byte byte int ), this, bluetoothDevice, by, by2, n);
        }

        public void onSetReport(BluetoothDevice bluetoothDevice, byte by, byte by2, byte[] byArray) {
            InvokeDynamicSupport.bootstrap("onSetReport", $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onSetReport(android.bluetooth.BluetoothDevice byte byte byte[] ), this, bluetoothDevice, by, by2, byArray);
        }

        public void onSetProtocol(BluetoothDevice bluetoothDevice, byte by) {
            InvokeDynamicSupport.bootstrap("onSetProtocol", $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onSetProtocol(android.bluetooth.BluetoothDevice byte ), this, bluetoothDevice, by);
        }

        public void onInterruptData(BluetoothDevice bluetoothDevice, byte by, byte[] byArray) {
            InvokeDynamicSupport.bootstrap("onInterruptData", $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onInterruptData(android.bluetooth.BluetoothDevice byte byte[] ), this, bluetoothDevice, by, byArray);
        }

        public void onVirtualCableUnplug(BluetoothDevice bluetoothDevice) {
            InvokeDynamicSupport.bootstrap("onVirtualCableUnplug", $$robo$$android_bluetooth_BluetoothHidDevice_Callback$onVirtualCableUnplug(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

