/*
 * Decompiled with CFR 0.152.
 */
package android.app.slice;

import android.app.PendingIntent;
import android.app.RemoteInput;
import android.app.slice.SliceItem;
import android.app.slice.SliceSpec;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Slice
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String HINT_TITLE = "title";
    public static String HINT_LIST = "list";
    public static String HINT_LIST_ITEM = "list_item";
    public static String HINT_LARGE = "large";
    public static String HINT_ACTIONS = "actions";
    public static String HINT_SELECTED = "selected";
    public static String HINT_NO_TINT = "no_tint";
    public static String HINT_SHORTCUT = "shortcut";
    public static String HINT_SUMMARY = "summary";
    public static String HINT_TOGGLE = "toggle";
    public static String HINT_HORIZONTAL = "horizontal";
    public static String HINT_PARTIAL = "partial";
    public static String HINT_SEE_MORE = "see_more";
    public static String HINT_CALLER_NEEDED = "caller_needed";
    public static String HINT_KEYWORDS = "keywords";
    public static String HINT_ERROR = "error";
    public static String HINT_TTL = "ttl";
    public static String HINT_LAST_UPDATED = "last_updated";
    public static String HINT_PERMISSION_REQUEST = "permission_request";
    public static String SUBTYPE_LAYOUT_DIRECTION = "layout_direction";
    public static String EXTRA_TOGGLE_STATE = "android.app.slice.extra.TOGGLE_STATE";
    @Deprecated
    public static String EXTRA_SLIDER_VALUE = "android.app.slice.extra.SLIDER_VALUE";
    public static String EXTRA_RANGE_VALUE = "android.app.slice.extra.RANGE_VALUE";
    public static String SUBTYPE_MESSAGE = "message";
    public static String SUBTYPE_SOURCE = "source";
    public static String SUBTYPE_COLOR = "color";
    @Deprecated
    public static String SUBTYPE_SLIDER = "slider";
    public static String SUBTYPE_RANGE = "range";
    public static String SUBTYPE_MAX = "max";
    public static String SUBTYPE_VALUE = "value";
    public static String SUBTYPE_TOGGLE = "toggle";
    public static String SUBTYPE_PRIORITY = "priority";
    public static String SUBTYPE_CONTENT_DESCRIPTION = "content_description";
    public static String SUBTYPE_MILLIS = "millis";
    private SliceItem[] mItems;
    private String[] mHints;
    private SliceSpec mSpec;
    private Uri mUri;
    public static Parcelable.Creator<Slice> CREATOR;

    private void $$robo$$android_app_slice_Slice$__constructor__(ArrayList<SliceItem> items, String[] hints, Uri uri, SliceSpec spec) {
        this.mHints = hints;
        this.mItems = items.toArray(new SliceItem[items.size()]);
        this.mUri = uri;
        this.mSpec = spec;
    }

    private void $$robo$$android_app_slice_Slice$__constructor__(Parcel in) {
        this.mHints = in.readStringArray();
        int n = in.readInt();
        this.mItems = new SliceItem[n];
        for (int i = 0; i < n; ++i) {
            this.mItems[i] = SliceItem.CREATOR.createFromParcel(in);
        }
        this.mUri = Uri.CREATOR.createFromParcel(in);
        this.mSpec = in.readTypedObject(SliceSpec.CREATOR);
    }

    private final SliceSpec $$robo$$android_app_slice_Slice$getSpec() {
        return this.mSpec;
    }

    private final Uri $$robo$$android_app_slice_Slice$getUri() {
        return this.mUri;
    }

    private final List<SliceItem> $$robo$$android_app_slice_Slice$getItems() {
        return Arrays.asList(this.mItems);
    }

    private final List<String> $$robo$$android_app_slice_Slice$getHints() {
        return Arrays.asList(this.mHints);
    }

    private final void $$robo$$android_app_slice_Slice$writeToParcel(Parcel dest, int flags) {
        dest.writeStringArray(this.mHints);
        dest.writeInt(this.mItems.length);
        for (int i = 0; i < this.mItems.length; ++i) {
            this.mItems[i].writeToParcel(dest, flags);
        }
        this.mUri.writeToParcel(dest, 0);
        dest.writeTypedObject(this.mSpec, flags);
    }

    private final int $$robo$$android_app_slice_Slice$describeContents() {
        return 0;
    }

    private final boolean $$robo$$android_app_slice_Slice$hasHint(String hint) {
        return ArrayUtils.contains(this.mHints, hint);
    }

    private final boolean $$robo$$android_app_slice_Slice$isCallerNeeded() {
        return this.hasHint("caller_needed");
    }

    private final String $$robo$$android_app_slice_Slice$toString() {
        return this.toString("");
    }

    private final String $$robo$$android_app_slice_Slice$toString(String indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mItems.length; ++i) {
            sb.append(indent);
            if (Objects.equals(this.mItems[i].getFormat(), "slice")) {
                sb.append("slice:\n");
                sb.append(this.mItems[i].getSlice().toString(indent + "   "));
                continue;
            }
            if (Objects.equals(this.mItems[i].getFormat(), "text")) {
                sb.append("text: ");
                sb.append(this.mItems[i].getText());
                sb.append("\n");
                continue;
            }
            sb.append(this.mItems[i].getFormat());
            sb.append("\n");
        }
        return sb.toString();
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<Slice>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_slice_Slice_1$__constructor__() {
            }

            private final Slice $$robo$$android_app_slice_Slice_1$createFromParcel(Parcel in) {
                return new Slice(in);
            }

            private final Slice[] $$robo$$android_app_slice_Slice_1$newArray(int size) {
                return new Slice[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_slice_Slice_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_slice_Slice_1$__constructor__(), this);
            }

            @Override
            public Slice createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_slice_Slice_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public Slice[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_slice_Slice_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(ArrayList<SliceItem> arrayList, String[] stringArray, Uri uri, SliceSpec sliceSpec) {
        this.$$robo$$android_app_slice_Slice$__constructor__(arrayList, stringArray, uri, sliceSpec);
    }

    public Slice(ArrayList<SliceItem> arrayList, String[] stringArray, Uri uri, SliceSpec sliceSpec) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_slice_Slice$__constructor__(java.util.ArrayList<android.app.slice.SliceItem> java.lang.String[] android.net.Uri android.app.slice.SliceSpec ), this, arrayList, stringArray, uri, sliceSpec);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_app_slice_Slice$__constructor__(parcel);
    }

    public Slice(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_slice_Slice$__constructor__(android.os.Parcel ), this, parcel);
    }

    public SliceSpec getSpec() {
        return InvokeDynamicSupport.bootstrap("getSpec", $$robo$$android_app_slice_Slice$getSpec(), this);
    }

    public Uri getUri() {
        return InvokeDynamicSupport.bootstrap("getUri", $$robo$$android_app_slice_Slice$getUri(), this);
    }

    public List<SliceItem> getItems() {
        return InvokeDynamicSupport.bootstrap("getItems", $$robo$$android_app_slice_Slice$getItems(), this);
    }

    public List<String> getHints() {
        return InvokeDynamicSupport.bootstrap("getHints", $$robo$$android_app_slice_Slice$getHints(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_slice_Slice$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_slice_Slice$describeContents(), this);
    }

    public boolean hasHint(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasHint", $$robo$$android_app_slice_Slice$hasHint(java.lang.String ), this, string2);
    }

    public boolean isCallerNeeded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCallerNeeded", $$robo$$android_app_slice_Slice$isCallerNeeded(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_slice_Slice$toString(), this);
    }

    private String toString(String string2) {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_slice_Slice$toString(java.lang.String ), this, string2);
    }

    static {
        RobolectricInternals.classInitializing(Slice.class);
    }

    public /* synthetic */ Slice() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Slice)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Uri mUri;
        private ArrayList<SliceItem> mItems;
        private ArrayList<String> mHints;
        private SliceSpec mSpec;

        @Deprecated
        private void $$robo$$android_app_slice_Slice_Builder$__constructor__(Uri uri) {
            this.mItems = new ArrayList();
            this.mHints = new ArrayList();
            this.mUri = uri;
        }

        private void $$robo$$android_app_slice_Slice_Builder$__constructor__(Uri uri, SliceSpec spec) {
            this.mItems = new ArrayList();
            this.mHints = new ArrayList();
            this.mUri = uri;
            this.mSpec = spec;
        }

        private void $$robo$$android_app_slice_Slice_Builder$__constructor__(Builder parent) {
            this.mItems = new ArrayList();
            this.mHints = new ArrayList();
            this.mUri = parent.mUri.buildUpon().appendPath("_gen").appendPath(String.valueOf(this.mItems.size())).build();
        }

        private final Builder $$robo$$android_app_slice_Slice_Builder$setCallerNeeded(boolean callerNeeded) {
            if (callerNeeded) {
                this.mHints.add("caller_needed");
            } else {
                this.mHints.remove("caller_needed");
            }
            return this;
        }

        private final Builder $$robo$$android_app_slice_Slice_Builder$addHints(List<String> hints) {
            this.mHints.addAll(hints);
            return this;
        }

        private final Builder $$robo$$android_app_slice_Slice_Builder$setSpec(SliceSpec spec) {
            this.mSpec = spec;
            return this;
        }

        private final Builder $$robo$$android_app_slice_Slice_Builder$addSubSlice(Slice slice, String subType) {
            Preconditions.checkNotNull(slice);
            this.mItems.add(new SliceItem((Object)slice, "slice", subType, slice.getHints().toArray(new String[slice.getHints().size()])));
            return this;
        }

        private final Builder $$robo$$android_app_slice_Slice_Builder$addAction(PendingIntent action, Slice s, String subType) {
            Preconditions.checkNotNull(action);
            Preconditions.checkNotNull(s);
            List<String> hints = s.getHints();
            s.mSpec = null;
            this.mItems.add(new SliceItem(action, s, "action", subType, hints.toArray(new String[hints.size()])));
            return this;
        }

        private final Builder $$robo$$android_app_slice_Slice_Builder$addText(CharSequence text, String subType, List<String> hints) {
            this.mItems.add(new SliceItem((Object)text, "text", subType, hints));
            return this;
        }

        private final Builder $$robo$$android_app_slice_Slice_Builder$addIcon(Icon icon, String subType, List<String> hints) {
            Preconditions.checkNotNull(icon);
            this.mItems.add(new SliceItem((Object)icon, "image", subType, hints));
            return this;
        }

        private final Builder $$robo$$android_app_slice_Slice_Builder$addRemoteInput(RemoteInput remoteInput, String subType, List<String> hints) {
            Preconditions.checkNotNull(remoteInput);
            this.mItems.add(new SliceItem((Object)remoteInput, "input", subType, hints));
            return this;
        }

        private final Builder $$robo$$android_app_slice_Slice_Builder$addInt(int value, String subType, List<String> hints) {
            this.mItems.add(new SliceItem((Object)value, "int", subType, hints));
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_app_slice_Slice_Builder$addTimestamp(long time, String subType, List<String> hints) {
            return this.addLong(time, subType, hints);
        }

        private final Builder $$robo$$android_app_slice_Slice_Builder$addLong(long value, String subType, List<String> hints) {
            this.mItems.add(new SliceItem((Object)value, "long", subType, hints.toArray(new String[hints.size()])));
            return this;
        }

        private final Builder $$robo$$android_app_slice_Slice_Builder$addBundle(Bundle bundle, String subType, List<String> hints) {
            Preconditions.checkNotNull(bundle);
            this.mItems.add(new SliceItem((Object)bundle, "bundle", subType, hints));
            return this;
        }

        private final Slice $$robo$$android_app_slice_Slice_Builder$build() {
            return new Slice(this.mItems, this.mHints.toArray(new String[this.mHints.size()]), this.mUri, this.mSpec);
        }

        private void __constructor__(Uri uri) {
            this.$$robo$$android_app_slice_Slice_Builder$__constructor__(uri);
        }

        public Builder(Uri uri) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_slice_Slice_Builder$__constructor__(android.net.Uri ), this, uri);
        }

        private void __constructor__(Uri uri, SliceSpec sliceSpec) {
            this.$$robo$$android_app_slice_Slice_Builder$__constructor__(uri, sliceSpec);
        }

        public Builder(Uri uri, SliceSpec sliceSpec) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_slice_Slice_Builder$__constructor__(android.net.Uri android.app.slice.SliceSpec ), this, uri, sliceSpec);
        }

        private void __constructor__(Builder builder) {
            this.$$robo$$android_app_slice_Slice_Builder$__constructor__(builder);
        }

        public Builder(Builder builder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_slice_Slice_Builder$__constructor__(android.app.slice.Slice$Builder ), this, builder);
        }

        public Builder setCallerNeeded(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setCallerNeeded", $$robo$$android_app_slice_Slice_Builder$setCallerNeeded(boolean ), this, bl);
        }

        public Builder addHints(List<String> list) {
            return InvokeDynamicSupport.bootstrap("addHints", $$robo$$android_app_slice_Slice_Builder$addHints(java.util.List<java.lang.String> ), this, list);
        }

        public Builder setSpec(SliceSpec sliceSpec) {
            return InvokeDynamicSupport.bootstrap("setSpec", $$robo$$android_app_slice_Slice_Builder$setSpec(android.app.slice.SliceSpec ), this, sliceSpec);
        }

        public Builder addSubSlice(Slice slice, String string2) {
            return InvokeDynamicSupport.bootstrap("addSubSlice", $$robo$$android_app_slice_Slice_Builder$addSubSlice(android.app.slice.Slice java.lang.String ), this, slice, string2);
        }

        public Builder addAction(PendingIntent pendingIntent, Slice slice, String string2) {
            return InvokeDynamicSupport.bootstrap("addAction", $$robo$$android_app_slice_Slice_Builder$addAction(android.app.PendingIntent android.app.slice.Slice java.lang.String ), this, pendingIntent, slice, string2);
        }

        public Builder addText(CharSequence charSequence, String string2, List<String> list) {
            return InvokeDynamicSupport.bootstrap("addText", $$robo$$android_app_slice_Slice_Builder$addText(java.lang.CharSequence java.lang.String java.util.List<java.lang.String> ), this, charSequence, string2, list);
        }

        public Builder addIcon(Icon icon, String string2, List<String> list) {
            return InvokeDynamicSupport.bootstrap("addIcon", $$robo$$android_app_slice_Slice_Builder$addIcon(android.graphics.drawable.Icon java.lang.String java.util.List<java.lang.String> ), this, icon, string2, list);
        }

        public Builder addRemoteInput(RemoteInput remoteInput, String string2, List<String> list) {
            return InvokeDynamicSupport.bootstrap("addRemoteInput", $$robo$$android_app_slice_Slice_Builder$addRemoteInput(android.app.RemoteInput java.lang.String java.util.List<java.lang.String> ), this, remoteInput, string2, list);
        }

        public Builder addInt(int n, String string2, List<String> list) {
            return InvokeDynamicSupport.bootstrap("addInt", $$robo$$android_app_slice_Slice_Builder$addInt(int java.lang.String java.util.List<java.lang.String> ), this, n, string2, list);
        }

        @Deprecated
        public Builder addTimestamp(long l, String string2, List<String> list) {
            return InvokeDynamicSupport.bootstrap("addTimestamp", $$robo$$android_app_slice_Slice_Builder$addTimestamp(long java.lang.String java.util.List<java.lang.String> ), this, l, string2, list);
        }

        public Builder addLong(long l, String string2, List<String> list) {
            return InvokeDynamicSupport.bootstrap("addLong", $$robo$$android_app_slice_Slice_Builder$addLong(long java.lang.String java.util.List<java.lang.String> ), this, l, string2, list);
        }

        public Builder addBundle(Bundle bundle, String string2, List<String> list) {
            return InvokeDynamicSupport.bootstrap("addBundle", $$robo$$android_app_slice_Slice_Builder$addBundle(android.os.Bundle java.lang.String java.util.List<java.lang.String> ), this, bundle, string2, list);
        }

        public Slice build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_app_slice_Slice_Builder$build(), this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SliceSubtype {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SliceHint {
    }
}

