/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.annotation.SystemApi;
import android.app.backup.BackupManagerMonitor;
import android.app.backup.BackupObserver;
import android.app.backup.BackupProgress;
import android.app.backup.IBackupManager;
import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IBackupObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.ISelectBackupTransportCallback;
import android.app.backup.RestoreObserver;
import android.app.backup.RestoreSession;
import android.app.backup.SelectBackupTransportCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.Log;
import android.util.Pair;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BackupManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BackupManager";
    @SystemApi
    public static int SUCCESS = 0;
    @SystemApi
    public static int ERROR_BACKUP_NOT_ALLOWED = -2001;
    @SystemApi
    public static int ERROR_PACKAGE_NOT_FOUND = -2002;
    @SystemApi
    public static int ERROR_BACKUP_CANCELLED = -2003;
    @SystemApi
    public static int ERROR_TRANSPORT_ABORTED = -1000;
    @SystemApi
    public static int ERROR_TRANSPORT_PACKAGE_REJECTED = -1002;
    @SystemApi
    public static int ERROR_TRANSPORT_QUOTA_EXCEEDED = -1005;
    @SystemApi
    public static int ERROR_AGENT_FAILURE = -1003;
    public static String EXTRA_BACKUP_SERVICES_AVAILABLE = "backup_services_available";
    @SystemApi
    public static int FLAG_NON_INCREMENTAL_BACKUP = 1;
    @SystemApi
    public static String PACKAGE_MANAGER_SENTINEL = "@pm@";
    @SystemApi
    public static int ERROR_TRANSPORT_UNAVAILABLE = -1;
    @SystemApi
    public static int ERROR_TRANSPORT_INVALID = -2;
    private Context mContext;
    private static IBackupManager sService;

    private static final void $$robo$$android_app_backup_BackupManager$checkServiceBinder() {
        if (sService == null) {
            sService = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
        }
    }

    private void $$robo$$android_app_backup_BackupManager$__constructor__(Context context) {
        this.mContext = context;
    }

    private final void $$robo$$android_app_backup_BackupManager$dataChanged() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.dataChanged(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.d("BackupManager", "dataChanged() couldn't connect");
            }
        }
    }

    private static final void $$robo$$android_app_backup_BackupManager$dataChanged(String packageName) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.dataChanged(packageName);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "dataChanged(pkg) couldn't connect");
            }
        }
    }

    @Deprecated
    private final int $$robo$$android_app_backup_BackupManager$requestRestore(RestoreObserver observer) {
        return this.requestRestore(observer, null);
    }

    @Deprecated
    @SystemApi
    private final int $$robo$$android_app_backup_BackupManager$requestRestore(RestoreObserver observer, BackupManagerMonitor monitor) {
        Log.w("BackupManager", "requestRestore(): Since Android P app can no longer request restoring of its backup.");
        return -1;
    }

    @SystemApi
    private final RestoreSession $$robo$$android_app_backup_BackupManager$beginRestoreSession() {
        RestoreSession session = null;
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                IRestoreSession binder = sService.beginRestoreSession(null, null);
                if (binder != null) {
                    session = new RestoreSession(this.mContext, binder);
                }
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "beginRestoreSession() couldn't connect");
            }
        }
        return session;
    }

    @SystemApi
    private final void $$robo$$android_app_backup_BackupManager$setBackupEnabled(boolean isEnabled) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.setBackupEnabled(isEnabled);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "setBackupEnabled() couldn't connect");
            }
        }
    }

    @SystemApi
    private final boolean $$robo$$android_app_backup_BackupManager$isBackupEnabled() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.isBackupEnabled();
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "isBackupEnabled() couldn't connect");
            }
        }
        return false;
    }

    @SystemApi
    private final boolean $$robo$$android_app_backup_BackupManager$isBackupServiceActive(UserHandle user) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "isBackupServiceActive");
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.isBackupServiceActive(user.getIdentifier());
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "isBackupEnabled() couldn't connect");
            }
        }
        return false;
    }

    @SystemApi
    private final void $$robo$$android_app_backup_BackupManager$setAutoRestore(boolean isEnabled) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.setAutoRestore(isEnabled);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "setAutoRestore() couldn't connect");
            }
        }
    }

    @SystemApi
    private final String $$robo$$android_app_backup_BackupManager$getCurrentTransport() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.getCurrentTransport();
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "getCurrentTransport() couldn't connect");
            }
        }
        return null;
    }

    @SystemApi
    private final String[] $$robo$$android_app_backup_BackupManager$listAllTransports() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.listAllTransports();
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "listAllTransports() couldn't connect");
            }
        }
        return null;
    }

    @SystemApi
    private final void $$robo$$android_app_backup_BackupManager$updateTransportAttributes(ComponentName transportComponent, String name, Intent configurationIntent, String currentDestinationString, Intent dataManagementIntent, String dataManagementLabel) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.updateTransportAttributes(transportComponent, name, configurationIntent, currentDestinationString, dataManagementIntent, dataManagementLabel);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "describeTransport() couldn't connect");
            }
        }
    }

    @Deprecated
    @SystemApi
    private final String $$robo$$android_app_backup_BackupManager$selectBackupTransport(String transport) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.selectBackupTransport(transport);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "selectBackupTransport() couldn't connect");
            }
        }
        return null;
    }

    @SystemApi
    private final void $$robo$$android_app_backup_BackupManager$selectBackupTransport(ComponentName transport, SelectBackupTransportCallback listener) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                SelectTransportListenerWrapper wrapper = listener == null ? null : new SelectTransportListenerWrapper(this, this.mContext, listener);
                sService.selectBackupTransportAsync(transport, wrapper);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "selectBackupTransportAsync() couldn't connect");
            }
        }
    }

    @SystemApi
    private final void $$robo$$android_app_backup_BackupManager$backupNow() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.backupNow();
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "backupNow() couldn't connect");
            }
        }
    }

    @SystemApi
    private final long $$robo$$android_app_backup_BackupManager$getAvailableRestoreToken(String packageName) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.getAvailableRestoreToken(packageName);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "getAvailableRestoreToken() couldn't connect");
            }
        }
        return 0L;
    }

    @SystemApi
    private final boolean $$robo$$android_app_backup_BackupManager$isAppEligibleForBackup(String packageName) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.isAppEligibleForBackup(packageName);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "isAppEligibleForBackup(pkg) couldn't connect");
            }
        }
        return false;
    }

    @SystemApi
    private final int $$robo$$android_app_backup_BackupManager$requestBackup(String[] packages, BackupObserver observer) {
        return this.requestBackup(packages, observer, null, 0);
    }

    @SystemApi
    private final int $$robo$$android_app_backup_BackupManager$requestBackup(String[] packages, BackupObserver observer, BackupManagerMonitor monitor, int flags) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                BackupObserverWrapper observerWrapper = observer == null ? null : new BackupObserverWrapper(this, this.mContext, observer);
                BackupManagerMonitorWrapper monitorWrapper = monitor == null ? null : new BackupManagerMonitorWrapper(this, monitor);
                return sService.requestBackup(packages, observerWrapper, monitorWrapper, flags);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "requestBackup() couldn't connect");
            }
        }
        return -1;
    }

    @SystemApi
    private final void $$robo$$android_app_backup_BackupManager$cancelBackups() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.cancelBackups();
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "cancelBackups() couldn't connect.");
            }
        }
    }

    @SystemApi
    private final Intent $$robo$$android_app_backup_BackupManager$getConfigurationIntent(String transportName) {
        if (sService != null) {
            try {
                return sService.getConfigurationIntent(transportName);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "getConfigurationIntent() couldn't connect");
            }
        }
        return null;
    }

    @SystemApi
    private final String $$robo$$android_app_backup_BackupManager$getDestinationString(String transportName) {
        if (sService != null) {
            try {
                return sService.getDestinationString(transportName);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "getDestinationString() couldn't connect");
            }
        }
        return null;
    }

    @SystemApi
    private final Intent $$robo$$android_app_backup_BackupManager$getDataManagementIntent(String transportName) {
        if (sService != null) {
            try {
                return sService.getDataManagementIntent(transportName);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "getDataManagementIntent() couldn't connect");
            }
        }
        return null;
    }

    @SystemApi
    private final String $$robo$$android_app_backup_BackupManager$getDataManagementLabel(String transportName) {
        if (sService != null) {
            try {
                return sService.getDataManagementLabel(transportName);
            }
            catch (RemoteException e) {
                Log.e("BackupManager", "getDataManagementLabel() couldn't connect");
            }
        }
        return null;
    }

    private static void checkServiceBinder() {
        InvokeDynamicSupport.bootstrapStatic("checkServiceBinder", $$robo$$android_app_backup_BackupManager$checkServiceBinder());
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_backup_BackupManager$__constructor__(context);
    }

    public BackupManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupManager$__constructor__(android.content.Context ), this, context);
    }

    public void dataChanged() {
        InvokeDynamicSupport.bootstrap("dataChanged", $$robo$$android_app_backup_BackupManager$dataChanged(), this);
    }

    public static void dataChanged(String string2) {
        InvokeDynamicSupport.bootstrapStatic("dataChanged", $$robo$$android_app_backup_BackupManager$dataChanged(java.lang.String ), (String)string2);
    }

    @Deprecated
    public int requestRestore(RestoreObserver restoreObserver) {
        return (int)InvokeDynamicSupport.bootstrap("requestRestore", $$robo$$android_app_backup_BackupManager$requestRestore(android.app.backup.RestoreObserver ), this, restoreObserver);
    }

    @Deprecated
    @SystemApi
    public int requestRestore(RestoreObserver restoreObserver, BackupManagerMonitor backupManagerMonitor) {
        return (int)InvokeDynamicSupport.bootstrap("requestRestore", $$robo$$android_app_backup_BackupManager$requestRestore(android.app.backup.RestoreObserver android.app.backup.BackupManagerMonitor ), this, restoreObserver, backupManagerMonitor);
    }

    @SystemApi
    public RestoreSession beginRestoreSession() {
        return InvokeDynamicSupport.bootstrap("beginRestoreSession", $$robo$$android_app_backup_BackupManager$beginRestoreSession(), this);
    }

    @SystemApi
    public void setBackupEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBackupEnabled", $$robo$$android_app_backup_BackupManager$setBackupEnabled(boolean ), this, bl);
    }

    @SystemApi
    public boolean isBackupEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBackupEnabled", $$robo$$android_app_backup_BackupManager$isBackupEnabled(), this);
    }

    @SystemApi
    public boolean isBackupServiceActive(UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isBackupServiceActive", $$robo$$android_app_backup_BackupManager$isBackupServiceActive(android.os.UserHandle ), this, userHandle);
    }

    @SystemApi
    public void setAutoRestore(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoRestore", $$robo$$android_app_backup_BackupManager$setAutoRestore(boolean ), this, bl);
    }

    @SystemApi
    public String getCurrentTransport() {
        return InvokeDynamicSupport.bootstrap("getCurrentTransport", $$robo$$android_app_backup_BackupManager$getCurrentTransport(), this);
    }

    @SystemApi
    public String[] listAllTransports() {
        return InvokeDynamicSupport.bootstrap("listAllTransports", $$robo$$android_app_backup_BackupManager$listAllTransports(), this);
    }

    @SystemApi
    public void updateTransportAttributes(ComponentName componentName, String string2, Intent intent, String string3, Intent intent2, String string4) {
        InvokeDynamicSupport.bootstrap("updateTransportAttributes", $$robo$$android_app_backup_BackupManager$updateTransportAttributes(android.content.ComponentName java.lang.String android.content.Intent java.lang.String android.content.Intent java.lang.String ), this, componentName, string2, intent, string3, intent2, string4);
    }

    @Deprecated
    @SystemApi
    public String selectBackupTransport(String string2) {
        return InvokeDynamicSupport.bootstrap("selectBackupTransport", $$robo$$android_app_backup_BackupManager$selectBackupTransport(java.lang.String ), this, string2);
    }

    @SystemApi
    public void selectBackupTransport(ComponentName componentName, SelectBackupTransportCallback selectBackupTransportCallback) {
        InvokeDynamicSupport.bootstrap("selectBackupTransport", $$robo$$android_app_backup_BackupManager$selectBackupTransport(android.content.ComponentName android.app.backup.SelectBackupTransportCallback ), this, componentName, selectBackupTransportCallback);
    }

    @SystemApi
    public void backupNow() {
        InvokeDynamicSupport.bootstrap("backupNow", $$robo$$android_app_backup_BackupManager$backupNow(), this);
    }

    @SystemApi
    public long getAvailableRestoreToken(String string2) {
        return (long)InvokeDynamicSupport.bootstrap("getAvailableRestoreToken", $$robo$$android_app_backup_BackupManager$getAvailableRestoreToken(java.lang.String ), this, string2);
    }

    @SystemApi
    public boolean isAppEligibleForBackup(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAppEligibleForBackup", $$robo$$android_app_backup_BackupManager$isAppEligibleForBackup(java.lang.String ), this, string2);
    }

    @SystemApi
    public int requestBackup(String[] stringArray, BackupObserver backupObserver) {
        return (int)InvokeDynamicSupport.bootstrap("requestBackup", $$robo$$android_app_backup_BackupManager$requestBackup(java.lang.String[] android.app.backup.BackupObserver ), this, stringArray, backupObserver);
    }

    @SystemApi
    public int requestBackup(String[] stringArray, BackupObserver backupObserver, BackupManagerMonitor backupManagerMonitor, int n) {
        return (int)InvokeDynamicSupport.bootstrap("requestBackup", $$robo$$android_app_backup_BackupManager$requestBackup(java.lang.String[] android.app.backup.BackupObserver android.app.backup.BackupManagerMonitor int ), this, stringArray, backupObserver, backupManagerMonitor, n);
    }

    @SystemApi
    public void cancelBackups() {
        InvokeDynamicSupport.bootstrap("cancelBackups", $$robo$$android_app_backup_BackupManager$cancelBackups(), this);
    }

    @SystemApi
    public Intent getConfigurationIntent(String string2) {
        return InvokeDynamicSupport.bootstrap("getConfigurationIntent", $$robo$$android_app_backup_BackupManager$getConfigurationIntent(java.lang.String ), this, string2);
    }

    @SystemApi
    public String getDestinationString(String string2) {
        return InvokeDynamicSupport.bootstrap("getDestinationString", $$robo$$android_app_backup_BackupManager$getDestinationString(java.lang.String ), this, string2);
    }

    @SystemApi
    public Intent getDataManagementIntent(String string2) {
        return InvokeDynamicSupport.bootstrap("getDataManagementIntent", $$robo$$android_app_backup_BackupManager$getDataManagementIntent(java.lang.String ), this, string2);
    }

    @SystemApi
    public String getDataManagementLabel(String string2) {
        return InvokeDynamicSupport.bootstrap("getDataManagementLabel", $$robo$$android_app_backup_BackupManager$getDataManagementLabel(java.lang.String ), this, string2);
    }

    public /* synthetic */ BackupManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackupManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class BackupManagerMonitorWrapper
    extends IBackupManagerMonitor.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        BackupManagerMonitor mMonitor;
        /* synthetic */ BackupManager this$0;

        private void $$robo$$android_app_backup_BackupManager_BackupManagerMonitorWrapper$__constructor__(BackupManager backupManager, BackupManagerMonitor monitor) {
            this.this$0 = backupManager;
            this.mMonitor = monitor;
        }

        private final void $$robo$$android_app_backup_BackupManager_BackupManagerMonitorWrapper$onEvent(Bundle event) throws RemoteException {
            this.mMonitor.onEvent(event);
        }

        private void __constructor__(BackupManager backupManager, BackupManagerMonitor backupManagerMonitor) {
            this.$$robo$$android_app_backup_BackupManager_BackupManagerMonitorWrapper$__constructor__(backupManager, backupManagerMonitor);
        }

        public BackupManagerMonitorWrapper(BackupManager backupManager, BackupManagerMonitor backupManagerMonitor) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupManager_BackupManagerMonitorWrapper$__constructor__(android.app.backup.BackupManager android.app.backup.BackupManagerMonitor ), this, backupManager, backupManagerMonitor);
        }

        @Override
        public void onEvent(Bundle bundle) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onEvent", $$robo$$android_app_backup_BackupManager_BackupManagerMonitorWrapper$onEvent(android.os.Bundle ), this, bundle);
        }

        public /* synthetic */ BackupManagerMonitorWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackupManagerMonitorWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SelectTransportListenerWrapper
    extends ISelectBackupTransportCallback.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        private SelectBackupTransportCallback mListener;
        /* synthetic */ BackupManager this$0;

        private void $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper$__constructor__(BackupManager backupManager, Context context, SelectBackupTransportCallback listener) {
            this.this$0 = backupManager;
            this.mHandler = new Handler(context.getMainLooper());
            this.mListener = listener;
        }

        private final void $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper$onSuccess(String transportName) {
            this.mHandler.post(new Runnable(this, transportName){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ String val$transportName;
                /* synthetic */ SelectTransportListenerWrapper this$1;

                private void $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper_1$__constructor__(SelectTransportListenerWrapper this$1, String string2) {
                    this.this$1 = this$1;
                    this.val$transportName = string2;
                }

                private final void $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper_1$run() {
                    this.this$1.mListener.onSuccess(this.val$transportName);
                }

                private void __constructor__(SelectTransportListenerWrapper selectTransportListenerWrapper, String string2) {
                    this.$$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper_1$__constructor__(selectTransportListenerWrapper, string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper_1$__constructor__(android.app.backup.BackupManager$SelectTransportListenerWrapper java.lang.String ), this, selectTransportListenerWrapper, string2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper_1$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper$onFailure(int reason) {
            this.mHandler.post(new Runnable(this, reason){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$reason;
                /* synthetic */ SelectTransportListenerWrapper this$1;

                private void $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper_2$__constructor__(SelectTransportListenerWrapper this$1, int n) {
                    this.this$1 = this$1;
                    this.val$reason = n;
                }

                private final void $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper_2$run() {
                    this.this$1.mListener.onFailure(this.val$reason);
                }

                private void __constructor__(SelectTransportListenerWrapper selectTransportListenerWrapper, int n) {
                    this.$$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper_2$__constructor__(selectTransportListenerWrapper, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper_2$__constructor__(android.app.backup.BackupManager$SelectTransportListenerWrapper int ), this, selectTransportListenerWrapper, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper_2$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private void __constructor__(BackupManager backupManager, Context context, SelectBackupTransportCallback selectBackupTransportCallback) {
            this.$$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper$__constructor__(backupManager, context, selectBackupTransportCallback);
        }

        public SelectTransportListenerWrapper(BackupManager backupManager, Context context, SelectBackupTransportCallback selectBackupTransportCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper$__constructor__(android.app.backup.BackupManager android.content.Context android.app.backup.SelectBackupTransportCallback ), this, backupManager, context, selectBackupTransportCallback);
        }

        @Override
        public void onSuccess(String string2) {
            InvokeDynamicSupport.bootstrap("onSuccess", $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper$onSuccess(java.lang.String ), this, string2);
        }

        @Override
        public void onFailure(int n) {
            InvokeDynamicSupport.bootstrap("onFailure", $$robo$$android_app_backup_BackupManager_SelectTransportListenerWrapper$onFailure(int ), this, n);
        }

        public /* synthetic */ SelectTransportListenerWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectTransportListenerWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class BackupObserverWrapper
    extends IBackupObserver.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Handler mHandler;
        BackupObserver mObserver;
        static int MSG_UPDATE = 1;
        static int MSG_RESULT = 2;
        static int MSG_FINISHED = 3;
        /* synthetic */ BackupManager this$0;

        private void $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$__constructor__(BackupManager backupManager, Context context, BackupObserver observer) {
            this.this$0 = backupManager;
            this.mHandler = new ShadowedObject(this, context.getMainLooper(), backupManager){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ BackupManager val$this$0;
                /* synthetic */ BackupObserverWrapper this$1;

                private void $$robo$$android_app_backup_BackupManager_BackupObserverWrapper_1$__constructor__(BackupObserverWrapper this$1, Looper x0, BackupManager backupManager) {
                    this.this$1 = this$1;
                    this.val$this$0 = backupManager;
                }

                private final void $$robo$$android_app_backup_BackupManager_BackupObserverWrapper_1$handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            Pair obj = (Pair)msg.obj;
                            this.this$1.mObserver.onUpdate((String)obj.first, (BackupProgress)obj.second);
                            break;
                        }
                        case 2: {
                            this.this$1.mObserver.onResult((String)msg.obj, msg.arg1);
                            break;
                        }
                        case 3: {
                            this.this$1.mObserver.backupFinished(msg.arg1);
                            break;
                        }
                        default: {
                            Log.w("BackupManager", "Unknown message: " + msg);
                        }
                    }
                }

                private void __constructor__(BackupObserverWrapper backupObserverWrapper, Looper looper, BackupManager backupManager) {
                    this.$$robo$$android_app_backup_BackupManager_BackupObserverWrapper_1$__constructor__(backupObserverWrapper, looper, backupManager);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupManager_BackupObserverWrapper_1$__constructor__(android.app.backup.BackupManager$BackupObserverWrapper android.os.Looper android.app.backup.BackupManager ), this, backupObserverWrapper, looper, backupManager);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_backup_BackupManager_BackupObserverWrapper_1$handleMessage(android.os.Message ), this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mObserver = observer;
        }

        private final void $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$onUpdate(String currentPackage, BackupProgress backupProgress) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, Pair.create(currentPackage, backupProgress)));
        }

        private final void $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$onResult(String currentPackage, int status) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, status, 0, currentPackage));
        }

        private final void $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$backupFinished(int status) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, status, 0));
        }

        private void __constructor__(BackupManager backupManager, Context context, BackupObserver backupObserver) {
            this.$$robo$$android_app_backup_BackupManager_BackupObserverWrapper$__constructor__(backupManager, context, backupObserver);
        }

        public BackupObserverWrapper(BackupManager backupManager, Context context, BackupObserver backupObserver) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$__constructor__(android.app.backup.BackupManager android.content.Context android.app.backup.BackupObserver ), this, backupManager, context, backupObserver);
        }

        @Override
        public void onUpdate(String string2, BackupProgress backupProgress) {
            InvokeDynamicSupport.bootstrap("onUpdate", $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$onUpdate(java.lang.String android.app.backup.BackupProgress ), this, string2, backupProgress);
        }

        @Override
        public void onResult(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onResult", $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$onResult(java.lang.String int ), this, string2, n);
        }

        @Override
        public void backupFinished(int n) {
            InvokeDynamicSupport.bootstrap("backupFinished", $$robo$$android_app_backup_BackupManager_BackupObserverWrapper$backupFinished(int ), this, n);
        }

        public /* synthetic */ BackupObserverWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackupObserverWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

