/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.app.admin.NetworkEvent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DnsEvent
extends NetworkEvent
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private String mHostname;
    private String[] mIpAddresses;
    private int mIpAddressesCount;
    public static Parcelable.Creator<DnsEvent> CREATOR;

    private void $$robo$$android_app_admin_DnsEvent$__constructor__(String hostname, String[] ipAddresses, int ipAddressesCount, String packageName, long timestamp) {
        this.mHostname = hostname;
        this.mIpAddresses = ipAddresses;
        this.mIpAddressesCount = ipAddressesCount;
    }

    private void $$robo$$android_app_admin_DnsEvent$__constructor__(Parcel in) {
        this.mHostname = in.readString();
        this.mIpAddresses = in.createStringArray();
        this.mIpAddressesCount = in.readInt();
        this.mPackageName = in.readString();
        this.mTimestamp = in.readLong();
        this.mId = in.readLong();
    }

    private final String $$robo$$android_app_admin_DnsEvent$getHostname() {
        return this.mHostname;
    }

    private final List<InetAddress> $$robo$$android_app_admin_DnsEvent$getInetAddresses() {
        if (this.mIpAddresses == null || this.mIpAddresses.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>(this.mIpAddresses.length);
        for (String ipAddress : this.mIpAddresses) {
            try {
                inetAddresses.add(InetAddress.getByName(ipAddress));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return inetAddresses;
    }

    private final int $$robo$$android_app_admin_DnsEvent$getTotalResolvedAddressCount() {
        return this.mIpAddressesCount;
    }

    private final String $$robo$$android_app_admin_DnsEvent$toString() {
        return String.format("DnsEvent(%d, %s, %s, %d, %d, %s)", this.mId, this.mHostname, this.mIpAddresses == null ? "NONE" : String.join((CharSequence)" ", this.mIpAddresses), this.mIpAddressesCount, this.mTimestamp, this.mPackageName);
    }

    private final int $$robo$$android_app_admin_DnsEvent$describeContents() {
        return 0;
    }

    private final void $$robo$$android_app_admin_DnsEvent$writeToParcel(Parcel out, int flags) {
        out.writeInt(1);
        out.writeString(this.mHostname);
        out.writeStringArray(this.mIpAddresses);
        out.writeInt(this.mIpAddressesCount);
        out.writeString(this.mPackageName);
        out.writeLong(this.mTimestamp);
        out.writeLong(this.mId);
    }

    private /* synthetic */ void $$robo$$android_app_admin_DnsEvent$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<DnsEvent>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_admin_DnsEvent_1$__constructor__() {
            }

            private final DnsEvent $$robo$$android_app_admin_DnsEvent_1$createFromParcel(Parcel in) {
                if (in.readInt() != 1) {
                    return null;
                }
                return new DnsEvent(in, null);
            }

            private final DnsEvent[] $$robo$$android_app_admin_DnsEvent_1$newArray(int size) {
                return new DnsEvent[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_admin_DnsEvent_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_DnsEvent_1$__constructor__(), this);
            }

            @Override
            public DnsEvent createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_admin_DnsEvent_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public DnsEvent[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_admin_DnsEvent_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, String[] stringArray, int n, String string3, long l) {
        this.$$robo$$android_app_admin_DnsEvent$__constructor__(string2, stringArray, n, string3, l);
    }

    public DnsEvent(String string2, String[] stringArray, int n, String string3, long l) {
        super(string3, l);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_DnsEvent$__constructor__(java.lang.String java.lang.String[] int java.lang.String long ), this, string2, stringArray, n, string3, l);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_app_admin_DnsEvent$__constructor__(parcel);
    }

    public DnsEvent(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_DnsEvent$__constructor__(android.os.Parcel ), this, parcel);
    }

    public String getHostname() {
        return InvokeDynamicSupport.bootstrap("getHostname", $$robo$$android_app_admin_DnsEvent$getHostname(), this);
    }

    public List<InetAddress> getInetAddresses() {
        return InvokeDynamicSupport.bootstrap("getInetAddresses", $$robo$$android_app_admin_DnsEvent$getInetAddresses(), this);
    }

    public int getTotalResolvedAddressCount() {
        return (int)InvokeDynamicSupport.bootstrap("getTotalResolvedAddressCount", $$robo$$android_app_admin_DnsEvent$getTotalResolvedAddressCount(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_admin_DnsEvent$toString(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_admin_DnsEvent$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_admin_DnsEvent$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_app_admin_DnsEvent$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ DnsEvent(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_DnsEvent$__constructor__(android.os.Parcel android.app.admin.DnsEvent$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(DnsEvent.class);
    }

    public /* synthetic */ DnsEvent() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DnsEvent)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

