/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SearchableInfo
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String LOG_TAG = "SearchableInfo";
    private static String MD_LABEL_SEARCHABLE = "android.app.searchable";
    private static String MD_XML_ELEMENT_SEARCHABLE = "searchable";
    private static String MD_XML_ELEMENT_SEARCHABLE_ACTION_KEY = "actionkey";
    private static int SEARCH_MODE_BADGE_LABEL = 4;
    private static int SEARCH_MODE_BADGE_ICON = 8;
    private static int SEARCH_MODE_QUERY_REWRITE_FROM_DATA = 16;
    private static int SEARCH_MODE_QUERY_REWRITE_FROM_TEXT = 32;
    private int mLabelId;
    private ComponentName mSearchActivity;
    private int mHintId;
    private int mSearchMode;
    private int mIconId;
    private int mSearchButtonText;
    private int mSearchInputType;
    private int mSearchImeOptions;
    private boolean mIncludeInGlobalSearch;
    private boolean mQueryAfterZeroResults;
    private boolean mAutoUrlDetect;
    private int mSettingsDescriptionId;
    private String mSuggestAuthority;
    private String mSuggestPath;
    private String mSuggestSelection;
    private String mSuggestIntentAction;
    private String mSuggestIntentData;
    private int mSuggestThreshold;
    private HashMap<Integer, ActionKeyInfo> mActionKeys;
    private String mSuggestProviderPackage;
    private static int VOICE_SEARCH_SHOW_BUTTON = 1;
    private static int VOICE_SEARCH_LAUNCH_WEB_SEARCH = 2;
    private static int VOICE_SEARCH_LAUNCH_RECOGNIZER = 4;
    private int mVoiceSearchMode;
    private int mVoiceLanguageModeId;
    private int mVoicePromptTextId;
    private int mVoiceLanguageId;
    private int mVoiceMaxResults;
    public static Parcelable.Creator<SearchableInfo> CREATOR;

    private final String $$robo$$android_app_SearchableInfo$getSuggestAuthority() {
        return this.mSuggestAuthority;
    }

    private final String $$robo$$android_app_SearchableInfo$getSuggestPackage() {
        return this.mSuggestProviderPackage;
    }

    private final ComponentName $$robo$$android_app_SearchableInfo$getSearchActivity() {
        return this.mSearchActivity;
    }

    private final boolean $$robo$$android_app_SearchableInfo$useBadgeLabel() {
        return 0 != (this.mSearchMode & 4);
    }

    private final boolean $$robo$$android_app_SearchableInfo$useBadgeIcon() {
        return 0 != (this.mSearchMode & 8) && this.mIconId != 0;
    }

    private final boolean $$robo$$android_app_SearchableInfo$shouldRewriteQueryFromData() {
        return 0 != (this.mSearchMode & 0x10);
    }

    private final boolean $$robo$$android_app_SearchableInfo$shouldRewriteQueryFromText() {
        return 0 != (this.mSearchMode & 0x20);
    }

    private final int $$robo$$android_app_SearchableInfo$getSettingsDescriptionId() {
        return this.mSettingsDescriptionId;
    }

    private final String $$robo$$android_app_SearchableInfo$getSuggestPath() {
        return this.mSuggestPath;
    }

    private final String $$robo$$android_app_SearchableInfo$getSuggestSelection() {
        return this.mSuggestSelection;
    }

    private final String $$robo$$android_app_SearchableInfo$getSuggestIntentAction() {
        return this.mSuggestIntentAction;
    }

    private final String $$robo$$android_app_SearchableInfo$getSuggestIntentData() {
        return this.mSuggestIntentData;
    }

    private final int $$robo$$android_app_SearchableInfo$getSuggestThreshold() {
        return this.mSuggestThreshold;
    }

    private final Context $$robo$$android_app_SearchableInfo$getActivityContext(Context context) {
        return SearchableInfo.createActivityContext(context, this.mSearchActivity);
    }

    private static final Context $$robo$$android_app_SearchableInfo$createActivityContext(Context context, ComponentName activity) {
        Context theirContext = null;
        try {
            theirContext = context.createPackageContext(activity.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("SearchableInfo", "Package not found " + activity.getPackageName());
        }
        catch (SecurityException e) {
            Log.e("SearchableInfo", "Can't make context for " + activity.getPackageName(), e);
        }
        return theirContext;
    }

    private final Context $$robo$$android_app_SearchableInfo$getProviderContext(Context context, Context activityContext) {
        Context theirContext = null;
        if (this.mSearchActivity.getPackageName().equals(this.mSuggestProviderPackage)) {
            return activityContext;
        }
        if (this.mSuggestProviderPackage != null) {
            try {
                theirContext = context.createPackageContext(this.mSuggestProviderPackage, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return theirContext;
    }

    private void $$robo$$android_app_SearchableInfo$__constructor__(Context activityContext, AttributeSet attr2, ComponentName cName) {
        PackageManager pm;
        ProviderInfo pi;
        this.mActionKeys = null;
        this.mSearchActivity = cName;
        TypedArray a = activityContext.obtainStyledAttributes(attr2, R.styleable.Searchable);
        this.mSearchMode = a.getInt(3, 0);
        this.mLabelId = a.getResourceId(0, 0);
        this.mHintId = a.getResourceId(2, 0);
        this.mIconId = a.getResourceId(1, 0);
        this.mSearchButtonText = a.getResourceId(9, 0);
        this.mSearchInputType = a.getInt(10, 1);
        this.mSearchImeOptions = a.getInt(16, 2);
        this.mIncludeInGlobalSearch = a.getBoolean(18, false);
        this.mQueryAfterZeroResults = a.getBoolean(19, false);
        this.mAutoUrlDetect = a.getBoolean(21, false);
        this.mSettingsDescriptionId = a.getResourceId(20, 0);
        this.mSuggestAuthority = a.getString(4);
        this.mSuggestPath = a.getString(5);
        this.mSuggestSelection = a.getString(6);
        this.mSuggestIntentAction = a.getString(7);
        this.mSuggestIntentData = a.getString(8);
        this.mSuggestThreshold = a.getInt(17, 0);
        this.mVoiceSearchMode = a.getInt(11, 0);
        this.mVoiceLanguageModeId = a.getResourceId(12, 0);
        this.mVoicePromptTextId = a.getResourceId(13, 0);
        this.mVoiceLanguageId = a.getResourceId(14, 0);
        this.mVoiceMaxResults = a.getInt(15, 0);
        a.recycle();
        String suggestProviderPackage = null;
        if (this.mSuggestAuthority != null && (pi = (pm = activityContext.getPackageManager()).resolveContentProvider(this.mSuggestAuthority, 0x10000000)) != null) {
            suggestProviderPackage = pi.packageName;
        }
        this.mSuggestProviderPackage = suggestProviderPackage;
        if (this.mLabelId == 0) {
            throw new IllegalArgumentException("Search label must be a resource reference.");
        }
    }

    private final ActionKeyInfo $$robo$$android_app_SearchableInfo$findActionKey(int keyCode) {
        if (this.mActionKeys == null) {
            return null;
        }
        return this.mActionKeys.get(keyCode);
    }

    private final void $$robo$$android_app_SearchableInfo$addActionKey(ActionKeyInfo keyInfo) {
        if (this.mActionKeys == null) {
            this.mActionKeys = new HashMap();
        }
        this.mActionKeys.put(keyInfo.getKeyCode(), keyInfo);
    }

    private static final SearchableInfo $$robo$$android_app_SearchableInfo$getActivityMetaData(Context context, ActivityInfo activityInfo, int userId) {
        Context userContext = null;
        try {
            userContext = context.createPackageContextAsUser("system", 0, new UserHandle(userId));
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            Log.e("SearchableInfo", "Couldn't create package context for user " + userId);
            return null;
        }
        XmlResourceParser xml2 = activityInfo.loadXmlMetaData(userContext.getPackageManager(), "android.app.searchable");
        if (xml2 == null) {
            return null;
        }
        ComponentName cName = new ComponentName(activityInfo.packageName, activityInfo.name);
        SearchableInfo searchable = SearchableInfo.getActivityMetaData(userContext, xml2, cName);
        xml2.close();
        return searchable;
    }

    private static final SearchableInfo $$robo$$android_app_SearchableInfo$getActivityMetaData(Context context, XmlPullParser xml2, ComponentName cName) {
        SearchableInfo result = null;
        Context activityContext = SearchableInfo.createActivityContext(context, cName);
        if (activityContext == null) {
            return null;
        }
        try {
            int tagType = xml2.next();
            while (tagType != 1) {
                if (tagType == 2) {
                    AttributeSet attr2;
                    if (xml2.getName().equals("searchable")) {
                        attr2 = Xml.asAttributeSet(xml2);
                        if (attr2 != null) {
                            try {
                                result = new SearchableInfo(activityContext, attr2, cName);
                            }
                            catch (IllegalArgumentException ex) {
                                Log.w("SearchableInfo", "Invalid searchable metadata for " + cName.flattenToShortString() + ": " + ex.getMessage());
                                return null;
                            }
                        }
                    } else if (xml2.getName().equals("actionkey")) {
                        if (result == null) {
                            return null;
                        }
                        attr2 = Xml.asAttributeSet(xml2);
                        if (attr2 != null) {
                            try {
                                result.addActionKey(new ActionKeyInfo(activityContext, attr2));
                            }
                            catch (IllegalArgumentException ex) {
                                Log.w("SearchableInfo", "Invalid action key for " + cName.flattenToShortString() + ": " + ex.getMessage());
                                return null;
                            }
                        }
                    }
                }
                tagType = xml2.next();
            }
        }
        catch (XmlPullParserException e) {
            Log.w("SearchableInfo", "Reading searchable metadata for " + cName.flattenToShortString(), e);
            return null;
        }
        catch (IOException e) {
            Log.w("SearchableInfo", "Reading searchable metadata for " + cName.flattenToShortString(), e);
            return null;
        }
        return result;
    }

    private final int $$robo$$android_app_SearchableInfo$getLabelId() {
        return this.mLabelId;
    }

    private final int $$robo$$android_app_SearchableInfo$getHintId() {
        return this.mHintId;
    }

    private final int $$robo$$android_app_SearchableInfo$getIconId() {
        return this.mIconId;
    }

    private final boolean $$robo$$android_app_SearchableInfo$getVoiceSearchEnabled() {
        return 0 != (this.mVoiceSearchMode & 1);
    }

    private final boolean $$robo$$android_app_SearchableInfo$getVoiceSearchLaunchWebSearch() {
        return 0 != (this.mVoiceSearchMode & 2);
    }

    private final boolean $$robo$$android_app_SearchableInfo$getVoiceSearchLaunchRecognizer() {
        return 0 != (this.mVoiceSearchMode & 4);
    }

    private final int $$robo$$android_app_SearchableInfo$getVoiceLanguageModeId() {
        return this.mVoiceLanguageModeId;
    }

    private final int $$robo$$android_app_SearchableInfo$getVoicePromptTextId() {
        return this.mVoicePromptTextId;
    }

    private final int $$robo$$android_app_SearchableInfo$getVoiceLanguageId() {
        return this.mVoiceLanguageId;
    }

    private final int $$robo$$android_app_SearchableInfo$getVoiceMaxResults() {
        return this.mVoiceMaxResults;
    }

    private final int $$robo$$android_app_SearchableInfo$getSearchButtonText() {
        return this.mSearchButtonText;
    }

    private final int $$robo$$android_app_SearchableInfo$getInputType() {
        return this.mSearchInputType;
    }

    private final int $$robo$$android_app_SearchableInfo$getImeOptions() {
        return this.mSearchImeOptions;
    }

    private final boolean $$robo$$android_app_SearchableInfo$shouldIncludeInGlobalSearch() {
        return this.mIncludeInGlobalSearch;
    }

    private final boolean $$robo$$android_app_SearchableInfo$queryAfterZeroResults() {
        return this.mQueryAfterZeroResults;
    }

    private final boolean $$robo$$android_app_SearchableInfo$autoUrlDetect() {
        return this.mAutoUrlDetect;
    }

    private void $$robo$$android_app_SearchableInfo$__constructor__(Parcel in) {
        this.mActionKeys = null;
        this.mLabelId = in.readInt();
        this.mSearchActivity = ComponentName.readFromParcel(in);
        this.mHintId = in.readInt();
        this.mSearchMode = in.readInt();
        this.mIconId = in.readInt();
        this.mSearchButtonText = in.readInt();
        this.mSearchInputType = in.readInt();
        this.mSearchImeOptions = in.readInt();
        this.mIncludeInGlobalSearch = in.readInt() != 0;
        this.mQueryAfterZeroResults = in.readInt() != 0;
        this.mAutoUrlDetect = in.readInt() != 0;
        this.mSettingsDescriptionId = in.readInt();
        this.mSuggestAuthority = in.readString();
        this.mSuggestPath = in.readString();
        this.mSuggestSelection = in.readString();
        this.mSuggestIntentAction = in.readString();
        this.mSuggestIntentData = in.readString();
        this.mSuggestThreshold = in.readInt();
        for (int count = in.readInt(); count > 0; --count) {
            this.addActionKey(new ActionKeyInfo(in, null));
        }
        this.mSuggestProviderPackage = in.readString();
        this.mVoiceSearchMode = in.readInt();
        this.mVoiceLanguageModeId = in.readInt();
        this.mVoicePromptTextId = in.readInt();
        this.mVoiceLanguageId = in.readInt();
        this.mVoiceMaxResults = in.readInt();
    }

    private final int $$robo$$android_app_SearchableInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_app_SearchableInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mLabelId);
        this.mSearchActivity.writeToParcel(dest, flags);
        dest.writeInt(this.mHintId);
        dest.writeInt(this.mSearchMode);
        dest.writeInt(this.mIconId);
        dest.writeInt(this.mSearchButtonText);
        dest.writeInt(this.mSearchInputType);
        dest.writeInt(this.mSearchImeOptions);
        dest.writeInt(this.mIncludeInGlobalSearch ? 1 : 0);
        dest.writeInt(this.mQueryAfterZeroResults ? 1 : 0);
        dest.writeInt(this.mAutoUrlDetect ? 1 : 0);
        dest.writeInt(this.mSettingsDescriptionId);
        dest.writeString(this.mSuggestAuthority);
        dest.writeString(this.mSuggestPath);
        dest.writeString(this.mSuggestSelection);
        dest.writeString(this.mSuggestIntentAction);
        dest.writeString(this.mSuggestIntentData);
        dest.writeInt(this.mSuggestThreshold);
        if (this.mActionKeys == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(this.mActionKeys.size());
            for (ActionKeyInfo actionKey : this.mActionKeys.values()) {
                actionKey.writeToParcel(dest, flags);
            }
        }
        dest.writeString(this.mSuggestProviderPackage);
        dest.writeInt(this.mVoiceSearchMode);
        dest.writeInt(this.mVoiceLanguageModeId);
        dest.writeInt(this.mVoicePromptTextId);
        dest.writeInt(this.mVoiceLanguageId);
        dest.writeInt(this.mVoiceMaxResults);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<SearchableInfo>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_SearchableInfo_1$__constructor__() {
            }

            private final SearchableInfo $$robo$$android_app_SearchableInfo_1$createFromParcel(Parcel in) {
                return new SearchableInfo(in);
            }

            private final SearchableInfo[] $$robo$$android_app_SearchableInfo_1$newArray(int size) {
                return new SearchableInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_SearchableInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchableInfo_1$__constructor__(), this);
            }

            @Override
            public SearchableInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_SearchableInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public SearchableInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_SearchableInfo_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public String getSuggestAuthority() {
        return InvokeDynamicSupport.bootstrap("getSuggestAuthority", $$robo$$android_app_SearchableInfo$getSuggestAuthority(), this);
    }

    public String getSuggestPackage() {
        return InvokeDynamicSupport.bootstrap("getSuggestPackage", $$robo$$android_app_SearchableInfo$getSuggestPackage(), this);
    }

    public ComponentName getSearchActivity() {
        return InvokeDynamicSupport.bootstrap("getSearchActivity", $$robo$$android_app_SearchableInfo$getSearchActivity(), this);
    }

    public boolean useBadgeLabel() {
        return (boolean)InvokeDynamicSupport.bootstrap("useBadgeLabel", $$robo$$android_app_SearchableInfo$useBadgeLabel(), this);
    }

    public boolean useBadgeIcon() {
        return (boolean)InvokeDynamicSupport.bootstrap("useBadgeIcon", $$robo$$android_app_SearchableInfo$useBadgeIcon(), this);
    }

    public boolean shouldRewriteQueryFromData() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldRewriteQueryFromData", $$robo$$android_app_SearchableInfo$shouldRewriteQueryFromData(), this);
    }

    public boolean shouldRewriteQueryFromText() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldRewriteQueryFromText", $$robo$$android_app_SearchableInfo$shouldRewriteQueryFromText(), this);
    }

    public int getSettingsDescriptionId() {
        return (int)InvokeDynamicSupport.bootstrap("getSettingsDescriptionId", $$robo$$android_app_SearchableInfo$getSettingsDescriptionId(), this);
    }

    public String getSuggestPath() {
        return InvokeDynamicSupport.bootstrap("getSuggestPath", $$robo$$android_app_SearchableInfo$getSuggestPath(), this);
    }

    public String getSuggestSelection() {
        return InvokeDynamicSupport.bootstrap("getSuggestSelection", $$robo$$android_app_SearchableInfo$getSuggestSelection(), this);
    }

    public String getSuggestIntentAction() {
        return InvokeDynamicSupport.bootstrap("getSuggestIntentAction", $$robo$$android_app_SearchableInfo$getSuggestIntentAction(), this);
    }

    public String getSuggestIntentData() {
        return InvokeDynamicSupport.bootstrap("getSuggestIntentData", $$robo$$android_app_SearchableInfo$getSuggestIntentData(), this);
    }

    public int getSuggestThreshold() {
        return (int)InvokeDynamicSupport.bootstrap("getSuggestThreshold", $$robo$$android_app_SearchableInfo$getSuggestThreshold(), this);
    }

    public Context getActivityContext(Context context) {
        return InvokeDynamicSupport.bootstrap("getActivityContext", $$robo$$android_app_SearchableInfo$getActivityContext(android.content.Context ), this, context);
    }

    private static Context createActivityContext(Context context, ComponentName componentName) {
        return InvokeDynamicSupport.bootstrapStatic("createActivityContext", $$robo$$android_app_SearchableInfo$createActivityContext(android.content.Context android.content.ComponentName ), (Context)context, (ComponentName)componentName);
    }

    public Context getProviderContext(Context context, Context context2) {
        return InvokeDynamicSupport.bootstrap("getProviderContext", $$robo$$android_app_SearchableInfo$getProviderContext(android.content.Context android.content.Context ), this, context, context2);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, ComponentName componentName) {
        this.$$robo$$android_app_SearchableInfo$__constructor__(context, attributeSet, componentName);
    }

    public SearchableInfo(Context context, AttributeSet attributeSet, ComponentName componentName) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchableInfo$__constructor__(android.content.Context android.util.AttributeSet android.content.ComponentName ), this, context, attributeSet, componentName);
    }

    public ActionKeyInfo findActionKey(int n) {
        return InvokeDynamicSupport.bootstrap("findActionKey", $$robo$$android_app_SearchableInfo$findActionKey(int ), this, n);
    }

    private void addActionKey(ActionKeyInfo actionKeyInfo) {
        InvokeDynamicSupport.bootstrap("addActionKey", $$robo$$android_app_SearchableInfo$addActionKey(android.app.SearchableInfo$ActionKeyInfo ), this, actionKeyInfo);
    }

    public static SearchableInfo getActivityMetaData(Context context, ActivityInfo activityInfo, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getActivityMetaData", $$robo$$android_app_SearchableInfo$getActivityMetaData(android.content.Context android.content.pm.ActivityInfo int ), (Context)context, (ActivityInfo)activityInfo, (int)n);
    }

    private static SearchableInfo getActivityMetaData(Context context, XmlPullParser xmlPullParser, ComponentName componentName) {
        return InvokeDynamicSupport.bootstrapStatic("getActivityMetaData", $$robo$$android_app_SearchableInfo$getActivityMetaData(android.content.Context org.xmlpull.v1.XmlPullParser android.content.ComponentName ), (Context)context, (XmlPullParser)xmlPullParser, (ComponentName)componentName);
    }

    public int getLabelId() {
        return (int)InvokeDynamicSupport.bootstrap("getLabelId", $$robo$$android_app_SearchableInfo$getLabelId(), this);
    }

    public int getHintId() {
        return (int)InvokeDynamicSupport.bootstrap("getHintId", $$robo$$android_app_SearchableInfo$getHintId(), this);
    }

    public int getIconId() {
        return (int)InvokeDynamicSupport.bootstrap("getIconId", $$robo$$android_app_SearchableInfo$getIconId(), this);
    }

    public boolean getVoiceSearchEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getVoiceSearchEnabled", $$robo$$android_app_SearchableInfo$getVoiceSearchEnabled(), this);
    }

    public boolean getVoiceSearchLaunchWebSearch() {
        return (boolean)InvokeDynamicSupport.bootstrap("getVoiceSearchLaunchWebSearch", $$robo$$android_app_SearchableInfo$getVoiceSearchLaunchWebSearch(), this);
    }

    public boolean getVoiceSearchLaunchRecognizer() {
        return (boolean)InvokeDynamicSupport.bootstrap("getVoiceSearchLaunchRecognizer", $$robo$$android_app_SearchableInfo$getVoiceSearchLaunchRecognizer(), this);
    }

    public int getVoiceLanguageModeId() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceLanguageModeId", $$robo$$android_app_SearchableInfo$getVoiceLanguageModeId(), this);
    }

    public int getVoicePromptTextId() {
        return (int)InvokeDynamicSupport.bootstrap("getVoicePromptTextId", $$robo$$android_app_SearchableInfo$getVoicePromptTextId(), this);
    }

    public int getVoiceLanguageId() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceLanguageId", $$robo$$android_app_SearchableInfo$getVoiceLanguageId(), this);
    }

    public int getVoiceMaxResults() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceMaxResults", $$robo$$android_app_SearchableInfo$getVoiceMaxResults(), this);
    }

    public int getSearchButtonText() {
        return (int)InvokeDynamicSupport.bootstrap("getSearchButtonText", $$robo$$android_app_SearchableInfo$getSearchButtonText(), this);
    }

    public int getInputType() {
        return (int)InvokeDynamicSupport.bootstrap("getInputType", $$robo$$android_app_SearchableInfo$getInputType(), this);
    }

    public int getImeOptions() {
        return (int)InvokeDynamicSupport.bootstrap("getImeOptions", $$robo$$android_app_SearchableInfo$getImeOptions(), this);
    }

    public boolean shouldIncludeInGlobalSearch() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldIncludeInGlobalSearch", $$robo$$android_app_SearchableInfo$shouldIncludeInGlobalSearch(), this);
    }

    public boolean queryAfterZeroResults() {
        return (boolean)InvokeDynamicSupport.bootstrap("queryAfterZeroResults", $$robo$$android_app_SearchableInfo$queryAfterZeroResults(), this);
    }

    public boolean autoUrlDetect() {
        return (boolean)InvokeDynamicSupport.bootstrap("autoUrlDetect", $$robo$$android_app_SearchableInfo$autoUrlDetect(), this);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_app_SearchableInfo$__constructor__(parcel);
    }

    public SearchableInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchableInfo$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_SearchableInfo$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_SearchableInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(SearchableInfo.class);
    }

    public /* synthetic */ SearchableInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SearchableInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ActionKeyInfo
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mKeyCode;
        private String mQueryActionMsg;
        private String mSuggestActionMsg;
        private String mSuggestActionMsgColumn;

        private void $$robo$$android_app_SearchableInfo_ActionKeyInfo$__constructor__(Context activityContext, AttributeSet attr2) {
            TypedArray a = activityContext.obtainStyledAttributes(attr2, R.styleable.SearchableActionKey);
            this.mKeyCode = a.getInt(0, 0);
            this.mQueryActionMsg = a.getString(1);
            this.mSuggestActionMsg = a.getString(2);
            this.mSuggestActionMsgColumn = a.getString(3);
            a.recycle();
            if (this.mKeyCode == 0) {
                throw new IllegalArgumentException("No keycode.");
            }
            if (this.mQueryActionMsg == null && this.mSuggestActionMsg == null && this.mSuggestActionMsgColumn == null) {
                throw new IllegalArgumentException("No message information.");
            }
        }

        private void $$robo$$android_app_SearchableInfo_ActionKeyInfo$__constructor__(Parcel in) {
            this.mKeyCode = in.readInt();
            this.mQueryActionMsg = in.readString();
            this.mSuggestActionMsg = in.readString();
            this.mSuggestActionMsgColumn = in.readString();
        }

        private final int $$robo$$android_app_SearchableInfo_ActionKeyInfo$getKeyCode() {
            return this.mKeyCode;
        }

        private final String $$robo$$android_app_SearchableInfo_ActionKeyInfo$getQueryActionMsg() {
            return this.mQueryActionMsg;
        }

        private final String $$robo$$android_app_SearchableInfo_ActionKeyInfo$getSuggestActionMsg() {
            return this.mSuggestActionMsg;
        }

        private final String $$robo$$android_app_SearchableInfo_ActionKeyInfo$getSuggestActionMsgColumn() {
            return this.mSuggestActionMsgColumn;
        }

        private final int $$robo$$android_app_SearchableInfo_ActionKeyInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_SearchableInfo_ActionKeyInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mKeyCode);
            dest.writeString(this.mQueryActionMsg);
            dest.writeString(this.mSuggestActionMsg);
            dest.writeString(this.mSuggestActionMsgColumn);
        }

        private /* synthetic */ void $$robo$$android_app_SearchableInfo_ActionKeyInfo$__constructor__(Parcel x0, 1 x1) {
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_app_SearchableInfo_ActionKeyInfo$__constructor__(context, attributeSet);
        }

        public ActionKeyInfo(Context context, AttributeSet attributeSet) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchableInfo_ActionKeyInfo$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_SearchableInfo_ActionKeyInfo$__constructor__(parcel);
        }

        public ActionKeyInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchableInfo_ActionKeyInfo$__constructor__(android.os.Parcel ), this, parcel);
        }

        public int getKeyCode() {
            return (int)InvokeDynamicSupport.bootstrap("getKeyCode", $$robo$$android_app_SearchableInfo_ActionKeyInfo$getKeyCode(), this);
        }

        public String getQueryActionMsg() {
            return InvokeDynamicSupport.bootstrap("getQueryActionMsg", $$robo$$android_app_SearchableInfo_ActionKeyInfo$getQueryActionMsg(), this);
        }

        public String getSuggestActionMsg() {
            return InvokeDynamicSupport.bootstrap("getSuggestActionMsg", $$robo$$android_app_SearchableInfo_ActionKeyInfo$getSuggestActionMsg(), this);
        }

        public String getSuggestActionMsgColumn() {
            return InvokeDynamicSupport.bootstrap("getSuggestActionMsgColumn", $$robo$$android_app_SearchableInfo_ActionKeyInfo$getSuggestActionMsgColumn(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_SearchableInfo_ActionKeyInfo$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_SearchableInfo_ActionKeyInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_SearchableInfo_ActionKeyInfo$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ ActionKeyInfo(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchableInfo_ActionKeyInfo$__constructor__(android.os.Parcel android.app.SearchableInfo$1 ), this, parcel, var2_2);
        }

        public /* synthetic */ ActionKeyInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionKeyInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

