/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.ApplicationPackageManager;
import android.app.IActivityManager;
import android.app.IApplicationThread;
import android.app.IServiceConnection;
import android.app.Instrumentation;
import android.app.LoadedApk;
import android.app.ReceiverRestrictedContext;
import android.app.ResourcesManager;
import android.app.SharedPreferencesImpl;
import android.app.SystemServiceRegistry;
import android.app.WallpaperManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.IContentProvider;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.CompatResources;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Debug;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.AndroidRuntimeException;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.autofill.AutofillManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executor;
import libcore.io.Memory;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ContextImpl
extends Context
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ContextImpl";
    private static boolean DEBUG = false;
    private static String XATTR_INODE_CACHE = "user.inode_cache";
    private static String XATTR_INODE_CODE_CACHE = "user.inode_code_cache";
    @GuardedBy(value="ContextImpl.class")
    private static ArrayMap<String, ArrayMap<File, SharedPreferencesImpl>> sSharedPrefsCache;
    @GuardedBy(value="ContextImpl.class")
    private ArrayMap<String, File> mSharedPrefsPaths;
    ActivityThread mMainThread;
    LoadedApk mPackageInfo;
    private ClassLoader mClassLoader;
    private IBinder mActivityToken;
    private UserHandle mUser;
    private ApplicationContentResolver mContentResolver;
    private String mBasePackageName;
    private String mOpPackageName;
    private ResourcesManager mResourcesManager;
    private Resources mResources;
    private Display mDisplay;
    private int mFlags;
    private Context mOuterContext;
    private int mThemeResource;
    private Resources.Theme mTheme;
    private PackageManager mPackageManager;
    private Context mReceiverRestrictedContext;
    private String mSplitName;
    private AutofillManager.AutofillClient mAutofillClient;
    private boolean mIsAutofillCompatEnabled;
    private Object mSync;
    @GuardedBy(value="mSync")
    private File mDatabasesDir;
    @GuardedBy(value="mSync")
    private File mPreferencesDir;
    @GuardedBy(value="mSync")
    private File mFilesDir;
    @GuardedBy(value="mSync")
    private File mNoBackupFilesDir;
    @GuardedBy(value="mSync")
    private File mCacheDir;
    @GuardedBy(value="mSync")
    private File mCodeCacheDir;
    Object[] mServiceCache;
    static int STATE_UNINITIALIZED = 0;
    static int STATE_INITIALIZING = 1;
    static int STATE_READY = 2;
    static int STATE_NOT_FOUND = 3;
    int[] mServiceInitializationStateArray;

    private static final ContextImpl $$robo$$android_app_ContextImpl$getImpl(Context context) {
        Context nextContext;
        while (context instanceof ContextWrapper && (nextContext = ((ContextWrapper)context).getBaseContext()) != null) {
            context = nextContext;
        }
        return (ContextImpl)context;
    }

    private final AssetManager $$robo$$android_app_ContextImpl$getAssets() {
        return this.getResources().getAssets();
    }

    private final Resources $$robo$$android_app_ContextImpl$getResources() {
        return this.mResources;
    }

    private final PackageManager $$robo$$android_app_ContextImpl$getPackageManager() {
        if (this.mPackageManager != null) {
            return this.mPackageManager;
        }
        IPackageManager pm = ActivityThread.getPackageManager();
        if (pm != null) {
            this.mPackageManager = new ApplicationPackageManager(this, pm);
            return this.mPackageManager;
        }
        return null;
    }

    private final ContentResolver $$robo$$android_app_ContextImpl$getContentResolver() {
        return this.mContentResolver;
    }

    private final Looper $$robo$$android_app_ContextImpl$getMainLooper() {
        return this.mMainThread.getLooper();
    }

    private final Executor $$robo$$android_app_ContextImpl$getMainExecutor() {
        return this.mMainThread.getExecutor();
    }

    private final Context $$robo$$android_app_ContextImpl$getApplicationContext() {
        return this.mPackageInfo != null ? this.mPackageInfo.getApplication() : this.mMainThread.getApplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ContextImpl$setTheme(int resId) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mThemeResource != resId) {
                this.mThemeResource = resId;
                this.initializeTheme();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_app_ContextImpl$getThemeResId() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mThemeResource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Resources.Theme $$robo$$android_app_ContextImpl$getTheme() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mTheme != null) {
                return this.mTheme;
            }
            this.mThemeResource = Resources.selectDefaultTheme(this.mThemeResource, this.getOuterContext().getApplicationInfo().targetSdkVersion);
            this.initializeTheme();
            return this.mTheme;
        }
    }

    private final void $$robo$$android_app_ContextImpl$initializeTheme() {
        if (this.mTheme == null) {
            this.mTheme = this.mResources.newTheme();
        }
        this.mTheme.applyStyle(this.mThemeResource, true);
    }

    private final ClassLoader $$robo$$android_app_ContextImpl$getClassLoader() {
        return this.mClassLoader != null ? this.mClassLoader : (this.mPackageInfo != null ? this.mPackageInfo.getClassLoader() : ClassLoader.getSystemClassLoader());
    }

    private final String $$robo$$android_app_ContextImpl$getPackageName() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getPackageName();
        }
        return "android";
    }

    private final String $$robo$$android_app_ContextImpl$getBasePackageName() {
        return this.mBasePackageName != null ? this.mBasePackageName : this.getPackageName();
    }

    private final String $$robo$$android_app_ContextImpl$getOpPackageName() {
        return this.mOpPackageName != null ? this.mOpPackageName : this.getBasePackageName();
    }

    private final ApplicationInfo $$robo$$android_app_ContextImpl$getApplicationInfo() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getApplicationInfo();
        }
        throw new RuntimeException("Not supported in system context");
    }

    private final String $$robo$$android_app_ContextImpl$getPackageResourcePath() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getResDir();
        }
        throw new RuntimeException("Not supported in system context");
    }

    private final String $$robo$$android_app_ContextImpl$getPackageCodePath() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getAppDir();
        }
        throw new RuntimeException("Not supported in system context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SharedPreferences $$robo$$android_app_ContextImpl$getSharedPreferences(String name, int mode) {
        if (this.mPackageInfo.getApplicationInfo().targetSdkVersion < 19 && name == null) {
            name = "null";
        }
        Class<ContextImpl> clazz = ContextImpl.class;
        synchronized (ContextImpl.class) {
            File file;
            if (this.mSharedPrefsPaths == null) {
                this.mSharedPrefsPaths = new ArrayMap();
            }
            if ((file = this.mSharedPrefsPaths.get(name)) == null) {
                file = this.getSharedPreferencesPath(name);
                this.mSharedPrefsPaths.put(name, file);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return this.getSharedPreferences(file, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SharedPreferences $$robo$$android_app_ContextImpl$getSharedPreferences(File file, int mode) {
        Class<ContextImpl> clazz = ContextImpl.class;
        synchronized (ContextImpl.class) {
            ArrayMap<File, SharedPreferencesImpl> cache = this.getSharedPreferencesCacheLocked();
            SharedPreferencesImpl sp = cache.get(file);
            if (sp == null) {
                this.checkMode(mode);
                if (this.getApplicationInfo().targetSdkVersion >= 26 && this.isCredentialProtectedStorage() && !this.getSystemService(UserManager.class).isUserUnlockingOrUnlocked(UserHandle.myUserId())) {
                    throw new IllegalStateException("SharedPreferences in credential encrypted storage are not available until after user is unlocked");
                }
                sp = new SharedPreferencesImpl(file, mode);
                cache.put(file, sp);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return sp;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if ((mode & 4) != 0 || this.getApplicationInfo().targetSdkVersion < 11) {
                sp.startReloadIfChangedUnexpectedly();
            }
            return sp;
        }
    }

    @GuardedBy(value="ContextImpl.class")
    private final ArrayMap<File, SharedPreferencesImpl> $$robo$$android_app_ContextImpl$getSharedPreferencesCacheLocked() {
        String packageName;
        ArrayMap<File, SharedPreferencesImpl> packagePrefs;
        if (sSharedPrefsCache == null) {
            sSharedPrefsCache = new ArrayMap();
        }
        if ((packagePrefs = sSharedPrefsCache.get(packageName = this.getPackageName())) == null) {
            packagePrefs = new ArrayMap();
            sSharedPrefsCache.put(packageName, packagePrefs);
        }
        return packagePrefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ContextImpl$reloadSharedPreferences() {
        ArrayList<SharedPreferencesImpl> spImpls = new ArrayList<SharedPreferencesImpl>();
        Class<ContextImpl> clazz = ContextImpl.class;
        synchronized (ContextImpl.class) {
            ArrayMap<File, SharedPreferencesImpl> cache = this.getSharedPreferencesCacheLocked();
            for (int i = 0; i < cache.size(); ++i) {
                SharedPreferencesImpl sp = cache.valueAt(i);
                if (sp == null) continue;
                spImpls.add(sp);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (int i = 0; i < spImpls.size(); ++i) {
                ((SharedPreferencesImpl)spImpls.get(i)).startReloadIfChangedUnexpectedly();
            }
            return;
        }
    }

    private static final int $$robo$$android_app_ContextImpl$moveFiles(File sourceDir, File targetDir, String prefix) {
        File[] sourceFiles = FileUtils.listFilesOrEmpty(sourceDir, new FilenameFilter(prefix){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$prefix;

            private void $$robo$$android_app_ContextImpl_1$__constructor__(String string2) {
                this.val$prefix = string2;
            }

            private final boolean $$robo$$android_app_ContextImpl_1$accept(File dir, String name) {
                return name.startsWith(this.val$prefix);
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_app_ContextImpl_1$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ContextImpl_1$__constructor__(java.lang.String ), this, string2);
            }

            @Override
            public boolean accept(File file, String string2) {
                return (boolean)InvokeDynamicSupport.bootstrap("accept", $$robo$$android_app_ContextImpl_1$accept(java.io.File java.lang.String ), this, file, string2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        int res = 0;
        for (File sourceFile : sourceFiles) {
            File targetFile = new File(targetDir, sourceFile.getName());
            Log.d("ContextImpl", "Migrating " + sourceFile + " to " + targetFile);
            try {
                FileUtils.copyFileOrThrow(sourceFile, targetFile);
                FileUtils.copyPermissions(sourceFile, targetFile);
                if (!sourceFile.delete()) {
                    throw new IOException("Failed to clean up " + sourceFile);
                }
                if (res == -1) continue;
                ++res;
            }
            catch (IOException e) {
                Log.w("ContextImpl", "Failed to migrate " + sourceFile + ": " + e);
                res = -1;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_ContextImpl$moveSharedPreferencesFrom(Context sourceContext, String name) {
        Class<ContextImpl> clazz = ContextImpl.class;
        synchronized (ContextImpl.class) {
            File source = sourceContext.getSharedPreferencesPath(name);
            File target = this.getSharedPreferencesPath(name);
            int res = ContextImpl.moveFiles(source.getParentFile(), target.getParentFile(), source.getName());
            if (res > 0) {
                ArrayMap<File, SharedPreferencesImpl> cache = this.getSharedPreferencesCacheLocked();
                cache.remove(source);
                cache.remove(target);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return res != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_ContextImpl$deleteSharedPreferences(String name) {
        Class<ContextImpl> clazz = ContextImpl.class;
        synchronized (ContextImpl.class) {
            File prefs = this.getSharedPreferencesPath(name);
            File prefsBackup = SharedPreferencesImpl.makeBackupFile(prefs);
            ArrayMap<File, SharedPreferencesImpl> cache = this.getSharedPreferencesCacheLocked();
            cache.remove(prefs);
            prefs.delete();
            prefsBackup.delete();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return !prefs.exists() && !prefsBackup.exists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File $$robo$$android_app_ContextImpl$getPreferencesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mPreferencesDir == null) {
                this.mPreferencesDir = new File(this.getDataDir(), "shared_prefs");
            }
            return ContextImpl.ensurePrivateDirExists(this.mPreferencesDir);
        }
    }

    private final FileInputStream $$robo$$android_app_ContextImpl$openFileInput(String name) throws FileNotFoundException {
        File f = this.makeFilename(this.getFilesDir(), name);
        return new FileInputStream(f);
    }

    private final FileOutputStream $$robo$$android_app_ContextImpl$openFileOutput(String name, int mode) throws FileNotFoundException {
        this.checkMode(mode);
        boolean append = (mode & 0x8000) != 0;
        File f = this.makeFilename(this.getFilesDir(), name);
        try {
            FileOutputStream fos = new FileOutputStream(f, append);
            ContextImpl.setFilePermissionsFromMode(f.getPath(), mode, 0);
            return fos;
        }
        catch (FileNotFoundException fos) {
            File parent = f.getParentFile();
            parent.mkdir();
            FileUtils.setPermissions(parent.getPath(), 505, -1, -1);
            FileOutputStream fos2 = new FileOutputStream(f, append);
            ContextImpl.setFilePermissionsFromMode(f.getPath(), mode, 0);
            return fos2;
        }
    }

    private final boolean $$robo$$android_app_ContextImpl$deleteFile(String name) {
        File f = this.makeFilename(this.getFilesDir(), name);
        return f.delete();
    }

    private static final File $$robo$$android_app_ContextImpl$ensurePrivateDirExists(File file) {
        return ContextImpl.ensurePrivateDirExists(file, 505, -1, null);
    }

    private static final File $$robo$$android_app_ContextImpl$ensurePrivateCacheDirExists(File file, String xattr) {
        int gid = UserHandle.getCacheAppGid(Process.myUid());
        return ContextImpl.ensurePrivateDirExists(file, 1529, gid, xattr);
    }

    private static final File $$robo$$android_app_ContextImpl$ensurePrivateDirExists(File file, int mode, int gid, String xattr) {
        if (!file.exists()) {
            block7: {
                String path = file.getAbsolutePath();
                try {
                    Os.mkdir(path, mode);
                    Os.chmod(path, mode);
                    if (gid != -1) {
                        Os.chown(path, -1, gid);
                    }
                }
                catch (ErrnoException e) {
                    if (e.errno == OsConstants.EEXIST) break block7;
                    Log.w("ContextImpl", "Failed to ensure " + file + ": " + e.getMessage());
                }
            }
            if (xattr != null) {
                try {
                    StructStat stat = Os.stat(file.getAbsolutePath());
                    byte[] value = new byte[8];
                    Memory.pokeLong(value, 0, stat.st_ino, ByteOrder.nativeOrder());
                    Os.setxattr(file.getParentFile().getAbsolutePath(), xattr, value, 0);
                }
                catch (ErrnoException e) {
                    Log.w("ContextImpl", "Failed to update " + xattr + ": " + e.getMessage());
                }
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File $$robo$$android_app_ContextImpl$getFilesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mFilesDir == null) {
                this.mFilesDir = new File(this.getDataDir(), "files");
            }
            return ContextImpl.ensurePrivateDirExists(this.mFilesDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File $$robo$$android_app_ContextImpl$getNoBackupFilesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mNoBackupFilesDir == null) {
                this.mNoBackupFilesDir = new File(this.getDataDir(), "no_backup");
            }
            return ContextImpl.ensurePrivateDirExists(this.mNoBackupFilesDir);
        }
    }

    private final File $$robo$$android_app_ContextImpl$getExternalFilesDir(String type) {
        File[] dirs = this.getExternalFilesDirs(type);
        return dirs != null && dirs.length > 0 ? dirs[0] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File[] $$robo$$android_app_ContextImpl$getExternalFilesDirs(String type) {
        Object object = this.mSync;
        synchronized (object) {
            File[] dirs = Environment.buildExternalStorageAppFilesDirs(this.getPackageName());
            if (type != null) {
                dirs = Environment.buildPaths(dirs, type);
            }
            return this.ensureExternalDirsExistOrFilter(dirs);
        }
    }

    private final File $$robo$$android_app_ContextImpl$getObbDir() {
        File[] dirs = this.getObbDirs();
        return dirs != null && dirs.length > 0 ? dirs[0] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File[] $$robo$$android_app_ContextImpl$getObbDirs() {
        Object object = this.mSync;
        synchronized (object) {
            File[] dirs = Environment.buildExternalStorageAppObbDirs(this.getPackageName());
            return this.ensureExternalDirsExistOrFilter(dirs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File $$robo$$android_app_ContextImpl$getCacheDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mCacheDir == null) {
                this.mCacheDir = new File(this.getDataDir(), "cache");
            }
            return ContextImpl.ensurePrivateCacheDirExists(this.mCacheDir, "user.inode_cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File $$robo$$android_app_ContextImpl$getCodeCacheDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mCodeCacheDir == null) {
                this.mCodeCacheDir = new File(this.getDataDir(), "code_cache");
            }
            return ContextImpl.ensurePrivateCacheDirExists(this.mCodeCacheDir, "user.inode_code_cache");
        }
    }

    private final File $$robo$$android_app_ContextImpl$getExternalCacheDir() {
        File[] dirs = this.getExternalCacheDirs();
        return dirs != null && dirs.length > 0 ? dirs[0] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File[] $$robo$$android_app_ContextImpl$getExternalCacheDirs() {
        Object object = this.mSync;
        synchronized (object) {
            File[] dirs = Environment.buildExternalStorageAppCacheDirs(this.getPackageName());
            return this.ensureExternalDirsExistOrFilter(dirs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File[] $$robo$$android_app_ContextImpl$getExternalMediaDirs() {
        Object object = this.mSync;
        synchronized (object) {
            File[] dirs = Environment.buildExternalStorageAppMediaDirs(this.getPackageName());
            return this.ensureExternalDirsExistOrFilter(dirs);
        }
    }

    private final File $$robo$$android_app_ContextImpl$getPreloadsFileCache() {
        return Environment.getDataPreloadsFileCacheDirectory(this.getPackageName());
    }

    private final File $$robo$$android_app_ContextImpl$getFileStreamPath(String name) {
        return this.makeFilename(this.getFilesDir(), name);
    }

    private final File $$robo$$android_app_ContextImpl$getSharedPreferencesPath(String name) {
        return this.makeFilename(this.getPreferencesDir(), name + ".xml");
    }

    private final String[] $$robo$$android_app_ContextImpl$fileList() {
        return FileUtils.listOrEmpty(this.getFilesDir());
    }

    private final SQLiteDatabase $$robo$$android_app_ContextImpl$openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        return this.openOrCreateDatabase(name, mode, factory, null);
    }

    private final SQLiteDatabase $$robo$$android_app_ContextImpl$openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
        this.checkMode(mode);
        File f = this.getDatabasePath(name);
        int flags = 0x10000000;
        if ((mode & 8) != 0) {
            flags |= 0x20000000;
        }
        if ((mode & 0x10) != 0) {
            flags |= 0x10;
        }
        SQLiteDatabase db = SQLiteDatabase.openDatabase(f.getPath(), factory, flags, errorHandler);
        ContextImpl.setFilePermissionsFromMode(f.getPath(), mode, 0);
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_ContextImpl$moveDatabaseFrom(Context sourceContext, String name) {
        Class<ContextImpl> clazz = ContextImpl.class;
        synchronized (ContextImpl.class) {
            File source = sourceContext.getDatabasePath(name);
            File target = this.getDatabasePath(name);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ContextImpl.moveFiles(source.getParentFile(), target.getParentFile(), source.getName()) != -1;
        }
    }

    private final boolean $$robo$$android_app_ContextImpl$deleteDatabase(String name) {
        try {
            File f = this.getDatabasePath(name);
            return SQLiteDatabase.deleteDatabase(f);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private final File $$robo$$android_app_ContextImpl$getDatabasePath(String name) {
        File f;
        if (name.charAt(0) == File.separatorChar) {
            String dirPath = name.substring(0, name.lastIndexOf(File.separatorChar));
            File dir = new File(dirPath);
            name = name.substring(name.lastIndexOf(File.separatorChar));
            f = new File(dir, name);
            if (!dir.isDirectory() && dir.mkdir()) {
                FileUtils.setPermissions(dir.getPath(), 505, -1, -1);
            }
        } else {
            File dir = this.getDatabasesDir();
            f = this.makeFilename(dir, name);
        }
        return f;
    }

    private final String[] $$robo$$android_app_ContextImpl$databaseList() {
        return FileUtils.listOrEmpty(this.getDatabasesDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File $$robo$$android_app_ContextImpl$getDatabasesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDatabasesDir == null) {
                this.mDatabasesDir = "android".equals(this.getPackageName()) ? new File("/data/system") : new File(this.getDataDir(), "databases");
            }
            return ContextImpl.ensurePrivateDirExists(this.mDatabasesDir);
        }
    }

    @Deprecated
    private final Drawable $$robo$$android_app_ContextImpl$getWallpaper() {
        return this.getWallpaperManager().getDrawable();
    }

    @Deprecated
    private final Drawable $$robo$$android_app_ContextImpl$peekWallpaper() {
        return this.getWallpaperManager().peekDrawable();
    }

    @Deprecated
    private final int $$robo$$android_app_ContextImpl$getWallpaperDesiredMinimumWidth() {
        return this.getWallpaperManager().getDesiredMinimumWidth();
    }

    @Deprecated
    private final int $$robo$$android_app_ContextImpl$getWallpaperDesiredMinimumHeight() {
        return this.getWallpaperManager().getDesiredMinimumHeight();
    }

    @Deprecated
    private final void $$robo$$android_app_ContextImpl$setWallpaper(Bitmap bitmap) throws IOException {
        this.getWallpaperManager().setBitmap(bitmap);
    }

    @Deprecated
    private final void $$robo$$android_app_ContextImpl$setWallpaper(InputStream data) throws IOException {
        this.getWallpaperManager().setStream(data);
    }

    @Deprecated
    private final void $$robo$$android_app_ContextImpl$clearWallpaper() throws IOException {
        this.getWallpaperManager().clear();
    }

    private final WallpaperManager $$robo$$android_app_ContextImpl$getWallpaperManager() {
        return this.getSystemService(WallpaperManager.class);
    }

    private final void $$robo$$android_app_ContextImpl$startActivity(Intent intent) {
        this.warnIfCallingFromSystemProcess();
        this.startActivity(intent, null);
    }

    private final void $$robo$$android_app_ContextImpl$startActivityAsUser(Intent intent, UserHandle user) {
        this.startActivityAsUser(intent, null, user);
    }

    private final void $$robo$$android_app_ContextImpl$startActivity(Intent intent, Bundle options) {
        this.warnIfCallingFromSystemProcess();
        int targetSdkVersion = this.getApplicationInfo().targetSdkVersion;
        if (!((intent.getFlags() & 0x10000000) != 0 || targetSdkVersion >= 24 && targetSdkVersion < 28 || options != null && ActivityOptions.fromBundle(options).getLaunchTaskId() != -1)) {
            throw new AndroidRuntimeException("Calling startActivity() from outside of an Activity  context requires the FLAG_ACTIVITY_NEW_TASK flag. Is this really what you want?");
        }
        this.mMainThread.getInstrumentation().execStartActivity(this.getOuterContext(), (IBinder)this.mMainThread.getApplicationThread(), null, (Activity)null, intent, -1, options);
    }

    private final void $$robo$$android_app_ContextImpl$startActivityAsUser(Intent intent, Bundle options, UserHandle user) {
        try {
            ActivityManager.getService().startActivityAsUser(this.mMainThread.getApplicationThread(), this.getBasePackageName(), intent, intent.resolveTypeIfNeeded(this.getContentResolver()), null, null, 0, 0x10000000, null, options, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$startActivities(Intent[] intents) {
        this.warnIfCallingFromSystemProcess();
        this.startActivities(intents, null);
    }

    private final int $$robo$$android_app_ContextImpl$startActivitiesAsUser(Intent[] intents, Bundle options, UserHandle userHandle) {
        if ((intents[0].getFlags() & 0x10000000) == 0) {
            throw new AndroidRuntimeException("Calling startActivities() from outside of an Activity  context requires the FLAG_ACTIVITY_NEW_TASK flag on first Intent. Is this really what you want?");
        }
        return this.mMainThread.getInstrumentation().execStartActivitiesAsUser(this.getOuterContext(), this.mMainThread.getApplicationThread(), null, null, intents, options, userHandle.getIdentifier());
    }

    private final void $$robo$$android_app_ContextImpl$startActivities(Intent[] intents, Bundle options) {
        this.warnIfCallingFromSystemProcess();
        if ((intents[0].getFlags() & 0x10000000) == 0) {
            throw new AndroidRuntimeException("Calling startActivities() from outside of an Activity  context requires the FLAG_ACTIVITY_NEW_TASK flag on first Intent. Is this really what you want?");
        }
        this.mMainThread.getInstrumentation().execStartActivities(this.getOuterContext(), this.mMainThread.getApplicationThread(), null, null, intents, options);
    }

    private final void $$robo$$android_app_ContextImpl$startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) throws IntentSender.SendIntentException {
        this.startIntentSender(intent, fillInIntent, flagsMask, flagsValues, extraFlags, null);
    }

    private final void $$robo$$android_app_ContextImpl$startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
        try {
            int result;
            String resolvedType = null;
            if (fillInIntent != null) {
                fillInIntent.migrateExtraStreamToClipData();
                fillInIntent.prepareToLeaveProcess(this);
                resolvedType = fillInIntent.resolveTypeIfNeeded(this.getContentResolver());
            }
            if ((result = ActivityManager.getService().startActivityIntentSender(this.mMainThread.getApplicationThread(), intent != null ? intent.getTarget() : null, intent != null ? intent.getWhitelistToken() : null, fillInIntent, resolvedType, null, null, 0, flagsMask, flagsValues, options)) == -96) {
                throw new IntentSender.SendIntentException();
            }
            Instrumentation.checkStartActivityResult(result, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$sendBroadcast(Intent intent) {
        this.warnIfCallingFromSystemProcess();
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, null, -1, null, false, false, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$sendBroadcast(Intent intent, String receiverPermission) {
        String[] stringArray;
        this.warnIfCallingFromSystemProcess();
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (receiverPermission == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = receiverPermission;
        }
        String[] receiverPermissions = stringArray;
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, receiverPermissions, -1, null, false, false, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$sendBroadcastMultiplePermissions(Intent intent, String[] receiverPermissions) {
        this.warnIfCallingFromSystemProcess();
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, receiverPermissions, -1, null, false, false, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$sendBroadcastAsUserMultiplePermissions(Intent intent, UserHandle user, String[] receiverPermissions) {
        this.warnIfCallingFromSystemProcess();
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, receiverPermissions, -1, null, false, false, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$sendBroadcast(Intent intent, String receiverPermission, Bundle options) {
        String[] stringArray;
        this.warnIfCallingFromSystemProcess();
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (receiverPermission == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = receiverPermission;
        }
        String[] receiverPermissions = stringArray;
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, receiverPermissions, -1, options, false, false, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$sendBroadcast(Intent intent, String receiverPermission, int appOp) {
        String[] stringArray;
        this.warnIfCallingFromSystemProcess();
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (receiverPermission == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = receiverPermission;
        }
        String[] receiverPermissions = stringArray;
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, receiverPermissions, appOp, null, false, false, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$sendOrderedBroadcast(Intent intent, String receiverPermission) {
        String[] stringArray;
        this.warnIfCallingFromSystemProcess();
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (receiverPermission == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = receiverPermission;
        }
        String[] receiverPermissions = stringArray;
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, receiverPermissions, -1, null, true, false, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$sendOrderedBroadcast(Intent intent, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        this.sendOrderedBroadcast(intent, receiverPermission, -1, resultReceiver, scheduler, initialCode, initialData, initialExtras, null);
    }

    private final void $$robo$$android_app_ContextImpl$sendOrderedBroadcast(Intent intent, String receiverPermission, Bundle options, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        this.sendOrderedBroadcast(intent, receiverPermission, -1, resultReceiver, scheduler, initialCode, initialData, initialExtras, options);
    }

    private final void $$robo$$android_app_ContextImpl$sendOrderedBroadcast(Intent intent, String receiverPermission, int appOp, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        this.sendOrderedBroadcast(intent, receiverPermission, appOp, resultReceiver, scheduler, initialCode, initialData, initialExtras, null);
    }

    private final void $$robo$$android_app_ContextImpl$sendOrderedBroadcast(Intent intent, String receiverPermission, int appOp, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras, Bundle options) {
        String[] stringArray;
        this.warnIfCallingFromSystemProcess();
        IIntentReceiver rd = null;
        if (resultReceiver != null) {
            if (this.mPackageInfo != null) {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = this.mPackageInfo.getReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, this.mMainThread.getInstrumentation(), false);
            } else {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = new LoadedApk.ReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, null, false).getIIntentReceiver();
            }
        }
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (receiverPermission == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = receiverPermission;
        }
        String[] receiverPermissions = stringArray;
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, rd, initialCode, initialData, initialExtras, receiverPermissions, appOp, options, true, false, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$sendBroadcastAsUser(Intent intent, UserHandle user) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, null, -1, null, false, false, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$sendBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission) {
        this.sendBroadcastAsUser(intent, user, receiverPermission, -1);
    }

    private final void $$robo$$android_app_ContextImpl$sendBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, Bundle options) {
        String[] stringArray;
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (receiverPermission == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = receiverPermission;
        }
        String[] receiverPermissions = stringArray;
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, receiverPermissions, -1, options, false, false, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$sendBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, int appOp) {
        String[] stringArray;
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (receiverPermission == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = receiverPermission;
        }
        String[] receiverPermissions = stringArray;
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, receiverPermissions, appOp, null, false, false, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$sendOrderedBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        this.sendOrderedBroadcastAsUser(intent, user, receiverPermission, -1, null, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    private final void $$robo$$android_app_ContextImpl$sendOrderedBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, int appOp, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        this.sendOrderedBroadcastAsUser(intent, user, receiverPermission, appOp, null, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    private final void $$robo$$android_app_ContextImpl$sendOrderedBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, int appOp, Bundle options, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        String[] stringArray;
        IIntentReceiver rd = null;
        if (resultReceiver != null) {
            if (this.mPackageInfo != null) {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = this.mPackageInfo.getReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, this.mMainThread.getInstrumentation(), false);
            } else {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = new LoadedApk.ReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, null, false).getIIntentReceiver();
            }
        }
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (receiverPermission == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = receiverPermission;
        }
        String[] receiverPermissions = stringArray;
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, rd, initialCode, initialData, initialExtras, receiverPermissions, appOp, options, true, false, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_app_ContextImpl$sendStickyBroadcast(Intent intent) {
        this.warnIfCallingFromSystemProcess();
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, null, -1, null, false, true, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_app_ContextImpl$sendStickyOrderedBroadcast(Intent intent, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        this.warnIfCallingFromSystemProcess();
        IIntentReceiver rd = null;
        if (resultReceiver != null) {
            if (this.mPackageInfo != null) {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = this.mPackageInfo.getReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, this.mMainThread.getInstrumentation(), false);
            } else {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = new LoadedApk.ReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, null, false).getIIntentReceiver();
            }
        }
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, rd, initialCode, initialData, initialExtras, null, -1, null, true, true, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_app_ContextImpl$removeStickyBroadcast(Intent intent) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (resolvedType != null) {
            intent = new Intent(intent);
            intent.setDataAndType(intent.getData(), resolvedType);
        }
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().unbroadcastIntent(this.mMainThread.getApplicationThread(), intent, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_app_ContextImpl$sendStickyBroadcastAsUser(Intent intent, UserHandle user) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, null, -1, null, false, true, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_app_ContextImpl$sendStickyBroadcastAsUser(Intent intent, UserHandle user, Bundle options) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, null, -1, options, false, true, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_app_ContextImpl$sendStickyOrderedBroadcastAsUser(Intent intent, UserHandle user, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        IIntentReceiver rd = null;
        if (resultReceiver != null) {
            if (this.mPackageInfo != null) {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = this.mPackageInfo.getReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, this.mMainThread.getInstrumentation(), false);
            } else {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = new LoadedApk.ReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, null, false).getIIntentReceiver();
            }
        }
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, rd, initialCode, initialData, initialExtras, null, -1, null, true, true, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_app_ContextImpl$removeStickyBroadcastAsUser(Intent intent, UserHandle user) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (resolvedType != null) {
            intent = new Intent(intent);
            intent.setDataAndType(intent.getData(), resolvedType);
        }
        try {
            intent.prepareToLeaveProcess(this);
            ActivityManager.getService().unbroadcastIntent(this.mMainThread.getApplicationThread(), intent, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Intent $$robo$$android_app_ContextImpl$registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        return this.registerReceiver(receiver, filter, null, null);
    }

    private final Intent $$robo$$android_app_ContextImpl$registerReceiver(BroadcastReceiver receiver, IntentFilter filter, int flags) {
        return this.registerReceiver(receiver, filter, null, null, flags);
    }

    private final Intent $$robo$$android_app_ContextImpl$registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return this.registerReceiverInternal(receiver, this.getUserId(), filter, broadcastPermission, scheduler, this.getOuterContext(), 0);
    }

    private final Intent $$robo$$android_app_ContextImpl$registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler, int flags) {
        return this.registerReceiverInternal(receiver, this.getUserId(), filter, broadcastPermission, scheduler, this.getOuterContext(), flags);
    }

    private final Intent $$robo$$android_app_ContextImpl$registerReceiverAsUser(BroadcastReceiver receiver, UserHandle user, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return this.registerReceiverInternal(receiver, user.getIdentifier(), filter, broadcastPermission, scheduler, this.getOuterContext(), 0);
    }

    private final Intent $$robo$$android_app_ContextImpl$registerReceiverInternal(BroadcastReceiver receiver, int userId, IntentFilter filter, String broadcastPermission, Handler scheduler, Context context, int flags) {
        IIntentReceiver rd = null;
        if (receiver != null) {
            if (this.mPackageInfo != null && context != null) {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = this.mPackageInfo.getReceiverDispatcher(receiver, context, scheduler, this.mMainThread.getInstrumentation(), true);
            } else {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = new LoadedApk.ReceiverDispatcher(receiver, context, scheduler, null, true).getIIntentReceiver();
            }
        }
        try {
            Intent intent = ActivityManager.getService().registerReceiver(this.mMainThread.getApplicationThread(), this.mBasePackageName, rd, filter, broadcastPermission, userId, flags);
            if (intent != null) {
                intent.setExtrasClassLoader(this.getClassLoader());
                intent.prepareToEnterProcess();
            }
            return intent;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$unregisterReceiver(BroadcastReceiver receiver) {
        if (this.mPackageInfo != null) {
            IIntentReceiver rd = this.mPackageInfo.forgetReceiverDispatcher(this.getOuterContext(), receiver);
            try {
                ActivityManager.getService().unregisterReceiver(rd);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            throw new RuntimeException("Not supported in system context");
        }
    }

    private final void $$robo$$android_app_ContextImpl$validateServiceIntent(Intent service) {
        if (service.getComponent() == null && service.getPackage() == null) {
            if (this.getApplicationInfo().targetSdkVersion >= 21) {
                IllegalArgumentException ex = new IllegalArgumentException("Service Intent must be explicit: " + service);
                throw ex;
            }
            Log.w("ContextImpl", "Implicit intents with startService are not safe: " + service + " " + Debug.getCallers(2, 3));
        }
    }

    private final ComponentName $$robo$$android_app_ContextImpl$startService(Intent service) {
        this.warnIfCallingFromSystemProcess();
        return this.startServiceCommon(service, false, this.mUser);
    }

    private final ComponentName $$robo$$android_app_ContextImpl$startForegroundService(Intent service) {
        this.warnIfCallingFromSystemProcess();
        return this.startServiceCommon(service, true, this.mUser);
    }

    private final boolean $$robo$$android_app_ContextImpl$stopService(Intent service) {
        this.warnIfCallingFromSystemProcess();
        return this.stopServiceCommon(service, this.mUser);
    }

    private final ComponentName $$robo$$android_app_ContextImpl$startServiceAsUser(Intent service, UserHandle user) {
        return this.startServiceCommon(service, false, user);
    }

    private final ComponentName $$robo$$android_app_ContextImpl$startForegroundServiceAsUser(Intent service, UserHandle user) {
        return this.startServiceCommon(service, true, user);
    }

    private final ComponentName $$robo$$android_app_ContextImpl$startServiceCommon(Intent service, boolean requireForeground, UserHandle user) {
        try {
            this.validateServiceIntent(service);
            service.prepareToLeaveProcess(this);
            ComponentName cn = ActivityManager.getService().startService(this.mMainThread.getApplicationThread(), service, service.resolveTypeIfNeeded(this.getContentResolver()), requireForeground, this.getOpPackageName(), user.getIdentifier());
            if (cn != null) {
                if (cn.getPackageName().equals("!")) {
                    throw new SecurityException("Not allowed to start service " + service + " without permission " + cn.getClassName());
                }
                if (cn.getPackageName().equals("!!")) {
                    throw new SecurityException("Unable to start service " + service + ": " + cn.getClassName());
                }
                if (cn.getPackageName().equals("?")) {
                    throw new IllegalStateException("Not allowed to start service " + service + ": " + cn.getClassName());
                }
            }
            return cn;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ContextImpl$stopServiceAsUser(Intent service, UserHandle user) {
        return this.stopServiceCommon(service, user);
    }

    private final boolean $$robo$$android_app_ContextImpl$stopServiceCommon(Intent service, UserHandle user) {
        try {
            this.validateServiceIntent(service);
            service.prepareToLeaveProcess(this);
            int res = ActivityManager.getService().stopService(this.mMainThread.getApplicationThread(), service, service.resolveTypeIfNeeded(this.getContentResolver()), user.getIdentifier());
            if (res < 0) {
                throw new SecurityException("Not allowed to stop service " + service);
            }
            return res != 0;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ContextImpl$bindService(Intent service, ServiceConnection conn, int flags) {
        this.warnIfCallingFromSystemProcess();
        return this.bindServiceCommon(service, conn, flags, this.mMainThread.getHandler(), this.getUser());
    }

    private final boolean $$robo$$android_app_ContextImpl$bindServiceAsUser(Intent service, ServiceConnection conn, int flags, UserHandle user) {
        return this.bindServiceCommon(service, conn, flags, this.mMainThread.getHandler(), user);
    }

    private final boolean $$robo$$android_app_ContextImpl$bindServiceAsUser(Intent service, ServiceConnection conn, int flags, Handler handler, UserHandle user) {
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null.");
        }
        return this.bindServiceCommon(service, conn, flags, handler, user);
    }

    private final IServiceConnection $$robo$$android_app_ContextImpl$getServiceDispatcher(ServiceConnection conn, Handler handler, int flags) {
        return this.mPackageInfo.getServiceDispatcher(conn, this.getOuterContext(), handler, flags);
    }

    private final IApplicationThread $$robo$$android_app_ContextImpl$getIApplicationThread() {
        return this.mMainThread.getApplicationThread();
    }

    private final Handler $$robo$$android_app_ContextImpl$getMainThreadHandler() {
        return this.mMainThread.getHandler();
    }

    private final boolean $$robo$$android_app_ContextImpl$bindServiceCommon(Intent service, ServiceConnection conn, int flags, Handler handler, UserHandle user) {
        if (conn == null) {
            throw new IllegalArgumentException("connection is null");
        }
        if (this.mPackageInfo == null) {
            throw new RuntimeException("Not supported in system context");
        }
        IServiceConnection sd = this.mPackageInfo.getServiceDispatcher(conn, this.getOuterContext(), handler, flags);
        this.validateServiceIntent(service);
        try {
            IBinder token = this.getActivityToken();
            if (token == null && (flags & 1) == 0 && this.mPackageInfo != null && this.mPackageInfo.getApplicationInfo().targetSdkVersion < 14) {
                flags |= 0x20;
            }
            service.prepareToLeaveProcess(this);
            int res = ActivityManager.getService().bindService(this.mMainThread.getApplicationThread(), this.getActivityToken(), service, service.resolveTypeIfNeeded(this.getContentResolver()), sd, flags, this.getOpPackageName(), user.getIdentifier());
            if (res < 0) {
                throw new SecurityException("Not allowed to bind to service " + service);
            }
            return res != 0;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$unbindService(ServiceConnection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("connection is null");
        }
        if (this.mPackageInfo != null) {
            IServiceConnection sd = this.mPackageInfo.forgetServiceDispatcher(this.getOuterContext(), conn);
            try {
                ActivityManager.getService().unbindService(sd);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            throw new RuntimeException("Not supported in system context");
        }
    }

    private final boolean $$robo$$android_app_ContextImpl$startInstrumentation(ComponentName className, String profileFile, Bundle arguments) {
        try {
            if (arguments != null) {
                arguments.setAllowFds(false);
            }
            return ActivityManager.getService().startInstrumentation(className, profileFile, 0, arguments, null, null, this.getUserId(), null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Object $$robo$$android_app_ContextImpl$getSystemService(String name) {
        return SystemServiceRegistry.getSystemService(this, name);
    }

    private final String $$robo$$android_app_ContextImpl$getSystemServiceName(Class<?> serviceClass) {
        return SystemServiceRegistry.getSystemServiceName(serviceClass);
    }

    private final int $$robo$$android_app_ContextImpl$checkPermission(String permission2, int pid, int uid) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        IActivityManager am = ActivityManager.getService();
        if (am == null) {
            int appId = UserHandle.getAppId(uid);
            if (appId == 0 || appId == 1000) {
                Slog.w("ContextImpl", "Missing ActivityManager; assuming " + uid + " holds " + permission2);
                return 0;
            }
            Slog.w("ContextImpl", "Missing ActivityManager; assuming " + uid + " does not hold " + permission2);
            return -1;
        }
        try {
            return am.checkPermission(permission2, pid, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ContextImpl$checkPermission(String permission2, int pid, int uid, IBinder callerToken) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        try {
            return ActivityManager.getService().checkPermissionWithToken(permission2, pid, uid, callerToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ContextImpl$checkCallingPermission(String permission2) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        int pid = Binder.getCallingPid();
        if (pid != Process.myPid()) {
            return this.checkPermission(permission2, pid, Binder.getCallingUid());
        }
        return -1;
    }

    private final int $$robo$$android_app_ContextImpl$checkCallingOrSelfPermission(String permission2) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        return this.checkPermission(permission2, Binder.getCallingPid(), Binder.getCallingUid());
    }

    private final int $$robo$$android_app_ContextImpl$checkSelfPermission(String permission2) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        return this.checkPermission(permission2, Process.myPid(), Process.myUid());
    }

    private final void $$robo$$android_app_ContextImpl$enforce(String permission2, int resultOfCheck, boolean selfToo, int uid, String message) {
        if (resultOfCheck != 0) {
            throw new SecurityException((message != null ? message + ": " : "") + (selfToo ? "Neither user " + uid + " nor current process has " : "uid " + uid + " does not have ") + permission2 + ".");
        }
    }

    private final void $$robo$$android_app_ContextImpl$enforcePermission(String permission2, int pid, int uid, String message) {
        this.enforce(permission2, this.checkPermission(permission2, pid, uid), false, uid, message);
    }

    private final void $$robo$$android_app_ContextImpl$enforceCallingPermission(String permission2, String message) {
        this.enforce(permission2, this.checkCallingPermission(permission2), false, Binder.getCallingUid(), message);
    }

    private final void $$robo$$android_app_ContextImpl$enforceCallingOrSelfPermission(String permission2, String message) {
        this.enforce(permission2, this.checkCallingOrSelfPermission(permission2), true, Binder.getCallingUid(), message);
    }

    private final void $$robo$$android_app_ContextImpl$grantUriPermission(String toPackage, Uri uri, int modeFlags) {
        try {
            ActivityManager.getService().grantUriPermission(this.mMainThread.getApplicationThread(), toPackage, ContentProvider.getUriWithoutUserId(uri), modeFlags, this.resolveUserId(uri));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$revokeUriPermission(Uri uri, int modeFlags) {
        try {
            ActivityManager.getService().revokeUriPermission(this.mMainThread.getApplicationThread(), null, ContentProvider.getUriWithoutUserId(uri), modeFlags, this.resolveUserId(uri));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ContextImpl$revokeUriPermission(String targetPackage, Uri uri, int modeFlags) {
        try {
            ActivityManager.getService().revokeUriPermission(this.mMainThread.getApplicationThread(), targetPackage, ContentProvider.getUriWithoutUserId(uri), modeFlags, this.resolveUserId(uri));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ContextImpl$checkUriPermission(Uri uri, int pid, int uid, int modeFlags) {
        try {
            return ActivityManager.getService().checkUriPermission(ContentProvider.getUriWithoutUserId(uri), pid, uid, modeFlags, this.resolveUserId(uri), null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ContextImpl$checkUriPermission(Uri uri, int pid, int uid, int modeFlags, IBinder callerToken) {
        try {
            return ActivityManager.getService().checkUriPermission(ContentProvider.getUriWithoutUserId(uri), pid, uid, modeFlags, this.resolveUserId(uri), callerToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ContextImpl$resolveUserId(Uri uri) {
        return ContentProvider.getUserIdFromUri(uri, this.getUserId());
    }

    private final int $$robo$$android_app_ContextImpl$checkCallingUriPermission(Uri uri, int modeFlags) {
        int pid = Binder.getCallingPid();
        if (pid != Process.myPid()) {
            return this.checkUriPermission(uri, pid, Binder.getCallingUid(), modeFlags);
        }
        return -1;
    }

    private final int $$robo$$android_app_ContextImpl$checkCallingOrSelfUriPermission(Uri uri, int modeFlags) {
        return this.checkUriPermission(uri, Binder.getCallingPid(), Binder.getCallingUid(), modeFlags);
    }

    private final int $$robo$$android_app_ContextImpl$checkUriPermission(Uri uri, String readPermission, String writePermission, int pid, int uid, int modeFlags) {
        if ((modeFlags & 1) != 0 && (readPermission == null || this.checkPermission(readPermission, pid, uid) == 0)) {
            return 0;
        }
        if ((modeFlags & 2) != 0 && (writePermission == null || this.checkPermission(writePermission, pid, uid) == 0)) {
            return 0;
        }
        return uri != null ? this.checkUriPermission(uri, pid, uid, modeFlags) : -1;
    }

    private final String $$robo$$android_app_ContextImpl$uriModeFlagToString(int uriModeFlags) {
        StringBuilder builder = new StringBuilder();
        if ((uriModeFlags & 1) != 0) {
            builder.append("read and ");
        }
        if ((uriModeFlags & 2) != 0) {
            builder.append("write and ");
        }
        if ((uriModeFlags & 0x40) != 0) {
            builder.append("persistable and ");
        }
        if ((uriModeFlags & 0x80) != 0) {
            builder.append("prefix and ");
        }
        if (builder.length() > 5) {
            builder.setLength(builder.length() - 5);
            return builder.toString();
        }
        throw new IllegalArgumentException("Unknown permission mode flags: " + uriModeFlags);
    }

    private final void $$robo$$android_app_ContextImpl$enforceForUri(int modeFlags, int resultOfCheck, boolean selfToo, int uid, Uri uri, String message) {
        if (resultOfCheck != 0) {
            throw new SecurityException((message != null ? message + ": " : "") + (selfToo ? "Neither user " + uid + " nor current process has " : "User " + uid + " does not have ") + this.uriModeFlagToString(modeFlags) + " permission on " + uri + ".");
        }
    }

    private final void $$robo$$android_app_ContextImpl$enforceUriPermission(Uri uri, int pid, int uid, int modeFlags, String message) {
        this.enforceForUri(modeFlags, this.checkUriPermission(uri, pid, uid, modeFlags), false, uid, uri, message);
    }

    private final void $$robo$$android_app_ContextImpl$enforceCallingUriPermission(Uri uri, int modeFlags, String message) {
        this.enforceForUri(modeFlags, this.checkCallingUriPermission(uri, modeFlags), false, Binder.getCallingUid(), uri, message);
    }

    private final void $$robo$$android_app_ContextImpl$enforceCallingOrSelfUriPermission(Uri uri, int modeFlags, String message) {
        this.enforceForUri(modeFlags, this.checkCallingOrSelfUriPermission(uri, modeFlags), true, Binder.getCallingUid(), uri, message);
    }

    private final void $$robo$$android_app_ContextImpl$enforceUriPermission(Uri uri, String readPermission, String writePermission, int pid, int uid, int modeFlags, String message) {
        this.enforceForUri(modeFlags, this.checkUriPermission(uri, readPermission, writePermission, pid, uid, modeFlags), false, uid, uri, message);
    }

    private final void $$robo$$android_app_ContextImpl$warnIfCallingFromSystemProcess() {
        if (Process.myUid() == 1000) {
            Slog.w("ContextImpl", "Calling a method in the system process without a qualified user: " + Debug.getCallers(5));
        }
    }

    private static final Resources $$robo$$android_app_ContextImpl$createResources(IBinder activityToken, LoadedApk pi, String splitName, int displayId, Configuration overrideConfig, CompatibilityInfo compatInfo) {
        ClassLoader classLoader;
        String[] splitResDirs;
        try {
            splitResDirs = pi.getSplitPaths(splitName);
            classLoader = pi.getSplitClassLoader(splitName);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        return ResourcesManager.getInstance().getResources(activityToken, pi.getResDir(), splitResDirs, pi.getOverlayDirs(), pi.getApplicationInfo().sharedLibraryFiles, displayId, overrideConfig, compatInfo, classLoader);
    }

    private final Context $$robo$$android_app_ContextImpl$createApplicationContext(ApplicationInfo application, int flags) throws PackageManager.NameNotFoundException {
        LoadedApk pi = this.mMainThread.getPackageInfo(application, this.mResources.getCompatibilityInfo(), flags | 0x40000000);
        if (pi != null) {
            ContextImpl c = new ContextImpl(this, this.mMainThread, pi, null, this.mActivityToken, new UserHandle(UserHandle.getUserId(application.uid)), flags, null);
            int displayId = this.mDisplay != null ? this.mDisplay.getDisplayId() : 0;
            c.setResources(ContextImpl.createResources(this.mActivityToken, pi, null, displayId, null, this.getDisplayAdjustments(displayId).getCompatibilityInfo()));
            if (c.mResources != null) {
                return c;
            }
        }
        throw new PackageManager.NameNotFoundException("Application package " + application.packageName + " not found");
    }

    private final Context $$robo$$android_app_ContextImpl$createPackageContext(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return this.createPackageContextAsUser(packageName, flags, this.mUser);
    }

    private final Context $$robo$$android_app_ContextImpl$createPackageContextAsUser(String packageName, int flags, UserHandle user) throws PackageManager.NameNotFoundException {
        if (packageName.equals("system") || packageName.equals("android")) {
            return new ContextImpl(this, this.mMainThread, this.mPackageInfo, null, this.mActivityToken, user, flags, null);
        }
        LoadedApk pi = this.mMainThread.getPackageInfo(packageName, this.mResources.getCompatibilityInfo(), flags | 0x40000000, user.getIdentifier());
        if (pi != null) {
            ContextImpl c = new ContextImpl(this, this.mMainThread, pi, null, this.mActivityToken, user, flags, null);
            int displayId = this.mDisplay != null ? this.mDisplay.getDisplayId() : 0;
            c.setResources(ContextImpl.createResources(this.mActivityToken, pi, null, displayId, null, this.getDisplayAdjustments(displayId).getCompatibilityInfo()));
            if (c.mResources != null) {
                return c;
            }
        }
        throw new PackageManager.NameNotFoundException("Application package " + packageName + " not found");
    }

    private final Context $$robo$$android_app_ContextImpl$createContextForSplit(String splitName) throws PackageManager.NameNotFoundException {
        if (!this.mPackageInfo.getApplicationInfo().requestsIsolatedSplitLoading()) {
            return this;
        }
        ClassLoader classLoader = this.mPackageInfo.getSplitClassLoader(splitName);
        String[] paths = this.mPackageInfo.getSplitPaths(splitName);
        ContextImpl context = new ContextImpl(this, this.mMainThread, this.mPackageInfo, splitName, this.mActivityToken, this.mUser, this.mFlags, classLoader);
        int displayId = this.mDisplay != null ? this.mDisplay.getDisplayId() : 0;
        context.setResources(ResourcesManager.getInstance().getResources(this.mActivityToken, this.mPackageInfo.getResDir(), paths, this.mPackageInfo.getOverlayDirs(), this.mPackageInfo.getApplicationInfo().sharedLibraryFiles, displayId, null, this.mPackageInfo.getCompatibilityInfo(), classLoader));
        return context;
    }

    private final Context $$robo$$android_app_ContextImpl$createConfigurationContext(Configuration overrideConfiguration) {
        if (overrideConfiguration == null) {
            throw new IllegalArgumentException("overrideConfiguration must not be null");
        }
        ContextImpl context = new ContextImpl(this, this.mMainThread, this.mPackageInfo, this.mSplitName, this.mActivityToken, this.mUser, this.mFlags, this.mClassLoader);
        int displayId = this.mDisplay != null ? this.mDisplay.getDisplayId() : 0;
        context.setResources(ContextImpl.createResources(this.mActivityToken, this.mPackageInfo, this.mSplitName, displayId, overrideConfiguration, this.getDisplayAdjustments(displayId).getCompatibilityInfo()));
        return context;
    }

    private final Context $$robo$$android_app_ContextImpl$createDisplayContext(Display display) {
        if (display == null) {
            throw new IllegalArgumentException("display must not be null");
        }
        ContextImpl context = new ContextImpl(this, this.mMainThread, this.mPackageInfo, this.mSplitName, this.mActivityToken, this.mUser, this.mFlags, this.mClassLoader);
        int displayId = display.getDisplayId();
        context.setResources(ContextImpl.createResources(this.mActivityToken, this.mPackageInfo, this.mSplitName, displayId, null, this.getDisplayAdjustments(displayId).getCompatibilityInfo()));
        context.mDisplay = display;
        return context;
    }

    private final Context $$robo$$android_app_ContextImpl$createDeviceProtectedStorageContext() {
        int flags = this.mFlags & 0xFFFFFFEF | 8;
        return new ContextImpl(this, this.mMainThread, this.mPackageInfo, this.mSplitName, this.mActivityToken, this.mUser, flags, this.mClassLoader);
    }

    private final Context $$robo$$android_app_ContextImpl$createCredentialProtectedStorageContext() {
        int flags = this.mFlags & 0xFFFFFFF7 | 0x10;
        return new ContextImpl(this, this.mMainThread, this.mPackageInfo, this.mSplitName, this.mActivityToken, this.mUser, flags, this.mClassLoader);
    }

    private final boolean $$robo$$android_app_ContextImpl$isRestricted() {
        return (this.mFlags & 4) != 0;
    }

    private final boolean $$robo$$android_app_ContextImpl$isDeviceProtectedStorage() {
        return (this.mFlags & 8) != 0;
    }

    private final boolean $$robo$$android_app_ContextImpl$isCredentialProtectedStorage() {
        return (this.mFlags & 0x10) != 0;
    }

    private final boolean $$robo$$android_app_ContextImpl$canLoadUnsafeResources() {
        if (this.getPackageName().equals(this.getOpPackageName())) {
            return true;
        }
        return (this.mFlags & 2) != 0;
    }

    private final Display $$robo$$android_app_ContextImpl$getDisplay() {
        if (this.mDisplay == null) {
            return this.mResourcesManager.getAdjustedDisplay(0, this.mResources);
        }
        return this.mDisplay;
    }

    private final void $$robo$$android_app_ContextImpl$updateDisplay(int displayId) {
        this.mDisplay = this.mResourcesManager.getAdjustedDisplay(displayId, this.mResources);
    }

    private final DisplayAdjustments $$robo$$android_app_ContextImpl$getDisplayAdjustments(int displayId) {
        return this.mResources.getDisplayAdjustments();
    }

    private final File $$robo$$android_app_ContextImpl$getDataDir() {
        if (this.mPackageInfo != null) {
            File res = null;
            res = this.isCredentialProtectedStorage() ? this.mPackageInfo.getCredentialProtectedDataDirFile() : (this.isDeviceProtectedStorage() ? this.mPackageInfo.getDeviceProtectedDataDirFile() : this.mPackageInfo.getDataDirFile());
            if (res != null) {
                if (!res.exists() && Process.myUid() == 1000) {
                    Log.wtf("ContextImpl", "Data directory doesn't exist for package " + this.getPackageName(), new Throwable());
                }
                return res;
            }
            throw new RuntimeException("No data directory found for package " + this.getPackageName());
        }
        throw new RuntimeException("No package details found for package " + this.getPackageName());
    }

    private final File $$robo$$android_app_ContextImpl$getDir(String name, int mode) {
        this.checkMode(mode);
        name = "app_" + name;
        File file = this.makeFilename(this.getDataDir(), name);
        if (!file.exists()) {
            file.mkdir();
            ContextImpl.setFilePermissionsFromMode(file.getPath(), mode, 505);
        }
        return file;
    }

    private final UserHandle $$robo$$android_app_ContextImpl$getUser() {
        return this.mUser;
    }

    private final int $$robo$$android_app_ContextImpl$getUserId() {
        return this.mUser.getIdentifier();
    }

    private final AutofillManager.AutofillClient $$robo$$android_app_ContextImpl$getAutofillClient() {
        return this.mAutofillClient;
    }

    private final void $$robo$$android_app_ContextImpl$setAutofillClient(AutofillManager.AutofillClient client) {
        this.mAutofillClient = client;
    }

    private final boolean $$robo$$android_app_ContextImpl$isAutofillCompatibilityEnabled() {
        return this.mIsAutofillCompatEnabled;
    }

    private final void $$robo$$android_app_ContextImpl$setAutofillCompatibilityEnabled(boolean autofillCompatEnabled) {
        this.mIsAutofillCompatEnabled = autofillCompatEnabled;
    }

    private static final ContextImpl $$robo$$android_app_ContextImpl$createSystemContext(ActivityThread mainThread) {
        LoadedApk packageInfo = new LoadedApk(mainThread);
        ContextImpl context = new ContextImpl(null, mainThread, packageInfo, null, null, null, 0, null);
        context.setResources(packageInfo.getResources());
        context.mResources.updateConfiguration(context.mResourcesManager.getConfiguration(), context.mResourcesManager.getDisplayMetrics());
        return context;
    }

    private static final ContextImpl $$robo$$android_app_ContextImpl$createSystemUiContext(ContextImpl systemContext) {
        LoadedApk packageInfo = systemContext.mPackageInfo;
        ContextImpl context = new ContextImpl(null, systemContext.mMainThread, packageInfo, null, null, null, 0, null);
        context.setResources(ContextImpl.createResources(null, packageInfo, null, 0, null, packageInfo.getCompatibilityInfo()));
        return context;
    }

    private static final ContextImpl $$robo$$android_app_ContextImpl$createAppContext(ActivityThread mainThread, LoadedApk packageInfo) {
        if (packageInfo == null) {
            throw new IllegalArgumentException("packageInfo");
        }
        ContextImpl context = new ContextImpl(null, mainThread, packageInfo, null, null, null, 0, null);
        context.setResources(packageInfo.getResources());
        return context;
    }

    private static final ContextImpl $$robo$$android_app_ContextImpl$createActivityContext(ActivityThread mainThread, LoadedApk packageInfo, ActivityInfo activityInfo, IBinder activityToken, int displayId, Configuration overrideConfiguration) {
        if (packageInfo == null) {
            throw new IllegalArgumentException("packageInfo");
        }
        String[] splitDirs = packageInfo.getSplitResDirs();
        ClassLoader classLoader = packageInfo.getClassLoader();
        if (packageInfo.getApplicationInfo().requestsIsolatedSplitLoading()) {
            Trace.traceBegin(8192L, "SplitDependencies");
            try {
                classLoader = packageInfo.getSplitClassLoader(activityInfo.splitName);
                splitDirs = packageInfo.getSplitPaths(activityInfo.splitName);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException(e);
            }
            finally {
                Trace.traceEnd(8192L);
            }
        }
        ContextImpl context = new ContextImpl(null, mainThread, packageInfo, activityInfo.splitName, activityToken, null, 0, classLoader);
        displayId = displayId != -1 ? displayId : 0;
        CompatibilityInfo compatInfo = displayId == 0 ? packageInfo.getCompatibilityInfo() : CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
        ResourcesManager resourcesManager = ResourcesManager.getInstance();
        context.setResources(resourcesManager.createBaseActivityResources(activityToken, packageInfo.getResDir(), splitDirs, packageInfo.getOverlayDirs(), packageInfo.getApplicationInfo().sharedLibraryFiles, displayId, overrideConfiguration, compatInfo, classLoader));
        context.mDisplay = resourcesManager.getAdjustedDisplay(displayId, context.getResources());
        return context;
    }

    private void $$robo$$android_app_ContextImpl$__constructor__(ContextImpl container, ActivityThread mainThread, LoadedApk packageInfo, String splitName, IBinder activityToken, UserHandle user, int flags, ClassLoader classLoader) {
        this.mThemeResource = 0;
        this.mTheme = null;
        this.mReceiverRestrictedContext = null;
        this.mSplitName = null;
        this.mAutofillClient = null;
        this.mSync = new Object();
        this.mServiceCache = SystemServiceRegistry.createServiceCache();
        this.mServiceInitializationStateArray = new int[this.mServiceCache.length];
        this.mOuterContext = this;
        if ((flags & 0x18) == 0) {
            File dataDir = packageInfo.getDataDirFile();
            if (Objects.equals(dataDir, packageInfo.getCredentialProtectedDataDirFile())) {
                flags |= 0x10;
            } else if (Objects.equals(dataDir, packageInfo.getDeviceProtectedDataDirFile())) {
                flags |= 8;
            }
        }
        this.mMainThread = mainThread;
        this.mActivityToken = activityToken;
        this.mFlags = flags;
        if (user == null) {
            user = Process.myUserHandle();
        }
        this.mUser = user;
        this.mPackageInfo = packageInfo;
        this.mSplitName = splitName;
        this.mClassLoader = classLoader;
        this.mResourcesManager = ResourcesManager.getInstance();
        if (container != null) {
            this.mBasePackageName = container.mBasePackageName;
            this.mOpPackageName = container.mOpPackageName;
            this.setResources(container.mResources);
            this.mDisplay = container.mDisplay;
        } else {
            this.mBasePackageName = packageInfo.mPackageName;
            ApplicationInfo ainfo = packageInfo.getApplicationInfo();
            this.mOpPackageName = ainfo.uid == 1000 && ainfo.uid != Process.myUid() ? ActivityThread.currentPackageName() : this.mBasePackageName;
        }
        this.mContentResolver = new ApplicationContentResolver(this, mainThread);
    }

    private final void $$robo$$android_app_ContextImpl$setResources(Resources r) {
        if (r instanceof CompatResources) {
            ((CompatResources)r).setContext(this);
        }
        this.mResources = r;
    }

    private final void $$robo$$android_app_ContextImpl$installSystemApplicationInfo(ApplicationInfo info, ClassLoader classLoader) {
        this.mPackageInfo.installSystemApplicationInfo(info, classLoader);
    }

    private final void $$robo$$android_app_ContextImpl$scheduleFinalCleanup(String who, String what) {
        this.mMainThread.scheduleContextCleanup(this, who, what);
    }

    private final void $$robo$$android_app_ContextImpl$performFinalCleanup(String who, String what) {
        this.mPackageInfo.removeContextRegistrations(this.getOuterContext(), who, what);
    }

    private final Context $$robo$$android_app_ContextImpl$getReceiverRestrictedContext() {
        if (this.mReceiverRestrictedContext != null) {
            return this.mReceiverRestrictedContext;
        }
        this.mReceiverRestrictedContext = new ReceiverRestrictedContext(this.getOuterContext());
        return this.mReceiverRestrictedContext;
    }

    private final void $$robo$$android_app_ContextImpl$setOuterContext(Context context) {
        this.mOuterContext = context;
    }

    private final Context $$robo$$android_app_ContextImpl$getOuterContext() {
        return this.mOuterContext;
    }

    private final IBinder $$robo$$android_app_ContextImpl$getActivityToken() {
        return this.mActivityToken;
    }

    private final void $$robo$$android_app_ContextImpl$checkMode(int mode) {
        if (this.getApplicationInfo().targetSdkVersion >= 24) {
            if ((mode & 1) != 0) {
                throw new SecurityException("MODE_WORLD_READABLE no longer supported");
            }
            if ((mode & 2) != 0) {
                throw new SecurityException("MODE_WORLD_WRITEABLE no longer supported");
            }
        }
    }

    private static final void $$robo$$android_app_ContextImpl$setFilePermissionsFromMode(String name, int mode, int extraPermissions) {
        int perms = 0x1B0 | extraPermissions;
        if ((mode & 1) != 0) {
            perms |= 4;
        }
        if ((mode & 2) != 0) {
            perms |= 2;
        }
        FileUtils.setPermissions(name, perms, -1, -1);
    }

    private final File $$robo$$android_app_ContextImpl$makeFilename(File base, String name) {
        if (name.indexOf(File.separatorChar) < 0) {
            return new File(base, name);
        }
        throw new IllegalArgumentException("File " + name + " contains a path separator");
    }

    private final File[] $$robo$$android_app_ContextImpl$ensureExternalDirsExistOrFilter(File[] dirs) {
        StorageManager sm = this.getSystemService(StorageManager.class);
        File[] result = new File[dirs.length];
        for (int i = 0; i < dirs.length; ++i) {
            File dir = dirs[i];
            if (!(dir.exists() || dir.mkdirs() || dir.exists())) {
                try {
                    sm.mkdirs(dir);
                }
                catch (Exception e) {
                    Log.w("ContextImpl", "Failed to ensure " + dir + ": " + e);
                    dir = null;
                }
            }
            result[i] = dir;
        }
        return result;
    }

    static ContextImpl getImpl(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getImpl", $$robo$$android_app_ContextImpl$getImpl(android.content.Context ), (Context)context);
    }

    @Override
    public AssetManager getAssets() {
        return InvokeDynamicSupport.bootstrap("getAssets", $$robo$$android_app_ContextImpl$getAssets(), this);
    }

    @Override
    public Resources getResources() {
        return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_app_ContextImpl$getResources(), this);
    }

    @Override
    public PackageManager getPackageManager() {
        return InvokeDynamicSupport.bootstrap("getPackageManager", $$robo$$android_app_ContextImpl$getPackageManager(), this);
    }

    @Override
    public ContentResolver getContentResolver() {
        return InvokeDynamicSupport.bootstrap("getContentResolver", $$robo$$android_app_ContextImpl$getContentResolver(), this);
    }

    @Override
    public Looper getMainLooper() {
        return InvokeDynamicSupport.bootstrap("getMainLooper", $$robo$$android_app_ContextImpl$getMainLooper(), this);
    }

    @Override
    public Executor getMainExecutor() {
        return InvokeDynamicSupport.bootstrap("getMainExecutor", $$robo$$android_app_ContextImpl$getMainExecutor(), this);
    }

    @Override
    public Context getApplicationContext() {
        return InvokeDynamicSupport.bootstrap("getApplicationContext", $$robo$$android_app_ContextImpl$getApplicationContext(), this);
    }

    @Override
    public void setTheme(int n) {
        InvokeDynamicSupport.bootstrap("setTheme", $$robo$$android_app_ContextImpl$setTheme(int ), this, n);
    }

    @Override
    public int getThemeResId() {
        return (int)InvokeDynamicSupport.bootstrap("getThemeResId", $$robo$$android_app_ContextImpl$getThemeResId(), this);
    }

    @Override
    public Resources.Theme getTheme() {
        return InvokeDynamicSupport.bootstrap("getTheme", $$robo$$android_app_ContextImpl$getTheme(), this);
    }

    private void initializeTheme() {
        InvokeDynamicSupport.bootstrap("initializeTheme", $$robo$$android_app_ContextImpl$initializeTheme(), this);
    }

    @Override
    public ClassLoader getClassLoader() {
        return InvokeDynamicSupport.bootstrap("getClassLoader", $$robo$$android_app_ContextImpl$getClassLoader(), this);
    }

    @Override
    public String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_app_ContextImpl$getPackageName(), this);
    }

    @Override
    public String getBasePackageName() {
        return InvokeDynamicSupport.bootstrap("getBasePackageName", $$robo$$android_app_ContextImpl$getBasePackageName(), this);
    }

    @Override
    public String getOpPackageName() {
        return InvokeDynamicSupport.bootstrap("getOpPackageName", $$robo$$android_app_ContextImpl$getOpPackageName(), this);
    }

    @Override
    public ApplicationInfo getApplicationInfo() {
        return InvokeDynamicSupport.bootstrap("getApplicationInfo", $$robo$$android_app_ContextImpl$getApplicationInfo(), this);
    }

    @Override
    public String getPackageResourcePath() {
        return InvokeDynamicSupport.bootstrap("getPackageResourcePath", $$robo$$android_app_ContextImpl$getPackageResourcePath(), this);
    }

    @Override
    public String getPackageCodePath() {
        return InvokeDynamicSupport.bootstrap("getPackageCodePath", $$robo$$android_app_ContextImpl$getPackageCodePath(), this);
    }

    @Override
    public SharedPreferences getSharedPreferences(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getSharedPreferences", $$robo$$android_app_ContextImpl$getSharedPreferences(java.lang.String int ), this, string2, n);
    }

    @Override
    public SharedPreferences getSharedPreferences(File file, int n) {
        return InvokeDynamicSupport.bootstrap("getSharedPreferences", $$robo$$android_app_ContextImpl$getSharedPreferences(java.io.File int ), this, file, n);
    }

    private ArrayMap<File, SharedPreferencesImpl> getSharedPreferencesCacheLocked() {
        return InvokeDynamicSupport.bootstrap("getSharedPreferencesCacheLocked", $$robo$$android_app_ContextImpl$getSharedPreferencesCacheLocked(), this);
    }

    @Override
    public void reloadSharedPreferences() {
        InvokeDynamicSupport.bootstrap("reloadSharedPreferences", $$robo$$android_app_ContextImpl$reloadSharedPreferences(), this);
    }

    private static int moveFiles(File file, File file2, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("moveFiles", $$robo$$android_app_ContextImpl$moveFiles(java.io.File java.io.File java.lang.String ), (File)file, (File)file2, (String)string2);
    }

    @Override
    public boolean moveSharedPreferencesFrom(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("moveSharedPreferencesFrom", $$robo$$android_app_ContextImpl$moveSharedPreferencesFrom(android.content.Context java.lang.String ), this, context, string2);
    }

    @Override
    public boolean deleteSharedPreferences(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteSharedPreferences", $$robo$$android_app_ContextImpl$deleteSharedPreferences(java.lang.String ), this, string2);
    }

    private File getPreferencesDir() {
        return InvokeDynamicSupport.bootstrap("getPreferencesDir", $$robo$$android_app_ContextImpl$getPreferencesDir(), this);
    }

    @Override
    public FileInputStream openFileInput(String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFileInput", $$robo$$android_app_ContextImpl$openFileInput(java.lang.String ), this, string2);
    }

    @Override
    public FileOutputStream openFileOutput(String string2, int n) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFileOutput", $$robo$$android_app_ContextImpl$openFileOutput(java.lang.String int ), this, string2, n);
    }

    @Override
    public boolean deleteFile(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteFile", $$robo$$android_app_ContextImpl$deleteFile(java.lang.String ), this, string2);
    }

    private static File ensurePrivateDirExists(File file) {
        return InvokeDynamicSupport.bootstrapStatic("ensurePrivateDirExists", $$robo$$android_app_ContextImpl$ensurePrivateDirExists(java.io.File ), (File)file);
    }

    private static File ensurePrivateCacheDirExists(File file, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("ensurePrivateCacheDirExists", $$robo$$android_app_ContextImpl$ensurePrivateCacheDirExists(java.io.File java.lang.String ), (File)file, (String)string2);
    }

    private static File ensurePrivateDirExists(File file, int n, int n2, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("ensurePrivateDirExists", $$robo$$android_app_ContextImpl$ensurePrivateDirExists(java.io.File int int java.lang.String ), (File)file, (int)n, (int)n2, (String)string2);
    }

    @Override
    public File getFilesDir() {
        return InvokeDynamicSupport.bootstrap("getFilesDir", $$robo$$android_app_ContextImpl$getFilesDir(), this);
    }

    @Override
    public File getNoBackupFilesDir() {
        return InvokeDynamicSupport.bootstrap("getNoBackupFilesDir", $$robo$$android_app_ContextImpl$getNoBackupFilesDir(), this);
    }

    @Override
    public File getExternalFilesDir(String string2) {
        return InvokeDynamicSupport.bootstrap("getExternalFilesDir", $$robo$$android_app_ContextImpl$getExternalFilesDir(java.lang.String ), this, string2);
    }

    @Override
    public File[] getExternalFilesDirs(String string2) {
        return InvokeDynamicSupport.bootstrap("getExternalFilesDirs", $$robo$$android_app_ContextImpl$getExternalFilesDirs(java.lang.String ), this, string2);
    }

    @Override
    public File getObbDir() {
        return InvokeDynamicSupport.bootstrap("getObbDir", $$robo$$android_app_ContextImpl$getObbDir(), this);
    }

    @Override
    public File[] getObbDirs() {
        return InvokeDynamicSupport.bootstrap("getObbDirs", $$robo$$android_app_ContextImpl$getObbDirs(), this);
    }

    @Override
    public File getCacheDir() {
        return InvokeDynamicSupport.bootstrap("getCacheDir", $$robo$$android_app_ContextImpl$getCacheDir(), this);
    }

    @Override
    public File getCodeCacheDir() {
        return InvokeDynamicSupport.bootstrap("getCodeCacheDir", $$robo$$android_app_ContextImpl$getCodeCacheDir(), this);
    }

    @Override
    public File getExternalCacheDir() {
        return InvokeDynamicSupport.bootstrap("getExternalCacheDir", $$robo$$android_app_ContextImpl$getExternalCacheDir(), this);
    }

    @Override
    public File[] getExternalCacheDirs() {
        return InvokeDynamicSupport.bootstrap("getExternalCacheDirs", $$robo$$android_app_ContextImpl$getExternalCacheDirs(), this);
    }

    @Override
    public File[] getExternalMediaDirs() {
        return InvokeDynamicSupport.bootstrap("getExternalMediaDirs", $$robo$$android_app_ContextImpl$getExternalMediaDirs(), this);
    }

    @Override
    public File getPreloadsFileCache() {
        return InvokeDynamicSupport.bootstrap("getPreloadsFileCache", $$robo$$android_app_ContextImpl$getPreloadsFileCache(), this);
    }

    @Override
    public File getFileStreamPath(String string2) {
        return InvokeDynamicSupport.bootstrap("getFileStreamPath", $$robo$$android_app_ContextImpl$getFileStreamPath(java.lang.String ), this, string2);
    }

    @Override
    public File getSharedPreferencesPath(String string2) {
        return InvokeDynamicSupport.bootstrap("getSharedPreferencesPath", $$robo$$android_app_ContextImpl$getSharedPreferencesPath(java.lang.String ), this, string2);
    }

    @Override
    public String[] fileList() {
        return InvokeDynamicSupport.bootstrap("fileList", $$robo$$android_app_ContextImpl$fileList(), this);
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String string2, int n, SQLiteDatabase.CursorFactory cursorFactory) {
        return InvokeDynamicSupport.bootstrap("openOrCreateDatabase", $$robo$$android_app_ContextImpl$openOrCreateDatabase(java.lang.String int android.database.sqlite.SQLiteDatabase$CursorFactory ), this, string2, n, cursorFactory);
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String string2, int n, SQLiteDatabase.CursorFactory cursorFactory, DatabaseErrorHandler databaseErrorHandler) {
        return InvokeDynamicSupport.bootstrap("openOrCreateDatabase", $$robo$$android_app_ContextImpl$openOrCreateDatabase(java.lang.String int android.database.sqlite.SQLiteDatabase$CursorFactory android.database.DatabaseErrorHandler ), this, string2, n, cursorFactory, databaseErrorHandler);
    }

    @Override
    public boolean moveDatabaseFrom(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("moveDatabaseFrom", $$robo$$android_app_ContextImpl$moveDatabaseFrom(android.content.Context java.lang.String ), this, context, string2);
    }

    @Override
    public boolean deleteDatabase(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteDatabase", $$robo$$android_app_ContextImpl$deleteDatabase(java.lang.String ), this, string2);
    }

    @Override
    public File getDatabasePath(String string2) {
        return InvokeDynamicSupport.bootstrap("getDatabasePath", $$robo$$android_app_ContextImpl$getDatabasePath(java.lang.String ), this, string2);
    }

    @Override
    public String[] databaseList() {
        return InvokeDynamicSupport.bootstrap("databaseList", $$robo$$android_app_ContextImpl$databaseList(), this);
    }

    private File getDatabasesDir() {
        return InvokeDynamicSupport.bootstrap("getDatabasesDir", $$robo$$android_app_ContextImpl$getDatabasesDir(), this);
    }

    @Override
    @Deprecated
    public Drawable getWallpaper() {
        return InvokeDynamicSupport.bootstrap("getWallpaper", $$robo$$android_app_ContextImpl$getWallpaper(), this);
    }

    @Override
    @Deprecated
    public Drawable peekWallpaper() {
        return InvokeDynamicSupport.bootstrap("peekWallpaper", $$robo$$android_app_ContextImpl$peekWallpaper(), this);
    }

    @Override
    @Deprecated
    public int getWallpaperDesiredMinimumWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWallpaperDesiredMinimumWidth", $$robo$$android_app_ContextImpl$getWallpaperDesiredMinimumWidth(), this);
    }

    @Override
    @Deprecated
    public int getWallpaperDesiredMinimumHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getWallpaperDesiredMinimumHeight", $$robo$$android_app_ContextImpl$getWallpaperDesiredMinimumHeight(), this);
    }

    @Override
    @Deprecated
    public void setWallpaper(Bitmap bitmap) throws IOException {
        InvokeDynamicSupport.bootstrap("setWallpaper", $$robo$$android_app_ContextImpl$setWallpaper(android.graphics.Bitmap ), this, bitmap);
    }

    @Override
    @Deprecated
    public void setWallpaper(InputStream inputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("setWallpaper", $$robo$$android_app_ContextImpl$setWallpaper(java.io.InputStream ), this, inputStream);
    }

    @Override
    @Deprecated
    public void clearWallpaper() throws IOException {
        InvokeDynamicSupport.bootstrap("clearWallpaper", $$robo$$android_app_ContextImpl$clearWallpaper(), this);
    }

    private WallpaperManager getWallpaperManager() {
        return InvokeDynamicSupport.bootstrap("getWallpaperManager", $$robo$$android_app_ContextImpl$getWallpaperManager(), this);
    }

    @Override
    public void startActivity(Intent intent) {
        InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ContextImpl$startActivity(android.content.Intent ), this, intent);
    }

    @Override
    public void startActivityAsUser(Intent intent, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("startActivityAsUser", $$robo$$android_app_ContextImpl$startActivityAsUser(android.content.Intent android.os.UserHandle ), this, intent, userHandle);
    }

    @Override
    public void startActivity(Intent intent, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ContextImpl$startActivity(android.content.Intent android.os.Bundle ), this, intent, bundle);
    }

    @Override
    public void startActivityAsUser(Intent intent, Bundle bundle, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("startActivityAsUser", $$robo$$android_app_ContextImpl$startActivityAsUser(android.content.Intent android.os.Bundle android.os.UserHandle ), this, intent, bundle, userHandle);
    }

    @Override
    public void startActivities(Intent[] intentArray) {
        InvokeDynamicSupport.bootstrap("startActivities", $$robo$$android_app_ContextImpl$startActivities(android.content.Intent[] ), this, intentArray);
    }

    @Override
    public int startActivitiesAsUser(Intent[] intentArray, Bundle bundle, UserHandle userHandle) {
        return (int)InvokeDynamicSupport.bootstrap("startActivitiesAsUser", $$robo$$android_app_ContextImpl$startActivitiesAsUser(android.content.Intent[] android.os.Bundle android.os.UserHandle ), this, intentArray, bundle, userHandle);
    }

    @Override
    public void startActivities(Intent[] intentArray, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("startActivities", $$robo$$android_app_ContextImpl$startActivities(android.content.Intent[] android.os.Bundle ), this, intentArray, bundle);
    }

    @Override
    public void startIntentSender(IntentSender intentSender, Intent intent, int n, int n2, int n3) throws IntentSender.SendIntentException {
        InvokeDynamicSupport.bootstrap("startIntentSender", $$robo$$android_app_ContextImpl$startIntentSender(android.content.IntentSender android.content.Intent int int int ), this, intentSender, intent, n, n2, n3);
    }

    @Override
    public void startIntentSender(IntentSender intentSender, Intent intent, int n, int n2, int n3, Bundle bundle) throws IntentSender.SendIntentException {
        InvokeDynamicSupport.bootstrap("startIntentSender", $$robo$$android_app_ContextImpl$startIntentSender(android.content.IntentSender android.content.Intent int int int android.os.Bundle ), this, intentSender, intent, n, n2, n3, bundle);
    }

    @Override
    public void sendBroadcast(Intent intent) {
        InvokeDynamicSupport.bootstrap("sendBroadcast", $$robo$$android_app_ContextImpl$sendBroadcast(android.content.Intent ), this, intent);
    }

    @Override
    public void sendBroadcast(Intent intent, String string2) {
        InvokeDynamicSupport.bootstrap("sendBroadcast", $$robo$$android_app_ContextImpl$sendBroadcast(android.content.Intent java.lang.String ), this, intent, string2);
    }

    @Override
    public void sendBroadcastMultiplePermissions(Intent intent, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("sendBroadcastMultiplePermissions", $$robo$$android_app_ContextImpl$sendBroadcastMultiplePermissions(android.content.Intent java.lang.String[] ), this, intent, stringArray);
    }

    @Override
    public void sendBroadcastAsUserMultiplePermissions(Intent intent, UserHandle userHandle, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("sendBroadcastAsUserMultiplePermissions", $$robo$$android_app_ContextImpl$sendBroadcastAsUserMultiplePermissions(android.content.Intent android.os.UserHandle java.lang.String[] ), this, intent, userHandle, stringArray);
    }

    @Override
    public void sendBroadcast(Intent intent, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendBroadcast", $$robo$$android_app_ContextImpl$sendBroadcast(android.content.Intent java.lang.String android.os.Bundle ), this, intent, string2, bundle);
    }

    @Override
    public void sendBroadcast(Intent intent, String string2, int n) {
        InvokeDynamicSupport.bootstrap("sendBroadcast", $$robo$$android_app_ContextImpl$sendBroadcast(android.content.Intent java.lang.String int ), this, intent, string2, n);
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, String string2) {
        InvokeDynamicSupport.bootstrap("sendOrderedBroadcast", $$robo$$android_app_ContextImpl$sendOrderedBroadcast(android.content.Intent java.lang.String ), this, intent, string2);
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, String string2, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string3, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendOrderedBroadcast", $$robo$$android_app_ContextImpl$sendOrderedBroadcast(android.content.Intent java.lang.String android.content.BroadcastReceiver android.os.Handler int java.lang.String android.os.Bundle ), this, intent, string2, broadcastReceiver, handler, n, string3, bundle);
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, String string2, Bundle bundle, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string3, Bundle bundle2) {
        InvokeDynamicSupport.bootstrap("sendOrderedBroadcast", $$robo$$android_app_ContextImpl$sendOrderedBroadcast(android.content.Intent java.lang.String android.os.Bundle android.content.BroadcastReceiver android.os.Handler int java.lang.String android.os.Bundle ), this, intent, string2, bundle, broadcastReceiver, handler, n, string3, bundle2);
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, String string2, int n, BroadcastReceiver broadcastReceiver, Handler handler, int n2, String string3, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendOrderedBroadcast", $$robo$$android_app_ContextImpl$sendOrderedBroadcast(android.content.Intent java.lang.String int android.content.BroadcastReceiver android.os.Handler int java.lang.String android.os.Bundle ), this, intent, string2, n, broadcastReceiver, handler, n2, string3, bundle);
    }

    void sendOrderedBroadcast(Intent intent, String string2, int n, BroadcastReceiver broadcastReceiver, Handler handler, int n2, String string3, Bundle bundle, Bundle bundle2) {
        InvokeDynamicSupport.bootstrap("sendOrderedBroadcast", $$robo$$android_app_ContextImpl$sendOrderedBroadcast(android.content.Intent java.lang.String int android.content.BroadcastReceiver android.os.Handler int java.lang.String android.os.Bundle android.os.Bundle ), this, intent, string2, n, broadcastReceiver, handler, n2, string3, bundle, bundle2);
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("sendBroadcastAsUser", $$robo$$android_app_ContextImpl$sendBroadcastAsUser(android.content.Intent android.os.UserHandle ), this, intent, userHandle);
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle userHandle, String string2) {
        InvokeDynamicSupport.bootstrap("sendBroadcastAsUser", $$robo$$android_app_ContextImpl$sendBroadcastAsUser(android.content.Intent android.os.UserHandle java.lang.String ), this, intent, userHandle, string2);
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle userHandle, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendBroadcastAsUser", $$robo$$android_app_ContextImpl$sendBroadcastAsUser(android.content.Intent android.os.UserHandle java.lang.String android.os.Bundle ), this, intent, userHandle, string2, bundle);
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle userHandle, String string2, int n) {
        InvokeDynamicSupport.bootstrap("sendBroadcastAsUser", $$robo$$android_app_ContextImpl$sendBroadcastAsUser(android.content.Intent android.os.UserHandle java.lang.String int ), this, intent, userHandle, string2, n);
    }

    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle userHandle, String string2, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string3, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendOrderedBroadcastAsUser", $$robo$$android_app_ContextImpl$sendOrderedBroadcastAsUser(android.content.Intent android.os.UserHandle java.lang.String android.content.BroadcastReceiver android.os.Handler int java.lang.String android.os.Bundle ), this, intent, userHandle, string2, broadcastReceiver, handler, n, string3, bundle);
    }

    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle userHandle, String string2, int n, BroadcastReceiver broadcastReceiver, Handler handler, int n2, String string3, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendOrderedBroadcastAsUser", $$robo$$android_app_ContextImpl$sendOrderedBroadcastAsUser(android.content.Intent android.os.UserHandle java.lang.String int android.content.BroadcastReceiver android.os.Handler int java.lang.String android.os.Bundle ), this, intent, userHandle, string2, n, broadcastReceiver, handler, n2, string3, bundle);
    }

    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle userHandle, String string2, int n, Bundle bundle, BroadcastReceiver broadcastReceiver, Handler handler, int n2, String string3, Bundle bundle2) {
        InvokeDynamicSupport.bootstrap("sendOrderedBroadcastAsUser", $$robo$$android_app_ContextImpl$sendOrderedBroadcastAsUser(android.content.Intent android.os.UserHandle java.lang.String int android.os.Bundle android.content.BroadcastReceiver android.os.Handler int java.lang.String android.os.Bundle ), this, intent, userHandle, string2, n, bundle, broadcastReceiver, handler, n2, string3, bundle2);
    }

    @Override
    @Deprecated
    public void sendStickyBroadcast(Intent intent) {
        InvokeDynamicSupport.bootstrap("sendStickyBroadcast", $$robo$$android_app_ContextImpl$sendStickyBroadcast(android.content.Intent ), this, intent);
    }

    @Override
    @Deprecated
    public void sendStickyOrderedBroadcast(Intent intent, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendStickyOrderedBroadcast", $$robo$$android_app_ContextImpl$sendStickyOrderedBroadcast(android.content.Intent android.content.BroadcastReceiver android.os.Handler int java.lang.String android.os.Bundle ), this, intent, broadcastReceiver, handler, n, string2, bundle);
    }

    @Override
    @Deprecated
    public void removeStickyBroadcast(Intent intent) {
        InvokeDynamicSupport.bootstrap("removeStickyBroadcast", $$robo$$android_app_ContextImpl$removeStickyBroadcast(android.content.Intent ), this, intent);
    }

    @Override
    @Deprecated
    public void sendStickyBroadcastAsUser(Intent intent, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("sendStickyBroadcastAsUser", $$robo$$android_app_ContextImpl$sendStickyBroadcastAsUser(android.content.Intent android.os.UserHandle ), this, intent, userHandle);
    }

    @Override
    @Deprecated
    public void sendStickyBroadcastAsUser(Intent intent, UserHandle userHandle, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendStickyBroadcastAsUser", $$robo$$android_app_ContextImpl$sendStickyBroadcastAsUser(android.content.Intent android.os.UserHandle android.os.Bundle ), this, intent, userHandle, bundle);
    }

    @Override
    @Deprecated
    public void sendStickyOrderedBroadcastAsUser(Intent intent, UserHandle userHandle, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendStickyOrderedBroadcastAsUser", $$robo$$android_app_ContextImpl$sendStickyOrderedBroadcastAsUser(android.content.Intent android.os.UserHandle android.content.BroadcastReceiver android.os.Handler int java.lang.String android.os.Bundle ), this, intent, userHandle, broadcastReceiver, handler, n, string2, bundle);
    }

    @Override
    @Deprecated
    public void removeStickyBroadcastAsUser(Intent intent, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("removeStickyBroadcastAsUser", $$robo$$android_app_ContextImpl$removeStickyBroadcastAsUser(android.content.Intent android.os.UserHandle ), this, intent, userHandle);
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        return InvokeDynamicSupport.bootstrap("registerReceiver", $$robo$$android_app_ContextImpl$registerReceiver(android.content.BroadcastReceiver android.content.IntentFilter ), this, broadcastReceiver, intentFilter);
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, int n) {
        return InvokeDynamicSupport.bootstrap("registerReceiver", $$robo$$android_app_ContextImpl$registerReceiver(android.content.BroadcastReceiver android.content.IntentFilter int ), this, broadcastReceiver, intentFilter, n);
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, String string2, Handler handler) {
        return InvokeDynamicSupport.bootstrap("registerReceiver", $$robo$$android_app_ContextImpl$registerReceiver(android.content.BroadcastReceiver android.content.IntentFilter java.lang.String android.os.Handler ), this, broadcastReceiver, intentFilter, string2, handler);
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, String string2, Handler handler, int n) {
        return InvokeDynamicSupport.bootstrap("registerReceiver", $$robo$$android_app_ContextImpl$registerReceiver(android.content.BroadcastReceiver android.content.IntentFilter java.lang.String android.os.Handler int ), this, broadcastReceiver, intentFilter, string2, handler, n);
    }

    @Override
    public Intent registerReceiverAsUser(BroadcastReceiver broadcastReceiver, UserHandle userHandle, IntentFilter intentFilter, String string2, Handler handler) {
        return InvokeDynamicSupport.bootstrap("registerReceiverAsUser", $$robo$$android_app_ContextImpl$registerReceiverAsUser(android.content.BroadcastReceiver android.os.UserHandle android.content.IntentFilter java.lang.String android.os.Handler ), this, broadcastReceiver, userHandle, intentFilter, string2, handler);
    }

    private Intent registerReceiverInternal(BroadcastReceiver broadcastReceiver, int n, IntentFilter intentFilter, String string2, Handler handler, Context context, int n2) {
        return InvokeDynamicSupport.bootstrap("registerReceiverInternal", $$robo$$android_app_ContextImpl$registerReceiverInternal(android.content.BroadcastReceiver int android.content.IntentFilter java.lang.String android.os.Handler android.content.Context int ), this, broadcastReceiver, n, intentFilter, string2, handler, context, n2);
    }

    @Override
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        InvokeDynamicSupport.bootstrap("unregisterReceiver", $$robo$$android_app_ContextImpl$unregisterReceiver(android.content.BroadcastReceiver ), this, broadcastReceiver);
    }

    private void validateServiceIntent(Intent intent) {
        InvokeDynamicSupport.bootstrap("validateServiceIntent", $$robo$$android_app_ContextImpl$validateServiceIntent(android.content.Intent ), this, intent);
    }

    @Override
    public ComponentName startService(Intent intent) {
        return InvokeDynamicSupport.bootstrap("startService", $$robo$$android_app_ContextImpl$startService(android.content.Intent ), this, intent);
    }

    @Override
    public ComponentName startForegroundService(Intent intent) {
        return InvokeDynamicSupport.bootstrap("startForegroundService", $$robo$$android_app_ContextImpl$startForegroundService(android.content.Intent ), this, intent);
    }

    @Override
    public boolean stopService(Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrap("stopService", $$robo$$android_app_ContextImpl$stopService(android.content.Intent ), this, intent);
    }

    @Override
    public ComponentName startServiceAsUser(Intent intent, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("startServiceAsUser", $$robo$$android_app_ContextImpl$startServiceAsUser(android.content.Intent android.os.UserHandle ), this, intent, userHandle);
    }

    @Override
    public ComponentName startForegroundServiceAsUser(Intent intent, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("startForegroundServiceAsUser", $$robo$$android_app_ContextImpl$startForegroundServiceAsUser(android.content.Intent android.os.UserHandle ), this, intent, userHandle);
    }

    private ComponentName startServiceCommon(Intent intent, boolean bl, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("startServiceCommon", $$robo$$android_app_ContextImpl$startServiceCommon(android.content.Intent boolean android.os.UserHandle ), this, intent, bl, userHandle);
    }

    @Override
    public boolean stopServiceAsUser(Intent intent, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("stopServiceAsUser", $$robo$$android_app_ContextImpl$stopServiceAsUser(android.content.Intent android.os.UserHandle ), this, intent, userHandle);
    }

    private boolean stopServiceCommon(Intent intent, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("stopServiceCommon", $$robo$$android_app_ContextImpl$stopServiceCommon(android.content.Intent android.os.UserHandle ), this, intent, userHandle);
    }

    @Override
    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("bindService", $$robo$$android_app_ContextImpl$bindService(android.content.Intent android.content.ServiceConnection int ), this, intent, serviceConnection, n);
    }

    @Override
    public boolean bindServiceAsUser(Intent intent, ServiceConnection serviceConnection, int n, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("bindServiceAsUser", $$robo$$android_app_ContextImpl$bindServiceAsUser(android.content.Intent android.content.ServiceConnection int android.os.UserHandle ), this, intent, serviceConnection, n, userHandle);
    }

    @Override
    public boolean bindServiceAsUser(Intent intent, ServiceConnection serviceConnection, int n, Handler handler, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("bindServiceAsUser", $$robo$$android_app_ContextImpl$bindServiceAsUser(android.content.Intent android.content.ServiceConnection int android.os.Handler android.os.UserHandle ), this, intent, serviceConnection, n, handler, userHandle);
    }

    @Override
    public IServiceConnection getServiceDispatcher(ServiceConnection serviceConnection, Handler handler, int n) {
        return InvokeDynamicSupport.bootstrap("getServiceDispatcher", $$robo$$android_app_ContextImpl$getServiceDispatcher(android.content.ServiceConnection android.os.Handler int ), this, serviceConnection, handler, n);
    }

    @Override
    public IApplicationThread getIApplicationThread() {
        return InvokeDynamicSupport.bootstrap("getIApplicationThread", $$robo$$android_app_ContextImpl$getIApplicationThread(), this);
    }

    @Override
    public Handler getMainThreadHandler() {
        return InvokeDynamicSupport.bootstrap("getMainThreadHandler", $$robo$$android_app_ContextImpl$getMainThreadHandler(), this);
    }

    private boolean bindServiceCommon(Intent intent, ServiceConnection serviceConnection, int n, Handler handler, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("bindServiceCommon", $$robo$$android_app_ContextImpl$bindServiceCommon(android.content.Intent android.content.ServiceConnection int android.os.Handler android.os.UserHandle ), this, intent, serviceConnection, n, handler, userHandle);
    }

    @Override
    public void unbindService(ServiceConnection serviceConnection) {
        InvokeDynamicSupport.bootstrap("unbindService", $$robo$$android_app_ContextImpl$unbindService(android.content.ServiceConnection ), this, serviceConnection);
    }

    @Override
    public boolean startInstrumentation(ComponentName componentName, String string2, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("startInstrumentation", $$robo$$android_app_ContextImpl$startInstrumentation(android.content.ComponentName java.lang.String android.os.Bundle ), this, componentName, string2, bundle);
    }

    @Override
    public Object getSystemService(String string2) {
        return InvokeDynamicSupport.bootstrap("getSystemService", $$robo$$android_app_ContextImpl$getSystemService(java.lang.String ), this, string2);
    }

    @Override
    public String getSystemServiceName(Class<?> clazz) {
        return InvokeDynamicSupport.bootstrap("getSystemServiceName", $$robo$$android_app_ContextImpl$getSystemServiceName(java.lang.Class<?> ), this, clazz);
    }

    @Override
    public int checkPermission(String string2, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("checkPermission", $$robo$$android_app_ContextImpl$checkPermission(java.lang.String int int ), this, string2, n, n2);
    }

    @Override
    public int checkPermission(String string2, int n, int n2, IBinder iBinder) {
        return (int)InvokeDynamicSupport.bootstrap("checkPermission", $$robo$$android_app_ContextImpl$checkPermission(java.lang.String int int android.os.IBinder ), this, string2, n, n2, iBinder);
    }

    @Override
    public int checkCallingPermission(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("checkCallingPermission", $$robo$$android_app_ContextImpl$checkCallingPermission(java.lang.String ), this, string2);
    }

    @Override
    public int checkCallingOrSelfPermission(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("checkCallingOrSelfPermission", $$robo$$android_app_ContextImpl$checkCallingOrSelfPermission(java.lang.String ), this, string2);
    }

    @Override
    public int checkSelfPermission(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("checkSelfPermission", $$robo$$android_app_ContextImpl$checkSelfPermission(java.lang.String ), this, string2);
    }

    private void enforce(String string2, int n, boolean bl, int n2, String string3) {
        InvokeDynamicSupport.bootstrap("enforce", $$robo$$android_app_ContextImpl$enforce(java.lang.String int boolean int java.lang.String ), this, string2, n, bl, n2, string3);
    }

    @Override
    public void enforcePermission(String string2, int n, int n2, String string3) {
        InvokeDynamicSupport.bootstrap("enforcePermission", $$robo$$android_app_ContextImpl$enforcePermission(java.lang.String int int java.lang.String ), this, string2, n, n2, string3);
    }

    @Override
    public void enforceCallingPermission(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("enforceCallingPermission", $$robo$$android_app_ContextImpl$enforceCallingPermission(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public void enforceCallingOrSelfPermission(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("enforceCallingOrSelfPermission", $$robo$$android_app_ContextImpl$enforceCallingOrSelfPermission(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public void grantUriPermission(String string2, Uri uri, int n) {
        InvokeDynamicSupport.bootstrap("grantUriPermission", $$robo$$android_app_ContextImpl$grantUriPermission(java.lang.String android.net.Uri int ), this, string2, uri, n);
    }

    @Override
    public void revokeUriPermission(Uri uri, int n) {
        InvokeDynamicSupport.bootstrap("revokeUriPermission", $$robo$$android_app_ContextImpl$revokeUriPermission(android.net.Uri int ), this, uri, n);
    }

    @Override
    public void revokeUriPermission(String string2, Uri uri, int n) {
        InvokeDynamicSupport.bootstrap("revokeUriPermission", $$robo$$android_app_ContextImpl$revokeUriPermission(java.lang.String android.net.Uri int ), this, string2, uri, n);
    }

    @Override
    public int checkUriPermission(Uri uri, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("checkUriPermission", $$robo$$android_app_ContextImpl$checkUriPermission(android.net.Uri int int int ), this, uri, n, n2, n3);
    }

    @Override
    public int checkUriPermission(Uri uri, int n, int n2, int n3, IBinder iBinder) {
        return (int)InvokeDynamicSupport.bootstrap("checkUriPermission", $$robo$$android_app_ContextImpl$checkUriPermission(android.net.Uri int int int android.os.IBinder ), this, uri, n, n2, n3, iBinder);
    }

    private int resolveUserId(Uri uri) {
        return (int)InvokeDynamicSupport.bootstrap("resolveUserId", $$robo$$android_app_ContextImpl$resolveUserId(android.net.Uri ), this, uri);
    }

    @Override
    public int checkCallingUriPermission(Uri uri, int n) {
        return (int)InvokeDynamicSupport.bootstrap("checkCallingUriPermission", $$robo$$android_app_ContextImpl$checkCallingUriPermission(android.net.Uri int ), this, uri, n);
    }

    @Override
    public int checkCallingOrSelfUriPermission(Uri uri, int n) {
        return (int)InvokeDynamicSupport.bootstrap("checkCallingOrSelfUriPermission", $$robo$$android_app_ContextImpl$checkCallingOrSelfUriPermission(android.net.Uri int ), this, uri, n);
    }

    @Override
    public int checkUriPermission(Uri uri, String string2, String string3, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("checkUriPermission", $$robo$$android_app_ContextImpl$checkUriPermission(android.net.Uri java.lang.String java.lang.String int int int ), this, uri, string2, string3, n, n2, n3);
    }

    private String uriModeFlagToString(int n) {
        return InvokeDynamicSupport.bootstrap("uriModeFlagToString", $$robo$$android_app_ContextImpl$uriModeFlagToString(int ), this, n);
    }

    private void enforceForUri(int n, int n2, boolean bl, int n3, Uri uri, String string2) {
        InvokeDynamicSupport.bootstrap("enforceForUri", $$robo$$android_app_ContextImpl$enforceForUri(int int boolean int android.net.Uri java.lang.String ), this, n, n2, bl, n3, uri, string2);
    }

    @Override
    public void enforceUriPermission(Uri uri, int n, int n2, int n3, String string2) {
        InvokeDynamicSupport.bootstrap("enforceUriPermission", $$robo$$android_app_ContextImpl$enforceUriPermission(android.net.Uri int int int java.lang.String ), this, uri, n, n2, n3, string2);
    }

    @Override
    public void enforceCallingUriPermission(Uri uri, int n, String string2) {
        InvokeDynamicSupport.bootstrap("enforceCallingUriPermission", $$robo$$android_app_ContextImpl$enforceCallingUriPermission(android.net.Uri int java.lang.String ), this, uri, n, string2);
    }

    @Override
    public void enforceCallingOrSelfUriPermission(Uri uri, int n, String string2) {
        InvokeDynamicSupport.bootstrap("enforceCallingOrSelfUriPermission", $$robo$$android_app_ContextImpl$enforceCallingOrSelfUriPermission(android.net.Uri int java.lang.String ), this, uri, n, string2);
    }

    @Override
    public void enforceUriPermission(Uri uri, String string2, String string3, int n, int n2, int n3, String string4) {
        InvokeDynamicSupport.bootstrap("enforceUriPermission", $$robo$$android_app_ContextImpl$enforceUriPermission(android.net.Uri java.lang.String java.lang.String int int int java.lang.String ), this, uri, string2, string3, n, n2, n3, string4);
    }

    private void warnIfCallingFromSystemProcess() {
        InvokeDynamicSupport.bootstrap("warnIfCallingFromSystemProcess", $$robo$$android_app_ContextImpl$warnIfCallingFromSystemProcess(), this);
    }

    private static Resources createResources(IBinder iBinder, LoadedApk loadedApk, String string2, int n, Configuration configuration, CompatibilityInfo compatibilityInfo) {
        return InvokeDynamicSupport.bootstrapStatic("createResources", $$robo$$android_app_ContextImpl$createResources(android.os.IBinder android.app.LoadedApk java.lang.String int android.content.res.Configuration android.content.res.CompatibilityInfo ), (IBinder)iBinder, (LoadedApk)loadedApk, (String)string2, (int)n, (Configuration)configuration, (CompatibilityInfo)compatibilityInfo);
    }

    @Override
    public Context createApplicationContext(ApplicationInfo applicationInfo, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("createApplicationContext", $$robo$$android_app_ContextImpl$createApplicationContext(android.content.pm.ApplicationInfo int ), this, applicationInfo, n);
    }

    @Override
    public Context createPackageContext(String string2, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("createPackageContext", $$robo$$android_app_ContextImpl$createPackageContext(java.lang.String int ), this, string2, n);
    }

    @Override
    public Context createPackageContextAsUser(String string2, int n, UserHandle userHandle) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("createPackageContextAsUser", $$robo$$android_app_ContextImpl$createPackageContextAsUser(java.lang.String int android.os.UserHandle ), this, string2, n, userHandle);
    }

    @Override
    public Context createContextForSplit(String string2) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("createContextForSplit", $$robo$$android_app_ContextImpl$createContextForSplit(java.lang.String ), this, string2);
    }

    @Override
    public Context createConfigurationContext(Configuration configuration) {
        return InvokeDynamicSupport.bootstrap("createConfigurationContext", $$robo$$android_app_ContextImpl$createConfigurationContext(android.content.res.Configuration ), this, configuration);
    }

    @Override
    public Context createDisplayContext(Display display) {
        return InvokeDynamicSupport.bootstrap("createDisplayContext", $$robo$$android_app_ContextImpl$createDisplayContext(android.view.Display ), this, display);
    }

    @Override
    public Context createDeviceProtectedStorageContext() {
        return InvokeDynamicSupport.bootstrap("createDeviceProtectedStorageContext", $$robo$$android_app_ContextImpl$createDeviceProtectedStorageContext(), this);
    }

    @Override
    public Context createCredentialProtectedStorageContext() {
        return InvokeDynamicSupport.bootstrap("createCredentialProtectedStorageContext", $$robo$$android_app_ContextImpl$createCredentialProtectedStorageContext(), this);
    }

    @Override
    public boolean isRestricted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRestricted", $$robo$$android_app_ContextImpl$isRestricted(), this);
    }

    @Override
    public boolean isDeviceProtectedStorage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceProtectedStorage", $$robo$$android_app_ContextImpl$isDeviceProtectedStorage(), this);
    }

    @Override
    public boolean isCredentialProtectedStorage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCredentialProtectedStorage", $$robo$$android_app_ContextImpl$isCredentialProtectedStorage(), this);
    }

    @Override
    public boolean canLoadUnsafeResources() {
        return (boolean)InvokeDynamicSupport.bootstrap("canLoadUnsafeResources", $$robo$$android_app_ContextImpl$canLoadUnsafeResources(), this);
    }

    @Override
    public Display getDisplay() {
        return InvokeDynamicSupport.bootstrap("getDisplay", $$robo$$android_app_ContextImpl$getDisplay(), this);
    }

    @Override
    public void updateDisplay(int n) {
        InvokeDynamicSupport.bootstrap("updateDisplay", $$robo$$android_app_ContextImpl$updateDisplay(int ), this, n);
    }

    @Override
    public DisplayAdjustments getDisplayAdjustments(int n) {
        return InvokeDynamicSupport.bootstrap("getDisplayAdjustments", $$robo$$android_app_ContextImpl$getDisplayAdjustments(int ), this, n);
    }

    @Override
    public File getDataDir() {
        return InvokeDynamicSupport.bootstrap("getDataDir", $$robo$$android_app_ContextImpl$getDataDir(), this);
    }

    @Override
    public File getDir(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getDir", $$robo$$android_app_ContextImpl$getDir(java.lang.String int ), this, string2, n);
    }

    @Override
    public UserHandle getUser() {
        return InvokeDynamicSupport.bootstrap("getUser", $$robo$$android_app_ContextImpl$getUser(), this);
    }

    @Override
    public int getUserId() {
        return (int)InvokeDynamicSupport.bootstrap("getUserId", $$robo$$android_app_ContextImpl$getUserId(), this);
    }

    @Override
    public AutofillManager.AutofillClient getAutofillClient() {
        return InvokeDynamicSupport.bootstrap("getAutofillClient", $$robo$$android_app_ContextImpl$getAutofillClient(), this);
    }

    @Override
    public void setAutofillClient(AutofillManager.AutofillClient autofillClient) {
        InvokeDynamicSupport.bootstrap("setAutofillClient", $$robo$$android_app_ContextImpl$setAutofillClient(android.view.autofill.AutofillManager$AutofillClient ), this, autofillClient);
    }

    @Override
    public boolean isAutofillCompatibilityEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutofillCompatibilityEnabled", $$robo$$android_app_ContextImpl$isAutofillCompatibilityEnabled(), this);
    }

    @Override
    public void setAutofillCompatibilityEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutofillCompatibilityEnabled", $$robo$$android_app_ContextImpl$setAutofillCompatibilityEnabled(boolean ), this, bl);
    }

    static ContextImpl createSystemContext(ActivityThread activityThread) {
        return InvokeDynamicSupport.bootstrapStatic("createSystemContext", $$robo$$android_app_ContextImpl$createSystemContext(android.app.ActivityThread ), (ActivityThread)activityThread);
    }

    static ContextImpl createSystemUiContext(ContextImpl contextImpl) {
        return InvokeDynamicSupport.bootstrapStatic("createSystemUiContext", $$robo$$android_app_ContextImpl$createSystemUiContext(android.app.ContextImpl ), (ContextImpl)contextImpl);
    }

    static ContextImpl createAppContext(ActivityThread activityThread, LoadedApk loadedApk) {
        return InvokeDynamicSupport.bootstrapStatic("createAppContext", $$robo$$android_app_ContextImpl$createAppContext(android.app.ActivityThread android.app.LoadedApk ), (ActivityThread)activityThread, (LoadedApk)loadedApk);
    }

    static ContextImpl createActivityContext(ActivityThread activityThread, LoadedApk loadedApk, ActivityInfo activityInfo, IBinder iBinder, int n, Configuration configuration) {
        return InvokeDynamicSupport.bootstrapStatic("createActivityContext", $$robo$$android_app_ContextImpl$createActivityContext(android.app.ActivityThread android.app.LoadedApk android.content.pm.ActivityInfo android.os.IBinder int android.content.res.Configuration ), (ActivityThread)activityThread, (LoadedApk)loadedApk, (ActivityInfo)activityInfo, (IBinder)iBinder, (int)n, (Configuration)configuration);
    }

    private void __constructor__(ContextImpl contextImpl, ActivityThread activityThread, LoadedApk loadedApk, String string2, IBinder iBinder, UserHandle userHandle, int n, ClassLoader classLoader) {
        this.$$robo$$android_app_ContextImpl$__constructor__(contextImpl, activityThread, loadedApk, string2, iBinder, userHandle, n, classLoader);
    }

    public ContextImpl(ContextImpl contextImpl, ActivityThread activityThread, LoadedApk loadedApk, String string2, IBinder iBinder, UserHandle userHandle, int n, ClassLoader classLoader) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ContextImpl$__constructor__(android.app.ContextImpl android.app.ActivityThread android.app.LoadedApk java.lang.String android.os.IBinder android.os.UserHandle int java.lang.ClassLoader ), this, contextImpl, activityThread, loadedApk, string2, iBinder, userHandle, n, classLoader);
    }

    void setResources(Resources resources) {
        InvokeDynamicSupport.bootstrap("setResources", $$robo$$android_app_ContextImpl$setResources(android.content.res.Resources ), this, resources);
    }

    void installSystemApplicationInfo(ApplicationInfo applicationInfo, ClassLoader classLoader) {
        InvokeDynamicSupport.bootstrap("installSystemApplicationInfo", $$robo$$android_app_ContextImpl$installSystemApplicationInfo(android.content.pm.ApplicationInfo java.lang.ClassLoader ), this, applicationInfo, classLoader);
    }

    void scheduleFinalCleanup(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("scheduleFinalCleanup", $$robo$$android_app_ContextImpl$scheduleFinalCleanup(java.lang.String java.lang.String ), this, string2, string3);
    }

    void performFinalCleanup(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("performFinalCleanup", $$robo$$android_app_ContextImpl$performFinalCleanup(java.lang.String java.lang.String ), this, string2, string3);
    }

    Context getReceiverRestrictedContext() {
        return InvokeDynamicSupport.bootstrap("getReceiverRestrictedContext", $$robo$$android_app_ContextImpl$getReceiverRestrictedContext(), this);
    }

    void setOuterContext(Context context) {
        InvokeDynamicSupport.bootstrap("setOuterContext", $$robo$$android_app_ContextImpl$setOuterContext(android.content.Context ), this, context);
    }

    Context getOuterContext() {
        return InvokeDynamicSupport.bootstrap("getOuterContext", $$robo$$android_app_ContextImpl$getOuterContext(), this);
    }

    @Override
    public IBinder getActivityToken() {
        return InvokeDynamicSupport.bootstrap("getActivityToken", $$robo$$android_app_ContextImpl$getActivityToken(), this);
    }

    private void checkMode(int n) {
        InvokeDynamicSupport.bootstrap("checkMode", $$robo$$android_app_ContextImpl$checkMode(int ), this, n);
    }

    static void setFilePermissionsFromMode(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("setFilePermissionsFromMode", $$robo$$android_app_ContextImpl$setFilePermissionsFromMode(java.lang.String int int ), (String)string2, (int)n, (int)n2);
    }

    private File makeFilename(File file, String string2) {
        return InvokeDynamicSupport.bootstrap("makeFilename", $$robo$$android_app_ContextImpl$makeFilename(java.io.File java.lang.String ), this, file, string2);
    }

    private File[] ensureExternalDirsExistOrFilter(File[] fileArray) {
        return InvokeDynamicSupport.bootstrap("ensureExternalDirsExistOrFilter", $$robo$$android_app_ContextImpl$ensureExternalDirsExistOrFilter(java.io.File[] ), this, fileArray);
    }

    public /* synthetic */ ContextImpl() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContextImpl)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ApplicationContentResolver
    extends ContentResolver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ActivityThread mMainThread;

        private void $$robo$$android_app_ContextImpl_ApplicationContentResolver$__constructor__(Context context, ActivityThread mainThread) {
            this.mMainThread = Preconditions.checkNotNull(mainThread);
        }

        private final IContentProvider $$robo$$android_app_ContextImpl_ApplicationContentResolver$acquireProvider(Context context, String auth) {
            return this.mMainThread.acquireProvider(context, ContentProvider.getAuthorityWithoutUserId(auth), this.resolveUserIdFromAuthority(auth), true);
        }

        private final IContentProvider $$robo$$android_app_ContextImpl_ApplicationContentResolver$acquireExistingProvider(Context context, String auth) {
            return this.mMainThread.acquireExistingProvider(context, ContentProvider.getAuthorityWithoutUserId(auth), this.resolveUserIdFromAuthority(auth), true);
        }

        private final boolean $$robo$$android_app_ContextImpl_ApplicationContentResolver$releaseProvider(IContentProvider provider) {
            return this.mMainThread.releaseProvider(provider, true);
        }

        private final IContentProvider $$robo$$android_app_ContextImpl_ApplicationContentResolver$acquireUnstableProvider(Context c, String auth) {
            return this.mMainThread.acquireProvider(c, ContentProvider.getAuthorityWithoutUserId(auth), this.resolveUserIdFromAuthority(auth), false);
        }

        private final boolean $$robo$$android_app_ContextImpl_ApplicationContentResolver$releaseUnstableProvider(IContentProvider icp) {
            return this.mMainThread.releaseProvider(icp, false);
        }

        private final void $$robo$$android_app_ContextImpl_ApplicationContentResolver$unstableProviderDied(IContentProvider icp) {
            this.mMainThread.handleUnstableProviderDied(icp.asBinder(), true);
        }

        private final void $$robo$$android_app_ContextImpl_ApplicationContentResolver$appNotRespondingViaProvider(IContentProvider icp) {
            this.mMainThread.appNotRespondingViaProvider(icp.asBinder());
        }

        private final int $$robo$$android_app_ContextImpl_ApplicationContentResolver$resolveUserIdFromAuthority(String auth) {
            return ContentProvider.getUserIdFromAuthority(auth, this.getUserId());
        }

        private void __constructor__(Context context, ActivityThread activityThread) {
            this.$$robo$$android_app_ContextImpl_ApplicationContentResolver$__constructor__(context, activityThread);
        }

        public ApplicationContentResolver(Context context, ActivityThread activityThread) {
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ContextImpl_ApplicationContentResolver$__constructor__(android.content.Context android.app.ActivityThread ), this, context, activityThread);
        }

        @Override
        protected IContentProvider acquireProvider(Context context, String string2) {
            return InvokeDynamicSupport.bootstrap("acquireProvider", $$robo$$android_app_ContextImpl_ApplicationContentResolver$acquireProvider(android.content.Context java.lang.String ), this, context, string2);
        }

        @Override
        protected IContentProvider acquireExistingProvider(Context context, String string2) {
            return InvokeDynamicSupport.bootstrap("acquireExistingProvider", $$robo$$android_app_ContextImpl_ApplicationContentResolver$acquireExistingProvider(android.content.Context java.lang.String ), this, context, string2);
        }

        @Override
        public boolean releaseProvider(IContentProvider iContentProvider) {
            return (boolean)InvokeDynamicSupport.bootstrap("releaseProvider", $$robo$$android_app_ContextImpl_ApplicationContentResolver$releaseProvider(android.content.IContentProvider ), this, iContentProvider);
        }

        @Override
        protected IContentProvider acquireUnstableProvider(Context context, String string2) {
            return InvokeDynamicSupport.bootstrap("acquireUnstableProvider", $$robo$$android_app_ContextImpl_ApplicationContentResolver$acquireUnstableProvider(android.content.Context java.lang.String ), this, context, string2);
        }

        @Override
        public boolean releaseUnstableProvider(IContentProvider iContentProvider) {
            return (boolean)InvokeDynamicSupport.bootstrap("releaseUnstableProvider", $$robo$$android_app_ContextImpl_ApplicationContentResolver$releaseUnstableProvider(android.content.IContentProvider ), this, iContentProvider);
        }

        @Override
        public void unstableProviderDied(IContentProvider iContentProvider) {
            InvokeDynamicSupport.bootstrap("unstableProviderDied", $$robo$$android_app_ContextImpl_ApplicationContentResolver$unstableProviderDied(android.content.IContentProvider ), this, iContentProvider);
        }

        @Override
        public void appNotRespondingViaProvider(IContentProvider iContentProvider) {
            InvokeDynamicSupport.bootstrap("appNotRespondingViaProvider", $$robo$$android_app_ContextImpl_ApplicationContentResolver$appNotRespondingViaProvider(android.content.IContentProvider ), this, iContentProvider);
        }

        protected int resolveUserIdFromAuthority(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("resolveUserIdFromAuthority", $$robo$$android_app_ContextImpl_ApplicationContentResolver$resolveUserIdFromAuthority(java.lang.String ), this, string2);
        }

        public /* synthetic */ ApplicationContentResolver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApplicationContentResolver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ServiceInitializationState {
    }
}

