/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.app.ContextImpl;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ChangedPackages;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IDexModuleRegisterCallback;
import android.content.pm.IOnPermissionsChangeListener;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstantAppInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.IntentFilterVerificationInfo;
import android.content.pm.KeySet;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.SharedLibraryInfo;
import android.content.pm.VerifierDeviceIdentity;
import android.content.pm.VersionedPackage;
import android.content.pm.dex.ArtManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.os.storage.VolumeInfo;
import android.provider.Settings;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.ArrayMap;
import android.util.IconDrawableFactory;
import android.util.LauncherIcons;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.Preconditions;
import com.android.internal.util.UserIcons;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.VMRuntime;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ApplicationPackageManager
extends PackageManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ApplicationPackageManager";
    private static boolean DEBUG_ICONS = false;
    private static int DEFAULT_EPHEMERAL_COOKIE_MAX_SIZE_BYTES = 16384;
    private static int sDefaultFlags = 1024;
    private Object mLock;
    @GuardedBy(value="mLock")
    private UserManager mUserManager;
    @GuardedBy(value="mLock")
    private PackageInstaller mInstaller;
    @GuardedBy(value="mLock")
    private ArtManager mArtManager;
    @GuardedBy(value="mDelegates")
    private ArrayList<MoveCallbackDelegate> mDelegates;
    @GuardedBy(value="mLock")
    private String mPermissionsControllerPackageName;
    @VisibleForTesting
    public static int[] CORP_BADGE_LABEL_RES_ID;
    volatile int mCachedSafeMode;
    private ContextImpl mContext;
    private IPackageManager mPM;
    private static Object sSync;
    private static ArrayMap<ResourceName, WeakReference<Drawable.ConstantState>> sIconCache;
    private static ArrayMap<ResourceName, WeakReference<CharSequence>> sStringCache;
    private Map<PackageManager.OnPermissionsChangedListener, IOnPermissionsChangeListener> mPermissionListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UserManager $$robo$$android_app_ApplicationPackageManager$getUserManager() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserManager == null) {
                this.mUserManager = UserManager.get(this.mContext);
            }
            return this.mUserManager;
        }
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getUserId() {
        return this.mContext.getUserId();
    }

    private final PackageInfo $$robo$$android_app_ApplicationPackageManager$getPackageInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return this.getPackageInfoAsUser(packageName, flags, this.mContext.getUserId());
    }

    private final PackageInfo $$robo$$android_app_ApplicationPackageManager$getPackageInfo(VersionedPackage versionedPackage, int flags) throws PackageManager.NameNotFoundException {
        try {
            PackageInfo pi = this.mPM.getPackageInfoVersioned(versionedPackage, flags, this.mContext.getUserId());
            if (pi != null) {
                return pi;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(versionedPackage.toString());
    }

    private final PackageInfo $$robo$$android_app_ApplicationPackageManager$getPackageInfoAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        try {
            PackageInfo pi = this.mPM.getPackageInfo(packageName, flags, userId);
            if (pi != null) {
                return pi;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    private final String[] $$robo$$android_app_ApplicationPackageManager$currentToCanonicalPackageNames(String[] names) {
        try {
            return this.mPM.currentToCanonicalPackageNames(names);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String[] $$robo$$android_app_ApplicationPackageManager$canonicalToCurrentPackageNames(String[] names) {
        try {
            return this.mPM.canonicalToCurrentPackageNames(names);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Intent $$robo$$android_app_ApplicationPackageManager$getLaunchIntentForPackage(String packageName) {
        Intent intentToResolve = new Intent("android.intent.action.MAIN");
        intentToResolve.addCategory("android.intent.category.INFO");
        intentToResolve.setPackage(packageName);
        List<ResolveInfo> ris = this.queryIntentActivities(intentToResolve, 0);
        if (ris == null || ris.size() <= 0) {
            intentToResolve.removeCategory("android.intent.category.INFO");
            intentToResolve.addCategory("android.intent.category.LAUNCHER");
            intentToResolve.setPackage(packageName);
            ris = this.queryIntentActivities(intentToResolve, 0);
        }
        if (ris == null || ris.size() <= 0) {
            return null;
        }
        Intent intent = new Intent(intentToResolve);
        intent.setFlags(0x10000000);
        intent.setClassName(ris.get((int)0).activityInfo.packageName, ris.get((int)0).activityInfo.name);
        return intent;
    }

    private final Intent $$robo$$android_app_ApplicationPackageManager$getLeanbackLaunchIntentForPackage(String packageName) {
        return this.getLaunchIntentForPackageAndCategory(packageName, "android.intent.category.LEANBACK_LAUNCHER");
    }

    private final Intent $$robo$$android_app_ApplicationPackageManager$getCarLaunchIntentForPackage(String packageName) {
        return this.getLaunchIntentForPackageAndCategory(packageName, "android.intent.category.CAR_LAUNCHER");
    }

    private final Intent $$robo$$android_app_ApplicationPackageManager$getLaunchIntentForPackageAndCategory(String packageName, String category) {
        Intent intentToResolve = new Intent("android.intent.action.MAIN");
        intentToResolve.addCategory(category);
        intentToResolve.setPackage(packageName);
        List<ResolveInfo> ris = this.queryIntentActivities(intentToResolve, 0);
        if (ris == null || ris.size() <= 0) {
            return null;
        }
        Intent intent = new Intent(intentToResolve);
        intent.setFlags(0x10000000);
        intent.setClassName(ris.get((int)0).activityInfo.packageName, ris.get((int)0).activityInfo.name);
        return intent;
    }

    private final int[] $$robo$$android_app_ApplicationPackageManager$getPackageGids(String packageName) throws PackageManager.NameNotFoundException {
        return this.getPackageGids(packageName, 0);
    }

    private final int[] $$robo$$android_app_ApplicationPackageManager$getPackageGids(String packageName, int flags) throws PackageManager.NameNotFoundException {
        try {
            int[] gids = this.mPM.getPackageGids(packageName, flags, this.mContext.getUserId());
            if (gids != null) {
                return gids;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getPackageUid(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return this.getPackageUidAsUser(packageName, flags, this.mContext.getUserId());
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getPackageUidAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return this.getPackageUidAsUser(packageName, 0, userId);
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getPackageUidAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        try {
            int uid = this.mPM.getPackageUid(packageName, flags, userId);
            if (uid >= 0) {
                return uid;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    private final PermissionInfo $$robo$$android_app_ApplicationPackageManager$getPermissionInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        try {
            PermissionInfo pi = this.mPM.getPermissionInfo(name, this.mContext.getOpPackageName(), flags);
            if (pi != null) {
                return pi;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(name);
    }

    private final List<PermissionInfo> $$robo$$android_app_ApplicationPackageManager$queryPermissionsByGroup(String group, int flags) throws PackageManager.NameNotFoundException {
        try {
            List pi;
            ParceledListSlice parceledList = this.mPM.queryPermissionsByGroup(group, flags);
            if (parceledList != null && (pi = parceledList.getList()) != null) {
                return pi;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(group);
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isPermissionReviewModeEnabled() {
        return this.mContext.getResources().getBoolean(17957002);
    }

    private final PermissionGroupInfo $$robo$$android_app_ApplicationPackageManager$getPermissionGroupInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        try {
            PermissionGroupInfo pgi = this.mPM.getPermissionGroupInfo(name, flags);
            if (pgi != null) {
                return pgi;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(name);
    }

    private final List<PermissionGroupInfo> $$robo$$android_app_ApplicationPackageManager$getAllPermissionGroups(int flags) {
        try {
            ParceledListSlice parceledList = this.mPM.getAllPermissionGroups(flags);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ApplicationInfo $$robo$$android_app_ApplicationPackageManager$getApplicationInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return this.getApplicationInfoAsUser(packageName, flags, this.mContext.getUserId());
    }

    private final ApplicationInfo $$robo$$android_app_ApplicationPackageManager$getApplicationInfoAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        try {
            ApplicationInfo ai = this.mPM.getApplicationInfo(packageName, flags, userId);
            if (ai != null) {
                return ApplicationPackageManager.maybeAdjustApplicationInfo(ai);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    private static final ApplicationInfo $$robo$$android_app_ApplicationPackageManager$maybeAdjustApplicationInfo(ApplicationInfo info) {
        if (info.primaryCpuAbi != null && info.secondaryCpuAbi != null) {
            String runtimeIsa = VMRuntime.getRuntime().vmInstructionSet();
            String secondaryIsa = VMRuntime.getInstructionSet(info.secondaryCpuAbi);
            String secondaryDexCodeIsa = SystemProperties.get("ro.dalvik.vm.isa." + secondaryIsa);
            String string2 = secondaryIsa = secondaryDexCodeIsa.isEmpty() ? secondaryIsa : secondaryDexCodeIsa;
            if (runtimeIsa.equals(secondaryIsa)) {
                ApplicationInfo modified = new ApplicationInfo(info);
                modified.nativeLibraryDir = info.secondaryNativeLibraryDir;
                return modified;
            }
        }
        return info;
    }

    private final ActivityInfo $$robo$$android_app_ApplicationPackageManager$getActivityInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        try {
            ActivityInfo ai = this.mPM.getActivityInfo(className, flags, this.mContext.getUserId());
            if (ai != null) {
                return ai;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    private final ActivityInfo $$robo$$android_app_ApplicationPackageManager$getReceiverInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        try {
            ActivityInfo ai = this.mPM.getReceiverInfo(className, flags, this.mContext.getUserId());
            if (ai != null) {
                return ai;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    private final ServiceInfo $$robo$$android_app_ApplicationPackageManager$getServiceInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        try {
            ServiceInfo si = this.mPM.getServiceInfo(className, flags, this.mContext.getUserId());
            if (si != null) {
                return si;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    private final ProviderInfo $$robo$$android_app_ApplicationPackageManager$getProviderInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        try {
            ProviderInfo pi = this.mPM.getProviderInfo(className, flags, this.mContext.getUserId());
            if (pi != null) {
                return pi;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    private final String[] $$robo$$android_app_ApplicationPackageManager$getSystemSharedLibraryNames() {
        try {
            return this.mPM.getSystemSharedLibraryNames();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<SharedLibraryInfo> $$robo$$android_app_ApplicationPackageManager$getSharedLibraries(int flags) {
        return this.getSharedLibrariesAsUser(flags, this.mContext.getUserId());
    }

    private final List<SharedLibraryInfo> $$robo$$android_app_ApplicationPackageManager$getSharedLibrariesAsUser(int flags, int userId) {
        try {
            ParceledListSlice sharedLibs = this.mPM.getSharedLibraries(this.mContext.getOpPackageName(), flags, userId);
            if (sharedLibs == null) {
                return Collections.emptyList();
            }
            return sharedLibs.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_app_ApplicationPackageManager$getServicesSystemSharedLibraryPackageName() {
        try {
            return this.mPM.getServicesSystemSharedLibraryPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_app_ApplicationPackageManager$getSharedSystemSharedLibraryPackageName() {
        try {
            return this.mPM.getSharedSystemSharedLibraryPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ChangedPackages $$robo$$android_app_ApplicationPackageManager$getChangedPackages(int sequenceNumber) {
        try {
            return this.mPM.getChangedPackages(sequenceNumber, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final FeatureInfo[] $$robo$$android_app_ApplicationPackageManager$getSystemAvailableFeatures() {
        try {
            ParceledListSlice parceledList = this.mPM.getSystemAvailableFeatures();
            if (parceledList == null) {
                return new FeatureInfo[0];
            }
            List list = parceledList.getList();
            FeatureInfo[] res = new FeatureInfo[list.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (FeatureInfo)list.get(i);
            }
            return res;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$hasSystemFeature(String name) {
        return this.hasSystemFeature(name, 0);
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$hasSystemFeature(String name, int version) {
        try {
            return this.mPM.hasSystemFeature(name, version);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ApplicationPackageManager$checkPermission(String permName, String pkgName) {
        try {
            return this.mPM.checkPermission(permName, pkgName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isPermissionRevokedByPolicy(String permName, String pkgName) {
        try {
            return this.mPM.isPermissionRevokedByPolicy(permName, pkgName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_app_ApplicationPackageManager$getPermissionControllerPackageName() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPermissionsControllerPackageName == null) {
                try {
                    this.mPermissionsControllerPackageName = this.mPM.getPermissionControllerPackageName();
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            return this.mPermissionsControllerPackageName;
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$addPermission(PermissionInfo info) {
        try {
            return this.mPM.addPermission(info);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$addPermissionAsync(PermissionInfo info) {
        try {
            return this.mPM.addPermissionAsync(info);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$removePermission(String name) {
        try {
            this.mPM.removePermission(name);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$grantRuntimePermission(String packageName, String permissionName, UserHandle user) {
        try {
            this.mPM.grantRuntimePermission(packageName, permissionName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$revokeRuntimePermission(String packageName, String permissionName, UserHandle user) {
        try {
            this.mPM.revokeRuntimePermission(packageName, permissionName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getPermissionFlags(String permissionName, String packageName, UserHandle user) {
        try {
            return this.mPM.getPermissionFlags(permissionName, packageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$updatePermissionFlags(String permissionName, String packageName, int flagMask, int flagValues, UserHandle user) {
        try {
            this.mPM.updatePermissionFlags(permissionName, packageName, flagMask, flagValues, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$shouldShowRequestPermissionRationale(String permission2) {
        try {
            return this.mPM.shouldShowRequestPermissionRationale(permission2, this.mContext.getPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ApplicationPackageManager$checkSignatures(String pkg1, String pkg2) {
        try {
            return this.mPM.checkSignatures(pkg1, pkg2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ApplicationPackageManager$checkSignatures(int uid1, int uid2) {
        try {
            return this.mPM.checkUidSignatures(uid1, uid2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$hasSigningCertificate(String packageName, byte[] certificate, int type) {
        try {
            return this.mPM.hasSigningCertificate(packageName, certificate, type);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$hasSigningCertificate(int uid, byte[] certificate, int type) {
        try {
            return this.mPM.hasUidSigningCertificate(uid, certificate, type);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String[] $$robo$$android_app_ApplicationPackageManager$getPackagesForUid(int uid) {
        try {
            return this.mPM.getPackagesForUid(uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_app_ApplicationPackageManager$getNameForUid(int uid) {
        try {
            return this.mPM.getNameForUid(uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String[] $$robo$$android_app_ApplicationPackageManager$getNamesForUids(int[] uids) {
        try {
            return this.mPM.getNamesForUids(uids);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getUidForSharedUser(String sharedUserName) throws PackageManager.NameNotFoundException {
        try {
            int uid = this.mPM.getUidForSharedUser(sharedUserName);
            if (uid != -1) {
                return uid;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException("No shared userid for user:" + sharedUserName);
    }

    private final List<PackageInfo> $$robo$$android_app_ApplicationPackageManager$getInstalledPackages(int flags) {
        return this.getInstalledPackagesAsUser(flags, this.mContext.getUserId());
    }

    private final List<PackageInfo> $$robo$$android_app_ApplicationPackageManager$getInstalledPackagesAsUser(int flags, int userId) {
        try {
            ParceledListSlice parceledList = this.mPM.getInstalledPackages(flags, userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<PackageInfo> $$robo$$android_app_ApplicationPackageManager$getPackagesHoldingPermissions(String[] permissions, int flags) {
        int userId = this.mContext.getUserId();
        try {
            ParceledListSlice parceledList = this.mPM.getPackagesHoldingPermissions(permissions, flags, userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ApplicationInfo> $$robo$$android_app_ApplicationPackageManager$getInstalledApplications(int flags) {
        return this.getInstalledApplicationsAsUser(flags, this.mContext.getUserId());
    }

    private final List<ApplicationInfo> $$robo$$android_app_ApplicationPackageManager$getInstalledApplicationsAsUser(int flags, int userId) {
        try {
            ParceledListSlice parceledList = this.mPM.getInstalledApplications(flags, userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<InstantAppInfo> $$robo$$android_app_ApplicationPackageManager$getInstantApps() {
        try {
            ParceledListSlice slice = this.mPM.getInstantApps(this.mContext.getUserId());
            if (slice != null) {
                return slice.getList();
            }
            return Collections.emptyList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getInstantAppIcon(String packageName) {
        try {
            Bitmap bitmap = this.mPM.getInstantAppIcon(packageName, this.mContext.getUserId());
            if (bitmap != null) {
                return new BitmapDrawable(null, bitmap);
            }
            return null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isInstantApp() {
        return this.isInstantApp(this.mContext.getPackageName());
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isInstantApp(String packageName) {
        try {
            return this.mPM.isInstantApp(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getInstantAppCookieMaxBytes() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "ephemeral_cookie_max_size_bytes", 16384);
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getInstantAppCookieMaxSize() {
        return this.getInstantAppCookieMaxBytes();
    }

    private final byte[] $$robo$$android_app_ApplicationPackageManager$getInstantAppCookie() {
        try {
            byte[] cookie = this.mPM.getInstantAppCookie(this.mContext.getPackageName(), this.mContext.getUserId());
            if (cookie != null) {
                return cookie;
            }
            return EmptyArray.BYTE;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$clearInstantAppCookie() {
        this.updateInstantAppCookie(null);
    }

    private final void $$robo$$android_app_ApplicationPackageManager$updateInstantAppCookie(byte[] cookie) {
        if (cookie != null && cookie.length > this.getInstantAppCookieMaxBytes()) {
            throw new IllegalArgumentException("instant cookie longer than " + this.getInstantAppCookieMaxBytes());
        }
        try {
            this.mPM.setInstantAppCookie(this.mContext.getPackageName(), cookie, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$setInstantAppCookie(byte[] cookie) {
        try {
            return this.mPM.setInstantAppCookie(this.mContext.getPackageName(), cookie, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ResolveInfo $$robo$$android_app_ApplicationPackageManager$resolveActivity(Intent intent, int flags) {
        return this.resolveActivityAsUser(intent, flags, this.mContext.getUserId());
    }

    private final ResolveInfo $$robo$$android_app_ApplicationPackageManager$resolveActivityAsUser(Intent intent, int flags, int userId) {
        try {
            return this.mPM.resolveIntent(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ResolveInfo> $$robo$$android_app_ApplicationPackageManager$queryIntentActivities(Intent intent, int flags) {
        return this.queryIntentActivitiesAsUser(intent, flags, this.mContext.getUserId());
    }

    private final List<ResolveInfo> $$robo$$android_app_ApplicationPackageManager$queryIntentActivitiesAsUser(Intent intent, int flags, int userId) {
        try {
            ParceledListSlice parceledList = this.mPM.queryIntentActivities(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags, userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ResolveInfo> $$robo$$android_app_ApplicationPackageManager$queryIntentActivityOptions(ComponentName caller, Intent[] specifics, Intent intent, int flags) {
        ContentResolver resolver = this.mContext.getContentResolver();
        String[] specificTypes = null;
        if (specifics != null) {
            int N = specifics.length;
            for (int i = 0; i < N; ++i) {
                String t;
                Intent sp = specifics[i];
                if (sp == null || (t = sp.resolveTypeIfNeeded(resolver)) == null) continue;
                if (specificTypes == null) {
                    specificTypes = new String[N];
                }
                specificTypes[i] = t;
            }
        }
        try {
            ParceledListSlice parceledList = this.mPM.queryIntentActivityOptions(caller, specifics, specificTypes, intent, intent.resolveTypeIfNeeded(resolver), flags, this.mContext.getUserId());
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ResolveInfo> $$robo$$android_app_ApplicationPackageManager$queryBroadcastReceiversAsUser(Intent intent, int flags, int userId) {
        try {
            ParceledListSlice parceledList = this.mPM.queryIntentReceivers(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags, userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ResolveInfo> $$robo$$android_app_ApplicationPackageManager$queryBroadcastReceivers(Intent intent, int flags) {
        return this.queryBroadcastReceiversAsUser(intent, flags, this.mContext.getUserId());
    }

    private final ResolveInfo $$robo$$android_app_ApplicationPackageManager$resolveServiceAsUser(Intent intent, int flags, int userId) {
        try {
            return this.mPM.resolveService(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ResolveInfo $$robo$$android_app_ApplicationPackageManager$resolveService(Intent intent, int flags) {
        return this.resolveServiceAsUser(intent, flags, this.mContext.getUserId());
    }

    private final List<ResolveInfo> $$robo$$android_app_ApplicationPackageManager$queryIntentServicesAsUser(Intent intent, int flags, int userId) {
        try {
            ParceledListSlice parceledList = this.mPM.queryIntentServices(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags, userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ResolveInfo> $$robo$$android_app_ApplicationPackageManager$queryIntentServices(Intent intent, int flags) {
        return this.queryIntentServicesAsUser(intent, flags, this.mContext.getUserId());
    }

    private final List<ResolveInfo> $$robo$$android_app_ApplicationPackageManager$queryIntentContentProvidersAsUser(Intent intent, int flags, int userId) {
        try {
            ParceledListSlice parceledList = this.mPM.queryIntentContentProviders(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags, userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ResolveInfo> $$robo$$android_app_ApplicationPackageManager$queryIntentContentProviders(Intent intent, int flags) {
        return this.queryIntentContentProvidersAsUser(intent, flags, this.mContext.getUserId());
    }

    private final ProviderInfo $$robo$$android_app_ApplicationPackageManager$resolveContentProvider(String name, int flags) {
        return this.resolveContentProviderAsUser(name, flags, this.mContext.getUserId());
    }

    private final ProviderInfo $$robo$$android_app_ApplicationPackageManager$resolveContentProviderAsUser(String name, int flags, int userId) {
        try {
            return this.mPM.resolveContentProvider(name, flags, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ProviderInfo> $$robo$$android_app_ApplicationPackageManager$queryContentProviders(String processName, int uid, int flags) {
        return this.queryContentProviders(processName, uid, flags, null);
    }

    private final List<ProviderInfo> $$robo$$android_app_ApplicationPackageManager$queryContentProviders(String processName, int uid, int flags, String metaDataKey) {
        try {
            ParceledListSlice slice = this.mPM.queryContentProviders(processName, uid, flags, metaDataKey);
            return slice != null ? slice.getList() : Collections.emptyList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final InstrumentationInfo $$robo$$android_app_ApplicationPackageManager$getInstrumentationInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        try {
            InstrumentationInfo ii = this.mPM.getInstrumentationInfo(className, flags);
            if (ii != null) {
                return ii;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    private final List<InstrumentationInfo> $$robo$$android_app_ApplicationPackageManager$queryInstrumentation(String targetPackage, int flags) {
        try {
            ParceledListSlice parceledList = this.mPM.queryInstrumentation(targetPackage, flags);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getDrawable(String packageName, int resId, ApplicationInfo appInfo) {
        ResourceName name = new ResourceName(packageName, resId);
        Drawable cachedIcon = this.getCachedIcon(name);
        if (cachedIcon != null) {
            return cachedIcon;
        }
        if (appInfo == null) {
            try {
                appInfo = this.getApplicationInfo(packageName, 1024);
            }
            catch (PackageManager.NameNotFoundException e) {
                return null;
            }
        }
        if (resId != 0) {
            try {
                Resources r = this.getResourcesForApplication(appInfo);
                Drawable dr = r.getDrawable(resId, null);
                if (dr != null) {
                    this.putCachedIcon(name, dr);
                }
                return dr;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w("PackageManager", "Failure retrieving resources for " + appInfo.packageName);
            }
            catch (Resources.NotFoundException e) {
                Log.w("PackageManager", "Failure retrieving resources for " + appInfo.packageName + ": " + e.getMessage());
            }
            catch (Exception e) {
                Log.w("PackageManager", "Failure retrieving icon 0x" + Integer.toHexString(resId) + " in package " + packageName, e);
            }
        }
        return null;
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getActivityIcon(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return this.getActivityInfo(activityName, 1024).loadIcon(this);
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getActivityIcon(Intent intent) throws PackageManager.NameNotFoundException {
        if (intent.getComponent() != null) {
            return this.getActivityIcon(intent.getComponent());
        }
        ResolveInfo info = this.resolveActivity(intent, 65536);
        if (info != null) {
            return info.activityInfo.loadIcon(this);
        }
        throw new PackageManager.NameNotFoundException(intent.toUri(0));
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getDefaultActivityIcon() {
        return Resources.getSystem().getDrawable(17301651);
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getApplicationIcon(ApplicationInfo info) {
        return info.loadIcon(this);
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getApplicationIcon(String packageName) throws PackageManager.NameNotFoundException {
        return this.getApplicationIcon(this.getApplicationInfo(packageName, 1024));
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getActivityBanner(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return this.getActivityInfo(activityName, 1024).loadBanner(this);
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getActivityBanner(Intent intent) throws PackageManager.NameNotFoundException {
        if (intent.getComponent() != null) {
            return this.getActivityBanner(intent.getComponent());
        }
        ResolveInfo info = this.resolveActivity(intent, 65536);
        if (info != null) {
            return info.activityInfo.loadBanner(this);
        }
        throw new PackageManager.NameNotFoundException(intent.toUri(0));
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getApplicationBanner(ApplicationInfo info) {
        return info.loadBanner(this);
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getApplicationBanner(String packageName) throws PackageManager.NameNotFoundException {
        return this.getApplicationBanner(this.getApplicationInfo(packageName, 1024));
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getActivityLogo(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return this.getActivityInfo(activityName, 1024).loadLogo(this);
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getActivityLogo(Intent intent) throws PackageManager.NameNotFoundException {
        if (intent.getComponent() != null) {
            return this.getActivityLogo(intent.getComponent());
        }
        ResolveInfo info = this.resolveActivity(intent, 65536);
        if (info != null) {
            return info.activityInfo.loadLogo(this);
        }
        throw new PackageManager.NameNotFoundException(intent.toUri(0));
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getApplicationLogo(ApplicationInfo info) {
        return info.loadLogo(this);
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getApplicationLogo(String packageName) throws PackageManager.NameNotFoundException {
        return this.getApplicationLogo(this.getApplicationInfo(packageName, 1024));
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getUserBadgedIcon(Drawable icon, UserHandle user) {
        if (!this.isManagedProfile(user.getIdentifier())) {
            return icon;
        }
        Drawable badge = new LauncherIcons(this.mContext).getBadgeDrawable(17302331, this.getUserBadgeColor(user));
        return this.getBadgedDrawable(icon, badge, null, true);
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getUserBadgedDrawableForDensity(Drawable drawable2, UserHandle user, Rect badgeLocation, int badgeDensity) {
        Drawable badgeDrawable = this.getUserBadgeForDensity(user, badgeDensity);
        if (badgeDrawable == null) {
            return drawable2;
        }
        return this.getBadgedDrawable(drawable2, badgeDrawable, badgeLocation, true);
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getUserBadgeColor(UserHandle user) {
        return IconDrawableFactory.getUserBadgeColor(this.getUserManager(), user.getIdentifier());
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getUserBadgeForDensity(UserHandle user, int density) {
        Drawable badgeColor = this.getManagedProfileIconForDensity(user, 17302327, density);
        if (badgeColor == null) {
            return null;
        }
        Drawable badgeForeground = this.getDrawableForDensity(17302326, density);
        badgeForeground.setTint(this.getUserBadgeColor(user));
        LayerDrawable badge = new LayerDrawable(new Drawable[]{badgeColor, badgeForeground});
        return badge;
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getUserBadgeForDensityNoBackground(UserHandle user, int density) {
        Drawable badge = this.getManagedProfileIconForDensity(user, 17302328, density);
        if (badge != null) {
            badge.setTint(this.getUserBadgeColor(user));
        }
        return badge;
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getDrawableForDensity(int drawableId, int density) {
        if (density <= 0) {
            density = this.mContext.getResources().getDisplayMetrics().densityDpi;
        }
        return Resources.getSystem().getDrawableForDensity(drawableId, density);
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getManagedProfileIconForDensity(UserHandle user, int drawableId, int density) {
        if (this.isManagedProfile(user.getIdentifier())) {
            return this.getDrawableForDensity(drawableId, density);
        }
        return null;
    }

    private final CharSequence $$robo$$android_app_ApplicationPackageManager$getUserBadgedLabel(CharSequence label, UserHandle user) {
        if (this.isManagedProfile(user.getIdentifier())) {
            int badge = this.getUserManager().getManagedProfileBadge(user.getIdentifier());
            int resourceId = CORP_BADGE_LABEL_RES_ID[badge % CORP_BADGE_LABEL_RES_ID.length];
            return Resources.getSystem().getString(resourceId, label);
        }
        return label;
    }

    private final Resources $$robo$$android_app_ApplicationPackageManager$getResourcesForActivity(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(this.getActivityInfo((ComponentName)activityName, (int)1024).applicationInfo);
    }

    private final Resources $$robo$$android_app_ApplicationPackageManager$getResourcesForApplication(ApplicationInfo app) throws PackageManager.NameNotFoundException {
        if (app.packageName.equals("system")) {
            return this.mContext.mMainThread.getSystemUiContext().getResources();
        }
        boolean sameUid = app.uid == Process.myUid();
        Resources r = this.mContext.mMainThread.getTopLevelResources(sameUid ? app.sourceDir : app.publicSourceDir, sameUid ? app.splitSourceDirs : app.splitPublicSourceDirs, app.resourceDirs, app.sharedLibraryFiles, 0, this.mContext.mPackageInfo);
        if (r != null) {
            return r;
        }
        throw new PackageManager.NameNotFoundException("Unable to open " + app.publicSourceDir);
    }

    private final Resources $$robo$$android_app_ApplicationPackageManager$getResourcesForApplication(String appPackageName) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(this.getApplicationInfo(appPackageName, 1024));
    }

    private final Resources $$robo$$android_app_ApplicationPackageManager$getResourcesForApplicationAsUser(String appPackageName, int userId) throws PackageManager.NameNotFoundException {
        if (userId < 0) {
            throw new IllegalArgumentException("Call does not support special user #" + userId);
        }
        if ("system".equals(appPackageName)) {
            return this.mContext.mMainThread.getSystemUiContext().getResources();
        }
        try {
            ApplicationInfo ai = this.mPM.getApplicationInfo(appPackageName, 1024, userId);
            if (ai != null) {
                return this.getResourcesForApplication(ai);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException("Package " + appPackageName + " doesn't exist");
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isSafeMode() {
        try {
            if (this.mCachedSafeMode < 0) {
                this.mCachedSafeMode = this.mPM.isSafeMode() ? 1 : 0;
            }
            return this.mCachedSafeMode != 0;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ApplicationPackageManager$addOnPermissionsChangeListener(PackageManager.OnPermissionsChangedListener listener) {
        Map<PackageManager.OnPermissionsChangedListener, IOnPermissionsChangeListener> map = this.mPermissionListeners;
        synchronized (map) {
            if (this.mPermissionListeners.get(listener) != null) {
                return;
            }
            OnPermissionsChangeListenerDelegate delegate = new OnPermissionsChangeListenerDelegate(this, listener, Looper.getMainLooper());
            try {
                this.mPM.addOnPermissionsChangeListener(delegate);
                this.mPermissionListeners.put(listener, delegate);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ApplicationPackageManager$removeOnPermissionsChangeListener(PackageManager.OnPermissionsChangedListener listener) {
        Map<PackageManager.OnPermissionsChangedListener, IOnPermissionsChangeListener> map = this.mPermissionListeners;
        synchronized (map) {
            IOnPermissionsChangeListener delegate = this.mPermissionListeners.get(listener);
            if (delegate != null) {
                try {
                    this.mPM.removeOnPermissionsChangeListener(delegate);
                    this.mPermissionListeners.remove(listener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_app_ApplicationPackageManager$configurationChanged() {
        Object object = sSync;
        synchronized (object) {
            sIconCache.clear();
            sStringCache.clear();
        }
    }

    private void $$robo$$android_app_ApplicationPackageManager$__constructor__(ContextImpl context, IPackageManager pm) {
        this.mLock = new Object();
        this.mDelegates = new ArrayList();
        this.mCachedSafeMode = -1;
        this.mPermissionListeners = new ArrayMap<PackageManager.OnPermissionsChangedListener, IOnPermissionsChangeListener>();
        this.mContext = context;
        this.mPM = pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Drawable $$robo$$android_app_ApplicationPackageManager$getCachedIcon(ResourceName name) {
        Object object = sSync;
        synchronized (object) {
            WeakReference<Drawable.ConstantState> wr = sIconCache.get(name);
            if (wr != null) {
                Drawable.ConstantState state = (Drawable.ConstantState)wr.get();
                if (state != null) {
                    return state.newDrawable();
                }
                sIconCache.remove(name);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ApplicationPackageManager$putCachedIcon(ResourceName name, Drawable dr) {
        Object object = sSync;
        synchronized (object) {
            sIconCache.put(name, new WeakReference<Drawable.ConstantState>(dr.getConstantState()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_app_ApplicationPackageManager$handlePackageBroadcast(int cmd, String[] pkgList, boolean hasPkgInfo) {
        boolean immediateGc = false;
        if (cmd == 1) {
            immediateGc = true;
        }
        if (pkgList != null && pkgList.length > 0) {
            boolean needCleanup = false;
            for (String ssp : pkgList) {
                Object object = sSync;
                synchronized (object) {
                    ResourceName nm;
                    int i;
                    for (i = sIconCache.size() - 1; i >= 0; --i) {
                        nm = sIconCache.keyAt(i);
                        if (!nm.packageName.equals(ssp)) continue;
                        sIconCache.removeAt(i);
                        needCleanup = true;
                    }
                    for (i = sStringCache.size() - 1; i >= 0; --i) {
                        nm = sStringCache.keyAt(i);
                        if (!nm.packageName.equals(ssp)) continue;
                        sStringCache.removeAt(i);
                        needCleanup = true;
                    }
                }
            }
            if (needCleanup || hasPkgInfo) {
                if (immediateGc) {
                    Runtime.getRuntime().gc();
                } else {
                    ActivityThread.currentActivityThread().scheduleGcIdler();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CharSequence $$robo$$android_app_ApplicationPackageManager$getCachedString(ResourceName name) {
        Object object = sSync;
        synchronized (object) {
            WeakReference<CharSequence> wr = sStringCache.get(name);
            if (wr != null) {
                CharSequence cs = (CharSequence)wr.get();
                if (cs != null) {
                    return cs;
                }
                sStringCache.remove(name);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ApplicationPackageManager$putCachedString(ResourceName name, CharSequence cs) {
        Object object = sSync;
        synchronized (object) {
            sStringCache.put(name, new WeakReference<CharSequence>(cs));
        }
    }

    private final CharSequence $$robo$$android_app_ApplicationPackageManager$getText(String packageName, int resid, ApplicationInfo appInfo) {
        ResourceName name = new ResourceName(packageName, resid);
        CharSequence text = this.getCachedString(name);
        if (text != null) {
            return text;
        }
        if (appInfo == null) {
            try {
                appInfo = this.getApplicationInfo(packageName, 1024);
            }
            catch (PackageManager.NameNotFoundException e) {
                return null;
            }
        }
        try {
            Resources r = this.getResourcesForApplication(appInfo);
            text = r.getText(resid);
            this.putCachedString(name, text);
            return text;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w("PackageManager", "Failure retrieving resources for " + appInfo.packageName);
        }
        catch (RuntimeException e) {
            Log.w("PackageManager", "Failure retrieving text 0x" + Integer.toHexString(resid) + " in package " + packageName, e);
        }
        return null;
    }

    private final XmlResourceParser $$robo$$android_app_ApplicationPackageManager$getXml(String packageName, int resid, ApplicationInfo appInfo) {
        if (appInfo == null) {
            try {
                appInfo = this.getApplicationInfo(packageName, 1024);
            }
            catch (PackageManager.NameNotFoundException e) {
                return null;
            }
        }
        try {
            Resources r = this.getResourcesForApplication(appInfo);
            return r.getXml(resid);
        }
        catch (RuntimeException e) {
            Log.w("PackageManager", "Failure retrieving xml 0x" + Integer.toHexString(resid) + " in package " + packageName, e);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w("PackageManager", "Failure retrieving resources for " + appInfo.packageName);
        }
        return null;
    }

    private final CharSequence $$robo$$android_app_ApplicationPackageManager$getApplicationLabel(ApplicationInfo info) {
        return info.loadLabel(this);
    }

    private final int $$robo$$android_app_ApplicationPackageManager$installExistingPackage(String packageName) throws PackageManager.NameNotFoundException {
        return this.installExistingPackage(packageName, 0);
    }

    private final int $$robo$$android_app_ApplicationPackageManager$installExistingPackage(String packageName, int installReason) throws PackageManager.NameNotFoundException {
        return this.installExistingPackageAsUser(packageName, installReason, this.mContext.getUserId());
    }

    private final int $$robo$$android_app_ApplicationPackageManager$installExistingPackageAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return this.installExistingPackageAsUser(packageName, 0, userId);
    }

    private final int $$robo$$android_app_ApplicationPackageManager$installExistingPackageAsUser(String packageName, int installReason, int userId) throws PackageManager.NameNotFoundException {
        try {
            int res = this.mPM.installExistingPackageAsUser(packageName, userId, 0, installReason);
            if (res == -3) {
                throw new PackageManager.NameNotFoundException("Package " + packageName + " doesn't exist");
            }
            return res;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$verifyPendingInstall(int id2, int response) {
        try {
            this.mPM.verifyPendingInstall(id2, response);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) {
        try {
            this.mPM.extendVerificationTimeout(id2, verificationCodeAtTimeout, millisecondsToDelay);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$verifyIntentFilter(int id2, int verificationCode, List<String> failedDomains) {
        try {
            this.mPM.verifyIntentFilter(id2, verificationCode, failedDomains);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getIntentVerificationStatusAsUser(String packageName, int userId) {
        try {
            return this.mPM.getIntentVerificationStatus(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$updateIntentVerificationStatusAsUser(String packageName, int status, int userId) {
        try {
            return this.mPM.updateIntentVerificationStatus(packageName, status, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<IntentFilterVerificationInfo> $$robo$$android_app_ApplicationPackageManager$getIntentFilterVerifications(String packageName) {
        try {
            ParceledListSlice parceledList = this.mPM.getIntentFilterVerifications(packageName);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<IntentFilter> $$robo$$android_app_ApplicationPackageManager$getAllIntentFilters(String packageName) {
        try {
            ParceledListSlice parceledList = this.mPM.getAllIntentFilters(packageName);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_app_ApplicationPackageManager$getDefaultBrowserPackageNameAsUser(int userId) {
        try {
            return this.mPM.getDefaultBrowserPackageName(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$setDefaultBrowserPackageNameAsUser(String packageName, int userId) {
        try {
            return this.mPM.setDefaultBrowserPackageName(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$setInstallerPackageName(String targetPackage, String installerPackageName) {
        try {
            this.mPM.setInstallerPackageName(targetPackage, installerPackageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$setUpdateAvailable(String packageName, boolean updateAvailable) {
        try {
            this.mPM.setUpdateAvailable(packageName, updateAvailable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_app_ApplicationPackageManager$getInstallerPackageName(String packageName) {
        try {
            return this.mPM.getInstallerPackageName(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getMoveStatus(int moveId) {
        try {
            return this.mPM.getMoveStatus(moveId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ApplicationPackageManager$registerMoveCallback(PackageManager.MoveCallback callback, Handler handler) {
        ArrayList<MoveCallbackDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            MoveCallbackDelegate delegate = new MoveCallbackDelegate(callback, handler.getLooper());
            try {
                this.mPM.registerMoveCallback(delegate);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mDelegates.add(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ApplicationPackageManager$unregisterMoveCallback(PackageManager.MoveCallback callback) {
        ArrayList<MoveCallbackDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            Iterator<MoveCallbackDelegate> i = this.mDelegates.iterator();
            while (i.hasNext()) {
                MoveCallbackDelegate delegate = i.next();
                if (delegate.mCallback != callback) continue;
                try {
                    this.mPM.unregisterMoveCallback(delegate);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                i.remove();
            }
        }
    }

    private final int $$robo$$android_app_ApplicationPackageManager$movePackage(String packageName, VolumeInfo vol) {
        try {
            String volumeUuid = "private".equals(vol.id) ? StorageManager.UUID_PRIVATE_INTERNAL : (vol.isPrimaryPhysical() ? "primary_physical" : Preconditions.checkNotNull(vol.fsUuid));
            return this.mPM.movePackage(packageName, volumeUuid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final VolumeInfo $$robo$$android_app_ApplicationPackageManager$getPackageCurrentVolume(ApplicationInfo app) {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        return this.getPackageCurrentVolume(app, storage);
    }

    @VisibleForTesting
    private final VolumeInfo $$robo$$android_app_ApplicationPackageManager$getPackageCurrentVolume(ApplicationInfo app, StorageManager storage) {
        if (app.isInternal()) {
            return storage.findVolumeById("private");
        }
        if (app.isExternalAsec()) {
            return storage.getPrimaryPhysicalVolume();
        }
        return storage.findVolumeByUuid(app.volumeUuid);
    }

    private final List<VolumeInfo> $$robo$$android_app_ApplicationPackageManager$getPackageCandidateVolumes(ApplicationInfo app) {
        StorageManager storageManager = this.mContext.getSystemService(StorageManager.class);
        return this.getPackageCandidateVolumes(app, storageManager, this.mPM);
    }

    @VisibleForTesting
    private final List<VolumeInfo> $$robo$$android_app_ApplicationPackageManager$getPackageCandidateVolumes(ApplicationInfo app, StorageManager storageManager, IPackageManager pm) {
        VolumeInfo currentVol = this.getPackageCurrentVolume(app, storageManager);
        List<VolumeInfo> vols = storageManager.getVolumes();
        ArrayList<VolumeInfo> candidates = new ArrayList<VolumeInfo>();
        for (VolumeInfo vol : vols) {
            if (!Objects.equals(vol, currentVol) && !this.isPackageCandidateVolume(this.mContext, app, vol, pm)) continue;
            candidates.add(vol);
        }
        return candidates;
    }

    @VisibleForTesting
    private final boolean $$robo$$android_app_ApplicationPackageManager$isForceAllowOnExternal(Context context) {
        return Settings.Global.getInt(context.getContentResolver(), "force_allow_on_external", 0) != 0;
    }

    @VisibleForTesting
    private final boolean $$robo$$android_app_ApplicationPackageManager$isAllow3rdPartyOnInternal(Context context) {
        return context.getResources().getBoolean(17956869);
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isPackageCandidateVolume(ContextImpl context, ApplicationInfo app, VolumeInfo vol, IPackageManager pm) {
        boolean forceAllowOnExternal = this.isForceAllowOnExternal(context);
        if ("private".equals(vol.getId())) {
            return app.isSystemApp() || this.isAllow3rdPartyOnInternal(context);
        }
        if (app.isSystemApp()) {
            return false;
        }
        if (!(forceAllowOnExternal || app.installLocation != 1 && app.installLocation != -1)) {
            return false;
        }
        if (!vol.isMountedWritable()) {
            return false;
        }
        if (vol.isPrimaryPhysical()) {
            return app.isInternal();
        }
        try {
            if (pm.isPackageDeviceAdminOnAnyUser(app.packageName)) {
                return false;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return vol.getType() == 1;
    }

    private final int $$robo$$android_app_ApplicationPackageManager$movePrimaryStorage(VolumeInfo vol) {
        try {
            String volumeUuid = "private".equals(vol.id) ? StorageManager.UUID_PRIVATE_INTERNAL : (vol.isPrimaryPhysical() ? "primary_physical" : Preconditions.checkNotNull(vol.fsUuid));
            return this.mPM.movePrimaryStorage(volumeUuid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final VolumeInfo $$robo$$android_app_ApplicationPackageManager$getPrimaryStorageCurrentVolume() {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        String volumeUuid = storage.getPrimaryStorageUuid();
        return storage.findVolumeByQualifiedUuid(volumeUuid);
    }

    private final List<VolumeInfo> $$robo$$android_app_ApplicationPackageManager$getPrimaryStorageCandidateVolumes() {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        VolumeInfo currentVol = this.getPrimaryStorageCurrentVolume();
        List<VolumeInfo> vols = storage.getVolumes();
        ArrayList<VolumeInfo> candidates = new ArrayList<VolumeInfo>();
        if (Objects.equals("primary_physical", storage.getPrimaryStorageUuid()) && currentVol != null) {
            candidates.add(currentVol);
        } else {
            for (VolumeInfo vol : vols) {
                if (!Objects.equals(vol, currentVol) && !ApplicationPackageManager.isPrimaryStorageCandidateVolume(vol)) continue;
                candidates.add(vol);
            }
        }
        return candidates;
    }

    private static final boolean $$robo$$android_app_ApplicationPackageManager$isPrimaryStorageCandidateVolume(VolumeInfo vol) {
        if ("private".equals(vol.getId())) {
            return true;
        }
        if (!vol.isMountedWritable()) {
            return false;
        }
        return vol.getType() == 1;
    }

    private final void $$robo$$android_app_ApplicationPackageManager$deletePackage(String packageName, IPackageDeleteObserver observer, int flags) {
        this.deletePackageAsUser(packageName, observer, flags, this.mContext.getUserId());
    }

    private final void $$robo$$android_app_ApplicationPackageManager$deletePackageAsUser(String packageName, IPackageDeleteObserver observer, int flags, int userId) {
        try {
            this.mPM.deletePackageAsUser(packageName, -1, observer, userId, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$clearApplicationUserData(String packageName, IPackageDataObserver observer) {
        try {
            this.mPM.clearApplicationUserData(packageName, observer, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$deleteApplicationCacheFiles(String packageName, IPackageDataObserver observer) {
        try {
            this.mPM.deleteApplicationCacheFiles(packageName, observer);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$deleteApplicationCacheFilesAsUser(String packageName, int userId, IPackageDataObserver observer) {
        try {
            this.mPM.deleteApplicationCacheFilesAsUser(packageName, userId, observer);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$freeStorageAndNotify(String volumeUuid, long idealStorageSize, IPackageDataObserver observer) {
        try {
            this.mPM.freeStorageAndNotify(volumeUuid, idealStorageSize, 0, observer);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$freeStorage(String volumeUuid, long freeStorageSize, IntentSender pi) {
        try {
            this.mPM.freeStorage(volumeUuid, freeStorageSize, 0, pi);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String[] $$robo$$android_app_ApplicationPackageManager$setPackagesSuspended(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, String dialogMessage) {
        try {
            return this.mPM.setPackagesSuspendedAsUser(packageNames, suspended, appExtras, launcherExtras, dialogMessage, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Bundle $$robo$$android_app_ApplicationPackageManager$getSuspendedPackageAppExtras() {
        PersistableBundle extras;
        try {
            extras = this.mPM.getSuspendedPackageAppExtras(this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return extras != null ? new Bundle(extras.deepCopy()) : null;
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isPackageSuspendedForUser(String packageName, int userId) {
        try {
            return this.mPM.isPackageSuspendedForUser(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isPackageSuspended(String packageName) throws PackageManager.NameNotFoundException {
        try {
            return this.isPackageSuspendedForUser(packageName, this.mContext.getUserId());
        }
        catch (IllegalArgumentException ie) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isPackageSuspended() {
        return this.isPackageSuspendedForUser(this.mContext.getOpPackageName(), this.mContext.getUserId());
    }

    private final void $$robo$$android_app_ApplicationPackageManager$setApplicationCategoryHint(String packageName, int categoryHint) {
        try {
            this.mPM.setApplicationCategoryHint(packageName, categoryHint, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$getPackageSizeInfoAsUser(String packageName, int userHandle, IPackageStatsObserver observer) {
        String msg = "Shame on you for calling the hidden API getPackageSizeInfoAsUser(). Shame!";
        if (this.mContext.getApplicationInfo().targetSdkVersion >= 26) {
            throw new UnsupportedOperationException("Shame on you for calling the hidden API getPackageSizeInfoAsUser(). Shame!");
        }
        if (observer != null) {
            Log.d("ApplicationPackageManager", "Shame on you for calling the hidden API getPackageSizeInfoAsUser(). Shame!");
            try {
                observer.onGetStatsCompleted(null, false);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$addPackageToPreferred(String packageName) {
        Log.w("ApplicationPackageManager", "addPackageToPreferred() is a no-op");
    }

    private final void $$robo$$android_app_ApplicationPackageManager$removePackageFromPreferred(String packageName) {
        Log.w("ApplicationPackageManager", "removePackageFromPreferred() is a no-op");
    }

    private final List<PackageInfo> $$robo$$android_app_ApplicationPackageManager$getPreferredPackages(int flags) {
        Log.w("ApplicationPackageManager", "getPreferredPackages() is a no-op");
        return Collections.emptyList();
    }

    private final void $$robo$$android_app_ApplicationPackageManager$addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        try {
            this.mPM.addPreferredActivity(filter, match, set, activity, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$addPreferredActivityAsUser(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        try {
            this.mPM.addPreferredActivity(filter, match, set, activity, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        try {
            this.mPM.replacePreferredActivity(filter, match, set, activity, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$replacePreferredActivityAsUser(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        try {
            this.mPM.replacePreferredActivity(filter, match, set, activity, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$clearPackagePreferredActivities(String packageName) {
        try {
            this.mPM.clearPackagePreferredActivities(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        try {
            return this.mPM.getPreferredActivities(outFilters, outActivities, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ComponentName $$robo$$android_app_ApplicationPackageManager$getHomeActivities(List<ResolveInfo> outActivities) {
        try {
            return this.mPM.getHomeActivities(outActivities);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$setComponentEnabledSetting(ComponentName componentName, int newState, int flags) {
        try {
            this.mPM.setComponentEnabledSetting(componentName, newState, flags, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getComponentEnabledSetting(ComponentName componentName) {
        try {
            return this.mPM.getComponentEnabledSetting(componentName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$setApplicationEnabledSetting(String packageName, int newState, int flags) {
        try {
            this.mPM.setApplicationEnabledSetting(packageName, newState, flags, this.mContext.getUserId(), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getApplicationEnabledSetting(String packageName) {
        try {
            return this.mPM.getApplicationEnabledSetting(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$flushPackageRestrictionsAsUser(int userId) {
        try {
            this.mPM.flushPackageRestrictionsAsUser(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$setApplicationHiddenSettingAsUser(String packageName, boolean hidden, UserHandle user) {
        try {
            return this.mPM.setApplicationHiddenSettingAsUser(packageName, hidden, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$getApplicationHiddenSettingAsUser(String packageName, UserHandle user) {
        try {
            return this.mPM.getApplicationHiddenSettingAsUser(packageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final KeySet $$robo$$android_app_ApplicationPackageManager$getKeySetByAlias(String packageName, String alias) {
        Preconditions.checkNotNull(packageName);
        Preconditions.checkNotNull(alias);
        try {
            return this.mPM.getKeySetByAlias(packageName, alias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final KeySet $$robo$$android_app_ApplicationPackageManager$getSigningKeySet(String packageName) {
        Preconditions.checkNotNull(packageName);
        try {
            return this.mPM.getSigningKeySet(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isSignedBy(String packageName, KeySet ks) {
        Preconditions.checkNotNull(packageName);
        Preconditions.checkNotNull(ks);
        try {
            return this.mPM.isPackageSignedByKeySet(packageName, ks);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isSignedByExactly(String packageName, KeySet ks) {
        Preconditions.checkNotNull(packageName);
        Preconditions.checkNotNull(ks);
        try {
            return this.mPM.isPackageSignedByKeySetExactly(packageName, ks);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final VerifierDeviceIdentity $$robo$$android_app_ApplicationPackageManager$getVerifierDeviceIdentity() {
        try {
            return this.mPM.getVerifierDeviceIdentity();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isUpgrade() {
        try {
            return this.mPM.isUpgrade();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PackageInstaller $$robo$$android_app_ApplicationPackageManager$getPackageInstaller() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInstaller == null) {
                try {
                    this.mInstaller = new PackageInstaller(this.mPM.getPackageInstaller(), this.mContext.getPackageName(), this.mContext.getUserId());
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            return this.mInstaller;
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isPackageAvailable(String packageName) {
        try {
            return this.mPM.isPackageAvailable(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$addCrossProfileIntentFilter(IntentFilter filter, int sourceUserId, int targetUserId, int flags) {
        try {
            this.mPM.addCrossProfileIntentFilter(filter, this.mContext.getOpPackageName(), sourceUserId, targetUserId, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$clearCrossProfileIntentFilters(int sourceUserId) {
        try {
            this.mPM.clearCrossProfileIntentFilters(sourceUserId, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$loadItemIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo) {
        Drawable dr = this.loadUnbadgedItemIcon(itemInfo, appInfo);
        if (itemInfo.showUserIcon != -10000) {
            return dr;
        }
        return this.getUserBadgedIcon(dr, new UserHandle(this.mContext.getUserId()));
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$loadUnbadgedItemIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo) {
        if (itemInfo.showUserIcon != -10000) {
            Bitmap bitmap = this.getUserManager().getUserIcon(itemInfo.showUserIcon);
            if (bitmap == null) {
                return UserIcons.getDefaultUserIcon(this.mContext.getResources(), itemInfo.showUserIcon, false);
            }
            return new BitmapDrawable(bitmap);
        }
        Drawable dr = null;
        if (itemInfo.packageName != null) {
            dr = this.getDrawable(itemInfo.packageName, itemInfo.icon, appInfo);
        }
        if (dr == null) {
            dr = itemInfo.loadDefaultIcon(this);
        }
        return dr;
    }

    private final Drawable $$robo$$android_app_ApplicationPackageManager$getBadgedDrawable(Drawable drawable2, Drawable badgeDrawable, Rect badgeLocation, boolean tryBadgeInPlace) {
        int badgedWidth = drawable2.getIntrinsicWidth();
        int badgedHeight = drawable2.getIntrinsicHeight();
        boolean canBadgeInPlace = tryBadgeInPlace && drawable2 instanceof BitmapDrawable && ((BitmapDrawable)drawable2).getBitmap().isMutable();
        Bitmap bitmap = canBadgeInPlace ? ((BitmapDrawable)drawable2).getBitmap() : Bitmap.createBitmap(badgedWidth, badgedHeight, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        if (!canBadgeInPlace) {
            drawable2.setBounds(0, 0, badgedWidth, badgedHeight);
            drawable2.draw(canvas);
        }
        if (badgeLocation != null) {
            if (badgeLocation.left < 0 || badgeLocation.top < 0 || badgeLocation.width() > badgedWidth || badgeLocation.height() > badgedHeight) {
                throw new IllegalArgumentException("Badge location " + badgeLocation + " not in badged drawable bounds " + new Rect(0, 0, badgedWidth, badgedHeight));
            }
            badgeDrawable.setBounds(0, 0, badgeLocation.width(), badgeLocation.height());
            canvas.save();
            canvas.translate(badgeLocation.left, badgeLocation.top);
            badgeDrawable.draw(canvas);
            canvas.restore();
        } else {
            badgeDrawable.setBounds(0, 0, badgedWidth, badgedHeight);
            badgeDrawable.draw(canvas);
        }
        if (!canBadgeInPlace) {
            BitmapDrawable mergedDrawable = new BitmapDrawable(this.mContext.getResources(), bitmap);
            if (drawable2 instanceof BitmapDrawable) {
                BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
                mergedDrawable.setTargetDensity(bitmapDrawable.getBitmap().getDensity());
            }
            return mergedDrawable;
        }
        return drawable2;
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isManagedProfile(int userId) {
        return this.getUserManager().isManagedProfile(userId);
    }

    private final int $$robo$$android_app_ApplicationPackageManager$getInstallReason(String packageName, UserHandle user) {
        try {
            return this.mPM.getInstallReason(packageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$canRequestPackageInstalls() {
        try {
            return this.mPM.canRequestPackageInstalls(this.mContext.getPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    private final ComponentName $$robo$$android_app_ApplicationPackageManager$getInstantAppResolverSettingsComponent() {
        try {
            return this.mPM.getInstantAppResolverSettingsComponent();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    private final ComponentName $$robo$$android_app_ApplicationPackageManager$getInstantAppInstallerComponent() {
        try {
            return this.mPM.getInstantAppInstallerComponent();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    private final String $$robo$$android_app_ApplicationPackageManager$getInstantAppAndroidId(String packageName, UserHandle user) {
        try {
            return this.mPM.getInstantAppAndroidId(packageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$registerDexModule(String dexModule, PackageManager.DexModuleRegisterCallback callback) {
        boolean isSharedModule = false;
        try {
            StructStat stat = Os.stat(dexModule);
            if ((OsConstants.S_IROTH & stat.st_mode) != 0) {
                isSharedModule = true;
            }
        }
        catch (ErrnoException e) {
            callback.onDexModuleRegistered(dexModule, false, "Could not get stat the module file: " + e.getMessage());
            return;
        }
        DexModuleRegisterCallbackDelegate callbackDelegate = null;
        if (callback != null) {
            callbackDelegate = new DexModuleRegisterCallbackDelegate(callback);
        }
        try {
            this.mPM.registerDexModule(this.mContext.getPackageName(), dexModule, isSharedModule, callbackDelegate);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    private final CharSequence $$robo$$android_app_ApplicationPackageManager$getHarmfulAppWarning(String packageName) {
        try {
            return this.mPM.getHarmfulAppWarning(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    private final void $$robo$$android_app_ApplicationPackageManager$setHarmfulAppWarning(String packageName, CharSequence warning) {
        try {
            this.mPM.setHarmfulAppWarning(packageName, warning, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ArtManager $$robo$$android_app_ApplicationPackageManager$getArtManager() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mArtManager == null) {
                try {
                    this.mArtManager = new ArtManager(this.mContext, this.mPM.getArtManager());
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            return this.mArtManager;
        }
    }

    private final String $$robo$$android_app_ApplicationPackageManager$getSystemTextClassifierPackageName() {
        try {
            return this.mPM.getSystemTextClassifierPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    private final boolean $$robo$$android_app_ApplicationPackageManager$isPackageStateProtected(String packageName, int userId) {
        try {
            return this.mPM.isPackageStateProtected(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    static void __staticInitializer__() {
        CORP_BADGE_LABEL_RES_ID = new int[]{17040195, 17040196, 17040197};
        sSync = new Object();
        sIconCache = new ArrayMap();
        sStringCache = new ArrayMap();
    }

    UserManager getUserManager() {
        return InvokeDynamicSupport.bootstrap("getUserManager", $$robo$$android_app_ApplicationPackageManager$getUserManager(), this);
    }

    @Override
    public int getUserId() {
        return (int)InvokeDynamicSupport.bootstrap("getUserId", $$robo$$android_app_ApplicationPackageManager$getUserId(), this);
    }

    @Override
    public PackageInfo getPackageInfo(String string2, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getPackageInfo", $$robo$$android_app_ApplicationPackageManager$getPackageInfo(java.lang.String int ), this, string2, n);
    }

    @Override
    public PackageInfo getPackageInfo(VersionedPackage versionedPackage, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getPackageInfo", $$robo$$android_app_ApplicationPackageManager$getPackageInfo(android.content.pm.VersionedPackage int ), this, versionedPackage, n);
    }

    @Override
    public PackageInfo getPackageInfoAsUser(String string2, int n, int n2) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getPackageInfoAsUser", $$robo$$android_app_ApplicationPackageManager$getPackageInfoAsUser(java.lang.String int int ), this, string2, n, n2);
    }

    @Override
    public String[] currentToCanonicalPackageNames(String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("currentToCanonicalPackageNames", $$robo$$android_app_ApplicationPackageManager$currentToCanonicalPackageNames(java.lang.String[] ), this, stringArray);
    }

    @Override
    public String[] canonicalToCurrentPackageNames(String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("canonicalToCurrentPackageNames", $$robo$$android_app_ApplicationPackageManager$canonicalToCurrentPackageNames(java.lang.String[] ), this, stringArray);
    }

    @Override
    public Intent getLaunchIntentForPackage(String string2) {
        return InvokeDynamicSupport.bootstrap("getLaunchIntentForPackage", $$robo$$android_app_ApplicationPackageManager$getLaunchIntentForPackage(java.lang.String ), this, string2);
    }

    @Override
    public Intent getLeanbackLaunchIntentForPackage(String string2) {
        return InvokeDynamicSupport.bootstrap("getLeanbackLaunchIntentForPackage", $$robo$$android_app_ApplicationPackageManager$getLeanbackLaunchIntentForPackage(java.lang.String ), this, string2);
    }

    @Override
    public Intent getCarLaunchIntentForPackage(String string2) {
        return InvokeDynamicSupport.bootstrap("getCarLaunchIntentForPackage", $$robo$$android_app_ApplicationPackageManager$getCarLaunchIntentForPackage(java.lang.String ), this, string2);
    }

    private Intent getLaunchIntentForPackageAndCategory(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getLaunchIntentForPackageAndCategory", $$robo$$android_app_ApplicationPackageManager$getLaunchIntentForPackageAndCategory(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public int[] getPackageGids(String string2) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getPackageGids", $$robo$$android_app_ApplicationPackageManager$getPackageGids(java.lang.String ), this, string2);
    }

    @Override
    public int[] getPackageGids(String string2, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getPackageGids", $$robo$$android_app_ApplicationPackageManager$getPackageGids(java.lang.String int ), this, string2, n);
    }

    @Override
    public int getPackageUid(String string2, int n) throws PackageManager.NameNotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("getPackageUid", $$robo$$android_app_ApplicationPackageManager$getPackageUid(java.lang.String int ), this, string2, n);
    }

    @Override
    public int getPackageUidAsUser(String string2, int n) throws PackageManager.NameNotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("getPackageUidAsUser", $$robo$$android_app_ApplicationPackageManager$getPackageUidAsUser(java.lang.String int ), this, string2, n);
    }

    @Override
    public int getPackageUidAsUser(String string2, int n, int n2) throws PackageManager.NameNotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("getPackageUidAsUser", $$robo$$android_app_ApplicationPackageManager$getPackageUidAsUser(java.lang.String int int ), this, string2, n, n2);
    }

    @Override
    public PermissionInfo getPermissionInfo(String string2, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getPermissionInfo", $$robo$$android_app_ApplicationPackageManager$getPermissionInfo(java.lang.String int ), this, string2, n);
    }

    @Override
    public List<PermissionInfo> queryPermissionsByGroup(String string2, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("queryPermissionsByGroup", $$robo$$android_app_ApplicationPackageManager$queryPermissionsByGroup(java.lang.String int ), this, string2, n);
    }

    @Override
    public boolean isPermissionReviewModeEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPermissionReviewModeEnabled", $$robo$$android_app_ApplicationPackageManager$isPermissionReviewModeEnabled(), this);
    }

    @Override
    public PermissionGroupInfo getPermissionGroupInfo(String string2, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getPermissionGroupInfo", $$robo$$android_app_ApplicationPackageManager$getPermissionGroupInfo(java.lang.String int ), this, string2, n);
    }

    @Override
    public List<PermissionGroupInfo> getAllPermissionGroups(int n) {
        return InvokeDynamicSupport.bootstrap("getAllPermissionGroups", $$robo$$android_app_ApplicationPackageManager$getAllPermissionGroups(int ), this, n);
    }

    @Override
    public ApplicationInfo getApplicationInfo(String string2, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getApplicationInfo", $$robo$$android_app_ApplicationPackageManager$getApplicationInfo(java.lang.String int ), this, string2, n);
    }

    @Override
    public ApplicationInfo getApplicationInfoAsUser(String string2, int n, int n2) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getApplicationInfoAsUser", $$robo$$android_app_ApplicationPackageManager$getApplicationInfoAsUser(java.lang.String int int ), this, string2, n, n2);
    }

    private static ApplicationInfo maybeAdjustApplicationInfo(ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrapStatic("maybeAdjustApplicationInfo", $$robo$$android_app_ApplicationPackageManager$maybeAdjustApplicationInfo(android.content.pm.ApplicationInfo ), (ApplicationInfo)applicationInfo);
    }

    @Override
    public ActivityInfo getActivityInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getActivityInfo", $$robo$$android_app_ApplicationPackageManager$getActivityInfo(android.content.ComponentName int ), this, componentName, n);
    }

    @Override
    public ActivityInfo getReceiverInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getReceiverInfo", $$robo$$android_app_ApplicationPackageManager$getReceiverInfo(android.content.ComponentName int ), this, componentName, n);
    }

    @Override
    public ServiceInfo getServiceInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_app_ApplicationPackageManager$getServiceInfo(android.content.ComponentName int ), this, componentName, n);
    }

    @Override
    public ProviderInfo getProviderInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getProviderInfo", $$robo$$android_app_ApplicationPackageManager$getProviderInfo(android.content.ComponentName int ), this, componentName, n);
    }

    @Override
    public String[] getSystemSharedLibraryNames() {
        return InvokeDynamicSupport.bootstrap("getSystemSharedLibraryNames", $$robo$$android_app_ApplicationPackageManager$getSystemSharedLibraryNames(), this);
    }

    @Override
    public List<SharedLibraryInfo> getSharedLibraries(int n) {
        return InvokeDynamicSupport.bootstrap("getSharedLibraries", $$robo$$android_app_ApplicationPackageManager$getSharedLibraries(int ), this, n);
    }

    @Override
    public List<SharedLibraryInfo> getSharedLibrariesAsUser(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getSharedLibrariesAsUser", $$robo$$android_app_ApplicationPackageManager$getSharedLibrariesAsUser(int int ), this, n, n2);
    }

    @Override
    public String getServicesSystemSharedLibraryPackageName() {
        return InvokeDynamicSupport.bootstrap("getServicesSystemSharedLibraryPackageName", $$robo$$android_app_ApplicationPackageManager$getServicesSystemSharedLibraryPackageName(), this);
    }

    @Override
    public String getSharedSystemSharedLibraryPackageName() {
        return InvokeDynamicSupport.bootstrap("getSharedSystemSharedLibraryPackageName", $$robo$$android_app_ApplicationPackageManager$getSharedSystemSharedLibraryPackageName(), this);
    }

    @Override
    public ChangedPackages getChangedPackages(int n) {
        return InvokeDynamicSupport.bootstrap("getChangedPackages", $$robo$$android_app_ApplicationPackageManager$getChangedPackages(int ), this, n);
    }

    @Override
    public FeatureInfo[] getSystemAvailableFeatures() {
        return InvokeDynamicSupport.bootstrap("getSystemAvailableFeatures", $$robo$$android_app_ApplicationPackageManager$getSystemAvailableFeatures(), this);
    }

    @Override
    public boolean hasSystemFeature(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSystemFeature", $$robo$$android_app_ApplicationPackageManager$hasSystemFeature(java.lang.String ), this, string2);
    }

    @Override
    public boolean hasSystemFeature(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSystemFeature", $$robo$$android_app_ApplicationPackageManager$hasSystemFeature(java.lang.String int ), this, string2, n);
    }

    @Override
    public int checkPermission(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("checkPermission", $$robo$$android_app_ApplicationPackageManager$checkPermission(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public boolean isPermissionRevokedByPolicy(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPermissionRevokedByPolicy", $$robo$$android_app_ApplicationPackageManager$isPermissionRevokedByPolicy(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public String getPermissionControllerPackageName() {
        return InvokeDynamicSupport.bootstrap("getPermissionControllerPackageName", $$robo$$android_app_ApplicationPackageManager$getPermissionControllerPackageName(), this);
    }

    @Override
    public boolean addPermission(PermissionInfo permissionInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("addPermission", $$robo$$android_app_ApplicationPackageManager$addPermission(android.content.pm.PermissionInfo ), this, permissionInfo);
    }

    @Override
    public boolean addPermissionAsync(PermissionInfo permissionInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("addPermissionAsync", $$robo$$android_app_ApplicationPackageManager$addPermissionAsync(android.content.pm.PermissionInfo ), this, permissionInfo);
    }

    @Override
    public void removePermission(String string2) {
        InvokeDynamicSupport.bootstrap("removePermission", $$robo$$android_app_ApplicationPackageManager$removePermission(java.lang.String ), this, string2);
    }

    @Override
    public void grantRuntimePermission(String string2, String string3, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("grantRuntimePermission", $$robo$$android_app_ApplicationPackageManager$grantRuntimePermission(java.lang.String java.lang.String android.os.UserHandle ), this, string2, string3, userHandle);
    }

    @Override
    public void revokeRuntimePermission(String string2, String string3, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("revokeRuntimePermission", $$robo$$android_app_ApplicationPackageManager$revokeRuntimePermission(java.lang.String java.lang.String android.os.UserHandle ), this, string2, string3, userHandle);
    }

    @Override
    public int getPermissionFlags(String string2, String string3, UserHandle userHandle) {
        return (int)InvokeDynamicSupport.bootstrap("getPermissionFlags", $$robo$$android_app_ApplicationPackageManager$getPermissionFlags(java.lang.String java.lang.String android.os.UserHandle ), this, string2, string3, userHandle);
    }

    @Override
    public void updatePermissionFlags(String string2, String string3, int n, int n2, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("updatePermissionFlags", $$robo$$android_app_ApplicationPackageManager$updatePermissionFlags(java.lang.String java.lang.String int int android.os.UserHandle ), this, string2, string3, n, n2, userHandle);
    }

    @Override
    public boolean shouldShowRequestPermissionRationale(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldShowRequestPermissionRationale", $$robo$$android_app_ApplicationPackageManager$shouldShowRequestPermissionRationale(java.lang.String ), this, string2);
    }

    @Override
    public int checkSignatures(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("checkSignatures", $$robo$$android_app_ApplicationPackageManager$checkSignatures(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public int checkSignatures(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("checkSignatures", $$robo$$android_app_ApplicationPackageManager$checkSignatures(int int ), this, n, n2);
    }

    @Override
    public boolean hasSigningCertificate(String string2, byte[] byArray, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSigningCertificate", $$robo$$android_app_ApplicationPackageManager$hasSigningCertificate(java.lang.String byte[] int ), this, string2, byArray, n);
    }

    @Override
    public boolean hasSigningCertificate(int n, byte[] byArray, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSigningCertificate", $$robo$$android_app_ApplicationPackageManager$hasSigningCertificate(int byte[] int ), this, n, byArray, n2);
    }

    @Override
    public String[] getPackagesForUid(int n) {
        return InvokeDynamicSupport.bootstrap("getPackagesForUid", $$robo$$android_app_ApplicationPackageManager$getPackagesForUid(int ), this, n);
    }

    @Override
    public String getNameForUid(int n) {
        return InvokeDynamicSupport.bootstrap("getNameForUid", $$robo$$android_app_ApplicationPackageManager$getNameForUid(int ), this, n);
    }

    @Override
    public String[] getNamesForUids(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getNamesForUids", $$robo$$android_app_ApplicationPackageManager$getNamesForUids(int[] ), this, nArray);
    }

    @Override
    public int getUidForSharedUser(String string2) throws PackageManager.NameNotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("getUidForSharedUser", $$robo$$android_app_ApplicationPackageManager$getUidForSharedUser(java.lang.String ), this, string2);
    }

    @Override
    public List<PackageInfo> getInstalledPackages(int n) {
        return InvokeDynamicSupport.bootstrap("getInstalledPackages", $$robo$$android_app_ApplicationPackageManager$getInstalledPackages(int ), this, n);
    }

    @Override
    public List<PackageInfo> getInstalledPackagesAsUser(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getInstalledPackagesAsUser", $$robo$$android_app_ApplicationPackageManager$getInstalledPackagesAsUser(int int ), this, n, n2);
    }

    @Override
    public List<PackageInfo> getPackagesHoldingPermissions(String[] stringArray, int n) {
        return InvokeDynamicSupport.bootstrap("getPackagesHoldingPermissions", $$robo$$android_app_ApplicationPackageManager$getPackagesHoldingPermissions(java.lang.String[] int ), this, stringArray, n);
    }

    @Override
    public List<ApplicationInfo> getInstalledApplications(int n) {
        return InvokeDynamicSupport.bootstrap("getInstalledApplications", $$robo$$android_app_ApplicationPackageManager$getInstalledApplications(int ), this, n);
    }

    @Override
    public List<ApplicationInfo> getInstalledApplicationsAsUser(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getInstalledApplicationsAsUser", $$robo$$android_app_ApplicationPackageManager$getInstalledApplicationsAsUser(int int ), this, n, n2);
    }

    @Override
    public List<InstantAppInfo> getInstantApps() {
        return InvokeDynamicSupport.bootstrap("getInstantApps", $$robo$$android_app_ApplicationPackageManager$getInstantApps(), this);
    }

    @Override
    public Drawable getInstantAppIcon(String string2) {
        return InvokeDynamicSupport.bootstrap("getInstantAppIcon", $$robo$$android_app_ApplicationPackageManager$getInstantAppIcon(java.lang.String ), this, string2);
    }

    @Override
    public boolean isInstantApp() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInstantApp", $$robo$$android_app_ApplicationPackageManager$isInstantApp(), this);
    }

    @Override
    public boolean isInstantApp(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isInstantApp", $$robo$$android_app_ApplicationPackageManager$isInstantApp(java.lang.String ), this, string2);
    }

    @Override
    public int getInstantAppCookieMaxBytes() {
        return (int)InvokeDynamicSupport.bootstrap("getInstantAppCookieMaxBytes", $$robo$$android_app_ApplicationPackageManager$getInstantAppCookieMaxBytes(), this);
    }

    @Override
    public int getInstantAppCookieMaxSize() {
        return (int)InvokeDynamicSupport.bootstrap("getInstantAppCookieMaxSize", $$robo$$android_app_ApplicationPackageManager$getInstantAppCookieMaxSize(), this);
    }

    @Override
    public byte[] getInstantAppCookie() {
        return InvokeDynamicSupport.bootstrap("getInstantAppCookie", $$robo$$android_app_ApplicationPackageManager$getInstantAppCookie(), this);
    }

    @Override
    public void clearInstantAppCookie() {
        InvokeDynamicSupport.bootstrap("clearInstantAppCookie", $$robo$$android_app_ApplicationPackageManager$clearInstantAppCookie(), this);
    }

    @Override
    public void updateInstantAppCookie(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("updateInstantAppCookie", $$robo$$android_app_ApplicationPackageManager$updateInstantAppCookie(byte[] ), this, byArray);
    }

    @Override
    public boolean setInstantAppCookie(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setInstantAppCookie", $$robo$$android_app_ApplicationPackageManager$setInstantAppCookie(byte[] ), this, byArray);
    }

    @Override
    public ResolveInfo resolveActivity(Intent intent, int n) {
        return InvokeDynamicSupport.bootstrap("resolveActivity", $$robo$$android_app_ApplicationPackageManager$resolveActivity(android.content.Intent int ), this, intent, n);
    }

    @Override
    public ResolveInfo resolveActivityAsUser(Intent intent, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("resolveActivityAsUser", $$robo$$android_app_ApplicationPackageManager$resolveActivityAsUser(android.content.Intent int int ), this, intent, n, n2);
    }

    @Override
    public List<ResolveInfo> queryIntentActivities(Intent intent, int n) {
        return InvokeDynamicSupport.bootstrap("queryIntentActivities", $$robo$$android_app_ApplicationPackageManager$queryIntentActivities(android.content.Intent int ), this, intent, n);
    }

    @Override
    public List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("queryIntentActivitiesAsUser", $$robo$$android_app_ApplicationPackageManager$queryIntentActivitiesAsUser(android.content.Intent int int ), this, intent, n, n2);
    }

    @Override
    public List<ResolveInfo> queryIntentActivityOptions(ComponentName componentName, Intent[] intentArray, Intent intent, int n) {
        return InvokeDynamicSupport.bootstrap("queryIntentActivityOptions", $$robo$$android_app_ApplicationPackageManager$queryIntentActivityOptions(android.content.ComponentName android.content.Intent[] android.content.Intent int ), this, componentName, intentArray, intent, n);
    }

    @Override
    public List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("queryBroadcastReceiversAsUser", $$robo$$android_app_ApplicationPackageManager$queryBroadcastReceiversAsUser(android.content.Intent int int ), this, intent, n, n2);
    }

    @Override
    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int n) {
        return InvokeDynamicSupport.bootstrap("queryBroadcastReceivers", $$robo$$android_app_ApplicationPackageManager$queryBroadcastReceivers(android.content.Intent int ), this, intent, n);
    }

    @Override
    public ResolveInfo resolveServiceAsUser(Intent intent, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("resolveServiceAsUser", $$robo$$android_app_ApplicationPackageManager$resolveServiceAsUser(android.content.Intent int int ), this, intent, n, n2);
    }

    @Override
    public ResolveInfo resolveService(Intent intent, int n) {
        return InvokeDynamicSupport.bootstrap("resolveService", $$robo$$android_app_ApplicationPackageManager$resolveService(android.content.Intent int ), this, intent, n);
    }

    @Override
    public List<ResolveInfo> queryIntentServicesAsUser(Intent intent, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("queryIntentServicesAsUser", $$robo$$android_app_ApplicationPackageManager$queryIntentServicesAsUser(android.content.Intent int int ), this, intent, n, n2);
    }

    @Override
    public List<ResolveInfo> queryIntentServices(Intent intent, int n) {
        return InvokeDynamicSupport.bootstrap("queryIntentServices", $$robo$$android_app_ApplicationPackageManager$queryIntentServices(android.content.Intent int ), this, intent, n);
    }

    @Override
    public List<ResolveInfo> queryIntentContentProvidersAsUser(Intent intent, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("queryIntentContentProvidersAsUser", $$robo$$android_app_ApplicationPackageManager$queryIntentContentProvidersAsUser(android.content.Intent int int ), this, intent, n, n2);
    }

    @Override
    public List<ResolveInfo> queryIntentContentProviders(Intent intent, int n) {
        return InvokeDynamicSupport.bootstrap("queryIntentContentProviders", $$robo$$android_app_ApplicationPackageManager$queryIntentContentProviders(android.content.Intent int ), this, intent, n);
    }

    @Override
    public ProviderInfo resolveContentProvider(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("resolveContentProvider", $$robo$$android_app_ApplicationPackageManager$resolveContentProvider(java.lang.String int ), this, string2, n);
    }

    @Override
    public ProviderInfo resolveContentProviderAsUser(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("resolveContentProviderAsUser", $$robo$$android_app_ApplicationPackageManager$resolveContentProviderAsUser(java.lang.String int int ), this, string2, n, n2);
    }

    @Override
    public List<ProviderInfo> queryContentProviders(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("queryContentProviders", $$robo$$android_app_ApplicationPackageManager$queryContentProviders(java.lang.String int int ), this, string2, n, n2);
    }

    @Override
    public List<ProviderInfo> queryContentProviders(String string2, int n, int n2, String string3) {
        return InvokeDynamicSupport.bootstrap("queryContentProviders", $$robo$$android_app_ApplicationPackageManager$queryContentProviders(java.lang.String int int java.lang.String ), this, string2, n, n2, string3);
    }

    @Override
    public InstrumentationInfo getInstrumentationInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getInstrumentationInfo", $$robo$$android_app_ApplicationPackageManager$getInstrumentationInfo(android.content.ComponentName int ), this, componentName, n);
    }

    @Override
    public List<InstrumentationInfo> queryInstrumentation(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("queryInstrumentation", $$robo$$android_app_ApplicationPackageManager$queryInstrumentation(java.lang.String int ), this, string2, n);
    }

    @Override
    public Drawable getDrawable(String string2, int n, ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_app_ApplicationPackageManager$getDrawable(java.lang.String int android.content.pm.ApplicationInfo ), this, string2, n, applicationInfo);
    }

    @Override
    public Drawable getActivityIcon(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getActivityIcon", $$robo$$android_app_ApplicationPackageManager$getActivityIcon(android.content.ComponentName ), this, componentName);
    }

    @Override
    public Drawable getActivityIcon(Intent intent) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getActivityIcon", $$robo$$android_app_ApplicationPackageManager$getActivityIcon(android.content.Intent ), this, intent);
    }

    @Override
    public Drawable getDefaultActivityIcon() {
        return InvokeDynamicSupport.bootstrap("getDefaultActivityIcon", $$robo$$android_app_ApplicationPackageManager$getDefaultActivityIcon(), this);
    }

    @Override
    public Drawable getApplicationIcon(ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrap("getApplicationIcon", $$robo$$android_app_ApplicationPackageManager$getApplicationIcon(android.content.pm.ApplicationInfo ), this, applicationInfo);
    }

    @Override
    public Drawable getApplicationIcon(String string2) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getApplicationIcon", $$robo$$android_app_ApplicationPackageManager$getApplicationIcon(java.lang.String ), this, string2);
    }

    @Override
    public Drawable getActivityBanner(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getActivityBanner", $$robo$$android_app_ApplicationPackageManager$getActivityBanner(android.content.ComponentName ), this, componentName);
    }

    @Override
    public Drawable getActivityBanner(Intent intent) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getActivityBanner", $$robo$$android_app_ApplicationPackageManager$getActivityBanner(android.content.Intent ), this, intent);
    }

    @Override
    public Drawable getApplicationBanner(ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrap("getApplicationBanner", $$robo$$android_app_ApplicationPackageManager$getApplicationBanner(android.content.pm.ApplicationInfo ), this, applicationInfo);
    }

    @Override
    public Drawable getApplicationBanner(String string2) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getApplicationBanner", $$robo$$android_app_ApplicationPackageManager$getApplicationBanner(java.lang.String ), this, string2);
    }

    @Override
    public Drawable getActivityLogo(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getActivityLogo", $$robo$$android_app_ApplicationPackageManager$getActivityLogo(android.content.ComponentName ), this, componentName);
    }

    @Override
    public Drawable getActivityLogo(Intent intent) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getActivityLogo", $$robo$$android_app_ApplicationPackageManager$getActivityLogo(android.content.Intent ), this, intent);
    }

    @Override
    public Drawable getApplicationLogo(ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrap("getApplicationLogo", $$robo$$android_app_ApplicationPackageManager$getApplicationLogo(android.content.pm.ApplicationInfo ), this, applicationInfo);
    }

    @Override
    public Drawable getApplicationLogo(String string2) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getApplicationLogo", $$robo$$android_app_ApplicationPackageManager$getApplicationLogo(java.lang.String ), this, string2);
    }

    @Override
    public Drawable getUserBadgedIcon(Drawable drawable2, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getUserBadgedIcon", $$robo$$android_app_ApplicationPackageManager$getUserBadgedIcon(android.graphics.drawable.Drawable android.os.UserHandle ), this, drawable2, userHandle);
    }

    @Override
    public Drawable getUserBadgedDrawableForDensity(Drawable drawable2, UserHandle userHandle, Rect rect, int n) {
        return InvokeDynamicSupport.bootstrap("getUserBadgedDrawableForDensity", $$robo$$android_app_ApplicationPackageManager$getUserBadgedDrawableForDensity(android.graphics.drawable.Drawable android.os.UserHandle android.graphics.Rect int ), this, drawable2, userHandle, rect, n);
    }

    private int getUserBadgeColor(UserHandle userHandle) {
        return (int)InvokeDynamicSupport.bootstrap("getUserBadgeColor", $$robo$$android_app_ApplicationPackageManager$getUserBadgeColor(android.os.UserHandle ), this, userHandle);
    }

    @Override
    public Drawable getUserBadgeForDensity(UserHandle userHandle, int n) {
        return InvokeDynamicSupport.bootstrap("getUserBadgeForDensity", $$robo$$android_app_ApplicationPackageManager$getUserBadgeForDensity(android.os.UserHandle int ), this, userHandle, n);
    }

    @Override
    public Drawable getUserBadgeForDensityNoBackground(UserHandle userHandle, int n) {
        return InvokeDynamicSupport.bootstrap("getUserBadgeForDensityNoBackground", $$robo$$android_app_ApplicationPackageManager$getUserBadgeForDensityNoBackground(android.os.UserHandle int ), this, userHandle, n);
    }

    private Drawable getDrawableForDensity(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getDrawableForDensity", $$robo$$android_app_ApplicationPackageManager$getDrawableForDensity(int int ), this, n, n2);
    }

    private Drawable getManagedProfileIconForDensity(UserHandle userHandle, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getManagedProfileIconForDensity", $$robo$$android_app_ApplicationPackageManager$getManagedProfileIconForDensity(android.os.UserHandle int int ), this, userHandle, n, n2);
    }

    @Override
    public CharSequence getUserBadgedLabel(CharSequence charSequence, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getUserBadgedLabel", $$robo$$android_app_ApplicationPackageManager$getUserBadgedLabel(java.lang.CharSequence android.os.UserHandle ), this, charSequence, userHandle);
    }

    @Override
    public Resources getResourcesForActivity(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourcesForActivity", $$robo$$android_app_ApplicationPackageManager$getResourcesForActivity(android.content.ComponentName ), this, componentName);
    }

    @Override
    public Resources getResourcesForApplication(ApplicationInfo applicationInfo) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourcesForApplication", $$robo$$android_app_ApplicationPackageManager$getResourcesForApplication(android.content.pm.ApplicationInfo ), this, applicationInfo);
    }

    @Override
    public Resources getResourcesForApplication(String string2) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourcesForApplication", $$robo$$android_app_ApplicationPackageManager$getResourcesForApplication(java.lang.String ), this, string2);
    }

    @Override
    public Resources getResourcesForApplicationAsUser(String string2, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourcesForApplicationAsUser", $$robo$$android_app_ApplicationPackageManager$getResourcesForApplicationAsUser(java.lang.String int ), this, string2, n);
    }

    @Override
    public boolean isSafeMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSafeMode", $$robo$$android_app_ApplicationPackageManager$isSafeMode(), this);
    }

    @Override
    public void addOnPermissionsChangeListener(PackageManager.OnPermissionsChangedListener onPermissionsChangedListener) {
        InvokeDynamicSupport.bootstrap("addOnPermissionsChangeListener", $$robo$$android_app_ApplicationPackageManager$addOnPermissionsChangeListener(android.content.pm.PackageManager$OnPermissionsChangedListener ), this, onPermissionsChangedListener);
    }

    @Override
    public void removeOnPermissionsChangeListener(PackageManager.OnPermissionsChangedListener onPermissionsChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnPermissionsChangeListener", $$robo$$android_app_ApplicationPackageManager$removeOnPermissionsChangeListener(android.content.pm.PackageManager$OnPermissionsChangedListener ), this, onPermissionsChangedListener);
    }

    static void configurationChanged() {
        InvokeDynamicSupport.bootstrapStatic("configurationChanged", $$robo$$android_app_ApplicationPackageManager$configurationChanged());
    }

    private void __constructor__(ContextImpl contextImpl, IPackageManager iPackageManager) {
        this.$$robo$$android_app_ApplicationPackageManager$__constructor__(contextImpl, iPackageManager);
    }

    public ApplicationPackageManager(ContextImpl contextImpl, IPackageManager iPackageManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ApplicationPackageManager$__constructor__(android.app.ContextImpl android.content.pm.IPackageManager ), this, contextImpl, iPackageManager);
    }

    private Drawable getCachedIcon(ResourceName resourceName) {
        return InvokeDynamicSupport.bootstrap("getCachedIcon", $$robo$$android_app_ApplicationPackageManager$getCachedIcon(android.app.ApplicationPackageManager$ResourceName ), this, resourceName);
    }

    private void putCachedIcon(ResourceName resourceName, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("putCachedIcon", $$robo$$android_app_ApplicationPackageManager$putCachedIcon(android.app.ApplicationPackageManager$ResourceName android.graphics.drawable.Drawable ), this, resourceName, drawable2);
    }

    static void handlePackageBroadcast(int n, String[] stringArray, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("handlePackageBroadcast", $$robo$$android_app_ApplicationPackageManager$handlePackageBroadcast(int java.lang.String[] boolean ), (int)n, (String[])stringArray, (boolean)bl);
    }

    private CharSequence getCachedString(ResourceName resourceName) {
        return InvokeDynamicSupport.bootstrap("getCachedString", $$robo$$android_app_ApplicationPackageManager$getCachedString(android.app.ApplicationPackageManager$ResourceName ), this, resourceName);
    }

    private void putCachedString(ResourceName resourceName, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("putCachedString", $$robo$$android_app_ApplicationPackageManager$putCachedString(android.app.ApplicationPackageManager$ResourceName java.lang.CharSequence ), this, resourceName, charSequence);
    }

    @Override
    public CharSequence getText(String string2, int n, ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_app_ApplicationPackageManager$getText(java.lang.String int android.content.pm.ApplicationInfo ), this, string2, n, applicationInfo);
    }

    @Override
    public XmlResourceParser getXml(String string2, int n, ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrap("getXml", $$robo$$android_app_ApplicationPackageManager$getXml(java.lang.String int android.content.pm.ApplicationInfo ), this, string2, n, applicationInfo);
    }

    @Override
    public CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrap("getApplicationLabel", $$robo$$android_app_ApplicationPackageManager$getApplicationLabel(android.content.pm.ApplicationInfo ), this, applicationInfo);
    }

    @Override
    public int installExistingPackage(String string2) throws PackageManager.NameNotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("installExistingPackage", $$robo$$android_app_ApplicationPackageManager$installExistingPackage(java.lang.String ), this, string2);
    }

    @Override
    public int installExistingPackage(String string2, int n) throws PackageManager.NameNotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("installExistingPackage", $$robo$$android_app_ApplicationPackageManager$installExistingPackage(java.lang.String int ), this, string2, n);
    }

    @Override
    public int installExistingPackageAsUser(String string2, int n) throws PackageManager.NameNotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("installExistingPackageAsUser", $$robo$$android_app_ApplicationPackageManager$installExistingPackageAsUser(java.lang.String int ), this, string2, n);
    }

    private int installExistingPackageAsUser(String string2, int n, int n2) throws PackageManager.NameNotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("installExistingPackageAsUser", $$robo$$android_app_ApplicationPackageManager$installExistingPackageAsUser(java.lang.String int int ), this, string2, n, n2);
    }

    @Override
    public void verifyPendingInstall(int n, int n2) {
        InvokeDynamicSupport.bootstrap("verifyPendingInstall", $$robo$$android_app_ApplicationPackageManager$verifyPendingInstall(int int ), this, n, n2);
    }

    @Override
    public void extendVerificationTimeout(int n, int n2, long l) {
        InvokeDynamicSupport.bootstrap("extendVerificationTimeout", $$robo$$android_app_ApplicationPackageManager$extendVerificationTimeout(int int long ), this, n, n2, l);
    }

    @Override
    public void verifyIntentFilter(int n, int n2, List<String> list) {
        InvokeDynamicSupport.bootstrap("verifyIntentFilter", $$robo$$android_app_ApplicationPackageManager$verifyIntentFilter(int int java.util.List<java.lang.String> ), this, n, n2, list);
    }

    @Override
    public int getIntentVerificationStatusAsUser(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getIntentVerificationStatusAsUser", $$robo$$android_app_ApplicationPackageManager$getIntentVerificationStatusAsUser(java.lang.String int ), this, string2, n);
    }

    @Override
    public boolean updateIntentVerificationStatusAsUser(String string2, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateIntentVerificationStatusAsUser", $$robo$$android_app_ApplicationPackageManager$updateIntentVerificationStatusAsUser(java.lang.String int int ), this, string2, n, n2);
    }

    @Override
    public List<IntentFilterVerificationInfo> getIntentFilterVerifications(String string2) {
        return InvokeDynamicSupport.bootstrap("getIntentFilterVerifications", $$robo$$android_app_ApplicationPackageManager$getIntentFilterVerifications(java.lang.String ), this, string2);
    }

    @Override
    public List<IntentFilter> getAllIntentFilters(String string2) {
        return InvokeDynamicSupport.bootstrap("getAllIntentFilters", $$robo$$android_app_ApplicationPackageManager$getAllIntentFilters(java.lang.String ), this, string2);
    }

    @Override
    public String getDefaultBrowserPackageNameAsUser(int n) {
        return InvokeDynamicSupport.bootstrap("getDefaultBrowserPackageNameAsUser", $$robo$$android_app_ApplicationPackageManager$getDefaultBrowserPackageNameAsUser(int ), this, n);
    }

    @Override
    public boolean setDefaultBrowserPackageNameAsUser(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDefaultBrowserPackageNameAsUser", $$robo$$android_app_ApplicationPackageManager$setDefaultBrowserPackageNameAsUser(java.lang.String int ), this, string2, n);
    }

    @Override
    public void setInstallerPackageName(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setInstallerPackageName", $$robo$$android_app_ApplicationPackageManager$setInstallerPackageName(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public void setUpdateAvailable(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setUpdateAvailable", $$robo$$android_app_ApplicationPackageManager$setUpdateAvailable(java.lang.String boolean ), this, string2, bl);
    }

    @Override
    public String getInstallerPackageName(String string2) {
        return InvokeDynamicSupport.bootstrap("getInstallerPackageName", $$robo$$android_app_ApplicationPackageManager$getInstallerPackageName(java.lang.String ), this, string2);
    }

    @Override
    public int getMoveStatus(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMoveStatus", $$robo$$android_app_ApplicationPackageManager$getMoveStatus(int ), this, n);
    }

    @Override
    public void registerMoveCallback(PackageManager.MoveCallback moveCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerMoveCallback", $$robo$$android_app_ApplicationPackageManager$registerMoveCallback(android.content.pm.PackageManager$MoveCallback android.os.Handler ), this, moveCallback, handler);
    }

    @Override
    public void unregisterMoveCallback(PackageManager.MoveCallback moveCallback) {
        InvokeDynamicSupport.bootstrap("unregisterMoveCallback", $$robo$$android_app_ApplicationPackageManager$unregisterMoveCallback(android.content.pm.PackageManager$MoveCallback ), this, moveCallback);
    }

    @Override
    public int movePackage(String string2, VolumeInfo volumeInfo) {
        return (int)InvokeDynamicSupport.bootstrap("movePackage", $$robo$$android_app_ApplicationPackageManager$movePackage(java.lang.String android.os.storage.VolumeInfo ), this, string2, volumeInfo);
    }

    @Override
    public VolumeInfo getPackageCurrentVolume(ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrap("getPackageCurrentVolume", $$robo$$android_app_ApplicationPackageManager$getPackageCurrentVolume(android.content.pm.ApplicationInfo ), this, applicationInfo);
    }

    protected VolumeInfo getPackageCurrentVolume(ApplicationInfo applicationInfo, StorageManager storageManager) {
        return InvokeDynamicSupport.bootstrap("getPackageCurrentVolume", $$robo$$android_app_ApplicationPackageManager$getPackageCurrentVolume(android.content.pm.ApplicationInfo android.os.storage.StorageManager ), this, applicationInfo, storageManager);
    }

    @Override
    public List<VolumeInfo> getPackageCandidateVolumes(ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrap("getPackageCandidateVolumes", $$robo$$android_app_ApplicationPackageManager$getPackageCandidateVolumes(android.content.pm.ApplicationInfo ), this, applicationInfo);
    }

    protected List<VolumeInfo> getPackageCandidateVolumes(ApplicationInfo applicationInfo, StorageManager storageManager, IPackageManager iPackageManager) {
        return InvokeDynamicSupport.bootstrap("getPackageCandidateVolumes", $$robo$$android_app_ApplicationPackageManager$getPackageCandidateVolumes(android.content.pm.ApplicationInfo android.os.storage.StorageManager android.content.pm.IPackageManager ), this, applicationInfo, storageManager, iPackageManager);
    }

    protected boolean isForceAllowOnExternal(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrap("isForceAllowOnExternal", $$robo$$android_app_ApplicationPackageManager$isForceAllowOnExternal(android.content.Context ), this, context);
    }

    protected boolean isAllow3rdPartyOnInternal(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAllow3rdPartyOnInternal", $$robo$$android_app_ApplicationPackageManager$isAllow3rdPartyOnInternal(android.content.Context ), this, context);
    }

    private boolean isPackageCandidateVolume(ContextImpl contextImpl, ApplicationInfo applicationInfo, VolumeInfo volumeInfo, IPackageManager iPackageManager) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPackageCandidateVolume", $$robo$$android_app_ApplicationPackageManager$isPackageCandidateVolume(android.app.ContextImpl android.content.pm.ApplicationInfo android.os.storage.VolumeInfo android.content.pm.IPackageManager ), this, contextImpl, applicationInfo, volumeInfo, iPackageManager);
    }

    @Override
    public int movePrimaryStorage(VolumeInfo volumeInfo) {
        return (int)InvokeDynamicSupport.bootstrap("movePrimaryStorage", $$robo$$android_app_ApplicationPackageManager$movePrimaryStorage(android.os.storage.VolumeInfo ), this, volumeInfo);
    }

    @Override
    public VolumeInfo getPrimaryStorageCurrentVolume() {
        return InvokeDynamicSupport.bootstrap("getPrimaryStorageCurrentVolume", $$robo$$android_app_ApplicationPackageManager$getPrimaryStorageCurrentVolume(), this);
    }

    @Override
    public List<VolumeInfo> getPrimaryStorageCandidateVolumes() {
        return InvokeDynamicSupport.bootstrap("getPrimaryStorageCandidateVolumes", $$robo$$android_app_ApplicationPackageManager$getPrimaryStorageCandidateVolumes(), this);
    }

    private static boolean isPrimaryStorageCandidateVolume(VolumeInfo volumeInfo) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPrimaryStorageCandidateVolume", $$robo$$android_app_ApplicationPackageManager$isPrimaryStorageCandidateVolume(android.os.storage.VolumeInfo ), (VolumeInfo)volumeInfo);
    }

    @Override
    public void deletePackage(String string2, IPackageDeleteObserver iPackageDeleteObserver, int n) {
        InvokeDynamicSupport.bootstrap("deletePackage", $$robo$$android_app_ApplicationPackageManager$deletePackage(java.lang.String android.content.pm.IPackageDeleteObserver int ), this, string2, iPackageDeleteObserver, n);
    }

    @Override
    public void deletePackageAsUser(String string2, IPackageDeleteObserver iPackageDeleteObserver, int n, int n2) {
        InvokeDynamicSupport.bootstrap("deletePackageAsUser", $$robo$$android_app_ApplicationPackageManager$deletePackageAsUser(java.lang.String android.content.pm.IPackageDeleteObserver int int ), this, string2, iPackageDeleteObserver, n, n2);
    }

    @Override
    public void clearApplicationUserData(String string2, IPackageDataObserver iPackageDataObserver) {
        InvokeDynamicSupport.bootstrap("clearApplicationUserData", $$robo$$android_app_ApplicationPackageManager$clearApplicationUserData(java.lang.String android.content.pm.IPackageDataObserver ), this, string2, iPackageDataObserver);
    }

    @Override
    public void deleteApplicationCacheFiles(String string2, IPackageDataObserver iPackageDataObserver) {
        InvokeDynamicSupport.bootstrap("deleteApplicationCacheFiles", $$robo$$android_app_ApplicationPackageManager$deleteApplicationCacheFiles(java.lang.String android.content.pm.IPackageDataObserver ), this, string2, iPackageDataObserver);
    }

    @Override
    public void deleteApplicationCacheFilesAsUser(String string2, int n, IPackageDataObserver iPackageDataObserver) {
        InvokeDynamicSupport.bootstrap("deleteApplicationCacheFilesAsUser", $$robo$$android_app_ApplicationPackageManager$deleteApplicationCacheFilesAsUser(java.lang.String int android.content.pm.IPackageDataObserver ), this, string2, n, iPackageDataObserver);
    }

    @Override
    public void freeStorageAndNotify(String string2, long l, IPackageDataObserver iPackageDataObserver) {
        InvokeDynamicSupport.bootstrap("freeStorageAndNotify", $$robo$$android_app_ApplicationPackageManager$freeStorageAndNotify(java.lang.String long android.content.pm.IPackageDataObserver ), this, string2, l, iPackageDataObserver);
    }

    @Override
    public void freeStorage(String string2, long l, IntentSender intentSender) {
        InvokeDynamicSupport.bootstrap("freeStorage", $$robo$$android_app_ApplicationPackageManager$freeStorage(java.lang.String long android.content.IntentSender ), this, string2, l, intentSender);
    }

    @Override
    public String[] setPackagesSuspended(String[] stringArray, boolean bl, PersistableBundle persistableBundle, PersistableBundle persistableBundle2, String string2) {
        return InvokeDynamicSupport.bootstrap("setPackagesSuspended", $$robo$$android_app_ApplicationPackageManager$setPackagesSuspended(java.lang.String[] boolean android.os.PersistableBundle android.os.PersistableBundle java.lang.String ), this, stringArray, bl, persistableBundle, persistableBundle2, string2);
    }

    @Override
    public Bundle getSuspendedPackageAppExtras() {
        return InvokeDynamicSupport.bootstrap("getSuspendedPackageAppExtras", $$robo$$android_app_ApplicationPackageManager$getSuspendedPackageAppExtras(), this);
    }

    @Override
    public boolean isPackageSuspendedForUser(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPackageSuspendedForUser", $$robo$$android_app_ApplicationPackageManager$isPackageSuspendedForUser(java.lang.String int ), this, string2, n);
    }

    @Override
    public boolean isPackageSuspended(String string2) throws PackageManager.NameNotFoundException {
        return (boolean)InvokeDynamicSupport.bootstrap("isPackageSuspended", $$robo$$android_app_ApplicationPackageManager$isPackageSuspended(java.lang.String ), this, string2);
    }

    @Override
    public boolean isPackageSuspended() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPackageSuspended", $$robo$$android_app_ApplicationPackageManager$isPackageSuspended(), this);
    }

    @Override
    public void setApplicationCategoryHint(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setApplicationCategoryHint", $$robo$$android_app_ApplicationPackageManager$setApplicationCategoryHint(java.lang.String int ), this, string2, n);
    }

    @Override
    public void getPackageSizeInfoAsUser(String string2, int n, IPackageStatsObserver iPackageStatsObserver) {
        InvokeDynamicSupport.bootstrap("getPackageSizeInfoAsUser", $$robo$$android_app_ApplicationPackageManager$getPackageSizeInfoAsUser(java.lang.String int android.content.pm.IPackageStatsObserver ), this, string2, n, iPackageStatsObserver);
    }

    @Override
    public void addPackageToPreferred(String string2) {
        InvokeDynamicSupport.bootstrap("addPackageToPreferred", $$robo$$android_app_ApplicationPackageManager$addPackageToPreferred(java.lang.String ), this, string2);
    }

    @Override
    public void removePackageFromPreferred(String string2) {
        InvokeDynamicSupport.bootstrap("removePackageFromPreferred", $$robo$$android_app_ApplicationPackageManager$removePackageFromPreferred(java.lang.String ), this, string2);
    }

    @Override
    public List<PackageInfo> getPreferredPackages(int n) {
        return InvokeDynamicSupport.bootstrap("getPreferredPackages", $$robo$$android_app_ApplicationPackageManager$getPreferredPackages(int ), this, n);
    }

    @Override
    public void addPreferredActivity(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("addPreferredActivity", $$robo$$android_app_ApplicationPackageManager$addPreferredActivity(android.content.IntentFilter int android.content.ComponentName[] android.content.ComponentName ), this, intentFilter, n, componentNameArray, componentName);
    }

    @Override
    public void addPreferredActivityAsUser(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName, int n2) {
        InvokeDynamicSupport.bootstrap("addPreferredActivityAsUser", $$robo$$android_app_ApplicationPackageManager$addPreferredActivityAsUser(android.content.IntentFilter int android.content.ComponentName[] android.content.ComponentName int ), this, intentFilter, n, componentNameArray, componentName, n2);
    }

    @Override
    public void replacePreferredActivity(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("replacePreferredActivity", $$robo$$android_app_ApplicationPackageManager$replacePreferredActivity(android.content.IntentFilter int android.content.ComponentName[] android.content.ComponentName ), this, intentFilter, n, componentNameArray, componentName);
    }

    @Override
    public void replacePreferredActivityAsUser(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName, int n2) {
        InvokeDynamicSupport.bootstrap("replacePreferredActivityAsUser", $$robo$$android_app_ApplicationPackageManager$replacePreferredActivityAsUser(android.content.IntentFilter int android.content.ComponentName[] android.content.ComponentName int ), this, intentFilter, n, componentNameArray, componentName, n2);
    }

    @Override
    public void clearPackagePreferredActivities(String string2) {
        InvokeDynamicSupport.bootstrap("clearPackagePreferredActivities", $$robo$$android_app_ApplicationPackageManager$clearPackagePreferredActivities(java.lang.String ), this, string2);
    }

    @Override
    public int getPreferredActivities(List<IntentFilter> list, List<ComponentName> list2, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getPreferredActivities", $$robo$$android_app_ApplicationPackageManager$getPreferredActivities(java.util.List<android.content.IntentFilter> java.util.List<android.content.ComponentName> java.lang.String ), this, list, list2, string2);
    }

    @Override
    public ComponentName getHomeActivities(List<ResolveInfo> list) {
        return InvokeDynamicSupport.bootstrap("getHomeActivities", $$robo$$android_app_ApplicationPackageManager$getHomeActivities(java.util.List<android.content.pm.ResolveInfo> ), this, list);
    }

    @Override
    public void setComponentEnabledSetting(ComponentName componentName, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setComponentEnabledSetting", $$robo$$android_app_ApplicationPackageManager$setComponentEnabledSetting(android.content.ComponentName int int ), this, componentName, n, n2);
    }

    @Override
    public int getComponentEnabledSetting(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getComponentEnabledSetting", $$robo$$android_app_ApplicationPackageManager$getComponentEnabledSetting(android.content.ComponentName ), this, componentName);
    }

    @Override
    public void setApplicationEnabledSetting(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setApplicationEnabledSetting", $$robo$$android_app_ApplicationPackageManager$setApplicationEnabledSetting(java.lang.String int int ), this, string2, n, n2);
    }

    @Override
    public int getApplicationEnabledSetting(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getApplicationEnabledSetting", $$robo$$android_app_ApplicationPackageManager$getApplicationEnabledSetting(java.lang.String ), this, string2);
    }

    @Override
    public void flushPackageRestrictionsAsUser(int n) {
        InvokeDynamicSupport.bootstrap("flushPackageRestrictionsAsUser", $$robo$$android_app_ApplicationPackageManager$flushPackageRestrictionsAsUser(int ), this, n);
    }

    @Override
    public boolean setApplicationHiddenSettingAsUser(String string2, boolean bl, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("setApplicationHiddenSettingAsUser", $$robo$$android_app_ApplicationPackageManager$setApplicationHiddenSettingAsUser(java.lang.String boolean android.os.UserHandle ), this, string2, bl, userHandle);
    }

    @Override
    public boolean getApplicationHiddenSettingAsUser(String string2, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("getApplicationHiddenSettingAsUser", $$robo$$android_app_ApplicationPackageManager$getApplicationHiddenSettingAsUser(java.lang.String android.os.UserHandle ), this, string2, userHandle);
    }

    @Override
    public KeySet getKeySetByAlias(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getKeySetByAlias", $$robo$$android_app_ApplicationPackageManager$getKeySetByAlias(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public KeySet getSigningKeySet(String string2) {
        return InvokeDynamicSupport.bootstrap("getSigningKeySet", $$robo$$android_app_ApplicationPackageManager$getSigningKeySet(java.lang.String ), this, string2);
    }

    @Override
    public boolean isSignedBy(String string2, KeySet keySet) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSignedBy", $$robo$$android_app_ApplicationPackageManager$isSignedBy(java.lang.String android.content.pm.KeySet ), this, string2, keySet);
    }

    @Override
    public boolean isSignedByExactly(String string2, KeySet keySet) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSignedByExactly", $$robo$$android_app_ApplicationPackageManager$isSignedByExactly(java.lang.String android.content.pm.KeySet ), this, string2, keySet);
    }

    @Override
    public VerifierDeviceIdentity getVerifierDeviceIdentity() {
        return InvokeDynamicSupport.bootstrap("getVerifierDeviceIdentity", $$robo$$android_app_ApplicationPackageManager$getVerifierDeviceIdentity(), this);
    }

    @Override
    public boolean isUpgrade() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUpgrade", $$robo$$android_app_ApplicationPackageManager$isUpgrade(), this);
    }

    @Override
    public PackageInstaller getPackageInstaller() {
        return InvokeDynamicSupport.bootstrap("getPackageInstaller", $$robo$$android_app_ApplicationPackageManager$getPackageInstaller(), this);
    }

    @Override
    public boolean isPackageAvailable(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPackageAvailable", $$robo$$android_app_ApplicationPackageManager$isPackageAvailable(java.lang.String ), this, string2);
    }

    @Override
    public void addCrossProfileIntentFilter(IntentFilter intentFilter, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("addCrossProfileIntentFilter", $$robo$$android_app_ApplicationPackageManager$addCrossProfileIntentFilter(android.content.IntentFilter int int int ), this, intentFilter, n, n2, n3);
    }

    @Override
    public void clearCrossProfileIntentFilters(int n) {
        InvokeDynamicSupport.bootstrap("clearCrossProfileIntentFilters", $$robo$$android_app_ApplicationPackageManager$clearCrossProfileIntentFilters(int ), this, n);
    }

    @Override
    public Drawable loadItemIcon(PackageItemInfo packageItemInfo, ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrap("loadItemIcon", $$robo$$android_app_ApplicationPackageManager$loadItemIcon(android.content.pm.PackageItemInfo android.content.pm.ApplicationInfo ), this, packageItemInfo, applicationInfo);
    }

    @Override
    public Drawable loadUnbadgedItemIcon(PackageItemInfo packageItemInfo, ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrap("loadUnbadgedItemIcon", $$robo$$android_app_ApplicationPackageManager$loadUnbadgedItemIcon(android.content.pm.PackageItemInfo android.content.pm.ApplicationInfo ), this, packageItemInfo, applicationInfo);
    }

    private Drawable getBadgedDrawable(Drawable drawable2, Drawable drawable3, Rect rect, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getBadgedDrawable", $$robo$$android_app_ApplicationPackageManager$getBadgedDrawable(android.graphics.drawable.Drawable android.graphics.drawable.Drawable android.graphics.Rect boolean ), this, drawable2, drawable3, rect, bl);
    }

    private boolean isManagedProfile(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isManagedProfile", $$robo$$android_app_ApplicationPackageManager$isManagedProfile(int ), this, n);
    }

    @Override
    public int getInstallReason(String string2, UserHandle userHandle) {
        return (int)InvokeDynamicSupport.bootstrap("getInstallReason", $$robo$$android_app_ApplicationPackageManager$getInstallReason(java.lang.String android.os.UserHandle ), this, string2, userHandle);
    }

    @Override
    public boolean canRequestPackageInstalls() {
        return (boolean)InvokeDynamicSupport.bootstrap("canRequestPackageInstalls", $$robo$$android_app_ApplicationPackageManager$canRequestPackageInstalls(), this);
    }

    @Override
    public ComponentName getInstantAppResolverSettingsComponent() {
        return InvokeDynamicSupport.bootstrap("getInstantAppResolverSettingsComponent", $$robo$$android_app_ApplicationPackageManager$getInstantAppResolverSettingsComponent(), this);
    }

    @Override
    public ComponentName getInstantAppInstallerComponent() {
        return InvokeDynamicSupport.bootstrap("getInstantAppInstallerComponent", $$robo$$android_app_ApplicationPackageManager$getInstantAppInstallerComponent(), this);
    }

    @Override
    public String getInstantAppAndroidId(String string2, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getInstantAppAndroidId", $$robo$$android_app_ApplicationPackageManager$getInstantAppAndroidId(java.lang.String android.os.UserHandle ), this, string2, userHandle);
    }

    @Override
    public void registerDexModule(String string2, PackageManager.DexModuleRegisterCallback dexModuleRegisterCallback) {
        InvokeDynamicSupport.bootstrap("registerDexModule", $$robo$$android_app_ApplicationPackageManager$registerDexModule(java.lang.String android.content.pm.PackageManager$DexModuleRegisterCallback ), this, string2, dexModuleRegisterCallback);
    }

    @Override
    public CharSequence getHarmfulAppWarning(String string2) {
        return InvokeDynamicSupport.bootstrap("getHarmfulAppWarning", $$robo$$android_app_ApplicationPackageManager$getHarmfulAppWarning(java.lang.String ), this, string2);
    }

    @Override
    public void setHarmfulAppWarning(String string2, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setHarmfulAppWarning", $$robo$$android_app_ApplicationPackageManager$setHarmfulAppWarning(java.lang.String java.lang.CharSequence ), this, string2, charSequence);
    }

    @Override
    public ArtManager getArtManager() {
        return InvokeDynamicSupport.bootstrap("getArtManager", $$robo$$android_app_ApplicationPackageManager$getArtManager(), this);
    }

    @Override
    public String getSystemTextClassifierPackageName() {
        return InvokeDynamicSupport.bootstrap("getSystemTextClassifierPackageName", $$robo$$android_app_ApplicationPackageManager$getSystemTextClassifierPackageName(), this);
    }

    @Override
    public boolean isPackageStateProtected(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPackageStateProtected", $$robo$$android_app_ApplicationPackageManager$isPackageStateProtected(java.lang.String int ), this, string2, n);
    }

    static {
        RobolectricInternals.classInitializing(ApplicationPackageManager.class);
    }

    public /* synthetic */ ApplicationPackageManager() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApplicationPackageManager)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class DexModuleRegisterCallbackDelegate
    extends IDexModuleRegisterCallback.Stub
    implements Handler.Callback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int MSG_DEX_MODULE_REGISTERED = 1;
        private PackageManager.DexModuleRegisterCallback callback;
        private Handler mHandler;

        private void $$robo$$android_app_ApplicationPackageManager_DexModuleRegisterCallbackDelegate$__constructor__(PackageManager.DexModuleRegisterCallback callback) {
            this.callback = callback;
            this.mHandler = new Handler(Looper.getMainLooper(), this);
        }

        private final void $$robo$$android_app_ApplicationPackageManager_DexModuleRegisterCallbackDelegate$onDexModuleRegistered(String dexModulePath, boolean success, String message) throws RemoteException {
            this.mHandler.obtainMessage(1, new DexModuleRegisterResult(dexModulePath, success, message, null)).sendToTarget();
        }

        private final boolean $$robo$$android_app_ApplicationPackageManager_DexModuleRegisterCallbackDelegate$handleMessage(Message msg) {
            if (msg.what != 1) {
                return false;
            }
            DexModuleRegisterResult result = (DexModuleRegisterResult)msg.obj;
            this.callback.onDexModuleRegistered(result.dexModulePath, result.success, result.message);
            return true;
        }

        private void __constructor__(PackageManager.DexModuleRegisterCallback dexModuleRegisterCallback) {
            this.$$robo$$android_app_ApplicationPackageManager_DexModuleRegisterCallbackDelegate$__constructor__(dexModuleRegisterCallback);
        }

        public DexModuleRegisterCallbackDelegate(PackageManager.DexModuleRegisterCallback dexModuleRegisterCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ApplicationPackageManager_DexModuleRegisterCallbackDelegate$__constructor__(android.content.pm.PackageManager$DexModuleRegisterCallback ), this, dexModuleRegisterCallback);
        }

        @Override
        public void onDexModuleRegistered(String string2, boolean bl, String string3) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onDexModuleRegistered", $$robo$$android_app_ApplicationPackageManager_DexModuleRegisterCallbackDelegate$onDexModuleRegistered(java.lang.String boolean java.lang.String ), this, string2, bl, string3);
        }

        @Override
        public boolean handleMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_ApplicationPackageManager_DexModuleRegisterCallbackDelegate$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ DexModuleRegisterCallbackDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DexModuleRegisterCallbackDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class DexModuleRegisterResult
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        String dexModulePath;
        boolean success;
        String message;

        private void $$robo$$android_app_ApplicationPackageManager_DexModuleRegisterResult$__constructor__(String dexModulePath, boolean success, String message) {
            this.dexModulePath = dexModulePath;
            this.success = success;
            this.message = message;
        }

        private /* synthetic */ void $$robo$$android_app_ApplicationPackageManager_DexModuleRegisterResult$__constructor__(String x0, boolean x1, String x2, 1 x3) {
        }

        private void __constructor__(String string2, boolean bl, String string3) {
            this.$$robo$$android_app_ApplicationPackageManager_DexModuleRegisterResult$__constructor__(string2, bl, string3);
        }

        public DexModuleRegisterResult(String string2, boolean bl, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ApplicationPackageManager_DexModuleRegisterResult$__constructor__(java.lang.String boolean java.lang.String ), this, string2, bl, string3);
        }

        private /* synthetic */ void __constructor__(String string2, boolean bl, String string3, 1 var4_4) {
            this.$$robo$$android_app_ApplicationPackageManager_DexModuleRegisterResult$__constructor__(string2, bl, string3, var4_4);
        }

        public /* synthetic */ DexModuleRegisterResult(String string2, boolean bl, String string3, 1 var4_4) {
            this(string2, bl, string3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ApplicationPackageManager_DexModuleRegisterResult$__constructor__(java.lang.String boolean java.lang.String android.app.ApplicationPackageManager$1 ), this, string2, bl, string3, var4_4);
        }

        public /* synthetic */ DexModuleRegisterResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DexModuleRegisterResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class OnPermissionsChangeListenerDelegate
    extends IOnPermissionsChangeListener.Stub
    implements Handler.Callback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int MSG_PERMISSIONS_CHANGED = 1;
        private PackageManager.OnPermissionsChangedListener mListener;
        private Handler mHandler;
        /* synthetic */ ApplicationPackageManager this$0;

        private void $$robo$$android_app_ApplicationPackageManager_OnPermissionsChangeListenerDelegate$__constructor__(ApplicationPackageManager this$0, PackageManager.OnPermissionsChangedListener listener, Looper looper) {
            this.this$0 = this$0;
            this.mListener = listener;
            this.mHandler = new Handler(looper, this);
        }

        private final void $$robo$$android_app_ApplicationPackageManager_OnPermissionsChangeListenerDelegate$onPermissionsChanged(int uid) {
            this.mHandler.obtainMessage(1, uid, 0).sendToTarget();
        }

        private final boolean $$robo$$android_app_ApplicationPackageManager_OnPermissionsChangeListenerDelegate$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int uid = msg.arg1;
                    this.mListener.onPermissionsChanged(uid);
                    return true;
                }
            }
            return false;
        }

        private void __constructor__(ApplicationPackageManager applicationPackageManager, PackageManager.OnPermissionsChangedListener onPermissionsChangedListener, Looper looper) {
            this.$$robo$$android_app_ApplicationPackageManager_OnPermissionsChangeListenerDelegate$__constructor__(applicationPackageManager, onPermissionsChangedListener, looper);
        }

        public OnPermissionsChangeListenerDelegate(ApplicationPackageManager applicationPackageManager, PackageManager.OnPermissionsChangedListener onPermissionsChangedListener, Looper looper) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ApplicationPackageManager_OnPermissionsChangeListenerDelegate$__constructor__(android.app.ApplicationPackageManager android.content.pm.PackageManager$OnPermissionsChangedListener android.os.Looper ), this, applicationPackageManager, onPermissionsChangedListener, looper);
        }

        @Override
        public void onPermissionsChanged(int n) {
            InvokeDynamicSupport.bootstrap("onPermissionsChanged", $$robo$$android_app_ApplicationPackageManager_OnPermissionsChangeListenerDelegate$onPermissionsChanged(int ), this, n);
        }

        @Override
        public boolean handleMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_ApplicationPackageManager_OnPermissionsChangeListenerDelegate$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ OnPermissionsChangeListenerDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnPermissionsChangeListenerDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class MoveCallbackDelegate
    extends IPackageMoveObserver.Stub
    implements Handler.Callback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int MSG_CREATED = 1;
        private static int MSG_STATUS_CHANGED = 2;
        PackageManager.MoveCallback mCallback;
        Handler mHandler;

        private void $$robo$$android_app_ApplicationPackageManager_MoveCallbackDelegate$__constructor__(PackageManager.MoveCallback callback, Looper looper) {
            this.mCallback = callback;
            this.mHandler = new Handler(looper, this);
        }

        private final boolean $$robo$$android_app_ApplicationPackageManager_MoveCallbackDelegate$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    this.mCallback.onCreated(args.argi1, (Bundle)args.arg2);
                    args.recycle();
                    return true;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    this.mCallback.onStatusChanged(args.argi1, args.argi2, (Long)args.arg3);
                    args.recycle();
                    return true;
                }
            }
            return false;
        }

        private final void $$robo$$android_app_ApplicationPackageManager_MoveCallbackDelegate$onCreated(int moveId, Bundle extras) {
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = moveId;
            args.arg2 = extras;
            this.mHandler.obtainMessage(1, args).sendToTarget();
        }

        private final void $$robo$$android_app_ApplicationPackageManager_MoveCallbackDelegate$onStatusChanged(int moveId, int status, long estMillis) {
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = moveId;
            args.argi2 = status;
            args.arg3 = estMillis;
            this.mHandler.obtainMessage(2, args).sendToTarget();
        }

        private void __constructor__(PackageManager.MoveCallback moveCallback, Looper looper) {
            this.$$robo$$android_app_ApplicationPackageManager_MoveCallbackDelegate$__constructor__(moveCallback, looper);
        }

        public MoveCallbackDelegate(PackageManager.MoveCallback moveCallback, Looper looper) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ApplicationPackageManager_MoveCallbackDelegate$__constructor__(android.content.pm.PackageManager$MoveCallback android.os.Looper ), this, moveCallback, looper);
        }

        @Override
        public boolean handleMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_ApplicationPackageManager_MoveCallbackDelegate$handleMessage(android.os.Message ), this, message);
        }

        @Override
        public void onCreated(int n, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onCreated", $$robo$$android_app_ApplicationPackageManager_MoveCallbackDelegate$onCreated(int android.os.Bundle ), this, n, bundle);
        }

        @Override
        public void onStatusChanged(int n, int n2, long l) {
            InvokeDynamicSupport.bootstrap("onStatusChanged", $$robo$$android_app_ApplicationPackageManager_MoveCallbackDelegate$onStatusChanged(int int long ), this, n, n2, l);
        }

        public /* synthetic */ MoveCallbackDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MoveCallbackDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ResourceName
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        String packageName;
        int iconId;

        private void $$robo$$android_app_ApplicationPackageManager_ResourceName$__constructor__(String _packageName, int _iconId) {
            this.packageName = _packageName;
            this.iconId = _iconId;
        }

        private void $$robo$$android_app_ApplicationPackageManager_ResourceName$__constructor__(ApplicationInfo aInfo, int _iconId) {
        }

        private void $$robo$$android_app_ApplicationPackageManager_ResourceName$__constructor__(ComponentInfo cInfo, int _iconId) {
        }

        private void $$robo$$android_app_ApplicationPackageManager_ResourceName$__constructor__(ResolveInfo rInfo, int _iconId) {
        }

        private final boolean $$robo$$android_app_ApplicationPackageManager_ResourceName$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceName that = (ResourceName)o;
            if (this.iconId != that.iconId) {
                return false;
            }
            return !(this.packageName == null ? that.packageName != null : !this.packageName.equals(that.packageName));
        }

        private final int $$robo$$android_app_ApplicationPackageManager_ResourceName$hashCode() {
            int result = this.packageName.hashCode();
            result = 31 * result + this.iconId;
            return result;
        }

        private final String $$robo$$android_app_ApplicationPackageManager_ResourceName$toString() {
            return "{ResourceName " + this.packageName + " / " + this.iconId + "}";
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_app_ApplicationPackageManager_ResourceName$__constructor__(string2, n);
        }

        public ResourceName(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ApplicationPackageManager_ResourceName$__constructor__(java.lang.String int ), this, string2, n);
        }

        private void __constructor__(ApplicationInfo applicationInfo, int n) {
            this.$$robo$$android_app_ApplicationPackageManager_ResourceName$__constructor__(applicationInfo, n);
        }

        public ResourceName(ApplicationInfo applicationInfo, int n) {
            this(applicationInfo.packageName, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ApplicationPackageManager_ResourceName$__constructor__(android.content.pm.ApplicationInfo int ), this, applicationInfo, n);
        }

        private void __constructor__(ComponentInfo componentInfo, int n) {
            this.$$robo$$android_app_ApplicationPackageManager_ResourceName$__constructor__(componentInfo, n);
        }

        public ResourceName(ComponentInfo componentInfo, int n) {
            this(componentInfo.applicationInfo.packageName, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ApplicationPackageManager_ResourceName$__constructor__(android.content.pm.ComponentInfo int ), this, componentInfo, n);
        }

        private void __constructor__(ResolveInfo resolveInfo, int n) {
            this.$$robo$$android_app_ApplicationPackageManager_ResourceName$__constructor__(resolveInfo, n);
        }

        public ResourceName(ResolveInfo resolveInfo, int n) {
            this(resolveInfo.activityInfo.applicationInfo.packageName, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ApplicationPackageManager_ResourceName$__constructor__(android.content.pm.ResolveInfo int ), this, resolveInfo, n);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_app_ApplicationPackageManager_ResourceName$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_app_ApplicationPackageManager_ResourceName$hashCode(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_ApplicationPackageManager_ResourceName$toString(), this);
        }

        public /* synthetic */ ResourceName() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourceName)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

