/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.SharedElementCallback;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.transition.Transition;
import android.transition.TransitionListenerAdapter;
import android.transition.TransitionSet;
import android.transition.Visibility;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.view.GhostView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOverlay;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.ImageView;
import com.android.internal.view.OneShotPreDrawListener;
import java.util.ArrayList;
import java.util.Collection;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ActivityTransitionCoordinator
extends ResultReceiver
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ActivityTransitionCoordinator";
    static String KEY_REMOTE_RECEIVER = "android:remoteReceiver";
    protected static String KEY_SCREEN_LEFT = "shared_element:screenLeft";
    protected static String KEY_SCREEN_TOP = "shared_element:screenTop";
    protected static String KEY_SCREEN_RIGHT = "shared_element:screenRight";
    protected static String KEY_SCREEN_BOTTOM = "shared_element:screenBottom";
    protected static String KEY_TRANSLATION_Z = "shared_element:translationZ";
    protected static String KEY_SNAPSHOT = "shared_element:bitmap";
    protected static String KEY_SCALE_TYPE = "shared_element:scaleType";
    protected static String KEY_IMAGE_MATRIX = "shared_element:imageMatrix";
    protected static String KEY_ELEVATION = "shared_element:elevation";
    protected static ImageView.ScaleType[] SCALE_TYPE_VALUES;
    public static int MSG_SET_REMOTE_RECEIVER = 100;
    public static int MSG_HIDE_SHARED_ELEMENTS = 101;
    public static int MSG_TAKE_SHARED_ELEMENTS = 103;
    public static int MSG_EXIT_TRANSITION_COMPLETE = 104;
    public static int MSG_START_EXIT_TRANSITION = 105;
    public static int MSG_CANCEL = 106;
    public static int MSG_SHARED_ELEMENT_DESTINATION = 107;
    private Window mWindow;
    protected ArrayList<String> mAllSharedElementNames;
    protected ArrayList<View> mSharedElements;
    protected ArrayList<String> mSharedElementNames;
    protected ArrayList<View> mTransitioningViews;
    protected SharedElementCallback mListener;
    protected ResultReceiver mResultReceiver;
    private FixedEpicenterCallback mEpicenterCallback;
    protected boolean mIsReturning;
    private Runnable mPendingTransition;
    private boolean mIsStartingTransition;
    private ArrayList<GhostViewListeners> mGhostViewListeners;
    private ArrayMap<View, Float> mOriginalAlphas;
    private ArrayList<Matrix> mSharedElementParentMatrices;
    private boolean mSharedElementTransitionComplete;
    private boolean mViewsTransitionComplete;
    private boolean mBackgroundAnimatorComplete;
    private ArrayList<View> mStrippedTransitioningViews;

    private void $$robo$$android_app_ActivityTransitionCoordinator$__constructor__(Window window, ArrayList<String> allSharedElementNames, SharedElementCallback listener, boolean isReturning) {
        this.mSharedElements = new ArrayList();
        this.mSharedElementNames = new ArrayList();
        this.mTransitioningViews = new ArrayList();
        this.mEpicenterCallback = new FixedEpicenterCallback(null);
        this.mGhostViewListeners = new ArrayList();
        this.mOriginalAlphas = new ArrayMap();
        this.mStrippedTransitioningViews = new ArrayList();
        this.mWindow = window;
        this.mListener = listener;
        this.mAllSharedElementNames = allSharedElementNames;
        this.mIsReturning = isReturning;
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$viewsReady(ArrayMap<String, View> sharedElements) {
        sharedElements.retainAll(this.mAllSharedElementNames);
        if (this.mListener != null) {
            this.mListener.onMapSharedElements(this.mAllSharedElementNames, sharedElements);
        }
        this.setSharedElements(sharedElements);
        if (this.getViewsTransition() != null && this.mTransitioningViews != null) {
            ViewGroup decorView = this.getDecor();
            if (decorView != null) {
                decorView.captureTransitioningViews(this.mTransitioningViews);
            }
            this.mTransitioningViews.removeAll(this.mSharedElements);
        }
        this.setEpicenter();
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$setSharedElements(ArrayMap<String, View> sharedElements) {
        boolean isFirstRun = true;
        while (!sharedElements.isEmpty()) {
            int numSharedElements = sharedElements.size();
            for (int i = numSharedElements - 1; i >= 0; --i) {
                View view = sharedElements.valueAt(i);
                String name = sharedElements.keyAt(i);
                if (isFirstRun && (view == null || !view.isAttachedToWindow() || name == null)) {
                    sharedElements.removeAt(i);
                    continue;
                }
                if (ActivityTransitionCoordinator.isNested(view, sharedElements)) continue;
                this.mSharedElementNames.add(name);
                this.mSharedElements.add(view);
                sharedElements.removeAt(i);
            }
            isFirstRun = false;
        }
    }

    private static final boolean $$robo$$android_app_ActivityTransitionCoordinator$isNested(View view, ArrayMap<String, View> sharedElements) {
        ViewParent parent = view.getParent();
        boolean isNested = false;
        while (parent instanceof View) {
            View parentView = (View)((Object)parent);
            if (sharedElements.containsValue(parentView)) {
                isNested = true;
                break;
            }
            parent = parentView.getParent();
        }
        return isNested;
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$stripOffscreenViews() {
        if (this.mTransitioningViews == null) {
            return;
        }
        Rect r = new Rect();
        for (int i = this.mTransitioningViews.size() - 1; i >= 0; --i) {
            View view = this.mTransitioningViews.get(i);
            if (view.getGlobalVisibleRect(r)) continue;
            this.mTransitioningViews.remove(i);
            this.mStrippedTransitioningViews.add(view);
        }
    }

    private final Window $$robo$$android_app_ActivityTransitionCoordinator$getWindow() {
        return this.mWindow;
    }

    private final ViewGroup $$robo$$android_app_ActivityTransitionCoordinator$getDecor() {
        return this.mWindow == null ? null : (ViewGroup)this.mWindow.getDecorView();
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$setEpicenter() {
        int index;
        View epicenter = null;
        if (!this.mAllSharedElementNames.isEmpty() && !this.mSharedElementNames.isEmpty() && (index = this.mSharedElementNames.indexOf(this.mAllSharedElementNames.get(0))) >= 0) {
            epicenter = this.mSharedElements.get(index);
        }
        this.setEpicenter(epicenter);
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$setEpicenter(View view) {
        if (view == null) {
            this.mEpicenterCallback.setEpicenter(null);
        } else {
            Rect epicenter = new Rect();
            view.getBoundsOnScreen(epicenter);
            this.mEpicenterCallback.setEpicenter(epicenter);
        }
    }

    private final ArrayList<String> $$robo$$android_app_ActivityTransitionCoordinator$getAcceptedNames() {
        return this.mSharedElementNames;
    }

    private final ArrayList<String> $$robo$$android_app_ActivityTransitionCoordinator$getMappedNames() {
        ArrayList<String> names = new ArrayList<String>(this.mSharedElements.size());
        for (int i = 0; i < this.mSharedElements.size(); ++i) {
            names.add(this.mSharedElements.get(i).getTransitionName());
        }
        return names;
    }

    private final ArrayList<View> $$robo$$android_app_ActivityTransitionCoordinator$copyMappedViews() {
        return new ArrayList<View>(this.mSharedElements);
    }

    private final ArrayList<String> $$robo$$android_app_ActivityTransitionCoordinator$getAllSharedElementNames() {
        return this.mAllSharedElementNames;
    }

    private final Transition $$robo$$android_app_ActivityTransitionCoordinator$setTargets(Transition transition2, boolean add) {
        View view;
        int i;
        if (transition2 == null || add && (this.mTransitioningViews == null || this.mTransitioningViews.isEmpty())) {
            return null;
        }
        TransitionSet set = new TransitionSet();
        if (this.mTransitioningViews != null) {
            for (i = this.mTransitioningViews.size() - 1; i >= 0; --i) {
                view = this.mTransitioningViews.get(i);
                if (add) {
                    set.addTarget(view);
                    continue;
                }
                set.excludeTarget(view, true);
            }
        }
        if (this.mStrippedTransitioningViews != null) {
            for (i = this.mStrippedTransitioningViews.size() - 1; i >= 0; --i) {
                view = this.mStrippedTransitioningViews.get(i);
                set.excludeTarget(view, true);
            }
        }
        set.addTransition(transition2);
        if (!add && this.mTransitioningViews != null && !this.mTransitioningViews.isEmpty()) {
            set = new TransitionSet().addTransition(set);
        }
        return set;
    }

    private final Transition $$robo$$android_app_ActivityTransitionCoordinator$configureTransition(Transition transition2, boolean includeTransitioningViews) {
        if (transition2 != null) {
            transition2 = ((Transition)transition2).clone();
            ((Transition)transition2).setEpicenterCallback(this.mEpicenterCallback);
            transition2 = this.setTargets((Transition)transition2, includeTransitioningViews);
        }
        ActivityTransitionCoordinator.noLayoutSuppressionForVisibilityTransitions((Transition)transition2);
        return transition2;
    }

    private static final void $$robo$$android_app_ActivityTransitionCoordinator$removeExcludedViews(Transition transition2, ArrayList<View> views) {
        ArraySet<View> included = new ArraySet<View>();
        ActivityTransitionCoordinator.findIncludedViews(transition2, views, included);
        views.clear();
        views.addAll(included);
    }

    private static final void $$robo$$android_app_ActivityTransitionCoordinator$findIncludedViews(Transition transition2, ArrayList<View> views, ArraySet<View> included) {
        if (transition2 instanceof TransitionSet) {
            TransitionSet set = (TransitionSet)transition2;
            ArrayList<View> includedViews = new ArrayList<View>();
            int numViews = views.size();
            for (int i = 0; i < numViews; ++i) {
                View view = views.get(i);
                if (!transition2.isValidTarget(view)) continue;
                includedViews.add(view);
            }
            int count = set.getTransitionCount();
            for (int i = 0; i < count; ++i) {
                ActivityTransitionCoordinator.findIncludedViews(set.getTransitionAt(i), includedViews, included);
            }
        } else {
            int numViews = views.size();
            for (int i = 0; i < numViews; ++i) {
                View view = views.get(i);
                if (!transition2.isValidTarget(view)) continue;
                included.add(view);
            }
        }
    }

    private static final Transition $$robo$$android_app_ActivityTransitionCoordinator$mergeTransitions(Transition transition1, Transition transition2) {
        if (transition1 == null) {
            return transition2;
        }
        if (transition2 == null) {
            return transition1;
        }
        TransitionSet transitionSet = new TransitionSet();
        transitionSet.addTransition(transition1);
        transitionSet.addTransition(transition2);
        return transitionSet;
    }

    private final ArrayMap<String, View> $$robo$$android_app_ActivityTransitionCoordinator$mapSharedElements(ArrayList<String> accepted, ArrayList<View> localViews) {
        ArrayMap<String, View> sharedElements = new ArrayMap<String, View>();
        if (accepted != null) {
            for (int i = 0; i < accepted.size(); ++i) {
                sharedElements.put(accepted.get(i), localViews.get(i));
            }
        } else {
            ViewGroup decorView = this.getDecor();
            if (decorView != null) {
                decorView.findNamedViews(sharedElements);
            }
        }
        return sharedElements;
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$setResultReceiver(ResultReceiver resultReceiver) {
        this.mResultReceiver = resultReceiver;
    }

    protected abstract Transition getViewsTransition();

    private final void $$robo$$android_app_ActivityTransitionCoordinator$setSharedElementState(View view, String name, Bundle transitionArgs, Matrix tempMatrix, RectF tempRect, int[] decorLoc) {
        int scaleTypeInt;
        Bundle sharedElementBundle = transitionArgs.getBundle(name);
        if (sharedElementBundle == null) {
            return;
        }
        if (view instanceof ImageView && (scaleTypeInt = sharedElementBundle.getInt("shared_element:scaleType", -1)) >= 0) {
            ImageView imageView = (ImageView)view;
            ImageView.ScaleType scaleType = SCALE_TYPE_VALUES[scaleTypeInt];
            imageView.setScaleType(scaleType);
            if (scaleType == ImageView.ScaleType.MATRIX) {
                float[] matrixValues = sharedElementBundle.getFloatArray("shared_element:imageMatrix");
                tempMatrix.setValues(matrixValues);
                imageView.setImageMatrix(tempMatrix);
            }
        }
        float z = sharedElementBundle.getFloat("shared_element:translationZ");
        view.setTranslationZ(z);
        float elevation = sharedElementBundle.getFloat("shared_element:elevation");
        view.setElevation(elevation);
        float left = sharedElementBundle.getFloat("shared_element:screenLeft");
        float top = sharedElementBundle.getFloat("shared_element:screenTop");
        float right = sharedElementBundle.getFloat("shared_element:screenRight");
        float bottom = sharedElementBundle.getFloat("shared_element:screenBottom");
        if (decorLoc != null) {
            left -= (float)decorLoc[0];
            top -= (float)decorLoc[1];
            right -= (float)decorLoc[0];
            bottom -= (float)decorLoc[1];
        } else {
            this.getSharedElementParentMatrix(view, tempMatrix);
            tempRect.set(left, top, right, bottom);
            tempMatrix.mapRect(tempRect);
            float leftInParent = tempRect.left;
            float topInParent = tempRect.top;
            view.getInverseMatrix().mapRect(tempRect);
            float width = tempRect.width();
            float height = tempRect.height();
            view.setLeft(0);
            view.setTop(0);
            view.setRight(Math.round(width));
            view.setBottom(Math.round(height));
            tempRect.set(0.0f, 0.0f, width, height);
            view.getMatrix().mapRect(tempRect);
            left = leftInParent - tempRect.left;
            top = topInParent - tempRect.top;
            right = left + width;
            bottom = top + height;
        }
        int x = Math.round(left);
        int y = Math.round(top);
        int width = Math.round(right) - x;
        int height = Math.round(bottom) - y;
        int widthSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
        view.measure(widthSpec, heightSpec);
        view.layout(x, y, x + width, y + height);
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$setSharedElementMatrices() {
        int numSharedElements = this.mSharedElements.size();
        if (numSharedElements > 0) {
            this.mSharedElementParentMatrices = new ArrayList(numSharedElements);
        }
        for (int i = 0; i < numSharedElements; ++i) {
            View view = this.mSharedElements.get(i);
            ViewGroup parent = (ViewGroup)view.getParent();
            Matrix matrix = new Matrix();
            if (parent != null) {
                parent.transformMatrixToLocal(matrix);
                matrix.postTranslate(parent.getScrollX(), parent.getScrollY());
            }
            this.mSharedElementParentMatrices.add(matrix);
        }
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$getSharedElementParentMatrix(View view, Matrix matrix) {
        int index;
        int n = index = this.mSharedElementParentMatrices == null ? -1 : this.mSharedElements.indexOf(view);
        if (index < 0) {
            matrix.reset();
            ViewParent viewParent = view.getParent();
            if (viewParent instanceof ViewGroup) {
                ViewGroup parent = (ViewGroup)viewParent;
                parent.transformMatrixToLocal(matrix);
                matrix.postTranslate(parent.getScrollX(), parent.getScrollY());
            }
        } else {
            Matrix parentMatrix = this.mSharedElementParentMatrices.get(index);
            matrix.set(parentMatrix);
        }
    }

    private final ArrayList<SharedElementOriginalState> $$robo$$android_app_ActivityTransitionCoordinator$setSharedElementState(Bundle sharedElementState, ArrayList<View> snapshots) {
        ArrayList<SharedElementOriginalState> originalImageState = new ArrayList<SharedElementOriginalState>();
        if (sharedElementState != null) {
            Matrix tempMatrix = new Matrix();
            RectF tempRect = new RectF();
            int numSharedElements = this.mSharedElements.size();
            for (int i = 0; i < numSharedElements; ++i) {
                View sharedElement = this.mSharedElements.get(i);
                String name = this.mSharedElementNames.get(i);
                SharedElementOriginalState originalState = ActivityTransitionCoordinator.getOldSharedElementState(sharedElement, name, sharedElementState);
                originalImageState.add(originalState);
                this.setSharedElementState(sharedElement, name, sharedElementState, tempMatrix, tempRect, null);
            }
        }
        if (this.mListener != null) {
            this.mListener.onSharedElementStart(this.mSharedElementNames, this.mSharedElements, snapshots);
        }
        return originalImageState;
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$notifySharedElementEnd(ArrayList<View> snapshots) {
        if (this.mListener != null) {
            this.mListener.onSharedElementEnd(this.mSharedElementNames, this.mSharedElements, snapshots);
        }
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$scheduleSetSharedElementEnd(ArrayList<View> snapshots) {
        ViewGroup decorView = this.getDecor();
        if (decorView != null) {
            OneShotPreDrawListener.add(decorView, () -> this.notifySharedElementEnd(snapshots));
        }
    }

    private static final SharedElementOriginalState $$robo$$android_app_ActivityTransitionCoordinator$getOldSharedElementState(View view, String name, Bundle transitionArgs) {
        SharedElementOriginalState state = new SharedElementOriginalState();
        state.mLeft = view.getLeft();
        state.mTop = view.getTop();
        state.mRight = view.getRight();
        state.mBottom = view.getBottom();
        state.mMeasuredWidth = view.getMeasuredWidth();
        state.mMeasuredHeight = view.getMeasuredHeight();
        state.mTranslationZ = view.getTranslationZ();
        state.mElevation = view.getElevation();
        if (!(view instanceof ImageView)) {
            return state;
        }
        Bundle bundle = transitionArgs.getBundle(name);
        if (bundle == null) {
            return state;
        }
        int scaleTypeInt = bundle.getInt("shared_element:scaleType", -1);
        if (scaleTypeInt < 0) {
            return state;
        }
        ImageView imageView = (ImageView)view;
        state.mScaleType = imageView.getScaleType();
        if (state.mScaleType == ImageView.ScaleType.MATRIX) {
            state.mMatrix = new Matrix(imageView.getImageMatrix());
        }
        return state;
    }

    private final ArrayList<View> $$robo$$android_app_ActivityTransitionCoordinator$createSnapshots(Bundle state, Collection<String> names) {
        int numSharedElements = names.size();
        ArrayList<View> snapshots = new ArrayList<View>(numSharedElements);
        if (numSharedElements == 0) {
            return snapshots;
        }
        Context context = this.getWindow().getContext();
        int[] decorLoc = new int[2];
        ViewGroup decorView = this.getDecor();
        if (decorView != null) {
            decorView.getLocationOnScreen(decorLoc);
        }
        Matrix tempMatrix = new Matrix();
        for (String name : names) {
            Bundle sharedElementBundle = state.getBundle(name);
            View snapshot = null;
            if (sharedElementBundle != null) {
                Object parcelable = sharedElementBundle.getParcelable("shared_element:bitmap");
                if (parcelable != null && this.mListener != null) {
                    snapshot = this.mListener.onCreateSnapshotView(context, (Parcelable)parcelable);
                }
                if (snapshot != null) {
                    this.setSharedElementState(snapshot, name, state, tempMatrix, null, decorLoc);
                }
            }
            snapshots.add(snapshot);
        }
        return snapshots;
    }

    private static final void $$robo$$android_app_ActivityTransitionCoordinator$setOriginalSharedElementState(ArrayList<View> sharedElements, ArrayList<SharedElementOriginalState> originalState) {
        for (int i = 0; i < originalState.size(); ++i) {
            View view = sharedElements.get(i);
            SharedElementOriginalState state = originalState.get(i);
            if (view instanceof ImageView && state.mScaleType != null) {
                ImageView imageView = (ImageView)view;
                imageView.setScaleType(state.mScaleType);
                if (state.mScaleType == ImageView.ScaleType.MATRIX) {
                    imageView.setImageMatrix(state.mMatrix);
                }
            }
            view.setElevation(state.mElevation);
            view.setTranslationZ(state.mTranslationZ);
            int widthSpec = View.MeasureSpec.makeMeasureSpec(state.mMeasuredWidth, 0x40000000);
            int heightSpec = View.MeasureSpec.makeMeasureSpec(state.mMeasuredHeight, 0x40000000);
            view.measure(widthSpec, heightSpec);
            view.layout(state.mLeft, state.mTop, state.mRight, state.mBottom);
        }
    }

    private final Bundle $$robo$$android_app_ActivityTransitionCoordinator$captureSharedElementState() {
        Bundle bundle = new Bundle();
        RectF tempBounds = new RectF();
        Matrix tempMatrix = new Matrix();
        for (int i = 0; i < this.mSharedElements.size(); ++i) {
            View sharedElement = this.mSharedElements.get(i);
            String name = this.mSharedElementNames.get(i);
            this.captureSharedElementState(sharedElement, name, bundle, tempMatrix, tempBounds);
        }
        return bundle;
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$clearState() {
        this.mWindow = null;
        this.mSharedElements.clear();
        this.mTransitioningViews = null;
        this.mStrippedTransitioningViews = null;
        this.mOriginalAlphas.clear();
        this.mResultReceiver = null;
        this.mPendingTransition = null;
        this.mListener = null;
        this.mSharedElementParentMatrices = null;
    }

    private final long $$robo$$android_app_ActivityTransitionCoordinator$getFadeDuration() {
        return this.getWindow().getTransitionBackgroundFadeDuration();
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$hideViews(ArrayList<View> views) {
        int count = views.size();
        for (int i = 0; i < count; ++i) {
            View view = views.get(i);
            if (!this.mOriginalAlphas.containsKey(view)) {
                this.mOriginalAlphas.put(view, Float.valueOf(view.getAlpha()));
            }
            view.setAlpha(0.0f);
        }
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$showViews(ArrayList<View> views, boolean setTransitionAlpha) {
        int count = views.size();
        for (int i = 0; i < count; ++i) {
            this.showView(views.get(i), setTransitionAlpha);
        }
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$showView(View view, boolean setTransitionAlpha) {
        Float alpha = this.mOriginalAlphas.remove(view);
        if (alpha != null) {
            view.setAlpha(alpha.floatValue());
        }
        if (setTransitionAlpha) {
            view.setTransitionAlpha(1.0f);
        }
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$captureSharedElementState(View view, String name, Bundle transitionArgs, Matrix tempMatrix, RectF tempBounds) {
        Bundle sharedElementBundle = new Bundle();
        tempMatrix.reset();
        view.transformMatrixToGlobal(tempMatrix);
        tempBounds.set(0.0f, 0.0f, view.getWidth(), view.getHeight());
        tempMatrix.mapRect(tempBounds);
        sharedElementBundle.putFloat("shared_element:screenLeft", tempBounds.left);
        sharedElementBundle.putFloat("shared_element:screenRight", tempBounds.right);
        sharedElementBundle.putFloat("shared_element:screenTop", tempBounds.top);
        sharedElementBundle.putFloat("shared_element:screenBottom", tempBounds.bottom);
        sharedElementBundle.putFloat("shared_element:translationZ", view.getTranslationZ());
        sharedElementBundle.putFloat("shared_element:elevation", view.getElevation());
        Parcelable bitmap = null;
        if (this.mListener != null) {
            bitmap = this.mListener.onCaptureSharedElementSnapshot(view, tempMatrix, tempBounds);
        }
        if (bitmap != null) {
            sharedElementBundle.putParcelable("shared_element:bitmap", bitmap);
        }
        if (view instanceof ImageView) {
            ImageView imageView = (ImageView)view;
            int scaleTypeInt = ActivityTransitionCoordinator.scaleTypeToInt(imageView.getScaleType());
            sharedElementBundle.putInt("shared_element:scaleType", scaleTypeInt);
            if (imageView.getScaleType() == ImageView.ScaleType.MATRIX) {
                float[] matrix = new float[9];
                imageView.getImageMatrix().getValues(matrix);
                sharedElementBundle.putFloatArray("shared_element:imageMatrix", matrix);
            }
        }
        transitionArgs.putBundle(name, sharedElementBundle);
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$startTransition(Runnable runnable) {
        if (this.mIsStartingTransition) {
            this.mPendingTransition = runnable;
        } else {
            this.mIsStartingTransition = true;
            runnable.run();
        }
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$transitionStarted() {
        this.mIsStartingTransition = false;
    }

    private final boolean $$robo$$android_app_ActivityTransitionCoordinator$cancelPendingTransitions() {
        this.mPendingTransition = null;
        return this.mIsStartingTransition;
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$moveSharedElementsToOverlay() {
        if (this.mWindow == null || !this.mWindow.getSharedElementsUseOverlay()) {
            return;
        }
        this.setSharedElementMatrices();
        int numSharedElements = this.mSharedElements.size();
        ViewGroup decor = this.getDecor();
        if (decor != null) {
            boolean moveWithParent = this.moveSharedElementWithParent();
            Matrix tempMatrix = new Matrix();
            for (int i = 0; i < numSharedElements; ++i) {
                View view = this.mSharedElements.get(i);
                if (!view.isAttachedToWindow()) continue;
                tempMatrix.reset();
                this.mSharedElementParentMatrices.get(i).invert(tempMatrix);
                GhostView.addGhost(view, decor, tempMatrix);
                ViewGroup parent = (ViewGroup)view.getParent();
                if (!moveWithParent || ActivityTransitionCoordinator.isInTransitionGroup(parent, decor)) continue;
                GhostViewListeners listener = new GhostViewListeners(view, parent, decor);
                parent.getViewTreeObserver().addOnPreDrawListener(listener);
                parent.addOnAttachStateChangeListener(listener);
                this.mGhostViewListeners.add(listener);
            }
        }
    }

    private final boolean $$robo$$android_app_ActivityTransitionCoordinator$moveSharedElementWithParent() {
        return true;
    }

    private static final boolean $$robo$$android_app_ActivityTransitionCoordinator$isInTransitionGroup(ViewParent viewParent, ViewGroup decor) {
        if (viewParent == decor || !(viewParent instanceof ViewGroup)) {
            return false;
        }
        ViewGroup parent = (ViewGroup)viewParent;
        if (parent.isTransitionGroup()) {
            return true;
        }
        return ActivityTransitionCoordinator.isInTransitionGroup(parent.getParent(), decor);
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$moveSharedElementsFromOverlay() {
        int numListeners = this.mGhostViewListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            GhostViewListeners listener = this.mGhostViewListeners.get(i);
            listener.removeListener();
        }
        this.mGhostViewListeners.clear();
        if (this.mWindow == null || !this.mWindow.getSharedElementsUseOverlay()) {
            return;
        }
        ViewGroup decor = this.getDecor();
        if (decor != null) {
            ViewOverlay overlay = decor.getOverlay();
            int count = this.mSharedElements.size();
            for (int i = 0; i < count; ++i) {
                View sharedElement = this.mSharedElements.get(i);
                GhostView.removeGhost(sharedElement);
            }
        }
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$setGhostVisibility(int visibility) {
        int numSharedElements = this.mSharedElements.size();
        for (int i = 0; i < numSharedElements; ++i) {
            GhostView ghostView = GhostView.getGhost(this.mSharedElements.get(i));
            if (ghostView == null) continue;
            ghostView.setVisibility(visibility);
        }
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$scheduleGhostVisibilityChange(int visibility) {
        ViewGroup decorView = this.getDecor();
        if (decorView != null) {
            OneShotPreDrawListener.add(decorView, () -> this.setGhostVisibility(visibility));
        }
    }

    private final boolean $$robo$$android_app_ActivityTransitionCoordinator$isViewsTransitionComplete() {
        return this.mViewsTransitionComplete;
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$viewsTransitionComplete() {
        this.mViewsTransitionComplete = true;
        this.startInputWhenTransitionsComplete();
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$backgroundAnimatorComplete() {
        this.mBackgroundAnimatorComplete = true;
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$sharedElementTransitionComplete() {
        this.mSharedElementTransitionComplete = true;
        this.startInputWhenTransitionsComplete();
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$startInputWhenTransitionsComplete() {
        if (this.mViewsTransitionComplete && this.mSharedElementTransitionComplete) {
            ViewRootImpl viewRoot;
            ViewGroup decor = this.getDecor();
            if (decor != null && (viewRoot = decor.getViewRootImpl()) != null) {
                viewRoot.setPausedForTransition(false);
            }
            this.onTransitionsComplete();
        }
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$pauseInput() {
        ViewRootImpl viewRoot;
        ViewGroup decor = this.getDecor();
        ViewRootImpl viewRootImpl = viewRoot = decor == null ? null : decor.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.setPausedForTransition(true);
        }
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$onTransitionsComplete() {
    }

    private static final int $$robo$$android_app_ActivityTransitionCoordinator$scaleTypeToInt(ImageView.ScaleType scaleType) {
        for (int i = 0; i < SCALE_TYPE_VALUES.length; ++i) {
            if (scaleType != SCALE_TYPE_VALUES[i]) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_app_ActivityTransitionCoordinator$setTransitioningViewsVisiblity(int visiblity, boolean invalidate) {
        int numElements = this.mTransitioningViews == null ? 0 : this.mTransitioningViews.size();
        for (int i = 0; i < numElements; ++i) {
            View view = this.mTransitioningViews.get(i);
            if (invalidate) {
                view.setVisibility(visiblity);
                continue;
            }
            view.setTransitionVisibility(visiblity);
        }
    }

    private static final void $$robo$$android_app_ActivityTransitionCoordinator$noLayoutSuppressionForVisibilityTransitions(Transition transition2) {
        if (transition2 instanceof Visibility) {
            Visibility visibility = (Visibility)transition2;
            visibility.setSuppressLayout(false);
        } else if (transition2 instanceof TransitionSet) {
            TransitionSet set = (TransitionSet)transition2;
            int count = set.getTransitionCount();
            for (int i = 0; i < count; ++i) {
                ActivityTransitionCoordinator.noLayoutSuppressionForVisibilityTransitions(set.getTransitionAt(i));
            }
        }
    }

    private final boolean $$robo$$android_app_ActivityTransitionCoordinator$isTransitionRunning() {
        return !this.mViewsTransitionComplete || !this.mSharedElementTransitionComplete || !this.mBackgroundAnimatorComplete;
    }

    static void __staticInitializer__() {
        SCALE_TYPE_VALUES = ImageView.ScaleType.values();
    }

    private void __constructor__(Window window, ArrayList<String> arrayList, SharedElementCallback sharedElementCallback, boolean bl) {
        this.$$robo$$android_app_ActivityTransitionCoordinator$__constructor__(window, arrayList, sharedElementCallback, bl);
    }

    public ActivityTransitionCoordinator(Window window, ArrayList<String> arrayList, SharedElementCallback sharedElementCallback, boolean bl) {
        super(new Handler());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityTransitionCoordinator$__constructor__(android.view.Window java.util.ArrayList<java.lang.String> android.app.SharedElementCallback boolean ), this, window, arrayList, sharedElementCallback, bl);
    }

    protected void viewsReady(ArrayMap<String, View> arrayMap) {
        InvokeDynamicSupport.bootstrap("viewsReady", $$robo$$android_app_ActivityTransitionCoordinator$viewsReady(android.util.ArrayMap<java.lang.String, android.view.View> ), this, arrayMap);
    }

    private void setSharedElements(ArrayMap<String, View> arrayMap) {
        InvokeDynamicSupport.bootstrap("setSharedElements", $$robo$$android_app_ActivityTransitionCoordinator$setSharedElements(android.util.ArrayMap<java.lang.String, android.view.View> ), this, arrayMap);
    }

    private static boolean isNested(View view, ArrayMap<String, View> arrayMap) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNested", $$robo$$android_app_ActivityTransitionCoordinator$isNested(android.view.View android.util.ArrayMap<java.lang.String, android.view.View> ), (View)view, arrayMap);
    }

    protected void stripOffscreenViews() {
        InvokeDynamicSupport.bootstrap("stripOffscreenViews", $$robo$$android_app_ActivityTransitionCoordinator$stripOffscreenViews(), this);
    }

    protected Window getWindow() {
        return InvokeDynamicSupport.bootstrap("getWindow", $$robo$$android_app_ActivityTransitionCoordinator$getWindow(), this);
    }

    public ViewGroup getDecor() {
        return InvokeDynamicSupport.bootstrap("getDecor", $$robo$$android_app_ActivityTransitionCoordinator$getDecor(), this);
    }

    protected void setEpicenter() {
        InvokeDynamicSupport.bootstrap("setEpicenter", $$robo$$android_app_ActivityTransitionCoordinator$setEpicenter(), this);
    }

    private void setEpicenter(View view) {
        InvokeDynamicSupport.bootstrap("setEpicenter", $$robo$$android_app_ActivityTransitionCoordinator$setEpicenter(android.view.View ), this, view);
    }

    public ArrayList<String> getAcceptedNames() {
        return InvokeDynamicSupport.bootstrap("getAcceptedNames", $$robo$$android_app_ActivityTransitionCoordinator$getAcceptedNames(), this);
    }

    public ArrayList<String> getMappedNames() {
        return InvokeDynamicSupport.bootstrap("getMappedNames", $$robo$$android_app_ActivityTransitionCoordinator$getMappedNames(), this);
    }

    public ArrayList<View> copyMappedViews() {
        return InvokeDynamicSupport.bootstrap("copyMappedViews", $$robo$$android_app_ActivityTransitionCoordinator$copyMappedViews(), this);
    }

    public ArrayList<String> getAllSharedElementNames() {
        return InvokeDynamicSupport.bootstrap("getAllSharedElementNames", $$robo$$android_app_ActivityTransitionCoordinator$getAllSharedElementNames(), this);
    }

    protected Transition setTargets(Transition transition2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("setTargets", $$robo$$android_app_ActivityTransitionCoordinator$setTargets(android.transition.Transition boolean ), this, transition2, bl);
    }

    protected Transition configureTransition(Transition transition2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("configureTransition", $$robo$$android_app_ActivityTransitionCoordinator$configureTransition(android.transition.Transition boolean ), this, transition2, bl);
    }

    protected static void removeExcludedViews(Transition transition2, ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("removeExcludedViews", $$robo$$android_app_ActivityTransitionCoordinator$removeExcludedViews(android.transition.Transition java.util.ArrayList<android.view.View> ), (Transition)transition2, arrayList);
    }

    private static void findIncludedViews(Transition transition2, ArrayList<View> arrayList, ArraySet<View> arraySet) {
        InvokeDynamicSupport.bootstrapStatic("findIncludedViews", $$robo$$android_app_ActivityTransitionCoordinator$findIncludedViews(android.transition.Transition java.util.ArrayList<android.view.View> android.util.ArraySet<android.view.View> ), (Transition)transition2, arrayList, arraySet);
    }

    protected static Transition mergeTransitions(Transition transition2, Transition transition3) {
        return InvokeDynamicSupport.bootstrapStatic("mergeTransitions", $$robo$$android_app_ActivityTransitionCoordinator$mergeTransitions(android.transition.Transition android.transition.Transition ), (Transition)transition2, (Transition)transition3);
    }

    protected ArrayMap<String, View> mapSharedElements(ArrayList<String> arrayList, ArrayList<View> arrayList2) {
        return InvokeDynamicSupport.bootstrap("mapSharedElements", $$robo$$android_app_ActivityTransitionCoordinator$mapSharedElements(java.util.ArrayList<java.lang.String> java.util.ArrayList<android.view.View> ), this, arrayList, arrayList2);
    }

    protected void setResultReceiver(ResultReceiver resultReceiver) {
        InvokeDynamicSupport.bootstrap("setResultReceiver", $$robo$$android_app_ActivityTransitionCoordinator$setResultReceiver(android.os.ResultReceiver ), this, resultReceiver);
    }

    private void setSharedElementState(View view, String string2, Bundle bundle, Matrix matrix, RectF rectF, int[] nArray) {
        InvokeDynamicSupport.bootstrap("setSharedElementState", $$robo$$android_app_ActivityTransitionCoordinator$setSharedElementState(android.view.View java.lang.String android.os.Bundle android.graphics.Matrix android.graphics.RectF int[] ), this, view, string2, bundle, matrix, rectF, nArray);
    }

    private void setSharedElementMatrices() {
        InvokeDynamicSupport.bootstrap("setSharedElementMatrices", $$robo$$android_app_ActivityTransitionCoordinator$setSharedElementMatrices(), this);
    }

    private void getSharedElementParentMatrix(View view, Matrix matrix) {
        InvokeDynamicSupport.bootstrap("getSharedElementParentMatrix", $$robo$$android_app_ActivityTransitionCoordinator$getSharedElementParentMatrix(android.view.View android.graphics.Matrix ), this, view, matrix);
    }

    protected ArrayList<SharedElementOriginalState> setSharedElementState(Bundle bundle, ArrayList<View> arrayList) {
        return InvokeDynamicSupport.bootstrap("setSharedElementState", $$robo$$android_app_ActivityTransitionCoordinator$setSharedElementState(android.os.Bundle java.util.ArrayList<android.view.View> ), this, bundle, arrayList);
    }

    protected void notifySharedElementEnd(ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrap("notifySharedElementEnd", $$robo$$android_app_ActivityTransitionCoordinator$notifySharedElementEnd(java.util.ArrayList<android.view.View> ), this, arrayList);
    }

    protected void scheduleSetSharedElementEnd(ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrap("scheduleSetSharedElementEnd", $$robo$$android_app_ActivityTransitionCoordinator$scheduleSetSharedElementEnd(java.util.ArrayList<android.view.View> ), this, arrayList);
    }

    private static SharedElementOriginalState getOldSharedElementState(View view, String string2, Bundle bundle) {
        return InvokeDynamicSupport.bootstrapStatic("getOldSharedElementState", $$robo$$android_app_ActivityTransitionCoordinator$getOldSharedElementState(android.view.View java.lang.String android.os.Bundle ), (View)view, (String)string2, (Bundle)bundle);
    }

    protected ArrayList<View> createSnapshots(Bundle bundle, Collection<String> collection) {
        return InvokeDynamicSupport.bootstrap("createSnapshots", $$robo$$android_app_ActivityTransitionCoordinator$createSnapshots(android.os.Bundle java.util.Collection<java.lang.String> ), this, bundle, collection);
    }

    protected static void setOriginalSharedElementState(ArrayList<View> arrayList, ArrayList<SharedElementOriginalState> arrayList2) {
        InvokeDynamicSupport.bootstrapStatic("setOriginalSharedElementState", $$robo$$android_app_ActivityTransitionCoordinator$setOriginalSharedElementState(java.util.ArrayList<android.view.View> java.util.ArrayList<android.app.ActivityTransitionCoordinator$SharedElementOriginalState> ), arrayList, arrayList2);
    }

    protected Bundle captureSharedElementState() {
        return InvokeDynamicSupport.bootstrap("captureSharedElementState", $$robo$$android_app_ActivityTransitionCoordinator$captureSharedElementState(), this);
    }

    protected void clearState() {
        InvokeDynamicSupport.bootstrap("clearState", $$robo$$android_app_ActivityTransitionCoordinator$clearState(), this);
    }

    protected long getFadeDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getFadeDuration", $$robo$$android_app_ActivityTransitionCoordinator$getFadeDuration(), this);
    }

    protected void hideViews(ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrap("hideViews", $$robo$$android_app_ActivityTransitionCoordinator$hideViews(java.util.ArrayList<android.view.View> ), this, arrayList);
    }

    protected void showViews(ArrayList<View> arrayList, boolean bl) {
        InvokeDynamicSupport.bootstrap("showViews", $$robo$$android_app_ActivityTransitionCoordinator$showViews(java.util.ArrayList<android.view.View> boolean ), this, arrayList, bl);
    }

    private void showView(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("showView", $$robo$$android_app_ActivityTransitionCoordinator$showView(android.view.View boolean ), this, view, bl);
    }

    protected void captureSharedElementState(View view, String string2, Bundle bundle, Matrix matrix, RectF rectF) {
        InvokeDynamicSupport.bootstrap("captureSharedElementState", $$robo$$android_app_ActivityTransitionCoordinator$captureSharedElementState(android.view.View java.lang.String android.os.Bundle android.graphics.Matrix android.graphics.RectF ), this, view, string2, bundle, matrix, rectF);
    }

    protected void startTransition(Runnable runnable) {
        InvokeDynamicSupport.bootstrap("startTransition", $$robo$$android_app_ActivityTransitionCoordinator$startTransition(java.lang.Runnable ), this, runnable);
    }

    protected void transitionStarted() {
        InvokeDynamicSupport.bootstrap("transitionStarted", $$robo$$android_app_ActivityTransitionCoordinator$transitionStarted(), this);
    }

    protected boolean cancelPendingTransitions() {
        return (boolean)InvokeDynamicSupport.bootstrap("cancelPendingTransitions", $$robo$$android_app_ActivityTransitionCoordinator$cancelPendingTransitions(), this);
    }

    protected void moveSharedElementsToOverlay() {
        InvokeDynamicSupport.bootstrap("moveSharedElementsToOverlay", $$robo$$android_app_ActivityTransitionCoordinator$moveSharedElementsToOverlay(), this);
    }

    protected boolean moveSharedElementWithParent() {
        return (boolean)InvokeDynamicSupport.bootstrap("moveSharedElementWithParent", $$robo$$android_app_ActivityTransitionCoordinator$moveSharedElementWithParent(), this);
    }

    public static boolean isInTransitionGroup(ViewParent viewParent, ViewGroup viewGroup) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInTransitionGroup", $$robo$$android_app_ActivityTransitionCoordinator$isInTransitionGroup(android.view.ViewParent android.view.ViewGroup ), (ViewParent)viewParent, (ViewGroup)viewGroup);
    }

    protected void moveSharedElementsFromOverlay() {
        InvokeDynamicSupport.bootstrap("moveSharedElementsFromOverlay", $$robo$$android_app_ActivityTransitionCoordinator$moveSharedElementsFromOverlay(), this);
    }

    protected void setGhostVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setGhostVisibility", $$robo$$android_app_ActivityTransitionCoordinator$setGhostVisibility(int ), this, n);
    }

    protected void scheduleGhostVisibilityChange(int n) {
        InvokeDynamicSupport.bootstrap("scheduleGhostVisibilityChange", $$robo$$android_app_ActivityTransitionCoordinator$scheduleGhostVisibilityChange(int ), this, n);
    }

    protected boolean isViewsTransitionComplete() {
        return (boolean)InvokeDynamicSupport.bootstrap("isViewsTransitionComplete", $$robo$$android_app_ActivityTransitionCoordinator$isViewsTransitionComplete(), this);
    }

    protected void viewsTransitionComplete() {
        InvokeDynamicSupport.bootstrap("viewsTransitionComplete", $$robo$$android_app_ActivityTransitionCoordinator$viewsTransitionComplete(), this);
    }

    protected void backgroundAnimatorComplete() {
        InvokeDynamicSupport.bootstrap("backgroundAnimatorComplete", $$robo$$android_app_ActivityTransitionCoordinator$backgroundAnimatorComplete(), this);
    }

    protected void sharedElementTransitionComplete() {
        InvokeDynamicSupport.bootstrap("sharedElementTransitionComplete", $$robo$$android_app_ActivityTransitionCoordinator$sharedElementTransitionComplete(), this);
    }

    private void startInputWhenTransitionsComplete() {
        InvokeDynamicSupport.bootstrap("startInputWhenTransitionsComplete", $$robo$$android_app_ActivityTransitionCoordinator$startInputWhenTransitionsComplete(), this);
    }

    protected void pauseInput() {
        InvokeDynamicSupport.bootstrap("pauseInput", $$robo$$android_app_ActivityTransitionCoordinator$pauseInput(), this);
    }

    protected void onTransitionsComplete() {
        InvokeDynamicSupport.bootstrap("onTransitionsComplete", $$robo$$android_app_ActivityTransitionCoordinator$onTransitionsComplete(), this);
    }

    private static int scaleTypeToInt(ImageView.ScaleType scaleType) {
        return (int)InvokeDynamicSupport.bootstrapStatic("scaleTypeToInt", $$robo$$android_app_ActivityTransitionCoordinator$scaleTypeToInt(android.widget.ImageView$ScaleType ), (ImageView.ScaleType)scaleType);
    }

    protected void setTransitioningViewsVisiblity(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setTransitioningViewsVisiblity", $$robo$$android_app_ActivityTransitionCoordinator$setTransitioningViewsVisiblity(int boolean ), this, n, bl);
    }

    private static void noLayoutSuppressionForVisibilityTransitions(Transition transition2) {
        InvokeDynamicSupport.bootstrapStatic("noLayoutSuppressionForVisibilityTransitions", $$robo$$android_app_ActivityTransitionCoordinator$noLayoutSuppressionForVisibilityTransitions(android.transition.Transition ), (Transition)transition2);
    }

    public boolean isTransitionRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTransitionRunning", $$robo$$android_app_ActivityTransitionCoordinator$isTransitionRunning(), this);
    }

    static {
        RobolectricInternals.classInitializing(ActivityTransitionCoordinator.class);
    }

    public /* synthetic */ ActivityTransitionCoordinator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityTransitionCoordinator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SharedElementOriginalState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mLeft;
        int mTop;
        int mRight;
        int mBottom;
        int mMeasuredWidth;
        int mMeasuredHeight;
        ImageView.ScaleType mScaleType;
        Matrix mMatrix;
        float mTranslationZ;
        float mElevation;

        private void $$robo$$android_app_ActivityTransitionCoordinator_SharedElementOriginalState$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityTransitionCoordinator_SharedElementOriginalState$__constructor__();
        }

        public SharedElementOriginalState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityTransitionCoordinator_SharedElementOriginalState$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SharedElementOriginalState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class GhostViewListeners
    implements ViewTreeObserver.OnPreDrawListener,
    View.OnAttachStateChangeListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private View mView;
        private ViewGroup mDecor;
        private View mParent;
        private Matrix mMatrix;
        private ViewTreeObserver mViewTreeObserver;

        private void $$robo$$android_app_ActivityTransitionCoordinator_GhostViewListeners$__constructor__(View view, View parent, ViewGroup decor) {
            this.mMatrix = new Matrix();
            this.mView = view;
            this.mParent = parent;
            this.mDecor = decor;
            this.mViewTreeObserver = parent.getViewTreeObserver();
        }

        private final View $$robo$$android_app_ActivityTransitionCoordinator_GhostViewListeners$getView() {
            return this.mView;
        }

        private final boolean $$robo$$android_app_ActivityTransitionCoordinator_GhostViewListeners$onPreDraw() {
            GhostView ghostView = GhostView.getGhost(this.mView);
            if (ghostView == null || !this.mView.isAttachedToWindow()) {
                this.removeListener();
            } else {
                GhostView.calculateMatrix(this.mView, this.mDecor, this.mMatrix);
                ghostView.setMatrix(this.mMatrix);
            }
            return true;
        }

        private final void $$robo$$android_app_ActivityTransitionCoordinator_GhostViewListeners$removeListener() {
            if (this.mViewTreeObserver.isAlive()) {
                this.mViewTreeObserver.removeOnPreDrawListener(this);
            } else {
                this.mParent.getViewTreeObserver().removeOnPreDrawListener(this);
            }
            this.mParent.removeOnAttachStateChangeListener(this);
        }

        private final void $$robo$$android_app_ActivityTransitionCoordinator_GhostViewListeners$onViewAttachedToWindow(View v) {
            this.mViewTreeObserver = v.getViewTreeObserver();
        }

        private final void $$robo$$android_app_ActivityTransitionCoordinator_GhostViewListeners$onViewDetachedFromWindow(View v) {
            this.removeListener();
        }

        private void __constructor__(View view, View view2, ViewGroup viewGroup) {
            this.$$robo$$android_app_ActivityTransitionCoordinator_GhostViewListeners$__constructor__(view, view2, viewGroup);
        }

        public GhostViewListeners(View view, View view2, ViewGroup viewGroup) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityTransitionCoordinator_GhostViewListeners$__constructor__(android.view.View android.view.View android.view.ViewGroup ), this, view, view2, viewGroup);
        }

        public View getView() {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_app_ActivityTransitionCoordinator_GhostViewListeners$getView(), this);
        }

        @Override
        public boolean onPreDraw() {
            return (boolean)InvokeDynamicSupport.bootstrap("onPreDraw", $$robo$$android_app_ActivityTransitionCoordinator_GhostViewListeners$onPreDraw(), this);
        }

        public void removeListener() {
            InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_app_ActivityTransitionCoordinator_GhostViewListeners$removeListener(), this);
        }

        @Override
        public void onViewAttachedToWindow(View view) {
            InvokeDynamicSupport.bootstrap("onViewAttachedToWindow", $$robo$$android_app_ActivityTransitionCoordinator_GhostViewListeners$onViewAttachedToWindow(android.view.View ), this, view);
        }

        @Override
        public void onViewDetachedFromWindow(View view) {
            InvokeDynamicSupport.bootstrap("onViewDetachedFromWindow", $$robo$$android_app_ActivityTransitionCoordinator_GhostViewListeners$onViewDetachedFromWindow(android.view.View ), this, view);
        }

        public /* synthetic */ GhostViewListeners() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GhostViewListeners)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class FixedEpicenterCallback
    extends Transition.EpicenterCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Rect mEpicenter;

        private void $$robo$$android_app_ActivityTransitionCoordinator_FixedEpicenterCallback$__constructor__() {
        }

        private final void $$robo$$android_app_ActivityTransitionCoordinator_FixedEpicenterCallback$setEpicenter(Rect epicenter) {
            this.mEpicenter = epicenter;
        }

        private final Rect $$robo$$android_app_ActivityTransitionCoordinator_FixedEpicenterCallback$onGetEpicenter(Transition transition2) {
            return this.mEpicenter;
        }

        private /* synthetic */ void $$robo$$android_app_ActivityTransitionCoordinator_FixedEpicenterCallback$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityTransitionCoordinator_FixedEpicenterCallback$__constructor__();
        }

        public FixedEpicenterCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityTransitionCoordinator_FixedEpicenterCallback$__constructor__(), this);
        }

        public void setEpicenter(Rect rect) {
            InvokeDynamicSupport.bootstrap("setEpicenter", $$robo$$android_app_ActivityTransitionCoordinator_FixedEpicenterCallback$setEpicenter(android.graphics.Rect ), this, rect);
        }

        @Override
        public Rect onGetEpicenter(Transition transition2) {
            return InvokeDynamicSupport.bootstrap("onGetEpicenter", $$robo$$android_app_ActivityTransitionCoordinator_FixedEpicenterCallback$onGetEpicenter(android.transition.Transition ), this, transition2);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_app_ActivityTransitionCoordinator_FixedEpicenterCallback$__constructor__(var1_1);
        }

        public /* synthetic */ FixedEpicenterCallback(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityTransitionCoordinator_FixedEpicenterCallback$__constructor__(android.app.ActivityTransitionCoordinator$1 ), this, var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FixedEpicenterCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected class ContinueTransitionListener
    extends TransitionListenerAdapter
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ActivityTransitionCoordinator this$0;

        private void $$robo$$android_app_ActivityTransitionCoordinator_ContinueTransitionListener$__constructor__(ActivityTransitionCoordinator this$0) {
            this.this$0 = this$0;
        }

        private final void $$robo$$android_app_ActivityTransitionCoordinator_ContinueTransitionListener$onTransitionStart(Transition transition2) {
            this.this$0.mIsStartingTransition = false;
            Runnable pending = this.this$0.mPendingTransition;
            this.this$0.mPendingTransition = null;
            if (pending != null) {
                this.this$0.startTransition(pending);
            }
        }

        private final void $$robo$$android_app_ActivityTransitionCoordinator_ContinueTransitionListener$onTransitionEnd(Transition transition2) {
            transition2.removeListener(this);
        }

        private void __constructor__(ActivityTransitionCoordinator activityTransitionCoordinator) {
            this.$$robo$$android_app_ActivityTransitionCoordinator_ContinueTransitionListener$__constructor__(activityTransitionCoordinator);
        }

        public ContinueTransitionListener(ActivityTransitionCoordinator activityTransitionCoordinator) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityTransitionCoordinator_ContinueTransitionListener$__constructor__(android.app.ActivityTransitionCoordinator ), this, activityTransitionCoordinator);
        }

        @Override
        public void onTransitionStart(Transition transition2) {
            InvokeDynamicSupport.bootstrap("onTransitionStart", $$robo$$android_app_ActivityTransitionCoordinator_ContinueTransitionListener$onTransitionStart(android.transition.Transition ), this, transition2);
        }

        @Override
        public void onTransitionEnd(Transition transition2) {
            InvokeDynamicSupport.bootstrap("onTransitionEnd", $$robo$$android_app_ActivityTransitionCoordinator_ContinueTransitionListener$onTransitionEnd(android.transition.Transition ), this, transition2);
        }

        public /* synthetic */ ContinueTransitionListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContinueTransitionListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

